//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCVSSOCKET_H
#define WSCVSSOCKET_H

#include <WScom.h>
#include <WSCngbase.h>
#define WSCvssocket_VER  1000
#include <WSDsocket.h>

class WSCvssocket   :public WSCngbase{
  protected:
    WSDsocket*  _socket;
    char*     _addr;
    WSCushort _port; 
    WSCulong _timeout; 
    WSCbool _on; 
    void* _handle;
    WSCstring _error_str;

    WSMFpropertyDef(WSNip,        char*,      _addr);
    WSMFpropertyDef(WSNport,      WSCushort,      _port);
    WSMFpropertyDef(WSNtimeout,   WSCulong,      _timeout);
    WSMFpropertyDef(WSNrunning,   WSCbool,      _on);

WSDLEX32 static void _accepted_work(WSDsocket*,void*,WSCulong);
  public:

    WSDLEX32 WSCvssocket(WSCbase* base, char* name);
    WSDLEX32 virtual ~WSCvssocket();
    WSDLEX32 virtual void onActivate();

    WSDLEX32 long read(WSCuchar* buf,long size);
    WSDLEX32 long write(WSCuchar* buf,long size);

    WSDLEX32 WSCstring getDestAddr();
    WSDLEX32 WSDsocket* getSocket();

    WSDLEX32 void getErrorMsg(char* buffer,long size);
    WSDLEX32 WSCstring getErrorMessage();

    WSMFguiClassDef(WSCvssocket,WSCngbase);
    WSMFversionDef(WSCvssocket);
};

#endif //WSCVSSOCKET_H
