//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCVTGLBTN_H
#define WSCVTGLBTN_H

#include <WScom.h>
#include <WSCvlabel.h>
#define WSCvtoggle_VER  1000

class WSDkeyboard;
class WSClistData;

class WSCvtoggle :public WSCvlabel{

  private:
  protected:
    char*     _select_string;
    char*     _group_name;
    char*     _td_name;
    char*     _bd_name;
    char*     _ld_name;
    char*     _rd_name;
    char*     _tb_name;
    char*     _btb_name;
    char*     _sc_str;
    short     _indicator_color;
    short     _select_color;
    short     _indicator_pixmap;
    short     _select_pixmap;
    short     _id;
    unsigned  _indicator_size:6;
    unsigned  _indicator_type:2;
    unsigned  _indicator_shadow_thick:4;
    unsigned  _indicator_on:1;
    unsigned  _enable_focus_move:1;
    unsigned  _unique:1;
    unsigned  _select_reset:1;
    unsigned  _press_status:1;
    unsigned  _toggle_status:1;
    unsigned  _return_key_focus:1;
    unsigned  _alt_focus_registered:1;

    WSMFpropertyDef(WSNselectString,    char*,   _select_string  );
    WSMFpropertyDef(WSNindicatorOn,     WSCbool, _indicator_on   );
    WSMFpropertyDef(WSNindicatorType,   WSCuchar, _indicator_type   );
    WSMFpropertyDef(WSNindicatorSize,   WSCuchar, _indicator_size   );
    WSMFpropertyDef(WSNindicatorShadow, WSCuchar, _indicator_shadow_thick );
    WSMFpropertyDef(WSNindicatorColor,  short,  _indicator_color );
    WSMFpropertyDef(WSNindicatorPixmap, short,  _indicator_pixmap );
    WSMFpropertyDef(WSNselectColor,     short,  _select_color );
    WSMFpropertyDef(WSNselectPixmap,    short,  _select_pixmap );
    WSMFpropertyDef(WSNunique,          WSCbool,   _unique       );
    WSMFpropertyDef(WSNgroup,           char*,     _group_name   );
    WSMFpropertyDef(WSNid,              short,     _id           );
    WSMFpropertyDef(WSNselectReset,     WSCbool,   _select_reset  );
    WSMFpropertyDef(WSNenableFocusMove, WSCbool,   _enable_focus_move);
    WSMFpropertyDef(WSNupward,     char*,    _td_name);
    WSMFpropertyDef(WSNdownward,  char*,     _bd_name);
    WSMFpropertyDef(WSNleftward,   char*,    _ld_name);
    WSMFpropertyDef(WSNrightward,   char*,   _rd_name);
    WSMFpropertyDef(WSNtab,   char*,   _tb_name);
    WSMFpropertyDef(WSNbacktab,   char*,   _btb_name);
    WSMFpropertyDef(WSNstatus,   WSCbool,   _toggle_status);
    WSMFpropertyDef(WSNreturnKeyFocus,   WSCbool, _return_key_focus);
    WSMFpropertyDef(WSNshortcut,  char*,  _sc_str);

    WSDLEX32 virtual long _device_initialize();

    WSDLEX32 static WSClistData* _tgl_list;
    WSDLEX32 static WSClistData* _get_toggle_list();
    WSDLEX32 static void _key_handler(void*,WSDkeyboard*,WSCbool);

WSDLEX32 static void      (*_ext_draw_proc)(void*);
WSDLEX32 static char* _policy_name;
    WSDLEX32 long _set_status(WSCbool state,WSCbool create_event = True);
    WSDLEX32 void _status_move(WSCbase* target);
    WSDLEX32 void _extra_focus_move(long direct);
  public:
    WSDLEX32 WSCvtoggle(WSCbase*,char*);
    WSDLEX32 virtual ~WSCvtoggle();

    WSDLEX32 virtual void onMousePress(WSCpoint*);
    WSDLEX32 virtual void onMouseRelease(WSCpoint*);
    WSDLEX32 virtual void onMouseOut();
    WSDLEX32 virtual void onValueChange(WSCbool);
    WSDLEX32 virtual void onSensitiveChange(WSCbool);
    WSDLEX32 virtual void onKey(WSDkeyboard*,WSCbool);
    WSDLEX32 virtual void onFocusChange(WSCbool);
    WSDLEX32 virtual void onGuiPolicyChange(long);

    WSDLEX32 virtual long addProcedure(WSCprocedure*);
    WSDLEX32 virtual long draw();
    WSDLEX32 long setStatus(WSCbool state,WSCbool create_event = True);
    WSDLEX32 WSCbool getStatus();
    WSDLEX32 long getGroupValue();
    WSDLEX32 long setGroupValue(long);
    WSDLEX32 long clearGroupValue();
    WSDLEX32 virtual long execEventProc(long,void*);

    WSMFguiClassDef(WSCvtoggle,WSCvlabel);
    WSMFversionDef(WSCvtoggle);
};

struct WSCvtoggle_draw_struct{
  WSCvtoggle* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  long blinking;
  long blink_fore;
  long shadow_type;
  long blink_type;
  long twin_blink;
  short fore_color;
  short back_color;
  short blink_color;
  short select_color;
  short back_blink_color;
  short top_shadow_color;
  short bottom_shadow_color;
  char* label_string;
  char* select_string;
  char* shortcut_string;
  short label_pixmap;
  short blink_pixmap;
  short select_pixmap;
  short press_status;
  long  orientation;
#ifndef NO_GRADATION
  long  gradation;
  long  gradation_margin;
#endif
  long  margin_left;
  long  margin_right;
  long  margin_top;
  long  margin_bottom;
  WSCbool  emboss;
  WSCuchar font;
  WSCbool  reverse_flag;
  WSCbool  enable_focus_move;
  WSCbool  toggle_status;
  WSCbool  unique;
  WSCbool  select_reset;
  WSCuchar indicator_size;
  WSCuchar indicator_type;
  WSCuchar indicator_shadow_thickness;
  WSCbool  indicator_on;
  short indicator_pixmap;
  short indicator_color;
};

#endif
