//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCWORKINGDIALOG_H
#define WSCWORKINGDIALOG_H

#include <WScom.h>
#include <WSCbaseDialog.h>

class WSCvifield;
class WSCvlabel;
class WSCvmeter;

#define WSCworkingDialog_VER 1001

class WSCworkingDialog :public WSCbaseDialog{

  protected:
    WSCform*     _area1;
    WSCform*     _form;
    WSCvmeter*   _meter;
    WSCvlabel*   _title;
    WSCvlabel*   _value_label;
    char* _label_string;
    short     _wbg_no;
    WSCushort     _value;
    WSCushort _lw;
    short   _hatch_color;
    unsigned  _hatch_pattern:4;
    unsigned  _lt:4;
    unsigned  _stippled:1;

    WSMFpropertyDef(WSNlineWidth, WSCushort, _lw);
    WSMFpropertyDef(WSNlineType,  WSCuchar,      _lt);
    WSMFpropertyDef(WSNstippled,        WSCbool, _stippled         );
    WSMFpropertyDef(WSNhatchPattern,    WSCuchar, _hatch_pattern    );
    WSMFpropertyDef(WSNhatchColor,      short,   _hatch_color      );


    WSMFpropertyDef( WSNlabelString,   char*,   _label_string ); 
    WSMFpropertyDef( WSNworkBackColor,  short,      _wbg_no );
    WSMFpropertyDef( WSNvalue,  WSCushort,      _value );
    WSDLEX32 virtual void setWorkWSNforeColor(short);

  public:
    WSDLEX32 WSCworkingDialog(WSCbase*,char*);
    WSDLEX32 virtual ~WSCworkingDialog();

    WSDLEX32 virtual  long initialize();
    WSDLEX32 virtual void adjustForm();

//    virtual void onResize(WSCrect* rect);
    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onGuiPolicyChange(long);

    WSDLEX32 virtual  long popup();
    WSDLEX32 virtual  void update();
    WSDLEX32 virtual  void setValue(WSCushort value);
    WSDLEX32 virtual char* getDefaultProperty();


    WSMFguiClassDef(WSCworkingDialog,WSCbaseDialog);
    WSMFversionDef(WSCworkingDialog);
};
#endif
