//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDIMAGE_H
#define WSDIMAGE_H

#include <WScom.h>
#include <WSDres.h>

class WSDimage :public WSDres{

  protected:
    WSCushort  _w;
    WSCushort  _h;
    WSCulong       _mode;
  public:
    WSDLEX32 WSDimage();
    WSDLEX32 virtual ~WSDimage();
    WSDLEX32 long destroyImage();

    WSDLEX32 long setImageName(char* iname); 
    WSDLEX32 long setImageWidth(WSCushort );
    WSDLEX32 long setImageHeight(WSCushort );

    WSDLEX32 WSCushort getImageWidth();
    WSDLEX32 WSCushort getImageHeight();
    WSDLEX32 WSCbool   getReady();
    WSDLEX32 void   setImageMode(WSCulong);
    WSDLEX32 WSCulong   getImageMode();

    WSMFclassDef(WSDimage,WSDres);
};
#define WS_IMAGE_MODE_REUSE_MEM 0x00000001

#endif //WSDIMAGE_H
