//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDMESSAGE_H
#define WSDMESSAGE_H

#include <WScom.h>
#include <WSCbase.h>
#include <WSCstring.h>

#define  WS_TRANS_MESSAGE "WSatom"

class WSDmessage :public WSCroot{

  protected:
    WSCstring _id;
    void*     _data;

    void      (*_exec_action)(char *);
    void      (*_exec_action2)(char *,void*);

    static int (*_ext_send_msg1)(char* disp,char *message,char *data);
    static int (*_ext_send_msg2)(char* disp,char *message,char* data);
    WSDLEX32 static WSDmessage* (*_chandler)();
    WSDLEX32 virtual long initialize();
  public:
    WSDLEX32 static void _setup_ext_send_msg_proc(void* fn1,void* fn2);

    WSDLEX32 void setupMessage(char *,void (*cbwork)(char *));
    WSDLEX32 void setupMessage(char *,void (*cbwork)(char *,void*),void*);

    WSDLEX32 virtual void sendMessage(char *data);
    WSDLEX32 static int sendMessageEx(char* disp,char *message,char *data);

    WSDLEX32 static int extSendMessage(char* disp,char *message,char *data);
    WSDLEX32 static int extSendNewMessage(char* disp,char *message,char *data);

    WSDLEX32 static WSDmessage* getNewInstance();
    WSDLEX32 static void setCreateHandler(WSDmessage*(*)());

    WSMFclassDef(WSDmessage, WSCroot) ;
};
#endif
