//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDPRDEV_H
#define WSDPRDEV_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSDdev.h>
#include <WSClistData.h>
#include <WSDfile.h>

class WSDprDev :public WSDdev{

 protected:
  WSDfile* _file;
  short _work_x;
  short _work_y;
  WSCushort _work_width;
  WSCushort _work_height;
  unsigned  _format:4;
  unsigned  _type:2;
  unsigned  _orientation:1;
  
  
 public:
  WSDLEX32 WSDprDev();

  WSDLEX32 virtual long    initialize();
  WSDLEX32 virtual long    beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool absolute,WSCbool scaling = True);
  WSDLEX32 virtual long    endDraw();
  WSDLEX32 virtual long  setValue(long kind,void* data);
  WSDLEX32 virtual long  getValue(long kind, void* value);
  WSDLEX32 virtual WSCbool getReady();
  WSDLEX32 virtual long getExposedArea(short* x,short* y,WSCushort* w,WSCushort* h,WSCbool scaling = True);
  WSDLEX32 void setFile(WSDfile*);
  WSDLEX32 virtual WSCbool isExposed(short,short,WSCushort,WSCushort,WSCbool scaling = True);

  WSDLEX32 virtual long getDeviceResource();
  WSDLEX32 virtual long getWindowResource();
  WSDLEX32 virtual long getContextResource();
  WSDLEX32 virtual long getSpecialResource();


  WSMFclassDef(WSDprDev,WSDdev);
};
#endif
