//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCINSPECTOR_H
#define WSCINSPECTOR_H

#include <WScom.h>
#include <WSCsform.h>
#include <WSClistData.h>

#define WSCinspector_VER 1000
class WSCindexForm;
class WSCpropertyEditor;
class WSClist;
class WSCprocedureEditor;
class WSCwindowEditor;
class WSCpopupMenu;
class WSCfform;
class WSCdirTree;


class WSCinspector :public WSCsform{

  protected:
    WSClist*           _list;
    WSCindexForm*      _area2;
    WSCpropertyEditor* _prope;
    WSClistData*       _target_list;
    WSCprocedureEditor* _ope;
    WSCwindowEditor*    _we;
    WSCpopupMenu*       _pmenu;
    WSCpopupMenu*       _pmenu2;
    WSClist*           _list2;
    WSClistData        _pname;
    WSClistData        _procs;
    WSClistData*       _selected;
    WSCbase*           _pmenu_client;
    WSClist*           _file_list;
    WSCfform*          _fform;
    WSCfform*          _ifform;
    WSCfform*          _dfform;
    WSCdirTree*        _dir_tree;
    WSCsform*          _sform;
    WSCsform*          _sform2;
    WSCfform*          _mfform;
    WSCbase*           _pform;
    WSCfform*          _cfform;
    WSClist*           _class_list;
    
    char*              _pos_bk;
    void  (*_load_project_fn)(WSCinspector*,char*);

    void (*_search_proc)(WSCbase*);
    void (*_copy_proc)(WSCbase*);
    void (*_paste_proc)(WSCbase*);
    void (*_editor_proc)(WSCprocedureEditor*,char*);
    char* (*_get_ext_files_proc)();
    WSCulong           _value;
    WSDLEX32 void _adjust_work();

    WSDLEX32 virtual void setWorkWSNwidth(WSCushort);
    WSDLEX32 virtual void setWorkWSNheight(WSCushort);
    WSDLEX32 virtual void setWorkWSNshadowThickness(WSCuchar);
    WSDLEX32 virtual void setWorkWSNbarValue(char*);
    WSDLEX32 virtual void getWorkWSNbarValue(char**);
  
    WSDLEX32 virtual void onResize(WSCrect* rect);

    WSDLEX32 WSCbase* _search_inst_work(char* name,WSCbase*);
    WSDLEX32 static void _area2_work(WSCbase*);
    WSDLEX32 static void _pe_select_work(WSCbase*);
    WSDLEX32 static void _prope_activate_work(WSCbase*);
    WSDLEX32 static void _lb_press_work(WSCbase*);
    WSDLEX32 static void _lb_activate_work(WSCbase*);
    WSDLEX32 static void _flb_activate_work(WSCbase*);
    WSDLEX32 static void _lb_activate2_work(WSCbase*);
    WSDLEX32 static void _popup_ch_work(WSCbase*);
    WSDLEX32 static void _file_list_vis_work(WSCbase*);
    WSDLEX32 static void _flb_press_work(WSCbase*);
    WSDLEX32 static void _float_work(WSCbase*);
    WSDLEX32 static void _float_work2(WSCbase*);
    WSDLEX32 static void _float_work3(WSCbase*);
    WSDLEX32 static void _float_work4(WSCbase*);
    WSDLEX32 static void _float_work5(WSCbase*);
    WSDLEX32 static void _float_vis_work(WSCbase*);
    WSDLEX32 static void _float_vis_work2(WSCbase*);
    WSDLEX32 static void _float_vis_work3(WSCbase*);
    WSDLEX32 static void _file_selected_work(WSCbase*);

    WSDLEX32 static void _prj_work(WSCbase*);
    WSDLEX32 static void _cmpl_work(WSCbase*);
    WSDLEX32 static void _save_work(WSCbase*);
    WSDLEX32 static void _disp_work(WSCbase*);
    WSDLEX32 static void _search_work(WSCbase*);
    WSDLEX32 static void _copy_work(WSCbase*);
    WSDLEX32 static void _paste_work(WSCbase*);
    WSDLEX32 static void _del_work(WSCbase*);

    WSDLEX32 void _set_list_work(WSCbase*,long);
    WSDLEX32 void _set_file_list_work(WSCbase*);
    WSDLEX32 void _update_lb();
    void (*_getproc(char*))(WSCbase*);
    WSDLEX32 virtual WSCbase* getPropertyInheritChild();
    WSDLEX32 void _adjust_forms();
    WSMFpropertyDef(WSNvalue,     WSCulong, _value);


  public:
    WSDLEX32 WSCinspector(WSCbase*,char*);
    WSDLEX32 virtual ~WSCinspector();
    WSDLEX32 virtual  long initialize();
    WSDLEX32 virtual void onGuiPolicyChanged(long);

    WSDLEX32 WSCbase* getPropertyEditor();
    WSDLEX32 WSCbase* getProcedureEditor();
    WSDLEX32 WSCbase* getDirTree();
    WSDLEX32 WSCbase* getClassList();
    WSDLEX32 WSCstring getSelectedClassName();
    WSDLEX32 void setLoadProjectHandler(void(*)(WSCinspector*,char*));

    WSDLEX32 void setClients(WSClistData*);
    WSDLEX32 void setSelectedClientList(WSClistData*);
    WSDLEX32 void updateList();
    WSDLEX32 WSCbase* getSelectedClient();
    WSDLEX32 void setGetDirHandler(void*);
    WSDLEX32 void setExternalSourceFilesHandler(void*);
    WSDLEX32 char* getSrcPath();
    WSDLEX32 void setEditorExecuteHandler(void*);
    WSDLEX32 WSCbase* getPopupMenuSelectedClient();
    WSDLEX32 WSCbase* getForm1();
    WSDLEX32 WSCbase* getForm2();
    WSDLEX32 WSCbase* getForm3();
    WSDLEX32 WSCbase* getForm4();
    WSDLEX32 WSCbase* getForm5();
    WSDLEX32 void setFormVisible(long no,WSCbool fl);
    WSDLEX32 WSCulong getFormVisible();
    WSDLEX32 void setSelectIndexTab(long no);
 
    WSDLEX32 void setForm4Client(WSCbase*);

    WSDLEX32 virtual long draw();

    WSMFguiClassDef(WSCinspector,WSCsform);
    WSMFversionDef(WSCinspector);
};
#endif
