//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCWINDOWEDITOR_H
#define WSCWINDOWEDITOR_H

#include <WScom.h>
#include <WSCform.h>

class WSCscrForm;
class WSCvbtn;
class WSCvlabel;
class WSCform;
class WSCvlabel;
class WSCoption;
class WSCvifield;
class WSCcolorSelect;
class WSCmessageDialog;
class WSCbaseDialog;
class WSCfileSelect;
class WSCvtoggle;
class WSClist;
class WSCclassPropEditor;
class WSCclassUTrgEditor;
class WSCtriggerEditor;
class WSCclassRMethodEditor;

#define WSCwindowEditor_VER 1000

class WSCwindowEditor :public WSCscrForm{

  protected:
    void* _voidp_client;
    WSCbase*     _client;

    WSCvtoggle*  _tgb1;
    WSCvtoggle*  _tgb2;
    WSCvtoggle*  _tgb3;
    WSCmessageDialog* _msg;
    WSCvtoggle*  _pstg1;
    WSCvtoggle*  _pstg2;
    WSCvtoggle*  _pstg3;
    WSCvbtn*     _psbt1;
    WSCvbtn*     _psbt2;
    WSCvbtn*     _psbt3;
    WSCvbtn*     _psbt4;
    WSCvbtn*     _bt1;
    WSCvlabel*  _cname;
    WSCvlabel*   pslb6;
    WSCvifield*  _class_icon;
    WSCvifield*  _class_cmmt;
    WSCvifield*  _class_base;
    WSCvifield*  _inst_name;
    WSCvifield*  _file_name;
    WSCclassPropEditor* _cpe;
    WSCclassUTrgEditor* _cute;
    WSCtriggerEditor* _cte;
    WSCvtoggle*  _vartg;
    WSCvtoggle*  _prjtg;
    WSCvtoggle*  _rctg;
    WSCvbtn*  _fbt1;
    WSCclassRMethodEditor* _crme;

    unsigned _editable:1;
    WSMFpropertyDef( WSNclient,  void*,          _voidp_client ); 

    WSDLEX32 static void _prjtg_work(WSCbase*);
    WSDLEX32 static void _vartg_work(WSCbase*);
    WSDLEX32 static void _stg1_work(WSCbase*);
    WSDLEX32 static void _psbt1_work(WSCbase*);
    WSDLEX32 static void _psbt2_work(WSCbase*);
    WSDLEX32 static void _psbt3_work(WSCbase*);
    WSDLEX32 static void _psbt4_work(WSCbase*);
    WSDLEX32 static void _vifi_work(WSCbase*);
    WSDLEX32 static void _fbtn_work(WSCbase*);
    WSDLEX32 static void _rctg_work(WSCbase*);

    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onParentVisibleChange(WSCbool);


    WSDLEX32 void _adjust();
    WSDLEX32 virtual void setWorkWSNwidth(WSCushort);
    WSDLEX32 virtual void setWorkWSNheight(WSCushort);

  public:
    WSDLEX32 WSCwindowEditor(WSCbase*,char*);
    WSDLEX32 virtual ~WSCwindowEditor();

    WSDLEX32 virtual  long initialize();
//    virtual  long execEventProc(long,void*);
    WSDLEX32 virtual void onGuiPolicyChange(long);

    WSDLEX32 void setEditClient(WSCbase*);
    WSDLEX32 WSCbase* getEditClient();

    WSDLEX32 void setEditable(WSCbool);
    WSDLEX32 WSCbool getEditable();

    WSMFguiClassDef(WSCwindowEditor,WSCscrForm);
    WSMFversionDef(WSCwindowEditor);

};
#endif
