//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSADCOM_H
#define WSADCOM_H

#include <WScom.h>
#include <WSCstring.h>

struct prop_data {
  WSCstring name;
  WSCstring vname;
  WSCstring value;
  WSCstring bname;
  long       type;
  WSCbool    use_file;
  char       att;
  WSCstring values;
};
struct utrg_data {
  WSCstring name;
  WSCstring vname;
  long value;
  long type;
};

struct rmethod_data {
//  long type;
  WSCstring name;
  WSCstring params;
  WSCstring type_name;
};


extern WSDLEX char* get_type_name(long type_no);

extern WSDLEX WSCbase* WSGFreadWinSrc(WSCstring& src,WSCbool edit);
extern WSDLEX WSCbase* WSGFreadWinSrc2(WSCstring& src,WSCbool edit,char* topname);
extern WSDLEX WSCbase* WSGFreadWinFile(char* dirname,char* fname,long encoding);

extern WSDLEX void WSGFreadWinSrcSetCreateProcHandler(long(*)(char*,char*));
extern WSDLEX WSCstring WSGFcreateWinSrc(WSCbase*);
extern WSDLEX char* WSGFcreateName(char* picname,char* classname);
extern WSDLEX WSCstring WSGFcreateVirtualRemoteClassHeader(WSCbase*);
extern WSDLEX WSCstring WSGFcreateVirtualRemoteClassSrc(WSCbase*);

extern WSDLEX long WSGFcreateProjectSrcFile(char* dname,char* fname,WSCulong proj,long encoding);
extern WSDLEX long WSGFcreateMakefiles(char* dname,char* prj_name,WSCulong proj,long encoding);
extern WSDLEX long WSGFcreateMkinfFile(char* dname,char* prj_name,WSCulong proj,long encoding);
extern WSDLEX long WSGFcreateWindowSrcFiles(char* dname,WSCulong proj,long encoding);
extern WSDLEX long WSGFsaveWindowFile(char* dname,WSCbase* win,WSCulong proj);
extern WSDLEX long WSGFloadProjectAndWinFiles(char* dname,char* fname,long encoding);
extern WSDLEX long WSGFdestroyProject(WSCulong project);
extern WSDLEX long WSGFsaveProject(WSCulong project,char* dname,char* fname,long encoding);

extern WSDLEX long WSGFloadProject(char* dname,char* fname,long encoding);
extern WSDLEX long WSGFloadProject(char* path,long encoding);
extern WSDLEX WSCbase* copy_recursive(WSCbase* item,WSCbase* target);


#define WS_VE_INSTANCE_UPDATED          "ve-instance-updated"
#define WS_VE_INSTANCE_COPIED           "ve-instance-copied"
#define WS_VE_INSTANCE_PASTED           "ve-instance-pasted"
#define WS_VE_PROPERTY_VIEWER_UPDATED   "ve-property-viewer-updated"
#define WS_VE_PROCEDURE_VIEWER_UPDATED  "ve-procedure-viewer-updated"
#define WS_VE_ATTR_VIEWER_UPDATED       "ve-attr-viewer-updated"
#define WS_VE_INSTANCE_TO_FRONT         "ve-instance-to-front"
#define WS_VE_INSTANCE_TO_BACK          "ve-instance-to-back"
#define WS_VE_INSTANCE_DELETE           "ve-instance-delete"
#define WS_VE_PROP_INSTANCE_SELECTED    "ve-prop-instance-selected"
#define WS_VE_PROP_INSTANCE_RELEASED    "ve-prop-instance-released"
#define WS_VE_PROP_INSTANCE_PROP_UPDATED "ve-prop-instance-prop-updated"
#define WS_VE_INTERNAL_WINDOW_CREATED   "ve-internal-window-created"
#define WS_VE_INTERNAL_WINDOW_DESTROYED "ve-internal-window-destroyed"
#define WS_VE_INTERNAL_WINDOW_VISIBLE   "ve-internal-window-visible"
#define WS_VE_INTERNAL_WINDOW_UNVISIBLE "ve-internal-window-unvisible"
#define WS_VE_EXEC_UNDO                 "ve-exec-undo"
#define WS_VE_SET_PROPERTY_UNDO         "ve-set-property-undo"
#define WS_VE_INSTANCE_CLICKED          "ve-instance-clicked"

#define WS_VE_PM_MENU1 WSGFgettext("A3:WSSTR Copy    :COPY:,Paste:PASTE:,SP,Properties:PROP:,Procedures:OP:,Attributes:EXPROP:,SP,Delete:DEL:")
#define WS_VE_PM_MENU2 WSGFgettext("A3:WSSTR Copy    :COPY:,Paste:PASTE:,SP,Properties:PROP:,Procedures:OP:,Attributes:EXPROP:,SP,Front:FRONT:,Back:BACK:,SP,Delete:DEL:")

extern WSDLEX void WSGFsetDefaultVePopupMenus();
extern WSDLEX void WSGFsetDefaultVePropertyEditProcedures();

extern WSDLEX void add_lib_list(char* libname);
extern WSDLEX void clear_lib_list();
extern WSDLEX WSClistData* get_lib_name();

extern WSDLEX void WSGFcreateWindowInstanceList2Ocaml(WSCstring*,WSCbase*);
extern WSDLEX void WSGFcreateWindowInstanceList3Ocaml(WSCstring*,WSCbase*);
extern WSDLEX long _check_name_strings(char* cname,WSCbase* base,WSCbase* client,char* aname);
extern WSDLEX WSCbase* _search_instance(char* name,WSCbase* item);

extern WSDLEX long WSGFpasteInstance(WSCbase* target,WSCbase* src);
extern WSDLEX void WSGFsetupInstance(WSCbase*);
extern WSDLEX WSCbase*      WSGFgetClassBase(WSCbase*);
extern WSDLEX void          WSGFresetClassBase(WSCbase*);
extern WSDLEX long WSGFloadLibrary(long,char* libname);

#define WS_ERR_NOT_MANAGER -3
#define WS_ERR_OVERWRAPED  -4


#endif
