//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDDEVFBFORMDEV_H
#define WSDDEVFBFORMDEV_H

#include <devfb/devfb.h>
#include <WSDwindowDev.h>

#define N_VIEWR     64

class WSDdevfbFormDev               :public WSDwindowDev {
  private:
  protected:
   WSClistData _child_dev_list;
    W        _window;
    W        _gid;
    W        _mem_gid;
    UB*      _mem_gid_buf;
    short    _bg;
    short    _bg_pix;

    long     _click_time;
    WSCushort _mno;
    WSCbool _added_to_child_dev_list;
    RLIST   _clip_fore_list[N_VIEWR];
    long    _clip_num;
    WSDdevfbFormDev* _mparent_dev;

static WSCbool _expose_sequence;
static WSClistData _geometry_update_list;
static WSClistData _update_list;
static WSClistData _expose_list;
static WSClistData _recursive_update_list;
static short _global_region_x;
static short _global_region_y;
static WSCushort _global_region_w;
static WSCushort _global_region_h;

static short _exposed_global_region_x;
static short _exposed_global_region_y;
static WSCushort _exposed_global_region_w;
static WSCushort _exposed_global_region_h;

  public:
virtual long createWindow();
virtual long createPixmap(); //call for Expose only...
virtual long createContext();
virtual long destroyWindow();
virtual long destroyPixmap();
virtual long destroyContext();
virtual WSCbool getParentVisible();
    RLIST* getClipList();
    void   clearClipList();
    void   setClipNum(long num);
#if 0
static  void _evh_delete(Widget,XtPointer,XEvent*,WSCbool*);
static  void _evh_delete2(Widget,void*,void*);
static  void _evh_dummy(Widget,XtPointer,XEvent*,WSCbool*);

    long    setPixmap(Pixmap);
    void    setWidget(Widget);
    long    setGC(GC);
#endif

virtual void _copy_area(long x,long y,WSCulong w,WSCulong h,long dx,long dy,WSCuchar fl);
virtual void _setup_pixmap(short x,short y,WSCushort w,WSCushort h,short bg,short img_no);
virtual void _clear_area( long x,long y,WSCulong w,WSCulong h);

    WSDdevfbFormDev();
    virtual ~WSDdevfbFormDev();
    virtual long setVisible(WSCbool fl);
    virtual long setValue(long kind,void*);
    virtual long getDeviceResource();
    virtual long getWindowResource();
    virtual long getContextResource();
    virtual long getSpecialResource();
    virtual WSDdev* getEventParentDev();

    void _evh_expose(RECT* );
    void _evh_expose_abs(RECT* );
    void _expose_ex(WSCrect*);
    void _expose_ex_abs(WSCrect*);
    void _evh_btn_press(WEVENT*);
    void _evh_btn_release(WEVENT*);
    void _evh_mouse_move(WEVENT*);
    void _evh_mouse_out();
    void _evh_mouse_in(H x,H y);
    void _evh_resize(RECT*);
    void _evh_destroy(WEVENT*);

    W  getWindow();
    W  getGID();
    W  getMemGID();
    W  getParentWindow();
    W  getParentGID();
    W  getParentMemGID();
    WSCbool getUseMemGID();
#if 0
    Widget  getWidget();
    Pixmap  getPixmap();
    Window  getWindow();
    GC      getGC();
    WSCushort getMouseNo();
#endif
   WSDdevfbFormDev* getParentAreaDev();
   WSDdevfbFormDev* getMostParentAreaDev();
   void addChildDevList(WSDdevfbFormDev*);
   void delChildDevList(WSDdevfbFormDev*);
   void setChildDevListFlag(WSCbool);
   WSCbool getChildDevListFlag();

  virtual long raise();
  virtual long lower();
  static WSCbool isValidInstance(WSDdevfbFormDev*);

  virtual void getAbstSize(short*,short*,WSCushort*,WSCushort*);
//  virtual void getAbstSizeForGid(short*,short*,WSCushort*,WSCushort*);
  virtual void getAbstPos(short*,short*);
//  virtual void getAbstPosForGid(short*,short*);
  virtual WSCbool haveWindow();
  WSClistData* getChildDevList();

  void setDefaultRegion();
  void redrawAll();

  WSDdevfbFormDev* getChildWithPoint(short x,short y);
  static WSDdevfbFormDev* getMouseGrabedDev(); 
  static void setMouseGrabedDev(WSDdevfbFormDev* dev); 
  virtual void drawBackGround(long x,long y,WSCulong w,WSCulong h);
  virtual void exposeExecute(short x,short y,WSCushort w,WSCushort h);
  virtual void recursiveExposeExecute(short x,short y,WSCushort w,WSCushort h);
  virtual long exposeArea(long x,long y,WSCulong w,WSCulong h,WSCbool scaling = True);    
  void addUpdateList();
  void addGeometryUpdateList();
  void addRecursiveUpdateList();
static void executeUpdate();
static void setGlobalRegion(short x,short y,WSCushort,WSCushort);
static void getGlobalRegion(short* x,short* y,WSCushort*,WSCushort*);
virtual void recursive_update();
virtual long detachClient();
  void _clear_parent_cache();

  WSMFclassDef(WSDdevfbFormDev,WSDwindowDev);
};
#endif
 
