#ifndef WSDDEVICEFONT_H
#define WSDDEVICEFONT_H

#include <stdio.h>
#include <WScom.h>
#include <WSCstring.h>

#define DEVICE_FONT_OPTIMIZE
#define NO_FONT_GLYPH_TABLE

#define WS_FONT_BITMAP 0

#define WS_FONT_TYPE_BDF 1
#define WS_FONT_TYPE_PCF 2
#define WS_FONT_TYPE_TTF 3

struct WSDdeviceFontGlyph{
  unsigned char* _data;
  int _char_code;
  unsigned char _width;
  char _left_bearing;
  char _right_bearing;
  char _ascent;
  char _descent;
#ifndef DEVICE_FONT_OPTIMIZE
  WSDdeviceFontGlyph();
#endif
  virtual ~WSDdeviceFontGlyph();

  virtual int destroy();
};

struct WSDdeviceFont{
  WSCstring _font_name;
  int _type;
  int _height;
  int _width;
  int _ascent;
  int _descent;
  int _chars;
  int _default_char_code;
  WSDdeviceFontGlyph* _font_glyph;
  int _font_encode;
  unsigned char* _glyph_buf;

  WSDdeviceFont();
  virtual ~WSDdeviceFont();
  virtual int destroy();
//  virtual int getStringWidth(WSCushort* str,int len,int* w);
  virtual WSDdeviceFontGlyph* getFontGlyph(WSCushort str);
#ifdef NO_FONT_GLYPH_TABLE
  virtual WSDdeviceFontGlyph* _get_font_glyph(WSCushort str,int pos,int snum,int lnum);
#else
  WSDdeviceFontGlyph** _font_glyph_table;
#endif
};

struct WSDdeviceFontList{
  int _font_order[WS_FONT_COUNT];
  WSClistData _list;
  WSDdeviceFontList();
  virtual ~WSDdeviceFontList();
  int destroy();
  WSDdeviceFontGlyph* getFontGlyph(unsigned int code);
  int addFont(WSDdeviceFont*);
  int* getFontOrder();
  WSDdeviceFont* getFont(int fenc);
  int getFontHeight();
  int getFontAscent();
  int getFontDescent();
  int getStringWidth(WSCushort* str,int len,int* w);
};

extern WSDdeviceFont* WSGFdeviceReadFont(char* file_name,char* fontname,int type,int fenc);
extern WSDdeviceFontList* WSGFdeviceOpenFont(char* fname,char* path);

#endif
