//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef DEVFB_DEP_H
#define DEVFB_DEP_H

#include <WScom.h>

class  WSDdeviceFontList;
class  WSClistData;
#define WS_EXLIST_MAX 32
#define WS_VISLIST_MAX 32
typedef struct _graphics_context {
  short _gid;
  unsigned char _lw;
  unsigned char _ld_type;
  unsigned int _fg_color;
  unsigned int _bg_color;
  short _x;
  short _y;
  unsigned short _w;
  unsigned short _h;
  unsigned char* _buf;
  unsigned int _row_bytes;
  unsigned int _hatch_type;
  int _window_id;
  unsigned char _depth;
  unsigned char _start_red;
  unsigned char _start_green;
  unsigned char _start_blue;
  unsigned char _red_bits;
  unsigned char _green_bits;
  unsigned char _blue_bits;
  short _draw_pt_x;
  short _draw_pt_y;
  WSDdeviceFontList*  _font;
//  WSClistData* _ex_region_list;
//  WSClistData* _visible_region_list;
  WSCrect* _ex_region_list;
  WSCrect* _visible_region_list;
  long _ex_region_list_num;
  long _visible_region_list_num;
  unsigned char _updated;
} WSDdeviceGC;

typedef struct _window_context {
  short _x;
  short _y;
  unsigned short _w;
  unsigned short _h;
  unsigned int _attr;
  unsigned int _bg_color;
  void* _user_data;
  unsigned short* _title_string;
  short _window_id;
  short _parent_window_id;
  short _stack_no;
  long _status;
  int _pid;
  int _gc;
#if (defined ROOT_LESS) && (defined USE_X11)
  long _native_window;
  long _native_context;
  long _native_image;
#endif
#ifdef MacOS
  int _diff_y;
  long _top_float;
#endif
} WSDdeviceWindow;


typedef struct _event_list {
  WSDdeviceEvent _event;
  struct _event_list* _next;
} WSDdeviceEventList;

#include <devfb/WSDdeviceFont.h>

#define WS_MAX_WINDOW    64
#define WS_MAX_GC       256
#define WS_MAX_POINTS   256

#define WS_MAX_WINDOW_AREA (sizeof(WSDdeviceWindow)*WS_MAX_WINDOW)
#define WS_MAX_GC_AREA     (sizeof(WSDdeviceGC)*WS_MAX_GC)
#define WS_MAX_CONTEXT_AREA (WS_MAX_WINDOW_AREA + WS_MAX_GC_AREA)

#define WS_DEVICE_NEED_EXPOSE 1

extern int WSGFdeviceFrameBufferInitialize();
extern int WSGFdeviceGetNewWindow(unsigned int attr,unsigned int parent,short x,short y,unsigned short w, unsigned short h,unsigned int bg);
extern int WSGFdeviceDestroyWindow(int wid);
extern int WSGFdeviceMoveWindow(int wid,short x,short y);
extern int WSGFdeviceResizeWindow(int wid,unsigned short w,unsigned short h);
extern int WSGFdeviceGetWindowPosition(int wid,short* x, short* y);
extern int _WSGFdeviceGetWindowPosition(int wid,short* x, short* y); //unlock version
extern int WSGFdeviceGetWindowSize(int wid,unsigned short* w, unsigned short* h);
extern int _WSGFdeviceGetWindowSize(int wid,unsigned short* w, unsigned short* h); //unlock version
extern int WSGFdeviceGetWindowStatus(int wid,unsigned int* status);
extern int _WSGFdeviceGetWindowStatus(int wid,unsigned int* status); //unlock version
extern int WSGFdeviceSetWindowStatus(int wid,unsigned int status);
extern int _WSGFdeviceSetWindowStatus(int wid,unsigned int status); //unlock version
extern int WSGFdeviceSetWindowTitle(int wid,unsigned short* code);
extern int WSGFdeviceSetWindowColor(int wid,unsigned int color);
extern int WSGFdeviceGetActiveWindow(int* wid);
extern int _WSGFdeviceGetActiveWindow(int* wid); //unlock version
extern int WSGFdeviceGetWindowOwner(int wid,int* pid);
extern int _WSGFdeviceGetWindowOwner(int wid,int* pid); //unlock version
extern int WSGFdeviceSetWindowData(int wid,void*);
extern int WSGFdeviceGetWindowData(int wid,void**);
extern int WSGFdeviceGetNextEvent(WSDdeviceEvent* evt,unsigned int mode);

extern int WSGFdeviceGetNewGC(short x,short y,
                       unsigned short w, unsigned short h,
                       unsigned int depth, unsigned short row_bytes,
                       unsigned char* buf,
                       unsigned int start_red,
                       unsigned int start_green,
                       unsigned int start_blue,
                       unsigned int red_bits,
                       unsigned int green_bits,
                       unsigned int blue_bits);
extern int WSGFdeviceDestroyGC(int gid);

extern int WSGFdeviceDrawLine(int gid,short x1,short y1,short x2,short y2,
                              unsigned int fg,int lw,int type);

extern int WSGFdeviceDrawRect(int gid,short x,short y,
                              unsigned short w, unsigned short h,
                              unsigned int fg,int lw,int type);

extern int WSGFdeviceDrawPolygon(int gid,WSCpoint* point,int num,
                              unsigned int fg,int lw,int type);

extern int WSGFdeviceDrawFillPolygon(int gid,WSCpoint* point,int num,
                              unsigned int bg,int rev);

extern int WSGFdeviceDrawArc(int gid,short x,short y,
                              unsigned short w,unsigned short h,
                              int a1,int a2, 
                              unsigned int bg,int lw,int type);

extern int WSGFdeviceDrawFillArc(int gid,short x,short y,
                              unsigned short w,unsigned short h,
                              int a1,int a2, int arctype,
                              unsigned int bg);


extern int WSGFdeviceDrawFillRect(int gid,short x,short y,
                              unsigned short w, unsigned short h,
                              unsigned int bg,int htype);

extern int WSGFdeviceDrawString(int gid,short x,short y,
                              WSDdeviceFontList* fl,
                              unsigned int fg,WSCushort* string,int len);
extern int _WSGFdeviceDrawString(int gid,short x,short y,
                              WSDdeviceFontList* fl,
                              unsigned int fg,WSCushort* string,int len); //unlock version
extern int WSGFdeviceGetStringWidth(int gid,
                              WSDdeviceFontList* fl,
                              WSCushort* string,int len);
extern int WSGFdeviceGetStringHeight(int gid,
                              WSDdeviceFontList* fl,
                              WSCushort* string,int len);

extern int WSGFdeviceGetWindowGC(int wid);
extern int _WSGFdeviceGetWindowGC(int wid); //unlock version
extern int WSGFdeviceGetGCWindow(int gid);
extern int _WSGFdeviceGetGCWindow(int gid); //unlock version
extern int WSGFdeviceFlushGC(int gid);
extern int WSGFdeviceGetDevSpec(int gid,DEV_SPEC* dspec);
extern int WSGFdeviceGetColorSpec(int gid,CSPEC* cspec);
extern int WSGFdeviceBitBlt(int sgid,short x,short y,
                              unsigned short w, unsigned short h,
                              int dgid, short dx,short dy,
                              unsigned int mode);
extern int WSGFdeviceStretchedBitBlt(int sgid,short x,short y,
                              unsigned short w, unsigned short h,
                              int dgid, short dx,short dy,
                              unsigned short w, unsigned short h,
                              unsigned int mode);

extern int WSGFdeviceDestroyVisibleRegion(int gid);
//extern int WSGFdeviceDestroyExclusiveRegion(int gid);
extern int _WSGFdeviceDestroyExclusiveRegion(int gid); //unlock version
//extern int WSGFdeviceAddVisibleRegion(int gid,short,short,unsigned short,unsigned short);
extern int WSGFdeviceSetVisibleRegion(int gid,short,short,unsigned short,unsigned short);
extern int _WSGFdeviceSetVisibleRegion(int gid,short,short,unsigned short,unsigned short); //unlock vertion
//extern int WSGFdeviceAddExclusiveRegion(int gid,short,short,unsigned short,unsigned short);
extern int _WSGFdeviceAddExclusiveRegion(int gid,short,short,unsigned short,unsigned short); //unlock version
//extern WSClistData* WSGFdeviceGetVisibleRegion(int gid);
//extern WSClistData* WSGFdeviceGetExclusiveRegion(int gid);
extern WSCrect* WSGFdeviceGetVisibleRegion(int gid,int* num);
extern WSCrect* WSGFdeviceGetExclusiveRegion(int gid,int* num);

extern void WSGFlockDev();
extern void WSGFunlockDev();

extern int WSGFdeviceSetDrawPoint(int gid,short x,short y);
extern int WSGFdeviceGetDrawPoint(int gid,short* x,short* y);
extern int _WSGFdeviceGetDrawPoint(int gid,short* x,short* y); //unlock version
extern int WSGFdeviceSetFont(int gid,WSDdeviceFontList* font);
extern int WSGFdeviceGetFont(int gid,WSDdeviceFontList** font);
extern int _WSGFdeviceGetFont(int gid,WSDdeviceFontList** font); //unlock version
extern int WSGFdeviceSetForeColor(int gid,unsigned int col);
extern int _WSGFdeviceSetForeColor(int gid,unsigned int col); //unlock version
extern int WSGFdeviceGetForeColor(int gid,unsigned int* col);
extern int _WSGFdeviceGetForeColor(int gid,unsigned int* col); //unlock version
extern int WSGFdeviceSetBackColor(int gid,unsigned int col);
extern int _WSGFdeviceSetBackColor(int gid,unsigned int col); //unlock version
extern int WSGFdeviceGetBackColor(int gid,unsigned int* col);
extern int WSGFdeviceGetScreenSize(int* w,int* h);
extern int WSGFdeviceSearchWindow(short x,short y);
extern int WSGFdeviceGetGCPos(int gid,short* x,short* y);
extern int WSGFdeviceGetCursorPos(short* x,short* y);
extern int WSGFdeviceGetCursorPos();
extern int WSGFdeviceGetWindowList(int* list,int num);

extern int WSGFdeviceSemCreate(int cnt,unsigned int opt);
extern int WSGFdeviceSemLock(int id);
extern int WSGFdeviceSemUnlock(int id);
extern int WSGFdeviceSemDestroy(int id);

extern int WSGFdeviceSleep(int time);
extern int WSGFdeviceCreateThread(int* thr,void(*proc)(int),int arg);
extern int WSGFdeviceExitThread();
extern int WSGFdeviceTerminateThread(int id);
extern int WSGFdeviceGetThreadId();
extern int WSGFdeviceSendMessage(MESSAGE*);
extern int WSGFdeviceSendDelayMessage(MESSAGE*,int,int*);
extern int WSGFdeviceRecvMessage(int type,MESSAGE*,int size);
extern int WSGFdeviceCheckEventAvailable();

//internal variables--
extern WSDdeviceWindow* _window_list;
extern WSDdeviceGC*     _gc_list;
extern WSDdeviceEventList*  _evt_list;
extern unsigned int _default_black_color;
extern unsigned int _default_white_color;
extern WSClistData _message_list;
extern WSClistData _message_time_list;
extern WSClistData _message_rate_list;
extern unsigned char* _buffer;
extern int _device_row_bytes;
extern int _device_width;
extern int _device_height;
extern int _device_depth;
extern unsigned int _device_start_red;
extern unsigned int _device_start_green;
extern unsigned int _device_start_blue;
extern unsigned int _device_red_bits;
extern unsigned int _device_green_bits;
extern unsigned int _device_blue_bits;
extern int   _sem_id;
extern int   _event_sem_id;

//internal functions--
extern int _init_frame_buffer();
extern int _get_event(WSDdeviceEvent* evt,unsigned int mode);
extern int _update_frame_buffer(int x,int y,unsigned int w,unsigned int h);
extern void _get_mouse_pos(short* x,short* y);

#if defined( LINUX ) || defined (MacOS)
#include <pthread.h>
typedef struct pthread_sem_struct{
  int value;
  pthread_mutex_t mutex;
  pthread_cond_t lock_free;
} pthread_sem_t;
extern int pthread_sem_init_np(pthread_sem_t* semp);
extern int pthread_sem_lock_np(pthread_sem_t* semp);
extern int pthread_sem_unlock_np(pthread_sem_t* semp);
extern int pthread_sem_destroy_np(pthread_sem_t* semp);
#endif

#endif
