//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDDFBFONT_H
#define WSDDFBFONT_H

#include <WScom.h>
#include <WSDres.h>
#include <WSDfont.h>
#include <directfb.h>

#define WS_FONT_COUNT      23
#define WS_FONT_NONE        0
#define WS_FONT_ISO8859(n) (n) /* 1 - 15 */
#define WS_FONT_UNICODE    16
#define WS_FONT_KOI8R      17
#define WS_FONT_JIS0201    18
#define WS_FONT_JIS0208    19
#define WS_FONT_KSC5601    20
#define WS_FONT_GB2312     21
#define WS_FONT_BIG5       22

struct WSDdfbFontStruct {
  long               codeset;
  IDirectFBFont*     font;
  DFBFontDescription font_desc;
};

class WSDdfbFont               :public WSDfont {

 protected:
  long _font_height;
 
  WSDdfbFontStruct    _font_list[WS_FONT_COUNT]; 
  int    _font_order[WS_FONT_COUNT]; 


  virtual long initialize();
  virtual long destroy();

 public:
  WSDdfbFont();
  virtual ~WSDdfbFont();
  virtual long getStringWidth(WSCstring*);
  virtual long getStringHeight(WSCstring*);
  virtual long getStringWidthUCS2(WSCushort*);
  virtual long getStringHeightUCS2(WSCushort*);
  int* getFontOrder();

//  long getXFontSet();

  virtual long getAscent();
  virtual long getDescent();

  WSMFclassDef(WSDdfbFont,WSDfont);
};

#endif //WSDDFBFONT_H
