//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDDFBKEYBOARD_H
#define WSDDFBKEYBOARD_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSkeysym.h>
#include <WSCstring.h>
#include <WSClistData.h>
#include <WSDkeyboard.h>
#include <directfb.h>

class WSDdfbKeyboard :public WSDkeyboard{

  protected:
    IDirectFBInputDevice* _keyboard;

    WSCstring _selected_string;
    WSDdev* _dev;
    WSCbool  _focused;

    WSCbool _wait_for_receive_data;
    long _x;
    long _y;
    long _fno;
    short _fg;
    short _bg;
  public:
    WSDdfbKeyboard();
    virtual ~WSDdfbKeyboard();

    virtual long initialize();

    WSCbool deliverKeyEvent(void* ev,WSCbool);
    virtual long startFep(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    virtual long startAscii(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    virtual long setFepPos (WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    virtual long resetFep(WSDdev*);

    virtual void setSelectedString(char*,long encode = WS_EN_DEFAULT);
    virtual char* getSelectedString(long encode = WS_EN_DEFAULT);

//-----------------------------------------------------------------//
WSMFclassDef(WSDdfbKeyboard,WSDkeyboard);

};
extern WSDdfbKeyboard* WSGIdfbKeyboard();
#endif
