//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDDFBWINDEV_H
#define WSDDFBWINDEV_H

#include <dfb/WSDdfbFormDev.h>

class WSDdfbWinDev   :public WSDdfbFormDev{
 protected:
  WSCulong _attr;
  char   _title_bar;
  char   _title_bar_style;
  unsigned _no_frame:1;
  unsigned _requested_top:1;
  unsigned _no_frame_first_time:1;
  unsigned _transient:1;
  unsigned _top_float:1;
  unsigned _modal:1;

  short _diff_x;
  short _diff_y;
  WSCushort _diff_w;
  WSCushort _diff_h;
  WSCstring _title_str;
  virtual long createWindow();
  virtual long destroyWindow();
  virtual long createPixmap();
  virtual long destroyPixmap();
  virtual long createContext();
  virtual long destroyContext();

 public:
  WSDdfbWinDev();
  virtual ~WSDdfbWinDev();
  virtual long setVisible(WSCbool fl);
  virtual long setValue(long kind,void*);
  virtual long getValue(long kind,void*);
  virtual long getWindowResource();
  virtual long getContextResource();
  virtual WSCbool getParentVisible();
 
  virtual WSDdev* getParentDev();
  virtual WSDdev* getVisibleParentDev();
  virtual WSCbool haveWindow();

  WSMFclassDef(WSDdfbWinDev,WSDdfbFormDev);
};
#endif
