//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#if !defined(_hobj3d_h)
#define _hobj3d_h

#include  "object3d.h"

class THObj3D : public TObject3D {
    Matrix3 wm;
    Vector  wp;
    Vector  velocity;
    Vector  wvelocity;
    Vector  AngleVelocity;
    Vector  accele;
    long    gravity;
    double  sx, sy, sz;
    int     sf;
  public:
    THObj3D *parent;
    THObj3D *brother;
    THObj3D *child;
    THObj3D(int vn, int pn, THObj3D* p);
    ~THObj3D();
    void SetWorld();

    void SetNodeWorldMatrix(long deltax);

    void show(THObj3D *eye);

    void GetWorldPosition(Vector &pos, long &h, long &p, long &b);

    void   SetVelocity(Vector v);
    Vector GetVelocity() { return velocity;};
    void   SetWVelocity(Vector wv);
    Vector GetWVelocity(){ return wvelocity;};
    void   SetAngleVelocity(Vector v){AngleVelocity = v;};
    Vector GetAngleVelocity(){ return AngleVelocity;};
    void   SetGravity(long g) { gravity = g;};
    long   GetGravity() { return gravity;};
    void   SetAccele(Vector v) { accele = v; };
    Vector GetAccele() { return accele;};
    void   SetScale(double x, double y, double z) {
             sx = x; sy = y; sz = z; sf = 1;
           };
    void   GetScale(double &x, double &y, double &z) {
             x = sx; y = sy; z = sz;
           };
    Vector GetDirection_world(const Vector &local) {
             return ConvCoordinate(wm, local);
           };

    Vector GetDirection_eye(const Vector &world) {
             return ConvCoordinate2(wm, world);
           };

    Vector GetDirection_local(const Vector &world) {
             return ConvCoordinate2(wm, world);
           };
    Vector WorldToLocal(Vector w) {
             w = w - wp;
             return ConvCoordinate2(wm, w);
           };

    Vector GetWorldOrigin() {return wp;};

};

#endif
