//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDWINEXECUTE_H
#define WSDWINEXECUTE_H

#include <windows.h>
#include <WSDexecute.h>

#define WS_WIN_EXECUTE 1

class WSDwinExecute :public WSDexecute{
protected:
WSDLEX32 static void _read_thread(DWORD);
WSDLEX32 static void _check_thread(DWORD);
  char* _buffer;
  long _data_len;
  DWORD _thread_id;
  HANDLE _thread;
  HANDLE _thread2;
  HANDLE _sem;
  CRITICAL_SECTION _crs;
  HANDLE _read;
  HANDLE _write;
  HANDLE _read2;
  HANDLE _write2;
public:
  WSDLEX32 WSDwinExecute();
  WSDLEX32 virtual ~WSDwinExecute();

  WSDLEX32 virtual long killProcess();
  WSDLEX32 virtual long execute(char* name,long mode);
  WSDLEX32 virtual long read(char* ,long len);
  WSDLEX32 virtual char* gets(char* ,long len);
  WSDLEX32 virtual long write(char* ,long len);

  WSDLEX32 void _callback();

  WSMFclassDef(WSDwinExecute,WSDexecute);
};
#endif
