//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDWINTHREAD_H
#define WSDWINTHREAD_H

#include <WSDthread.h>

#define WS_WIN_THR 3
class WSDwinThread :public WSDthread{

  protected:
    HANDLE  _thr;
    HANDLE  _tid;
    CRITICAL_SECTION _cs;
    WSDLEX32 static DWORD _thread_start_handler(void*);
  public:
    WSDLEX32 WSDwinThread();
    WSDLEX32 virtual ~WSDwinThread();

    WSDLEX32 virtual long    createThread(void* data);
    WSDLEX32 virtual long    detachThread();
    WSDLEX32 virtual long    joinThread(void**);
    WSDLEX32 virtual long    terminateThread();
    WSDLEX32 virtual long    getStatus();
    WSDLEX32 virtual long    execCallback(void*);

    WSMFclassDef(WSDwinThread,WSDthread);
};
struct _internal_thr_data_ {
  WSDwinThread* thr;
  void*         data;
};
#endif
