//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDWINSOCKET_H
#define WSDWINSOCKET_H

#include <WScom.h>
#include <WSDsocket.h>

#define WS_WIN_ACCEPT 2

class WSDwinsocket  :public WSDsocket{
 protected:
  SOCKET _socket;
  WSCbool _listened;
  HANDLE _sem;
  WSCstring _error_str;
  WSDLEX32 virtual long initialize();
  WSDLEX32 virtual long destroy();

  WSDLEX32 static void* _accept_thread_(void*);
  WSDLEX32 static void* _udp_read_thread_(void*);
 public:
  WSDLEX32 WSDwinsocket();
  WSDLEX32 virtual ~WSDwinsocket();
  WSDLEX32 virtual long connect();
  WSDLEX32 virtual long listen();
  WSDLEX32 virtual void* accept();
  WSDLEX32 virtual long acceptEx(void(*)(WSDsocket*,void*,WSCulong));
  WSDLEX32 virtual long _continue_udp_read_accept();

  WSDLEX32 virtual long read(void* handle,WSCuchar* buf,long size);
  WSDLEX32 virtual long write(void* handle,WSCuchar* buf,long size);
  WSDLEX32 virtual long read(WSCuchar* buf,long);
  WSDLEX32 virtual long write(WSCuchar* buf,long);

  WSDLEX32 virtual long close(void* sock = NULL);

  WSDLEX32 void seterr(int er = -1);
  WSDLEX32 virtual WSCstring getLastError(); 

  WSMFclassDef(WSDwinsocket,WSDsocket);
};
struct _accept_send_type{
  WSDwinsocket* sock;
  int         socket;
  WSCulong    addr;
  void(*hd)(WSDsocket*,void*,WSCulong);
};

#endif //WSDWINSOCKET_H
