//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDXSCRDEV_H
#define WSDXSCRDEV_H

#include <x11/WSDxformDev.h>
#include <X11/Intrinsic.h>

class WSDxscrFrameDev   :public WSDxformDev{
 protected:
  Widget  _scr_form;
  short   _h_scr_pos;
  short   _v_scr_pos;
  short   _p1_x;
  short   _p1_y;
  short   _p2_x;
  short   _p2_y;
  WSCushort  _work_width;
  WSCushort  _work_height;
  WSCushort  _title_height;

  virtual long createWindow();
  virtual long createPixmap();
  virtual long destroyWindow();
  static  void _evh_delete2(Widget,void*,void*);
  static  void _evh_resize(Widget,XtPointer,XEvent*,WSCbool*);

 public:
  WSDxscrFrameDev();
  virtual ~WSDxscrFrameDev();
  virtual long setVisible(WSCbool fl);
  virtual long setValue(long kind,void*);
  virtual void getDispAddr(short*,short*);
  virtual void _clear_widget();

  WSMFclassDef(WSDxscrFrameDev,WSDxformDev);
};
#endif
