open Swig
open Mwtlib
open Newwin000
open Startep

let _RAND_MAX = 0x7fff
let _RIGHT = 0
let _LEFT  = 1
let direction = ref _RIGHT

let non_val = -1

let del_pos = (non_val, non_val)
let del_filter item = item <> del_pos

let most_right = ref non_val
let most_left = ref non_val
let diff_x = ref 0
let diff_y = ref 0

let p = print_endline

let drawep obj =
   (* do something *)
   most_right := non_val;
   most_left := non_val;
   diff_x := 0;
   diff_y := 0;
   ignore(!newvdra_001 -> "setForeColor" ("#000000"));
   ignore(!newvdra_001 -> "drawRect" (0, 0, 400, 400));
   ignore(!newvdra_001 -> "setForeColor" ("#ffffff"));

   (* check inv and shoot missile *)
   let iter_f_inv pos_inv =
      match pos_inv with
      | pt_x, pt_y ->
         if !most_right = non_val
         then most_right := pt_x;
         if !most_left = non_val
         then most_left := pt_x;
         if pt_x < !most_left
         then most_left := pt_x;
         if pt_x > !most_right
         then most_right := pt_x;
         
         if int_of_float (float_of_int (Random.int _RAND_MAX) *. 200.0 /.
                           float_of_int (_RAND_MAX + 1)) = 0
         then inv_missile := (pt_x + 5, pt_y) :: !inv_missile
   in
   List.iter iter_f_inv !inv_list;

   (* check change direction *)
   if !direction = _RIGHT then
      begin
         diff_x := 1;
         if !most_right > 380 then
            begin
               direction := _LEFT;
               diff_x := -1;
               diff_y := 1
            end
      end
   else
      begin
         diff_x := -1;
         if !most_left < 20 then
            begin
               direction := _RIGHT;
               diff_x := 1;
               diff_y := 1
            end
      end;

   (* draw and move inv *)
   let map_f_inv pos_inv =
      match pos_inv with
      | pt_x, pt_y ->
      let npt_x = pt_x + !diff_x
      and npt_y = pt_y + !diff_y in
      let ret_val = (npt_x, npt_y) in

      if (npt_x / 20 + npt_y / 20) mod 2 <> 0 then
         begin
            ignore (!newvdra_001 -> "drawImage"
               ((make_int npt_x), (make_int npt_y), 10, 10, "1.bmp", _WS_CENTER));
            ret_val
         end
      else
         begin
            ignore (!newvdra_001 -> "drawImage"
               ((make_int npt_x), (make_int npt_y), 10, 10, "2.bmp", _WS_CENTER));
            ret_val
         end
   in
   inv_list := List.rev_map map_f_inv !inv_list;
   
   (* draw and move inv missile *)
   ignore (!newvdra_001 -> "setForeColor" ("#ff00ff"));
   let map_f_im pos_im =
      match pos_im with
      | pt_x, pt_y ->
      let npt_y = pt_y + 3 in
      ignore (!newvdra_001 -> "drawFillRect"
         ((make_int (pt_x - 2)), (make_int npt_y), 3, 6));
      if npt_y > 400
      then  del_pos else (pt_x, npt_y)
   in
   let tmp_im = List.rev_map map_f_im !inv_missile in
   if List.mem del_pos tmp_im
   then inv_missile := List.filter del_filter tmp_im
   else inv_missile := tmp_im;

   (* draw and move my missile *)
   ignore (!newvdra_001 -> "setForeColor" ("#00ff00"));
   let map_f_mm pos_mm =
      match pos_mm with
      | pt_x, pt_y ->
      let npt_y = pt_y - 10 in
      ignore (!newvdra_001 -> "drawFillRect"
         ((make_int (pt_x - 2)), (make_int npt_y), 3, 6));
      if npt_y < 0
      then  del_pos else (pt_x, npt_y)
   in
   let tmp_mm = List.rev_map map_f_mm !my_missile in
   if List.mem del_pos tmp_mm
   then my_missile := List.filter del_filter tmp_mm
   else my_missile := tmp_mm;

   (* draw fence *)
   ignore (!newvdra_001 -> "setForeColor" ("#ffff00"));
   let iter_f_fen pos_fen =
      let f pos =
         match pos with
         | (pt_x, pt_y) ->
         ignore(!newvdra_001 -> "drawFillRect" ((make_int pt_x), (make_int pt_y), 5, 5));
      in
      f pos_fen
   in
   List.iter iter_f_fen !fence_list;

   (* draw my base *)
   match !my_base with
   | base_x, base_y ->
   ignore (!newvdra_001 -> "drawImage"
      ((make_int base_x), (make_int base_y), 10, 10, "base.bmp", _WS_CENTER));
   ()

let _ = Callback.register "drawep" drawep
