//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCclassInformation.h>
#include <WSCbaseDialog.h>
#include <WSCform.h>
#include <WSCvbtn.h>
#include <WSCvlabel.h>
#include <WSCvslider.h>
#include <WSCcolorSet.h>
#include <WSCvlabel.h>
#include <WSCvslider.h>
#include <WSCcolorSet.h>
#include <WSCvifield.h>
#include <WSCform.h>
#include <WSCmessageDialog.h>
#include <WSDappDev.h>
#include <WSDmouse.h>
#include <WSDcolor.h>
#include <WSDappDev.h>
#include <advance/WSCcolorEditor.h>
#include <math.h>

#define _X_OFF 64
#define _Y_OFF 64
#define _DIS   48

WSMFguiClassInitialize(WSCcolorEditor,WSCbaseDialog);
WSMFversion(WSCcolorEditor,WSCbaseDialog);

static WSCcolorEditor* theAppColorEditor = NULL;
WSCcolorEditor* WSGIappColorEditor(){
  if (theAppColorEditor == NULL){
    theAppColorEditor = new WSCcolorEditor(NULL,"theAppColorEditor");
    theAppColorEditor->initialize();
  }
  return theAppColorEditor;
}

WSCcolorEditor::WSCcolorEditor(WSCbase* base,char* objName):
WSCbaseDialog(base,objName){
  _slider_not_move = 0;
  clearea1 = NULL;
  cledvlab000 = NULL;
  cledvsli001 = NULL;
  cledvifi001 = NULL;
  cledvifi002 = NULL;
  cledvifi003 = NULL;
  cledvsli002 = NULL;
  cledvsli003 = NULL;
  cledvsli004 = NULL;
  cledvifi004 = NULL;
  cledvlab001 = NULL;
  cledvlab003 = NULL;
  _no = 0;
  _rep_hd = NULL;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCcolorEditor);
  WSMFpropertyCreate(WSNreplyHandler,void*,_rep_hd,WSSreplyHandler);

  WSMFpropertyCreateEnd
}
WSMFproperty(WSCcolorEditor,WSNreplyHandler,void*,_rep_hd,NULL);
void WSCcolorEditor::setWorkWSNreplyHandler(void*){
}
void WSCcolorEditor::getWorkWSNreplyHandler(void**){
}
void setvis(WSCbase* target){
  target->setVisible(True);
  WSClistData children = target->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    setvis(child);
  }
}
void setupifd(WSCvifield* ifd){
  ifd->initialize();
  ifd->setInternalObject(True);
  ifd->setPropertyV(WSNcursorPos,(short)4);
  ifd->setPropertyV(WSNshadowType,(char)1);
  ifd->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  ifd->setPropertyV(WSNbottomShadowColor,"gray55");
  ifd->setPropertyV(WSNx,(short)200);
  ifd->setPropertyV(WSNwidth,(WSCushort)60);
  ifd->setPropertyV(WSNheight,(WSCushort)20);
}
void setupsld(WSCvslider* sld){
  sld->initialize();
  sld->setInternalObject(True);
  sld->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  sld->setPropertyV(WSNbottomShadowColor,"gray55");
  sld->setPropertyV(WSNsliderSize,(WSCushort)20);
  sld->setPropertyV(WSNx,(short)270);
  sld->setPropertyV(WSNheight,(WSCushort)20);
}
long WSCcolorEditor::initialize(){
  WSCbaseDialog::initialize();

  clearea1 = new  WSCform(this,"clearea1");
  clearea1->initialize();
  clearea1->setInternalObject(True);
  clearea1->setUserData(WS_BASE_CLASS,(void*)this);
  clearea1->setPropertyV(WSNx,(short)1);
  clearea1->setPropertyV(WSNy,(short)5);
  clearea1->setPropertyV(WSNwidth,(WSCushort)380);
  clearea1->setPropertyV(WSNheight,(WSCushort)135);
  clearea1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  clearea1->setPropertyV(WSNbackColor,"gray80");
  clearea1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
//  clearea1->setPropertyV(WSNtopShadowColor,"gray85");
//  clearea1->setPropertyV(WSNbottomShadowColor,"gray30");
  clearea1->setPropertyV(WSNpixmapStyle,(WSCuchar)1);
  clearea1->setVisible(True);
  WSCprocedure* op_clearea1_0 = new WSCprocedure("new_ep",WSEV_MOUSE_MOVE);
  op_clearea1_0->setFunction(cl_drop,"cl_drop");
  clearea1->addProcedure(op_clearea1_0);
  
  cledvlab000 = new  WSCvlabel(clearea1,"cledvlab000");
  cledvlab000->initialize();
  cledvlab000->setInternalObject(True);
  cledvlab000->setUserData(WS_BASE_CLASS,(void*)this);
  cledvlab000->setPropertyV(WSNbackColor,"#ffffff");
//  cledvlab000->setPropertyV(WSNbottomShadowColor,"gray55");
  cledvlab000->setPropertyV(WSNx,(short)190);
  cledvlab000->setPropertyV(WSNy,(short)105);
  cledvlab000->setPropertyV(WSNwidth,(WSCushort)40);
  cledvlab000->setPropertyV(WSNheight,(WSCushort)20);


  cledvifi001 = new  WSCvifield(clearea1,"cledvifi001");
  setupifd(cledvifi001);
  cledvifi001->setPropertyV(WSNlabelString,"1000");
  cledvifi001->setPropertyV(WSNy,(short)10);
  cledvifi001->setUserData(WS_BASE_CLASS,(void*)this);
  WSCprocedure* op_cledvifi001_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
  op_cledvifi001_0->setFunction(cl_if_set0,"cl_if_set0");
  cledvifi001->addProcedure(op_cledvifi001_0);

  cledvifi002 = new  WSCvifield(clearea1,"cledvifi002");
  setupifd(cledvifi002);
  cledvifi002->setPropertyV(WSNlabelString,"255");
  cledvifi002->setPropertyV(WSNy,(short)30);
  cledvifi002->setUserData(WS_BASE_CLASS,(void*)this);
  WSCprocedure* op_cledvifi002_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
  op_cledvifi002_0->setFunction(cl_if_set1,"cl_if_set1");
  cledvifi002->addProcedure(op_cledvifi002_0);

  cledvifi003 = new  WSCvifield(clearea1,"cledvifi003");
  setupifd(cledvifi003);
  cledvifi003->setPropertyV(WSNlabelString,"255");
  cledvifi003->setPropertyV(WSNy,(short)50);
  cledvifi003->setUserData(WS_BASE_CLASS,(void*)this);
  WSCprocedure* op_cledvifi003_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
  op_cledvifi003_0->setFunction(cl_if_set2,"cl_if_set2");
  cledvifi003->addProcedure(op_cledvifi003_0);

  cledvifi004 = new  WSCvifield(clearea1,"cledvifi004");
  setupifd(cledvifi004);
  cledvifi004->setPropertyV(WSNlabelString,"255");
  cledvifi004->setPropertyV(WSNy,(short)70);
  cledvifi004->setUserData(WS_BASE_CLASS,(void*)this);
  WSCprocedure* op_cledvifi004_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
  op_cledvifi004_0->setFunction(cl_if_set3,"cl_if_set3");
  cledvifi004->addProcedure(op_cledvifi004_0);

  cledvsli001 = new  WSCvslider(clearea1,"cledvsli001");
  setupsld(cledvsli001);
  cledvsli001->setUserData(WS_BASE_CLASS,(void*)this);
  cledvsli001->setPropertyV(WSNdragInterval,(WSCushort)10);
  cledvsli001->setPropertyV(WSNy,(short)10);
  cledvsli001->setPropertyV(WSNvalue,(short)1000);
  WSCprocedure* op_cledvsli001_0 = new WSCprocedure("Edit the color settings",WSEV_VALUE_CH);
  op_cledvsli001_0->setFunction(cl_chop,"cl_chop");
  cledvsli001->addProcedure(op_cledvsli001_0);

  cledvsli002 = new  WSCvslider(clearea1,"cledvsli002");
  setupsld(cledvsli002);
  cledvsli002->setUserData(WS_BASE_CLASS,(void*)this);
  cledvsli002->setPropertyV(WSNy,(short)30);
  cledvsli002->setPropertyV(WSNmaximum,(short)255);
  cledvsli002->setPropertyV(WSNvalue,(short)255);
  WSCprocedure* op_cledvsli002_0 = new WSCprocedure("new_ep",WSEV_VALUE_CH);
  op_cledvsli002_0->setFunction(cl_chop,"cl_chop");
  cledvsli002->addProcedure(op_cledvsli002_0);

  cledvsli003 = new  WSCvslider(clearea1,"cledvsli003");
  setupsld(cledvsli003);
  cledvsli003->setUserData(WS_BASE_CLASS,(void*)this);
  cledvsli003->setPropertyV(WSNy,(short)50);
  cledvsli003->setPropertyV(WSNmaximum,(short)255);
  cledvsli003->setPropertyV(WSNvalue,(short)255);
  WSCprocedure* op_cledvsli003_0 = new WSCprocedure("new_ep",WSEV_VALUE_CH);
  op_cledvsli003_0->setFunction(cl_chop,"cl_chop");
  cledvsli003->addProcedure(op_cledvsli003_0);

  cledvsli004 = new  WSCvslider(clearea1,"cledvsli004");
  setupsld(cledvsli004);
  cledvsli004->setUserData(WS_BASE_CLASS,(void*)this);
  cledvsli004->setPropertyV(WSNy,(short)70);
  cledvsli004->setPropertyV(WSNmaximum,(short)255);
  cledvsli004->setPropertyV(WSNvalue,(short)255);
  WSCprocedure* op_cledvsli004_0 = new WSCprocedure("new_ep",WSEV_VALUE_CH);
  op_cledvsli004_0->setFunction(cl_chop,"cl_chop");
  cledvsli004->addProcedure(op_cledvsli004_0);

  cledvlab001 = new  WSCvifield(clearea1,"cledvlab001");
  cledvlab001->initialize();
  cledvlab001->setInternalObject(True);
  cledvlab001->setUserData(WS_BASE_CLASS,(void*)this);
  cledvlab001->setPropertyV(WSNcolumns,(WSCushort)10);
  cledvlab001->setPropertyV(WSNinterCur,(WSCbool)1);
  cledvlab001->setPropertyV(WSNshadowType,(char)1);
  cledvlab001->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  cledvlab001->setPropertyV(WSNbottomShadowColor,"gray55");
  cledvlab001->setPropertyV(WSNlabelString,"#ffffff");
  cledvlab001->setPropertyV(WSNx,(short)290);
  cledvlab001->setPropertyV(WSNy,(short)105);
  cledvlab001->setPropertyV(WSNwidth,(WSCushort)80);
  cledvlab001->setPropertyV(WSNheight,(WSCushort)20);

  WSCprocedure* op_cledvlab001_0 = new WSCprocedure("new_ep",WSEV_ACTIVATE);
  op_cledvlab001_0->setFunction(cl_ifname_set,"cl_ifname_set");
  cledvlab001->addProcedure(op_cledvlab001_0);

  WSCvlabel* cledvlab002 = new  WSCvlabel(clearea1,"cledvlab002");
  cledvlab002->initialize();
  cledvlab002->setInternalObject(True);
  cledvlab002->setUserData(WS_BASE_CLASS,(void*)this);
  cledvlab002->setPropertyV(WSNshadowType,(char)1);
  cledvlab002->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  cledvlab002->setPropertyV(WSNbottomShadowColor,"gray55");
  cledvlab002->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/cmap.xpm");
  cledvlab002->setPropertyV(WSNx,(short)12);
  cledvlab002->setPropertyV(WSNy,(short)12);
  cledvlab002->setPropertyV(WSNwidth,(WSCushort)110);
  cledvlab002->setPropertyV(WSNheight,(WSCushort)110);
  WSGFsetMargin(cledvlab002,0);

  cledvlab003 = new  WSCvlabel(clearea1,"cledvlab003");
  cledvlab003->initialize();
  cledvlab003->setInternalObject(True);
  cledvlab003->setUserData(WS_BASE_CLASS,(void*)this);
  cledvlab003->setPropertyV(WSNshadowType,(char)0);
  cledvlab003->setPropertyV(WSNx,(short)64);
  cledvlab003->setPropertyV(WSNy,(short)64);
  cledvlab003->setPropertyV(WSNwidth,(WSCushort)8);
  cledvlab003->setPropertyV(WSNheight,(WSCushort)8);

  WSCvlabel* cledvtex000 = new  WSCvlabel(clearea1,"cledvtex000");
  cledvtex000->initialize();
  cledvtex000->setInternalObject(True);
  cledvtex000->setUserData(WS_BASE_CLASS,(void*)this);
  cledvtex000->setPropertyV(WSNlabelString,WSGFgettext("D3:WSSTR All:"));
  cledvtex000->setPropertyV(WSNx,(short)140);
  cledvtex000->setPropertyV(WSNy,(short)10);
  cledvtex000->setPropertyV(WSNwidth,(WSCushort)50);
  cledvtex000->setPropertyV(WSNheight,(WSCushort)20);
  cledvtex000->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  cledvtex000->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);

  WSCvlabel* cledvtex001 = new  WSCvlabel(clearea1,"cledvtex001");
  cledvtex001->initialize();
  cledvtex001->setInternalObject(True);
  cledvtex001->setUserData(WS_BASE_CLASS,(void*)this);
  cledvtex001->setPropertyV(WSNlabelString,WSGFgettext("E3:WSSTR R:"));
  cledvtex001->setPropertyV(WSNx,(short)140);
  cledvtex001->setPropertyV(WSNy,(short)30);
  cledvtex001->setPropertyV(WSNwidth,(WSCushort)50);
  cledvtex001->setPropertyV(WSNheight,(WSCushort)20);
  cledvtex001->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  cledvtex001->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);

  WSCvlabel* cledvtex005 = new  WSCvlabel(clearea1,"cledvtex005");
  cledvtex005->initialize();
  cledvtex005->setInternalObject(True);
  cledvtex005->setUserData(WS_BASE_CLASS,(void*)this);
  cledvtex005->setPropertyV(WSNlabelString,WSGFgettext("F3:WSSTR G:"));
  cledvtex005->setPropertyV(WSNx,(short)140);
  cledvtex005->setPropertyV(WSNy,(short)50);
  cledvtex005->setPropertyV(WSNwidth,(WSCushort)50);
  cledvtex005->setPropertyV(WSNheight,(WSCushort)20);
  cledvtex005->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  cledvtex005->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);

  WSCvlabel* cledvtex006 = new  WSCvlabel(clearea1,"cledvtex006");
  cledvtex006->initialize();
  cledvtex006->setInternalObject(True);
  cledvtex006->setUserData(WS_BASE_CLASS,(void*)this);
  cledvtex006->setPropertyV(WSNlabelString,WSGFgettext("G3:WSSTR B:"));
  cledvtex006->setPropertyV(WSNx,(short)140);
  cledvtex006->setPropertyV(WSNy,(short)70);
  cledvtex006->setPropertyV(WSNwidth,(WSCushort)50);
  cledvtex006->setPropertyV(WSNheight,(WSCushort)20);
  cledvtex006->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  cledvtex006->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);

  WSCvlabel* cledvtex007 = new  WSCvlabel(clearea1,"cledvtex007");
  cledvtex007->initialize();
  cledvtex007->setInternalObject(True);
  cledvtex007->setUserData(WS_BASE_CLASS,(void*)this);
  cledvtex007->setPropertyV(WSNlabelString,WSGFgettext("H3:WSSTR Color:"));
  cledvtex007->setPropertyV(WSNx,(short)130);
  cledvtex007->setPropertyV(WSNy,(short)105);
  cledvtex007->setPropertyV(WSNwidth,(WSCushort)60);
  cledvtex007->setPropertyV(WSNheight,(WSCushort)20);
  cledvtex007->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);

  WSCvlabel* cledvtex008 = new  WSCvlabel(clearea1,"cledvtex008");
  cledvtex008->initialize();
  cledvtex008->setInternalObject(True);
  cledvtex008->setUserData(WS_BASE_CLASS,(void*)this);
  cledvtex008->setPropertyV(WSNlabelString,WSGFgettext("I3:WSSTR Name:"));
  cledvtex008->setPropertyV(WSNx,(short)230);
  cledvtex008->setPropertyV(WSNy,(short)105);
  cledvtex008->setPropertyV(WSNwidth,(WSCushort)60);
  cledvtex008->setPropertyV(WSNheight,(WSCushort)20);
  cledvtex008->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);

  WSCvlabel* WSCvlab000 = new  WSCvlabel(clearea1,"WSCvlab000");
  WSCvlab000->initialize();
  WSCvlab000->setInternalObject(True);
  WSCvlab000->setUserData(WS_BASE_CLASS,(void*)this);
  WSCvlab000->setPropertyV(WSNshadowType,(char)1);
  WSCvlab000->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  WSCvlab000->setPropertyV(WSNx,(short)130);
  WSCvlab000->setPropertyV(WSNy,(short)97);
  WSCvlab000->setPropertyV(WSNwidth,(WSCushort)250);
  WSCvlab000->setPropertyV(WSNheight,(WSCushort)2);

  WSCmessageDialog* clemdialog = new  WSCmessageDialog(this,"clemdialog");
  clemdialog->initialize();
  clemdialog->setInternalObject(True);
  clemdialog->setPropertyV(WSNwidth,(WSCushort)400);
  clemdialog->setPropertyV(WSNheight,(WSCushort)120);
  clemdialog->setPropertyV(WSNshadowThickness,(WSCuchar)1);

  setUserData(WS_BASE_CLASS,(void*)this);
  setPropertyV(WSNx,(short)400);
  setPropertyV(WSNy,(short)400);
  setPropertyV(WSNwidth,(WSCushort)390);
  setPropertyV(WSNheight,(WSCushort)180);
  setPropertyV(WSNshadowThickness,(WSCuchar)1);
  setPropertyV(WSNtitleBar,(char)2);
  setPropertyV(WSNtitleString,"ColorEditor");
  setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi25.xpm");

  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());

  setvis(clearea1);
  return WS_NO_ERR;
}

WSCcolorEditor::~WSCcolorEditor(){
}

WSDcolor* WSCcolorEditor::color = NULL;

void WSCcolorEditor::_set_color_name(char* cname){
//WSMFtrace("WSCcolorEditor::_set_color_name %s\n",cname);
  if (color == NULL){
    color = WSGIappColorSet()->getColor((short)0);
    if (color == NULL){
      color = WSGIappColorSet()->getNewColor();
      color->setId(0);
      WSGIappColorSet()->addColor(color);
    }
  }
  if (color == NULL){
    return;
  }
  color->setUsePrivateCell(True);
  color->setColorName(cname);
  cledvlab000->setPropertyV(WSNbackColor,(short)0);
  cledvlab000->setAbsoluteDraw(True);
  cledvlab000->draw();
  cledvlab001->setPropertyV(WSNlabelString,cname);
  cledvlab001->setAbsoluteDraw(True);
  cledvlab001->draw();
}

void WSCcolorEditor::cl_if_set0(WSCbase* object){
  WSCcolorEditor* base = (WSCcolorEditor*)object->getUserData(WS_BASE_CLASS);
  short val = atoi(object->getProperty(WSNlabelString));
  base->cledvsli001->setPropertyV(WSNvalue,val);
}
void WSCcolorEditor::cl_if_set1(WSCbase* object){
  WSCcolorEditor* base = (WSCcolorEditor*)object->getUserData(WS_BASE_CLASS);
  short val = atoi(object->getProperty(WSNlabelString));
  base->cledvsli002->setPropertyV(WSNvalue,val);
}
void WSCcolorEditor::cl_if_set2(WSCbase* object){
  WSCcolorEditor* base = (WSCcolorEditor*)object->getUserData(WS_BASE_CLASS);
  short val = atoi(object->getProperty(WSNlabelString));
  base->cledvsli003->setPropertyV(WSNvalue,val);
}
void WSCcolorEditor::cl_if_set3(WSCbase* object){
  WSCcolorEditor* base = (WSCcolorEditor*)object->getUserData(WS_BASE_CLASS);
  short val = atoi(object->getProperty(WSNlabelString));
  base->cledvsli004->setPropertyV(WSNvalue,val);
}

void WSCcolorEditor::cl_ifname_set(WSCbase* object){
  WSCcolorEditor* base = (WSCcolorEditor*)object->getUserData(WS_BASE_CLASS);
  WSCstring str;
  str.setString(object->getProperty(WSNlabelString));
  str.delHeadSpace();
  str.delTailSpace();
  base->setColorName(str.getString());
}

void WSCcolorEditor::cl_set(WSCbase* object){
  WSCcolorEditor* base = (WSCcolorEditor*)object->getUserData(WS_BASE_CLASS);
  void* rp = NULL;
  long data;
  base->getPropertyV(WSNreplyHandler,&rp);
  base->getPropertyV(WSNuserValue,&data);
  base->setVisible(False);
  if (rp != NULL){
    void (*hd)(WSCcolorEditor*,void*) = (void(*)(WSCcolorEditor*,void*))rp;
    hd(base,(void*)data);
  }
}
void WSCcolorEditor::cl_end(WSCbase* object){
  WSCcolorEditor* base = (WSCcolorEditor*)object->getUserData(WS_BASE_CLASS);
  base->setVisible(False);
}



void WSCcolorEditor::cl_chop(WSCbase* object){
  WSCcolorEditor* base = (WSCcolorEditor*)object->getUserData(WS_BASE_CLASS);
  if (base->_slider_not_move == 1){
    return;
  }
  short val1;
  short val2;
  short val3;
  short val4;
  base->cledvsli001->getPropertyV(WSNvalue,&val1);
  base->cledvsli002->getPropertyV(WSNvalue,&val2);
  base->cledvsli003->getPropertyV(WSNvalue,&val3);
  base->cledvsli004->getPropertyV(WSNvalue,&val4);

//WSMFtrace("WSCcolorEditor::cl_chop  %d %d %d %d\n",val1,val2,val3,val4);

  base->cledvifi001->setPropertyV(WSNlabelString,WSGFltoa(val1));
  base->cledvifi002->setPropertyV(WSNlabelString,WSGFltoa(val2));
  base->cledvifi003->setPropertyV(WSNlabelString,WSGFltoa(val3));
  base->cledvifi004->setPropertyV(WSNlabelString,WSGFltoa(val4));

  char buffer[16];
  sprintf(buffer,"#%02x%02x%02x",(val2*val1)/1000,(val3*val1)/1000,(val4*val1)/1000);
//WSMFtrace("WSCcolorEditor::cl_chop   %s\n",buffer);
  base->_set_color_name(buffer);

  short posx = (short)(_X_OFF + _DIS * ( (val4-val3) * cos( 3.1415 /6)  )/255);
  short posy = (short)(_Y_OFF + _DIS * ( (val4+val3) * sin( 3.1415 /6) - val2 )/255);

  base->cledvlab003->setVisible(False);
  base->cledvlab003->setPropertyV(WSNx,posx);
  base->cledvlab003->setPropertyV(WSNy,posy);
  base->cledvlab003->setVisible(True);

}

void WSCcolorEditor::cl_drop(WSCbase* object){
  WSCcolorEditor* base = (WSCcolorEditor*)object->getUserData(WS_BASE_CLASS);
  base->cledvlab003->redraw();
  if (WSGIappMouse()->getStatus() != WS_MOUSE_BTN1){
    return;
  } 

  short px,py;
  short angle1 = 0;
  short angle2 = 0;
  WSGIappMouse()->getMousePosition(&px,&py,base->clearea1);
  if (abs( px - _X_OFF) < (_DIS+30) && abs(py - _Y_OFF) < (_DIS+30)){
    double dis2 = (px - _X_OFF) * (px -_X_OFF) + (py - _Y_OFF)*(py - _Y_OFF);
    double dis = sqrt(dis2);
    angle1 = (short)(acos( (double)(px-_X_OFF)/dis ) * 180 / 3.1415);
    angle2 = (short)(asin( (double)(py-_Y_OFF)/dis ) * 180 / 3.1415);
    if (angle2 > 0){
      angle1 = 360 -angle1;
    }

    short val1;
    short val2;
    short val3;
    short val4;
    dis = dis * 256 / _DIS;
    if (dis > 255){
      dis = 255;
    }
    base->cledvsli001->getPropertyV(WSNvalue,&val1);
    if (30 <= angle1  && angle1< 90 ){
       double tmp =  1.5 - angle1/60.0; //30->1 90 ->0
       val2 = (short)255 ;
       val3 = (short)(255 * (1 - dis/255.0));
       val4 = (short)(val2 * tmp + val3* (1-tmp));
    }else 
    if (90 <= angle1  && angle1< 150 ){
       double tmp =  angle1/60.0 -1.5; //90->0 150->1
       val2 = (short)255 ;
       val4 = (short)(255 * (1 - dis/255.0));
       val3 = (short)(val2 * tmp + val4 *(1-tmp));
    }else 
    if (150 <= angle1  && angle1< 210 ){
       double tmp =  angle1/60.0 -2.5; //150->0 210->1
       val4 = (short)(255 * (1 - dis/255.0));
       val3 = (short)255 ;
       val2 = (short)(val4 * tmp + val3 * (1- tmp));
    }else 
    if (210 <= angle1  && angle1< 270 ){
       double tmp =  angle1/60.0 -3.5; //210->0 270->1
       val2 = (short)(255 * (1 - dis/255.0));
       val3 = (short)255 ;
       val4 = (short)(val3 * tmp + val2 * (1 - tmp));
    }else 
    if (270 <= angle1  && angle1< 330 ){
       double tmp = -angle1/60.0 +5.5; //270->1 330->0
       val2 = (short)(255 * (1 - dis/255.0));
       val4 = (short)255 ;
       val3 = (short)(val4 * tmp + val2 * (1 - tmp));
    }else {
       if (angle1 >=330){
          angle1 -= 360;
       }
       double tmp = -angle1/60.0 + 0.5; //-30->1 30->0
       val4 = (short)255 ;
       val3 = (short)(255 * (1 - dis/255.0));
       val2 = (short)(val3 * tmp + val4 * (1-tmp));
    }

    short posx = (short)(_X_OFF + _DIS * ( (val4-val3) * cos( 3.1415 /6)  )/255);
    short posy = (short)(_Y_OFF + _DIS * ( (val4+val3) * sin( 3.1415 /6) - val2 )/255);

//printf("xy=%d,%d\n",posx,posy);
    base->cledvlab003->clear();
    base->cledvlab003->setVisible(False);
    base->cledvlab003->setPropertyV(WSNx,posx);
    base->cledvlab003->setPropertyV(WSNy,posy);
    base->cledvlab003->setVisible(True);
    base->cledvlab003->redraw();

    base->cledvsli002->setPropertyV(WSNvalue,val2);
    base->cledvsli003->setPropertyV(WSNvalue,val3);
    base->cledvsli004->setPropertyV(WSNvalue,val4);
    base->cledvifi002->setPropertyV(WSNlabelString,WSGFltoa(val2));
    base->cledvifi003->setPropertyV(WSNlabelString,WSGFltoa(val3));
    base->cledvifi004->setPropertyV(WSNlabelString,WSGFltoa(val4));
    char buffer[16];
    sprintf(buffer,"#%02x%02x%02x",(val2*val1)/1000,(val3*val1)/1000,(val4*val1)/1000);
    base->_set_color_name(buffer);
  }

}

char* WSCcolorEditor::getColorName(){
  WSCstring str;
  str.setString( cledvlab001->getProperty(WSNlabelString) );
  str.delHeadSpace();
  str.delTailSpace();
  cledvlab001->setPropertyV(WSNlabelString,str.getString());
static char buffer[128];
  strcpy(buffer,str.getString());
  return buffer;
}

void WSCcolorEditor::setColorName(char* cname){
//WSMFtrace("WSCcolorEditor::setColorName() start\n");
  _set_color_name(cname);
  long r,g,b;
  color->getRGB(&r,&g,&b);
  _slider_not_move = 1;
  cledvsli001->setPropertyV(WSNvalue,(short)1000);
  cledvsli002->setPropertyV(WSNvalue,(short)r);
  cledvsli003->setPropertyV(WSNvalue,(short)g);
  cledvsli004->setPropertyV(WSNvalue,(short)b);
  _slider_not_move = 0;
  cl_chop(cledvsli001);
//WSMFtrace("WSCcolorEditor::setColorName() done.\n");
  return;
}

void WSCcolorEditor::adjustForm(){
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }

  if (_w > 2){
    clearea1->setPropertyV(WSNwidth,(WSCushort)(_w -2));
  }else{
    clearea1->setPropertyV(WSNwidth,(WSCushort)(1));
  }

  if (_h+diff > 45){
    clearea1->setPropertyV(WSNheight,(WSCushort)(_h+diff -45));
  }else{
    clearea1->setPropertyV(WSNwidth,(WSCushort)(1));
  }
}
void WSCcolorEditor::onActivate(){
  WSCbaseDialog::onActivate();
  if (getStatus() != WS_DIALOG_CANCEL){
    _popuped = 0;
    setVisible(False);
  }
}
void WSCcolorEditor::onGuiPolicyChange(long policy){
  if ( clearea1 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_ORIGINAL){
      clearea1->setProperty(WSNy,5);
      clearea1->setProperty(WSNshadowThickness,1);
    }else{
      clearea1->setProperty(WSNy,0);
      clearea1->setProperty(WSNshadowThickness,0);
    }
    adjustForm();
  }
}
