//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCscrForm.h>
#include <WSCvlabel.h>
#include <WSCvtoggle.h>
#include <WSCvifield.h>
#include <WSCvbtn.h>
#include <WSDkeyboard.h>
#include <WSCimageSet.h>
#include <WSDfileSystem.h>
#include <WSDfile.h>
#include <WSDdragDrop.h>
#include <WSCbaseList.h>
#include <WSCcolorSet.h>
#include <WSCvfbtn.h>
#include <WSCvline.h>
#include <WSCballoonHelp.h>
#include <WSCmessageDialog.h>
#include <WSCindexForm.h>
#include <advance/WSCcolorSelect.h>
#include <advance/WSCcolorEditor.h>

static char* pixmaps[] = {
WS_PIXMAP_DIR "wcreate.xpm",
WS_PIXMAP_DIR "edit.xpm",
WS_PIXMAP_DIR "wtrash.xpm",
};
static char* bhelpstr[] = {
"J3:WSSTR Add user color",
"K3:WSSTR Edit user color",
"L3:WSSTR Delete user color"
"",
"",
""
};

WSCeventProc WSCcolorSelect::evprocs[] = {
  WSCcolorSelect::_btn1_work,
  WSCcolorSelect::_btn2_work,
  WSCcolorSelect::_btn3_work,
  NULL,
  NULL,
  NULL
};




#define WS_COLORS_PIX    WS_PIXMAP_DIR "bi25.xpm"
#define WS_TB_OFX       10

#define WS_TB_WIDTH     650
#define WS_TB_HEIGHT    300
#define WS_TB_SCRHEIGHT 800
#define WS_TB_T         18
#define WS_TB_H         18
#define WS_TB_W         24
#define WS_TB_X         8
#define WS_TB_Y         8
#define WS_TB_COL       8

WSMFguiClassInitialize(WSCcolorSelect,WSCbaseDialog);
static WSCcolorSelect* _the_app_color_select = NULL;
WSCcolorSelect* WSGIappColorSelect(){
  if (_the_app_color_select == NULL){
    _the_app_color_select = new WSCcolorSelect(NULL,"AppColorSelect");
    _the_app_color_select->initialize();
//    _the_app_color_select->setPropertyV(WSNmodal,(WSCbool)True);
  }
  return _the_app_color_select;
}

WSCcolorSelect::WSCcolorSelect(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){
  _init = 0;
  _area = NULL;
  _set_btn = NULL;
  _scr_area = NULL;
  _color_show = NULL;
//  _use_table = NULL;
//  _table_no = 0;
  _no = 0;
  _w = WS_TB_WIDTH;
  _h = WS_TB_HEIGHT;
  _message = NULL;
  _work_proc = NULL;

  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNreplyHandler,  void*,_work_proc,WSSreplyHandler );
  WSMFpropertyCreateEnd
}

WSMFproperty( WSCcolorSelect, WSNreplyHandler, void*, _work_proc, NULL);

void WSCcolorSelect::setWorkWSNreplyHandler(void* /*data*/){
}

void WSCcolorSelect::getWorkWSNreplyHandler(void** /*data*/){
}
void WSCcolorSelect::setWorkWSNwidth(WSCushort w){
  WSCbaseDialog::setWorkWSNwidth(w);
  _adjust();
}
void WSCcolorSelect::setWorkWSNheight(WSCushort h){
  WSCbaseDialog::setWorkWSNheight(h);
  _adjust();
}

#if 0
void WSCcolorSelect::_color_edit_callback(WSCcleSel* ,void* data){
  WSCcolorSelect* cs = (WSCcolorSelect*)data;
  cs->_scr_area->redraw();
  cs->_color_show->redraw();
  WSDcolor* col = WSGIappColorSet()->getColor(1);
  if (col != NULL){
    col->restartBlinkServer();
  }
}
#endif

void WSCcolorSelect::updateList(){
  if (_init != False){
    return;
  }
  _init = True;
  long i = 0;
  long j = 0;
  long k = 0;
  for(i=0; i<5; i++){
    for(j=0; j<5; j++){
      for(k=0; k<5; k++){
//WSMFtrace("WSCcolorSelect::updateList %d %d %d\n",i,j,k);
        WSCvbtn* lb = new WSCvbtn(_scr_area,"TBlb");
        lb->initialize();
        lb->setVisible(False);
        lb->setInternalObject(True);
        lb->setPropertyV(WSNx,(short)( WS_TB_X + WS_TB_W * k + WS_TB_W * 5 *i));
        lb->setPropertyV(WSNy,(short)( WS_TB_Y + WS_TB_H * j));
        lb->setPropertyV(WSNwidth, (WSCushort)(WS_TB_W-1) );
        lb->setPropertyV(WSNheight,(WSCushort)(WS_TB_H-1) );
        lb->setPropertyV(WSNshadowThickness,(WSCuchar)1);
        lb->setUserData("COLOR SELECT",(void*)this);
        WSGFsetMargin(lb,0);
        char col[64];
        char tcol[64];
        char bcol[64];
        long r =64*i;
        long g =64*j;
        long b =64*k;
        long tr =64*(i+1);
        long tg =64*(j+1);
        long tb =64*(k+1);
        long br =64*(i-1);
        long bg =64*(j-1);
        long bb =64*(k-1);

        if (r > 255) r = 255;
        if (g > 255) g = 255;
        if (b > 255) b = 255;

        if (tr > 255) tr = 255;
        if (tg > 255) tg = 255;
        if (tb > 255) tb = 255;

        if (br < 0) br = 0;
        if (bg < 0) bg = 0;
        if (bb < 0) bb = 0;

        sprintf(col,"#%02x%02x%02x",r,g,b);
        sprintf(tcol,"#%02x%02x%02x",tr,tg,tb);
        sprintf(bcol,"#%02x%02x%02x",br,bg,bb);
        lb->setPropertyV(WSNbackColor,col);
        lb->setPropertyV(WSNtopShadowColor,tcol);
        lb->setPropertyV(WSNbottomShadowColor,bcol);

        WSCprocedure* inop = new WSCprocedure("in op",WSEV_ACTIVATE);
        inop->setFunction(_label_push_work,"_label_push_work");
        lb->addProcedure(inop);
        lb->setVisible(True);
      }
    }
  }
  for(i=0; i<25; i++){
//WSMFtrace("WSCcolorSelect::updateList %d %d %d\n",i,j,k);
    WSCvlabel* lb = new WSCvbtn(_scr_area,"TBlb");
    lb->initialize();
    lb->setVisible(False);
    lb->setInternalObject(True);
    lb->setPropertyV(WSNx,(short)( WS_TB_X + WS_TB_W * i));
    lb->setPropertyV(WSNy,(short)( WS_TB_Y + WS_TB_H * 5));
    lb->setPropertyV(WSNwidth, (WSCushort)(WS_TB_W-1) );
    lb->setPropertyV(WSNheight,(WSCushort)(WS_TB_H-1) );
    lb->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    lb->setUserData("COLOR SELECT",(void*)this);
    WSGFsetMargin(lb,0);
    char col[64];
    char tcol[64];
    char bcol[64];
    long g =10*i;
    long tg =10*(i+4);
    long bg =10*(i-4);
    if (g > 249) g = 255;
    if (tg > 249) tg = 255;
    if (bg < 0) bg = 0;

    sprintf(col,"#%02x%02x%02x",g,g,g);
    sprintf(tcol,"#%02x%02x%02x",tg,tg,tg);
    sprintf(bcol,"#%02x%02x%02x",bg,bg,bg);
    lb->setPropertyV(WSNbackColor,col);
    lb->setPropertyV(WSNtopShadowColor,tcol);
    lb->setPropertyV(WSNbottomShadowColor,bcol);

    WSCprocedure* inop = new WSCprocedure("in op",WSEV_ACTIVATE);
    inop->setFunction(_label_push_work,"_label_push_work");
    lb->addProcedure(inop);
    lb->setVisible(True);
  }

}

WSCcolorSelect::~WSCcolorSelect(){
}


void WSCcolorSelect::_label_push_work(WSCbase* obj){
  WSCcolorSelect* fs = (WSCcolorSelect*)obj->getUserData("COLOR SELECT");

  short cno;
  obj->getPropertyV(WSNtopShadowColor,&cno);
  fs->_color_show->setPropertyV(WSNtopShadowColor,cno);

  obj->getPropertyV(WSNbackColor,&cno);
  fs->_color_show->setPropertyV(WSNbackColor,cno);

  obj->getPropertyV(WSNbottomShadowColor,&cno);
  fs->_color_show->setPropertyV(WSNbottomShadowColor,cno);

  WSCstring cname(obj->getProperty(WSNbackColor));
  fs->_color_name->setProperty(WSNlabelString,cname);

//WSMFtrace("WSCcolorSelect::_lb_work 1 #%s#\n", obj->getProperty(WSNtopShadowColor));
//WSMFtrace("WSCcolorSelect::_lb_work 2 #%s#\n", obj->getProperty(WSNbackColor));
//WSMFtrace("WSCcolorSelect::_lb_work 3 #%s#\n", obj->getProperty(WSNbottomShadowColor));
  fs->_color_show->update();
}

//short WSCcolorSelect::getTableNo(){
//  return (_table_no*3 +1);
//}

void WSCcolorSelect::_set_btn_work(WSCbase* obj){
  WSCcolorSelect* fs = (WSCcolorSelect*)obj->getUserData("COLOR SELECT");
  void (*hd)(WSCcolorSelect*,void*);
  void* data;
  void* hdp;
  fs->getPropertyV(WSNuserValue,(long*)&data);
  fs->getPropertyV(WSNreplyHandler,&hdp);
  hd = (void(*)(WSCcolorSelect*,void*))hdp;
  fs->setVisible(False);
  if (hd != NULL){
    hd(fs,data);
    WSGIappObjectList()->execUpdate();
  }
  fs->setVisible(False);
}
long WSCcolorSelect::initialize(){
  WSCbaseDialog::initialize();

  _area = new WSCform(this,"cs-area");
  _area->initialize();
  _area->setInternalObject(True);
  _area->setPropertyV(WSNx,(short)1);
  _area->setPropertyV(WSNy,(short)5);
  _area->setPropertyV(WSNwidth, (WSCushort)(WS_TB_WIDTH -2));
  _area->setPropertyV(WSNheight,(WSCushort)(WS_TB_HEIGHT -45));
  _area->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _area->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _area->setVisible(True);

  _index_area = new WSCindexForm(_area,"cs-area2");
  _index_area->initialize();
  _index_area->setInternalObject(True);
  _index_area->setPropertyV(WSNx,(short)5);
  _index_area->setPropertyV(WSNy,(short)35);
  _index_area->setPropertyV(WSNwidth, (WSCushort)(WS_TB_WIDTH -10));
  _index_area->setPropertyV(WSNheight,(WSCushort)(WS_TB_HEIGHT -85));
  _index_area->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _index_area->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _index_area->setProperty(WSNmenuItems,WSGFgettext("M3:WSSTR Default colors,Standard colors,User defined colors"));
  _index_area->setVisible(True);

  long i;
  for(i=0; i<3; i++){
    WSCvfbtn* btn = new WSCvfbtn(_index_area,"cs-vfbtn");
    btn->initialize();
    btn->setPropertyV(WSNx,(short)(i* 30 + 5));
    btn->setPropertyV(WSNy,(short)(25));
    btn->setPropertyV(WSNwidth,(WSCushort)(30));
    btn->setPropertyV(WSNheight,(WSCushort)(29));
    btn->setPropertyV(WSNlabelPixmap,pixmaps[i]);
    btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    btn->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    btn->setProperty(WSNuserValue,3);
    WSGFsetMargin(btn,0);
    btn->setUserData("COLOR SELECT",(void*)this); 
    
    WSCprocedure* op1 = new WSCprocedure("op1",WSEV_ACTIVATE);
    op1->setFunction(evprocs[i],"evprocs");
    btn->addProcedure(op1);
    btn->setVisible(True);
    WSGIappBalloonHelp()->registerClient(btn,WSGFgettext(bhelpstr[i]));
  }
  _color_show = new WSCvlabel(_area,"cs-ctitle");
  _color_show->initialize();
  _color_show->setInternalObject(True);
  _color_show->setPropertyV(WSNx,     (short)(60 + WS_TB_OFX));
  _color_show->setPropertyV(WSNy,     (short)6 );
  _color_show->setPropertyV(WSNwidth, (WSCushort)70);
  _color_show->setPropertyV(WSNheight,(WSCushort)20);
  _color_show->setPropertyV(WSNlabelString,"");
  _color_show->setPropertyV(WSNforeColor,"cyan4");
  _color_show->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _color_show->setPropertyV(WSNshadowType,(char)WS_SHADOW_OUT);
  _color_show->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _color_show->setVisible(True);

  _color_name = new WSCvlabel(_area,"cs-cname-lb");
  _color_name->initialize();
  _color_name->setInternalObject(True);
  _color_name->setPropertyV(WSNx,     (short)(200 + WS_TB_OFX) );
  _color_name->setPropertyV(WSNy,     (short)7 );
  _color_name->setPropertyV(WSNwidth, (WSCushort)160);
  _color_name->setPropertyV(WSNheight,(WSCushort)16);
//  _color_name->setPropertyV(WSNbackColor,"gray80");
  _color_name->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _color_name->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _color_name->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _color_name->setVisible(True);
  WSGFsetMargin(_color_name,0);

  WSCvlabel* sp1 = new WSCvlabel(_area,"FS-sp1");
  sp1->initialize();
  sp1->setInternalObject(True);
  sp1->setPropertyV(WSNx,(short)0);
  sp1->setPropertyV(WSNy,(short)30);
  sp1->setPropertyV(WSNwidth, (WSCushort)(1280));
  sp1->setPropertyV(WSNheight,(WSCushort)2);
  sp1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  sp1->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  sp1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  sp1->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  sp1->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  sp1->setVisible(True);

  WSCbase* dtitle = new WSCvlabel(_area,"fs-dtitle");
  dtitle->initialize();
  dtitle->setInternalObject(True);
  dtitle->setPropertyV(WSNx,     (short)(5 + WS_TB_OFX));
  dtitle->setPropertyV(WSNy,     (short)7 );
  dtitle->setPropertyV(WSNwidth, (WSCushort)50);
  dtitle->setPropertyV(WSNheight,(WSCushort)16);
  dtitle->setPropertyV(WSNlabelString,WSGFgettext("H3:WSSTR Color:"));
  dtitle->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  dtitle->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  dtitle->setVisible(True);
  WSGFsetMargin(dtitle,0);

  WSCbase* dtitle2 = new WSCvlabel(_area,"fs-dtitle");
  dtitle2->initialize();
  dtitle2->setInternalObject(True);
  dtitle2->setPropertyV(WSNx,     (short)(135 + WS_TB_OFX) );
  dtitle2->setPropertyV(WSNy,     (short)7 );
  dtitle2->setPropertyV(WSNwidth, (WSCushort)60);
  dtitle2->setPropertyV(WSNheight,(WSCushort)16);
  dtitle2->setPropertyV(WSNlabelString,WSGFgettext("I3:WSSTR Name:"));
  dtitle2->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  dtitle2->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  dtitle2->setVisible(True);
  WSGFsetMargin(dtitle2,0);

  _scr_area0 = new WSCscrForm(_index_area,"fs-area0");
  _scr_area0->initialize();
  _scr_area0->setInternalObject(True);
  _scr_area0->setPropertyV(WSNx,     (short)5 );
  _scr_area0->setPropertyV(WSNy,     (short)31 );
  _scr_area0->setPropertyV(WSNwidth, (WSCushort)(WS_TB_WIDTH -20));
  _scr_area0->setPropertyV(WSNheight,(WSCushort)(WS_TB_HEIGHT - 115));
  _scr_area0->setPropertyV(WSNworkWidth, (WSCushort)(WS_TB_W * 30 + 30));
  _scr_area0->setPropertyV(WSNworkHeight,(WSCushort)(WS_TB_H * 11 + 20));
  _scr_area0->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  _scr_area0->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _scr_area0->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _scr_area0->setPropertyV(WSNscrollHeight,(WSCushort)2);
  _scr_area0->setPropertyV(WSNincrement,(WSCushort)30);
  _scr_area0->setPropertyV(WSNpageIncrement,(WSCushort)100);
  _scr_area0->setProperty(WSNuserValue,1);

  _setup_area1(_scr_area0);

  _scr_area = new WSCscrForm(_index_area,"fs-area2");
  _scr_area->initialize();
  _scr_area->setInternalObject(True);
  _scr_area->setPropertyV(WSNx,     (short)5 );
  _scr_area->setPropertyV(WSNy,     (short)31 );
  _scr_area->setPropertyV(WSNwidth, (WSCushort)(WS_TB_WIDTH -20));
  _scr_area->setPropertyV(WSNheight,(WSCushort)(WS_TB_HEIGHT - 115));
  _scr_area->setPropertyV(WSNworkWidth, (WSCushort)(WS_TB_W * 25 + 20));
  _scr_area->setPropertyV(WSNworkHeight,(WSCushort)(WS_TB_H * 7 + 20));
  _scr_area->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  _scr_area->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _scr_area->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _scr_area->setPropertyV(WSNscrollHeight,(WSCushort)2);
  _scr_area->setPropertyV(WSNincrement,(WSCushort)30);
  _scr_area->setPropertyV(WSNpageIncrement,(WSCushort)100);
  _scr_area->setProperty(WSNuserValue,2);

  _scr_area2 = new WSCscrForm(_index_area,"fs-area3");
  _scr_area2->initialize();
  _scr_area2->setInternalObject(True);
  _scr_area2->setPropertyV(WSNx,     (short)5 );
  _scr_area2->setPropertyV(WSNy,     (short)61 );
  _scr_area2->setPropertyV(WSNwidth, (WSCushort)(WS_TB_WIDTH -20));
  _scr_area2->setPropertyV(WSNheight,(WSCushort)(WS_TB_HEIGHT - 145));
  _scr_area2->setPropertyV(WSNworkWidth, (WSCushort)(WS_TB_W * 25 + 20));
  _scr_area2->setPropertyV(WSNworkHeight,(WSCushort)(WS_TB_H * 7 + 20));
  _scr_area2->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  _scr_area2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _scr_area2->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _scr_area2->setPropertyV(WSNscrollHeight,(WSCushort)2);
  _scr_area2->setPropertyV(WSNincrement,(WSCushort)30);
  _scr_area2->setPropertyV(WSNpageIncrement,(WSCushort)100);
  _scr_area2->setProperty(WSNuserValue,3);


  WSCvlabel* sp2 = new WSCvlabel(_scr_area,"FS-sp1");
  sp2->initialize();
  sp2->setInternalObject(True);
  sp2->setPropertyV(WSNx,(short)(WS_TB_X));
  sp2->setPropertyV(WSNy,(short)( WS_TB_H * 7));
  sp2->setPropertyV(WSNwidth, (WSCushort)(WS_TB_W * 25));
  sp2->setPropertyV(WSNheight,(WSCushort)2);
  sp2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  sp2->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
//  sp2->setPropertyV(WSNbackColor,"gray80");
  sp2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
//  sp2->setPropertyV(WSNtopShadowColor,"gray95");
//  sp2->setPropertyV(WSNbottomShadowColor,"gray45");
  sp2->setProperty(WSNtopShadowColor,WS_DF_TOPSHADOWCOLOR);
  sp2->setProperty(WSNbottomShadowColor,WS_DF_BOTTOMSHADOWCOLOR);
  sp2->setVisible(True);


  _message = new  WSCmessageDialog(this,"clemdialog");
  _message->initialize();
  _message->setInternalObject(True);
  _message->setUserData(WS_BASE_CLASS,(void*)this);
  _message->setPropertyV(WSNwidth,(WSCushort)450);
  _message->setPropertyV(WSNheight,(WSCushort)120);
  _message->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _message->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/bi23.xpm");
  _message->setPropertyV(WSNtitleString,"Message");
  _message->setPropertyV(WSNdefaultPosition,(WSCbool)True);

  updateList();
  setPropertyV(WSNtitleString,WSGFgettext("W3:WSSTR ColorBox"));
  setPropertyV(WSNlabelPixmap,WS_COLORS_PIX);
//  _adjust();
  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());

  return WS_NO_ERR;
}

void WSCcolorSelect::onParentVisibleChange(WSCbool fl){
  WSCbaseDialog::onParentVisibleChange(fl);
  if (fl != False){
//    updateList();
    _scr_area->setPropertyV(WSNhbarValue,(WSCushort)0);
    _scr_area->setPropertyV(WSNvbarValue,(WSCushort)0);
  }
}

void WSCcolorSelect::onVisibleChange(WSCbool fl){
  WSCbaseDialog::onVisibleChange(fl);
  if (fl != False){
//    updateList();
    _scr_area->setPropertyV(WSNhbarValue,(WSCushort)0);
    _scr_area->setPropertyV(WSNvbarValue,(WSCushort)0);
  }else{
//    if (_color_sel != NULL){
//      _color_sel->setVisible(False);
//    }
  }


}

char* WSCcolorSelect::getSelectColor(){
  short cno;
  _color_show->getPropertyV(WSNbackColor,&cno);
  return WSGIappColorSet()->getColorName(cno);
}

char* WSCcolorSelect::getSelectTopShadowColor(){
  short cno;
  _color_show->getPropertyV(WSNtopShadowColor,&cno);
  return WSGIappColorSet()->getColorName(cno);
}

char* WSCcolorSelect::getSelectBottomShadowColor(){
  short cno;
  _color_show->getPropertyV(WSNbottomShadowColor,&cno);
  return WSGIappColorSet()->getColorName(cno);
}

//WSCbool WSCcolorSelect::getUseTable(){
//  return _use_table->getStatus();
//}

//void WSCcolorSelect::setUseTable(WSCbool fl){
//  if (fl != False){
//    fl = True;
//  }
//  _use_table->setStatus(fl,True);
//}
void WSCcolorSelect::onResize(WSCrect* area){
  WSCbaseDialog::onResize(area);
  _adjust();
}

void WSCcolorSelect::_adjust(){
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }

  if (_w > 2){
    _area->setPropertyV(WSNwidth,(WSCushort)(_w -2));
  }else{
    _area->setPropertyV(WSNwidth,(WSCushort)(1));
  }
  if (_w > 10){
    _index_area->setPropertyV(WSNwidth,(WSCushort)(_w -10));
  }else{
    _index_area->setPropertyV(WSNwidth,(WSCushort)(1));
  }
  if (_w > 20){
    _scr_area->setPropertyV(WSNwidth,(WSCushort)(_w -20));
    _scr_area0->setPropertyV(WSNwidth,(WSCushort)(_w -20));
    _scr_area2->setPropertyV(WSNwidth,(WSCushort)(_w -20));
  }else{
    _scr_area->setPropertyV(WSNwidth,(WSCushort)(1));
    _scr_area0->setPropertyV(WSNwidth,(WSCushort)(1));
    _scr_area2->setPropertyV(WSNwidth,(WSCushort)(1));
  }
  if (_h +diff > 45){
    _area->setPropertyV(WSNheight,(WSCushort)(_h +diff -45));
  }else{
    _area->setPropertyV(WSNheight,(WSCushort)(1));
  }
  if (_h +diff > 85){
    _index_area->setPropertyV(WSNheight,(WSCushort)(_h +diff -85));
  }else{
    _index_area->setPropertyV(WSNheight,(WSCushort)(1));
  }
  if (_h +diff > 125){
    _scr_area->setPropertyV(WSNheight,(WSCushort)(_h +diff -125));
    _scr_area0->setPropertyV(WSNheight,(WSCushort)(_h +diff -125));
  }else{
    _scr_area->setPropertyV(WSNheight,(WSCushort)(1));
    _scr_area0->setPropertyV(WSNheight,(WSCushort)(1));
  }
  if (_h +diff > 155){
    _scr_area2->setPropertyV(WSNheight,(WSCushort)(_h +diff -155));
  }else{
    _scr_area2->setPropertyV(WSNheight,(WSCushort)(1));
  }
}
void WSCcolorSelect::onActivate(){
  WSCbaseDialog::onActivate();
  if (getStatus() != WS_DIALOG_CANCEL){
    _popuped = 0;
    setVisible(False);
  }
}
void WSCcolorSelect::_btn1_work(WSCbase* btn){
  WSCcolorSelect* cs = (WSCcolorSelect*)btn->getUserData("COLOR SELECT");
  if (cs == NULL){
    return;
  }
//printf("WSCcolorSelect::_btn1_work...\n");
  long ret = WSGIappColorEditor()->popup();
  if (ret == WS_DIALOG_OK){
    cs->addColorEntry(WSGIappColorEditor()->getColorName());
  }
}
void WSCcolorSelect::_btn2_work(WSCbase* btn){
  WSCcolorSelect* cs = (WSCcolorSelect*)btn->getUserData("COLOR SELECT");
  if (cs == NULL){
    return;
  }
  long i;
  WSCstring cname( cs->getSelectColor() );
  long num = cs->_user_colors.getNum();
  for(i=0; i<num; i++){
    char* cn = (char*)cs->_user_colors[i];
    if (!strcmp(cn,(char*)cname)){
      WSGIappColorEditor()->setColorName(cn);
      long ret = WSGIappColorEditor()->popup();
      if (ret == WS_DIALOG_OK){
        delete cn;
        cs->_user_colors.setData(i,
            WSGFstrdup(WSGIappColorEditor()->getColorName()));
      }
      cs->updateColorEntry();
      return;
    }
  }
  cs->_message->setPropertyV(WSNlabelString,WSGFgettext("N3:WSSTR Please select the user color.")); 
  cs->_message->popup();
}
void WSCcolorSelect::_btn3_work(WSCbase* btn){
  WSCcolorSelect* cs = (WSCcolorSelect*)btn->getUserData("COLOR SELECT");
  if (cs == NULL){
    return;
  }
  WSCstring cname(cs->getSelectColor());
  long i;
  long num = cs->_user_colors.getNum();
  for(i=0; i<num; i++){
    char* cn = (char*)cs->_user_colors[i];
    if (!strcmp(cn,(char*)cname)){
      WSCstring str;
      str << WSGFgettext("O3:WSSTR Delete the selected color: ") << cn
          << WSGFgettext("P3:WSSTR  ?");
      cs->_message->setPropertyV(WSNlabelString,(char*)str);
      long ret = cs->_message->popup();
      if (ret == WS_DIALOG_OK){
        delete cn;
        cs->_user_colors.delPos(i);
        cs->updateColorEntry();
      }
      return;
    }
  }
  cs->_message->setPropertyV(WSNlabelString,WSGFgettext("Q3:WSSTR Please select the user color to delete.")); 
  cs->_message->popup();
}

void WSCcolorSelect::updateColorEntry(){
  long i;
  long num = _user_label_list.getNum();
  for(i=0; i<num; i++){
    WSCvbtn* lb = (WSCvbtn*)_user_label_list[i];
    lb->clear();
    lb->setVisible(False);
  }

  num = _user_colors.getNum();
  for(i=0; i<num; i++){
    char* cn = (char*)_user_colors[i];
    WSCvbtn* lb = (WSCvbtn*)_user_label_list[i];
    if (lb == NULL){
      lb = new WSCvbtn(_scr_area2,"cs-lb");
      lb->initialize();
      _user_label_list.add((void*)lb);
      lb->setVisible(False);
      lb->setInternalObject(True);
      lb->setPropertyV(WSNx,(short)( WS_TB_X + WS_TB_W * (i % 25)));
      lb->setPropertyV(WSNy,(short)( WS_TB_Y + WS_TB_H * (i / 25)));
      lb->setPropertyV(WSNwidth, (WSCushort)(WS_TB_W-1) );
      lb->setPropertyV(WSNheight,(WSCushort)(WS_TB_H-1) );
      lb->setPropertyV(WSNshadowThickness,(WSCuchar)1);
      lb->setUserData("COLOR SELECT",(void*)this);
      lb->setUserData("USER COLOR",(void*)1);
      WSGFsetMargin(lb,0);

      WSCprocedure* inop = new WSCprocedure("in op",WSEV_ACTIVATE);
      inop->setFunction(_label_push_work,"_label_push_work");
      lb->addProcedure(inop);
    }
    lb->setPropertyV(WSNbackColor,cn);
    lb->setVisible(True);
    lb->redraw();
  }
}
void WSCcolorSelect::addColorEntry(char* cn){
  _user_colors.add((void*)WSGFstrdup(cn));
  updateColorEntry();
}
long WSCcolorSelect::delColorEntry(char* cname){
  long i;
  long num = _user_colors.getNum();
  for(i=0; i<num; i++){
    char* cn = (char*)_user_colors[i];
    if (!strcmp(cn,(char*)cname)){
      delete cn;
      _user_colors.delPos(i);
      updateColorEntry();
      return WS_NO_ERR;
    }
  }
  return WS_ERR;
}
long WSCcolorSelect::save(char* fname){
  WSCstring str;
  long i;
  long num = _user_colors.getNum();
  for(i=0; i<num; i++){
    char* cn = (char*)_user_colors[i];
    str << cn << "\n";
  }
  return WSGFreplaceTextFile(fname,(char*)str,False);
}
void WSCcolorSelect::clearColorEntry(){
  long i;
  long num = _user_colors.getNum();
  for(i=0; i<num; i++){
    char* cn = (char*)_user_colors[i];
    delete cn;
  }
  _user_colors.clear();

  updateColorEntry();
}
long WSCcolorSelect::load(char* fname){
  long i;
  long num = _user_colors.getNum();
  for(i=0; i<num; i++){
    char* cn = (char*)_user_colors[i];
    delete cn;
  }
  _user_colors.clear();


  WSCstring* str =  WSGFreadTextFile(fname);
  if (str == NULL){
    return WS_ERR;
  }
  while(str->eof() == False){
    WSCstring line = str->gets();
    line.delHeadSpace();
    line.delTailSpace();
    addColorEntry((char*)line);
  }
  delete str;
  updateColorEntry();
  return WS_OK;
}
void WSCcolorSelect::onGuiPolicyChange(long policy){
  if ( _area != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_ORIGINAL){
      _area->setProperty(WSNy,5);
      _area->setProperty(WSNshadowThickness,1);
      _scr_area->setPropertyV(WSNshadowThickness,(WSCuchar)1);
      _scr_area0->setPropertyV(WSNshadowThickness,(WSCuchar)1);
      _scr_area2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
      _index_area->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else{
      _area->setProperty(WSNy,0);
      _area->setProperty(WSNshadowThickness,0);
      _scr_area->setPropertyV(WSNshadowThickness,(WSCuchar)2);
      _scr_area0->setPropertyV(WSNshadowThickness,(WSCuchar)2);
      _scr_area2->setPropertyV(WSNshadowThickness,(WSCuchar)2);
      _index_area->setPropertyV(WSNshadowThickness,(WSCuchar)2);
    }
    _adjust();
  }
}
void WSCcolorSelect::_setup_dbtn(WSCbase* parent,long pos,
                                 char* col1,char* col2,char* col3){
  WSCvbtn* lb = new WSCvbtn(parent,"cs-lb");
  lb->initialize();
  lb->setInternalObject(True);
  lb->setPropertyV(WSNx,(short)( 405));
  lb->setPropertyV(WSNy,(short)( 5 + (WS_TB_H+2) * pos));
  lb->setPropertyV(WSNwidth, (WSCushort)(WS_TB_W-1) );
  lb->setPropertyV(WSNheight,(WSCushort)(WS_TB_H-1) );
  lb->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  lb->setProperty(WSNbackColor,col1);
  lb->setProperty(WSNtopShadowColor,col2);
  lb->setProperty(WSNbottomShadowColor,col3);
  lb->setUserData("COLOR SELECT",(void*)this);
  lb->setUserData("USER COLOR",(void*)1);
  WSGFsetMargin(lb,0);

  WSCprocedure* inop = new WSCprocedure("in op",WSEV_ACTIVATE);
  inop->setFunction(_label_push_work,"_label_push_work");
  lb->addProcedure(inop);

  lb->setVisible(True);
  lb->redraw();
}
void WSCcolorSelect::_setup_area1(WSCbase* newform_002){

	WSCvlabel* newvlab_003 = new  WSCvlabel(newform_002,"newvlab_003");
	newvlab_003->initialize();
	newvlab_003->setPropertyV(WSNshadowThickness,(unsigned char)0);
	newvlab_003->setPropertyV(WSNlabelPixmap,"$(WSDIR)/sys/pixmaps/win1.xpm");
	newvlab_003->setPropertyV(WSNname,"newvlab_003");
	newvlab_003->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_003->setPropertyV(WSNx,(short)17);
	newvlab_003->setPropertyV(WSNy,(short)2);
	newvlab_003->setPropertyV(WSNwidth,(unsigned short)314);
	newvlab_003->setPropertyV(WSNheight,(unsigned short)140);

	WSCform* newform_004 = new  WSCform(newform_002,"newform_004");
	newform_004->initialize();
	newform_004->setPropertyV(WSNname,"newform_004");
	newform_004->setPropertyV(WSNx,(short)24);
	newform_004->setPropertyV(WSNy,(short)32);
	newform_004->setPropertyV(WSNwidth,(unsigned short)300);
	newform_004->setPropertyV(WSNheight,(unsigned short)25);
	newform_004->setPropertyV(WSNshadowThickness,(unsigned char)0);
	newform_004->setPropertyV(WSNbackColor,"DEF5");
	newform_004->setPropertyV(WSNvis,(WSCbool)1);

	WSCvlabel* newvlab_008 = new  WSCvlabel(newform_004,"newvlab_008");
	newvlab_008->initialize();
	newvlab_008->setPropertyV(WSNshadowType,(char)-1);
	newvlab_008->setPropertyV(WSNshadowThickness,(unsigned char)0);
	newvlab_008->setPropertyV(WSNlabelString,"menu");
	newvlab_008->setPropertyV(WSNname,"newvlab_008");
	newvlab_008->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_008->setProperty(WSNforeColor,WS_DF_MENUFORECOLOR);
	newvlab_008->setPropertyV(WSNwidth,(unsigned short)80);
	newvlab_008->setPropertyV(WSNheight,(unsigned short)25);

	WSCvlabel* newvlab_009 = new  WSCvlabel(newform_004,"newvlab_009");
	newvlab_009->initialize();
	newvlab_009->setPropertyV(WSNshadowType,(char)1);
	newvlab_009->setPropertyV(WSNshadowThickness,(unsigned char)0);
	newvlab_009->setPropertyV(WSNbackColor,"DEF7");
	newvlab_009->setPropertyV(WSNlabelString,"selected");
	newvlab_009->setPropertyV(WSNname,"newvlab_009");
	newvlab_009->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_009->setProperty(WSNforeColor,WS_DF_MENUSELECTFORECOLOR);
	newvlab_009->setPropertyV(WSNx,(short)80);
	newvlab_009->setPropertyV(WSNwidth,(unsigned short)80);
	newvlab_009->setPropertyV(WSNheight,(unsigned short)25);

	WSCvline* newvlin_011 = new  WSCvline(newform_004,"newvlin_011");
	newvlin_011->initialize();
	newvlin_011->setPropertyV(WSNlineX,"0,10,300");
	newvlin_011->setPropertyV(WSNlineY,"30,5,5");
	newvlin_011->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_011->setPropertyV(WSNname,"newvlin_011");
	newvlin_011->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_011->setPropertyV(WSNx,(short)50);
	newvlin_011->setPropertyV(WSNwidth,(unsigned short)300);
	newvlin_011->setPropertyV(WSNheight,(unsigned short)12);

	WSCvline* newvlin_013 = new  WSCvline(newform_004,"newvlin_013");
	newvlin_013->initialize();
	newvlin_013->setPropertyV(WSNlineX,"0,5,300");
	newvlin_013->setPropertyV(WSNlineY,"5,5,5");
	newvlin_013->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_013->setPropertyV(WSNname,"newvlin_013");
	newvlin_013->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_013->setPropertyV(WSNx,(short)140);
	newvlin_013->setPropertyV(WSNy,(short)15);
	newvlin_013->setPropertyV(WSNwidth,(unsigned short)300);
	newvlin_013->setPropertyV(WSNheight,(unsigned short)12);

	WSCform* newform_005 = new  WSCform(newform_002,"newform_005");
	newform_005->initialize();
	newform_005->setPropertyV(WSNname,"newform_005");
	newform_005->setPropertyV(WSNx,(short)24);
	newform_005->setPropertyV(WSNy,(short)57);
	newform_005->setPropertyV(WSNwidth,(unsigned short)300);
	newform_005->setPropertyV(WSNheight,(unsigned short)75);
	newform_005->setPropertyV(WSNshadowThickness,(unsigned char)0);
	newform_005->setPropertyV(WSNvis,(WSCbool)1);

	WSCscrForm* newscrF_006 = new  WSCscrForm(newform_005,"newscrF_006");
	newscrF_006->initialize();
	newscrF_006->setPropertyV(WSNname,"newscrF_006");
	newscrF_006->setPropertyV(WSNx,(short)2);
	newscrF_006->setPropertyV(WSNy,(short)3);
	newscrF_006->setPropertyV(WSNwidth,(unsigned short)153);
	newscrF_006->setPropertyV(WSNheight,(unsigned short)70);
	newscrF_006->setPropertyV(WSNvis,(WSCbool)1);

	WSCvbtn* newvbtn_007 = new  WSCvbtn(newform_005,"newvbtn_007");
	newvbtn_007->initialize();
	newvbtn_007->setPropertyV(WSNlabelString,"TEXT");
	newvbtn_007->setPropertyV(WSNname,"newvbtn_007");
	newvbtn_007->setPropertyV(WSNvis,(WSCbool)1);
	newvbtn_007->setPropertyV(WSNx,(short)191);
	newvbtn_007->setPropertyV(WSNy,(short)5);

	WSCvline* newvlin_016 = new  WSCvline(newform_005,"newvlin_016");
	newvlin_016->initialize();
	newvlin_016->setPropertyV(WSNlineX,"0,10,100");
	newvlin_016->setPropertyV(WSNlineY,"0,18,18");
	newvlin_016->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_016->setPropertyV(WSNname,"newvlin_016");
	newvlin_016->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_016->setPropertyV(WSNx,(short)250);
	newvlin_016->setPropertyV(WSNy,(short)20);

	WSCvline* newvlin_017 = new  WSCvline(newform_005,"newvlin_017");
	newvlin_017->initialize();
	newvlin_017->setPropertyV(WSNlineX,"0,5,100");
	newvlin_017->setPropertyV(WSNlineY,"10,25,25");
	newvlin_017->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_017->setPropertyV(WSNname,"newvlin_017");
	newvlin_017->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_017->setPropertyV(WSNx,(short)240);
	newvlin_017->setPropertyV(WSNy,(short)33);

	WSCvline* newvlin_020 = new  WSCvline(newform_005,"newvlin_020");
	newvlin_020->initialize();
	newvlin_020->setPropertyV(WSNlineX,"0,100");
	newvlin_020->setPropertyV(WSNlineY,"8,8");
	newvlin_020->setPropertyV(WSNlineNum,(unsigned char)2);
	newvlin_020->setPropertyV(WSNname,"newvlin_020");
	newvlin_020->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_020->setPropertyV(WSNx,(short)270);
	newvlin_020->setPropertyV(WSNy,(short)10);

	WSCvline* newvlin_025 = new  WSCvline(newform_005,"newvlin_025");
	newvlin_025->initialize();
	newvlin_025->setPropertyV(WSNlineX,"0,10,200");
	newvlin_025->setPropertyV(WSNlineY,"0,45,45");
	newvlin_025->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_025->setPropertyV(WSNname,"newvlin_025");
	newvlin_025->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_025->setPropertyV(WSNx,(short)133);
	newvlin_025->setPropertyV(WSNy,(short)60);
	newvlin_025->setPropertyV(WSNwidth,(unsigned short)200);
	newvlin_025->setPropertyV(WSNheight,(unsigned short)50);

	WSCvline* newvlin_010 = new  WSCvline(newform_002,"newvlin_010");
	newvlin_010->initialize();
	newvlin_010->setPropertyV(WSNlineX,"0,10,100");
	newvlin_010->setPropertyV(WSNlineY,"30,5,5");
	newvlin_010->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_010->setPropertyV(WSNname,"newvlin_010");
	newvlin_010->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_010->setPropertyV(WSNx,(short)310);
	newvlin_010->setPropertyV(WSNy,(short)10);

	WSCvline* newvlin_012 = new  WSCvline(newform_002,"newvlin_012");
	newvlin_012->initialize();
	newvlin_012->setPropertyV(WSNlineX,"0,20,25,100");
	newvlin_012->setPropertyV(WSNlineY,"5,5,3,3");
	newvlin_012->setPropertyV(WSNlineNum,(unsigned char)4);
	newvlin_012->setPropertyV(WSNname,"newvlin_012");
	newvlin_012->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_012->setPropertyV(WSNx,(short)310);
	newvlin_012->setPropertyV(WSNy,(short)32);
	newvlin_012->setPropertyV(WSNheight,(unsigned short)20);

	WSCvline* newvlin_014 = new  WSCvline(newform_002,"newvlin_014");
	newvlin_014->initialize();
	newvlin_014->setPropertyV(WSNlineX,"0,20,25,100");
	newvlin_014->setPropertyV(WSNlineY,"5,5,8,8");
	newvlin_014->setPropertyV(WSNlineNum,(unsigned char)4);
	newvlin_014->setPropertyV(WSNname,"newvlin_014");
	newvlin_014->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_014->setPropertyV(WSNx,(short)310);
	newvlin_014->setPropertyV(WSNy,(short)47);
	newvlin_014->setPropertyV(WSNheight,(unsigned short)20);

	WSCvline* newvlin_015 = new  WSCvline(newform_002,"newvlin_015");
	newvlin_015->initialize();
	newvlin_015->setPropertyV(WSNlineX,"0,10,100");
	newvlin_015->setPropertyV(WSNlineY,"30,5,5");
	newvlin_015->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_015->setPropertyV(WSNname,"newvlin_015");
	newvlin_015->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_015->setPropertyV(WSNx,(short)310);
	newvlin_015->setPropertyV(WSNy,(short)70);

	WSCvline* newvlin_018 = new  WSCvline(newform_002,"newvlin_018");
	newvlin_018->initialize();
	newvlin_018->setPropertyV(WSNlineX,"0,10,100");
	newvlin_018->setPropertyV(WSNlineY,"30,5,5");
	newvlin_018->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_018->setPropertyV(WSNname,"newvlin_018");
	newvlin_018->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_018->setPropertyV(WSNx,(short)310);
	newvlin_018->setPropertyV(WSNy,(short)90);

	WSCvline* newvlin_019 = new  WSCvline(newform_002,"newvlin_019");
	newvlin_019->initialize();
	newvlin_019->setPropertyV(WSNlineX,"0,10,100");
	newvlin_019->setPropertyV(WSNlineY,"30,5,5");
	newvlin_019->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_019->setPropertyV(WSNname,"newvlin_019");
	newvlin_019->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_019->setPropertyV(WSNx,(short)310);
	newvlin_019->setPropertyV(WSNy,(short)110);
	newvlin_019->setPropertyV(WSNheight,(unsigned short)20);

	WSCvline* newvlin_026 = new  WSCvline(newform_002,"newvlin_026");
	newvlin_026->initialize();
	newvlin_026->setPropertyV(WSNlineX,"0,10,300");
	newvlin_026->setPropertyV(WSNlineY,"0,45,45");
	newvlin_026->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_026->setPropertyV(WSNname,"newvlin_026");
	newvlin_026->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_026->setPropertyV(WSNx,(short)160);
	newvlin_026->setPropertyV(WSNy,(short)130);
	newvlin_026->setPropertyV(WSNwidth,(unsigned short)250);
	newvlin_026->setPropertyV(WSNheight,(unsigned short)60);

	WSCvline* newvlin_027 = new  WSCvline(newform_002,"newvlin_027");
	newvlin_027->initialize();
	newvlin_027->setPropertyV(WSNlineX,"0,5,100");
	newvlin_027->setPropertyV(WSNlineY,"5,25,25");
	newvlin_027->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_027->setPropertyV(WSNname,"newvlin_027");
	newvlin_027->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_027->setPropertyV(WSNx,(short)310);
	newvlin_027->setPropertyV(WSNy,(short)170);

	WSCvline* newvlin_030 = new  WSCvline(newform_002,"newvlin_030");
	newvlin_030->initialize();
	newvlin_030->setPropertyV(WSNlineX,"5,10,100");
	newvlin_030->setPropertyV(WSNlineY,"5,25,25");
	newvlin_030->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_030->setPropertyV(WSNname,"newvlin_030");
	newvlin_030->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_030->setPropertyV(WSNx,(short)350);
	newvlin_030->setPropertyV(WSNy,(short)110);
	newvlin_030->setPropertyV(WSNwidth,(unsigned short)60);

	WSCvlabel* newvlab_031 = new  WSCvlabel(newform_002,"newvlab_031");
	newvlab_031->initialize();
	newvlab_031->setPropertyV(WSNlabelString,"Menu back color");
	newvlab_031->setPropertyV(WSNalignmentH,(unsigned char)0);
	newvlab_031->setPropertyV(WSNname,"newvlab_031");
	newvlab_031->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_031->setPropertyV(WSNx,(short)430);
	newvlab_031->setPropertyV(WSNy,(short)5);
	newvlab_031->setPropertyV(WSNwidth,(unsigned short)200);
	newvlab_031->setPropertyV(WSNheight,(unsigned short)20);

	WSCvlabel* newvlab_032 = new  WSCvlabel(newform_002,"newvlab_032");
	newvlab_032->initialize();
	newvlab_032->setPropertyV(WSNlabelString,"Menu fore color");
	newvlab_032->setPropertyV(WSNalignmentH,(unsigned char)0);
	newvlab_032->setPropertyV(WSNname,"newvlab_032");
	newvlab_032->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_032->setPropertyV(WSNx,(short)430);
	newvlab_032->setPropertyV(WSNy,(short)25);
	newvlab_032->setPropertyV(WSNwidth,(unsigned short)200);
	newvlab_032->setPropertyV(WSNheight,(unsigned short)20);

	WSCvlabel* newvlab_033 = new  WSCvlabel(newform_002,"newvlab_033");
	newvlab_033->initialize();
	newvlab_033->setPropertyV(WSNlabelString,"Menu selected color");
	newvlab_033->setPropertyV(WSNalignmentH,(unsigned char)0);
	newvlab_033->setPropertyV(WSNname,"newvlab_033");
	newvlab_033->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_033->setPropertyV(WSNx,(short)430);
	newvlab_033->setPropertyV(WSNy,(short)45);
	newvlab_033->setPropertyV(WSNwidth,(unsigned short)200);
	newvlab_033->setPropertyV(WSNheight,(unsigned short)20);

	WSCvline* newvlin_034 = new  WSCvline(newform_002,"newvlin_034");
	newvlin_034->initialize();
	newvlin_034->setPropertyV(WSNlineX,"10,15,100");
	newvlin_034->setPropertyV(WSNlineY,"5,25,25");
	newvlin_034->setPropertyV(WSNlineNum,(unsigned char)3);
	newvlin_034->setPropertyV(WSNname,"newvlin_034");
	newvlin_034->setPropertyV(WSNvis,(WSCbool)1);
	newvlin_034->setPropertyV(WSNx,(short)350);
	newvlin_034->setPropertyV(WSNy,(short)130);
	newvlin_034->setPropertyV(WSNwidth,(unsigned short)60);

	WSCvlabel* newvlab_035 = new  WSCvlabel(newform_002,"newvlab_035");
	newvlab_035->initialize();
	newvlab_035->setPropertyV(WSNlabelString,"Bar shadow color");
	newvlab_035->setPropertyV(WSNalignmentH,(unsigned char)0);
	newvlab_035->setPropertyV(WSNname,"newvlab_035");
	newvlab_035->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_035->setPropertyV(WSNx,(short)430);
	newvlab_035->setPropertyV(WSNy,(short)185);
	newvlab_035->setPropertyV(WSNwidth,(unsigned short)200);
	newvlab_035->setPropertyV(WSNheight,(unsigned short)20);

	WSCvlabel* newvlab_036 = new  WSCvlabel(newform_002,"newvlab_036");
	newvlab_036->initialize();
	newvlab_036->setPropertyV(WSNlabelString,"Workarea back color");
	newvlab_036->setPropertyV(WSNalignmentH,(unsigned char)0);
	newvlab_036->setPropertyV(WSNname,"newvlab_036");
	newvlab_036->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_036->setPropertyV(WSNx,(short)430);
	newvlab_036->setPropertyV(WSNy,(short)165);
	newvlab_036->setPropertyV(WSNwidth,(unsigned short)200);
	newvlab_036->setPropertyV(WSNheight,(unsigned short)20);

	WSCvlabel* newvlab_037 = new  WSCvlabel(newform_002,"newvlab_037");
	newvlab_037->initialize();
	newvlab_037->setPropertyV(WSNlabelString,"Fore color");
	newvlab_037->setPropertyV(WSNalignmentH,(unsigned char)0);
	newvlab_037->setPropertyV(WSNname,"newvlab_037");
	newvlab_037->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_037->setPropertyV(WSNx,(short)430);
	newvlab_037->setPropertyV(WSNy,(short)145);
	newvlab_037->setPropertyV(WSNwidth,(unsigned short)200);
	newvlab_037->setPropertyV(WSNheight,(unsigned short)20);

	WSCvlabel* newvlab_038 = new  WSCvlabel(newform_002,"newvlab_038");
	newvlab_038->initialize();
	newvlab_038->setPropertyV(WSNlabelString,"Dark back color");
	newvlab_038->setPropertyV(WSNalignmentH,(unsigned char)0);
	newvlab_038->setPropertyV(WSNname,"newvlab_038");
	newvlab_038->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_038->setPropertyV(WSNx,(short)430);
	newvlab_038->setPropertyV(WSNy,(short)125);
	newvlab_038->setPropertyV(WSNwidth,(unsigned short)200);
	newvlab_038->setPropertyV(WSNheight,(unsigned short)20);

	WSCvlabel* newvlab_039 = new  WSCvlabel(newform_002,"newvlab_039");
	newvlab_039->initialize();
	newvlab_039->setPropertyV(WSNlabelString,"Back color");
	newvlab_039->setPropertyV(WSNalignmentH,(unsigned char)0);
	newvlab_039->setPropertyV(WSNname,"newvlab_039");
	newvlab_039->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_039->setPropertyV(WSNx,(short)430);
	newvlab_039->setPropertyV(WSNy,(short)105);
	newvlab_039->setPropertyV(WSNwidth,(unsigned short)200);
	newvlab_039->setPropertyV(WSNheight,(unsigned short)20);

	WSCvlabel* newvlab_040 = new  WSCvlabel(newform_002,"newvlab_040");
	newvlab_040->initialize();
	newvlab_040->setPropertyV(WSNlabelString,"Command fore color");
	newvlab_040->setPropertyV(WSNalignmentH,(unsigned char)0);
	newvlab_040->setPropertyV(WSNname,"newvlab_040");
	newvlab_040->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_040->setPropertyV(WSNx,(short)430);
	newvlab_040->setPropertyV(WSNy,(short)85);
	newvlab_040->setPropertyV(WSNwidth,(unsigned short)200);
	newvlab_040->setPropertyV(WSNheight,(unsigned short)20);

	WSCvlabel* newvlab_041 = new  WSCvlabel(newform_002,"newvlab_041");
	newvlab_041->initialize();
	newvlab_041->setPropertyV(WSNlabelString,"Command back color");
	newvlab_041->setPropertyV(WSNalignmentH,(unsigned char)0);
	newvlab_041->setPropertyV(WSNname,"newvlab_041");
	newvlab_041->setPropertyV(WSNvis,(WSCbool)1);
	newvlab_041->setPropertyV(WSNx,(short)430);
	newvlab_041->setPropertyV(WSNy,(short)65);
	newvlab_041->setPropertyV(WSNwidth,(unsigned short)200);
	newvlab_041->setPropertyV(WSNheight,(unsigned short)20);

    _setup_dbtn(newform_002,0,"DEF5","DEF8","DEF9");
    _setup_dbtn(newform_002,1,"DEF6","DEF8","DEF9");
    _setup_dbtn(newform_002,2,"DEF7","DEF8","DEF9");
    _setup_dbtn(newform_002,3,"DEF13","DEF15","DEF16");
    _setup_dbtn(newform_002,4,"DEF14","DEF15","DEF16");
    _setup_dbtn(newform_002,5,"DEF1","DEF3","DEF4");
    _setup_dbtn(newform_002,6,"DEF10","DEF3","DEF4");
    _setup_dbtn(newform_002,7,"DEF2","DEF3","DEF4");
    _setup_dbtn(newform_002,8,"DEF11","DEF3","DEF4");
    _setup_dbtn(newform_002,9,"DEF12","DEF3","DEF4");

}
