//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCstring.h>
#include <WSCbase.h>
#include <WSCmessageDialog.h>
#include <advance/WSadcom.h>
#include <WSCclassInformation.h>
#include <WSCbaseList.h>
#include <WSCvariant.h>
#include <WSDdragDrop.h>
#include <WSDmouse.h>
#include <WSCpopupMenu.h>
#include <WSDwindowDev.h>
#include <WSDfileSystem.h>
#include <WSClocaleSet.h>
#include <WSCfunction.h>
#include <WSCfunctionList.h>
#include <advance/WSCclassPropEditor.h>
#include <advance/WSCtriggerEditor.h>
#include <advance/WSCclassUTrgEditor.h>
#include <advance/WSCclassRMethodEditor.h>
#include <advance/WSCcolorSelect.h>
#include <WSCundoManager.h>

#ifdef MSW
#include <direct.h>
#include <io.h>
#endif

extern "C" {
void libwsad_func();
};
void libwsad_func(){
}

#ifdef MSW
#define WSMFchmod    _chmod
#else
#include <sys/types.h>
#include <sys/stat.h>
#define WSMFchmod    chmod
#endif

#ifdef BTRON
void copy_file(char* f1,char* f2){
  WSCstring* str = WSGFreadTextFile(f1);
  if (str != NULL){
    WSGFreplaceTextFile(f2,str->getString(),True);
    delete str;
  }
}
#endif

WSCbase* _get_class_base(WSCbase* base,char* cbase){
  WSClistData children = base->getChildren();
  long num = children.getNum();
  if (num == 0){
    return NULL;
  }
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      if (!WSIFstrcmp(child->getInstanceName(),cbase)){
        return child;
      }
      WSCbase* ret = _get_class_base(child,cbase);
      if (ret != NULL){
        return ret;
      }
    }
  }
  return NULL;
}

WSCbase* WSGFgetClassBase(WSCbase* base){
  WSCbase* item = (WSCbase*)base->getUserData("WS-BK-CLASS");
  if (item != NULL){
    return base;
  }
  char* cbase = (char*)base->getUserData(WS_WIN_CLASS_BASE);

  base->setUserData("WS-BK-CLASS",(void*)0);

  char* name = (char*)base->getUserData("WS-BK-CLASS-NAME");
  if (name != NULL){
    delete name;
    base->setUserData("WS-BK-CLASS-NAME",(void*)0);
  }

  if (cbase == NULL){
    return base;
  }
  if (!WSIFstrcmp(base->getInstanceName(),cbase)){
    return base;
  }
  WSCbase* ret = _get_class_base(base,cbase);
  if (ret == NULL){
    return base;
  }
  base->setUserData("WS-BK-CLASS",(void*)ret);
  base->setUserData("WS-BK-CLASS-NAME",(void*)WSGFstrdup(ret->getInstanceName()));

//printf("WSGFgetClassBase( base=%s",ret->getInstanceName());
  ret->setInstanceName(base->getInstanceName());
//printf(",cname=%s,icname=%s)\n",ret->getInstanceName(),ret->getClassName());
  ret->setUserData(WS_PROP_LIST,base->getUserData(WS_PROP_LIST));
  ret->setUserData(WS_UTRG_LIST, base->getUserData(WS_UTRG_LIST));
  ret->setUserData(WS_TRG_LIST, base->getUserData(WS_TRG_LIST));
  ret->setUserData(WS_RMETHOD_LIST, base->getUserData(WS_RMETHOD_LIST));
  ret->setUserData(WS_RCLASS_GENERATE, base->getUserData(WS_RCLASS_GENERATE));
  ret->setUserData(WS_RCLASS_NAME, base->getUserData(WS_RCLASS_NAME));
  ret->setUserData(WS_RCLASS_BNAME, base->getUserData(WS_RCLASS_BNAME));
  ret->setUserData(WS_NO_DEL_BUILDER_DATA,(void*)1);

  return ret;
}

void WSGFresetClassBase(WSCbase* base){
  WSCbase* item = (WSCbase*)base->getUserData("WS-BK-CLASS");
  if (item == NULL){
    return;
  }

  char* name = (char*)base->getUserData("WS-BK-CLASS-NAME");
  if (name != NULL){
    item->setInstanceName(name);
    delete[] name;
    base->setUserData("WS-BK-CLASS-NAME",(void*)0);
  }
}



static WSCbase*  _get_parent_base(WSCbase* win,char* pname){
  if (!strcmp(pname,win->getInstanceName())){
    return win;
  }
  WSClistData children = win->getChildren();
  long num = children.getNum();
  if (num == 0){
    return NULL;
  }
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];

    if ( !strcmp(pname,child->getInstanceName()) ){
      return child;
    }else{
      WSCbase* ret = _get_parent_base(child,pname);
      if (ret != NULL){
        return ret;
      }
    }
  }
  return NULL;
}
static WSCbase*  _get_parent_base2(WSCbase* win,char* pname){
  char* tname = (char*)win->getUserData("tname-");
  if (tname != NULL && !strcmp(pname,tname)){
    return win;
  }
  WSClistData children = win->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];

    char* tname = (char*)child->getUserData("tname-");
    if ( tname != NULL && !strcmp(pname,tname) ){
      return child;
    }else{
      WSCbase* ret = _get_parent_base2(child,pname);
      if (ret != NULL){
        return ret;
      }
    }
  }
  return NULL;
}
extern void _get_2_words(char* src,char* word1,char* word2);
#if 0
void _get_2_words(char* src,char* word1,char* word2){
   word1[0] = 0;
   word2[0] = 0;
   long ptr=0;
   while(1){
     if (src[ptr] == 0){
       return;
     }
     if (src[ptr] == ' ' || src[ptr] == '\t'){
       ptr++;
     }else{
       break;
     }
   }

   long i=0;
   while(1){
     if (src[ptr] == 0){
       word1[i] = 0;
       return;
     }
     if (src[ptr] == ' ' || src[ptr] == '\t'){
       word1[i] = 0;
       break;
     }
     word1[i] = src[ptr];
     i++;
     ptr++;
   }

   while(1){
     if (src[ptr] == 0){
       return;
     }
     if (src[ptr] == ' ' || src[ptr] == '\t'){
       ptr++;
     }else{
       break;
     }

   }

   i=0;
   while(1){
     if (src[ptr] == 0){
       word2[i] = 0;
       return;
     }
     if (src[ptr] == ' ' || src[ptr] == '\t'){
       word2[i] = 0;
       return;
     }
     word2[i] = src[ptr];
     i++;
     ptr++;
   }
}
#endif
static void _op_dummy(WSCbase*){
}
void _clean_tname_(WSCbase* base){
  if (base != NULL){
    char* tname = (char*)base->getUserData("tname-");
    if (tname != NULL){
      delete tname;
      base->setUserData("tname-",NULL);
    }
    WSClistData children = base->getChildren();
    long num = children.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)children[i];
      _clean_tname_(child);
    }
  }
}
WSCbase* _WSGFreadWinSrc(WSCstring& src,WSCbool edit,WSCbool spec_name,char* topname);

WSCbase* WSGFreadWinSrc(WSCstring& src,WSCbool edit){
  WSCbase* ret = _WSGFreadWinSrc(src,edit,False,NULL);
  _clean_tname_(ret);
  return ret;
}
WSCbase* WSGFreadWinSrc2(WSCstring& src,WSCbool edit,char* topname){
  return _WSGFreadWinSrc(src,edit,True,topname);
}
long (*_create_proc_handler)(char*,char*) = NULL;
void WSGFreadWinSrcSetCreateProcHandler(long(*hd)(char*,char*)){
  _create_proc_handler = hd;
}

char* get_type_name(long num){
extern char* WSGFvalueToType(long);
  return WSGFvalueToType(num);
#if 0
  switch(num){
    case 0: return "long";
    case 1: return "WSCulong";
    case 2: return "short";
    case 3: return "WSCushort";
    case 4: return "char";
    case 5: return "WSCuchar";
    case 6: return "float";
    case 7: return "double";
    case 9: return "char*";
    case 11: return "WSCbool";
    case 12: return "int";
    case 13: return "WSCuint";
    case 14: return "void";
  }
  return "long";
#endif
}
long get_type_value(char* typen){
extern long WSGFtypeToValue(char*);
  return WSGFtypeToValue(typen);
#if 0
  if (!strcmp(typen,"long")){
    return 0;
  }else
  if (!strcmp(typen,"WSCulong")){
    return 1;
  }else
  if (!strcmp(typen,"short")){
    return 2;
  }else
  if (!strcmp(typen,"WSCushort")){
    return 3;
  }else
  if (!strcmp(typen,"char")){
    return 4;
  }else
  if (!strcmp(typen,"WSCuchar")){
    return 5;
  }else
  if (!strcmp(typen,"float")){
    return 6;
  }else
  if (!strcmp(typen,"double")){
    return 7;
  }else
  if (!strcmp(typen,"char*")){
    return 9;
  }else
  if (!strcmp(typen,"void")){
    return 10;
  }else
  if (!strcmp(typen,"WSCbool")){
    return 11;
  }else
  if (!strcmp(typen,"int")){
    return 12;
  }else
  if (!strcmp(typen,"WSCuint")){
    return 13;
  }
  return 0;
#endif
}
char* get_type_name2(char* typen){
  if (!strcmp(typen,"long")){
    return "Long";
  }else
  if (!strcmp(typen,"WSCulong")){
    return "ULong";
  }else
  if (!strcmp(typen,"short")){
    return "Short";
  }else
  if (!strcmp(typen,"WSCushort")){
    return "UShort";
  }else
  if (!strcmp(typen,"char")){
    return "Char";
  }else
  if (!strcmp(typen,"WSCuchar")){
    return "UChar";
  }else
  if (!strcmp(typen,"float")){
    return "Float";
  }else
  if (!strcmp(typen,"double")){
    return "Double";
  }else
  if (!strcmp(typen,"char*")){
    return "String";
  }else
  if (!strcmp(typen,"void")){
    return "void";
  }else
  if (!strcmp(typen,"WSCbool")){
    return "Char";
  }else
  if (!strcmp(typen,"int")){
    return "Int";
  }else
  if (!strcmp(typen,"WSCuint")){
    return "UInt";
  }
  return "Long";
}




WSCbase* _WSGFreadWinSrc(WSCstring& src,WSCbool edit,WSCbool spec_name,char* topname){
   WSCbase* ret = NULL;
   WSCbase* obj = NULL;
   WSCbase* obj2 = NULL;
   WSCbool top = True;
//   char buffer[1024];
   char buf1[1024];
   char buf2[1024];
   char buf3[1024];
   char buf4[1024];
   WSCstring classname;

   src.seek(0);
   WSCstring str = src.gets();
   while(src.eof() == False){
     buf1[0] = 0;
     buf2[0] = 0;
     _get_2_words((char*)str,buf1,buf2);
    if(strcmp("#OBJ", buf1) && strcmp("#obj", buf1) &&
        strcmp("#cobj",buf1) && strcmp("#sobj",buf1) &&
        strcmp("#cobjr",buf1) ){
      break;
    }
    WSCbool ext = False;
    WSCbool classwin = False;
    WSCbool storewin = False;
    WSCbool rclass = False;
    if (!strcmp("#OBJ",buf1)){
      ext = True;
    }
    if (!strcmp("#cobj",buf1)){
      classwin = True;
      rclass = False;
    }
    if (!strcmp("#cobjr",buf1)){
      classwin = True;
      rclass = True;
    }
    if (!strcmp("#sobj",buf1)){
      storewin = True;
    }
    char dummy[2048];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(buf2,&ano,dummy);
    if (is_array != False){
      ext = True;
    }

    if (src.eof() != False){
      break;
    }
    str = src.gets();

    buf1[0] = 0;
    buf3[0] = 0;

    _get_2_words(str,buf1,buf3);
    if (classwin != False){
      classname = buf3;
    }
    if (strcmp("#TYPE",buf1)){
      break;
    }
    if (src.eof() != False){
      break;
    }
    str = src.gets();

    buf1[0] = 0;
    buf4[0] = 0;

    _get_2_words(str,buf1,buf4);

    if (strcmp("#PARENT",buf1)){
      break;
    }

    WSCbase* parent = NULL;
    if ( strcmp(buf4,"NULL") && buf4[0] != 0 ){
      if (spec_name == False){
        if (obj != NULL && !strcmp(obj->getInstanceName(),buf4)){
          parent = obj;
        }else
        if (obj2 != NULL && !strcmp(obj2->getInstanceName(),buf4)){
          parent = obj2;
        }else if (ret != NULL){
          parent = _get_parent_base(ret,buf4);
        }
        obj2 = parent; //ƤˤʤäΤ򥭥å夹...
      }else{
        if (obj != NULL){
          char* tname = (char*)obj->getUserData("tname-");
          if (tname != NULL && !strcmp(tname,buf4)){
            parent = obj;
          }
        }
        if (parent == NULL && obj2 != NULL){
          char* tname2 = (char*)obj2->getUserData("tname-");
          if (tname2 != NULL && !strcmp(tname2,buf4)){
            parent = obj2;
          }
        }
        if (parent == NULL && ret != NULL){
          parent = _get_parent_base2(ret,buf4);
        }
        obj2 = parent;
      }
    }

    obj = WSCbase::getNewInstance(buf3,parent,"--NO NAME--");
    if (obj == NULL){
      WSCmessageDialog* msg = WSGIappMessageDialog();
      msg->setPropertyV(WSNdefaultPosition,(WSCbool)True);
      msg->setPropertyV(WSNwidth,(WSCushort)450);
      msg->setPropertyV(WSNheight,(WSCushort)120);
      char buffer[1024];
      sprintf(buffer,WSGFgettext("A3:WSSTR Can not create class: %s.\nPlease check the import library is right."),buf3);
      msg->setPropertyV(WSNlabelString,buffer);
      msg->popup();
      if (ret != NULL){
        delete ret;
      }
      return NULL;
    }
//printf("WSadcom::readWinSrc cname=%s name=%s\n",buf3,buf2);
    long st_name = 0;
    if (spec_name == False){
      st_name = WSGFexistName(buf2,obj);
    }else if (top != False){
      st_name = WSGFexistName(topname,obj);
    }
    if (ext == True && ((st_name != 0 && is_array == False) ||
                       ((st_name == WS_PROCEDURE_NAME ||
                         st_name == WS_OBJECT_NAME ) && is_array != False ))){
      if (spec_name == False){
        WSCmessageDialog* msg = WSGIappMessageDialog();
        msg->setPropertyV(WSNwidth,(WSCushort)450);
        msg->setPropertyV(WSNheight,(WSCushort)120);
        char buffer[1024];
        sprintf(buffer,
           WSGFgettext("B3:WSSTR The name %s is already used by another instance."),
           buf2);
        msg->setPropertyV(WSNlabelString,buffer);
        msg->popup();
      }
    }
    if (spec_name == False){
      obj->setInstanceName(buf2);
    }else{
      obj->setUserData("tname-",WSGFstrdup(buf2));
      if (ret != NULL){
        obj->setInstanceName(WSGFcreateName(ret->getInstanceName(),
                             obj->getClassName()));
      }else{
        obj->setInstanceName(topname);
      }
    }

    obj->initialize();
    obj->setPropertyEditMode(edit);

    WSGFexecCreateHandler(obj);

    void (*delete_handler)(WSCbase*) = WSGFgetDeleteHandler();
    if (delete_handler != NULL){
      WSCprocedure* ac = new WSCprocedure("delete-handler",WSEV_DELETE);
      ac->setFunction(delete_handler,"delete_handler");
      ac->setInternal(True);
      obj->addProcedure(ac);
    }

    if (ext == True){
      obj->setUserData(WS_EXT_VAR,(void*)1);
    }
    if (classwin == True){
      obj->setUserData(WS_WIN_CLASS,(void*)1);
    }
    if (rclass == True){
      obj->setUserData(WS_RCLASS_GENERATE,(void*)1);
    }
    if (storewin == True){
      obj->setUserData(WS_WIN_STORE,(void*)1);
    }
    if (src.eof() != False){
      break;
    }
    str = src.gets();

    while(1){
      buf1[0]=0;
      buf2[0]=0;
      _get_2_words(str,buf1,buf2);

      if (strcmp("#PROC",buf1)){
        break;
      }

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();

      long trig;
      buf1[0]=0;
      buf3[0]=0;
      sscanf(str,"%s %ld",buf1,&trig);

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();

      _get_2_words(str,buf1,buf3);

      WSCstring prog(buf3);

      WSCprocedure* ac = new WSCprocedure(buf2,trig);
      if (prog.isExist(".cpp") == -1 && prog.isExist(".C") == -1){
        ac->setUseFile(False);
      }else{
        ac->setUseFile(True);
        if (spec_name != False && _create_proc_handler != NULL){
          if (classwin == False){
            _create_proc_handler((char*)prog,NULL);
          }else{
            _create_proc_handler((char*)prog,(char*)classname);
          }
        }
      }

      prog.replaceString(".cpp","",0);
      prog.replaceString(".C","",0);
      ac->setFunction(_op_dummy,prog.getString());
      obj->addProcedure(ac);

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;
      _get_2_words(str,buf1,buf2);

      if (strcmp("#RES",buf1)){
        break;
      }
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
      obj->setProperty(buf2,(char*)str);

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;
      char tbuf1[1024];
      char bbuf1[1024];
      tbuf1[0] = 0;
      bbuf1[0] = 0;
      long att = 0;
      long type;
      long use_file;

      sscanf(str,"%s %s %s %ld %ld %ld %s",buf1,buf2,tbuf1,&type,&use_file,&att,bbuf1);
      if (strncmp("#res",buf1,4)){
        break;
      }
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();

      WSClistData* prprc_list = (WSClistData*)obj->getUserData(WS_PROP_LIST);
      if (prprc_list == NULL){
        prprc_list = new WSClistData();
        obj->setUserData(WS_PROP_LIST,(void*)prprc_list);
      }
      char values[1024];
      values[0] = 0;
      if (buf1[4] == '#'){
        strcpy(values,&(buf1[5]));
      }
      prop_data* propdata = new prop_data;
      propdata->name.setString(buf2);
      propdata->vname.setString(tbuf1);
      propdata->value.setString(str);
      propdata->bname.setString(bbuf1);
      propdata->type = type;
      propdata->att = att;
      propdata->use_file = use_file;
      propdata->values.setString(values);
      propdata->values.replaceString("\\S"," ",0);
      prprc_list->add((void*)propdata);
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;
      char bbuf1[1024];
      long value;
      long value2;

      sscanf(str,"%s %s %s %ld",buf1,buf2,bbuf1,&value2);
      if (strncmp("#utrg",buf1,4)){
        break;
      }
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
      value = atoi(str);

      WSClistData* prprc_list = (WSClistData*)obj->getUserData(WS_UTRG_LIST);
      if (prprc_list == NULL){
        prprc_list = new WSClistData();
        obj->setUserData(WS_UTRG_LIST,(void*)prprc_list);
      }
      utrg_data* utrgdata = new utrg_data;
      utrgdata->name.setString(buf2);
      utrgdata->vname.setString(bbuf1);
      utrgdata->value = value;
      utrgdata->type = value2;
      prprc_list->add((void*)utrgdata);
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }


    while(1){
      buf1[0]=0;
      long trg;

      sscanf(str,"%s %ld",buf1,&trg);
      if (strcmp("#trg",buf1)){
        break; //
      }

      WSClistData* tlist = (WSClistData*)obj->getUserData(WS_TRG_LIST);
      if (tlist == NULL){
        tlist = new WSClistData();
        obj->setUserData(WS_TRG_LIST,(void*)tlist);
      }
      tlist->add((void*)trg);

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;
      _get_2_words(str,buf1,buf2);

      if (strcmp("#icon",buf1)){
        break; //
      }

      char* icon = (char*)obj->getUserData(WS_CLASS_ICON);
      if (icon != NULL){
        delete icon;
      }

      obj->setUserData(WS_CLASS_ICON,(void*)WSGFstrdup(buf2));
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;

//      sscanf(str,"%s %s",buf1,buf2);
      _get_2_words(str,buf1,buf2);

      if (strcmp("#com",buf1)){
        break; //
      }

      char* ccom = (char*)obj->getUserData(WS_CLASS_COMMENT);
      if (ccom != NULL){
        delete ccom;
      }
      obj->setUserData(WS_CLASS_COMMENT,(void*)WSGFstrdup(buf2));
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
 
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;

      _get_2_words(str,buf1,buf2);

      if (strcmp("#cbase",buf1)){
        break;
      }

      char* cbase = (char*)obj->getUserData(WS_WIN_CLASS_BASE);
      if (cbase != NULL){
        delete cbase;
      }
      obj->setUserData(WS_WIN_CLASS_BASE,(void*)WSGFstrdup(buf2));
      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;

      _get_2_words(str,buf1,buf2);

      if (strcmp("#rmethod",buf1)){
        break;
      }

      WSClistData* rmlist = (WSClistData*)obj->getUserData(WS_RMETHOD_LIST);
      if (rmlist == NULL){
        rmlist = new WSClistData();
        obj->setUserData(WS_RMETHOD_LIST,(void*)rmlist);
      }
      WSCstring rstr(buf2);

      rmethod_data* rmdata = new rmethod_data;
      rmdata->name = rstr.getWord(1,",");
//      rmdata->type =  get_type_value(rstr.getWord(0,","));
      rmdata->type_name =  rstr.getWord(0,",");

      if (src.eof() != False){
        return ret;
      }
      rstr = src.gets();
      rmdata->params = rstr;
      rmlist->add((void*)rmdata);

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;

      _get_2_words(str,buf1,buf2);

      if (strcmp("#rcname",buf1)){
        break;
      }
      obj->setUserData(WS_RCLASS_NAME,WSGFstrdup(buf2));

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    while(1){
      buf1[0]=0;
      buf2[0]=0;

      _get_2_words(str,buf1,buf2);

      if (strcmp("#brcname",buf1)){
        break;
      }
      obj->setUserData(WS_RCLASS_BNAME,WSGFstrdup(buf2));

      if (src.eof() != False){
        return ret;
      }
      str = src.gets();
    }

    if (top != False){
      ret = obj;
      obj->setUserData(WS_EXT_VAR,(void*)1);
      top = False;
    }
    str = src.gets();
  }
  return ret;
}
static void  _append(WSClistData* list,WSCstring* str){
  long num = list->getNum();
  long i;
  if (num > 2){
    WSClistData list1;
    WSClistData list2;
    for(i=0; i<num; i++){
      if (i < num/2){
        list1.add( (*list)[i]);
      }else{
        list2.add( (*list)[i]);
      }
    }
    WSCstring str1;
    WSCstring str2;
    _append(&list1,&str1);
    _append(&list2,&str2);
    str->addString(str1.getString());;
    str->addString(str2.getString());;
    return;
  }else{
    if (num == 2){
      WSCstring* str1 = (WSCstring*)(*list)[0];
      WSCstring* str2 = (WSCstring*)(*list)[1];
      str->addString(str1->getString());
      str->addString(str2->getString());
    }else if (num == 1){
      WSCstring* str1 = (WSCstring*)(*list)[0];
      str->addString(str1->getString());
    }
    return;
  }
}
//high speed strcmp
inline long WSGFstrcmp(char* x,char* y){
  register WSCuchar* s1 = (WSCuchar*)x;
  register WSCuchar* s2 = (WSCuchar*)y;
  register WSCuchar p1 = 0;
  register WSCuchar p2 = 0;
  do{
      p1 = (WSCuchar)*s1++;
      p2 = (WSCuchar)*s2++;
      if (p1 == 0){
         return p1 -p2;
      }
  } while (p1 == p2);
  return p1 -p2;
}

void _add_default_changed_property(WSCbase* btarget,char* pn,char tp,char* pdata,WSClistData* plist);
char* _value_to_type(long val){
static char* buf[17];
static char fl = False;
  if (fl == False){
    fl = True;
    buf[WSTlong] = "long";
    buf[WSTulong] = "WSCulong";
    buf[WSTshort] = "short";
    buf[WSTushort] = "WSCushort";
    buf[WSTchar] = "char";
    buf[WSTuchar] = "WSCuchar";
    buf[WSTfloat] = "float";
    buf[WSTdouble] = "double";
    buf[WSTvoidptr] = "void*";
    buf[WSTcharptr] = "char*";
    buf[WSTvoid] = "void";
    buf[WSTbool] = "WSCbool";
    buf[WSTint] = "int";
    buf[WSTuint] = "WSCuint";
  }
  if (-1 < val && val < WSTuint + 1){
    return buf[val];
  }
  return "long";
}
char* WSGFvalueToType(long val){
  return _value_to_type(val);
}
static WSCbool _is_color_property(char* pn){
  WSCstring tmp(pn);
  tmp.replaceString("WSN","",0);
  char* pname = tmp.getString();

  long len = strlen(pname);
  if (len < 5){
    return False;
  }
  if (!WSGFstrcmp(&pname[len -5],"Color")||
      !WSGFstrcmp(&pname[len -5],"color")){
    return True;
  }
  if (len < 6){
    return False;
  }
  if (!strncmp(&pname[len -6],"Color",5) ||
      !strncmp(&pname[len -6],"color",5)){
    if ( '0' <= pname[len-1] && '9' >= pname[len-1] ){
      return True;
    }else{
      return False;
    }
  }
  if (len < 7){
    return False;
  }
  if (!strncmp(&pname[len -7],"Color",5) ||
      !strncmp(&pname[len -7],"color",5)){
    if ( '0' <= pname[len-2] && '9' >= pname[len-2] &&
         '0' <= pname[len-1] && '9' >= pname[len-1] ){
      return True;
    }else{
      return False;
    }
  }
  return False;
}

static WSCbool _is_pixmap_property(char* pn){
  WSCstring tmp(pn);
  tmp.replaceString("WSN","",0);
  char* pname = tmp.getString();

  long len = strlen(pname);
  if (len < 6){
    return False;
  }
  if (!WSGFstrcmp(&pname[len -6],"Pixmap") ||
      !WSGFstrcmp(&pname[len -6],"pixmap")){
    return True;
  }
  if (len < 7){
    return False;
  }
  if (!strncmp(&pname[len -7],"Pixmap",6) ||
      !strncmp(&pname[len -7],"pixmap",6)){
    if ( '0' <= pname[len-1] &&
         '9' >= pname[len-1] ){
      return True;
    }else{
      return False;
    }
  }
  if (len < 8){
    return False;
  }
  if (!strncmp(&pname[len -8],"Pixmap",6) ||
      !strncmp(&pname[len -8],"pixmap",6)){
    if ( '0' <= pname[len-2] && '9' >= pname[len-2] &&
         '0' <= pname[len-1] && '9' >= pname[len-1] ){
      return True;
    }else{
      return False;
    }
  }
  return False;
}

void WSGFcreateWinData(WSCstring* str,WSCbase* parent,WSCbase* base){
   WSClistData children = base->getChildren();
   char buffer[2048];
   WSCstring str2;
   if ((long)base->getUserData(WS_WIN_STORE) == 1){
     sprintf(buffer,"#sobj      %s\n",base->getInstanceName());
   }else if ((long)base->getUserData(WS_WIN_CLASS) == 1){
     if ((long)base->getUserData(WS_RCLASS_GENERATE) == 1){
       sprintf(buffer,"#cobjr      %s\n",base->getInstanceName());
     }else{
       sprintf(buffer,"#cobj      %s\n",base->getInstanceName());
     }
   }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
     sprintf(buffer,"#OBJ       %s\n",base->getInstanceName());
   }else{
     sprintf(buffer,"#obj       %s\n",base->getInstanceName());
   }
   str2.addString(buffer);
   sprintf(buffer," #TYPE       %s\n",base->getClassName());
   str2.addString(buffer);

   if (parent == NULL){
     sprintf(buffer," #PARENT   NULL\n");
   }else{
     sprintf(buffer," #PARENT   %s\n",parent->getInstanceName());
   }
   str2.addString(buffer);


   WSClistData* prc_list = base->getProcedureList();
   long num = prc_list->getNum();
   long i;
   for(i=0; i< num; i++){
     WSCprocedure* ac = (WSCprocedure*)(*prc_list)[i];
     if (ac->getInternal() != False){
       continue;
     }
     sprintf(buffer," #PROC  %s\n",ac->getProcName());
     str2.addString(buffer);
     sprintf(buffer,"  #TRIG    %d\n",ac->getTrigger());
     str2.addString(buffer);
     if (ac->getUseFile() == False){
       sprintf(buffer,"  #PRO   %s\n\n",ac->getFunctionName());
     }else{
       sprintf(buffer,"  #PRO   %s.cpp\n\n",ac->getFunctionName());
     }
     str2.addString(buffer);

   }

   WSClistData props;
   WSGFgetAllPropertyList(base,&props);
//   WSClistData* props = base->getClassInformation()->getAllPropertyList();
   WSCproperty* prop;
   num = props.getNum();
   for(i=0; i< num; i++){
     prop = (WSCproperty*)props[i];
//     WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);
     if (def != False){
       continue;
     }
     if (!strcmp("name",prop->getPropObjName())){
       continue;
     }
     if (base->getDataSourceType() != WS_DATA_SOURCE_NONE &&
        !strcmp(prop->getPropObjName(),base->getDataSourcePropertyName())){
       continue;
     }

     sprintf(buffer," #RES      %s\n",prop->getPropObjName());
     str2.addString(buffer);

     sprintf(buffer,"%s",(char*)base->getProperty(prop->getPropObjName()));
     WSCstring sdata;
     sdata.setString(buffer);
     sdata.replaceString("\n","\\n",0);
     str2.addString(sdata.getString());
     str2.addString("\n");
   }

   WSClistData* prprc_list = (WSClistData*)base->getUserData(WS_PROP_LIST);
   if (prprc_list != NULL){
     num = prprc_list->getNum();
     for(i=0; i<num; i++){
       prop_data* propdata = (prop_data*)(*prprc_list)[i];
       if( !strcmp(propdata->vname.getString(),"")){
          propdata->vname.setString("dummy");
       }
       if (!strcmp(propdata->values.getString(),"")){
         sprintf(buffer," #res\t%s\t%s\t%d\t%d\t%d\t%s\n",propdata->name.getString(),
                       propdata->vname.getString(),
                       propdata->type,
                       propdata->use_file,
                       propdata->att,
                       propdata->bname.getString());
       }else{
         sprintf(buffer," #res#%s\t%s\t%s\t%d\t%d\t%d\t%s\n",propdata->values.getString(),
                       propdata->name.getString(),
                       propdata->vname.getString(),
                       propdata->type,
                       propdata->use_file,
                       propdata->att,
                       propdata->bname.getString());
       }
       str2.addString(buffer);
       sprintf(buffer,"%s",propdata->value.getString());
       WSCstring sdata;
       sdata.setString(buffer);
       sdata.replaceString("\n","\\n",0);
       str2.addString(sdata.getString());
       str2.addString("\n");
     }
   }
   WSClistData* prut_list = (WSClistData*)base->getUserData(WS_UTRG_LIST);
   if (prut_list != NULL){
     num = prut_list->getNum();
     for(i=0; i<num; i++){
       utrg_data* utrgdata = (utrg_data*)(*prut_list)[i];
       sprintf(buffer," #utrg\t%s\t%s\t%d\n",utrgdata->name.getString(),
                       utrgdata->vname.getString(),utrgdata->type);
       str2.addString(buffer);
       sprintf(buffer,"%d",utrgdata->value);
       WSCstring sdata;
       sdata.setString(buffer);
       sdata.replaceString("\n","\\n",0);
       str2.addString(sdata.getString());
       str2.addString("\n");
     }
   }
   WSClistData* tlist = (WSClistData*)base->getUserData(WS_TRG_LIST);
   if (tlist != NULL){
     num = tlist->getNum();
     for(i=0; i<num; i++){
       long trg = (long)(*tlist)[i];
       sprintf(buffer," #trg\t%d\n",trg);
       str2.addString(buffer);
     }
   }

   if ((char*)base->getUserData(WS_CLASS_ICON) != NULL){
       sprintf(buffer," #icon\t%s\n",(char*)base->getUserData(WS_CLASS_ICON));
       str2.addString(buffer);
   }

   if ((char*)base->getUserData(WS_CLASS_COMMENT) != NULL){
       sprintf(buffer," #com\t%s\n",(char*)base->getUserData(WS_CLASS_COMMENT));
       str2.addString(buffer);
   }

   if ((char*)base->getUserData(WS_WIN_CLASS_BASE) != NULL){
       sprintf(buffer," #cbase\t%s\n",(char*)base->getUserData(WS_WIN_CLASS_BASE));
       str2.addString(buffer);
   }

   WSClistData* rmlist = (WSClistData*)base->getUserData(WS_RMETHOD_LIST);
   if (rmlist != NULL){
     num = rmlist->getNum();
     for(i=0; i<num; i++){
       rmethod_data* rmdata = (rmethod_data*)(*rmlist)[i];
       sprintf(buffer," #rmethod\t%s,%s\n%s\n",
           (char*)rmdata->type_name,(char*)rmdata->name,
           (char*)rmdata->params);
       str2.addString(buffer);
     }
   }
   char* rcname = (char*)base->getUserData(WS_RCLASS_NAME);
   if (rcname != NULL){
     WSCstring tmp;
     tmp << " #rcname " << rcname <<"\n";
     str2 << tmp;
   }
   char* brcname = (char*)base->getUserData(WS_RCLASS_BNAME);
   if (brcname != NULL){
     WSCstring tmp;
     tmp << " #brcname " << brcname <<"\n";
     str2 << tmp;
   }



   str2.addString("\n");

   str->addString(str2.getString());

   num = children.getNum();
   WSClistData clist;
   for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring* cdata = new WSCstring;
        WSGFcreateWinData(cdata,base,child);
        clist.add((void*)cdata);
      }
   }

   WSCstring str3;
   _append(&clist,&str3);
   str->addString(str3.getString());

   num = clist.getNum();
   for(i=0; i<num; i++){
     WSCstring* cdata = (WSCstring*)clist[i];
     delete cdata;
   }
}

WSCstring WSGFcreateWinSrc(WSCbase* win){
  WSCstring str;
  WSGFcreateWinData(&str,NULL,win);
  return str;
}

long WSGFsaveWinFile(char* dname,WSCbase* win,long encoding){
//  WSCindexVariantData* prj = (WSCindexVariantData*)proj;
//  if (prj == NULL){
//    return WS_ERR;
//  }

//  WSCvariant lang = prj->getData("#LANG");
//  WSCvariant enc = prj->getData("#ENCODING");

  WSCstring fname = dname;
  fname << "/" << win->getInstanceName() << ".win";
  WSCstring str = WSGFcreateWinSrc(win);
//  long encoding = enc.getLong();
  if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
    encoding = WS_EN_LOCALE;
  } 
  return WSGFreplaceTextFile((char*)fname,str.getString(encoding),False);
}

char* WSGFcreateName(char* winname,char* classname){
static char buffer[32];
static int  num=0;
char tmp[16];
   strcpy(buffer,"___________");
   if (!strncmp(winname,"WSC",3) || !strncmp(winname,"WSD",3)){
     strncpy(tmp,&winname[3],3);
   }else{
     strncpy(tmp,winname,3);
   }
   tmp[3]=0;
   memcpy(buffer,tmp,strlen(tmp));
   if (strlen(classname) < 4){
     strcpy(tmp,"AAAAA");
   }else{
     strncpy(tmp,&(classname[3]),5);
   }
   tmp[4]=0;
   memcpy(&(buffer[3]),tmp,strlen(tmp));
   sprintf(tmp,"%03d",num);
   tmp[3]=0;
   memcpy(&(buffer[11-strlen(tmp)]),tmp,strlen(tmp));
   buffer[11]=0;
   num++;
   WSCbase* base = WSGIappObjectList()->getInstance("WSCbase",buffer);
   if ( base != NULL){
     return WSGFcreateName(winname,classname);
   }
//printf("WSGFcreateName ret=%s\n",buffer);
   return buffer;
}

WSCbool WSGFneedGenerateRemoteClass(WSCbase* inst){
  WSCbase* cbase = (WSCbase*)inst->getUserData(WS_WIN_CLASS_BASE);
  if (cbase != NULL){
    if (cbase->getUserData(WS_RCLASS_GENERATE)){
      return True;
    }else{
      return False;
    }
  }else{
    if (inst->getUserData(WS_RCLASS_GENERATE)){
      return True;
    }else{
      return False;
    }
  }
  return False;
}

WSCstring WSGFcreateVirtualRemoteClassHeader(WSCbase* inst){
  WSClistData* rdata = (WSClistData*)inst->getUserData(WS_RMETHOD_LIST);
  WSCstring cname = inst->getInstanceName();
  WSCstring ret;
  char* rcname = (char*)inst->getUserData(WS_RCLASS_NAME);
  if (rcname == NULL){
    WSCstring tmp;
    tmp = inst->getInstanceName();
    if (!strncmp((char*)tmp,"WSC",3)){
      tmp.replaceString("WSC","WSCR",1);
    }else{
      WSCstring tmp2;
      tmp2 << "WSCR" << tmp;
      tmp = tmp2;
    }
    rcname = WSGFstrdup((char*)tmp);
  }

  char* rbcname = (char*)inst->getUserData(WS_RCLASS_BNAME);
  if (rcname == NULL){
    WSCstring tmp;
    tmp = inst->getClassName();
    if (!strncmp((char*)tmp,"WSC",3)){
      tmp.replaceString("WSC","WSCR",1);
    }else{
      WSCstring tmp2;
      tmp2 << "WSCR" << tmp;
      tmp = tmp2;
    }
    rbcname = WSGFstrdup((char*)tmp);
  }

  ret =  "//----------------------------------------------------//\n";
  ret << "// Wide Studio Application C++ Source File            //\n";
  ret << "//            created by Wide Studio source generator //\n";
  ret << "//----------------------------------------------------//\n";
  ret << "#ifndef " << rcname << "_H\n";
  ret << "#define " << rcname << "_H\n\n";
  ret << "#include <WScom.h>\n";
  ret << "#include <" << rbcname << ".h>\n";

  ret << "class ";
  ret << rcname << " :public ";
  ret << rbcname << " {\n\n";
  ret << " public:\n";
  ret << "  " << rcname << "();\n";
  ret << "  ~" << rcname << "();\n\n";

  if (rdata != NULL){

    long i;
    long num = rdata->getNum();

    for(i=0; i<num; i++){
      rmethod_data* rmdata =(rmethod_data*)(*rdata)[i];
      if (rmdata != NULL){
        ret << "  " << rmdata->type_name << " "
            << rmdata->name << "(";
        WSCstring params;
        params = rmdata->params;
        long j;
        long pnum = params.getWords(",");
        for(j=0; j<pnum; j++){
          WSCstring tname;
          WSCstring pname;
          tname = params.getWord(j,",");
          j++;
          pname = params.getWord(j,",");
          ret << tname << " " << pname;
          if (j+1 < pnum){
            ret << ",";
          }
        }
        ret << ");\n";
      }
    }

  }
  ret << "  WSMFclassDef(" << rcname << "," <<
          rbcname << ");\n";
  ret << "};\n";
  ret << "#endif\n";
  return ret;
}

WSCstring WSGFcreateVirtualRemoteClassSrc(WSCbase* inst){
  WSClistData* rdata = (WSClistData*)inst->getUserData(WS_RMETHOD_LIST);
  WSCstring cname = inst->getInstanceName();
  WSCstring ret;
  char* rcname = (char*)inst->getUserData(WS_RCLASS_NAME);
  if (rcname == NULL){
    WSCstring tmp;
    tmp = inst->getInstanceName();
    if (!strncmp((char*)tmp,"WSC",3)){
      tmp.replaceString("WSC","WSCR",1);
    }else{
      WSCstring tmp2;
      tmp2 << "WSCR" << tmp;
      tmp = tmp2;
    }
    rcname = WSGFstrdup((char*)tmp);
  }

  char* rbcname = (char*)inst->getUserData(WS_RCLASS_BNAME);
  if (rcname == NULL){
    WSCstring tmp;
    tmp = inst->getClassName();
    if (!strncmp((char*)tmp,"WSC",3)){
      tmp.replaceString("WSC","WSCR",1);
    }else{
      WSCstring tmp2;
      tmp2 << "WSCR" << tmp;
      tmp = tmp2;
    }
    rbcname = WSGFstrdup((char*)tmp);
  }

  ret =  "//----------------------------------------------------//\n";
  ret << "// Wide Studio Application C++ Source File            //\n";
  ret << "//            created by Wide Studio source generator //\n";
  ret << "//----------------------------------------------------//\n";

  ret << "#include <WScom.h>\n";
  ret << "#include <" << rcname << ".h>\n";
  ret << "#include <" << inst->getInstanceName() << ".h>\n";
  ret << "#include <WSCbase.h>\n";
  ret << "#include <WSCbaseList.h>\n\n";
  ret << "WSMFclassInit(" << rcname << "," << rbcname << ");\n";
  ret << "WSMFremoteClassInit(" << rcname << "," << inst->getInstanceName() << ");\n\n";

  ret << rcname << "::" << rcname << "(){\n}\n\n";
  ret << rcname << "::~" << rcname << "(){\n}\n\n";

  if (rdata != NULL){

    long i;
    long num = rdata->getNum();

    for(i=0; i<num; i++){
      rmethod_data* rmdata =(rmethod_data*)(*rdata)[i];
      if (rmdata != NULL){
        ret << rmdata->type_name << " " << rcname << "::"
            << rmdata->name << "(";
        WSCstring params;
        params = rmdata->params;
        long j;
        long pnum = params.getWords(",");
        for(j=0; j<pnum; j++){
          WSCstring tname;
          WSCstring pname;
          if (!strcmp(pname,"")){
            pname << "p"<< j;
          }
          tname = params.getWord(j,","); j++;
          pname = params.getWord(j,",");
          ret << tname << " " << pname;
          if (j+1 < pnum){
            ret << ",";
          }
        }
        ret << "){\n";
        ret << "  if (_local != NULL){\n";
        ret << "    " << inst->getInstanceName() << "* item = (";
        ret << inst->getInstanceName() << "*)_local->cast(\"";
        ret << inst->getInstanceName() << "\");\n";
        ret << "    if (item != NULL){\n";
        if (strcmp((char*)rmdata->type_name,"void")){
          ret << "      return item->" << rmdata->name << "(";
        }else{
          ret << "      item->" << rmdata->name << "(";
        }
        for(j=0; j<pnum; j++){
          WSCstring pname;
          j++;
          pname = params.getWord(j,",");
          if (!strcmp(pname,"")){
            pname << "p"<< j;
          }
          ret << pname;

          if (j+1 < pnum){
            ret << ",";
          }
        }
        ret << ");\n";
        if (!strcmp((char*)rmdata->type_name,"void")){
          ret << "      return;\n";
        }
        ret << "    }\n";
        ret << "  }\n";
        ret << "  WSCremoteCall rc;\n";
        ret << "  rc.setClassName(\"" << inst->getInstanceName() << "\");\n";
        ret << "  rc.setOperationName(\"" << rmdata->name << "\");\n";
        ret << "  beginRemoteCall(&rc);\n";
        ret << "  if (_db == NULL){\n";
        if (!strcmp((char*)rmdata->type_name,"void")){
          ret << "    return;\n";
        }else
        if (!strcmp((char*)rmdata->type_name,"char*")){
          ret << "    return "";\n";
        }else{
          ret << "    return 0;\n";
        }
        ret << "  }\n";

        for(j=0; j<pnum; j++){
          WSCstring tname;
          WSCstring pname;
          if (!strcmp(pname,"")){
            pname << "p"<< j;
          }

          tname = params.getWord(j,",");
          j++;
          pname = params.getWord(j,",");
          if (!strcmp( get_type_name2((char*)tname) ,"String")){
            ret << "  _db->save(WS_DcRString,\""
                << pname << "\",(void*)" << pname << ");\n";
          }else{
            ret << "  _db->save(WS_DcR" << get_type_name2((char*)tname) 
                << ",\"" << pname << "\",(void*)&" << pname << ");\n";
          }

        }
        if (!strcmp((char*)rmdata->type_name,"void")){
        }else
        if (!strcmp((char*)rmdata->type_name,"char*")){
          ret << " char* ret;";
          ret << " _db->loadAlloc(WS_DcRString,\"ret\",(void**)&ret,NULL);\n";
        }else{
          ret << "  " << rmdata->type_name << " ret;\n";
          ret << " _db->load(WS_DcR"
                << get_type_name2((char*)rmdata->type_name) 
                << ",\"ret\",(void**)&ret);\n";
        }
        ret << "  endRemoteCall();\n";
        if (!strcmp((char*)rmdata->type_name,"void")){
          ret << "  return;\n";
        }else{
          ret << "  return ret;\n";
        }
      }
      ret << "}\n";
    }
  }
  ret << "void _" << inst->getInstanceName()
      << "_remote_call(WSDserialize* db,WSCremoteCall* rc){\n";
  long i;
  long num = 0;
  if (rdata != NULL){
    num = rdata->getNum();
  }
  for(i=0; i<num; i++){
    rmethod_data* rmdata =(rmethod_data*)(*rdata)[i];
    if (rmdata != NULL){
      ret << "  if (!strcmp(rc->_op,\"" << rmdata->name << "\")){\n";
      ret << "    WSCbase* inst ="
          << " WSGIappObjectList()->getInstance(rc->_class,rc->_instance);\n";

      if (!strcmp((char*)rmdata->type_name,"void")){
      }else
      if (!strcmp( (char*)rmdata->type_name ,"char*")){
        ret << "    WSCstring ret;\n";
      }else{
        ret << "    " << rmdata->type_name << " ret = 0;\n";
      }

      ret << "    if (inst != NULL){\n";
      ret << "      " << inst->getInstanceName() << "* target = ("
          << inst->getInstanceName() << "*)inst->cast(\""
          << inst->getInstanceName() << "\");\n";
      WSCstring params;
      params = rmdata->params;
      long j;
      long pnum = params.getWords(",");
      for(j=0; j<pnum; j++){
        WSCstring tname;
        WSCstring pname;
        if (!strcmp(pname,"")){
          pname << "p"<< j;
        }
        tname = params.getWord(j,","); j++;
        pname = params.getWord(j,",");

        if (!strcmp( get_type_name2((char*)tname) ,"String")){
          ret << "      char* " << pname << ";\n";
          ret << "      db->loadAlloc(WS_DcRString,\""
              << pname << "\",(void**)&" << pname << ",NULL);\n";
          ret << "      WSCstring " << pname << "_tmp;\n";
          ret << "      " << pname << "_tmp.setString(" << pname
              << ",WS_EN_UTF8);\n";
        }else{
          ret << "      " << tname << " " << pname << ";\n";
          ret << "      db->load(WS_DcR" << get_type_name2((char*)tname) 
              << ",\"" << pname << "\",(void*)&" << pname << ");\n";
        }
      }
      ret << "      if (target != NULL){\n";
      if (!strcmp(rmdata->type_name,"void")){
        ret << "        target->" << rmdata->name << "(";
      }else
      if (!strcmp( (char*)rmdata->type_name ,"char*")){
        ret << "        ret.setString( target->" << rmdata->name << "(";
      }else{
        ret << "        ret = target->" << rmdata->name << "(";
      }
      for(j=0; j<pnum; j++){
        WSCstring tname;
        WSCstring pname;
        if (!strcmp(pname,"")){
          pname << "p"<< j;
        }
        tname = params.getWord(j,","); j++;
        pname = params.getWord(j,",");

        if (!strcmp( get_type_name2((char*)tname) ,"String")){
          ret << pname << "_tmp";
        }else{
          ret << pname;
        }
        if (j+1 < pnum){
          ret << ",";
        }
      }
      ret << ")";
      if (!strcmp((char*)rmdata->type_name,"void")){
        ret << ";\n";
        ret << "        return;\n";
        ret << "      }\n";
        ret << "    }\n";
        ret << "    return;\n";
      }else
      if (!strcmp( (char*)rmdata->type_name ,"char*")){
        ret << ",WSGIappLocaleSet()->getDefaultEncoding());\n";
        ret << "      }\n";
        ret << "    }\n";
        ret << "    db->save(WS_DcR"
            << get_type_name2((char*)rmdata->type_name)
            << ",\"ret\",(void*)ret.getString(WS_EN_UTF8));\n";
        ret << "    return;\n";
      }else{
        ret << ";\n";
        ret << "      }\n";
        ret << "    }\n";
        ret << "    db->save(WS_DcR"
            << get_type_name2((char*)rmdata->type_name)
            << ",\"ret\",(void*)&ret);\n";
        ret << "    return;\n";
      }
      if (i+1<num){
        ret << "  }else\n";
      }else{
        ret << "  }\n";
      }
    }
  }
//XXZZ
  ret << "extern void _" << inst->getClassName()
      << "_remote_call(WSDserialize* db,WSCremoteCall* rc);\n";
  ret << "  _" << inst->getClassName() << "_remote_call(db,rc);\n}\n\n";

  ret << "WSMFdefineDrNetServer(" << inst->getInstanceName()
      << ",_" << inst->getInstanceName() << "_remote_call);\n\n";
  return ret;
}

void WSGFcreateWindowIncludeList(WSClistData* list,WSCbase* base){
  long i;
  long num = list->getNum();
  WSCbool fl = False;
  for(i=0; i< num; i++){
    WSCbase* lb = (WSCbase*)(*list)[i];
    if (!WSGFstrcmp(lb->getClassName(),base->getClassName())){
      fl = True;
      break;
    }
  }
  if (fl == False){
    list->add(base);
  }

  WSClistData children = base->getChildren();
  num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowIncludeList(list,child);
    }
  }
}

void WSGFcreateWindowInstanceList(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array == True){
      sprintf(buffer,"%s** %s = NULL;\n",base->getClassName(),arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
    }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"%s* %s = NULL;\n",base->getClassName(),base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceList(str,child);
    }
  }
}
void WSGFcreateWindowInstanceMemberList(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array == True){
      sprintf(buffer,"%s** %s;\n",base->getClassName(),arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
    }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"%s* %s;\n",base->getClassName(),base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceMemberList(str,child);
    }
  }
}


void WSGFcreateWindowInstanceListRb(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array == True){
//      sprintf(buffer,"$%s = []\n",arrayn);
      sprintf(buffer,"  attr_reader :%s\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
    }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
//      sprintf(buffer,"$%s\n",base->getInstanceName());
      sprintf(buffer,"  attr_reader :%s\n",base->getInstanceName());
      *str += buffer;
    }else{
//      sprintf(buffer,"$%s\n",base->getInstanceName());
      sprintf(buffer,"  attr_reader :%s\n",base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceListRb(str,child);
    }
  }
}

void WSGFcreateWindowInstanceListPy(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array == True){
      sprintf(buffer,"%s = {}\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
    }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"%s = None\n",base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"%s = None\n",base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceListPy(str,child);
    }
  }
}

void WSGFcreateWindowInstanceList2Py(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array == True){
      sprintf(buffer,"\tglobal %s\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceList2Py(str,child);
    }
  }
}

void WSGFcreateWindowInstanceExternList(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array == True){
      sprintf(buffer,"extern %s** %s;\n",base->getClassName(),arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
    }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"extern %s* %s;\n",base->getClassName(),base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceExternList(str,child);
    }
  }
}

void WSGFcreateWindowInstanceInitList(WSCstring* str,WSCbase* base){
  char buffer[1024];
  if (base->getInternalObject() == False){
    if ((long)base->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"  %s = NULL;\n",base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long num = children.getNum();
  if (num != 0){
    long i;
    WSCstring tmp1;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSGFcreateWindowInstanceInitList(&tmp1,child);
      }
    }
    *str += tmp1;
  }
}

void _create_array_data(WSCbase* base,WSClistData* aname,WSClistData* anos,WSClistData* atype){
  char arrayn[1024];
  long ano;
  long i;
  long num;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (array != False){
    num = aname->getNum();
    WSCbool fl = False;
    for(i=0; i<num; i++){
      char* an = (char*)(*aname)[i];
      if (!WSGFstrcmp(an,arrayn)){
        fl = True;
        long no = (long)(*anos)[i];
        if (no < ano){
          anos->setData(i,(void*)ano);
        }
        break;
      }
    }
    if (fl == False){
      aname->add((void*)WSGFstrdup(arrayn));
      anos->add((void*)ano);
      atype->add((void*)WSGFstrdup(base->getClassName()));
    }
  }
  WSClistData children = base->getChildren();
  num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      _create_array_data(child,aname,anos,atype);
    }
  }
}

void WSGFcreateWindowArrayInstanceSetupOcaml(WSCstring* str,WSCbase* base){
  WSClistData atype;
  WSClistData aname;
  WSClistData anos;
  _create_array_data(base,&aname,&anos,&atype);
  *str += "\n";
  long i;
  long num = aname.getNum();
  for(i=0; i<num; i++){
    char buffer[1024];
    sprintf(buffer,"let %s = ref (Array.init %d (fun n -> C_void))\n",(char*)aname[i],(long)anos[i]+1);
    *str += buffer;
    delete[] (char*)aname[i];
    delete[] (char*)atype[i];
  }
  *str += "\n";
}


void WSGFcreateWindowArrayInstanceSetup(WSCstring* str,WSCbase* base){
  WSClistData atype;
  WSClistData aname;
  WSClistData anos;
  _create_array_data(base,&aname,&anos,&atype);
  *str += "\n";
  long i;
  long num = aname.getNum();
  for(i=0; i<num; i++){
    char buffer[1024];
    sprintf(buffer,"\t%s = new %s*[%d];\n",(char*)aname[i],(char*)atype[i],(long)anos[i]+1);
    *str += buffer;
    delete[] (char*)aname[i];
    delete[] (char*)atype[i];
  }
  *str += "\n";
}

void WSGFcreateWindowInstanceSrc(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    sprintf(buffer,"    %s = new  %s(%s,\"%s\");\n",base->getInstanceName(),
      base->getClassName(),parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"  %s = new  %s(NULL,\"%s\");\n",base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  %s = new  %s(%s,\"%s\");\n",base->getInstanceName(),
        base->getClassName(),parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
    }
  }else{
    if (parent == NULL){
      sprintf(buffer,"  %s*     %s = new  %s(NULL,\"%s\");\n",base->getClassName(),
        base->getInstanceName(),base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  %s* %s = new  %s(%s,\"%s\");\n",base->getClassName(),
        base->getInstanceName(),base->getClassName(),parent->getInstanceName(),
              base->getInstanceName());
      *str += buffer;
    }
  }
  sprintf(buffer,"      %s->initialize();\n",base->getInstanceName());
  *str += buffer;

  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      sprintf(buffer,"  %s->setPropertyV(WSN%s,\"%s\");\n",
        base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      *str += buffer;
    }else{
      sprintf(buffer,"  %s->setPropertyV(WSN%s,(%s)%s);\n",
        base->getInstanceName(),
        prop->getPropObjName(),prop->getPropObjTypeName(),
        (char*)base->getProperty(prop->getPropObjName()));
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
#if 0
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    char objname[1024];
    if (is_array != False){
      sprintf(objname,"%sARY%d",arrayn,ano);
    }else{
      sprintf(objname,"%s",base->getInstanceName());
    }
#endif
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
#if 0
    sprintf(buffer,"    WSCprocedure* op_%s_%d = new WSCprocedure(\"%s\",%d);\n",
       objname,i,ac->getProcName(),ac->getTrigger());
    *str += buffer;
#endif
    sprintf(buffer,"    extern void %s(WSCbase*);\n",ac->getFunctionName());
    *str += buffer;
#if 0
    sprintf(buffer,"    op_%s_%d->setFunction(%s,\"%s\");\n",objname,i,
      ac->getFunctionName(),ac->getFunctionName());
    *str += buffer;
    sprintf(buffer,"    %s->addProcedure(op_%s_%d);\n",base->getInstanceName(),
      objname,i);
    *str += buffer;
#endif
    sprintf(buffer,"    %s->addProcedureV(\"%s\",\"%s\",%s,%d);\n",
           base->getInstanceName(),
           ac->getProcName(),
           ac->getFunctionName(),ac->getFunctionName(),
           ac->getTrigger());
    *str += buffer;

  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrc(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}

void WSGFcreateWindowInstanceSrcRb(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
//      sprintf(buffer,"  $%s = Mpfc::%s.new($%s,\"%s\")\n",
//             base->getInstanceName(),
//             base->getClassName(),
//             parent->getInstanceName(),base->getInstanceName());
      sprintf(buffer,"    @%s ||= []\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
      sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
             base->getInstanceName(),base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }else{
//      sprintf(buffer,"  $%s = Mpfc::%s.new(%s,\"%s\")\n",
//             base->getInstanceName(),
//             base->getClassName(),
//             parent->getInstanceName(),base->getInstanceName());
      sprintf(buffer,"    @%s ||= []\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
      sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
             base->getInstanceName(),base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }

    *str += buffer;
//    sprintf(buffer,"    $%s.init\n",base->getInstanceName());
    sprintf(buffer,"    @%s.init\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
//      sprintf(buffer,"  $%s = Mpfc::%s.new(nil,\"%s\")\n",base->getInstanceName(),
//              base->getClassName(),base->getInstanceName());
      sprintf(buffer, "  def initialize(arg1 = nil, arg2 = \"%s\")\n",
              base->getInstanceName());
      *str += buffer;
      sprintf(buffer, "    super(arg1,arg2)\n    @%s = self\n",
              base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s = Mpfc::%s.new($%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }else{
//        sprintf(buffer,"        $%s = Mpfc::%s.new(%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }
      *str += buffer;
    }
//    sprintf(buffer,"    $%s.init\n",base->getInstanceName());
    sprintf(buffer,"    @%s.init\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
//      sprintf(buffer,"  $%s = Mpfc::%s.new(nil,\"%s\")\n",base->getInstanceName(),
//              base->getClassName(),base->getInstanceName());
      sprintf(buffer, "  def initialize(arg1 = nil, arg2 = \"%s\")\n",
              base->getInstanceName());
      *str += buffer;
      sprintf(buffer, "    super(arg1,arg2)\n    @%s = self\n",
              base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s = Mpfc::%s.new($%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }else{
//        sprintf(buffer,"        $%s = Mpfc::%s.new(%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mpfc::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }
      *str += buffer;
    }
//    sprintf(buffer,"    $%s.init\n",base->getInstanceName());
    sprintf(buffer,"    @%s.init\n",base->getInstanceName());
    *str += buffer;
  }

  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s.setProperty(\"%s\",\"%s\")\n",
//          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
        sprintf(buffer,"    @%s.setProperty(\"%s\",\"%s\")\n",
              base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
//        sprintf(buffer,"        %s.setProperty(\"%s\",\"%s\")\n",
//          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
        sprintf(buffer,"    @%s.setProperty(\"%s\",\"%s\")\n",
              base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s.setProperty(\"%s\",%s);\n",
//          base->getInstanceName(),
//          prop->getPropObjName(),
//          (char*)base->getProperty(prop->getPropObjName()));
        sprintf(buffer,"    @%s.setProperty(\"%s\",%s)\n",
              base->getInstanceName(), prop->getPropObjName(),
              (char*)base->getProperty(prop->getPropObjName()));
      }else{
//        sprintf(buffer,"        %s.setProperty(\"%s\",%s);\n",
//          base->getInstanceName(),
//          prop->getPropObjName(),
//          (char*)base->getProperty(prop->getPropObjName()));
        sprintf(buffer,"    @%s.setProperty(\"%s\",%s)\n",
              base->getInstanceName(), prop->getPropObjName(),
              (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
//                               arrayn,ano,ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
              arrayn,ano,ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }else{
//        sprintf(buffer,"        %s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
//                               arrayn,ano,ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
              arrayn,ano,ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s.addProcedure(\"%s\",\"%s\",%d)\n",
//                               base->getInstanceName(),
//                               ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s.addProcedure(\"%s\",\"%s\",%d)\n",
              base->getInstanceName(),ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }else{
//        sprintf(buffer,"        %s.addProcedure(\"%s\",\"%s\",%d)\n",
//                               base->getInstanceName(),
//                               ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s.addProcedure(\"%s\",\"%s\",%d)\n",
              base->getInstanceName(),ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
//    WSCstring  tmpbuf;
//    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
//        WSCstring tmp1;
//        WSGFcreateWindowInstanceSrcRb(&tmp1,base,child);
//        tmpbuf += tmp1;
//        cnt++;
//        if (cnt > 20){
//          cnt=0;
//          *str += tmpbuf;
//          tmpbuf = "";
//        }
        WSGFcreateWindowInstanceSrcRb(str,base,child);
      }
    }
//    if (cnt > 0){
//      *str += tmpbuf;
//    }
  }
}

void WSGFcreateWindowInstanceSrcMwtRb(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
//      sprintf(buffer,"  $%s = Mwt::%s.new($%s,\"%s\")\n",
//             base->getInstanceName(),
//             base->getClassName(),
//             parent->getInstanceName(),base->getInstanceName());
      sprintf(buffer,"    @%s ||= []\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
      sprintf(buffer,"    @%s = Mwt::%s.new(@%s,\"%s\")\n",
             base->getInstanceName(),base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }else{
//      sprintf(buffer,"  $%s = Mwt::%s.new(%s,\"%s\")\n",
//             base->getInstanceName(),
//             base->getClassName(),
//             parent->getInstanceName(),base->getInstanceName());
      sprintf(buffer,"    @%s ||= []\n",arrayn);
      //if array,and noexisting, add into...
      if (str->isExist(buffer) == -1){
        *str += buffer;
      }
      sprintf(buffer,"    @%s = Mwt::%s.new(@%s,\"%s\")\n",
             base->getInstanceName(),base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }

    *str += buffer;
//    sprintf(buffer,"    $%s.init\n",base->getInstanceName());
    sprintf(buffer,"    @%s.init\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
//      sprintf(buffer,"  $%s = Mwt::%s.new(nil,\"%s\")\n",base->getInstanceName(),
//              base->getClassName(),base->getInstanceName());
      sprintf(buffer, "  def initialize(arg1 = nil, arg2 = \"%s\")\n",
              base->getInstanceName());
      *str += buffer;
      sprintf(buffer, "    super(arg1,arg2)\n    @%s = self\n",
              base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s = Mwt::%s.new($%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mwt::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }else{
//        sprintf(buffer,"        $%s = Mwt::%s.new(%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mwt::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }
      *str += buffer;
    }
//    sprintf(buffer,"    $%s.init\n",base->getInstanceName());
    sprintf(buffer,"    @%s.init\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
//      sprintf(buffer,"  $%s = Mwt::%s.new(nil,\"%s\")\n",base->getInstanceName(),
//              base->getClassName(),base->getInstanceName());
      sprintf(buffer, "  def initialize(arg1 = nil, arg2 = \"%s\")\n",
              base->getInstanceName());
      *str += buffer;
      sprintf(buffer, "    super(arg1,arg2)\n    @%s = self\n",
              base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s = Mwt::%s.new($%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mwt::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }else{
//        sprintf(buffer,"        $%s = Mwt::%s.new(%s,\"%s\")\n",
//                       base->getInstanceName(),
//                       base->getClassName(),
//                       parent->getInstanceName(),base->getInstanceName());
        sprintf(buffer,"    @%s = Mwt::%s.new(@%s,\"%s\")\n",
                       base->getInstanceName(),base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }
      *str += buffer;
    }
//    sprintf(buffer,"    $%s.init\n",base->getInstanceName());
    sprintf(buffer,"    @%s.init\n",base->getInstanceName());
    *str += buffer;
  }

  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s.setProperty(\"%s\",\"%s\")\n",
//          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
        sprintf(buffer,"    @%s.setProperty(\"%s\",\"%s\")\n",
              base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
//        sprintf(buffer,"        %s.setProperty(\"%s\",\"%s\")\n",
//          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
        sprintf(buffer,"    @%s.setProperty(\"%s\",\"%s\")\n",
              base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s.setProperty(\"%s\",%s);\n",
//          base->getInstanceName(),
//          prop->getPropObjName(),
//          (char*)base->getProperty(prop->getPropObjName()));
        sprintf(buffer,"    @%s.setProperty(\"%s\",%s)\n",
              base->getInstanceName(), prop->getPropObjName(),
              (char*)base->getProperty(prop->getPropObjName()));
      }else{
//        sprintf(buffer,"        %s.setProperty(\"%s\",%s);\n",
//          base->getInstanceName(),
//          prop->getPropObjName(),
//          (char*)base->getProperty(prop->getPropObjName()));
        sprintf(buffer,"    @%s.setProperty(\"%s\",%s)\n",
              base->getInstanceName(), prop->getPropObjName(),
              (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
//                               arrayn,ano,ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
              arrayn,ano,ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }else{
//        sprintf(buffer,"        %s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
//                               arrayn,ano,ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
              arrayn,ano,ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
//        sprintf(buffer,"        $%s.addProcedure(\"%s\",\"%s\",%d)\n",
//                               base->getInstanceName(),
//                               ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s.addProcedure(\"%s\",\"%s\",%d)\n",
              base->getInstanceName(),ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }else{
//        sprintf(buffer,"        %s.addProcedure(\"%s\",\"%s\",%d)\n",
//                               base->getInstanceName(),
//                               ac->getProcName(),
//                               ac->getFunctionName(),ac->getTrigger());
        sprintf(buffer,"    @%s.addProcedure(\"%s\",\"%s\",%d)\n",
              base->getInstanceName(),ac->getProcName(),
              ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
//    WSCstring  tmpbuf;
//    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
//        WSCstring tmp1;
//        WSGFcreateWindowInstanceSrcRb(&tmp1,base,child);
//        tmpbuf += tmp1;
//        cnt++;
//        if (cnt > 20){
//          cnt=0;
//          *str += tmpbuf;
//          tmpbuf = "";
//        }
        WSGFcreateWindowInstanceSrcMwtRb(str,base,child);
      }
    }
//    if (cnt > 0){
//      *str += tmpbuf;
//    }
  }
}

void WSGFcreateWindowInstanceSrc2Rb(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    sprintf(buffer,"$%s = []\n",arrayn);
    //if array,and noexisting, add into...
    if (str->isExist(buffer) == -1){
      *str += buffer;
    }
    if ( (long)base->getParentWindow()->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"$%s = $%s.%s\n",
              base->getInstanceName(),
              base->getParentWindow()->getInstanceName(),base->getInstanceName());
    }else{
      sprintf(buffer,"$%s = %s.%s\n",
              base->getInstanceName(),
              base->getParentWindow()->getInstanceName(),base->getInstanceName());
    }
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer, "$%s = Newwin_%s.new\n",
              base->getInstanceName(), base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)base->getParentWindow()->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"$%s = $%s.%s\n",
                       base->getInstanceName(),
                       base->getParentWindow()->getInstanceName(),
                       base->getInstanceName());
      }else{
        sprintf(buffer,"$%s = %s.%s\n",
                       base->getInstanceName(),
                       base->getParentWindow()->getInstanceName(),
                       base->getInstanceName());
      }
      *str += buffer;
    }
  }else{
    if (parent == NULL){
      sprintf(buffer, "%s = Newwin_%s.new\n",
              base->getInstanceName(), base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)base->getParentWindow()->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"%s = $%s.%s\n",
                       base->getInstanceName(),
                       base->getParentWindow()->getInstanceName(),
                       base->getInstanceName());
      }else{
        sprintf(buffer,"%s = %s.%s\n",
                       base->getInstanceName(),
                       base->getParentWindow()->getInstanceName(),
                       base->getInstanceName());
      }
      *str += buffer;
    }
  }

  //*str += "\n";

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  if (num != 0){
//    WSCstring  tmpbuf;
//    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
//        WSCstring tmp1;
//        WSGFcreateWindowInstanceSrc2Rb(&tmp1,base,child);
//        tmpbuf += tmp1;
//        cnt++;
//        if (cnt > 20){
//          cnt=0;
//          *str += tmpbuf;
//          tmpbuf = "";
//        }
        WSGFcreateWindowInstanceSrc2Rb(str,base,child);
      }
    }
//    if (cnt > 0){
//      *str += tmpbuf;
//    }
  }
}


void WSGFcreateWindowInstanceSrcPy(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"\t%s = mpfc.%s(%s,\"%s\")\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }else{
      sprintf(buffer,"\t%s = mpfc.%s(%s,\"%s\")\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }
    *str += buffer;
    sprintf(buffer,"\t%s.initialize()\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(None,\"%s\")\n",
              base->getInstanceName(),
              base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(%s,\"%s\")\n",
                       base->getInstanceName(),
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }else{
        sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(%s,\"%s\")\n",
                       base->getInstanceName(),
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }
      *str += buffer;
    }
    sprintf(buffer,"\t%s.initialize()\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
      sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(None,\"%s\")\n",
        base->getInstanceName(),
        base->getInstanceName(),
        base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(%s,\"%s\")\n",
              base->getInstanceName(),
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      }else{
        sprintf(buffer,"\tglobal %s\n\t%s = mpfc.%s(%s,\"%s\")\n",
              base->getInstanceName(),
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      }
      *str += buffer;
    }
    sprintf(buffer,"\t%s.initialize()\n",base->getInstanceName());
    *str += buffer;
  }

  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s.setProperty(\"%s\",\"%s\")\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
        sprintf(buffer,"\t%s.setProperty(\"%s\",\"%s\")\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s.setProperty(\"%s\",%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }else{
        sprintf(buffer,"\t%s.setProperty(\"%s\",%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"\t%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s.addProcedure(\"%s\",\"%s\",%d)\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"\t%s.addProcedure(\"%s\",\"%s\",%d)\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrcPy(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}

void WSGFcreateWindowInstanceSrcMwtPy(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
      sprintf(buffer,"\t%s = mwt.%s(%s,\"%s\")\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }else{
      sprintf(buffer,"\t%s = mwt.%s(%s,\"%s\")\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    }
    *str += buffer;
    sprintf(buffer,"\t%s.initialize()\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"\tglobal %s\n\t%s = mwt.%s(None,\"%s\")\n",
              base->getInstanceName(),
              base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\tglobal %s\n\t%s = mwt.%s(%s,\"%s\")\n",
                       base->getInstanceName(),
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }else{
        sprintf(buffer,"\tglobal %s\n\t%s = mwt.%s(%s,\"%s\")\n",
                       base->getInstanceName(),
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      }
      *str += buffer;
    }
    sprintf(buffer,"\t%s.initialize()\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
      sprintf(buffer,"\tglobal %s\n\t%s = mwt.%s(None,\"%s\")\n",
        base->getInstanceName(),
        base->getInstanceName(),
        base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      if ( (long)parent->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\tglobal %s\n\t%s = mwt.%s(%s,\"%s\")\n",
              base->getInstanceName(),
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      }else{
        sprintf(buffer,"\tglobal %s\n\t%s = mwt.%s(%s,\"%s\")\n",
              base->getInstanceName(),
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      }
      *str += buffer;
    }
    sprintf(buffer,"\t%s.initialize()\n",base->getInstanceName());
    *str += buffer;
  }

  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s.setProperty(\"%s\",\"%s\")\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
        sprintf(buffer,"\t%s.setProperty(\"%s\",\"%s\")\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s.setProperty(\"%s\",%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }else{
        sprintf(buffer,"\t%s.setProperty(\"%s\",%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"\t%s[%d].addProcedure(\"%s\",\"%s\",%d)\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"\t%s.addProcedure(\"%s\",\"%s\",%d)\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"\t%s.addProcedure(\"%s\",\"%s\",%d)\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrcMwtPy(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}

#if 0
void WSGFcreateWindowInstanceSrcPerl(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    sprintf(buffer,"    $%s = mpfc::new_%s($%s,\"%s\");\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    *str += buffer;
    sprintf(buffer,"    mpfc::WSCbase_init($%s);\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"  $%s = mpfc::new_%s($void,\"%s\");\n",base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  $%s = mpfc::new_%s($%s,\"%s\");\n",
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    mpfc::WSCbase_init($%s);\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
      sprintf(buffer,"  $%s = mpfc::new_%s($void,\"%s\");\n",
        base->getInstanceName(),base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
//      sprintf(buffer,"  local($%s) = mpfc::new_%s($%s,\"%s\");\n", //This causes deleting instances..
      sprintf(buffer,"  $%s = mpfc::new_%s($%s,\"%s\");\n",
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    mpfc::WSCbase_init($%s);\n",base->getInstanceName());
    *str += buffer;
  }


  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        mpfc::WSCbase_setProperty($%s,'%s','%s');\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
        sprintf(buffer,"        mpfc::WSCbase_setProperty($%s,'%s','%s');\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        mpfc::WSCbase_setProperty($%s,'%s',%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }else{
        sprintf(buffer,"        mpfc::WSCbase_setProperty($%s,'%s',%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        mpfc::WSCbase_addProcedure($%s[%d],'%s','%s',%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"        mpfc::WSCbase_addProcedure($%s[%d],'%s','%s',%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        mpfc::WSCbase_addProcedure($%s,'%s','%s',%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"        mpfc::WSCbase_addProcedure($%s,'%s','%s',%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrcPerl(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}
#endif
void WSGFcreateWindowInstanceSrcPerl(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    sprintf(buffer,"    $%s = new mpfc::%s($%s,\"%s\");\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    *str += buffer;
    sprintf(buffer,"    $%s->init();\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"  $%s = new mpfc::%s($void,\"%s\");\n",base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  $%s = new mpfc::%s($%s,\"%s\");\n",
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    $%s->init();\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
      sprintf(buffer,"  $%s = new mpfc::%s($void,\"%s\");\n",
        base->getInstanceName(),base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
//      sprintf(buffer,"  local($%s) = new mpfc::%s($%s,\"%s\");\n", //This causes deleting instances..
      sprintf(buffer,"  $%s = new mpfc::%s($%s,\"%s\");\n",
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    $%s->init();\n",base->getInstanceName());
    *str += buffer;
  }


  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s->setProperty('%s','%s');\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
        sprintf(buffer,"        $%s->setProperty('%s','%s');\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s->setProperty('%s',%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }else{
        sprintf(buffer,"        $%s->setProperty('%s',%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s[%d]->addProcedure('%s','%s',%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"        $%s[%d]->addProcedure('%s','%s',%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s->addProcedure('%s','%s',%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"        $%s->addProcedure('%s','%s',%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrcPerl(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}

void WSGFcreateWindowInstanceSrcMwtPerl(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    sprintf(buffer,"    $%s = new mwt::%s($%s,\"%s\");\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    *str += buffer;
    sprintf(buffer,"    $%s->init();\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"  $%s = new mwt::%s($void,\"%s\");\n",base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  $%s = new mwt::%s($%s,\"%s\");\n",
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    $%s->init();\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
      sprintf(buffer,"  $%s = new mwt::%s($void,\"%s\");\n",
        base->getInstanceName(),base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
//      sprintf(buffer,"  local($%s) = new mwt::%s($%s,\"%s\");\n", //This causes deleting instances..
      sprintf(buffer,"  $%s = new mwt::%s($%s,\"%s\");\n",
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    $%s->init();\n",base->getInstanceName());
    *str += buffer;
  }


  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s->setProperty('%s','%s');\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
        sprintf(buffer,"        $%s->setProperty('%s','%s');\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s->setProperty('%s',%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }else{
        sprintf(buffer,"        $%s->setProperty('%s',%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s[%d]->addProcedure('%s','%s',%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"        $%s[%d]->addProcedure('%s','%s',%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"        $%s->addProcedure('%s','%s',%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"        $%s->addProcedure('%s','%s',%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrcMwtPerl(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}

void WSGFcreateWindowInstanceSrcJava(WSCstring* str,WSCbase* parent,WSCbase* base,char* pkgname){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    sprintf(buffer,"    %s = new %s(%s,\"%s\");\n",
             base->getInstanceName(),
             base->getClassName(),
             parent->getInstanceName(),base->getInstanceName());
    *str += buffer;
    sprintf(buffer,"    %s.init();\n",base->getInstanceName());
    *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"    %s = new %s(null,\"%s\");\n",base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"    %s = new %s(%s,\"%s\");\n",
                       base->getInstanceName(),
                       base->getClassName(),
                       parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    %s.init();\n",base->getInstanceName());
    *str += buffer;
  }else{
    if (parent == NULL){
      sprintf(buffer,"    %s = new %s(null,\"%s\");\n",
        base->getInstanceName(),base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"    %s = new %s(%s,\"%s\");\n",
              base->getInstanceName(),base->getClassName(),
              parent->getInstanceName(),
              base->getInstanceName());
      *str += buffer;
    }
    sprintf(buffer,"    %s.init();\n",base->getInstanceName());
    *str += buffer;
  }


  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"    %s.setProperty(\"%s\",\"%s\");\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }else{
        sprintf(buffer,"    %s.setProperty(\"%s\",\"%s\");\n",
          base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      }
      *str += buffer;
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"    %s.setProperty(\"%s\",%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }else{
        sprintf(buffer,"    %s.setProperty(\"%s\",%s);\n",
          base->getInstanceName(),
          prop->getPropObjName(),
          (char*)base->getProperty(prop->getPropObjName()));
      }
      *str += buffer;
    }
  }
  WSCstring pkg(pkgname);
  pkg.delHeadSpace();
  pkg.delTailSpace();
  pkg << ".";
  pkg.replaceString(".","/",0);
  pkg.replaceString("//","/",0);
  if (!strcmp(pkg,"/")){
    pkg = "";
  }
  if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    sprintf(buffer,
      "    %s.setVariantData(\"package_name\",\"%s\");\n",
      base->getInstanceName(),(char*)pkg);
  }else{
    sprintf(buffer,
      "    %s.setVariantData(\"package_name\",\"%s\");\n",
      base->getInstanceName(),(char*)pkg);
  }
  *str += buffer;

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    if (is_array != False){
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"    %s[%d].addProcedure(\"%s\",\"%s.%s\",%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"    %s[%d].addProcedure(\"%s\",\"%s.%s\",%d);\n",
                               arrayn,ano,ac->getProcName(),
                               ac->getFunctionName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }else{
      if ( (long)base->getUserData(WS_EXT_VAR) == 1){
        sprintf(buffer,"    %s.addProcedure(\"%s\",\"%s.%s\",%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),
                               ac->getFunctionName(),ac->getTrigger());
      }else{
        sprintf(buffer,"    %s.addProcedure(\"%s\",\"%s.%s\",%d);\n",
                               base->getInstanceName(),
                               ac->getProcName(),
                               ac->getFunctionName(),
                               ac->getFunctionName(),ac->getTrigger());
      }
    }
    *str += buffer;
  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrcJava(&tmp1,base,child,pkgname);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}
void _createWindowInstanceList2Ocaml(WSCstring* str,WSCbase* base){

  WSClistData* op_list = base->getProcedureList();
  long num = op_list->getNum();
  int i;
  for(i=0; i< num; i++){
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }

    char buffer[1024];
    strncpy(buffer,ac->getFunctionName(),1024);
    buffer[1023] = 0;
    if ('a' <= buffer[0] && buffer[0] <= 'z'){
      buffer[0] = buffer[0] - ('a' - 'A');
    }
    *str << "open " << buffer << "\n";
    *str << "let _ = Callback.register \"" << ac->getFunctionName() << "\" " <<
            ac->getFunctionName() << "\n";
  }

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        _createWindowInstanceList2Ocaml(&tmp1,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}
void WSGFcreateWindowInstanceList2Ocaml(WSCstring* str,WSCbase* base){
  char buffer[1024];
  strncpy(buffer,base->getInstanceName(),1024);
  buffer[1023] = 0;
  if ('a' <= buffer[0] && buffer[0] <= 'z'){
    buffer[0] = buffer[0] - ('a' - 'A');
  }
  *str << "open " << buffer << "\n";
  _createWindowInstanceList2Ocaml(str,base);
}
void WSGFcreateWindowInstanceList3Ocaml(WSCstring* str,WSCbase* base){
//  char buffer[1024];
//  strncpy(buffer,base->getInstanceName(),1024);
//  buffer[1023] = 0;
//  if ('a' <= buffer[0] && buffer[0] <= 'z'){
//    buffer[0] = buffer[0] - ('a' - 'A');
//  }
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
    *str << "let _ = Callback.register \"" << base->getInstanceName() << "\" !"
         << arrayn << ".(" << ano << ")\n";
  }else{
    *str << "let _ = Callback.register \"" << base->getInstanceName() << "\" !"
         << base->getInstanceName() << "\n";
  }
  WSClistData children = base->getChildren();
  long num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    long i;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceList3Ocaml(&tmp1,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}
void WSGFcreateWindowInstanceSrcOcaml(WSCstring* str,WSCbase* parent,WSCbase* base){
  char buffer[2048];
  char arrayn[1024];
  long ano;
  char pname[2048];
  char iname[2048];
  WSCbool array = False;
  if (parent != NULL){
    array = WSGFcheckArrayName(parent->getInstanceName(),&ano,arrayn);
    if (array != False){
      sprintf(pname,"%s.(%d)",arrayn,ano);
    }else{
      sprintf(pname,"%s",parent->getInstanceName());
    }
  }
  array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (array != False){
    sprintf(iname,"%s.(%d)",arrayn,ano);
  }else{
    sprintf(iname,"%s",base->getInstanceName());
  }
  if ( array != False){
//TODO:
    sprintf(buffer,"  !%s <- new_%s (C_list [!%s; C_string \"%s\"]);\n",
      iname,
      base->getClassName(),pname,base->getInstanceName());
      *str += buffer;
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent == NULL){
      sprintf(buffer,"  %s := new_%s (C_list [C_int 0; C_string \"%s\"]);\n",base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
    sprintf(buffer,"  %s := new_%s (C_list [!%s; C_string \"%s\"]);\n",base->getInstanceName(),
        base->getClassName(),pname,base->getInstanceName());
      *str += buffer;
    }
  }else{
    if (parent == NULL){
      sprintf(buffer,"  %s := new_%s (C_list [C_int 0; C_string \"%s\"]);\n",
              base->getInstanceName(),
              base->getClassName(),base->getInstanceName());
      *str += buffer;
    }else{
      sprintf(buffer,"  %s := new_%s (C_list [!%s; C_string \"%s\"]);\n",
        base->getInstanceName(),
        base->getClassName(),pname,base->getInstanceName());
      *str += buffer;
    }
  }
  sprintf(buffer,"  ignore(!%s -> \"init\" ());\n",iname);
  *str += buffer;

  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      sprintf(buffer,"  ignore(!%s -> \"setProperty\"(\"%s\",\"%s\"));\n",
        iname,prop->getPropObjName(),sdata.getString());
      *str += buffer;
    }else{
      sprintf(buffer,"  ignore(!%s -> \"setProperty\"(\"%s\",%s));\n",
        iname,
        prop->getPropObjName(),
        (char*)base->getProperty(prop->getPropObjName()));
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    sprintf(buffer,"  ignore(!%s -> \"addProcedure\"(\"%s\",\"%s\",(%d)));\n",
           iname,
           ac->getProcName(),
           ac->getFunctionName(),
           ac->getTrigger());
    *str += buffer;

  }

  *str += "\n";

  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceSrcOcaml(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}
void WSGFcreateWindowInstanceListJava(WSCstring* str,WSCbase* parent,WSCbase* base){
  WSClistData atype;
  WSClistData aname;
  WSClistData anos;
  _create_array_data(base,&aname,&anos,&atype);
  long i;
  long num = aname.getNum();
  for(i=0; i<num; i++){
    char buffer[1024];
    sprintf(buffer,"  static %s[] %s = new %s[%d];\n",(char*)atype[i],(char*)aname[i],(char*)atype[i],(long)anos[i]+1);
    *str += buffer;
    delete (char*)aname[i];
    delete (char*)atype[i];
  }

  char buffer[2048];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if ( array != False){
  }else if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    sprintf(buffer,"  static %s %s = null;\n",
                   base->getClassName(),base->getInstanceName());
    *str += buffer;
  }else{
    sprintf(buffer,"  protected static %s %s = null;\n",
                   base->getClassName(),base->getInstanceName());
    *str += buffer;
  }


  WSClistData children = base->getChildren();
  num = children.getNum();
  if (num != 0){
    WSCstring  tmpbuf;
    long cnt=0;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceListJava(&tmp1,base,child);
        tmpbuf += tmp1;
        cnt++;
        if (cnt > 20){
          cnt=0;
          *str += tmpbuf;
          tmpbuf = "";
        }
      }
    }
    if (cnt > 0){
      *str += tmpbuf;
    }
  }
}
void WSGFcreateWindowInstanceListOcaml(WSCstring* str,WSCbase* base){
  char buffer[1024];
  char arrayn[1024];
  long ano;
  WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
  if (base->getInternalObject() == False){
    if (array != False){
//    }else if ((long)base->getUserData(WS_EXT_VAR) == 1){
    }else{
      sprintf(buffer,"let %s = ref C_void\n",base->getInstanceName());
      *str += buffer;
    }
  }

  WSClistData children = base->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i< num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      WSGFcreateWindowInstanceListOcaml(str,child);
    }
  }
}
void WSGFcreateWindowInstanceClassSrc(WSCstring* str,WSCbase* parent,WSCbase* base){
  if (parent == NULL){ //at first time...
    WSClistData children = base->getChildren();
    long num = children.getNum();
    long i;
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceClassSrc(&tmp1,base,child);
        *str += tmp1;
      }
    }
  }
  char buffer[2048];
  if ( (long)base->getUserData(WS_EXT_VAR) == 1){
    if (parent != NULL){
      sprintf(buffer,"  %s = new  %s(%s,\"%s\");\n",base->getInstanceName(),
        base->getClassName(),parent->getInstanceName(),base->getInstanceName());
      *str += buffer;
      sprintf(buffer,"  %s->initialize();\n",base->getInstanceName());
      *str += buffer;
      sprintf(buffer,"  %s->setInternalObject(True);\n",base->getInstanceName());
      *str += buffer;
    }
  }else{
    if (parent != NULL){
      sprintf(buffer,"  %s* %s = new  %s(%s,\"%s\");\n",base->getClassName(),
        base->getInstanceName(),base->getClassName(),parent->getInstanceName(),
        base->getInstanceName());
      *str += buffer;
      sprintf(buffer,"  %s->initialize();\n",base->getInstanceName());
      *str += buffer;
      sprintf(buffer,"  %s->setInternalObject(True);\n",base->getInstanceName());
      *str += buffer;
    }
  }
  sprintf(buffer,"  %s->setUserData(WS_BASE_CLASS,(void*)this);\n",base->getInstanceName());
  *str += buffer;
  sprintf(buffer,"  %s->setUserData(WS_BASE_CPTR,(void*)((WSCbase*)this));\n",base->getInstanceName());
  *str += buffer;

  WSClistData  props2;
  WSGFgetAllPropertyList(base,&props2);
//  WSClistData* props = base->getClassInformation()->getAllPropertyList();
  WSClistData*  props = &props2;

  WSCproperty* prop;
  long i;
  long num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
//    WSCbool def = prop->isDefaultValue(base);
     WSCbool def = True;
     base->isDefaultValue(prop->getPropObjName(),&def);

    if (def != False){
      continue;
    }
    if (!strcmp(prop->getPropObjName(),"name")){
      continue;
    }
    if (prop->isColorPropObj() != False || prop->isPixmapPropObj() != False ||
        prop->getPropObjType() == WSTcharptr){
      WSCstring sdata(base->getProperty(prop->getPropObjName()));
      sdata.replaceString("\\","\\\\",0);
      sdata.replaceString("\"","\\\"",0);
      sprintf(buffer,"  %s->setPropertyV(WSN%s,\"%s\");\n",base->getInstanceName(),prop->getPropObjName(),sdata.getString());
      *str += buffer;
    }else{
      sprintf(buffer,"  %s->setPropertyV(WSN%s,(%s)%s);\n",base->getInstanceName(),prop->getPropObjName(),prop->getPropObjTypeName(),(char*)base->getProperty(prop->getPropObjName()));
      *str += buffer;
    }
  }

  WSClistData* op_list = base->getProcedureList();
  num = op_list->getNum();
  for(i=0; i< num; i++){
    char arrayn[1024];
    long ano;
    WSCbool is_array = WSGFcheckArrayName(base->getInstanceName(),&ano,arrayn);
    char objname[1024];
    if (is_array != False){
      sprintf(objname,"%sARY%d",arrayn,ano);
    }else{
      sprintf(objname,"%s",base->getInstanceName());
    }
    WSCprocedure* ac = (WSCprocedure*)(*op_list)[i];
    if (ac->getInternal() != False){
      continue;
    }
    sprintf(buffer,"    WSCprocedure* op_%s_%d = new WSCprocedure(\"%s\",%d);\n",
      objname,i,ac->getProcName(),ac->getTrigger());
    *str += buffer;
    sprintf(buffer,"    op_%s_%d->setFunction(%s,\"%s\");\n",objname,i,ac->getFunctionName(),
      ac->getFunctionName());
    *str += buffer;
    sprintf(buffer,"    op_%s_%d->setInternal(True);\n",objname,i);
    *str += buffer;
    sprintf(buffer,"    %s->addProcedure(op_%s_%d);\n",base->getInstanceName(),objname,i);
    *str += buffer;
  }

  *str += "\n";

  if (parent != NULL){
    WSClistData children = base->getChildren();
    num = children.getNum();
    for(i=0; i< num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getInternalObject() == False){
        WSCstring tmp1;
        WSGFcreateWindowInstanceClassSrc(&tmp1,base,child);
        *str += tmp1;
      }
    }
  }
}

WSCstring* WSGFcreateWindowHeader(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "//----------------------------------------------------//\n";
  *str << "// Wide Studio Application C++ Source File            //\n";
  *str << "//            created by Wide Studio source generator //\n";
  *str << "//----------------------------------------------------//\n";
  *str << "#ifndef _" << btarget->getInstanceName() << "_H\n";
  *str << "#define _" << btarget->getInstanceName() << "_H\n";
  *str << "#include <WScom.h>\n#include <WSDappDev.h>\n";
  *str << "\n";
  *str << "//--- OBJECT includes ---//\n";

  WSCstring tmp1;
  long i;
  long num = ilist.getNum();
  for(i=0; i< num; i++){
    WSCbase* base = (WSCbase*)ilist[i];
    char buffer[1024];
    sprintf(buffer,"#include <%s.h>\n",base->getClassName());
    tmp1 += buffer;
  }
  *str << tmp1 << "\n";
  *str << "//--- OBJECT instance variable ---//\n";

  WSGFcreateWindowInstanceExternList(str,btarget);

  *str << "\n";
  *str << "#endif /* _"<< btarget->getInstanceName() << "_H */\n";
  return str;
}

WSCstring* WSGFcreateWindowSrc(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "//----------------------------------------------------//\n";
  *str << "// MWT C++ Application Source File                    //\n";
  *str << "//      created by WideStudio Application Builder     //\n";
  *str << "//----------------------------------------------------//\n";
  *str << "#include <WScom.h>\n#include <WSDappDev.h>\n";
  *str << "\n";
  *str << "//--- OBJECT includes ---//\n";

  WSCstring tmp1;
  long i;
  long num = ilist.getNum();
  for(i=0; i< num; i++){
    WSCbase* base = (WSCbase*)ilist[i];
    char buffer[1024];
    sprintf(buffer,"#include <%s.h>\n",base->getClassName());
    tmp1 += buffer;
  }
  *str << tmp1 << "\n";
  *str << "//--- OBJECT instance variable ---//\n";

  WSGFcreateWindowInstanceList(str,btarget);

  *str << "\n";
  *str << "//--- OBJECT src ---//\n";
  *str << "\n";
  *str << "WSCbase* _create_win_";
  *str << btarget->getInstanceName();
  *str << "(){\n";

  WSGFcreateWindowArrayInstanceSetup(str,btarget);
  WSGFcreateWindowInstanceSrc(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    *str << "   " << btarget->getInstanceName() << "->setVisible(True);\n";
  }
  *str << "   return " << btarget->getInstanceName() << ";\n";
  *str << "}\n\n";
  *str << "//--- end of src ---//\n";
  return str;

}

WSCstring* WSGFcreateWindowSrcRb(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "#----------------------------------------------------\n";
  *str << "# MWT Ruby Application Source File                   \n";
  *str << "#      created by WideStudio Application Builder     \n";
  *str << "#----------------------------------------------------\n";
  *str << "\n";
  *str << "#--- OBJECT src ---\n";
  *str << "\n";
  *str << "class Newwin_";
  *str << btarget->getInstanceName();
  *str << " < Mpfc::";
  *str << btarget->getClassName();
  *str << "\n";

  WSGFcreateWindowInstanceListRb(str,btarget);
  WSGFcreateWindowInstanceSrcRb(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    if ((long)btarget->getUserData(WS_EXT_VAR) == 1){
      *str << "    @" << btarget->getInstanceName() << ".setVisible(1)\n";
    }else{
      *str << "    @" << btarget->getInstanceName() << ".setVisible(1)\n";
    }
  }
  *str << "  end\n";
  *str << "end\n\n";

  WSGFcreateWindowInstanceSrc2Rb(str,NULL,btarget);
  *str << "#--- end of src ---\n";
  return str;
}
WSCstring* WSGFcreateWindowSrcMwtRb(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "#----------------------------------------------------\n";
  *str << "# MWT Ruby Application Source File                   \n";
  *str << "#      created by WideStudio Application Builder     \n";
  *str << "#----------------------------------------------------\n";
  *str << "\n";
  *str << "#--- OBJECT src ---\n";
  *str << "\n";
  *str << "class Newwin_";
  *str << btarget->getInstanceName();
  *str << " < Mwt::";
  *str << btarget->getClassName();
  *str << "\n";

  WSGFcreateWindowInstanceListRb(str,btarget);
  WSGFcreateWindowInstanceSrcMwtRb(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    if ((long)btarget->getUserData(WS_EXT_VAR) == 1){
      *str << "    @" << btarget->getInstanceName() << ".setVisible(1)\n";
    }else{
      *str << "    @" << btarget->getInstanceName() << ".setVisible(1)\n";
    }
  }
  *str << "  end\n";
  *str << "end\n\n";

  WSGFcreateWindowInstanceSrc2Rb(str,NULL,btarget);
  *str << "#--- end of src ---\n";
  return str;
}
WSCstring* WSGFcreateWindowSrcPy(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "#----------------------------------------------------\n";
  *str << "# MWT Python Application Source File                 \n";
  *str << "#      created by WideStudio Application Builder     \n";
  *str << "#----------------------------------------------------\n";
  *str << "import mpfc\n\n";
  *str << "#--- OBJECT instance variable ---\n";

  WSGFcreateWindowInstanceListPy(str,btarget);

  *str << "\n";
  *str << "#--- OBJECT src ---\n";
  *str << "\n";
  *str << "def _create_win_";
  *str << btarget->getInstanceName();
  *str << "():\n";

  WSGFcreateWindowInstanceList2Py(str,btarget);
  WSGFcreateWindowInstanceSrcPy(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    if ((long)btarget->getUserData(WS_EXT_VAR) == 1){
      *str << "\t" << btarget->getInstanceName() << ".setVisible(1)\n";
    }else{
      *str << "\t" << btarget->getInstanceName() << ".setVisible(1)\n";
    }
  }
  *str << "\n\n";
  *str << "_create_win_";
  *str << btarget->getInstanceName();
  *str << "()\n";
  *str << "#--- end of src ---\n";
  return str;
}
WSCstring* WSGFcreateWindowSrcMwtPy(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "#----------------------------------------------------\n";
  *str << "# MWT Python Application Source File                 \n";
  *str << "#      created by WideStudio Application Builder     \n";
  *str << "#----------------------------------------------------\n";
  *str << "import mwt\n\n";
  *str << "#--- OBJECT instance variable ---\n";

  WSGFcreateWindowInstanceListPy(str,btarget);

  *str << "\n";
  *str << "#--- OBJECT src ---\n";
  *str << "\n";
  *str << "def _create_win_";
  *str << btarget->getInstanceName();
  *str << "():\n";

  WSGFcreateWindowInstanceList2Py(str,btarget);
  WSGFcreateWindowInstanceSrcMwtPy(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    if ((long)btarget->getUserData(WS_EXT_VAR) == 1){
      *str << "\t" << btarget->getInstanceName() << ".setVisible(1)\n";
    }else{
      *str << "\t" << btarget->getInstanceName() << ".setVisible(1)\n";
    }
  }
  *str << "\n\n";
  *str << "_create_win_";
  *str << btarget->getInstanceName();
  *str << "()\n";
  *str << "#--- end of src ---\n";
  return str;
}
#if 0
WSCstring* WSGFcreateWindowSrcPerl(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "#----------------------------------------------------\n";
  *str << "# MWT Perl Application Source File                   \n";
  *str << "#      created by WideStudio Application Builder     \n";
  *str << "#----------------------------------------------------\n";
  *str << "\n";
  *str << "use mpfc;\n";
  *str << "\n";
  *str << "#--- OBJECT src ---\n";
  *str << "\n";

  WSGFcreateWindowInstanceSrcPerl(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    *str << "   mpfc::WSCbase_setVisible($" << btarget->getInstanceName()
                                            << ",1);\n";
  }
  *str << "1;\n";
  *str << "#--- end of src ---\n";
  return str;
}
#endif
WSCstring* WSGFcreateWindowSrcPerl(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "#----------------------------------------------------\n";
  *str << "# MWT Perl Application Source File                   \n";
  *str << "#      created by WideStudio Application Builder     \n";
  *str << "#----------------------------------------------------\n";
  *str << "\n";
  *str << "use mpfc;\n";
  *str << "\n";
  *str << "#--- OBJECT src ---\n";
  *str << "\n";

  WSGFcreateWindowInstanceSrcPerl(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    *str << "   $" << btarget->getInstanceName() << "->setVisible(1);\n";
  }
  *str << "1;\n";
  *str << "#--- end of src ---\n";
  return str;
}
WSCstring* WSGFcreateWindowSrcMwtPerl(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "#----------------------------------------------------\n";
  *str << "# MWT Perl Application Source File                   \n";
  *str << "#      created by WideStudio Application Builder     \n";
  *str << "#----------------------------------------------------\n";
  *str << "\n";
  *str << "use mwt;\n";
  *str << "\n";
  *str << "#--- OBJECT src ---\n";
  *str << "\n";

  WSGFcreateWindowInstanceSrcMwtPerl(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    *str << "   $" << btarget->getInstanceName() << "->setVisible(1);\n";
  }
  *str << "1;\n";
  *str << "#--- end of src ---\n";
  return str;
}
WSCstring* WSGFcreateWindowSrcJava(WSCbase* btarget,char* pkgname){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "//----------------------------------------------------\n";
  *str << "// MWT Java Application Source File                   \n";
  *str << "//      created by WideStudio Application Builder     \n";
  *str << "//----------------------------------------------------\n";
  *str << "\n";
  if (pkgname != NULL && strcmp(pkgname,"")){
    *str << "package " << pkgname << ";\n";
  }
  *str << "import org.widestudio.mpfc.*;\n";
  *str << "\n";
  *str << "//--- OBJECT src ---\n";
  *str << "public class " << btarget->getInstanceName() << "{\n";
  WSGFcreateWindowInstanceListJava(str,NULL,btarget);
  *str << "  public static void create_win_" << btarget->getInstanceName()
       << "(){\n";

  WSGFcreateWindowInstanceSrcJava(str,NULL,btarget,pkgname);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    *str << "    " << btarget->getInstanceName() << ".setVisible((short)Mpfc.True);\n";
  }
  *str << "  }\n}\n";
  *str << "//--- end of src ---\n";
  return str;
}
WSCstring* WSGFcreateWindowSrcMwtJava(WSCbase* btarget,char* pkgname){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "//----------------------------------------------------\n";
  *str << "// MWT Java Application Source File                   \n";
  *str << "//      created by WideStudio Application Builder     \n";
  *str << "//----------------------------------------------------\n";
  *str << "\n";
  if (pkgname != NULL && strcmp(pkgname,"")){
    *str << "package " << pkgname << ";\n";
  }
  *str << "import org.widestudio.mwt.*;\n";
  *str << "\n";
  *str << "//--- OBJECT src ---\n";
  *str << "public class " << btarget->getInstanceName() << "{\n";
  WSGFcreateWindowInstanceListJava(str,NULL,btarget);
  *str << "  public static void create_win_" << btarget->getInstanceName()
       << "(){\n";

  WSGFcreateWindowInstanceSrcJava(str,NULL,btarget,pkgname);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    *str << "    " << btarget->getInstanceName() << ".setVisible((short)Mwt.True);\n";
  }
  *str << "  }\n}\n";
  *str << "//--- end of src ---\n";
  return str;
}

WSCstring* WSGFcreateWindowSrcOcaml(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "(*----------------------------------------------------*)\n";
  *str << "(* MWT Ocaml Application Source File                  *)\n";
  *str << "(*      created by WideStudio Application Builder     *)\n";
  *str << "(*----------------------------------------------------*)\n";
  *str << "\n";
  *str << "open Swig\n";
  *str << "open Mpfc\n";
  *str << "open Mpfclib\n";
  *str << "\n";
  *str << "(*--- OBJECT instance variable ---*)\n";
  WSGFcreateWindowInstanceListOcaml(str,btarget);
  WSGFcreateWindowArrayInstanceSetupOcaml(str,btarget);

  *str << "(*--- OBJECT src ---*)\n";
  *str << "let _create_win_" << btarget->getInstanceName() << "() =\n";

  WSGFcreateWindowInstanceSrcOcaml(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    *str << "  ignore(!" << btarget->getInstanceName() << "-> \"setVisible\" (1));\n";
  }
  *str << "  ()\n";
  *str << "(*--- end of src ---*)\n";
  return str;
}

WSCstring* WSGFcreateWindowSrcMwtOcaml(WSCbase* btarget){
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  WSCstring* str = new WSCstring;
  *str =  "(*----------------------------------------------------*)\n";
  *str << "(* MWT Ocaml Application Source File                  *)\n";
  *str << "(*      created by WideStudio Application Builder     *)\n";
  *str << "(*----------------------------------------------------*)\n";
  *str << "\n";
  *str << "open Swig\n";
  *str << "open Mwt\n";
  *str << "open Mwtlib\n";
  *str << "\n";
  *str << "(*--- OBJECT instance variable ---*)\n";
  WSGFcreateWindowInstanceListOcaml(str,btarget);
  WSGFcreateWindowArrayInstanceSetupOcaml(str,btarget);

  *str << "(*--- OBJECT src ---*)\n";
  *str << "let _create_win_" << btarget->getInstanceName() << "() =\n";

  WSGFcreateWindowInstanceSrcOcaml(str,NULL,btarget);

  WSCbool fl;
  btarget->getPropertyV(WSNvis,&fl);
  if (fl != False){
    *str << "  ignore(!" << btarget->getInstanceName() << "-> \"setVisible\" (1));\n";
  }
  *str << "  ()\n";
  *str << "(*--- end of src ---*)\n";
  return str;
}

void  _create_procedure_list(WSClistData* prclist ,WSCbase* base){
  WSClistData* ops = base->getProcedureList();
  long num = ops->getNum();
  long i;
  for(i=0; i < num; i++){
    WSCprocedure* ac = (WSCprocedure*)(*ops)[i];
    long onum = prclist->getNum();
    long j;
    WSCbool fl = True;
    for(j=0; j < onum; j++){
      WSCprocedure* item = (WSCprocedure*)(*prclist)[j];
      if ( !WSGFstrcmp(item->getFunctionName(),ac->getFunctionName())){
         fl = False;
      }
    }
    if (fl == True){
      prclist->add((void*)ac);
    }
  }

  WSClistData children = base->getChildren();
  num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
       _create_procedure_list(prclist ,child);
    }
  }
}

void  WSGFcreateWindowClassProcedureList(WSCstring* out ,WSCbase* btarget){
  WSClistData prclist;
  _create_procedure_list(&prclist,btarget);

  long num = prclist.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCprocedure* ac = (WSCprocedure*)prclist[i];
    *out << "   static void " << ac->getFunctionName() << "(WSCbase*);\n";
  }
}


void _get_class_list2(WSCbase* base,WSClistData* list){
  long num = list->getNum();
  long i;
  long fl = True;
  for(i=0; i< num; i++){
    WSCbase* item = (WSCbase*)(*list)[i];
    if (!WSGFstrcmp(item->getClassName(),base->getClassName())){
      fl = False;
      break;
    }
  }
  if (fl == True){
    list->add((void*)base);
  }

  WSClistData children = base->getChildren();
  num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      _get_class_list2(child,list);
    }
  }
}

WSClistData* _get_class_list(WSCbase* btarget){
static   WSClistData  tmp;
  tmp.clear();
  tmp.add((void*)btarget);
  WSClistData children = btarget->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() == False){
      _get_class_list2(child,&tmp);
    }
  }
  return &tmp;
}

WSCstring* WSGFcreateWindowClassSrc(WSCbase* btarget){
  WSCstring* str = new WSCstring;
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  *str =  "//----------------------------------------------------//\n";
  *str << "// Wide Studio Application C++ Source File            //\n";
  *str << "//            created by Wide Studio source generator //\n";
  *str << "//----------------------------------------------------//\n";
  *str << "#include <WScom.h>\n#include <WSDappDev.h>\n\n";
  *str << "//--- OBJECT includes ---//\n";
  *str << "#include <" << btarget->getInstanceName() << ".h>\n";

  WSCstring tmp1;
  long i;
  long num = ilist.getNum();
  for(i=0; i< num; i++){
    WSCbase* base = (WSCbase*)ilist[i];
    char buffer[1024];
    sprintf(buffer,"#include <%s.h>\n",base->getClassName());
    tmp1 << buffer;
  }
  *str << tmp1 << "\n";
  *str << btarget->getInstanceName() << "::" << btarget->getInstanceName();
  *str << "(WSCbase* base,char* objName):\n";
  *str << btarget->getInstanceName() << "BASETYPE(base,objName){\n\n";
  *str << "  _property_initialize();\n";
//  *str << WSGFgettext("A:WSSTR  //please edit here...\n");
  *str << "  //please edit here...\n";
  *str << "\n\n}\n\n";

  *str << btarget->getInstanceName()<< "::~" << btarget->getInstanceName()<< "(){\n\n";
  *str << "  _property_delete();\n";
//  *str << WSGFgettext("A:WSSTR  //please edit here...\n");
  *str << "  //please edit here...\n";
  *str << "\n\n}\n\n";
  *str << "long " << btarget->getInstanceName() << "::initialize(){\n  ";
  *str << btarget->getInstanceName() << "BASETYPE" << "::initialize();\n";
  *str << "  objectInitialize();\n\n";
//  *str << WSGFgettext("A:WSSTR  //please edit here...\n");
  *str << "  //please edit here...\n";
  *str << "  return WS_NO_ERR;\n}\n";

  return str;
}

WSCstring* WSGFcreateWindowClassSrcP(WSCbase* btarget){
  WSCstring* str = new WSCstring;
  WSClistData ilist;
  WSGFcreateWindowIncludeList(&ilist,btarget);

  *str =  "//----------------------------------------------------//\n";
  *str << "// Wide Studio Application C++ Source File            //\n";
  *str << "//            created by Wide Studio source generator //\n";
  *str << "//----------------------------------------------------//\n";
  *str << "#include <WScom.h>\n#include <WSDappDev.h>\n";
  *str << "#include <WSCclassInformation.h>\n";
  *str << "//--- OBJECT includes ---//\n";
  *str << "#include <" << btarget->getInstanceName() << ".h>\n\n";

  WSCstring tmp1;
  long i;
  long num = ilist.getNum();
  for(i=0; i< num; i++){
    WSCbase* base = (WSCbase*)ilist[i];
    char buffer[1024];
    sprintf(buffer,"#include <%s.h>\n",base->getClassName());
    tmp1 << buffer;
  }
  *str << tmp1;
//  *str << WSGFgettext("B:WSSTR\n\n//Initializing of class...\n");
  *str << "\n\n//Initializing of class...\n";
  *str << "WSMFguiClassInitialize(" << btarget->getInstanceName() << ",";
  *str << btarget->getClassName() << ");\n\n";
  *str << "WSMFversion(" << btarget->getInstanceName() << ",";
  *str << btarget->getClassName() << ");\n\n";

  WSClistData  def_prop_list;
  WSClistData* props = btarget->getClassInformation()->getAllPropertyList();
  WSCproperty* prop;
  num = props->getNum();
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*props)[i];
    WSCbool def = prop->isDefaultValue(btarget);
    if (def != False){
      continue;
    }
    if (!strcmp(prop->getPropObjName(),WSNname)){
      continue;
    }
    if (!strcmp(prop->getPropObjName(),WSNvis)){
      continue;
    }
    _add_default_changed_property(btarget,prop->getPropObjName(),
      prop->getPropObjType(), btarget->getProperty(prop->getPropObjName()),
      &def_prop_list);
  }

  WSClistData* own_prop_list = (WSClistData*)btarget->getUserData(WS_PROP_LIST);
  WSClistData  prop_list_ins;
  WSClistData* prop_list = &prop_list_ins;
  if (own_prop_list != NULL){
    num = own_prop_list->getNum();
    for(i=0; i<num; i++){
      prop_list->add( (*own_prop_list)[i] );
    }
  }
  num = def_prop_list.getNum();
  for(i=0; i<num; i++){
    prop_list->add( def_prop_list[i] );
  }

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){ //Normal definition...
        if (WSGFstrcmp(propdata->values.getString(),"")){
          long num = propdata->values.getWords(",");
          if (num > 1){
            WSCstring vsname;
            vsname = propdata->values.getWord(0,",");
            vsname.replaceString("\\S","_",0);
            *str << "char* " << vsname << "[]={\n";

            long i;
            for(i=1; i<num; i++){
              WSCstring valuen;
              valuen = propdata->values.getWord(i,",");
              valuen.replaceString("\\S"," ",0);
              i++;
              *str << "\"" << valuen << "\",\n";
            }
            *str << "NULL\n";
            *str << "};\n";

            *str << "char* " << vsname << "D[]={\n";

            for(i=2; i<num; i++){
              WSCstring valuen;
              valuen = propdata->values.getWord(i,",");
              valuen.replaceString("\\S"," ",0);
              i++;
              *str << "\"" << valuen << "\",\n";
            }
            *str << "NULL\n";
            *str << "};\n";
          }
        }
      }
    }
  }

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 2){  //default value change
        *str << "WSMFpropertyValueChange(";
        *str << btarget->getInstanceName() << ",";
        *str << propdata->name.getString() << ",";
        *str <<  _value_to_type(propdata->type) << ",";
        if (propdata->type == WSTcharptr){  //string
           *str << "WSGFstrdup(\"" << propdata->value.getString() << "\")";
        }else{
           if (propdata->type == WSTshort && //2=short
               _is_color_property(propdata->name.getString()) != False){
             *str << "WSGFcolor(\"" << propdata->value.getString() << "\")";
           }else
           if (propdata->type == WSTshort &&  //2=short
               _is_pixmap_property(propdata->name.getString()) != False){
             *str << "WSGFimage(\"" << propdata->value.getString() << "\")";
           }else{
             *str << propdata->value.getString();
           }
        }
        *str << ");\n";
      }
    }
  }

  *str << "void " << btarget->getInstanceName() << "::_property_initialize(){\n";

  //󥹥ѿν //initialize of the instance variable
  WSCstring tmpInit;
  WSGFcreateWindowInstanceInitList(&tmpInit,btarget);
  char buffer[128];
  //ܤ饹Υ󥹥󥹤ǤСʤΤǺ...
  //Delete first line,if it is instance of own class...
  sprintf(buffer,"  %s = NULL;\n",btarget->getInstanceName());
  tmpInit.replaceString(buffer,"",1);

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){
        *str << "  " << propdata->vname.getString() << " = (";
        *str <<  _value_to_type(propdata->type) << ")";
        if (propdata->type == WSTcharptr){ //string
           *str << "WSGFstrdup(\"" << propdata->value.getString() << "\")";
        }else{
           if (propdata->type == WSTshort && //2=short
               _is_color_property(propdata->name.getString()) != False){
             if (WSGFstrcmp(propdata->value.getString(),"")){
               *str << "WSGFcolor(\"" << propdata->value.getString() << "\")";
             }else{
               *str << "WSGFcolor(\"#000000\")";
             }
           }else
           if (propdata->type == WSTshort &&  //2=short
               _is_pixmap_property(propdata->name.getString()) != False){
             *str << "WSGFimage(\"" << propdata->value.getString() << "\")";
           }else{
             if (WSGFstrcmp(propdata->value.getString(),"")){
               *str << propdata->value.getString();
             }else{
               *str << "0";
             }
           }
        }
        *str << ";\n";
      }
    }
  }

  *str << tmpInit.getString();
  *str << "\n  WSMFpropertyCreateStart\n";
  *str << "    //Check Version...\n";
  *str << "    WSMFparentCheckVerSrc(" << btarget->getInstanceName() << ");\n\n";

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){ //̾ץѥƥ...
        *str << "  WSMFpropertyCreate(";
        *str << propdata->name.getString() << ",";
        *str <<  _value_to_type(propdata->type) << ",";
        *str << propdata->vname.getString() << ",\"";
        *str << propdata->bname.getString() << "\");\n";
        if (WSGFstrcmp(propdata->values.getString(),"")){
            WSCstring vsname;
            vsname = propdata->values.getWord(0,",");
            vsname.replaceString("\\S","_",0);
            *str << "  WSMFpropertySetSelection(";
            *str << vsname << ",";
            *str << vsname << "D);\n\n";
        }else{
          if (WSGFstrcmp(propdata->bname.getString(),"")){
            if (propdata->type == WSTbool){ //WSCbool ʤ...
              *str << "  WSMFpropertySetSelection(WSRbool, WSRboolD);\n\n";
            }
          }else{
            *str << "\n";
          }
        }
                if (propdata->att == 4){
          *str << "  WSMFpropertyVisible(False);\n\n";
                }
      }else if (propdata->att == 1){ //delete prop
        *str << "  WSMFpropertyDelete(";
        *str << propdata->name.getString();
        *str << ");\n";
      }else if (propdata->att == 2){ //change default
        *str << "  WSMFpropertyValueChangeDef(";
        *str << btarget->getInstanceName() << ",";
        *str << propdata->name.getString() << ",";
        *str <<  _value_to_type(propdata->type) << ");\n";
      }else if (propdata->att == 3){ //builder unvis
        *str << "  WSMFpropertyVisibleOff(";
        *str << propdata->name.getString() << ");\n";
      }
    }
  }
  WSClistData* tlist = (WSClistData*)btarget->getUserData(WS_TRG_LIST);
  if (tlist != NULL){
    long num = tlist->getNum();
    long i;
    for(i=0; i<num; i++){
      long trg = (long)(*tlist)[i];
      *str << "  WSMFaddTrigger(" << WSGFltoa(trg) << ");\n";
    }

  }

  WSClistData* utlist = (WSClistData*)btarget->getUserData(WS_UTRG_LIST);
  if (utlist != NULL){
    long num = utlist->getNum();
    long i;
    for(i=0; i<num; i++){
      utrg_data* utrgdata  = (utrg_data*)(*utlist)[i];
      if (utrgdata->type == 0){
        *str << "  WSMFaddExtTrigger(" << utrgdata->vname.getString()
           << ",\"" << utrgdata->name.getString() << "\");\n";
      }else{
        *str << "  WSMFdelExtTrigger(" << utrgdata->vname.getString() << ");\n";
      }
    }
  }

  //setup of properties

  *str << "  WSMFpropertyCreateEnd\n" << "}\n";
  *str << "void " << btarget->getInstanceName() << "::_property_delete(){\n";
//  *str << "  delAllProcedure();\n";

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      //̾ޤԲĻ  char* ʤ...
      //if charptr
      if ( (propdata->att == 0 || propdata->att == 4 ) && propdata->type == WSTcharptr){
        *str << "  delete " << propdata->vname.getString() << ";\n";
      }
    }
  }
  *str << "}\n";

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){
        *str << "WSMFproperty(";
        *str << btarget->getInstanceName() << ",";
        *str << propdata->name.getString() << ",";
        *str <<  _value_to_type(propdata->type) << ",";
        *str << propdata->vname.getString() << ",";
        if (propdata->type == WSTcharptr){ //string
           *str << "WSGFstrdup(\"" << propdata->value.getString() << "\")";
        }else
        if (propdata->type == WSTvoidptr){
           *str << "(void*)" << propdata->value.getString();
        }else{
           if (propdata->type == WSTshort && //2=short
               _is_color_property(propdata->name.getString()) != False){
             if (WSGFstrcmp(propdata->value.getString(),"")){
               *str << "WSGFcolor(\"" << propdata->value.getString() << "\")";
             }else{
               *str << "WSGFcolor(\"#000000\")";
             }
           }else
           if (propdata->type == WSTshort &&  //2=short
               _is_pixmap_property(propdata->name.getString()) != False){
             *str << "WSGFimage(\"" << propdata->value.getString() << "\")";
           }else{
             if (WSGFstrcmp(propdata->value.getString(),"")){
               *str << propdata->value.getString();
             }else{
               *str << "0";
             }
           }
        }
        *str << ");\n";
        if (propdata->use_file == False){
          *str << "void " << btarget->getInstanceName() << "::setWork";
          *str << propdata->name.getString() << "(";
          *str <<  _value_to_type(propdata->type) << "){}\n";
          *str << "void " << btarget->getInstanceName() << "::getWork";
          *str << propdata->name.getString() << "(";
          *str <<  _value_to_type(propdata->type) << "*){}\n";
        }
      }
    }
  }

  *str << "long " << btarget->getInstanceName() << "::objectInitialize(){\n  ";

  WSCstring str2;
  WSGFcreateWindowInstanceClassSrc(&str2,NULL,btarget);
  // class->  ʬΤä...
  WSCstring tmp(btarget->getInstanceName());
  tmp << "->";
  str2.replaceString(tmp.getString(),"",0);

  // change [ new WSCxxx(class,"xxx") ] to [ new WSCxxx(this,"xxx") ]
  tmp = "(";
  tmp << btarget->getInstanceName() << ",";
  str2.replaceString(tmp.getString(),"(this,",0);
  if (btarget != btarget->getParentWindow()){
    str2.replaceString("\tsetPropertyV(","//\tsetPropertyV(",0);
  }

  *str << str2;
  *str << "    return WS_NO_ERR;\n";
  *str << "}\n//end of src\n";
  num = def_prop_list.getNum();
  for(i=0; i<num; i++){
    prop_data* pdata = (prop_data*)def_prop_list[i];
    delete pdata;
  }
  return str;
}

WSCstring* WSGFcreateWindowClassHeaderP(WSCbase* btarget){
  WSCstring* str = new WSCstring;

  //output of properties
  *str << "  private:////////////////////////\n";
  *str << "  //valiables for properties\n\n";
  WSClistData* prop_list = (WSClistData*)btarget->getUserData(WS_PROP_LIST);
  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){
        *str << "  " <<  _value_to_type(propdata->type) << " ";
        *str << propdata->vname.getString() << ";\n";
      }
    }
  }

  *str << "  protected:////////////////////////\n";
  *str << "     //definition of properties\n\n";

  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){
        *str << "  WSMFpropertyDef(";
        *str <<  propdata->name.getString() << ",";
        *str <<  _value_to_type(propdata->type) << ",";
        *str << propdata->vname.getString() << ");\n";
      }
    }
  }
  *str << "\n     //valiables for instances\n";

  WSCstring tmp1;
  WSGFcreateWindowInstanceMemberList(&tmp1,btarget);

  //ܤ饹Υ󥹥󥹤ǤСʤΤǺ...
  char buffer[128];
  sprintf(buffer,"%s* %s;\n",btarget->getClassName(),btarget->getInstanceName());
  WSCstring tmp2(buffer);
  tmp1.replaceString(tmp2.getString(),"",1);

  *str << tmp1;

  //define properties...
  *str << "     void _property_initialize();\n\n";
  *str << "     void _property_delete();\n\n";
  *str << "  public:////////////////////////\n";
  *str << "virtual     long initialize();\n\n";
  *str << "            long objectInitialize();\n\n";
  *str << "\n   // definitions for event procedures\n\n";

  WSCstring tmp3;
  WSGFcreateWindowClassProcedureList(&tmp3,btarget);
  *str << tmp3;
  *str << "\n\n";
  return str;
}

WSCstring* WSGFupdateWindowClassHeader(WSCstring* in,WSCbase* btarget){
  WSClistData* clist = _get_class_list(btarget);
  long i;
  long num = clist->getNum();
  for(i=0; i<num; i++){
    WSCbase* base = (WSCbase*)(*clist)[i];
    if (base == btarget){
      continue;
    }
    WSCstring tmp("class ");
    tmp << base->getClassName() << ";\n";
    if (in->isExist(tmp.getString()) == -1){ // if not exist
       WSCstring tmp2("//USE CLASS\n");
       tmp2 += tmp;
       in->replaceString("//USE CLASS\n",tmp2.getString(),1);
    }
  }

  WSClistData* prop_list = (WSClistData*)btarget->getUserData(WS_PROP_LIST);
  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      in->seek(0);
      char* str = 0;
      WSCbool exist = False;
      while(!in->eof()){
        WSCstring tmp = in->gets();
        if (tmp.isExist(propdata->name.getString()) != -1 &&
            tmp.isExist("#define") != -1 ){
           exist = True;
           delete str;
           break;
        }
      }

      if (exist == True){
        continue;
      }
      if (propdata->att == 0 || propdata->att == 4 ){
        WSCstring st("//USE PROPERTY\n#ifndef ");
        st << propdata->name.getString() << "\n";
        st << "#define " << propdata->name.getString();
        WSCstring tmp(propdata->name.getString());
        tmp.replaceString("WSN","\t\"",1);
        st << tmp.getString();
        st << "\"\n#endif\n";
        in->replaceString("//USE PROPERTY\n",st.getString(),1);
      }
    }
  }
  in->seek(0);
  WSClistData* utrg_list = (WSClistData*)btarget->getUserData(WS_UTRG_LIST);
  if (utrg_list != NULL){
    long num = utrg_list->getNum();
    long i;
    for(i=0; i<num; i++){
      utrg_data* utrgdata = (utrg_data*)(*utrg_list)[i];
      in->seek(0);
      char* str = 0;
      WSCbool exist = False;
      while(!in->eof()){
        WSCstring tmp = in->gets();
        if (tmp.isExist(utrgdata->name.getString()) != -1 &&
            tmp.isExist("#define") != -1 ){
           exist = True;
           delete str;
           break;
        }
      }

      if (exist == True){
        continue;
      }
      WSCstring st("//USE TRIGGER\n#ifndef ");
      st << utrgdata->vname.getString() << "\n";
      st << "#define " << utrgdata->vname.getString() << " ";
      st << utrgdata->value << "\n#endif\n";
      in->replaceString("//USE TRIGGER\n",st.getString(),1);
    }
  }


  in->seek(0);
  while(!in->eof()){
    WSCstring tmp = in->gets();

    if (tmp.isExist("//BASE CLASS HEADER") != -1){
      tmp = in->gets();
      WSCstring tmp2("<");
      tmp2 << btarget->getClassName();
      tmp2 << ".h>";
      if (tmp.isExist( tmp2.getString() ) == -1){
        tmp << "\n";
        in->replaceString(tmp.getString(),"",1);
        tmp2 = "//BASE CLASS HEADER\n";
        tmp2 << "#include <";
        tmp2 << btarget->getClassName();
        tmp2 << ".h>\n";
        in->replaceString("//BASE CLASS HEADER\n",tmp2.getString(),1);
      }
    }else if (tmp.isExist("BASETYPE") != -1 && tmp.isExist("#define") != -1){
      if (tmp.isExist(btarget->getClassName()) != -1 ){
        break;
      }else{
        tmp << "\n";
        in->replaceString(tmp.getString(),"",1);
        WSCstring tmp2("//BASE CLASS SETTING\n#define ");
        tmp2 << btarget->getInstanceName();
        tmp2 << "BASETYPE " << btarget->getClassName() << "\n";
        in->replaceString("//BASE CLASS SETTING\n",tmp2.getString(),1);
        break;
      }
    }
  }
  return in;
}


WSCstring* WSGFcreateWindowClassHeader(WSCbase* btarget){
  WSCstring* str = new WSCstring;
  *str =  "//----------------------------------------------------//\n";
  *str << "// Wide Studio Application C++ Source File            //\n";
  *str << "//            created by Wide Studio source generator //\n";
  *str << "//----------------------------------------------------//\n";
  *str << "#ifndef " << btarget->getInstanceName() << "_H\n";
  *str << "#define " << btarget->getInstanceName() << "_H\n";
  *str << "#include <WScom.h>\n#include <WSDappDev.h>\n";
  *str << "//define version...\n";
  *str << "#define " << btarget->getInstanceName() << "_VER 1000\n";
//  *str << WSGFgettext("C:WSSTR//##### IMPORTANT: Do not edit from here  #######\n\n");
  *str << "//##### IMPORTANT: Do not edit from here  #######\n\n";

  *str << "//BASE CLASS HEADER\n";
  *str << "#include <" << btarget->getClassName() << ".h>\n\n";

  //class list...
  WSClistData* clist = _get_class_list(btarget);
  long i;
  long num = clist->getNum();
  *str << "//USE CLASS\n";
  for(i=0; i<num; i++){
    WSCbase* base = (WSCbase*)(*clist)[i];
    if (base == btarget){
      continue;
    }
    *str << "class ";
    *str << base->getClassName();
    *str << ";\n";
  }

  *str << "\n//USE PROPERTY\n";
  WSClistData* prop_list = (WSClistData*)btarget->getUserData(WS_PROP_LIST);
  if (prop_list != NULL){
    long num = prop_list->getNum();
    long i;
    for(i=0; i<num; i++){
      prop_data* propdata = (prop_data*)(*prop_list)[i];
      if (propdata->att == 0 || propdata->att == 4){
        *str << "#ifndef " << propdata->name.getString() << "\n";
        *str << "#define " << propdata->name.getString();
        WSCstring tmp(propdata->name.getString());
        tmp.replaceString("WSN","\t\"",1);
        *str << tmp.getString() << "\"\n";
        *str << "#endif\n";
      }
    }
  }
   *str << "\n//USE TRIGGER\n";
  WSClistData* utrg_list = (WSClistData*)btarget->getUserData(WS_UTRG_LIST);
  if (utrg_list != NULL){
    long num = utrg_list->getNum();
    long i;
    for(i=0; i<num; i++){
      utrg_data* utrgdata = (utrg_data*)(*utrg_list)[i];
      *str << "#ifndef " << utrgdata->vname.getString() << "\n";
      *str << "#define " << utrgdata->vname.getString() << " " ;
      *str << utrgdata->value << "\n";
      *str << "#endif\n";
    }
  }


  *str << "\n//BASE CLASS SETTING\n";
  *str << "#define " << btarget->getInstanceName() << "BASETYPE ";
  *str << btarget->getClassName() << "\n\n";
//  *str << WSGFgettext("D:WSSTR//##### IMPORTANT: Do not edit to here  #######\n\n");
  *str << "//##### IMPORTANT: Do not edit to here  #######\n\n";
  //define class...
  *str << "class ";
  *str << btarget->getInstanceName() << " :public ";
  *str << btarget->getInstanceName() << "BASETYPE " << " {\n\n";

  // private include...
  *str << "#include <" << btarget->getInstanceName() << "P.h>\n\n";

  *str << "  public://///////////////////\n     ";
  *str << btarget->getInstanceName();
  *str << "(WSCbase* base,char* name);\n    virtual ~";
  *str << btarget->getInstanceName();
//  *str << WSGFgettext("E:WSSTR();\n\n    // class definitions/////////////////////////////////\n")
;
  *str << "();\n\n    // class definitions/////////////////////////////////\n";
  *str << "    WSMFguiClassDef("<< btarget->getInstanceName() << ",";
  *str << btarget->getInstanceName() << "BASETYPE " << ");\n";
  *str << "    WSMFversionDef(" << btarget->getInstanceName() << ");\n};\n";
  *str << "#endif\n";
  return str;
}

WSCbase* WSGFreadWinFile(char* dirname,char* fname,long encoding){
  WSCstring fname2;
  if ( !strcmp(dirname,"") ){
    fname2 << fname;
  }else{
    fname2 << dirname << "/" << fname;
  }

  if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
    encoding = WS_EN_LOCALE;
  }
  WSCstring* windata = WSGFreadTextFile((char*)fname2,encoding);
  if (windata != NULL){

    WSCbase* win = WSGFreadWinSrc(*windata,True);
    if (win != NULL){
      win->setUserData(WS_REGISTERED,(void*)1);
      win->setUserData(WS_FILENAME,WSGFstrdup((char*)fname));
    }else{
      delete windata;
      return NULL;
    }
    delete windata;
    return win;
  }else{
    return NULL;
  }
  return NULL;
}

long _ve_title_cnt = 1;

WSCvariant _get_product_name(WSCindexVariantData* prj){
  WSCvariant stlink = prj->getData("#STLINK");
  if (stlink.getLong()){
    return prj->getData("#STOUTPUT");
  }else{
    return prj->getData("#OUTPUT");
  }
}
WSCvariant _get_dbg_product_name(WSCindexVariantData* prj){
  WSCvariant stlink = prj->getData("#STLINK");
  if (stlink.getLong()){
    return prj->getData("#DBG_STOUTPUT");
  }else{
    return prj->getData("#DBG_OUTPUT");
  }
}

WSCvariant _get_vproduct_name(WSCindexVariantData* prj){
  WSCvariant str;
  str = prj->getData("#CMODE");
#ifdef MSW
  WSCvariant link_type = prj->getData("#LIB_CREATE");
  if (link_type.getLong() == 2){ //NETSCAPE PLUGIN
    if (atoi((char*)str)){
      static WSCstring ret;
      ret = "np";
      ret << _get_dbg_product_name(prj);
      return ret;
    }else{
      static WSCstring ret;
      ret = "np";
      ret << _get_product_name(prj);
      return ret;
    }
  }
#endif
  if (atoi((char*)str)){
    return _get_dbg_product_name(prj);
  }else{
    return _get_product_name(prj);
  }
}
WSCstring WSGFcreateProjectSrcC(long proj){
  WSCindexVariantData* prj = (WSCindexVariantData*)proj;
  if (prj == NULL){
    prj = new WSCindexVariantData;
  }

  WSCstring policy = prj->getData("#POLICY");
  WSCvariant enc = prj->getData("#ENCODING");
  WSCvariant link_type = prj->getData("#LIB_CREATE");
  long encoding = WSGFgetEncodingValue(enc.getCharPtr());

  WSCstring prj_src;

  prj_src << "//WINDOW BUILDER PROJECT MASTER SRC//\n";
  prj_src << "#include <WScom.h>\n";
  prj_src << "#include <WSDappDev.h>\n";
  prj_src << "#include <WSCbaseList.h>\n\n";
  prj_src << "#include <WSClocaleSet.h>\n\n";
  prj_src << "#ifdef MSW\n";
  prj_src << "WS_WINMAIN\n";
  prj_src << "#endif\n\n";

  prj_src << "char* mou[] = {\n";
  prj_src << "WS_DEFAULT_MOUSE_ID,\n";
  prj_src << "NULL};\n\n" << "void _mouse_init_(){\n";
  prj_src << "  WSGFloadMouseCursorData(mou);\n}\n\n";

  prj_src << "char* fon[] = {\n";
  WSCstring* font_data = WSGFgetFontSaveData();
  if (font_data != NULL){
    while(!font_data->eof()){
      WSCstring data = font_data->gets();
      prj_src << "\"" << data << "\",\n";
    }
    delete font_data;
  }
  prj_src << "NULL};\n\n";
  if (strcmp((char*)policy,"")){
    prj_src << "void _policy_init_(){\n";
    prj_src << "  WSGIappDev()->setGuiPolicy(" << policy.getWord(0,",")
            << ",False);\n";
    prj_src << "  WSGIappDev()->setExtGuiPolicy(\"" << policy.getWord(1,",")
            << "\",True);\n";
    prj_src << "}\n";
  }
  prj_src << "void _font_init_(){\n  WSGFloadFontData(fon);\n}\n";
  prj_src << "class _init_app_class_{\n";
  prj_src << "  public: _init_app_class_(){\n";

  prj_src << "    WSGFdeviceInitialize();\n";
  if (strcmp((char*)policy,"")){
    prj_src << "    WSGIappDev()->setInitHandler(_policy_init_);\n";
  }
  prj_src << "    WSGIappDev()->setInitHandler(_font_init_);\n";
  prj_src << "    WSGIappDev()->setInitHandler(_mouse_init_);\n";
  if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
    prj_src << "    WSGIappLocaleSet()->setDefaultEncoding(" <<
                WSGFltoa(encoding) << ");\n";
  }
  prj_src << "    WSDappDev* app = WSGIappDev();\n";
  prj_src << "    app->setInstanceName(\"";
  prj_src << _get_product_name(prj).getCharPtr();
  prj_src << "\");\n";

  if (strcmp((char*)policy,"")){
    WSCstring value = policy.getWord(0,",");
    WSCstring exname = policy.getWord(1,",");
    if (!strcmp(exname,"")){
      prj_src << "    app->setGuiPolicy(" << value << ",True);\n";
    }else{
      prj_src << "    app->setGuiPolicy(" << value << ",False);\n";
      prj_src << "    app->setExtGuiPolicy(\"" << exname << "\",True);\n";
    }
  }
  prj_src << "  };\n};\nstatic _init_app_class_ _execute_app_class_;\n\n";

  WSCulong win_id = 0;
  int i = -1;
  while(1){
    i++;
    WSCulong next_id = WSGIappObjectList()->getInstanceId(WS_ROOT_INSTANCE_ID,
                                       WS_NEXT_CHILD_INSTANCE_ID,win_id);
    if (next_id == 0){
      break;
    }
    win_id = next_id;
    WSCbase* win = (WSCbase*)next_id;

    if (win->getUserData(WS_REGISTERED) == (void*)0){
      continue;
    }
//    WSGFgetProcedureList(win,&oplist);
    if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
         (long)win->getUserData(WS_WIN_STORE) == 0 ){
      if (link_type.getLong() == 0|| //NORMAL APPLICATION
          link_type.getLong() == 4){ //CONSOLE APPLICATION
        prj_src << "//--- OBJECT execute auto initialize ---//\n";
        prj_src << "extern WSDLEX WSCbase* _create_win_";
        prj_src << win->getInstanceName() << "();\n";

        prj_src << "class _initialize_window_" << WSGFltoa(i);
        prj_src << "{\n public: _initialize_window_" << WSGFltoa(i);
        prj_src << "(){\n  WSGIappDev()->setInitHandler((void(*)())_create_win_";
        prj_src << win->getInstanceName() << ");\n";

        prj_src << " };\n";
        prj_src << "};\n";
        prj_src << "static _initialize_window_";
        prj_src << WSGFltoa(i);
        prj_src << " _execute_initialize_";
        prj_src << WSGFltoa(i);
        prj_src << ";\n\n";

      //NETSCAPE/IE PLUGIN
      }else if (link_type.getLong() == 2 || link_type.getLong() == 3){
        prj_src << "extern WSDLEX WSCbase* _create_win_";
        prj_src << win->getInstanceName();
        prj_src << "();\n";
      }
    }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
      //no output
    }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
      //no output
    }
  }

  //NETSCAPE/IE PLUGIN
  if (link_type.getLong() == 2 || link_type.getLong() == 3){
    prj_src << "extern int WSGFwsInitialize();\n";
    prj_src << "extern \"C\" {\n";
    prj_src << "void _ws_initialize(void* context){\n";
    prj_src << "  WSGIappDev()->setContext(context);\n";
    prj_src << "  WSGFwsInitialize();\n";
    prj_src << "};\n";
    prj_src << "void _ws_set_window(void* win){\n";
    prj_src << "  WSGIappDev()->setContext2(win);\n";
    prj_src << "};\n";
    prj_src << "WSCbase* _ws_create_window(){\n";
    prj_src << "//--- OBJECT execute auto initialize ---//\n";

    WSCulong win_id = 0;
    int i = -1;
    int cnt = 0;
    while(1){
      i++;
      WSCulong next_id = WSGIappObjectList()->getInstanceId(WS_ROOT_INSTANCE_ID,
                                         WS_NEXT_CHILD_INSTANCE_ID,win_id);
      if (next_id == 0){
        break;
      }
      win_id = next_id;
      WSCbase* win = (WSCbase*)next_id;
      if (win->getUserData(WS_REGISTERED) == (void*)0){
        continue;
      }
      cnt++;
      if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
         (long)win->getUserData(WS_WIN_STORE) == 0 ){
        if (i==0){
          prj_src << "  WSCbase* ret = _create_win_";
          prj_src << win->getInstanceName();
          prj_src << "();\n";
        }else{
          prj_src << "  _create_win_";
          prj_src << win->getInstanceName();
          prj_src << "();\n";
        }
      }
    }
    if (link_type.getLong() == 2){ //NETSCAPE PLUGIN
      prj_src << "  WSGFwsNsPluginInitialize();\n";
    }else{ //IE PLUGIN
      prj_src << "  WSGFwsIePluginInitialize();\n";
    }
    if (cnt==0){
      prj_src << "  return NULL;\n";
    }else{
      prj_src << "  return ret;\n";
    }
    prj_src << "};\n";
    prj_src << "};\n";
    prj_src << "\n";

    if (link_type.getLong() == 3){ //NETSCAPE PLUGIN
      long val = 0;
      WSCvariant id = prj->getData("#ID");
      sscanf( id.getCharPtr(),"%x",&val);
      prj_src << "#include <initguid.h>\n";
      prj_src << "DEFINE_GUID(LIBID_WSocxObjects,0x"
              << id
              << "L,0xFF82,0x11CF,0xBB,0x32,0x14,0x2A,0x04,0xC1,0x00,0x00);\n";
      char buffer[1024];
      sprintf(buffer,"%08x",val+1);
      prj_src << "DEFINE_GUID(IID_IWSocx,        0x"
              << buffer
              << "L,0xFF82,0x11CF,0xBB,0x32,0x14,0x2A,0x04,0xC1,0x00,0x00);\n";
      sprintf(buffer,"%08x",val+2);
      prj_src << "DEFINE_GUID(DIID_DWSocxEvents,       0x"
              << buffer
              << "L,0xFF82,0x11CF,0xBB,0x32,0x14,0x2A,0x04,0xC1,0x00,0x00);\n";
      sprintf(buffer,"%08x",val+3);
      prj_src << "DEFINE_GUID(CLSID_WSocx,       0x"
              << buffer
              << "L,0xFF82,0x11CF,0xBB,0x32,0x14,0x2A,0x04,0xC1,0x00,0x00);\n";
    }
  }
  if (link_type.getLong() == 1){
    prj_src = "";
    WSCstring tmp;

    WSCulong win_id = 0;
    int i = -1;
    while(1){
      i++;
      WSCulong next_id = WSGIappObjectList()->getInstanceId(WS_ROOT_INSTANCE_ID,
                                         WS_NEXT_CHILD_INSTANCE_ID,win_id);
      if (next_id == 0){
        break;
      }
      win_id = next_id;
      WSCbase* win = (WSCbase*)next_id;

      if ( (long)win->getUserData(WS_WIN_CLASS) != 0){
        tmp << "\"";
        tmp << win->getInstanceName();
        tmp << "\",\"";
        char* class_icon = (char*)win->getUserData(WS_CLASS_ICON);
        if (class_icon == NULL){
          tmp << WS_PIXMAP_DIR "obj/obj.xpm";
        }else{
          tmp << class_icon;
        }
        tmp << "\",\"";
        tmp << win->getInstanceName();
        char* class_comment = (char*)win->getUserData(WS_CLASS_COMMENT);
        if (class_comment != NULL){
          tmp << "(";
          tmp << class_comment;
          tmp << ")";
        }
//        tmp << WSGFgettext("P4:WSSTR \",\n");
        tmp << "\",\n";
      }
    }

    prj_src << "#include <WScom.h>\n";
    prj_src << "#include <WSDexternal.h>\n\n";
    prj_src << "static char *object_symbols[] = {\n";

    prj_src << tmp;

    prj_src << "NULL\n};\n\n";
    prj_src << "class  _dll_init {\n";
    prj_src << "  public:\n";
    prj_src << "  _dll_init(){\n";
    prj_src << "     WSDexternal::setTempData(object_symbols);\n";
    prj_src << "     WSDexternal::setProjectName(\""
            <<  _get_vproduct_name(prj) << "\");\n";
    prj_src << "  }\n";
    prj_src << "};\n";
    prj_src << "static _dll_init _execute_initialize;\n";
    prj_src << "\n";
  }
  return prj_src;
}
WSCstring WSGFcreateProjectSrcJava(long proj){

  WSCindexVariantData* prj = (WSCindexVariantData*)proj;
  if (prj == NULL){
    prj = new WSCindexVariantData;
  }

  WSCstring pkgname;
  if (prj->isExist("#JAVA_PKG_NAME") != False){
    pkgname = prj->getData("#JAVA_PKG_NAME").getCharPtr();
    pkgname.delHeadSpace();
    pkgname.delTailSpace();
  }

  WSCstring policy = prj->getData("#POLICY");
  WSCvariant enc = prj->getData("#ENCODING");
//  WSCvariant link_type = prj->getData("#LIB_CREATE");
  long encoding = WSGFgetEncodingValue(enc.getCharPtr());

  WSCstring prj_src;

  prj_src << "//WINDOW BUILDER PROJECT MASTER SRC\n";
  if (strcmp((char*)pkgname,"")){
    prj_src << "package " << pkgname << ";\n\n";
  }
  prj_src << "import org.widestudio.mwt.*;\n\n";
  prj_src << "public class " << _get_product_name(prj).getCharPtr() << "{\n";
  prj_src << "  static{\n";
  prj_src << "    System.loadLibrary(\"mwt_java\");\n";
  prj_src << "  };\n";
  prj_src << "  public static void main(String[] args){\n";
  prj_src << "    Mwt.WSGFdeviceInitialize();\n";
  prj_src << "    WSDappDev app = Mwt.WSGIappDev();\n";
  prj_src << "    Mwt.WSGFwsInitialize();\n\n";
    
  WSCstring* font_data = WSGFgetFontSaveData();
  if (font_data != NULL){
    prj_src << "    WSCstring fontdata = new WSCstring(\"";
    font_data->replaceString("\n","\\n",0);
    prj_src << font_data->getString() << "\");\n";
    prj_src << "    Mwt.WSGFsetFontData(fontdata);\n";
    delete font_data;
  }

  if (encoding != WS_EN_DEFAULT && encoding != WS_EN_NONE){
    prj_src << "    Mwt.WSGFsetDefaultEncoding(16);\n";
  }

  WSCulong win_id = 0;
  int i = -1;
  while(1){
    i++;
    WSCulong next_id = WSGIappObjectList()->getInstanceId(WS_ROOT_INSTANCE_ID,
                                       WS_NEXT_CHILD_INSTANCE_ID,win_id);
    if (next_id == 0){
      break;
    }
    win_id = next_id;
    WSCbase* win = (WSCbase*)next_id;

    if (win->getUserData(WS_REGISTERED) == (void*)0){
      continue;
    }
    if ( (long)win->getUserData(WS_WIN_CLASS) == 0 &&
         (long)win->getUserData(WS_WIN_STORE) == 0 ){
      prj_src << "    //--- OBJECT execute auto initialize ---\n";
      prj_src << "    " << win->getInstanceName() <<".create_win_"
              << win->getInstanceName() << "();\n";

    }else if ( (long)win->getUserData(WS_WIN_CLASS) == 1 ){
      //no output
    }else if ( (long)win->getUserData(WS_WIN_STORE) == 1 ){
      //no output
    }
  }

  prj_src << "    app.execInitHandler();\n";
  prj_src << "    app.handleEvents();\n";
  prj_src << "  }\n}\n";

  return prj_src;
}

long WSGFcreateMkinfFile(char* dname,char* prj_name,WSCulong proj,long encode){
  WSCindexVariantData* prj = (WSCindexVariantData*)proj;
  if (prj == NULL){
    return WS_ERR;
  }
  WSCstring lang = prj->getData("#LANG");
  WSCstring mkinf;
  mkinf << "##########################################\n";
  mkinf << "# compiler flags                         #\n";
  mkinf << "##########################################\n\n";
  mkinf << "DEBUG = ";

  WSCstring cmode = prj->getData("#CMODE");
  if (atoi((char*)cmode)){
    mkinf << prj->getData("#USER_FL");
    mkinf << " " << prj->getData("#USER_DBG_FL") << "\n\n";
  }else{
    mkinf << prj->getData("#USER_FL");
    mkinf << " " << prj->getData("#USER_RT_FL") << "\n\n";
  } 

#ifdef MSW
  if (atoi((char*)cmode)){
    mkinf << "DBGRM = echo\n\n";
  }else{
    mkinf << "DBGRM = $(RM)\n\n";
  }
#else
  if (atoi((char*)cmode)){
    mkinf << "__DBG_MK__ = 1\n\n";
  }
#endif
  mkinf << "##########################################\n";
  mkinf << "# setting of includes                    #\n";
  mkinf << "##########################################\n\n";
  mkinf << "ALL_INCLUDES = ";

  WSCstring include_value = prj->getData("#USER_INCLUDE");
  if (atoi((char*)cmode)){
    include_value << " " << prj->getData("#USER_DBG_INCLUDE");
  }else{
    include_value << " " << prj->getData("#USER_RT_INCLUDE");
  }

  mkinf <<  include_value << "\n\n";
  mkinf << "##########################################\n";
  mkinf << "# setting of libraries                   #\n";
  mkinf << "##########################################\n\n";
  mkinf << "ALL_LIBS = ";

  WSCvariant static_linked = prj->getData("#STLINK");
  WSCstring lib_value = prj->getData("#USER_LIB");

  WSCvariant link_type = prj->getData("#LIB_CREATE");
  if (static_linked.getLong() == False){
    lib_value << " " << WSGFgetMgrStrData(WS_LINK_OPTIONS,proj);
  }else{
    lib_value << " " << WSGFgetMgrStrData(WS_STLINK_OPTIONS,proj);
  }

  mkinf << lib_value;

  WSCstring ext_lib_value;
  if (atoi((char*)cmode)){
    if (atoi((char*)static_linked)){
      ext_lib_value = prj->getData("#USER_DBG_STLIB");
    }else{
      ext_lib_value = prj->getData("#USER_DBG_LIB");
    }
  }else{
    if (atoi((char*)static_linked)){
      ext_lib_value = prj->getData("#USER_RT_STLIB");
    }else{
      ext_lib_value = prj->getData("#USER_RT_LIB");
    }
  }

  mkinf << " " << ext_lib_value;

  WSCstring t_lib;
  t_lib << "ALL_LIBS2 = ";
  t_lib << lib_value;
  t_lib << " " << ext_lib_value;

  WSCstring link_libs = WSGFgetMgrStrData(WS_LINK_LIB_NAME,proj);
  mkinf << link_libs;
  t_lib << link_libs;

  t_lib.replaceString("WSDIR","WS_DEFAULT_DIR",0);

  mkinf << "\n\n";
  mkinf << t_lib;

  mkinf << "\n\n";
  mkinf << "##########################################\n";
  mkinf << "# setting of window                      #\n";
  mkinf << "##########################################\n\n";

  WSClistData  oplist;
  WSCstring wininf,opinf;
  WSCstring pname(prj_name,encode);
  wininf << "WINOBJ = " << pname << ".o ";

  WSCulong win_id = 0;
  while(1){
    WSCulong next_id = WSGIappObjectList()->getInstanceId(WS_ROOT_INSTANCE_ID,
                                       WS_NEXT_CHILD_INSTANCE_ID,win_id);
    if (next_id == 0){
      break;
    }
    win_id = next_id;
    WSCbase* win = (WSCbase*)next_id;
    WSGFgetProcedureList(win,&oplist);
    if (win->getUserData(WS_WIN_CLASS) != NULL){
      wininf << "\\\n        ";
      wininf << win->getInstanceName();
      wininf << ".o ";
      wininf << "\\\n        ";
      wininf << win->getInstanceName();
      wininf << "P.o ";
      if ((long)win->getUserData(WS_RCLASS_GENERATE) == 1){
        char* rcname = (char*)win->getUserData(WS_RCLASS_NAME);
        if (rcname != NULL){
          wininf << "        " << rcname << ".o\\\n";
        }
      }
    }else if (win->getUserData(WS_WIN_STORE) != NULL){
    }else{
      wininf << "\\\n        ";
      wininf << win->getInstanceName();
      wininf << ".o ";
    }
  }

  int num = oplist.getNum();
  if (num > 0){
    opinf << "OPOBJ = \\\n";
  }
  int i;
  for(i=0; i<num; i++){
    char* opname = (char*)oplist.getData(i);
    opinf << "        ";
    opinf << opname;
    opinf << ".o ";
    if (i != num -1){
      opinf << "\\\n";
    }
    delete opname;
  }

  mkinf << wininf << "\n\n";
  mkinf << opinf << "\n\n";
  mkinf << "OBJS = $(WINOBJ) $(OPOBJ) ";

  WSCstring sources = prj->getData("#WS_FILES");
  sources.delHeadSpace();
  sources.delTailSpace();
  if (strcmp((char*)sources,"0") && strcmp((char*)sources,"")){
    WSCstring files;
    if (!strcmp((char*)lang,WSN_LANG_CPP)){
      sources.replaceString(".cpp",".o",-1);
    }else if (!strcmp((char*)lang,WSN_LANG_OCAML)){
      sources.replaceString(".ml",".o",-1);
    }
    sources.replaceString(","," ",-1);
    mkinf << sources << " ";
  }

  mkinf << prj->getData("#OBJS") << " \n\n";
  mkinf << "##########################################\n";
  mkinf << "# setting of target binary               #\n";
  mkinf << "##########################################\n\n";
  mkinf << "TARGET = ";

  if (link_type.getLong() != 1){
    if (link_type.getLong() == 0 ||
        link_type.getLong() == 4){
      mkinf << _get_vproduct_name(prj);
    }else{
#ifdef MSW
    if (link_type.getLong() == 3){
      mkinf << _get_vproduct_name(prj) << ".ocx";
    }else{
      mkinf << _get_vproduct_name(prj) << ".dll";
    }
#else /*MSW*/
#ifdef MacOS
    mkinf << _get_vproduct_name(prj) << ".dylib";
#else
    mkinf << _get_vproduct_name(prj) << ".so";
#endif
#endif /*MSW*/
    }
    mkinf << "\n\n";
    mkinf << "CC=" << prj->getData("#CC1") << "\n";
    mkinf << "CXX=" << prj->getData("#CC") << "\n";
  }else{
#ifdef MSW
    if (link_type.getLong() == 3){
      mkinf << _get_vproduct_name(prj) << ".ocx";
    }else{
      mkinf << "lib" <<  _get_vproduct_name(prj) << ".dll";
    }
#else /*MSW*/
#ifdef MacOS
    mkinf << "lib" <<  _get_vproduct_name(prj) << ".dylib";
#else
    mkinf << "lib" <<  _get_vproduct_name(prj) << ".so";
#endif
#endif /*MSW*/
    mkinf << "\n\n";
    mkinf << "TARGET2 = ";
    mkinf << "lib" <<  _get_vproduct_name(prj) << ".a";
    mkinf << "\n\n";
    mkinf << "CC=" << prj->getData("#CC1") << "\n";
    mkinf << "CXX=" << prj->getData("#CC") << "\n";
  }

  WSCstring mkinf2;
  WSCvariant tval = WSGFgetProjectData((WSCulong)prj,"#COMPAT");
  long target = tval.getLong();
//printf("tval = %s target=%d\n",(char*)tval,target);
  if (target > 0){
    WSCstring str = WSGFgetMgrStrData(WS_TARGET_ENV_NAME,target);
    WSCstring tenv = WSGFgetProjectEnvironmentData((char*)str);

#ifdef MSW
    char c;
    for(c = 'a'; c < 'z'+1; c++){
      char buf[3];
      buf[0] = c;
      buf[1] = ':';
      buf[2] = 0;

      char buf2[3];
      buf2[0] = c + 'A' - 'a';
      buf2[1] = ':';
      buf2[2] = 0;

      char buf3[2];
      buf3[0] = c;
      buf3[1] = 0;

      WSCstring dest("/cygdrive/");
      dest << buf3;
      if (tenv.isExist(buf) != -1){
        tenv.replaceString(buf,dest,1);
      }else
      if (tenv.isExist(buf2) != -1){
        tenv.replaceString(buf2,dest,1);
      }
    }
    while(tenv.replaceString("\\","/",0));
    while(tenv.replaceString("//","/",0));
#endif

    mkinf2 << "##########################################\n";
    mkinf2 << "# compiler environment                   #\n";
    mkinf2 << "##########################################\n\n";
    mkinf2 << "BD = " << tenv << "\n\n";
  }

  WSCstring mkinf_fname;
  WSCstring mkinf_fname2;
  if (!strcmp(dname,"")){
    mkinf_fname << "mk.inf"; 
    mkinf_fname2 << "makefile.env"; 
  }else{
    WSCstring dirname(dname,encode);
    mkinf_fname << dirname << "/" << "mk.inf"; 
    mkinf_fname2 << dirname << "/" << "makefile.env"; 
  }

  long ret = WSGFreplaceTextFile(mkinf_fname,mkinf.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),False);
  if (ret != WS_NO_ERR){
    return ret;
  }
  return WSGFreplaceTextFile(mkinf_fname2,mkinf2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),False);
}

#ifdef MSW
void _copyfile_to_project_dir(char* dname,char* destname,char* srcname){
  WSCstring fname = "";
  fname << dname << "/" << destname;
  if (WSGFcheckExistFile(fname) == False){
    WSCstring buffer;
    buffer = WSGIappFileSystem()->adjustFileName(srcname);
    while( buffer.replaceString("//","/",0));
    while( buffer.replaceString("/","\\",0));
    while( fname.replaceString("//","/",0));
    while( fname.replaceString("/","\\",0));
    CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
             fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
  }
}
#endif


# define WS_MAKE_FILE2        "makefile"
# define WS_MAKE_FLAGS        WS_CFG_DIR "mkflags"
# define WS_MAKE_FLAGS2       "mkflags"
#ifdef MacOS
#define WS_XPM_DLL "xpm.bundle"
#define WS_PNG_DLL "png.bundle"
#define WS_JPG_DLL "jpg.bundle"
#else
#define WS_XPM_DLL "libwsxpm.so"
#define WS_PNG_DLL "libwspng.so"
#define WS_JPG_DLL "libwsjpg.so"
#endif

long WSGFcreateMakefiles(char* dname,char* prj_name,WSCulong proj,long encode){
  WSCindexVariantData* prj = (WSCindexVariantData*)proj;
  if (prj == NULL){
    return WS_ERR;
  }

  WSCstring buffer;
  long encoding = WSGFgetEncodingValue(prj->getData("#ENCODING"));
  if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
    encoding = WS_EN_LOCALE;
  }

  WSCvariant link_type = prj->getData("#LIB_CREATE");
  WSCvariant lang = prj->getData("#LANG");
  if (!strcmp(lang.getCharPtr(),WSN_LANG_CPP) ||
      !strcmp(lang.getCharPtr(),WSN_LANG_OCAML) ){
    WSGFcreateMkinfFile(dname,prj_name,proj,encode);
    WSCstring tval = WSGFgetProjectData((WSCulong)prj,"#COMPAT");
    long target = WSGFatol((char*)tval);
    WSCstring suffix;
    if (WSGFatol(tval) > 0){
      suffix = WSGFgetMgrStrData(WS_TARGET_SUFFIX,target);
    }

    WSCstring mfname;
    mfname << "$(WSDIR)/sys/data/" << WSGFgetEncodingName(encoding)
           << "/make_exe" << suffix;
    WSCstring mfname_dll;
    mfname_dll << "$(WSDIR)/sys/data/" << WSGFgetEncodingName(encoding)
               << "/make_dll" << suffix;

    WSCstring mfname_nsp;
    mfname_nsp << "$(WSDIR)/sys/data/" << WSGFgetEncodingName(encoding)
               << "/make_nsp" << suffix;

    WSCstring mfname_iep;
    mfname_iep << "$(WSDIR)/sys/data/" << WSGFgetEncodingName(encoding)
               << "/make_iep" << suffix;

    if (!strcmp(lang.getCharPtr(),WSN_LANG_OCAML)){
      mfname = "";
      mfname << "$(WSDIR)/sys/data/" << WSGFgetEncodingName(encoding)
               << "/make_ocaml";
    }

    WSCstring test_html;
    if (link_type.getLong() == 3){
      test_html << "$(WSDIR)/sys/data/test-iep.html";
    }else{
      test_html << "$(WSDIR)/sys/data/test.html";
    }
    if (link_type.getLong() == 0 || link_type.getLong() == 2 ||
        link_type.getLong() == 3 || link_type.getLong() == 4){
#ifdef MSW
      if (link_type.getLong() == 0|| link_type.getLong() == 4){
        buffer = WSGIappFileSystem()->adjustFileName(mfname);
      }else if (link_type.getLong() == 2){
        buffer = WSGIappFileSystem()->adjustFileName(mfname_nsp);
      }else if (link_type.getLong() == 3){
        buffer = WSGIappFileSystem()->adjustFileName(mfname_iep);
      }
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring dstr(dname,encode);
      WSCstring buffer2;
      buffer2 << dstr << "/" << WS_MAKE_FILE2;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
#else
      WSCstring dstr(dname,encode);
#ifdef BTRON
      WSCstring buffer2;
      if (link_type.getLong() == 0 ||
          link_type.getLong() == 4){
        buffer = WSGIappFileSystem()->adjustFileName(mfname);
      }else if (link_type.getLong() == 2){
        buffer = WSGIappFileSystem()->adjustFileName(mfname_nsp);
      }
      buffer2 << dstr << "/" << WS_MAKE_FILE2;
      copy_file( (char*)buffer,(char*)buffer2);
#else
      if (link_type.getLong() == 0 || link_type.getLong() == 4){
        buffer = "\\cp \"";
        buffer << WSGIappFileSystem()->adjustFileName(mfname)
             << "\" \"" << dstr << "/" << WS_MAKE_FILE2 << "\"";
      }else if (link_type.getLong() == 2){
        buffer = "\\cp \"";
        buffer << WSGIappFileSystem()->adjustFileName(mfname_nsp)
             << "\" \"" << dstr << "/" << WS_MAKE_FILE2 << "\"";
      }
      system(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
#endif

      WSCvariant static_linked = prj->getData("#STLINK");
      if (atoi((char*)static_linked) == 1){
        WSCstring dstr(dname,encode);
#ifdef BTRON
        buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_XPM_DLL);
        buffer2 = dstr;
        buffer2 << "/" << WS_XPM_DLL;
        copy_file((char*)buffer,(char*)buffer2);
#else
        buffer = "\\cp \"";
        buffer << WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_XPM_DLL)
           << "\" \"" << dstr << "/" << WS_XPM_DLL << "\"";
        system(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
#endif
#ifdef BTRON
        buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_PNG_DLL);
        buffer2 = dstr;
        buffer2 << "/" << WS_PNG_DLL;
        copy_file((char*)buffer,(char*)buffer2);
#else
        buffer = "\\cp \"";
        buffer << WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_PNG_DLL)
           << "\" \"" << dstr << "/" << WS_PNG_DLL << "\"";
        system(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
#endif

#ifdef BTRON
        buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_JPG_DLL);
        buffer2 = dstr;
        buffer2 << "/" << WS_JPG_DLL;
        copy_file((char*)buffer,(char*)buffer2);
#else
        buffer = "\\cp \"";
        buffer << WSGIappFileSystem()->adjustFileName("$(WSDIR)/lib/" WS_JPG_DLL)
           << "\" \"" << dstr << "/" << WS_JPG_DLL << "\"";
        system(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
#endif
      }
#endif
      if (link_type.getLong() == 2 || link_type.getLong() == 3){
        WSCstring* buf2 = WSGFreadTextFile(test_html);
        if (buf2 != NULL){
          buf2->replaceString("#PROGRAM#",_get_vproduct_name(prj),0);
          WSCstring buffer2;
  
          WSCstring dstr(dname,encode);
          if (link_type.getLong() == 2){
            buffer2 << dstr << "/test.html";
          }else if (link_type.getLong() == 3){
            buffer2 << dstr << "/test.html";
            long val = 0;
            sscanf( prj->getData("#ID").getCharPtr(),"%x",&val);
            char buffer[1024];
            sprintf(buffer,"%08x",val+3);
            buf2->replaceString("#ID#",buffer,0);
          }
#ifdef MSW
          while( buffer2.replaceString("//","/",0));
          while( buffer2.replaceString("/","\\",0));
#endif //MSW
          WSGFreplaceTextFile(buffer2,buf2->getString(),False);
          delete buf2;
        }
      }
    }
    if (link_type.getLong() == 1){
      WSCstring dstr(dname,encode);
#ifdef MSW
      buffer = WSGIappFileSystem()->adjustFileName(mfname_dll);
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      WSCstring buffer2;
      buffer2 << dstr << "/" << WS_MAKE_FILE2;
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));
      CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
#else
#ifdef BTRON
      buffer = WSGIappFileSystem()->adjustFileName(mfname_dll);
      WSCstring buffer2 = dstr;
      buffer2 << "/" << WS_MAKE_FILE2;
      copy_file((char*)buffer,(char*)buffer2);
#else
      buffer = "\\cp \"";
      buffer << WSGIappFileSystem()->adjustFileName(mfname_dll)
           << "\" \"" << dstr << "/" << WS_MAKE_FILE2 << "\"";
      system(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
#endif
#endif
    }

    WSCstring dstr(dname,encode);
#ifdef MSW
    WSCstring mkflags_fname(WS_MAKE_FLAGS);
    mkflags_fname << suffix;
    buffer = WSGIappFileSystem()->adjustFileName(mkflags_fname);
    while( buffer.replaceString("//","/",0));
    while( buffer.replaceString("/","\\",0));
    WSCstring buffer2;
    buffer2 << dstr << "/" << WS_MAKE_FLAGS2;
    while( buffer2.replaceString("//","/",0));
    while( buffer2.replaceString("/","\\",0));
    CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
      buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
#else
#ifdef BTRON
    WSCstring mkflags_fname(WS_MAKE_FLAGS);
    mkflags_fname << suffix;
    buffer = WSGIappFileSystem()->adjustFileName(mkflags_fname);
    WSCstring buffer2 = dstr;
    buffer2 << "/" << WS_MAKE_FLAGS2;
    copy_file((char*)buffer,(char*)buffer2);
#else
#ifdef MacOS
    if (link_type.getLong() == 0 ||
        link_type.getLong() == 4 ){
      WSCstring mac_sh;
      mac_sh << "$(WSDIR)/sys/data/sample.sh";
      WSCstring* buf_sh = WSGFreadTextFile(mac_sh);
      if (buf_sh != NULL){
        buf_sh->replaceString("#PROGRAM#",_get_vproduct_name(prj),0);
        WSCstring buffer2;
        buffer2 << dstr << "/" << _get_vproduct_name(prj) << ".sh";
        WSGFreplaceTextFile(buffer2,buf_sh->getString(),False);
        buffer2 = "chmod a+x ";
        buffer2 << dstr << "/" << _get_vproduct_name(prj) << ".sh";
        system(buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
        delete buf_sh;
      }
    }
#endif
    buffer = "\\cp \"";
    buffer << WSGIappFileSystem()->adjustFileName(WS_MAKE_FLAGS)
           << suffix
           << "\" \"" << dstr << "/" << WS_MAKE_FLAGS2 << "\"";
    system(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
#endif
#endif
 
#ifdef MSW
    WSCstring fname;
    //NOT NETSCAPE/IE PLUGIN
    if (link_type.getLong() != 2 && link_type.getLong() != 3){
      fname << dstr << "/" << "wsres.rc";
      if (WSGFcheckExistFile(fname) == False){
        WSCstring buffer;
        buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/wsres.rc");
        while( buffer.replaceString("//","/",0));
        while( buffer.replaceString("/","\\",0));
        while( fname.replaceString("//","/",0));
        while( fname.replaceString("/","\\",0));
        CopyFile(
          buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
          fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
      }
    }else{ //NETSCAPE/IE PLUGIN
      fname << dstr << "/" << "wsres.rc";
      {
        WSCstring buffer;
        if (link_type.getLong() == 2){ //NETSCAPE PLUGIN
          buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/wsres-nsp.rc");
        }else{ //IE PLUGIN
          buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/wsres-iep.rc");
        }
        while( buffer.replaceString("//","/",0));
        while( buffer.replaceString("/","\\",0));
        while( fname.replaceString("//","/",0));
        while( fname.replaceString("/","\\",0));

        CopyFile(
          buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
          fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
        if (link_type.getLong() == 3){ //IE PLUGIN
          fname ="";
          fname << dstr << "/" << "resource.h";
          buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/resource.h");
          while( buffer.replaceString("//","/",0));
          while( buffer.replaceString("/","\\",0));
          while( fname.replaceString("//","/",0));
          while( fname.replaceString("/","\\",0));

          CopyFile(
            buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
            fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
            FALSE);
          fname ="";
          fname << dstr << "/" << "dwinvers.h";
          buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/dwinvers.h");
          while( buffer.replaceString("//","/",0));
          while( buffer.replaceString("/","\\",0));
          while( fname.replaceString("//","/",0));
          while( fname.replaceString("/","\\",0));

          CopyFile(
            buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
            fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
            FALSE);
        }
      }
      WSCstring buffer2;
      buffer2 << dstr << "/wsres.rc";
      while( buffer2.replaceString("//","/",0));
      while( buffer2.replaceString("/","\\",0));

      WSCstring* buf2 = WSGFreadTextFile(buffer2);
      if (buf2 != NULL){
        buf2->replaceString("#PROGRAM#",_get_vproduct_name(prj),0);
        WSCstring pname(_get_vproduct_name(prj));
        if (link_type.getLong() == 3){ //IE PLUGIN
          pname << ".ocx";
        }else{
          pname << ".dll";
        }
        buf2->replaceString("#PROGRAM-NAME#",pname,0);
        WSGFreplaceTextFile(buffer2,buf2->getString(),False);
        delete buf2;
      }
    }
    fname = "";
    fname << dstr << "/" << "icons";
    int ret = _mkdir(fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
    _copyfile_to_project_dir(dstr,"icons/psave.ico", "$(WSDIR)/sys/pixmaps/psave.ico");
    _copyfile_to_project_dir(dstr,"icons/pend.ico","$(WSDIR)/sys/pixmaps/pend.ico");
    _copyfile_to_project_dir(dstr,"icons/wload.ico","$(WSDIR)/sys/pixmaps/wload.ico");
    _copyfile_to_project_dir(dstr,"icons/wsave.ico","$(WSDIR)/sys/pixmaps/wsave.ico");
    _copyfile_to_project_dir(dstr,"icons/obox.ico","$(WSDIR)/sys/pixmaps/obox.ico");
    _copyfile_to_project_dir(dstr,"icons/make.ico","$(WSDIR)/sys/pixmaps/make.ico");
    _copyfile_to_project_dir(dstr,"icons/run.ico","$(WSDIR)/sys/pixmaps/run.ico");
    _copyfile_to_project_dir(dstr,"icons/search.ico","$(WSDIR)/sys/pixmaps/search.ico");
    _copyfile_to_project_dir(dstr,"icons/search2.ico","$(WSDIR)/sys/pixmaps/search2.ico");
    _copyfile_to_project_dir(dstr,"icons/help.ico","$(WSDIR)/sys/pixmaps/help.ico");
    _copyfile_to_project_dir(dstr,"icons/runx.ico","$(WSDIR)/sys/pixmaps/runx.ico");
    _copyfile_to_project_dir(dstr,"icons/bi4.ico","$(WSDIR)/sys/pixmaps/bi4.ico");
    _copyfile_to_project_dir(dstr,"icons/bi13.ico","$(WSDIR)/sys/pixmaps/bi13.ico");
    _copyfile_to_project_dir(dstr,"icons/bi15.ico","$(WSDIR)/sys/pixmaps/bi15.ico");
    _copyfile_to_project_dir(dstr,"icons/bi16.ico","$(WSDIR)/sys/pixmaps/bi16.ico");
    _copyfile_to_project_dir(dstr,"icons/bi17.ico","$(WSDIR)/sys/pixmaps/bi17.ico");
    _copyfile_to_project_dir(dstr,"icons/bi18.ico","$(WSDIR)/sys/pixmaps/bi18.ico");
    _copyfile_to_project_dir(dstr,"icons/bi19.ico","$(WSDIR)/sys/pixmaps/bi19.ico");
    _copyfile_to_project_dir(dstr,"icons/bi23.ico","$(WSDIR)/sys/pixmaps/bi23.ico");
    _copyfile_to_project_dir(dstr,"icons/bi24.ico","$(WSDIR)/sys/pixmaps/bi24.ico");
    _copyfile_to_project_dir(dstr,"icons/bi25.ico","$(WSDIR)/sys/pixmaps/bi25.ico");
    _copyfile_to_project_dir(dstr,"icons/endbtn.ico","$(WSDIR)/sys/pixmaps/endbtn.ico");
    _copyfile_to_project_dir(dstr,"icons/ope.ico","$(WSDIR)/sys/pixmaps/ope.ico");
    _copyfile_to_project_dir(dstr,"icons/wcreate.ico","$(WSDIR)/sys/pixmaps/wcreate.ico");
    _copyfile_to_project_dir(dstr,"icons/wtrash.ico","$(WSDIR)/sys/pixmaps/wtrash.ico");
    _copyfile_to_project_dir(dstr,"icons/edit.ico","$(WSDIR)/sys/pixmaps/edit.ico");
    _copyfile_to_project_dir(dstr,"icons/pset.ico","$(WSDIR)/sys/pixmaps/pset.ico");
    _copyfile_to_project_dir(dstr,"icons/bi8.ico","$(WSDIR)/sys/pixmaps/bi8.ico");
    _copyfile_to_project_dir(dstr,"icons/pcreate.ico","$(WSDIR)/sys/pixmaps/pcreate.ico");
    _copyfile_to_project_dir(dstr,"icons/pload.ico","$(WSDIR)/sys/pixmaps/pload.ico");
    _copyfile_to_project_dir(dstr,"icons/bi40.ico","$(WSDIR)/sys/pixmaps/bi40.ico");
    _copyfile_to_project_dir(dstr,"icons/bi41.ico","$(WSDIR)/sys/pixmaps/bi41.ico");
    _copyfile_to_project_dir(dstr,"icons/bi42.ico","$(WSDIR)/sys/pixmaps/bi42.ico");
    _copyfile_to_project_dir(dstr,"icons/bi43.ico","$(WSDIR)/sys/pixmaps/bi43.ico");
    fname = "";
    fname << dstr << "/" << "main.ico";
    if (WSGFcheckExistFile(fname) == False){
      WSCstring buffer;
      buffer = WSGIappFileSystem()->adjustFileName("$(WSDIR)/sys/data/main.ico");
      while( buffer.replaceString("//","/",0));
      while( buffer.replaceString("/","\\",0));
      while( fname.replaceString("//","/",0));
      while( fname.replaceString("/","\\",0));
      CopyFile(
        buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
        FALSE);
    }
#endif

  }else
  if (!strcmp(lang.getCharPtr(),WSN_LANG_JAVA)){
//printf("WSGFcreateMakefiles Java language not supported..\n");
    WSCstring buffer;
    WSCstring dstr(dname,encode);
#ifdef MSW
#define WS_JAVA_LIB_MWT  "$(WSDIR)/lib/mwt_java.dll"
#define WS_JAVA_LIB2_MWT  "mwt_java.dll"
#define WS_JAVA_SRC_MWT  "$(WSDIR)/lib/mwt.jar"
#define WS_JAVA_SRC2_MWT  "mwt.jar"
    buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_LIB_MWT);
    while( buffer.replaceString("//","/",0));
    while( buffer.replaceString("/","\\",0));
    WSCstring buffer2;
    buffer2 << dstr << "/" << WS_JAVA_LIB2_MWT;
    while( buffer2.replaceString("//","/",0));
    while( buffer2.replaceString("/","\\",0));
    CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
      buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);

    buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_SRC_MWT);
    while( buffer.replaceString("//","/",0));
    while( buffer.replaceString("/","\\",0));
    buffer2 = "";
    buffer2 << dstr << "/" << WS_JAVA_SRC2_MWT;
    while( buffer2.replaceString("//","/",0));
    while( buffer2.replaceString("/","\\",0));
    CopyFile(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
      buffer2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),FALSE);
#else

#ifndef MacOS
#define WS_JAVA_LIB_MWT  "$(WSDIR)/lib/libmwt_java.so"
#define WS_JAVA_LIB2_MWT  "libmwt_java.so"
#else //MacOS
#define WS_JAVA_LIB_MWT  "$(WSDIR)/lib/libmwt_java.jnilib"
#define WS_JAVA_LIB2_MWT  "libmwt_java.jnilib"
#endif //MacOS

#define WS_JAVA_SRC_MWT  "$(WSDIR)/lib/mwt.jar"
#define WS_JAVA_SRC2_MWT  "mwt.jar"

#ifdef BTRON
    buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_LIB_MWT);
    WSCstring buffer2 = dstr;
    buffer2 << "/" << WS_JAVA_LIB2_MWT;
    copy_file((char*)buffer,(char*)buffer2);

    buffer = WSGIappFileSystem()->adjustFileName(WS_JAVA_SRC_MWT);
    buffer2 = dstr;
    buffer2 << "/" << WS_JAVA_SRC2_MWT;
    copy_file((char*)buffer,(char*)buffer2);
#else
    buffer = "\\cp \"";
    buffer << WSGIappFileSystem()->adjustFileName(WS_JAVA_LIB_MWT)
           << "\" \"" << dstr << "/" << WS_JAVA_LIB2_MWT << "\"";
//printf("WSGFcreateMakefiles Java language execute=#%s#..\n",(char*)buffer);
    system(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));

    buffer = "\\cp \"";
    buffer << WSGIappFileSystem()->adjustFileName(WS_JAVA_SRC_MWT)
           << "\" \"" << dstr << "/" << WS_JAVA_SRC2_MWT << "\"";
//printf("WSGFcreateMakefiles Java language execute=#%s#..\n",(char*)buffer);
    system(buffer.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
#endif

#endif

  }else
  if (!strcmp(lang.getCharPtr(),WSN_LANG_RUBY)){
printf("WSGFcreateMakefiles Ruby language not supported..\n");
  }else
  if (!strcmp(lang.getCharPtr(),WSN_LANG_PYTHON)){
printf("WSGFcreateMakefiles Python language not supported..\n");
  }else
  if (!strcmp(lang.getCharPtr(),WSN_LANG_PERL)){
printf("WSGFcreateMakefiles Perl language not supported..\n");
  }else
  if (!strcmp(lang.getCharPtr(),WSN_LANG_OCAML)){
printf("WSGFcreateMakefiles Ocaml language not supported..\n");
  }
  return WS_ERR;
}
long WSGFcreateProjectSrcFile(char* dname,char* fname,WSCulong proj,long encoding){
  WSCindexVariantData* prj = (WSCindexVariantData*)proj;
  if (prj == NULL){
    return WS_ERR;
  }

  WSCvariant lang = prj->getData("#LANG");
  if (!strcmp(lang.getCharPtr(),WSN_LANG_CPP)){
    WSCstring str = WSGFcreateProjectSrcC(proj);
    WSCstring file_name(dname,encoding);
    if (strcmp(dname,"")){
      file_name << "/" << fname << ".cpp";
    }else{
      file_name << fname << ".cpp";
    }
    WSCvariant enc = prj->getData("#ENCODING");
    long encoding = WSGFgetEncodingValue(enc.getCharPtr());

    WSMFchmod((char*)file_name,0666);
    long ret = WSGFreplaceTextFile((char*)file_name, str.getString(encoding),False);
    WSMFchmod((char*)file_name,0444);

    return ret;
  }else
  if (!strcmp(lang.getCharPtr(),WSN_LANG_JAVA)){
    WSCstring str = WSGFcreateProjectSrcJava(proj);
    WSCstring file_name(dname,encoding);
    if (strcmp(dname,"")){
      file_name << "/" << fname << ".java";
    }else{
      file_name << fname << ".java";
    }
    WSCvariant enc = prj->getData("#ENCODING");
    long encoding = WSGFgetEncodingValue(enc.getCharPtr());

    WSMFchmod((char*)file_name,0666);
    long ret = WSGFreplaceTextFile((char*)file_name, str.getString(encoding),False);
    WSMFchmod((char*)file_name,0444);

    return ret;
  }else
  if (!strcmp(lang.getCharPtr(),WSN_LANG_RUBY)){
printf("WSGFcreateProjectSrcFile Ruby language not supported..\n");
  }else
  if (!strcmp(lang.getCharPtr(),WSN_LANG_PYTHON)){
printf("WSGFcreateProjectSrcFile Python language not supported..\n");
  }else
  if (!strcmp(lang.getCharPtr(),WSN_LANG_PERL)){
printf("WSGFcreateProjectSrcFile Perl language not supported..\n");
  }else
  if (!strcmp(lang.getCharPtr(),WSN_LANG_OCAML)){
printf("WSGFcreateProjectSrcFile Ocaml language not supported..\n");
  }
  return WS_ERR;
}

long WSGFcreateWindowSrcFiles(char* dname,WSCulong proj,long encode){
  WSCindexVariantData* prj = (WSCindexVariantData*)proj;
  if (prj == NULL){
    return WS_ERR;
  }

  WSCvariant lang = prj->getData("#LANG");
  WSCvariant enc = prj->getData("#ENCODING");
  long encoding = WSGFgetEncodingValue(enc.getCharPtr());

  WSCulong win_id = 0;
  int i = -1;
  while(1){
    i++;
    WSCulong next_id = WSGIappObjectList()->getInstanceId(WS_ROOT_INSTANCE_ID,
                                       WS_NEXT_CHILD_INSTANCE_ID,win_id);
//printf("WSGFcreateWindowSrcFiles next_id=0x%x\n",next_id);fflush(stdout);
    if (next_id == 0){
      break;
    }
    win_id = next_id;
    WSCbase* win = (WSCbase*)next_id;
//printf("lang=#%s#\n",lang.getCharPtr());fflush(stdout);
    if (win->getUserData(WS_WIN_STORE)){
      WSCstring file_name(dname,encode);
      if (strcmp(dname,"")){
        file_name << "/" << win->getInstanceName() << ".oof";
      }else{
        file_name << win->getInstanceName() << ".oof";
      }
      WSGIconductor()->setSerializePath( "" );
      WSDserialize* db = WSGIconductor()->beginTransaction("FILE",(char*)file_name);
      if (db != NULL){
        WSCbase* b = WSGFgetClassBase(win);
        long ret = WSGIconductor()->save(db,b->getClassName(),win->getInstanceName(),b);
        if (ret != WS_NO_ERR){
          WSGFresetClassBase(win);
          return WS_ERR;
        }
        WSGIconductor()->endTransaction(db);
        WSGFresetClassBase(win);
      }else{
        return WS_ERR;
      }
    }else
    if (!strcmp(lang.getCharPtr(),WSN_LANG_CPP)){
      if (win->getUserData(WS_WIN_CLASS)){
        WSCbase* b = WSGFgetClassBase(win);

        WSCstring file_name(dname,encode);
        if (strcmp(dname,"")){
          file_name << "/" << win->getInstanceName() << ".cpp";
        }else{
          file_name << win->getInstanceName() << ".cpp";
        }
        if (WSGFcheckExistFile(file_name) == False){
          WSCstring* output = WSGFcreateWindowClassSrc(b);
          if (output == NULL){
            WSGFresetClassBase(win);
            return WS_ERR;
          }
          WSMFchmod((char*)file_name,0666);
          long ret = WSGFreplaceTextFile((char*)file_name,output->getString(encoding),False);
          WSMFchmod((char*)file_name,0444);
          delete output;
          if (ret == WS_ERR){
            WSGFresetClassBase(win);
            return WS_ERR;
          }
        }

        file_name.setString(dname,encode);
        if (strcmp(dname,"")){
          file_name << "/" << win->getInstanceName() << ".h";
        }else{
          file_name << win->getInstanceName() << ".h";
        }
        if (WSGFcheckExistFile(file_name) == False){
          WSCstring* output = WSGFcreateWindowClassHeader(b);
          if (output == NULL){
            return WS_ERR;
          }

          WSMFchmod((char*)file_name,0666);
          long ret = WSGFreplaceTextFile((char*)file_name,output->getString(encoding),False);
          WSMFchmod((char*)file_name,0444);

          delete output;
          if (ret == WS_ERR){
            WSGFresetClassBase(win);
            return WS_ERR;
          }
        }else{
          WSCstring* head = WSGFreadTextFile(file_name,encoding);
          if (head != NULL){
            WSGFupdateWindowClassHeader(head,b);

            WSMFchmod((char*)file_name,0666);
            long ret = WSGFreplaceTextFile(file_name,head->getString(encoding),False);
            WSMFchmod((char*)file_name,0444);

            delete head;
            if (ret != WS_NO_ERR){
              WSGFresetClassBase(win);
              return WS_ERR;
            }
          }else{
            WSGFresetClassBase(win);
            return WS_ERR;
          }
        }
        file_name.setString(dname,encode);
        if (strcmp(dname,"")){
          file_name << "/" << win->getInstanceName() << "P.cpp";
        }else{
          file_name << win->getInstanceName() << "P.cpp";
        }
        WSCstring* output = WSGFcreateWindowClassSrcP(b);

        WSMFchmod((char*)file_name,0666);
        long ret = WSGFreplaceTextFile((char*)file_name,output->getString(encoding),False);
        WSMFchmod((char*)file_name,0444);

        delete output;
        if (ret != WS_NO_ERR){
          return WS_ERR;
        }
        file_name.setString(dname,encode);
        if (strcmp(dname,"")){
          file_name << "/" << win->getInstanceName() << "P.h";
        }else{
          file_name << win->getInstanceName() << "P.h";
        }
        output = WSGFcreateWindowClassHeaderP(b);

        WSMFchmod((char*)file_name,0666);
        ret = WSGFreplaceTextFile((char*)file_name,output->getString(encoding),False);
        WSMFchmod((char*)file_name,0444);

        delete output;
        if (ret != WS_NO_ERR){
          WSGFresetClassBase(win);
          return WS_ERR;
        }

        if (win->getUserData(WS_RCLASS_GENERATE) != NULL){
          WSCstring outp = WSGFcreateVirtualRemoteClassHeader(win);
          char* rcname = (char*)win->getUserData(WS_RCLASS_NAME);
          if (rcname != NULL){
            file_name.setString(dname,encode);
            if (strcmp(dname,"")){
              file_name << "/" << rcname << ".h";
            }else{
              file_name << rcname << ".h";
            }

            WSMFchmod((char*)file_name,0666);
            ret = WSGFreplaceTextFile((char*)file_name,
                                  outp.getString(encoding),False);
            WSMFchmod((char*)file_name,0444);

            if (ret != WS_NO_ERR){
              WSGFresetClassBase(win);
              return WS_ERR;
            }
            outp = WSGFcreateVirtualRemoteClassSrc(win);
            file_name.setString(dname,encode);
            if (strcmp(dname,"")){
              file_name << "/" << rcname << ".cpp";
            }else{
              file_name << rcname << ".cpp";
            }

            WSMFchmod((char*)file_name,0666);
            ret = WSGFreplaceTextFile((char*)file_name,
                               outp.getString(encoding),False);
            WSMFchmod((char*)file_name,0444);

            if (ret != WS_NO_ERR){
              WSGFresetClassBase(win);
              return WS_ERR;
            }
          }
        }
        WSGFresetClassBase(win);

      }else{
        WSCstring* output = WSGFcreateWindowSrc(win);
        if (output == NULL){
          return WS_ERR;
        }
        WSCstring file_name(dname,encode);
        if (strcmp(dname,"")){
          file_name << "/" << win->getInstanceName() << ".cpp";
        }else{
          file_name << win->getInstanceName() << ".cpp";
        }

        WSMFchmod((char*)file_name,0666);
        long ret = WSGFreplaceTextFile((char*)file_name, output->getString(encoding),False);
        WSMFchmod((char*)file_name,0444);

        if (ret == WS_ERR){
          delete output;
          return WS_ERR;
        }
        delete output;
      }
    }else
    if (!strcmp(lang.getCharPtr(),WSN_LANG_JAVA)){
      if (win->getUserData(WS_WIN_CLASS)){
printf("Class source code generator for Java language is not supported..\n");
      }else{
        WSCstring pkgname;
        if (prj->isExist("#JAVA_PKG_NAME") != False){
          pkgname = prj->getData("#JAVA_PKG_NAME").getCharPtr();
          pkgname.delHeadSpace();
          pkgname.delTailSpace();
        }

        WSCstring* output = WSGFcreateWindowSrcMwtJava(win,(char*)pkgname);
        if (output == NULL){
          return WS_ERR;
        }
        WSCstring file_name(dname,encode);
        if (strcmp(dname,"")){
          file_name << "/" << win->getInstanceName() << ".java";
        }else{
          file_name << win->getInstanceName() << ".java";
        }

        WSMFchmod((char*)file_name,0666);
        long ret = WSGFreplaceTextFile((char*)file_name, output->getString(encoding),False);
        WSMFchmod((char*)file_name,0444);
        if (ret == WS_ERR){
          delete output;
          return WS_ERR;
        }
        delete output;
        return WS_NO_ERR;
      }
      return WS_ERR;

    }else
    if (!strcmp(lang.getCharPtr(),WSN_LANG_RUBY)){
      if (win->getUserData(WS_WIN_CLASS)){
printf("Class source code generator for Ruby language is not supported..\n");
      }else{
        WSCstring* output = WSGFcreateWindowSrcMwtRb(win);
        if (output == NULL){
          return WS_ERR;
        }
        WSCstring file_name(dname,encode);
        if (strcmp(dname,"")){
          file_name << "/" << win->getInstanceName() << ".rb";
        }else{
          file_name << win->getInstanceName() << ".rb";
        }

        WSMFchmod((char*)file_name,0666);
        long ret = WSGFreplaceTextFile((char*)file_name, output->getString(encoding),False);
        WSMFchmod((char*)file_name,0444);

        if (ret == WS_ERR){
          delete output;
          return WS_ERR;
        }
        delete output;
        return WS_NO_ERR;
      }
      return WS_ERR;
    }else
    if (!strcmp(lang.getCharPtr(),WSN_LANG_PYTHON)){
      if (win->getUserData(WS_WIN_CLASS)){
printf("Class source code generator for Python language is not supported..\n");
      }else{

        WSCstring* output = WSGFcreateWindowSrcMwtPy(win);
        if (output == NULL){
          return WS_ERR;
        }
        WSCstring file_name(dname,encode);
        if (strcmp(dname,"")){
          file_name << "/" << win->getInstanceName() << ".py";
        }else{
          file_name << win->getInstanceName() << ".py";
        }

        WSMFchmod((char*)file_name,0666);
        long ret = WSGFreplaceTextFile((char*)file_name, output->getString(encoding),False);
        WSMFchmod((char*)file_name,0444);

        if (ret == WS_ERR){
          delete output;
          return WS_ERR;
        }
        delete output;
        return WS_NO_ERR;
      }
      return WS_ERR;
    }else
    if (!strcmp(lang.getCharPtr(),WSN_LANG_PERL)){
      if (win->getUserData(WS_WIN_CLASS)){
printf("Class source code generator for Perl language is not supported..\n");
      }else{

        WSCstring* output = WSGFcreateWindowSrcMwtPerl(win);
        if (output == NULL){
          return WS_ERR;
        }
        WSCstring file_name(dname,encode);
        if (strcmp(dname,"")){
          file_name << "/" << win->getInstanceName() << ".pl";
        }else{
          file_name << win->getInstanceName() << ".pl";
        }

        WSMFchmod((char*)file_name,0666);
        long ret = WSGFreplaceTextFile((char*)file_name, output->getString(encoding),False);
        WSMFchmod((char*)file_name,0444);

        if (ret == WS_ERR){
          delete output;
          return WS_ERR;
        }
        delete output;
        return WS_NO_ERR;
      }
      return WS_ERR;
    }else
    if (!strcmp(lang.getCharPtr(),WSN_LANG_OCAML)){
      if (win->getUserData(WS_WIN_CLASS)){
printf("Class source code generator for Objective-Caml language is not supported..\n");
      }else{

        WSCstring* output = WSGFcreateWindowSrcMwtOcaml(win);
        if (output == NULL){
          return WS_ERR;
        }
        WSCstring file_name(dname,encode);
        if (strcmp(dname,"")){
          file_name << "/" << win->getInstanceName() << ".ml";
        }else{
          file_name << win->getInstanceName() << ".ml";
        }

        WSMFchmod((char*)file_name,0666);
        long ret = WSGFreplaceTextFile((char*)file_name, output->getString(encoding),False);
        WSMFchmod((char*)file_name,0444);

        if (ret == WS_ERR){
          delete output;
          return WS_ERR;
        }
        delete output;
        return WS_NO_ERR;
      }
      return WS_ERR;
 printf("WSGFcreateWindowSrcFile Ocaml language not supported..\n");
      return WS_ERR;
    }
  }
  return WS_NO_ERR;
}


#if 0
void _ve_drop_proc(WSCbase* b1,WSCbase* b2){
  short x,y;
  WSGIappMouse()->getMousePosition(&x,&y,b1);
  WSCbase* btarget=b1;
  while(1){
    if (btarget->getParent() != NULL){
      btarget = btarget->getParent();
    }else{
      break;
    }
  }

  WSCbase* newobj = WSCbase::getNewInstance(b2->getProperty(WSNuserString),b1,
         WSGFcreateName(btarget->getInstanceName(),b2->getProperty(WSNuserString)));
  if (newobj != NULL){
    newobj->initialize();
    newobj->setPropertyEditMode(True);
    newobj->setVisible(False);

    //֥ȤФƲΤǤФΥϥɥ¹...
    WSGFexecCreateHandler(newobj);
    //֥Ȥ˲ΤǤФΥϥɥϿ...
    void* delete_handler = (void*)WSGFgetDeleteHandler();
    if (delete_handler != NULL){
         WSCprocedure* ac = new WSCprocedure("delete-handler",WSEV_DELETE);
         ac->setFunction((void(*)(WSCbase*))delete_handler,"delete_handler");
         ac->setInternal(True);
         newobj->addProcedure(ac);
    }

    if (newobj->existProperty(WSNx) != False){
      WSCproperty* prop = newobj->getPropObj(WSNx);
      if (prop->getBuilderVisible() != False){
        newobj->setPropertyV(WSNx,x);
      }
    }
    if (newobj->existProperty(WSNy) != False){
      WSCproperty* prop = newobj->getPropObj(WSNy);
      if (prop->getBuilderVisible() != False){
        newobj->setPropertyV(WSNy,y);
      }
    }
#if 0
extern WSCprojectEditor* pe;
    long dw1 = atoi(pe->getProjectData("#DWIDTH"));
    long dh1 = atoi(pe->getProjectData("#DHEIGHT"));
    long dt1 = atoi(pe->getProjectData("#DTHICKNESS"));
    WSCushort dw = (WSCushort)dw1;
    WSCushort dh = (WSCushort)dh1;
    WSCushort dt = (WSCushort)dt1;
    if (dw <5){
      dw = 5;
    }
    if (dh <5){
      dh = 5;
    }

    if ( dw != 0){
      if (newobj->existProperty(WSNwidth) != False){
        WSCproperty* prop = newobj->getPropObj(WSNwidth);
        if (prop->getBuilderVisible() != False){
          newobj->setPropertyV(WSNwidth,dw);
        }
      }
    }
    if ( dh != 0){
      if (newobj->existProperty(WSNheight) != False){
        WSCproperty* prop = newobj->getPropObj(WSNheight);
        if (prop->getBuilderVisible() != False){
          newobj->setPropertyV(WSNheight,dh);
        }
      }
    }
    if (newobj->existProperty(WSNshadowThickness) != False){
      WSCproperty* prop = newobj->getPropObj(WSNshadowThickness);
      if (prop->getBuilderVisible() != False){
        newobj->setPropertyV(WSNshadowThickness,(WSCuchar)dt);
      }
    }
#endif
    if (newobj->existProperty(WSNtitleString) != False){
      WSCstring str;
      str << "title" << _ve_title_cnt;
      newobj->setProperty(WSNtitleString,str);
      _ve_title_cnt++;
    }
    newobj->setUserData(WS_EXT_VAR,(void*)1);

    newobj->setVisible(True);
    newobj->setPropertyEditExecute(True);
//update
    WSGIappObjectList()->execEventProc(WS_VE_INSTANCE_UPDATED);
  }else{
WSMFtrace("WSGFdropProc create error! #%s#\n",(char*)b2->getProperty(WSNuserString));
  }
}
void _ve_register_drop_site(WSCbase* obj){
  if (obj->getObjectType() & WS_TYPE_MANAGER){
    WSGIappDragDrop()->registerDropSite(obj,"OBJECT-CREATE",_ve_drop_proc);
    WSClistData children = obj->getChildren();
    long num = children.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)children.getData(i);
      if (child->getInternalObject() == False){
        _ve_register_drop_site(child);
      }
    }
  }
}
void _ve_unregister_drop_site(WSCbase* obj){
//printf("_unregister_drop_site here!\n");
  if (obj == NULL){
    return;
  }
//  if (obj->getObjectType() & WS_TYPE_MANAGER){
//printf("_unregister_drop_site %s\n",obj->getInstanceName());
    WSGIappDragDrop()->unregisterDropSite(obj);
//  }
  WSClistData children = obj->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children.getData(i);
    if (child->getInternalObject() == False){
      _ve_unregister_drop_site(child);
    }
  }
}
#endif

WSCpopupMenu* _ve_popup_menu = NULL;
WSCpopupMenu* _ve_popup_menu2 = NULL;
void _ve_copy_work(WSCbase*){
  WSGIappObjectList()->execEventProc(WS_VE_INSTANCE_COPIED);
}
void _ve_paste_work(WSCbase*){
  WSGIappObjectList()->execEventProc(WS_VE_INSTANCE_PASTED);
}
void _ve_prop_work(WSCbase*){
  WSGIappObjectList()->execEventProc(WS_VE_PROPERTY_VIEWER_UPDATED);
}
void _ve_proc_work(WSCbase*){
  WSGIappObjectList()->execEventProc(WS_VE_PROCEDURE_VIEWER_UPDATED);
}
void _ve_attr_work(WSCbase*){
  WSGIappObjectList()->execEventProc(WS_VE_ATTR_VIEWER_UPDATED);
}
void _ve_front_work(WSCbase*){
  WSGIappObjectList()->execEventProc(WS_VE_INSTANCE_TO_FRONT);
}
void _ve_back_work(WSCbase*){
  WSGIappObjectList()->execEventProc(WS_VE_INSTANCE_TO_BACK);
}
void _ve_del_work(WSCbase*){
  WSGIappObjectList()->execEventProc(WS_VE_INSTANCE_DELETE);
}
void _ve_property_editor_handler(WSCbase* target,long val){
  if (target->getInternalObject() != False){
    return;
  }

  if (val == WS_PE_PROPERTY_CHANGED){
    WSGIappObjectList()->execEventProc(WS_VE_PROP_INSTANCE_PROP_UPDATED);
  }else
  if (val == WS_PE_INSTANCE_ACTIVATED){
    WSCulong status = WSGIappMouse()->getMouseStatus();
 
    if (status & WS_MOUSE_SHIFT){
      WSGIappObjectList()->setInstanceId(WS_SET_SELECTED_INSTANCE,
                                             (WSCulong)target);
    }else{
      WSCulong id = WS_ROOT_INSTANCE_ID;
      while(1){
        WSCulong item = WSGIappObjectList()->getInstanceId(id,
                                               WS_NEXT_SELECTED_INSTANCE_ID,0);
        if (item == 0){
          break;
        }
        WSGIappObjectList()->setInstanceId(WS_REMOVE_SELECTED_INSTANCE,item);
        if (item != (WSCulong)target){
          WSCbase* item2 = (WSCbase*)item;
          item2->setPropertyEditExecute(False);
        }
      }
      WSGIappObjectList()->setInstanceId(WS_SET_SELECTED_INSTANCE,
                                            (WSCulong)target);
      WSGIappObjectList()->execEventProc(WS_VE_PROP_INSTANCE_SELECTED);
    }
  }else
  if (val == WS_PE_INSTANCE_NOT_ACTIVATED){
    WSCulong id = WS_ROOT_INSTANCE_ID;
    while(1){
      WSCulong item = WSGIappObjectList()->getInstanceId(id,
                                             WS_NEXT_SELECTED_INSTANCE_ID,0);
      if (item == (WSCulong)target){
        WSGIappObjectList()->setInstanceId(WS_REMOVE_SELECTED_INSTANCE,item);
        break;
      }
      if (item == 0){
        break;
      }
      id = item;
    }
    WSGIappObjectList()->execEventProc(WS_VE_PROP_INSTANCE_RELEASED);
  }
}

void WSGFsetDefaultVePopupMenus(){
  if (_ve_popup_menu == NULL){
    _ve_popup_menu = new WSCpopupMenu(NULL,"menu");
    _ve_popup_menu->initialize();
    _ve_popup_menu->setPropertyV(WSNmenuItemHeight,(WSCushort)20);
    _ve_popup_menu->setPropertyV(WSNmenuItems,WS_VE_PM_MENU1);
    _ve_popup_menu->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _ve_popup_menu->setEmboss(True);

    _ve_popup_menu->addProcedureV( "COPY",
                "_ve_copy_work", _ve_copy_work, WSEV_NONE);
    _ve_popup_menu->addProcedureV( "PASTE",
                "_ve_paste_work", _ve_paste_work, WSEV_NONE);
    _ve_popup_menu->addProcedureV( "PROP",
                "_ve_prop_work", _ve_prop_work, WSEV_NONE);
    _ve_popup_menu->addProcedureV( "OP",
                "_ve_proc_work", _ve_proc_work, WSEV_NONE);
    _ve_popup_menu->addProcedureV( "EXPROP",
                "_ve_attr_work", _ve_attr_work, WSEV_NONE);
    _ve_popup_menu->addProcedureV( "DEL",
                "_ve_del_work", _ve_del_work, WSEV_NONE);

  }
  if (_ve_popup_menu2 == NULL){
    _ve_popup_menu2 = new WSCpopupMenu(NULL,"menu");
    _ve_popup_menu2->initialize();
    _ve_popup_menu2->setPropertyV(WSNmenuItemHeight,(WSCushort)20);
    _ve_popup_menu2->setPropertyV(WSNmenuItems,WS_VE_PM_MENU1);
    _ve_popup_menu2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _ve_popup_menu2->setEmboss(True);

    _ve_popup_menu2->addProcedureV( "COPY",
                "_ve_copy_work", _ve_copy_work, WSEV_NONE);
    _ve_popup_menu2->addProcedureV( "PASTE",
                "_ve_paste_work", _ve_paste_work, WSEV_NONE);
    _ve_popup_menu2->addProcedureV( "PROP",
                "_ve_prop_work", _ve_prop_work, WSEV_NONE);
    _ve_popup_menu2->addProcedureV( "OP",
                "_ve_proc_work", _ve_proc_work, WSEV_NONE);
    _ve_popup_menu2->addProcedureV( "EXPROP",
                "_ve_attr_work", _ve_attr_work, WSEV_NONE);
    _ve_popup_menu2->addProcedureV( "FRONT",
                "_ve_front_work", _ve_front_work, WSEV_NONE);
    _ve_popup_menu2->addProcedureV( "BACK",
                "_ve_back_work", _ve_back_work, WSEV_NONE);
    _ve_popup_menu2->addProcedureV( "DEL",
               "_ve_del_work", _ve_del_work, WSEV_NONE);

  }
}
void WSGFsetVePopupMenus(WSCpopupMenu* menu1,WSCpopupMenu* menu2){
  _ve_popup_menu = menu1;
  _ve_popup_menu2 = menu2;
}
void _ve_unregister_popup_menu(WSCbase* client){
  if (client->getObjectType() & WS_TYPE_WINDOW){
    if (_ve_popup_menu == NULL){
      return;
    }
    _ve_popup_menu->unregisterClient(client);
  }else{
    if (_ve_popup_menu2 == NULL){
      return;
    }
    _ve_popup_menu2->unregisterClient(client);
  }
}
void _ve_register_popup_menu(WSCbase* client){
  if (client->getObjectType() & WS_TYPE_WINDOW){
    if (_ve_popup_menu == NULL){
      return;
    }
    _ve_popup_menu->registerClient(client,True);
  }else{
    if (_ve_popup_menu2 == NULL){
      return;
    }
    _ve_popup_menu2->registerClient(client,True);
  }
}
void ve_delete_instance(WSCbase* target){
//printf("ve_delete_instance internal destroy handler executed.. obj=0x%x\n",target);fflush(stdout);
//printf("ve_delete_instance internal destroy handler executed.. obj=%s\n",target->getInstanceName());fflush(stdout);
  _ve_unregister_popup_menu(target);
  WSGIappObjectList()->setInstanceId(WS_REMOVE_ROOT_INSTANCE,(WSCulong)target);
  WSGIappObjectList()->setInstanceId(WS_REMOVE_SELECTED_INSTANCE,(WSCulong)target);
//printf("ve_delete_instance internal destroy handler done.. %s\n",target->getInstanceName());fflush(stdout);
#ifndef NO_MWT_FUNCTION
#ifndef NO_INDEX_VARIANT_DATA
  WSGIappUndoManager()->clear();
#endif
#endif
}
void WSGFsetupInstance(WSCbase* target){
  WSGFexecCreateHandler(target);
//printf("WSGFsetupInstance target=%s\n",target->getInstanceName());
  void* delete_handler = (void*)WSGFgetDeleteHandler();
  if (delete_handler != NULL){
    WSCprocedure* ac = new WSCprocedure("delete-handler",WSEV_DELETE);
    ac->setFunction((void(*)(WSCbase*))delete_handler,"delete_handler");
    ac->setInternal(True);
    target->addProcedure(ac);
  } 

  target->setPropertyEditMode(True);
  // In order to it makes this target visible on SWT thread,
  // because of the SWT single threading.
  if ((target->getObjectType() & WS_TYPE_WINDOW ) == 0){
    // for no window insntance.
    target->setVisible(True);
  }else{
    //for execute async process in order to make a new window visible
    //on the SWT thread.
    WSGIappObjectList()->setInstanceId(WS_TARGET_INSTANCE_ID,(long)target);
    WSGIappObjectList()->execEventProc(WS_VE_INTERNAL_WINDOW_CREATED);
  }
  target->setPropertyEditExecute(True);

  WSCulong id = WS_ROOT_INSTANCE_ID;
  while(1){
    WSCulong item = WSGIappObjectList()->getInstanceId(id,
                                           WS_NEXT_SELECTED_INSTANCE_ID,0);
    if (item == 0){
      break;
    }
    WSGIappObjectList()->setInstanceId(WS_REMOVE_SELECTED_INSTANCE,item);
    if (item != (WSCulong)target){
      WSCbase* item2 = (WSCbase*)item;
      item2->setPropertyEditExecute(False);
    }
  }

  WSGIappObjectList()->execEventProc(WS_VE_INSTANCE_UPDATED);
  WSGIappObjectList()->setInstanceId(WS_SET_SELECTED_INSTANCE,(WSCulong)target);
  WSGIappObjectList()->execEventProc(WS_VE_PROP_INSTANCE_SELECTED);
}

void _ve_click_handler(WSCbase*){
  WSGIappObjectList()->execEventProc(WS_VE_INSTANCE_CLICKED);
}

WSCbase* _ve_create_instance(WSCbase* parent,WSCindexVariantData* val){
  WSCvariant v = val->getData("class");
  WSCvariant n = WSGFcreateName("new",v.getCharPtr());
  WSCbase* target = WSCbase::getNewInstance(v.getCharPtr(),parent,n.getCharPtr());
//printf("_ve_create_instance %s %s 0x%x\n",v.getCharPtr(),n.getCharPtr(),target);
  if (target == NULL){
    return NULL;
  }
  target->initialize();
  int num = val->getNum();
  int i;
  for(i=0; i<num; i++){
    char* prop = val->getIndex(i);
    if (strcmp(prop,"class") && strcmp(prop,"name")){
      WSCvariant v = val->getData(i);
//printf("_ve_create_instance setprop.. %s %s\n",prop,v.getCharPtr());
      target->setProperty(prop,v);
    }
  }
  WSGFsetupInstance(target);


  target->setUserData(WS_EXT_VAR,(void*)1);
  return target;
}

void _ve_setup_instance(WSCbase* target){
//  _ve_register_drop_site(target);
  _ve_register_popup_menu(target);
#ifndef NO_MWT_FUNCTION
#ifndef NO_INDEX_VARIANT_DATA
  WSGIappUndoManager()->clear();
 if (target->cast("WSCnwbase") == NULL){
    WSCprocedure* ac = new WSCprocedure("_ve_clock_handler",WSEV_MOUSE_PRESS);
    ac->setFunction((void(*)(WSCbase*))_ve_click_handler,"_ve_clock_handler");
    ac->setInternal(True);
    target->addProcedure(ac);
  }
#endif
#endif

}
void _ve_internal_window_create_handler(WSCbase* obj){
//printf("_ve_internal_window_create_handler started..\n");fflush(stdout);
  if ( obj->getPropertyEditMode() != False &&
      (obj->getObjectType() & WS_TYPE_MENU_WINDOW) == 0 ){
    WSGIappObjectList()->setInstanceId(WS_TARGET_INSTANCE_ID,(long)obj);
    WSGIappObjectList()->execEventProc(WS_VE_INTERNAL_WINDOW_CREATED);
  }
//printf("_ve_internal_window_create_handler done..\n");fflush(stdout);
}
void _ve_internal_window_vis_handler(WSCbase* obj){
//printf("_ve_internal_window_vis_handler started..\n");fflush(stdout);
  if ( obj->getPropertyEditMode() != False &&
      (obj->getObjectType() & WS_TYPE_MENU_WINDOW) == 0 ){
    WSGIappObjectList()->setInstanceId(WS_TARGET_INSTANCE_ID,(long)obj);
    WSGIappObjectList()->execEventProc(WS_VE_INTERNAL_WINDOW_VISIBLE);
  }
//printf("_ve_internal_window_vis_handler done..\n");fflush(stdout);
}
void _ve_internal_window_unvis_handler(WSCbase* obj){
  if (obj->getPropertyEditMode() != False &&
      (obj->getObjectType() & WS_TYPE_MENU_WINDOW) == 0 ){
    WSGIappObjectList()->setInstanceId(WS_TARGET_INSTANCE_ID,(long)obj);
    WSGIappObjectList()->execEventProc(WS_VE_INTERNAL_WINDOW_UNVISIBLE);
    WSDdev* dev = obj->getowndev();
    if (dev != NULL){
      WSDwindowDev* wdev = (WSDwindowDev*)dev->cast("WSDwindowDev");
      if (wdev != NULL){
        wdev->destroyWindow();
        wdev->onUnmap();
      }
    }
  }
}
void _ve_internal_window_destroy_handler(WSCbase* obj){
//printf("_ve_internal_window_destroy_handler..1 obj=0x%x\n",obj);fflush(stdout);
//printf("_ve_internal_window_destroy_handler..1 obj=%s\n",obj->getInstanceName());fflush(stdout);
  if ((obj->getObjectType() & WS_TYPE_MENU_WINDOW) == 0 &&
      obj->getPropertyEditMode() != False ){
    WSGIappObjectList()->setInstanceId(WS_TARGET_INSTANCE_ID,(long)obj);
    WSGIappObjectList()->execEventProc(WS_VE_INTERNAL_WINDOW_DESTROYED);
  }
//printf("_ve_internal_window_destroy_handler..2 obj=%s\n",obj->getInstanceName());fflush(stdout);
}



long _check_name_strings(char* cname,WSCbase* base,WSCbase* client,char* aname){
   WSCbase* basep = NULL;
   WSCbase* bp = base->getParentWindow();
   if (client != NULL){
     basep = client->getParentWindow();
   }

   long arrayno;
   char arrayname[1024];
   WSCbool array = WSGFcheckArrayName(base->getInstanceName(),&arrayno,arrayname);
   if (array == False && !strcmp(base->getInstanceName(),cname)){
     if ( (long)base->getUserData(WS_EXT_VAR) != 0 ){
       return WS_OBJECT_NAME;
     }else if ( basep == bp ){
       return WS_OBJECT_NAME;
     }
   }

   if (array != False && !strcmp(arrayname,cname)){
     if (bp == basep && client == NULL ){
       return WS_OBJECT_ARRAY_NAME;
     }else if (bp == basep && client != NULL &&
               !strcmp(client->getClassName(),base->getClassName())){
       return WS_OBJECT_ARRAY_NAME;
     }else{
       return WS_OBJECT_ARRAY_NAME_INVALID;
     }
   }
   if (aname != NULL){
     if (array == False && !strcmp(base->getInstanceName(),aname)){
       if ( (long)base->getUserData(WS_EXT_VAR) != 0 ){
         return WS_OBJECT_NAME;
       }else if ( basep == bp ){
         return WS_OBJECT_NAME;
       }
     }
     if (array != False && !strcmp(arrayname,aname)){
       if (bp == basep && client == NULL ){
         return WS_OBJECT_ARRAY_NAME;
       }else if (bp == basep && client != NULL &&
               !strcmp(client->getClassName(),base->getClassName())){
         return WS_OBJECT_ARRAY_NAME;
       }else{
         return WS_OBJECT_ARRAY_NAME_INVALID;
       }
     }
   }

   WSClistData* prlist = base->getProcedureList();
   long i;
   long num = prlist->getNum();
   WSCprocedure** ac_buf = (WSCprocedure**)prlist->_data;
   for(i=0; i<num; i++){
     WSCprocedure* ac = ac_buf[i];
     if(!strcmp(ac->getFunctionName(),cname)){
       return WS_PROCEDURE_NAME;
     }
   }
   WSClistData children = base->getChildren();
   num = children.getNum();
   WSCbase** child_buf = (WSCbase**)children._data;
   for(i=0; i<num; i++){
     WSCbase* child = child_buf[i];
     if (child->getInternalObject() == False){
       long ret = _check_name_strings(cname,child,client,aname);
       if (ret != 0){
         return ret;
       }
     }
   }
   return 0;
}
WSCbase* _search_instance(char* name,WSCbase* item){
  if (item->getInternalObject() != False){
    return NULL;
  }
  if (!strcmp(name,item->getInstanceName())){
    return item;
  }
  WSClistData children = item->getChildren();
  long num = children.getNum();
  long i;
  WSCbase** child_buf = (WSCbase**)children._data;
  for(i=0; i<num; i++){
//    WSCbase* child = (WSCbase*)children[i];
    WSCbase* child = child_buf[i];
    WSCbase* target = _search_instance(name,child);
    if (target != NULL){
      return target;
    }
  } 
  return NULL;
}
WSCbase* ve_search_instance(char* name){
  WSCulong win_id = WS_ROOT_INSTANCE_ID;
  while(1){
    WSCulong win_next = WSGIappObjectList()->getInstanceId(WS_ROOT_INSTANCE_ID,
                                               WS_NEXT_CHILD_INSTANCE_ID,win_id);
    if (win_next == 0){
      break;
    }

    WSCbase* win = (WSCbase*)win_next;
    WSCbase* target = _search_instance(name,win);
    if (target != NULL){
      return target;
    }
    win_id = win_next;
  }
  return NULL;
}

long ve_check_name_strings(char* cname,WSCbase* client){
  if (!strcmp("main",cname)){
    return WS_OTHER_NAME;
  }
  if (!strcmp("WinMain",cname)){
    return WS_OTHER_NAME;
  }

  WSCbase* pic = NULL;
  if (client != NULL){
    pic = client->getParentWindow();
  }

  WSCbase* sinst = ve_search_instance(cname);
  if (sinst != NULL){
    if (client == NULL){
      return WS_OBJECT_NAME;
    }else if (sinst == client){
      return 0;
    }else{
      return WS_OBJECT_NAME;
    }
  }

  long arrayno;
  char arrayname[1024];
  WSCbool array = WSGFcheckArrayName(cname,&arrayno,arrayname);
  if (array != False){
    WSCbase* sinst = ve_search_instance(arrayname);
    if (sinst != NULL){
      return WS_OBJECT_NAME;
    }
    WSCfunction* func = WSGIappFunctionList()->getFunction(arrayname);
    if (func != NULL){
      return WS_PROCEDURE_NAME;
    }
    return WS_OBJECT_ARRAY_NAME;
  }else{
    WSCfunction* func = WSGIappFunctionList()->getFunction(cname);
    if (func != NULL){
      return WS_PROCEDURE_NAME;
    }
  }
  WSCulong win_id = WS_ROOT_INSTANCE_ID;
  while(1){
    WSCulong win_next = WSGIappObjectList()->getInstanceId(WS_ROOT_INSTANCE_ID,
                                               WS_NEXT_CHILD_INSTANCE_ID,win_id);
    if (win_next == 0){
      break;
    }

    WSCbase* win = (WSCbase*)win_next;
    long ret;
    if (array != False){
      ret = _check_name_strings(cname,win,client,arrayname);
    }else{
      ret = _check_name_strings(cname,win,client,NULL);
    }
    if (ret != 0){
      return ret;
    }
    win_id = win_next;
  }
  return 0;
}
long WSGFpasteInstance(WSCbase* target,WSCbase* src){
  if (!(target->getObjectType() & WS_TYPE_MANAGER)){
    return WS_ERR_NOT_MANAGER;
  }
  WSCbool overwrap = False;
  if (target == src){
    overwrap = True;
  }else{
    WSCbase* ptarget = target;
    while(1){
      if (ptarget == NULL){
        break;
      }
      if (ptarget == src){
        overwrap = True;
        break;
      }
      ptarget = ptarget->getParent();
    }
  }
  if (overwrap == True){
    return WS_ERR_OVERWRAPED;
  }
  WSCbase* cpobj = copy_recursive(src,target);
  if (cpobj != NULL){
    short x = cpobj->getProperty(WSNx);
    x += 10;
    short y = cpobj->getProperty(WSNy);
    y += 10;
    cpobj->setProperty(WSNx,x);
    cpobj->setProperty(WSNy,y);

    WSCulong id = WS_ROOT_INSTANCE_ID;
    while(1){
      WSCulong item = WSGIappObjectList()->getInstanceId(id,
                                               WS_NEXT_SELECTED_INSTANCE_ID,0);
      if (item == 0){
        break;
      }
      WSGIappObjectList()->setInstanceId(WS_REMOVE_SELECTED_INSTANCE,item);
      if (item != (WSCulong)cpobj){
        WSCbase* item2 = (WSCbase*)item;
        item2->setPropertyEditExecute(False);
      }
    }
    WSGIappObjectList()->setInstanceId(WS_SET_SELECTED_INSTANCE,
                                            (WSCulong)cpobj);
  }
  return WS_NO_ERR;
}
WSCbool _setup_handler_for_eclipse = False;
WSCbase* copy_recursive(WSCbase* item,WSCbase* target){
  WSCbase* newobj = WSCbase::getNewInstance(item->getClassName(),target,
         WSGFcreateName(target->getParentWindow()->getInstanceName(),
                        item->getClassName()));
  if (newobj != NULL){
    newobj->initialize();
    newobj->setVisible(False);

//printf("copy_recursive target=%s WSGFexecCreateHandler\n",newobj->getInstanceName());
    if (_setup_handler_for_eclipse == False){
      WSGFexecCreateHandler(newobj);
    }else{
      WSGFsetupInstance(newobj);
    }
//printf("copy_recursive target=%s WSGFexecCreateHandler done.\n",newobj->getInstanceName());
    void* delete_handler = (void*)WSGFgetDeleteHandler();
    if (delete_handler != NULL){
      WSCprocedure* ac = new WSCprocedure("delete-handler",WSEV_DELETE);
      ac->setFunction((void(*)(WSCbase*))delete_handler,"delete_handler");
      ac->setInternal(True);
      newobj->addProcedure(ac);
    }

    WSClistData* oplist = item->getProcedureList();
    long i;
    long num = oplist->getNum();
    for(i=0; i<num; i++){
      WSCprocedure* ac = (WSCprocedure*)(*oplist)[i];
      if (ac->getInternal() != False){
        continue;
      }
      WSCprocedure* newac = new WSCprocedure(ac->getProcName(),
                                                    ac->getTrigger());

      newac->setFunction((void(*)(WSCbase*))ac->getProc(),ac->getFunctionName());
      newac->setUseFile(ac->getUseFile());
      newac->setInternal(ac->getInternal());
      newobj->addProcedure(newac);
    }
    WSClistData* property_list = item->getClassInformation()->getAllPropertyList();
    if (property_list == NULL){
      return newobj;
    }
    num = property_list->getNum();
    for(i=0; i<num; i++){
      WSCproperty* prop = (WSCproperty*)(*property_list)[i];
      if (!strcmp(prop->getPropObjName(),WSNname)){
        continue;
      }
      newobj->setProperty(prop->getPropObjName(),
        item->getProperty(prop->getPropObjName()));
    }

    newobj->setPropertyEditMode(True);
    newobj->setUserData(WS_EXT_VAR,item->getUserData(WS_EXT_VAR));
  }

  WSClistData children = item->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child->getInternalObject() != False){
      continue;
    }
    copy_recursive(child,newobj);
  }
  return newobj;
}
static WSCclassPropEditor* _cpe = NULL;
void _ve_class_prop_editor_exec(void*){
  if (_cpe == NULL){
    _cpe = new WSCclassPropEditor(NULL,"ve-class-prop-editor");
    _cpe->initialize();
    _cpe->setProperty(WSNdefaultPosition,True);
  }
  WSCbase* target = (WSCbase*)WSGIappObjectList()->getInstanceId(0,WS_TARGET_INSTANCE_ID,0);
  _cpe->setProperty(WSNclient,target);
  _cpe->setVisible(True);
}
static WSCtriggerEditor* _cte = NULL;
void _ve_class_trg_editor_exec(void*){
  if (_cte == NULL){
    _cte = new WSCtriggerEditor(NULL,"ve-class-trg-editor");
    _cte->initialize();
    _cte->setProperty(WSNdefaultPosition,True);
  }
  WSCbase* target = (WSCbase*)WSGIappObjectList()->getInstanceId(0,WS_TARGET_INSTANCE_ID,0);
  _cte->setProperty(WSNclient,target);
  _cte->setVisible(True);

}
static WSCclassUTrgEditor* _cute = NULL;
void _ve_class_utrg_editor_exec(void*){
  if (_cute == NULL){
    _cute = new WSCclassUTrgEditor(NULL,"ve-class-utrg-editor");
    _cute->initialize();
    _cute->setProperty(WSNdefaultPosition,True);
  }
  WSCbase* target = (WSCbase*)WSGIappObjectList()->getInstanceId(0,WS_TARGET_INSTANCE_ID,0);
  _cute->setProperty(WSNclient,target);
  _cute->setVisible(True);
}
static WSCclassRMethodEditor* _crme = NULL;
void _ve_class_remote_method_editor_exec(void*){
  if (_crme == NULL){
    _crme = new WSCclassRMethodEditor(NULL,"ve-class-rme-editor");
    _crme->initialize();
    _crme->setProperty(WSNdefaultPosition,True);
  }
  WSCbase* target = (WSCbase*)WSGIappObjectList()->getInstanceId(0,WS_TARGET_INSTANCE_ID,0);
  _crme->setProperty(WSNclient,target);
  _crme->setVisible(True);
}
//static WSCcolorSelect* _csl = NULL;
void _ve_color_selected(WSCbase*){
  if (WSGIappColorSelect()->getStatus() == WS_DIALOG_OK){
    WSGIappObjectList()->setUserStringData("selected-color1",
                           WSGIappColorSelect()->getSelectColor());
    WSGIappObjectList()->setUserStringData("selected-color2",
                           WSGIappColorSelect()->getSelectTopShadowColor());
    WSGIappObjectList()->setUserStringData("selected-color3",
                           WSGIappColorSelect()->getSelectBottomShadowColor());
    WSGIappObjectList()->execEventProc("ve-color-selected");
  }
}
void _ve_color_selector_exec(void*){

  WSGIappColorSelect()->setProperty(WSNdefaultPosition,True);
  WSGIappColorSelect()->setVisible(True);
  WSGIappColorSelect()->setMapStatus(WS_TOP);

}

void _ve_exec_undo(void*){
#ifndef NO_MWT_FUNCTION
#ifndef NO_INDEX_VARIANT_DATA
  WSGIappUndoManager()->execUndoProc();
#endif
#endif
}
void _ve_set_property_undo(void*){
#ifndef NO_MWT_FUNCTION
#ifndef NO_INDEX_VARIANT_DATA
  WSCbase* inst = (WSCbase*)WSGIappObjectList()->getInstanceId(0,WS_TARGET_INSTANCE_ID,0);
  if (WSGIappObjectList()->existInstance(inst) != False){
    WSCpropUndoProc* undo = new WSCpropUndoProc();
    undo->setTarget(inst);
    WSGIappUndoManager()->addUndoProc(undo);
  }
#endif
#endif
}

void WSGFsetDefaultVePropertyEditProcedures(){
  _setup_handler_for_eclipse = True;
  WSGFenablePropertyBuilderTitle();
  WSGFsetPropertyEditorHandler(_ve_property_editor_handler);
  WSGFsetCreateInstanceHandler(_ve_create_instance);
  WSGFsetCreateHandler(_ve_setup_instance);
  WSGIappObjectList()->
    setInternalWindowCreateHandler(_ve_internal_window_create_handler);
  WSGIappObjectList()->
    setInternalWindowVisibleHandler(_ve_internal_window_vis_handler);
  WSGIappObjectList()->
    setInternalWindowUnvisibleHandler(_ve_internal_window_unvis_handler);
  WSGIappObjectList()->
    setInternalWindowDestroyHandler(_ve_internal_window_destroy_handler);
extern long ve_check_name_strings(char*,WSCbase*);
  WSGFsetExistNameHandler(ve_check_name_strings);
  WSGFsetDeleteHandler(ve_delete_instance);
  WSGIappObjectList()->addEventProc(_ve_class_prop_editor_exec,"ve-class-prop-editor-activated",NULL);
  WSGIappObjectList()->addEventProc(_ve_class_trg_editor_exec,"ve-class-trg-editor-activated",NULL);
  WSGIappObjectList()->addEventProc(_ve_class_utrg_editor_exec,"ve-class-utrg-editor-activated",NULL);
  WSGIappObjectList()->addEventProc(_ve_class_remote_method_editor_exec,"ve-class-remote-method-editor-activated",NULL);
  WSGIappObjectList()->addEventProc(_ve_color_selector_exec,"ve-color-selector-activated",NULL);
  WSGIappObjectList()->addEventProc(_ve_set_property_undo,WS_VE_SET_PROPERTY_UNDO,NULL);
  WSGIappObjectList()->addEventProc(_ve_exec_undo,WS_VE_EXEC_UNDO,NULL);
  WSGIappColorSelect()->addProcedureV("_ve_color_selected","_ve_color_selected",_ve_color_selected,WSEV_ACTIVATE);
}
