//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <stdio.h>
#include <WSCstring.h>
#include <WSCbase.h>
#include <WSCmessageDialog.h>
#include <advance/WSadcom.h>
#include <WSCclassInformation.h>
#include <WSCbaseList.h>
#include <WSCvariant.h>
#include <WSClocaleSet.h>
#include <WSCcolorSet.h>
#include <WSDfileSystem.h>
#include <WSDexternal.h>
#include <WSCundoManager.h>

WSClistData _dlls;
WSClistData _dll_symbols;

long _load_project(long project,char* path,long encoding){
//printf("_load_project=%s\n",path);fflush(stdout);
  WSCstring* src = WSGFreadTextFile(path,encoding);
  if (src == NULL){
    return 0;
  }
  WSCindexVariantData* prj = (WSCindexVariantData*)project;
  if (prj == NULL){
    prj = new WSCindexVariantData;
  }
  if (prj == NULL){
    fprintf(stderr,"%s:%d Can not allocate memory..\n",__FILE__,__LINE__);
    delete src;
    return 0;
  }
  while(src->eof() == False){
    WSCstring index = src->gets();
    WSCstring data = src->gets();
    index.delHeadSpace();
    index.delTailSpace();
    index.delLineFeed();
    data.delLineFeed();
    if (!strcmp(index.getString(),"")){
      continue;
    }
    if (!strcmp(index.getString(),"DEFAULT_VALUE")){
      continue;
    }
//printf("index=%s data=%s\n",(char*)index,(char*)data);fflush(stdout);
    prj->setData(index,data);

    if (!strcmp(index.getString(),"#WS_DLL")){
      long num = data.getWords(",");
      long i;
      for(i=0; i<num; i++){
        WSCstring dll = data.getWord(i,",");
        dll.delHeadSpace();
        dll.delTailSpace();
        dll.delLineFeed();
        if (strcmp(dll.getString(),"")){
          long dnum = _dlls.getNum();
          long j;
          WSCbool fl = False;
          for(j=0; j<dnum; j++){
            WSDexternal* ext = (WSDexternal*)_dlls.getData(j);
            if (!strcmp(ext->getName(),dll.getString())){
              fl = True;
              break;
            }
          }
          if (fl == False){
            WSDexternal* ext = WSDexternal::getNewInstance();
            long ret = ext->open(dll.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
            if (ret == WS_NO_ERR){
              WSCstring* sym = ext->getObjectSymbols();
              if (sym != NULL){
                _dll_symbols.add((void*)sym);
                _dlls.add((void*)ext);
              }else{
                delete ext;
              }
            }
          }
        }
      }
    }
  }
  delete src;
  return (long)prj;
}

static WSCindexVariantData _target_suffixes;
static WSCindexVariantData _target_env_name;
static WSCindexVariantData _target_name;

long WSGFloadTargets(char* path,long encoding){
  _target_suffixes.clear();
  _target_env_name.clear();
  _target_name.clear();

  WSCstring* src = WSGFreadTextFile(path,encoding);
  if (src == NULL){
    return WS_ERR;
  }
  while(src->eof() == False){
    WSCstring line = src->gets();
    line.delHeadSpace();
    line.delTailSpace();
    WSCstring index_str = line.getWord(0,",");
    WSCstring suffix_str = line.getWord(1,",");
    WSCstring env_name_str = line.getWord(2,",");
    WSCstring label_str = line.getWord(3,",");
    _target_suffixes.setData(index_str,suffix_str);
    _target_env_name.setData(index_str,env_name_str);
    _target_name.setData(index_str,label_str);
  }
  delete src;
  return WS_NO_ERR;
}

static WSCindexVariantData _lib_opts_name;
static WSCindexVariantData _lib_opts;
static WSCindexVariantData _stlib_opts;
static long _init_lib_opts = False;


static long _init_targets = False;
long _load_targets(){
  if (_init_targets == False){
    WSCstring fname = WSGFgetMgrStrData(WS_TARGET_DEF_FILE_NAME,0);
    return WSGFloadTargets(fname.getString(),WS_EN_DEFAULT);
  }
  return WS_NO_ERR;
}
long _clear_link_options(){
  _init_lib_opts = False;
  _lib_opts_name.clear();
  _lib_opts.clear();
  _stlib_opts.clear();
  return WS_NO_ERR;
}
long _load_link_options(WSCulong val){
  WSCindexVariantData* prj = (WSCindexVariantData*)val;
  long id = 0;
  if (prj != NULL){
    id = atoi((char*)WSGFgetProjectData((WSCulong)prj,"#COMPAT"));
  }
//printf("_load_link_options id=%d\n",id);fflush(stdout);
static long target_id = 0;
  if (target_id != id){
    _clear_link_options();
    target_id = id;
  }
//printf("_load_link_options _init_lib_opts=%d\n",_init_lib_opts);fflush(stdout);
  if (_init_lib_opts == False){
    WSCstring fname = WSGFgetMgrStrData(WS_LINK_OPT_DEF_FILE_NAME,val);
//printf("_load_link_options fname=%s\n",(char*)fname);fflush(stdout);
    WSCstring* str = WSGFreadTextFile(fname.getString(),
                          WSGIappLocaleSet()->getSystemLocaleEncoding());
    if (str == NULL){
      return WS_ERR;
    }
    _init_lib_opts = True;
    while(str->eof() == False){
      WSCstring ldata = str->gets();
      WSCstring ename = ldata.getWord(0,":");
      WSCstring eopt = ldata.getWord(1,":");
      WSCstring lopt = ldata.getWord(2,":");
      WSCstring lopt2 = ldata.getWord(3,":");
      _lib_opts_name[(char*)eopt] = (char*)ename;
      _lib_opts[(char*)eopt] = (char*)lopt;
      _stlib_opts[(char*)eopt] = (char*)lopt2;
    }
    delete str;
  }
  return WS_NO_ERR;
}


static long langs[] = {
WS_LANG_CPP,
WS_LANG_JAVA,
WS_LANG_PERL,
WS_LANG_PYTHON,
WS_LANG_RUBY,
WS_LANG_OCAML,
0
};
static long encodings[] = {
WS_EN_ISO8859(1),
WS_EN_ISO8859(2),
WS_EN_ISO8859(3),
WS_EN_ISO8859(4),
WS_EN_ISO8859(5),
WS_EN_ISO8859(6),
WS_EN_ISO8859(7),
WS_EN_ISO8859(8),
WS_EN_ISO8859(9),
WS_EN_ISO8859(10),
WS_EN_ISO8859(11),
WS_EN_ISO8859(12),
WS_EN_ISO8859(13),
WS_EN_ISO8859(14),
WS_EN_ISO8859(15),
WS_EN_EUCJP,
WS_EN_SJIS,
WS_EN_UTF8,
WS_EN_EUCKR,
WS_EN_EUCCN,
WS_EN_BIG5,
WS_EN_KOI8R,
WS_EN_CP1251,
0
};

long WSGFgetMgrData(long kind,WSCulong val){
  if (kind == WS_NEXT_TARGET_ID){
extern long _load_targets();
    _load_targets();
    if (val == 0){
      WSCvariant index = _target_suffixes.getIndex(0);
      return index.getLong()+1;
    }
    int i;
    long num = _target_suffixes.getNum();
    for(i=0; i<num-1; i++){
      WSCvariant index = _target_suffixes.getIndex(i);
      if (index.getLong()+1 == val){
        WSCvariant index2 = _target_suffixes.getIndex(i+1);
        return index2.getLong()+1; 
      }
    }
    return 0;
  }
  if (kind == WS_NEXT_LANG_ID){
    long cnt = 0;
    while(1){
      if (val == langs[cnt]){
        return langs[cnt+1];
      }
      cnt++;
      if (langs[cnt] == 0){
        return 0;
      }
    }
  }
  if (kind == WS_NEXT_ENCODING_ID){
    if (val== 0){
      return encodings[0];
    }
    long cnt = 0;
    while(1){
      if (val == encodings[cnt]){
        return encodings[cnt+1];
      }
      cnt++;
      if (encodings[cnt] == 0){
        return 0;
      }
    }
  }
  if (kind == WS_NEXT_LINK_OPT_ID){
    if (val == 0){
      return atoi(_lib_opts.getIndex(0))+1;
    }
    long num = _lib_opts.getNum();
    long i;
    for(i=0; i<num-1; i++){
      long no = atoi(_lib_opts.getIndex(i))+1;
      if (no == val){
        return atoi(_lib_opts.getIndex(i+1))+1;
      }
    }
    return 0;
  }
  if (kind == WS_UNDO_NUM){
    return WSGIappUndoManager()->getNum();
  }

  return 0;
}
long WSGFloadLinkOptions(WSCulong prj){
  return _load_link_options(prj);
}


WSCstring WSGFgetProjectData(WSCulong proj,char* index){
  WSCindexVariantData* prj = (WSCindexVariantData*)proj;
  if (prj == NULL){
    prj = new WSCindexVariantData;
  }
  WSCstring ret;
  if (prj == NULL){
    return ret;
  }
  ret = prj->getData(index);
#ifdef MSW
  //for executing make command of Eclipse cdt 
  if (!strcmp(index,"#MAKE")){
    long pos = ret.isExist("$(WSDIR)");
    if (pos == 0){
      char* wsdir = WSGIappFileSystem()->adjustFileName("$(WSDIR)");
      ret.replaceString("$(WSDIR)",wsdir,1);
    }
  }
#endif
  if (!strcmp(index,"#LIB_CREATE") ||
      !strcmp(index,"#COMPAT")){
    long tmp = atoi(ret.getString());
    tmp += 1;
    ret = tmp;
  }
  return ret;
}

WSCstring WSGFgetProjectDefaultData(WSCulong proj,char* index){
  WSCindexVariantData* prj = (WSCindexVariantData*)proj;
  if (prj == NULL){
    prj = new WSCindexVariantData;
  }
  WSCvariant dval = prj->getData("DEFAULT_VALUE");
  void* val = dval.getVoidPtr();
  WSCvariant tmp = prj->getData("DEFAULT_VALUE");
  
  WSCindexVariantData* prj2 = (WSCindexVariantData*)val;

  WSCstring ret;
  if (prj2 == NULL){
    return ret;
  }
  ret = prj2->getData(index);
  if (!strcmp(index,"#LIB_CREATE") ||
      !strcmp(index,"#COMPAT")){
    long tmp = atoi(ret.getString());
    tmp += 1;
    ret = tmp;
  }
  return ret;
}

static WSCindexVariantData _prj_env;
static WSCindexVariantData _target_env_title;
static WSCbool _prj_env_loaded = False;
static WSCstring _prj_env_def_file_name;
static WSCstring _target_env_def_file_name;

static void _load_project_environment_data(){
  _prj_env.clear();

  if (!strcmp((char*)_target_env_def_file_name,"")){
    _target_env_def_file_name.setString(WS_TARGET_ENV_DEF_FILE_NAME_S);
  }

  WSCstring fname2 = WSGIappFileSystem()->adjustFileName(
                                  _target_env_def_file_name.getString());
  WSCstring* cdata = WSGFreadTextFile(
               fname2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
  if (cdata != NULL){
    while(cdata->eof() == False){
      WSCstring line = cdata->gets();
      line.delHeadSpace();
      if (strcmp((char*)line,"")){
        WSCstring index = line.getWord(0,",");
        WSCstring value = line.getWord(1,",");
        _target_env_title.setData(index,value);
        _prj_env.setData(index,"");
      }
    }
    delete cdata;
  }

  if (!strcmp((char*)_prj_env_def_file_name,"")){
    _prj_env_def_file_name.setString(WS_ENV_DEF_FILE_NAME_S);
  }
  WSCstring fname = WSGIappFileSystem()->adjustFileName(
                                  _prj_env_def_file_name.getString());
  
  cdata = WSGFreadTextFile(
               fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));

//printf("_load_project_env.. fname=%s cdata=0x%x\n",(char*)fname,cdata);fflush(stdout);
  if (cdata != NULL){
    while(cdata->eof() == False){
      WSCstring index = cdata->gets();
      WSCstring value = cdata->gets();
      index.delHeadSpace();
      index.delTailSpace();
//printf("_load_project_env.. index=%s v=%s\n",(char*)index,(char*)value);fflush(stdout);
      if (strcmp((char*)index,"")){
        _prj_env.setData(index,value);
      }
    }
    delete cdata;
  }


  return;
}
WSCstring WSGFgetProjectEnvironmentData(char* index){
  if (_prj_env_loaded == False){
    _load_project_environment_data();
    _prj_env_loaded = True;
  }
  WSCstring ret;
  ret = _prj_env.getData(index);
  return ret;
}
long WSGFsetProjectEnvironmentData(char* index,char* val,long encoding){
  if (_prj_env_loaded == False){
    _load_project_environment_data();
  }
  WSCstring item(val,encoding);
  _prj_env.setData(index,item);
  return WS_NO_ERR;
}
long WSGFsaveProjectEnvironment(){
  if (!strcmp((char*)_prj_env_def_file_name,"")){
    _prj_env_def_file_name.setString(WS_ENV_DEF_FILE_NAME_S);
  }
  WSCstring fname = WSGIappFileSystem()->adjustFileName(
                                  _prj_env_def_file_name.getString());
  WSCstring output;
  long num = _prj_env.getNum();
  long i;
  for(i=0; i<num; i++){
    output << _prj_env.getIndex(i) << "\n";
    output << _prj_env.getData(i) << "\n";
  }
  return WSGFreplaceTextFile(fname,(char*)output,False);
}


char* compatible_no_save[] = {
"#MAKE",
"#CC1",
"#CC",
"#LD",
"#USER_INCLUDE",
"#USER_FL",
"#USER_RT_INCLUDE",
"#USER_RT_FL",
"#USER_DBG_INCLUDE",
"#USER_DBG_FL",
"#USER_LIB",
"#USER_LD_FL",
"#USER_RT_LIB",
"#USER_DBG_LIB",
"#USER_RT_STLIB",
"#USER_DBG_STLIB",
"#FONT0",
"#FONT1",
"#FONT2",
"#FONT3",
"#FONT4",
"#FONT5",
"#FONT6",
"#FONT7",
NULL
};

char* WSGFgetProjectLocaleName(){
  return WSGIappLocaleSet()->getSystemLocaleName();
}

long WSGFsetProjectData(WSCulong proj,char* index,char* val,long encoding){
  WSCindexVariantData* prj = (WSCindexVariantData*)proj;
//  if (prj == NULL){
//    prj = new WSCindexVariantData;
//  }
  if (prj == NULL){
    return WS_ERR;
  }
  WSCstring val2(val,encoding);
#ifdef MSW
  //for executing make command of Eclipse cdt 
  if (!strcmp(index,"#MAKE")){
    char* wsdir = WSGIappFileSystem()->adjustFileName("$(WSDIR)");
    long pos = val2.isExist(wsdir);
    if (pos == 0){
      val2.replaceString(wsdir,"$(WSDIR)",1);
    }
  }
#endif
  if (!strcmp(index,"#LIB_CREATE") ||
      !strcmp(index,"#COMPAT")){
    long tmp = atoi(val);
    tmp -= 1;
    val2 = tmp;
  }
  prj->setData(index,val2);
  if (!strcmp(index,"#COMPAT")){

    WSCstring target_suffix = WSGFgetMgrStrData(WS_TARGET_SUFFIX,WSGFatol(val));
    WSCstring default_pfname = WSGFgetMgrStrData(WS_DEFAULT_PROJECT_FILE_NAME,0);
    default_pfname << target_suffix;
    long dprj = WSGFloadProject(default_pfname.getString(),WS_EN_DEFAULT);
    WSCindexVariantData* default_prj = (WSCindexVariantData*)dprj;
    if (default_prj == NULL){
      return WS_ERR;
    }
    long cnt = 0;
    while(1){
      if (compatible_no_save[cnt] == NULL){
        break;
      }
      WSCvariant dval = default_prj->getData(compatible_no_save[cnt]);
      prj->setData(compatible_no_save[cnt],dval);
      cnt++;
    }

    WSCindexVariantData* tval =
          (WSCindexVariantData*)prj->getData("DEFAULT_VALUE").getVoidPtr();
    delete tval;
    WSCindexVariantData* val =
          (WSCindexVariantData*)default_prj->getData("DEFAULT_VALUE").getVoidPtr();
    WSCvariant dval((void*)val,"WSCindexVariantData");
    prj->setData("DEFAULT_VALUE",dval);
//XXZZ
    delete default_prj;
//    WSGFdestroyProject((WSCulong)default_prj);
  }
  return WS_NO_ERR;
}

static WSCstring _default_project_file_name;
static WSCstring _link_opt_def_file_name;
static WSCstring _target_def_file_name;

static WSCstring _lib_def_file_name;
static WSCstring _link_lib_def_file_name;
static WSCstring _class_def_file_name;

static WSCbool _init_lib_names = False;
static WSCindexData _lib_name;
static WSCindexData _stlib_name;
static WSCindexData _complete_lib_name;
static WSCindexData _class_lib_list;
void _clear_class_lib_names(){
  int i;
  int num = _class_lib_list.getNum();
  for(i=0; i<num; i++){
    char* item = (char*)_class_lib_list.getData(i);
    delete item;
  }
  _class_lib_list.clear();
}
void _load_class_lib_names(WSCulong proj){
  char* locale = WSGFgetProjectLocaleName();
  if (locale == NULL || !strcmp(locale,"") || !strcmp(locale,"C")){
    locale = "en_US";
  }
  WSCstring class_def_fname = WSGFgetMgrStrData(WS_LINK_CLASS_DEF_FILE_NAME,proj);
  WSCstring fname;
  char buffer[1024];
  int i=1;
  while(1){
    sprintf(buffer,(char*)class_def_fname,locale,i);
    WSCstring* cdata = WSGFreadTextFile(buffer);
    if (cdata == NULL){
      break;
    }
    cdata->gets();
    while(cdata->eof() == False){
      WSCstring line = cdata->gets();
      WSCstring cname = line.getWord(0);
      WSCstring libname = line.getWord(2);
      if (strcmp((char*)libname,"")){
        _class_lib_list.setData(cname,WSGFstrdup((char*)libname));
      }
      cdata->gets();
    }
    delete cdata;
    i++;
  }
}

void _clear_link_lib_names(){
  int i;
  int num = _lib_name.getNum();
  for(i=0; i<num; i++){
    char* item = (char*)_lib_name.getData(i);
    delete item;
    item = (char*)_stlib_name.getData(i);
    delete item;
    item = (char*)_complete_lib_name.getData(i);
    delete item;
  }
  _lib_name.clear();
  _stlib_name.clear();
  _complete_lib_name.clear();
}

void _load_link_lib_names(WSCulong prj){
  _clear_link_lib_names();
  WSCstring fname = WSGFgetMgrStrData(WS_LINK_LIB_DEF_FILE_NAME,prj);
  WSCstring* ldata = WSGFreadTextFile((char*)fname);
  if (ldata == NULL){
    printf("_load_link_lib_names() read file err: %s\n",(char*)fname);fflush(stdout);
    return;
  }
  while(ldata->eof() == False){
    WSCstring line = ldata->gets();
    WSCstring lname = line.getWord(0);
    WSCstring complete_libname = line.getWord(1);
    WSCstring libname = line.getWord(2);
    WSCstring stlibname = line.getWord(3);
    libname.replaceString(","," ",-1);
    stlibname.replaceString(","," ",-1);
    _complete_lib_name.setData(lname,WSGFstrdup((char*)complete_libname));
    _lib_name.setData(lname,WSGFstrdup((char*)libname));
    _stlib_name.setData(lname,WSGFstrdup((char*)stlibname));
  }
}

WSClistData _lib_list;
void add_lib_list(char* libname){
  long num = _lib_list.getNum();
  long i;
  for(i=0; i<num; i++){
    char* item = (char*)_lib_list[i];
    if (!strcmp(libname,item)){
      return;
    }
  }
  char* str = WSGFstrdup(libname);
//printf("add_lib_name: libname=%s str=%s\n",libname,str);
  _lib_list.add((void*)str);
}
void clear_lib_list(){
  long num = _lib_list.getNum();
  long i;
  for(i=0; i<num; i++){
    char* item = (char*)_lib_list[i];
    delete[] item;
  }
  _lib_list.clear();
}
WSClistData* get_lib_name(){
  return &_lib_list;
}



char* _get_link_lib_name(WSCbase* base){
  int num = _class_lib_list.getNum();
  int i;
  for(i=0; i<num; i++){
    if (!strcmp(base->getClassName(),_class_lib_list.getIndex(i))){
      return (char*)_class_lib_list.getData(i);
    }
  }
  return "";
}

void _create_lib_list(WSCbase* item){
  char* str = _get_link_lib_name(item);
//printf("_update_lib_list str=%s\n",(char*)str);
  if (strcmp((char*)str,"")){
    add_lib_list(str); 
  }
  WSClistData children = item->getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children[i];
    _create_lib_list(child);
  }
}

WSCstring _get_link_lib_names(WSCulong proj){
  _load_link_lib_names(proj);
  if (_init_lib_names == False){
    _init_lib_names = True;
    _load_class_lib_names(proj);
  }

  WSCulong win_id = 0;
  WSCstring ret;
  while(1){
    long next_id = WSGIappObjectList()->getInstanceId(WS_ROOT_INSTANCE_ID,
                                                      WS_NEXT_CHILD_INSTANCE_ID,
                                                      win_id);
    if (next_id == 0){
      break;
    }
    _create_lib_list((WSCbase*)next_id);
    win_id = next_id;
  }

  WSCindexVariantData* prj = (WSCindexVariantData*)proj;
  WSCvariant static_linked = prj->getData("#STLINK");
  WSClistData* liblist = get_lib_name();
  long i;
  long lnum = liblist->getNum();
  for(i=0; i<lnum; i++){
    char* libname = (char*)(*liblist)[i];
    if (static_linked.getLong() == False){
      WSCstring clibname = (char*)_lib_name.getData(libname);
      ret << " " << clibname;
    }else{
      WSCstring clibname = (char*)_stlib_name.getData(libname);
      ret << " " << clibname;
    }
  }
  return ret;
}
long WSGFsetMgrStrData(long kind,char* str,long encoding){
  if (kind == WS_DEFAULT_PROJECT_FILE_NAME){
    _default_project_file_name.setString(str,encoding);
    return WS_NO_ERR;
  }
  if (kind == WS_TARGET_DEF_FILE_NAME){
    if (_init_targets != False){
      _init_targets = False;
    }
    _target_def_file_name.setString(str,encoding);
    return WS_NO_ERR;
  }
  if (kind == WS_LINK_OPT_DEF_FILE_NAME){
    if (_init_lib_opts != False){
      _clear_link_options();
      _init_lib_opts = False;
    }
    _link_opt_def_file_name.setString(str,encoding);
    return WS_NO_ERR;
  }
  if (kind == WS_LINK_LIB_DEF_FILE_NAME){
    _clear_link_lib_names();
    _link_lib_def_file_name.setString(str,encoding);
    return WS_NO_ERR;
  }
  if (kind == WS_LINK_CLASS_DEF_FILE_NAME){
    if (_init_lib_names != False){
      _clear_class_lib_names();
      _init_lib_names = False;
    }
    _class_def_file_name.setString(str,encoding);
    return WS_NO_ERR;
  }
  if (kind == WS_ENV_DEF_FILE_NAME){
    _prj_env_def_file_name.setString(str,encoding);
    return WS_NO_ERR;
  }
  if (kind == WS_TARGET_ENV_DEF_FILE_NAME){
    _target_env_def_file_name.setString(str,encoding);
    return WS_NO_ERR;
  }
  if (kind == WS_LIBNAME_DEF_FILE_NAME){
    _lib_def_file_name.setString(str,encoding);
    return WS_NO_ERR;
  }
  return WS_ERR;
}

WSCstring WSGFgetMgrStrStrData(long kind,char* val){
  WSCstring ret;
  if (kind == WS_TARGET_ENV_TITLE){
    if (_prj_env_loaded == False){
      _load_project_environment_data();
      _prj_env_loaded = True;
    }
    ret = _target_env_title.getData(val);
  }
  return ret;
}

WSCstring WSGFgetMgrStrData(long kind,WSCulong val){
  WSCstring ret;
  if (kind == WS_TARGET_NAME){
    _load_targets();
    int i;
    long num = _target_name.getNum();
    for(i=0; i<num; i++){
      WSCvariant index = _target_name.getIndex(i);
      if (index.getLong()+1 == val){
        ret = _target_name.getData(i);
        return ret;
      }
    }
    return ret;
  }
  if (kind == WS_TARGET_SUFFIX){
    _load_targets();
    int i;
    long num = _target_suffixes.getNum();
    for(i=0; i<num; i++){
      WSCvariant index = _target_suffixes.getIndex(i);
      if (index.getLong()+1 == val){
        ret = _target_suffixes.getData(i);
        return ret;
      }
    }
    return ret;
  }
  if (kind == WS_TARGET_ENV_NAME){
    _load_targets();
    int i;
    long num = _target_env_name.getNum();
    for(i=0; i<num; i++){
      WSCvariant index = _target_env_name.getIndex(i);
      if (index.getLong()+1 == val){
        ret = _target_env_name.getData(i);
        return ret;
      }
    }
    return ret;
  }

  if (kind == WS_LANG_STR){
    if (val == WS_LANG_CPP){
      ret = "C++";
    }
    if (val == WS_LANG_JAVA){
      ret = "Java";
    }
    if (val == WS_LANG_PERL){
      ret = "Perl";
    }
    if (val == WS_LANG_PYTHON){
      ret = "Python";
    }
    if (val == WS_LANG_RUBY){
      ret = "Ruby";
    }
    if (val == WS_LANG_OCAML){
      ret = "Ocaml";
    }
    return ret;
  }

  if (kind == WS_ENCODING_NAME){
    ret << WSGFgetEncodingName(val);
    return ret;
  }
  if (kind == WS_DEFAULT_PROJECT_FILE_NAME){
    char* locale = WSGFgetProjectLocaleName();
    if (!strcmp(_default_project_file_name.getString(),"")){
      _default_project_file_name.setString(WS_DEFAULT_PROJECT_FILE_NAME_S);
    }
    if (locale == NULL || !strcmp(locale,"") || !strcmp(locale,"C")){
      locale = "en_US";
    }
    char buffer[1024];
#if defined (_VC) || defined (_BCC)
    _snprintf(buffer,1024,_default_project_file_name.getString(),locale);
#else
    snprintf(buffer,1024,_default_project_file_name.getString(),locale);
#endif
    WSCstring ret(buffer);
    return ret;
  }
  if (kind == WS_TARGET_DEF_FILE_NAME){
    if (!strcmp(_target_def_file_name.getString(),"")){
      _target_def_file_name = WS_TARGET_DEF_FILE_NAME_S;
    }
    return _target_def_file_name;
  }
  if (kind == WS_LINK_OPT_DEF_FILE_NAME){
    if (!strcmp(_link_opt_def_file_name.getString(),"")){
      _link_opt_def_file_name = WS_LINK_OPT_DEF_FILE_NAME_S;
    }
    ret = _link_opt_def_file_name;
    WSCindexVariantData* prj = (WSCindexVariantData*)val;
    if (prj != NULL){
      long id = atoi((char*)WSGFgetProjectData((WSCulong)prj,"#COMPAT"));
      WSCstring suffix = WSGFgetMgrStrData(WS_TARGET_SUFFIX,id);
//printf("WSGFgetMgrStrData target_suffix=%s\n",(char*)suffix);fflush(stdout);
      ret << suffix;
    }
    return ret;
  }
  if (kind == WS_LINK_CLASS_DEF_FILE_NAME){
    if (!strcmp(_class_def_file_name.getString(),"")){
      _class_def_file_name = WS_LINK_CLASS_DEF_FILE_NAME_S;
    }
    ret = _class_def_file_name;
    return ret;
  }
  if (kind == WS_LINK_LIB_DEF_FILE_NAME){
    if (!strcmp(_link_lib_def_file_name.getString(),"")){
      _link_lib_def_file_name = WS_LINK_LIB_DEF_FILE_NAME_S;
    }
    ret = _link_lib_def_file_name;
    WSCindexVariantData* prj = (WSCindexVariantData*)val;
    if (prj != NULL){
      long id = atoi((char*)WSGFgetProjectData((WSCulong)prj,"#COMPAT"));
      WSCstring suffix = WSGFgetMgrStrData(WS_TARGET_SUFFIX,id);
      ret << suffix;
    }
    return ret;
  }

  if (kind == WS_LINK_OPTIONS){
    long index = 0;
    WSCindexVariantData* prj = (WSCindexVariantData*)val;
    if (prj != NULL){
      index = atoi(prj->getData("#CONPAT")); 
    }
    _load_link_options(val);
    ret = _lib_opts[WSGFltoa(index)];
    return ret;
  }
  if (kind == WS_STLINK_OPTIONS){
    long index = 0;
    WSCindexVariantData* prj = (WSCindexVariantData*)val;
    if (prj != NULL){
      index = atoi(prj->getData("#CONPAT")); 
    }
    _load_link_options(val);
    ret = _stlib_opts[WSGFltoa(index)];
    return ret;
  }
  if (kind == WS_LINK_OPT_NAME){
    long num = _lib_opts_name.getNum();
    long i;
    for(i=0; i<num; i++){
      long no = atoi(_lib_opts_name.getIndex(i));
      if (no+1 == val){
        ret = _lib_opts_name[WSGFltoa(no)];
        return ret;
      }
    }
    return ret;
  }
  if (kind == WS_LINK_LIB_NAME){
    return  _get_link_lib_names(val);
  }
  if (kind == WS_ENV_DEF_FILE_NAME){
    return _prj_env_def_file_name;
  }
  if (kind == WS_TARGET_ENV_DEF_FILE_NAME){
    return _target_env_def_file_name;
  }
  return ret;
}

long WSGFreloadProject(WSCulong project,char* path,long encoding){
  return _load_project(project,path,encoding);
}

long WSGFreloadProject(WSCulong project,char* dname,char* fname,long encoding){
  WSCstring path;
  if (dname == NULL || dname[0] == 0){
    path = fname;
  }else{
    path << dname << "/" << fname;
  }
  return _load_project(project,path,encoding);
}


long WSGFloadProject(char* path,long encoding){
  long project = _load_project(0,
        WSGFgetMgrStrData(WS_DEFAULT_PROJECT_FILE_NAME,0).getString(),encoding);
  long project2 = _load_project(0,
        WSGFgetMgrStrData(WS_DEFAULT_PROJECT_FILE_NAME,0).getString(),encoding);
  WSCindexVariantData* prj = (WSCindexVariantData*)project;
  WSCvariant val((void*)project2,"WSCindexVariantData");
  prj->setData("DEFAULT_VALUE",val);
//  WSCvariant tmp = prj->getData("DEFAULT_VALUE");
  long ret = _load_project(project,path,encoding);
  return ret;
}

long WSGFloadProject(char* dname,char* fname,long encoding){
  WSCstring path;
  if (dname == NULL || dname[0] == 0){
    path = fname;
  }else{
    path << dname << "/" << fname;
  }
  return WSGFloadProject(path.getString(),encoding);
}
long WSGFloadProjectAndWinFiles(char* dname,char* fname,long encoding){
  long prj = WSGFloadProject(dname,fname,encoding);
  if (prj == 0){
    return 0;
  }
  WSCstring wname(fname);
  wname << " ";
  wname.replaceString(".prj ",".wns",1);
  long ret = WSGFloadWinFiles(dname,(char*)wname,prj);
  if(ret != WS_NO_ERR){
    WSGFdestroyProject((WSCulong)prj);
    return 0;
  }
  return prj;
}

long WSGFdestroyProject(WSCulong project){
  if (project == 0){
    return WS_ERR;
  }
  WSCindexVariantData* val = (WSCindexVariantData*)project;
  WSCindexVariantData* val2 = (WSCindexVariantData*)val->getData("DEFAULT_VALUE").getVoidPtr();
  delete val;
  if (val2 != NULL){
    delete val2;
  }
  return WS_NO_ERR;
}

long WSGFdumpProject(WSCulong project){
  if (project == 0){
    return WS_ERR;
  }
  WSCindexVariantData* val = (WSCindexVariantData*)project;
  long i;
  long num = val->getNum();
  for(i=0; i<num; i++){
    printf("%s=%s\n",(char*)val->getIndex(i),(char*)val->getData(i));
  }
  return WS_NO_ERR;
}

long WSGFsaveProject(WSCulong project,char* dname,char* fname,long encoding){
  if (project == 0){
    return WS_ERR;
  }
  WSCindexVariantData* val = (WSCindexVariantData*)project;
  WSCstring path;
  if (dname == NULL || dname[0] == 0){
    path = fname;
  }else{
    path << dname << "/" << fname;
  }
  
  WSCvariant target = val->getData("#COMPAT");
  long num = val->getNum();
  long i;
  WSCstring out;
  for(i=0; i<num; i++){
    WSCstring index = val->getIndex(i);
    WSCstring data = val->getData(i);
    if (!strcmp(index.getString(),"DEFAULT_VALUE")){
      continue;
    }
    if (target.getLong() == 1){ //platform compatible..
      long no_save = False;
      long cnt = 0;
      while(1){
        if (compatible_no_save[cnt] == NULL){
          break;
        }
        if (!strcmp(compatible_no_save[cnt],(char*)index)){
          no_save = True;
        }
        cnt++;
      }
      if (no_save == True){
        continue;
      }
    }
    out << index << "\n";
    out << data << "\n";
  }
  WSGFreplaceTextFile(path,out.getString(encoding),False);

  WSCstring wns;
  WSCulong win_id = 0;
  while(1){
    WSCulong next_id = WSGIappObjectList()->getInstanceId(WS_ROOT_INSTANCE_ID,
                                       WS_NEXT_CHILD_INSTANCE_ID,win_id);
    if (next_id == 0){
      break;
    }
    win_id = next_id;
    WSCbase* win = (WSCbase*)next_id;

//    if (win->getUserData(WS_REGISTERED) == (void*)0){
//      continue;
//    }
    wns << win->getInstanceName() << ".win\n";
  }
  path.replaceString(".prj",".wns",1);
  path.replaceString(".PRJ",".wns",1);
  return WSGFreplaceTextFile(path,wns.getString(encoding),False);

//  path.replaceString(".wns",".col",1);
//  return WSGIappColorSelect()->save((char*)path);
}

long WSGFloadWinFiles(char* dname,char* fname,WSCulong prj){
  WSCindexVariantData* val = (WSCindexVariantData*)prj;
  if (val == 0){
    return WS_ERR;
  }
  long encoding = WSGFgetEncodingValue(val->getData("#ENCODING"));
  if (encoding == WS_EN_DEFAULT || encoding == WS_EN_NONE){
    encoding = WS_EN_LOCALE;
  }

  WSCstring path;
  if (dname == NULL || dname[0] == 0){
    path = fname;
  }else{
    path << dname << "/" << fname;
  }

  WSCstring* data = WSGFreadTextFile((char*)path,encoding);
  if (data == NULL){
    return WS_ERR;
  }
  WSCstring line;
  while(data->eof() == False){
    line = data->gets();
    line.delHeadSpace();
    line.delTailSpace();

    WSCbase* win = WSGFreadWinFile(dname,line,encoding);

    if (win == NULL){
      delete data;
      return WS_ERR;
    }
    WSGIappObjectList()->setInstanceId(WS_SET_ROOT_INSTANCE,(long)win);
    WSGIappObjectList()->setInstanceId(WS_SET_SELECTED_INSTANCE,(long)win);
  }
  delete data;
  return 0;
}

WSCindexVariantData _dll_lib_name;
WSCindexVariantData _dll_lib_name2;
WSCindexVariantData _st_lib_name;
long _load_lib_name(char* fname){
  _dll_lib_name.clear();
  _dll_lib_name2.clear();
  _st_lib_name.clear();
  WSCstring* str = WSGFreadTextFile(fname);
  if (str != NULL){
    while(str->eof() == False){
      WSCstring line = str->gets();
      WSCstring libname = line.getWord(0);
      WSCstring complete_libname = line.getWord(1);
      if (strcmp((char*)libname,"")){
        _dll_lib_name.setData(libname,complete_libname);
        _dll_lib_name2.setData(libname,line.getWord(2));
        _st_lib_name.setData(libname,line.getWord(3));
      }
    }
    delete str;
    return WS_NO_ERR;
  }
  return WS_ERR;
}

WSCindexData lib_list;
long WSGFloadLibrary(long project,char* libname){
  WSCindexVariantData* prj = (WSCindexVariantData*)project;
static int target_id = 0;
static int loaded = False;
  if (prj != NULL){
    long id = atoi((char*)WSGFgetProjectData((WSCulong)prj,"#COMPAT"));
    if (target_id != id){
      target_id = id;
      loaded = False;
    }
  }
  if (loaded == False){
    //TODO: 
    if (!strcmp(_lib_def_file_name.getString(),"")){
      _lib_def_file_name = WS_LIBNAME_DEF_FILE_NAME_S;
    }
    WSCstring suffix = WSGFgetMgrStrData(WS_TARGET_SUFFIX,target_id);
    WSCstring lib_def_fname = _lib_def_file_name;
    lib_def_fname << suffix;

    if (_load_lib_name(
           WSGIappFileSystem()->
                 adjustFileName(lib_def_fname.getString(
                           WSGIappLocaleSet()->getSystemLocaleEncoding())))
         != WS_NO_ERR){
      return WS_ERR;
    }
    loaded = True;
  }
  if (libname == NULL || !strcmp("",libname)){
    if (loaded != False){
      int num = _dll_lib_name.getNum();
      int i;
      for(i=0; i<num; i++){
        char* index = _dll_lib_name.getIndex(i);
        void* val = lib_list[index];
        if (val == NULL){
          WSCstring dllname =  _dll_lib_name.getData(index);
          if (!strcmp(dllname,"")){
            return WS_ERR;
          }
          WSDexternal* ext = WSDexternal::getNewInstance();
          if (ext == NULL){
            fprintf(stderr,"Error: WSDexternal::getNewInstance() can not generate an instance..\n");
            return WS_ERR;
          }
          long ret = ext->open(dllname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding())); 
          if (ret == WS_NO_ERR){
             lib_list.setData(index,(void*)ext);
          }else{
            fprintf(stderr,"Error: WSDexternal::open() can not open library:%s..\n",dllname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
          }
        }
      }
      return WS_NO_ERR;
    }
  }
  void* val = lib_list[libname];
  if (val == NULL){
   WSCstring dllname =  _dll_lib_name.getData(libname);
    if (!strcmp(dllname,"")){
      return WS_ERR;
    }
    WSDexternal* ext = WSDexternal::getNewInstance();
    if (ext == NULL){
      return WS_ERR;
    }
    long ret = ext->open(dllname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding())); 
    if (ret == WS_NO_ERR){
       lib_list.setData(libname,(void*)ext);
       return WS_NO_ERR;
    }
  }
  return WS_NO_ERR;
}


