//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#ifndef NO_REMOTE_INSTANCE
#include <WSCRroot.h>

WSMFclassInit(WSCRroot,WSCroot);

WSCRroot::WSCRroot(){
  _port = 0;
  _db = NULL;
  _rstatus = WS_NO_ERR; 
}

WSCRroot::~WSCRroot(){
}

void WSCRroot::setInstanceName(char* iname){
  _instance_name = iname;
}

void WSCRroot::setAddr(char* addr){
  _addr = addr;
}

void WSCRroot::setPort(WSCushort port){
  _port = port;
}

long WSCRroot::beginRemoteCall(WSCremoteCall* rc){
  _rstatus = WS_NO_ERR;
  _db = NULL;
  if (rc == NULL){
//printf("WSCRroot::beginRemoteCall rc==NULL\n");
    return WS_ERR;
  }
  if (!strcmp(_instance_name,"")){
//printf("WSCRroot::beginRemoteCall _instance_name = NONE\n");
    return WS_ERR;
  }
  rc->_port = _port;
  rc->_addr = _addr;
  rc->setInstanceName((char*)_instance_name);
  _db = WSGIconductor()->beginRemoteCall(rc);
  if (_db == NULL){
    _rstatus = WS_REMOTE_CALL_FAILED;
    return WS_ERR;
  }
  return WS_NO_ERR;
}
long WSCRroot::endRemoteCall(){
  if (_db == NULL){
    _rstatus = WS_REMOTE_CALL_FAILED;
    return WS_ERR;
  }
  long ret = WSGIconductor()->endRemoteCall(_db);
  _db = NULL;
  if (ret != WS_NO_ERR){
    _rstatus = WS_REMOTE_CALL_FAILED;
  }
  return ret;
}
#endif
