//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCbase.h>
#include <WSCbaseList.h>
#include <WSCclassInformation.h>
//#include <WSCgripHand.h>
#include <WSDdev.h>
#include <WSDappDev.h>
#include <WSCdevice.h>
#include <WSCfunctionList.h>
#include <WSDmouse.h>
#include <WSCvariant.h>
#include <WSCindexVariantData.h>
#include <WSDprivateTimer.h>

WSMFclassInit(WSCbase,WSCroot);

//#define TDBG

#ifdef WS_EMBED
void _df_def_dummy_ref(){
extern void _libws_drdef();
  _libws_drdef();
}
#endif

#ifdef MEMDBG
void* wsmalloc(unsigned int size){
  return malloc(size);
}
void* operator new(unsigned int size){
  return wsmalloc(size);
}
void* operator new[](unsigned int size){
  return wsmalloc(size);
}

void operator delete(void* ptr){
  free(ptr);
};
void operator delete[](void* ptr){
  free(ptr);
};
#endif

#ifdef MEMDBG1
void _break_point(){};
WSClistData* memlist = NULL;
long memflg = 0;
long mem_cnt = 0;
void* wsmalloc(unsigned int size){
  void* ptr =  malloc(size);
//printf("operator ::new %d  ptr=0x%x\n",size,ptr);
  if (memflg == 0){
    memflg = 1;
    memset(ptr,0,size);
    if (memlist == NULL){
      memlist = new WSClistData(8192);
    }
    memlist->add(ptr);
    _break_point();
//if (mem_cnt == 93000)assert(0);
//assert(mem_cnt != 8078);
mem_cnt++;
printf("MEMDBG: new mem sum=%d cnt=%d size=%d\n",memlist->getNum(),mem_cnt,size);
    memflg = 0;
  }
  return ptr;
};
void* operator new(unsigned int size){
  return wsmalloc(size);
}
void* operator new[](unsigned int size){
  return wsmalloc(size);
}

void operator delete(void* ptr){
//printf("operator delete 0x%x\n",ptr);
  if (memflg == 0){
    memflg = 1;
    if (memlist != NULL){
      long ret = memlist->del(ptr);
      if (ret == -1){
fprintf(stderr,"MEMDBG: memfree error...\n");fflush(stderr);
#ifndef TE
printf("MEMDBG: del mem error:0x%x\n",ptr);
assert(0);
#else
{ //mem trap!
int* x = NULL;
*x = 100;
}
#endif
      }
    }
printf("MEMDBG: del mem cnt=%d\n",memlist->getNum());
    memflg = 0;
  }
  free(ptr);
};
void operator delete[](void* ptr){
//printf("operator delete 0x%x\n",ptr);
  if (memflg == 0){
    memflg = 1;
    if (memlist != NULL){
      long ret = memlist->del(ptr);
      if (ret == -1){
fprintf(stderr,"MEMDBG: memfree error...\n");fflush(stderr);
#ifndef TE
assert(0);
#else
{ //mem trap!
int* x = NULL;
*x = 100;
}
#endif
//fprintf(stderr,"memfree error...\n");
      }
    }
printf("MEMDBG: del mem cnt=%d\n",memlist->getNum());
    memflg = 0;
  }
  free(ptr);
};


#endif


inline char* WSIFstrdup(const char* src){
  int len=0;
  while(src[len] != 0){
    len++;
  }
  len++;
  char* ret = new char[len];
  memcpy(ret,src,len);
  return ret;
}



WSCbase* WSCbase::_focus_instance = NULL;
WSCbase* WSCbase::_special_focus_instance = NULL;
WSCushort WSCbase::_grid_x = 1;
WSCushort WSCbase::_grid_y = 1;
WSClistData* WSCbase::_create_proc_list = NULL;
WSClistData* WSCbase::_cname_list = NULL;

WSCbase::WSCbase(WSCbase* parent,char* object_name){
WSMFtrace("WSCbase::WSCbase object_name=#%s# 0x%x\n",object_name,object_name);
#ifndef NO_INDEX_VARIANT_DATA
  _variant_list = NULL;
#endif
  _own_class_info = NULL;
  _proc_list = NULL;
  if (object_name != NULL && object_name[0] != 0){
    _instance_name = WSIFstrdup(object_name);
  }else{
    _instance_name = NULL;
  }
  _dev = NULL;
  _dev_public = NULL;
  _parent = parent;
  _data_source_server = NULL;
  _data_source_clients = NULL;
  _user_data_st_list = NULL;
  _user_data_list = NULL;
  _scale_ptrs = NULL;
  _event_mask =0;
//  _event_mask_ex =0;
  _num_of_st_user_data = 0;
  _num_of_user_data = 0;
  _name_hash_value = WSGFgetHashValue(object_name);
  _absolute_draw = False;
#ifndef WS_EMBED
  _show_grip_hand = False;
#endif
  _init_registered = False;
  _update_registered = False;
  _vis = False;
  _vis_bk = False;
  _parent_vis = False;
  _parent_vis_init = False;
  _sensitive = True;
  _sensitive_work = True;
  _parent_sensitive = True;
  _parent_sensitive_init = False;
#ifndef WS_EMBED
  _property_edit_mode = False;
#endif
  _internal_object = False;
  _geometry_changed = False;
  _expose_op = 0;
  _initialized = 0;
  _use_parent_base_dev = False;
  _dev_is_public_dev = False;
  _no_clear = False;
#ifndef NO_REMOTE_INSTANCE
  _export_ = False;
  _export_bk = False;
#endif
  _keep_pixmap_cache = True;
  _proc_list_len = 0;
  _proc_list_bk = NULL;
  _flag_for_anchor = False;
}

WSCbase::~WSCbase(){
#ifndef WS_EMBED
  WSCbase* client = NULL;
  WSCbase* prop_editor = WSGIappPropertyEditor();
  if (prop_editor != NULL && prop_editor != this){
    prop_editor->getPropertyV(WSNclient,(void**)&client);
//printf("WSCbase::~WSCbase prope cl=0x%x this=0x%x\n",client,this);
    if (client == (WSCbase*)this){
      client = NULL;
      prop_editor->setUserData("PCLIENT",(void*)NULL);
      prop_editor->setPropertyV(WSNclient,(void*)client);
    }
  }
  void(*hd)(WSCbase*,long)=NULL;
  hd = (void(*)(WSCbase*,long))WSGFgetPropertyEditorHandler();
  if (hd != NULL){
    hd(this,WS_PE_INSTANCE_NOT_ACTIVATED);
  }
#endif

#ifndef NO_REMOTE_INSTANCE
  if (_export_ != False){
    WSGIappObjectList()->addExportInstanceDeleteList(this);
    _export_ = False;
  }
#endif
  if (_special_focus_instance == this){
    _special_focus_instance = NULL;
  }
  setFocus(False);
  _exec_del_procedure();
  if (_own_class_info != NULL){
    WSGIappObjectList()->delClient(this,
                             _own_class_info->getClassInstanceList());
  }

  WSCbase* parent = getParent();
  if (parent != NULL){
    WSClistData* list = (WSClistData*)parent->getUserData("FOCUS_LIST");
    if (list != NULL){
      list->del(this);
    }
  }
  WSClistData* list = (WSClistData*)getUserData("FOCUS_LIST");
  if (list != NULL){
    delete list;
    setUserData("FOCUS_LIST",(void*)0);
  }
//  clearGriphand();

//printf("WSCbase::~WSCbase  delete dev...  %s\n",getInstanceName());
  if (_dev != NULL){
//    delete _dev;
    _dev->deleteInstance();
  }
  if (parent != NULL){
    parent->delChild(this);
    setParent(NULL);
  }
  if( _scale_ptrs != NULL){
    delete _scale_ptrs;
    _scale_ptrs = NULL;
  }
  long i;
  if (_num_of_st_user_data > 0){
    delete[] _user_data_st_list;
  }
  if (_num_of_user_data > 0){
    for(i=0; i< _num_of_user_data; i++){
      delete[] _user_data_list[i*2];
    }
    delete[] _user_data_list;
  }

  if (_data_source_clients != 0){
    long cnum = _data_source_clients->_num;
    WSCbase** buf = (WSCbase**)_data_source_clients->_data;
    for(i=0; i< cnum; i++){
      WSCbase* client = buf[i];
      client->setDataSourceServer(NULL);
    }
    delete _data_source_clients;
    _data_source_clients = NULL;
  }
  if ( getDataSourceServer() != NULL){
    getDataSourceServer()->delDataSourceClient(this);
    setDataSourceServer(NULL);
  }

  if (_proc_list != NULL){
    WSCprocedure** proc_list = (WSCprocedure**)_proc_list->_data;
    long num = _proc_list->_num;
    for(i=0; i<num; i++){
      WSCprocedure* op = proc_list[i];
      delete op;
    }
    delete _proc_list;
    _proc_list = NULL;
  }
  if (_proc_list_bk != NULL){
    delete[] _proc_list_bk;
    _proc_list_bk = NULL;
  }
#ifndef NO_INDEX_VARIANT_DATA
  if (_variant_list != NULL){
    _variant_list->clear();
    delete _variant_list;
    _variant_list = NULL;
  }
#endif
  if (_instance_name != NULL){
    delete[] _instance_name;
    _instance_name = NULL;
  }
}
WSClistData* WSCbase::getDataSourceClients(){
  return _data_source_clients;
}
void WSCbase::addDataSourceClient(WSCbase* client){
  if (_data_source_clients == NULL){
    _data_source_clients = new WSClistData(8);
  }
  long i;
  long num = _data_source_clients->_num;
  WSCbase** buf = (WSCbase**)_data_source_clients->_data;
  for(i=0; i<num; i++){
    if (buf[i] == client){
      return;
    }
  }
  _data_source_clients->add((void*)client);
}
void WSCbase::delDataSourceClient(WSCbase* client){
  if (_data_source_clients == NULL){
    return;
  }
  _data_source_clients->del((void*)client);
}
WSCbase* WSCbase::getDataSourceServer(){
  return _data_source_server;
}
void WSCbase::setDataSourceServer(WSCbase* dserv){
  _data_source_server = dserv;
}
void WSCbase::setDataToDataSourceClients(WSCvariant* data){
  WSCvariant tmp;
  if (data == NULL){
    data = &tmp;
    data->setValue("");
  }
  if (_data_source_clients == NULL){
    return;
  }
  long i;
  long num = _data_source_clients->_num;
  WSCbase** buf = (WSCbase**)_data_source_clients->_data;
  for(i=0; i<num; i++){
    buf[i]->setData(data);
  }
}
void WSCbase::setData(WSCvariant* data,long code){
  WSCbase* pchild = getPropertyInheritChild();
  if (pchild != NULL){
    pchild->setData(data,code);
  }
}
long WSCbase::getDataSourceType(){
  WSCbase* pchild = getPropertyInheritChild();
  if (pchild != NULL){
    return pchild->getDataSourceType();
  }
  return WS_DATA_SOURCE_NONE;
}
char* WSCbase::getDataSourcePropertyName(){
  WSCbase* pchild = getPropertyInheritChild();
  if (pchild != NULL){
    return pchild->getDataSourcePropertyName();
  }
  return "";
}
long WSCbase::_property_init(){
  long i,num;
  WSClistData* plist = _own_class_info->getPropertyListForInit();
  num = plist->_num;

  WSCproperty* prop = NULL;
  WSCproperty* prop_bk = NULL;
  void* class_ptr_bk = NULL;
  char* class_name;
  char* class_name_bk = NULL;
  WSCproperty** props = (WSCproperty**)plist->_data;
  for(i=0; i< num; i++){
    prop = props[i];
    class_name = prop->owner_class_name;
    if (prop_bk != NULL && class_name == class_name_bk){
      prop->execSetHandler( class_ptr_bk );                                  
    }else{
      class_ptr_bk = cast(class_name);
      prop->execSetHandler( class_ptr_bk );                                  
    }
    class_name_bk = class_name;
    prop_bk = prop;
  }
  return WS_NO_ERR;
}

WSCbool WSCbase::getInitialized(){
  return _initialized;
}

long WSCbase::initialize(){
static WSCbaseList* blist = NULL;
  _own_class_info = getClassInformation();
  if (blist == NULL){
    blist = WSGIappObjectList();
  }
  blist->addClient(this,_own_class_info->getClassInstanceList());
  _property_init();
  _initialized = True;
  if (_parent != NULL){
    _parent->setChild(this);
    _parent->onChildAdded(this);
  }
  _own_class_info->getHashTable(); //create hash tables.
  return WS_NO_ERR;
}

WSCbool WSCbase::_get_parent_visible(){
  if (_parent_vis_init == False){
    _parent_vis_init = True;
    if (_parent != NULL){
      _parent_vis = _parent->getVisible();
      return _parent_vis;
    }
    if (getObjectType() & WS_TYPE_WINDOW){
      _parent_vis = True;
      return _parent_vis;
    }
    _parent_vis = False;
    return _parent_vis;
  }else{
    return _parent_vis;
  }
}

WSCbool WSCbase::_get_parent_sensitive(){
  if (_parent_sensitive_init == False){
    _parent_sensitive_init = True;
    if (_parent != NULL){
      _parent_sensitive = _parent->getSensitive();
      return _parent_sensitive;
    }
    return True;
  }else{
    return _parent_sensitive;
  }
}

long WSCbase::delAllProcedure(){
  if (_proc_list != NULL){
    _proc_is_changed = 1;
    long num = _proc_list->_num;
    long i;
    WSCprocedure** buf = (WSCprocedure**)_proc_list->_data;
    for(i=0; i<num; i++){
      WSCprocedure* op = buf[i];
      if (op->getTrigger() != WSEV_DELETE){
        _proc_list->delPos(i);
        i--;
        num--;
        delete op;
      }
    }
  }
  return WS_NO_ERR;
}

#ifndef WS_EMBED
long WSCbase::setPropertyEditExecute(WSCbool fl ){
  if (fl !=  False) {
    setPropertyEditMode(True);
    WSCbase* client = this;
    WSCbase* prop_editor = WSGIappPropertyEditor();
    if (prop_editor != NULL){
      prop_editor->setPropertyV(WSNclient,(void*)client);
    }
    void(*hd)(WSCbase*,long)=NULL;
    hd = (void(*)(WSCbase*,long))WSGFgetPropertyEditorHandler();
    if (hd != NULL){
      hd(this,WS_PE_INSTANCE_ACTIVATED);
    }
    setShowGriphand(True);
  }else{
    WSCbase* client = NULL;
    WSCbase* prop_editor = WSGIappPropertyEditor();
    if (prop_editor != NULL){
      void* tmp;
      prop_editor->getPropertyV(WSNclient,&(tmp));
      client = (WSCbase*)tmp;
      if (client == (WSCbase*)this){
        client = NULL;
        prop_editor->setPropertyV(WSNclient,(void*)client);
      }
    }
    void(*hd)(WSCbase*,long)=NULL;
    hd = (void(*)(WSCbase*,long))WSGFgetPropertyEditorHandler();
    if (hd != NULL){
      hd(this,WS_PE_INSTANCE_NOT_ACTIVATED);
    }
    setShowGriphand(False);
  }
  setAbsoluteDraw(True);
  redraw();
  return WS_NO_ERR;
}
#endif

#ifndef WS_EMBED
long WSCbase::setPropertyEditMode(WSCbool fl ){
//printf("WSCbase::setPropertyEditMode %s %d\n",getInstanceName(),fl);
  if (fl !=  False) {
    if (_property_edit_mode == False){
      _property_edit_mode = True;
      _event_mask |= (WSEV_MOUSE_PRESS_BIT | WSEV_MOUSE_RELEASE_BIT);
      if (_dev != NULL){
        _dev->setEnableEventBit(_event_mask);
      }
      onEditModeChange(True);
    }else{
      _property_edit_mode = True;
    }
  }else{
    setPropertyEditExecute(False);
    _property_edit_mode = False;
    onEditModeChange(False);
  }
  return WS_NO_ERR;
}
#endif
void WSCbase::_adjust_for_anchors(WSCushort,WSCushort){
}
void WSCbase::update(){
#ifndef WS_EMBED
  if ( _show_grip_hand != False && _update_registered != False &&
       _geometry_changed != False){
    drawGriphand();
  }
#endif
  _update_registered = False;
  _geometry_changed = False;
dbprintf("WSCbase::update() %s:%d %s updated...\n",__FILE__,__LINE__,getInstanceName());
}
void WSCbase::needUpdate(){
  if (_update_registered == False && _vis != False){
    _update_registered = True;
    WSGIappObjectList()->addNeedUpdate(this);
dbprintf("WSCbase::needUpdate() %s:%d %s add update list...\n",__FILE__,__LINE__,getInstanceName());
  }
}
long WSCbase::delChild(WSCbase* child){
  WSClistData* children = getChildrenPtr();
  if (children == NULL){
    return WS_NO_ERR;
  }
  children->del(child);
  return WS_NO_ERR;
}
void WSCbase::onChildAdded(WSCbase* child){
  execProcedure(WSEV_CHILD_ADDED);
}
void WSCbase::setParent(WSCbase* parent){
  _parent = parent;
  //DEVELOP change dev property data for parent
}
long WSCbase::setChild(WSCbase* child){
  if (child == NULL){
    return WS_ERR;
  }
  WSClistData* children = getChildrenPtr();
  if (children == NULL){
    return WS_NO_ERR;
  }
  children->add((void*)child);
//  onChildAdded(child);
  return WS_NO_ERR;
}
#ifndef WS_EMBED
long WSCbase::drawGriphand(){
  if (_show_grip_hand == False){
    return WS_NO_ERR;
  }
  short x,y;
  WSCushort w,h;
  if (existProperty(WSNx) == False ||
      existProperty(WSNy) == False ||
      existProperty(WSNwidth) == False ||
      existProperty(WSNheight) == False ){
    return WS_ERR;
  }

  getPropertyV(WSNx,&x);
  getPropertyV(WSNy,&y);
  getPropertyV(WSNwidth,&w);
  getPropertyV(WSNheight,&h);

  if (getObjectType() & WS_TYPE_MANAGER){
    x = 0;
    y = 0;
  }
  _draw_grip_hand(x,y,w,h);
  return WS_NO_ERR;
}
long WSCbase::clearGriphand(){
  WSClistData* ghlist = (WSClistData*)getUserData("GH-LIST");
  if (ghlist != NULL){
    long i;
    for(i=0; i<9; i++){
      WSCbase* gh = (WSCbase*) (*ghlist)[i];
      if (WSGIappObjectList()->existInstance(gh)){
        delete gh;
      }
    }    
    delete ghlist;
  }
  setUserData("GH-LIST",NULL);
  return WS_NO_ERR;
}
#endif

void WSCbase::setGripHandGrid(WSCushort x,WSCushort y){
  _grid_x = x;
  _grid_y = y;
}

void WSCbase::getGripHandGrid(WSCushort* x,WSCushort* y){
  *x = _grid_x;
  *y = _grid_y;
}
#ifndef WS_EMBED
void _griph_geom_handler(WSCbase* base,short no,short diff_x,short diff_y){
#ifndef NO_GRIPHAND
  if (base->existProperty(WSNx) == False ||
      base->existProperty(WSNy) == False ||
      base->existProperty(WSNwidth) == False ||
      base->existProperty(WSNheight) == False){
    return;
  }
  if ( base->cast("WSCwindow") != NULL ){
    if (no == 0 || no == 1 || no == 2 || no == 6 || no == 7 || no==8){
      return;
    }
  }
  short x,y;
  WSCushort w,h;
  base->getPropertyV(WSNx,&x);
  base->getPropertyV(WSNy,&y);
  base->getPropertyV(WSNwidth,&w);
  base->getPropertyV(WSNheight,&h);
  WSCushort gx,gy;
  WSCbase::getGripHandGrid(&gx,&gy);
#if 0
  short ox = 0;
  short oy = 0;
  if (base->getXOffsetPtr() != NULL){
    ox = *(base->getXOffsetPtr());
  } 
  if (base->getYOffsetPtr() != NULL){
    oy = *(base->getYOffsetPtr());
  } 
#endif
#ifdef MSW
  if ((base->getObjectType() & WS_TYPE_WINDOW)){
    return;
  }
#endif
  WSCushort pw=0xffff;
  WSCushort ph=0xffff;
  WSCbase* parent = base->getParent();
  if (!(base->getObjectType() & WS_TYPE_WINDOW)){
    if (parent != NULL && parent->existProperty(WSNwidth) == True){
      parent->getPropertyV(WSNwidth,&pw);
      if (parent->existProperty(WSNworkWidth) == True){
        parent->getPropertyV(WSNworkWidth,&pw);
      }
    }
    if (parent != NULL && parent->existProperty(WSNheight) == True){
      parent->getPropertyV(WSNheight,&ph);
      if (parent->existProperty(WSNworkHeight) == True){
        parent->getPropertyV(WSNworkHeight,&ph);
      }
    }
  }

  if (diff_x != 0 || diff_y != 0){
    WSCbool at = False;
    WSCbool ab = False;
    WSCbool al = False;
    WSCbool ar = False;
    if (base->existProperty(WSNanchorTopFlag) == True &&
        (WSCbool)base->getProperty(WSNanchorTopFlag) == True){
      at = True;
    }
    if (base->existProperty(WSNanchorBottomFlag) == True &&
        (WSCbool)base->getProperty(WSNanchorBottomFlag) == True){
      ab = True;
    }
    if (base->existProperty(WSNanchorLeftFlag) == True &&
        (WSCbool)base->getProperty(WSNanchorLeftFlag) == True){
      al = True;
    }
    if (base->existProperty(WSNanchorRightFlag) == True &&
        (WSCbool)base->getProperty(WSNanchorRightFlag) == True){
      ar = True;
    }

    WSCbool refresh = False;
    if (base->getObjectType() & WS_TYPE_FORM){
    }else{
      refresh = True;
    }
    if (refresh != False){
      base->setVisible(False);
    }
    switch(no){
    case 0:
      if (at == True || al == True){
        break;
      }
      if (y -diff_y > -1 && h + diff_y > 0 && 
          x -diff_x > -1 && w + diff_x > 0 ){
        short dx = x - WSGFadjustNumber(x - diff_x,gx);
        short dy = y - WSGFadjustNumber(y - diff_y,gy);
        base->setPropertyV(WSNx, (short)(WSGFadjustNumber(x - diff_x,gx)));
        base->setPropertyV(WSNy, (short)(WSGFadjustNumber(y - diff_y,gy)));
        base->setPropertyV(WSNwidth,  (WSCushort)(WSGFadjustNumber(w + dx,gx)));
        base->setPropertyV(WSNheight, (WSCushort)(WSGFadjustNumber(h + dy,gy)));
      }
      break;
    case 1:
      if (at == True){
        break;
      }
      if (y -diff_y > -1 && h + diff_y > 0){
        short dy = y - WSGFadjustNumber(y - diff_y,gy);
        base->setPropertyV(WSNy, (short)(WSGFadjustNumber(y - diff_y,gy)) );
        base->setPropertyV(WSNheight, (WSCushort)(WSGFadjustNumber(h + dy,gy)) );
      }
      break;
    case 2:
      if (at == True || ar == True){
        break;
      }
      if (y -diff_y > -1 && h + diff_y > 0){
        short dy = y - WSGFadjustNumber(y - diff_y,gy);
        base->setPropertyV(WSNy, (short)(WSGFadjustNumber(y - diff_y,gy)) );
        base->setPropertyV(WSNheight, (WSCushort)(WSGFadjustNumber(h + dy,gy)) );
      }
      if (x + w - diff_x < pw && w - diff_x > 0){ 
        base->setPropertyV(WSNwidth,(WSCushort)(WSGFadjustNumber(w -diff_x,gx)) );
      }
      break;
    case 3:
      if (ar == True){
        break;
      }
      if (x + w - diff_x < pw && w - diff_x > 0){ 
        base->setPropertyV(WSNwidth,(WSCushort)(WSGFadjustNumber(w -diff_x,gx)) );
      }
      break;
    case 4:
      if (ab == True || ar == True){
        break;
      }
      if (x + w - diff_x < pw && w - diff_x > 0){ 
        base->setPropertyV(WSNwidth,(WSCushort)(WSGFadjustNumber(w -diff_x,gx)) );
      }
      if (y + h - diff_y < ph && h - diff_y > 0){ 
        base->setPropertyV(WSNheight,(WSCushort)(WSGFadjustNumber(h -diff_y,gy)));
      }
      break;
    case 5:
      if (ab == True){
        break;
      }
      if (y + h - diff_y < ph && h - diff_y > 0){ 
        base->setPropertyV(WSNheight,(WSCushort)(WSGFadjustNumber(h -diff_y,gy)));
      }
      break;
    case 6:
      if (ab == True || al == True){
        break;
      }
      if (x -diff_x > -1 && w + diff_x > 0){
        short dx = x - WSGFadjustNumber(x - diff_x,gx);
        base->setPropertyV(WSNx, (short)(WSGFadjustNumber(x - diff_x,gx)) );
        base->setPropertyV(WSNwidth,  (WSCushort)(WSGFadjustNumber(w + dx,gx)) );
      }
      if (y + h - diff_y < ph && h - diff_y > 0){ 
        base->setPropertyV(WSNheight,(WSCushort)(WSGFadjustNumber(h -diff_y,gy)));
      }
      break;
    case 7:
      if (al == True){
        break;
      }
      if (x -diff_x > -1 && w + diff_x > 0){
        short dx = x - WSGFadjustNumber(x - diff_x,gx);
        base->setPropertyV(WSNx, (short)(WSGFadjustNumber(x - diff_x,gx)) );
        base->setPropertyV(WSNwidth,  (WSCushort)(WSGFadjustNumber(w + dx,gx)) );
      }
      break;
    case 8:
      if (al == True || ar == True || at == True || ab == True){
        break;
      }
      if (x -diff_x > -1 && x -diff_x + w < pw){
        base->setPropertyV(WSNx, (short)(WSGFadjustNumber(x - diff_x,gx)) );
      }
      if (y -diff_y > -1 && y -diff_y + h < ph){
        base->setPropertyV(WSNy, (short)(WSGFadjustNumber(y - diff_y,gy)) );
      }
      break;
    }
    if (refresh != False){
      base->setVisible(True);
    }
    base->drawGriphand();
    base->update(); 
//#ifndef WS_EMBED
    WSGFmarkChanged(base);
    //update xy position...
    WSCbase* prop_editor = WSGIappPropertyEditor();
    if (prop_editor != NULL){
      WSGIappPropertyEditor()->setUserData(WS_GEOMETRY_UPDATE,(void*)1); 
      WSGIappPropertyEditor()->update();
    }
    void(*hd)(WSCbase*,long)=NULL;
    hd = (void(*)(WSCbase*,long))WSGFgetPropertyEditorHandler();
    if (hd != NULL){
      hd(base,WS_PE_PROPERTY_CHANGED);
    }
//#endif
  }
#endif
}
#endif
WSCbool WSCbase::getVisible(){
  if (_parent_vis_init != False){
    return (_vis && _parent_vis);
  }else{
    return (_vis && _get_parent_visible());
  }
}

WSCbool WSCbase::getSensitive(){
  if (_parent_sensitive_init != False){
    return (_sensitive && _parent_sensitive);
  }else{
    return (_sensitive && _get_parent_sensitive());
  }
}
WSCbool WSCbase::_get_sensitive_work(){
  return _sensitive_work;
}
void WSCbase::onResize(WSCrect*){}
#ifndef WS_EMBED
void WSCbase::onEditModeChange(WSCbool fl){
  if (fl != False){
    if (_sensitive == False){
      setSensitive(True);
      _sensitive_work = False;
    }
//    long val = (long)getSensitive();
//    setUserData(WS_DET,(void*)val);
  }
#if 0
  WSClistData children = getChildren();
  long num = children.getNum();
  long i;
  WSCbase* base;
  for(i=0; i < num; i++){
    base = (WSCbase*)children[i];
    if (base->getInternalObject() == False){
      base->setPropertyEditMode( fl ); 
    }
  }
#endif
  execProcedure(WSEV_EDIT_MODE_CH);
}
#endif
#ifndef WS_EMBED
void WSCbase::_draw_grip_hand(short x,short y,WSCushort w,WSCushort h){

#ifndef NO_GRIPHAND
  WSClistData* glist = (WSClistData*)getUserData("GH-LIST");
  long i;
  WSCbase* gh = NULL;
  if (glist == NULL){
    glist = new WSClistData(16);
    setUserData("GH-LIST",glist);

//DEVELOP ////////////////////////////
//to implement settings of mouse shages...

    for(i=0; i<9; i++){
      gh = WSGFgetNewGripHand(this);
      if (i % 2 == 1){
        if (i == 1 || i == 5){
          WSCushort h;
          gh->getPropertyV(WSNheight,&h);
          h = h/2;
          gh->setPropertyV(WSNheight,h);
        }else{
          WSCushort w;
          gh->getPropertyV(WSNwidth,&w);
          w = w/2;
          gh->setPropertyV(WSNwidth,w);
        }
      }
      gh->setUserData(WS_GRIPH_HANDLER,(void*)_griph_geom_handler);
      gh->setUserData("CLIENT",(void*)this);
      gh->setUserData("GH-NO",(void*)i);
      glist->add( gh );
    }    
  }
  gh = (WSCbase*)(*glist)[0];
  gh->setPropertyV(WSNx,x);
  gh->setPropertyV(WSNy,y);
  gh->setPropertyV(WSNmouse,(WSCushort)195);
  gh = (WSCbase*)(*glist)[1];
  gh->setPropertyV(WSNx, (short)(x + w/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNy,y);
  gh->setPropertyV(WSNmouse,(WSCushort)197);
  gh = (WSCbase*)(*glist)[2];
  gh->setPropertyV(WSNx, (short)(x + w - WS_GRIPH_SIZE*2) );
  gh->setPropertyV(WSNy,y);
  gh->setPropertyV(WSNmouse,(WSCushort)196);
  gh = (WSCbase*)(*glist)[3];
  gh->setPropertyV(WSNx, (short)(x + w - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNy, (short)(y + h/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNmouse,(WSCushort)176);
  gh = (WSCbase*)(*glist)[4];
  gh->setPropertyV(WSNx, (short)(x + w - WS_GRIPH_SIZE*2) );
  gh->setPropertyV(WSNy, (short)(y + h - WS_GRIPH_SIZE*2) );
  gh->setPropertyV(WSNmouse,(WSCushort)135);
  gh = (WSCbase*)(*glist)[5];
  gh->setPropertyV(WSNx, (short)(x + w/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNy, (short)(y + h - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNmouse,(WSCushort)136);
  gh = (WSCbase*)(*glist)[6];
  gh->setPropertyV(WSNx, x );
  gh->setPropertyV(WSNy, (short)(y + h - WS_GRIPH_SIZE*2) );
  gh->setPropertyV(WSNmouse,(WSCushort)134);
  gh = (WSCbase*)(*glist)[7];
  gh->setPropertyV(WSNx, x );
  gh->setPropertyV(WSNy, (short)(y + h/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNmouse,(WSCushort)163);
  gh = (WSCbase*)(*glist)[8];
  gh->setPropertyV(WSNx, (short)(x + w/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNy, (short)(y + h/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNmouse,(WSCushort)154);

  for(i=0; i<9; i++){ 
    gh = (WSCbase*)(*glist)[i];
    gh->setVisible(True);
  }
#endif
}
#endif
//WSCbool WSCbase::getGriphandOn(){
//  return _show_grip_hand;
//}
#ifndef WS_EMBED
long WSCbase::setShowGriphand(WSCbool fl){
  if (fl != False){
    fl = True;
  }
  if ((WSCuchar)fl == _show_grip_hand){
    return WS_NO_ERR;
  }
  if (fl != False){
    WSDdev* dev = _dev;
    if (dev == NULL){
      return WS_ERR;
    }
    dev->setEnableEvent(WSEV_EXPOSE);
    _show_grip_hand = True;
    drawGriphand();
  }else{
    _show_grip_hand = False;
    clearGriphand();
    setAbsoluteDraw(True);
    redraw();
  }
  return WS_NO_ERR;
}
#endif
WSCbase* WSCbase::getParent(){
  return _parent;
}
WSCbase* WSCbase::getParentWindow(){
  WSCbase* parent = this;
  while(parent->getParent() != NULL){
    parent = parent->getParent();
  }
  return parent;
}
WSCbase* WSCbase::getPublicDevChild(){
  return _dev_public;
}
WSDdev* WSCbase::getdev(){
  if (_dev_is_public_dev != False){
    if (_dev_public != NULL){
      return _dev_public->getdev();
    }else{
      return NULL;
    }
  }
  return _dev;
}
long WSCbase::setdev(WSDdev* dev){
  _dev = dev;
  if (_dev != NULL){
    _dev->attachClient(this);
    _device_initialize();
  }
  return WS_NO_ERR;
}
WSDdev* WSCbase::getowndev(){
  return _dev;
}
WSDdev* WSCbase::getParentDev(){
  if (_parent == NULL){
    return NULL;
  }
  if (_use_parent_base_dev != False){
    return _parent->getowndev();
  }
  return _parent->getdev();
}
void WSCbase::setUseParentBaseDev(WSCbool fl){
  _use_parent_base_dev = fl;
}
WSCbool WSCbase::getUseParentBaseDev(){
  return _use_parent_base_dev;
}
void WSCbase::setParentSensitive(WSCbool fl){
  if (fl == _parent_sensitive){
    return;
  }

  setAbsoluteDraw(True);
  needUpdate();
  WSCbool bk = _parent_sensitive;

  if (fl != False){
    _parent_sensitive = True;
  }else{
    _parent_sensitive = False;
  }
  onParentSensitiveChange(_parent_sensitive);
  execProcedure(WSEV_PARENT_SENSITIVE_CH);

  if ((bk && _sensitive) != (_parent_sensitive && _sensitive)){
    WSClistData* children = getChildrenPtr();
    if (children != NULL){
      long num = children->_num;
      WSCbase** children_buf = (WSCbase**)children->_data;
      long i;
      long fl = getSensitive();
      WSCbase* base;
      for(i=0; i < num; i++){
        base = children_buf[i];
        base->setParentSensitive(fl); 
      }
    }
  }
}

WSCbool WSCbase::getParentSensitive(){
  return _parent_sensitive;
}

void WSCbase::setParentVisible(WSCbool fl){
  if (fl == _parent_vis){
    return;
  }
  WSCbool bk = _parent_vis;
  if (fl != False){
    _parent_vis = True;
  }else{
    _parent_vis = False;
  }
  WSCbool parent_vis_bk = _parent_vis;
  WSCbool vis_bk = _vis;
  onParentVisibleChange(_parent_vis);
  execProcedure(WSEV_PARENT_VISIBLE_CH);
  if ((bk && vis_bk) != (parent_vis_bk && vis_bk)){
    WSClistData* children = getChildrenPtr();
    if (children != NULL){
      long num = children->_num;
      WSCbase** children_buf = (WSCbase**)children->_data;
      long i;
      long fl = getVisible();
      for(i=0; i < num; i++){
        WSCbase* base = children_buf[i];
        base->setParentVisible( fl );
      }
    }
  }
}

WSCbool WSCbase::getParentVisible(){
  if (_parent_vis_init == False){
    return  _get_parent_visible();
  }
  return _parent_vis;
}

void WSCbase::setSensitive(WSCbool fl){
  if (fl == _sensitive){
    return;
  }
  setAbsoluteDraw(True);
  needUpdate();
  long bk = getSensitive();
  if (fl != False){
    _sensitive = True;
    _sensitive_work = True;
  }else{
    _sensitive = False;
    _sensitive_work = False;
  }
  onSensitiveChange(_sensitive);
  execProcedure(WSEV_SENSITIVE_CH);

  long sensitive = getSensitive();
  if (bk != sensitive){
    WSClistData* children = getChildrenPtr();
    if (children != NULL){
      long num = children->_num;
      WSCbase** children_buf = (WSCbase**)children->_data;
      long i;
      for(i=0; i < num; i++){
        children_buf[i]->setParentSensitive( sensitive ); 
      }
    }
  }
  return;
}

long WSCbase::setAbsoluteDraw(WSCbool fl){
  _absolute_draw = fl;
  return WS_NO_ERR;
}

WSCbool WSCbase::getAbsoluteDraw(){
  return _absolute_draw;
}

WSClistData* WSCbase::getProcedureList(){
  if (_proc_list == NULL){
static WSClistData dummy;
    dummy.clear();
    return &dummy;
  }
  return _proc_list;
}

WSClistData WSCbase::getProcedures(){
  return *_proc_list;
}
void WSCbase::setVisible(WSCbool fl){
#ifdef TDBG
  printf("WSCbase::setVisible(%d) here1 %d\n",fl,WSGFclocktime());
#endif

  long obj_type = getObjectType();

  WSCbool bk;
  if (_parent_vis_init != False){
    bk = _vis_bk && _parent_vis;
  }else{
    bk = _vis_bk && _get_parent_visible();
  }
  if (_vis == fl && _vis_bk == fl){
    return;
  }
#ifdef TDBG
  printf("WSCbase::setVisible(%d) here2 %d\n",fl,WSGFclocktime());
#endif
  if (fl != False){
    _vis = True;
    _vis_bk = True;
  }else{
    _vis = False;
    _vis_bk = False;
    if ((obj_type &  WS_TYPE_FORM) == 0){
      if (_no_clear == False){
        redraw();
      }
    }
  }
#ifdef TDBG
  printf("WSCbase::setVisible(%d) here3 %d\n",fl,WSGFclocktime());
#endif
  long vis = getVisible();
  onVisibleChange(_vis);
  execProcedure(WSEV_VISIBLE_CH);
  if (bk != vis){
    WSClistData* children = getChildrenPtr();
    if (children != NULL){
      long num = children->_num;
      WSCbase** children_buf = (WSCbase**)children->_data;
      long i;
      for(i=0; i < num; i++){
        children_buf[i]->setParentVisible( vis ); 
      }
    }
  }
#ifdef TDBG
  printf("WSCbase::setVisible(%d) here4 %d\n",fl,WSGFclocktime());
#endif
  if (fl == True){
    if ((obj_type &  WS_TYPE_FORM) == 0){
      setAbsoluteDraw(True);
    }
    needUpdate();
  }
#ifdef TDBG
  printf("WSCbase::setVisible(%d) here5 %d\n",fl,WSGFclocktime());
#endif
  return;
}
void WSCbase::setNoClearFlag(WSCbool fl){
  _no_clear = fl;
}
long WSCbase::redraw(){
  return WS_NO_ERR;
}
long WSCbase::clear(){
  return WS_NO_ERR;
}
long WSCbase::_device_initialize(){
  if (_dev == NULL){
    return WS_ERR;
  }
  if (_scale_ptrs != NULL){
    if (_scale_ptrs[2] != NULL){
      _dev->setValue(WSDEV_SCALE_OFFSET,_scale_ptrs[2]);
    }
    if (_scale_ptrs[0] != NULL && !(getObjectType() & WS_TYPE_FORM )){
      _dev->setValue(WSDEV_X_OFFSET,_scale_ptrs[0]);
    }
    if (_scale_ptrs[1] != NULL && !(getObjectType() & WS_TYPE_FORM )){
      _dev->setValue(WSDEV_Y_OFFSET,_scale_ptrs[1]);
    }
  }
  _dev->setEnableEventBit(_event_mask);
  return WS_NO_ERR;
}


WSCclassInformation* WSCbase::WSCbase_info_ptr = NULL;
WSCclassInformation* WSCbase::getClassInformation(){
  if (WSCbase_info_ptr == NULL){
    WSCbase_info_ptr = new WSCclassInformation("WSCbase",NULL);
  }
  return WSCbase_info_ptr;
}
WSClistData* WSCbase::getPropertyList(){
  return _own_class_info->getAllPropertyList();
}
WSCproperty* WSCbase::getPropObj(char* prop_name){
  WSCproperty* prop = NULL;
  WSCbool ret = _own_class_info->getPropObj(prop_name,&prop);
  if (ret == False){
    return NULL;
  }else{
    return prop;
  }
}
long WSCbase::getPropObjArray(WSClistData* list){
  long pnum;
  long i,j;
  WSClistData* hash_table = _own_class_info->getHashTable();
  for(i=0; i < WS_MAX_HASH_VALUE; i++){
    pnum = hash_table[i]._num;
    WSCproperty* prop;
    for(j=0; j < pnum; j++){
//      WSChashData* hdata = (WSChashData*)hash_table[i][j];
      j++;
      prop = (WSCproperty*)hash_table[i][j];
      list->add(prop);
    }
  }
  return WS_NO_ERR;
}
long WSCbase::getPropertyArray(WSClistData* list,WSCbool include_defaultv){
  WSCproperty* prop;
  long pnum;

  long j;
  WSClistData* props = _own_class_info->getAllPropertyList();

  pnum = props->_num;
  for(j=0; j < pnum; j++){
    prop = (WSCproperty*)(*props)[j];
    WSCbool def = prop->isDefaultValue(this);
    if (def != False && include_defaultv == False){
      continue;
    }
    list->add(WSIFstrdup(prop->property_name));
    list->add(WSIFstrdup(_get_property_str_value(prop).getCharPtr()));
  }
  return WS_NO_ERR;
}

void WSCbase::_error_output(char* pname,char* tname,char* ptname,WSCbool fl){
if (fl == False){
WSMFtrace("ERROR. %s WSCbase::getProperty property %s invalid value type:%s\n",getClassName(),pname,tname);
}else{
WSMFtrace("ERROR. %s WSCbase::setProperty property %s invalid value type:%s\n",getClassName(),pname,tname);
}
WSMFtrace("object:%s WSN%s type is %s.\n",getInstanceName(),pname,ptname);
}

WSCvariant WSCbase::getProperty(char* prop_name){
  WSCproperty* prop;
  WSCbool fl = _own_class_info->getPropObj(prop_name,&prop);
  if (fl == False){
    if (getPropertyInheritChild() != NULL){
      return getPropertyInheritChild()->getProperty(prop_name);
    } 
WSMFtrace("ERROR. %s WSCbase::getProperty property not exists. %s\n",getClassName(),prop_name);
    return "";
  }
  return _get_property_str_value(prop);
}

WSCvariant WSCbase::_get_property_str_value(WSCproperty* prop){
  register long tp = prop->_prop_type;
//DEVELOP hash ...
//  if (tp < 7){
  switch(tp){
    case WSTshort:{
      if (prop->_is_pixmap != False){
        short val;
        prop->getValue(this,&val);
        return WSGFimageName(val);
      }else if (prop->_is_color != False){
        short val;
        prop->getValue(this,&val);
        if (val > 1023){
          return WSGFcolorName(val);
        }else{
          return WSGFcolorName(val);
        }
      }else{
        short data;
        prop->getValue(this,&data);
//        return WSGFltoa((long)data);
        return data;
      }
    }
    break;
    case WSTushort:{
      WSCushort data;
      prop->getValue(this,&data);
//      return WSGFltoa((long)data);
      return data;
    }
    case WSTbool:{
      char data;
      prop->getValue(this,&data);
      if (data != False){
//        return "1";
        return 1;
      }else{
//        return "0";
        return 0;
      }
    }
    case WSTcharptr:{
      char* data;
      prop->getValue(this,&data);
      if (data == NULL){
        data ="";
      }
      return data;
    }
    case WSTchar:{
      char data;
      prop->getValue(this,&data);
//      return WSGFltoa((long)data);
      return data;
    }
    case WSTuchar:{
      WSCuchar data;
      prop->getValue(this,&data);
//      return WSGFltoa((long)data);
      return data;
    }
    case WSTlong:{
      long data;
      prop->getValue(this,&data);
//      return WSGFltoa((long)data);
      return data;
    }
    case WSTulong:{
      WSCulong data;
      prop->getValue(this,&data);
//      return WSGFultoa(data);
      return data;
    }
    case WSTfloat:{
      float data;
      prop->getValue(this,&data);
//      return WSGFftoa(data);
      return data;
    }
    case WSTdouble:{
      double data;
      prop->getValue(this,&data);
//      return WSGFlftoa(data);
      return data;
    }
    case WSTvoidptr:{
      void* data;
      prop->getValue(this,&data);
//      return WSGFltoa((long)data);
      return (WSCulong)data;
    }
    case WSTint:{
      int data;
      prop->getValue(this,&data);
//      return WSGFltoa((long)data);
      return data;
    }
    case WSTuint:{
      WSCuint data;
      prop->getValue(this,&data);
//      return WSGFultoa(data);
      return data;
    }
  }
//  }
  return "";
}

WSCbool WSCbase::existProperty(char* prop_name){
  WSCproperty* prop;
  if (getPropertyInheritChild() != NULL &&
     _own_class_info->getPropObj(prop_name,&prop) == False){
    return getPropertyInheritChild()->existProperty(prop_name);
  }else{
    return _own_class_info->getPropObj(prop_name,&prop);
  }
}

WSCbool WSCbase::setProperty(char* prop_name,const WSCvariant& value1){
//  WSCvariant value = value1;
  WSCproperty* prop;
  WSCbool fl = _own_class_info->getPropObj(prop_name,&prop);
//  WSCbool ret = False;
  if (fl == False){
    if (getPropertyInheritChild() != NULL){
      return getPropertyInheritChild()->setProperty(prop_name,value1);
    }
    WSMFtrace("ERROR. %s WSCbase::setProperty property not exists. %s\n",
               getClassName(),prop_name);
    return False;
  }
  register long tp = prop->_prop_type;
//  if (value == NULL){
//    value = "";
//  }
  switch(tp){
    case WSTshort:{
      if (prop->_is_pixmap != False){
        short pno = -1;
        char* val = value1.getCharPtrConst();
        if (val[0] == 0 ||
            !WSIFstrcmp(val,"NULL") ||
            !WSIFstrcmp(val,"NONE") ||
            !WSIFstrcmp(val,"null") ||
            !WSIFstrcmp(val,"None") ){
            //pno = -1; ....
        }else{
          if (_keep_pixmap_cache != False){
            pno = WSGFimage(val);
          }else{
            short pixno = -1;
            prop->getValue(this,&pixno);
            if (pixno == -1 || pixno == 0){
              pno = WSGFimage(val);
            }else{
              pno = WSGFimage(val,pixno);
            }
          }
        }
        prop->setValue(this,&pno);
      }else if (prop->_is_color != False){
        short cno = value1.getShort();
        if (cno == 0 && value1.getType() == WSTcharptr){
          cno = WSGFcolor(value1.getCharPtrConst());
          prop->setValue(this,&cno);
        }else{
          prop->setValue(this,&cno);
        }
      }else{
        short data = value1.getShort();
        prop->setValue(this,&data);
      }
      return True;
    }
    break;
    case WSTuchar:{
      WSCuchar data = value1.getUnsignedChar();
      prop->setValue(this,&data);
      return True;
    }
    case WSTushort:{
      WSCushort data = value1.getUnsignedShort();
      prop->setValue(this,&data);
      return True;
    }
    case WSTcharptr:{
      char* diff;
      WSCvariant value = value1;
      char* val = value.getCharPtr();
      void* ptr = (void*)this;
      if (!prop->_can_burst_cast){
        ptr = cast2(prop->owner_class_name);
      }
      prop->_get_proc_addr(ptr,&diff);
//      prop->getValue(this,&diff);
      if (diff != NULL && diff[0] == val[0] && !WSIFstrcmp(diff,val)){
          //do nothing...
      }else{
        if (value.getType() == WSTcharptr && value.getNoAllocated() == False){
          value.setNoAllocated(True);
          prop->_set_proc_addr(ptr,&val);
        }else{
          char* nstr = WSIFstrdup(val);
          prop->_set_proc_addr(ptr,&nstr);
//          prop->setValue(this,&nstr);
        }
        if (diff != NULL){
          delete[] diff;
        }
      }
      return True;
    }
    case WSTbool:{
      char data = value1.getChar();
      if (data == 0 && value1.getType() == WSTcharptr) {
        char* val = value1.getCharPtrConst();
        if (!WSIFstrcmp(val,"True") || !WSIFstrcmp(val,"true")){
          data = True;
        }
      }
      prop->setValue(this,&data);
      return True;
    }
    case WSTchar:{
      char data = value1.getChar();
      prop->setValue(this,&data);
      return True;
    }
    case WSTlong:{
      long data = value1.getLong();
      prop->setValue(this,&data);
      return True;
    }
    case WSTulong:{
      WSCulong data = value1.getUnsignedLong();
      prop->setValue(this,&data);
      return True;
    }
    case WSTfloat:{
      float data = value1.getFloat();
      prop->setValue(this,&data);
      return True;
    }
    case WSTvoidptr:{
      void* data = (void*)value1.getVoidPtr();
      prop->setValue(this,&data);
      return True;
    }
    case WSTdouble:{
      double data = value1.getDouble();
      prop->setValue(this,&data);
      return True;
    }
  }
  return False;
}
WSCbool WSCbase::setDefaultValue(char* prop_name){
  WSCproperty* prop;
  WSCbool fl = _own_class_info->getPropObj(prop_name,&prop);
  if (fl == False){
WSMFtrace("ERROR. WSCbase::setDefaultValue property not exists. %s\n",prop_name);
    return False;
  }
  prop->setDefaultValue(this);
  return True;
} 
long WSCbase::isDefaultValue(char* prop_name,WSCbool* fl){
  WSCproperty* prop;
  WSCbool ret = _own_class_info->getPropObj(prop_name,&prop);
  if (ret == False){
    WSCbase* pchild = getPropertyInheritChild();
    if (pchild != NULL){
      return pchild->isDefaultValue(prop_name,fl);
    }else{
WSMFtrace("ERROR. WSCbase::isDefaultValue property not exists. %s\n",prop_name);
    }
    return WS_ERR;
  }
  *fl = prop->isDefaultValue(this);
  return WS_NO_ERR;
}

void WSCbase::_set_prop_error(char* pname){
  WSMFtrace("ERROR. WSCbase::setPropertyV property not exists. %s  class=%s obj=%s\n",pname,getClassName(),getInstanceName());
//  assert(0);//TEST
}

void WSCbase::_set_prop_error2(char* pname,char* tname,WSCproperty* prop){
  WSMFtrace("ERROR. WSCbase::setPropertyV property %s invalid value type:%s.\n",pname,tname);
#ifndef WS_EMBED
  WSMFtrace("object:%s WSN%s type is %s.\n",getInstanceName(),pname,prop->getPropObjTypeName());
#endif
//  assert(0);//TEST
}

WSCbool WSCbase::setPropertyV(char* prop_name,WSCvariant value){
  return setProperty(prop_name,value);
}
WSCbool WSCbase::setPropertyV(char* prop_name,char value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTchar || prop->_prop_type == WSTbool  ){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"char",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,WSCuchar value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTuchar || prop->_prop_type == WSTbool){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"unsigned char",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,char* value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (value == NULL){
    value ="";
  }
  if (prop->_prop_type == WSTcharptr){  //more than the color properties
    char* diff;
    void* ptr = (void*)this;
    if (!prop->_can_burst_cast){
      ptr = cast2(prop->owner_class_name);
    }
    prop->_get_proc_addr(ptr,&diff);
//    prop->getValue(this,&diff);
    if (diff != NULL && diff[0] == value[0] && !WSIFstrcmp(diff,value)){
      //do nothing...
    }else{
      char* nstr = WSIFstrdup(value);
//      prop->setValue(this,&nstr);
      prop->_set_proc_addr(ptr,&nstr);
      if (diff != NULL){
        delete[] diff;
      }
    }
    return True;
  }else if (prop->_is_color != False){ //more than the pixmap properties
    short cno = WSGFcolor(value);
    prop->setValue(this,&cno);
    return True;
  }else if (prop->_is_pixmap != False){
    short pno = -1;
    if (value[0] == 0 ||
        !WSIFstrcmp(value,"NULL") ||
        !WSIFstrcmp(value,"NONE") ||
        !WSIFstrcmp(value,"null") ||
        !WSIFstrcmp(value,"None") ){
        //pno = -1; ....
    }else{
      if (_keep_pixmap_cache != False){
        pno = WSGFimage(value);
      }else{
        short pixno = -1;
        prop->getValue(this,&pixno);
        if (pixno == -1 || pixno == 0){
          pno = WSGFimage(value);
        }else{
          pno = WSGFimage(value,pixno);
        }
      }
    }
    prop->setValue(this,&pno);
    return True;
  }else{
    _set_prop_error2(prop_name,"char*",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,short value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTshort){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"short",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,WSCushort value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTushort){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"unsigned short",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,int value){
  return setPropertyV(prop_name,(long)value);
}
WSCbool WSCbase::setPropertyV(char* prop_name,long value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTlong){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"long",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,WSCuint value){
  return setPropertyV(prop_name,(WSCulong)value);
}
WSCbool WSCbase::setPropertyV(char* prop_name,WSCulong value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTulong){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"unsigned long",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,float value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTfloat){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"float",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,double value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTdouble){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"double",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,void* value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTvoidptr){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"void*",prop);
    return False;
  }
  return True;
}
void WSCbase::_get_prop_error(char* pname){
  WSMFtrace("ERROR. WSCbase::getPropertyV property not exists. %s\n",pname);
}
void WSCbase::_get_prop_error2(char* pname,char* tname,WSCproperty* prop){
  WSMFtrace("ERROR. WSCbase::getPropertyV property %s is not type:%s.\n",pname,tname);
#ifndef WS_EMBED
  WSMFtrace("object:%s WSN%s type is %s.\n",getInstanceName(),pname,prop->getPropObjTypeName());
#endif
}
WSCbool WSCbase::getPropertyV(char* prop_name,char* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTchar || prop->_prop_type == WSTbool){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"char",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,WSCuchar* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTuchar || prop->_prop_type == WSTbool){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"unsigend char",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,char** value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTcharptr){
    prop->getValue(this,value);
    if (*value == NULL){
      *value = "";
    }
    return True;
  }else if (prop->_prop_type == WSTshort && prop->_is_color != False){
    short val;
    prop->getValue(this,&val);
    if (val > 1023){
      *value = WSGFcolorName(val);
    }else{
      *value = WSGFltoa(val);
    }
    return True;
  }else if (prop->_prop_type == WSTshort && prop->_is_pixmap != False){
    short val;
    prop->getValue(this,&val);
    *value = WSGFimageName(val);
    return True;
  }
  _get_prop_error2(prop_name,"char*",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,short* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTshort){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"short",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,WSCushort* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTushort){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"unsigend short",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,int* value){
  return getPropertyV(prop_name,(long*)value);
}
WSCbool WSCbase::getPropertyV(char* prop_name,WSCuint* value){
  return getPropertyV(prop_name,(WSCulong*)value);
}
WSCbool WSCbase::getPropertyV(char* prop_name,long* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTlong){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"long",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,WSCulong* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTulong){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"unsigned long",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,float* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTfloat){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"float",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,double* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTdouble){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"double",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,void** value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTvoidptr){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"void*",prop);
  return False;
}
void WSCbase::_exec_del_procedure(){
  if (_proc_list != NULL){
    _exec_procedure(WSEV_DELETE,True,False);
    _exec_procedure(WSEV_DELETE,True,True);
  }
  return;
}
void WSCbase::execProcedure(long ev){
dbprintf("WSCbase::execProcedure %s:%d %s start ev=0x%x\n",__FILE__,__LINE__,getInstanceName(),ev);
  if (_proc_list != NULL){
    if (ev == WSEV_EXPOSE && _expose_op == 0){
dbprintf("WSCbase::execProcedure %s:%d %s done ev=0x%x\n",__FILE__,__LINE__,getInstanceName(),ev);
      return;
    }
//    if ( ev > 32 && ((_event_mask_ex & WSGFeventToMaskBitEx(ev))== 0) ){
//dbprintf("WSCbase::execProcedure %s:%d %s done ev=0x%x\n",__FILE__,__LINE__,getInstanceName(),ev);
//      return;
//    }
    _exec_procedure(ev,False,False);
    _exec_procedure(ev,False,True);
  }
dbprintf("WSCbase::execProcedure %s:%d %s done2 ev=0x%x\n",__FILE__,__LINE__,getInstanceName(),ev);
  return;
}
void WSCbase::_exec_procedure(WSCprocedure* op){
#ifndef WS_EMBED
  WSCbool mess = False;
  if (WSGIappDev()->getTraceMode() != False && op->getInternal() == False){
    mess = True;
    char sbuf[1024];
    WSCstring str;
    sprintf(sbuf,"%s %s execute event procedure <%s>\n",getClassName(),getInstanceName(),
                                                  op->getProcName());
    str = sbuf;
    WSGFsendMessage("WS-TRACER",str.getString(WS_EN_UTF8));
    sprintf(sbuf,"function %s() start  ev=%s\n",op->getFunctionName(),
                                                 WSGFeventToName(op->getTrigger()));
    str = sbuf;
    WSGFsendMessage("WS-TRACER",str.getString(WS_EN_UTF8));
  }
#endif
  void (*proc)(WSCbase*); 
  proc = (void(*)(WSCbase*))op->getProc();
  if (proc != NULL){
dbprintf("WSCbase::_exec_procedure %s:%d %s start op=%s\n",__FILE__,__LINE__,getInstanceName(),op->getFunctionName());
    proc(this);
dbprintf("WSCbase::_exec_procedure %s:%d %s done op=%s\n",__FILE__,__LINE__,getInstanceName(),op->getFunctionName());
  }else{
    void(*hd)(char*,WSCbase*) =
                 (void(*)(char*,WSCbase*))WSGFgetProcedureHandler();
    if (hd != NULL){
dbprintf("WSCbase::_exec_procedure %s:%d %s start op=%s\n",__FILE__,__LINE__,getInstanceName(),op->getFunctionName());
      hd(op->getFunctionName(),this);
dbprintf("WSCbase::_exec_procedure %s:%d %s done op=%s\n",__FILE__,__LINE__,getInstanceName(),op->getFunctionName());
    }
  }
#ifndef WS_EMBED
  if (mess != False){
    char sbuf[1024];
    WSCstring str;
    sprintf(sbuf,"function %s() end\n",op->getFunctionName());
    str = sbuf;
    WSGFsendMessage("WS-TRACER",str.getString(WS_EN_UTF8));
  }
#endif
}
void WSCbase::_exec_procedure(long ev,WSCbool del,WSCbool internal){
  if (ev == WSEV_INITIALIZE){
    _init_registered = False;
  }
  if (_proc_list == NULL){
    return;
  }

  long num= _proc_list->_num;
  if (_proc_list_len < num){
    if (_proc_list_bk != NULL){
      delete[] _proc_list_bk;
    }
    _proc_list_bk = new WSCprocedure*[num];
    _proc_list_len = num;
  }

  _proc_is_changed = 0;
  memcpy(_proc_list_bk,_proc_list->_data,sizeof(WSCprocedure*) * num);
  long i;
  for(i=0; i<num; i++){
    WSCprocedure* op = _proc_list_bk[i];
    if (op->getTrigger()  == ev){
      if (op->getInternal() == internal){
        if (_proc_is_changed != 0){
          if (_proc_list == NULL){
            break;
          }
          long cnt = 0;
          long exists = 0;
          WSCprocedure** plist = (WSCprocedure**)_proc_list->_data;
          while(plist[cnt] != NULL){
            if (plist[cnt] == op){
              exists = 1;
              break;
            }
            cnt++;
          }
          if (exists == 0){
            continue;
          }
        }
        _exec_procedure(op);
        if (del == False){ 
          WSGIappObjectList()->execUpdate();
        }
      }
    }
  }
}
void WSCbase::_exec_procedure(char* opname,WSCbool internal){
  if (_proc_list == NULL){
    return;
  }
  long num = _proc_list->_num;
  long i;
  _proc_is_changed = 0;

  if (_proc_list_len < num){
    if (_proc_list_bk != NULL){
      delete[] _proc_list_bk;
    }
    _proc_list_bk = new WSCprocedure*[num];
    _proc_list_len = num;
  }

  memcpy(_proc_list_bk,_proc_list->_data,sizeof(WSCprocedure*)*num);
  for(i=0; i<num; i++){
    WSCprocedure* op = _proc_list_bk[i];
    if ( !WSIFstrcmp(op->getProcName(),opname) ){
      if (op->getInternal() == internal){
        if (_proc_is_changed != 0){
          if (_proc_list == NULL){
            break;
          }
          long cnt = 0;
          long exists = 0;
          WSCprocedure** plist = (WSCprocedure**)_proc_list->_data;
          while(plist[cnt] != NULL){
            if (plist[cnt] == op){
              exists = 1;
              break;
            }
            cnt++;
          }
          if (exists == 0){
            continue;
          }
        }
        _exec_procedure(op);
      }
    }
  }
}
void WSCbase::execProcedure(char* opname){
dbprintf("WSCbase::execProcedure %s:%d %s start opname=%s\n",__FILE__,__LINE__,getInstanceName(),opname);
  if (_proc_list != NULL){
    _exec_procedure(opname,False);
    _exec_procedure(opname,True);
  }
dbprintf("WSCbase::execProcedure %s:%d %s done opname=%s\n",__FILE__,__LINE__,getInstanceName(),opname);
  return;
}
long WSCbase::addProcedure(WSCprocedure* op){
  if (existTrigger(op->getTrigger()) == False && op->getInternal() == False){
//assert(0);
WSMFtrace("WSCbase::addProcedure trigger=%d not supported.\n",(int)op->getTrigger());
     return WS_ERR;
  }
  long trg = op->getTrigger();
  _event_mask |= op->getEffectiveTriggerMask();
//  _event_mask_ex |= WSGFeventToMaskBitEx(trg);
  if (trg == WSEV_INITIALIZE && _init_registered == False){
    _init_registered = True;
    WSGIappObjectList()->addNeedInitialize(this);
    _add_prcs(op);
    return WS_NO_ERR;
  }
//  op->setEffectiveTriggerMask( op->getEffectiveTriggerMask()  );
  if (op->getTrigger() == WSEV_EXPOSE){
    _expose_op = 1;
  }
  _add_prcs(op);
  WSDdev* dev = _dev;
  if (dev != NULL && op->getEffectiveTriggerMask() != 0){
    dev->setEnableEvent( op->getTrigger() );
  }
  return WS_NO_ERR;
}
void WSCbase::_add_prcs(WSCprocedure* op){
  if (_proc_list == NULL){
    _proc_list = new WSClistData(8);
  }
  _proc_list->add((void*)op);
  return;
}
long WSCbase::delProcedure(WSCprocedure* proc){
  if (_proc_list != NULL){
    if (_proc_list->del((void*)proc) == 0){
      _proc_is_changed = 1;
      return WS_NO_ERR;
    }
  }
  return WS_ERR;
}
long WSCbase::execEventProc(long ev,void* data){
//DEVELOP///
// makeing this procedure to use hash table
dbprintf("WSCbase::execEventProc %s:%d %s start ev=%d\n",__FILE__,__LINE__,getInstanceName(),ev);

  if (ev == WSEV_EXPOSE){
    if (data != NULL){
      WSCrect* area = (WSCrect*)data;
      onExpose(area);
      draw();
      if (_expose_op == 1){
        execProcedure(ev);
      }
dbprintf("WSCbase::execEventProc %s:%d %s done ev=%d\n",__FILE__,__LINE__,getInstanceName(),ev);
      return WS_NO_ERR;
    }
  }else if (ev == WSEV_MOUSE_PRESS){
    if (data != NULL){
      WSCpoint* point = (WSCpoint*)data;
      onMousePress(point);
      execProcedure(ev);
dbprintf("WSCbase::execEventProc %s:%d %s done ev=%d\n",__FILE__,__LINE__,getInstanceName(),ev);
      return WS_NO_ERR;
    }
  }else if (ev == WSEV_MOUSE_DOUBLE_CLICK){
    if (data != NULL){
      WSCpoint* point = (WSCpoint*)data;
      onMouseDoubleClick(point);
      execProcedure(ev);
dbprintf("WSCbase::execEventProc %s:%d %s done ev=%d\n",__FILE__,__LINE__,getInstanceName(),ev);
      return WS_NO_ERR;
    }
  }else if (ev == WSEV_MOUSE_RELEASE){
    if (data != NULL){
      WSCpoint* point = (WSCpoint*)data;
      onMouseRelease(point);
      execProcedure(ev);
dbprintf("WSCbase::execEventProc %s:%d %s done ev=%d\n",__FILE__,__LINE__,getInstanceName(),ev);
      return WS_NO_ERR;
    }
  }else if (ev == WSEV_MOUSE_IN){
    if (data != NULL){
      WSCpoint* point = (WSCpoint*)data;
      onMouseIn(point);
      execProcedure(ev);
dbprintf("WSCbase::execEventProc %s:%d %s done ev=%d\n",__FILE__,__LINE__,getInstanceName(),ev);
      return WS_NO_ERR;
    }
  }else if (ev == WSEV_MOUSE_OUT){
    onMouseOut();
    execProcedure(ev);
dbprintf("WSCbase::execEventProc %s:%d %s done ev=%d\n",__FILE__,__LINE__,getInstanceName(),ev);
    return WS_NO_ERR;
  }else if (ev == WSEV_MOUSE_MOVE){
    if (data != NULL){
      WSCpoint* point = (WSCpoint*)data;
      onMouseMove(point);
      execProcedure(ev);
dbprintf("WSCbase::execEventProc %s:%d %s done ev=%d\n",__FILE__,__LINE__,getInstanceName(),ev);
      return WS_ERR;
    }
  }else if (ev == WSEV_RESIZE){
    WSCrect* rect = (WSCrect*)data;
    onResize(rect);
    execProcedure(ev);
dbprintf("WSCbase::execEventProc %s:%d %s done ev=%d\n",__FILE__,__LINE__,getInstanceName(),ev);
    return WS_NO_ERR;
  }else if (ev == WSEV_GUI_POLICY_CH){
    long policy = (long)data;
    onGuiPolicyChange(policy);
dbprintf("WSCbase::execEventProc %s:%d %s done ev=%d\n",__FILE__,__LINE__,getInstanceName(),ev);
    return WS_NO_ERR;
  } 
  execProcedure(ev);
dbprintf("WSCbase::execEventProc %s:%d %s done ev=%d\n",__FILE__,__LINE__,getInstanceName(),ev);
  return WS_ERR;
}
void WSCbase::onMouseIn(WSCpoint*){
  if (existProperty(WSNmouse) != False){
    WSCushort id = getProperty(WSNmouse);
    WSDdev* dev = getowndev();
    if (dev != NULL){
      dev->setValue(WSDEV_MOUSE_NO,&id);
    }
  }
}
void WSCbase::onMouseOut(){}
void WSCbase::onMouseMove(WSCpoint*){}
void WSCbase::onFocusChange(WSCbool){}
void WSCbase::onWindowFocusChange(WSCbool){}
void WSCbase::onSpecialFocusChange(WSCbool){
  execProcedure(WSEV_SPECIAL_FOCUS_CH);
}

#ifndef WS_EMBED
WSDprivateTimer* _positioning_timer = NULL;
static WSCbase* _new_frame_top = NULL;
static WSCbase* _new_frame_bottom = NULL;
static WSCbase* _new_frame_left = NULL;
static WSCbase* _new_frame_right = NULL;
static long _new_frame_pos_x = 0;
static long _new_frame_pos_y = 0;
WSCbase* _target_site = NULL;

void WSCbase::_start_new_instance_positioning(){
  if (!(getObjectType() & WS_TYPE_MANAGER)){
    return;
  }
  _event_mask |= WSEV_MOUSE_RELEASE_BIT;
  if (_dev != NULL){
    _dev->setEnableEventBit(_event_mask);
  }

  _target_site = this;
  if (_positioning_timer == NULL){
    _positioning_timer = WSDprivateTimer::getNewInstance();
    _positioning_timer->setRate(5);
  }
  _positioning_timer->setWorkProc(_new_instance_pos_work_proc,this);

  if (_new_frame_top == NULL){
    _new_frame_top = WSCbase::getNewInstance("WSCwindow",NULL,"wscbase_sep_window");
    _new_frame_top->initialize();
    _new_frame_top->setProperty(WSNtitleBar,WS_NO_MANAGE);
    _new_frame_top->setProperty(WSNshadowThickness,0);
    _new_frame_top->setProperty(WSNbackColor,"#606060");
    _new_frame_top->setProperty(WSNindicatorOn,False);


    _new_frame_bottom = WSCbase::getNewInstance("WSCwindow",NULL,"wscbase_sep_window");
    _new_frame_bottom->initialize();
    _new_frame_bottom->setProperty(WSNtitleBar,WS_NO_MANAGE);
    _new_frame_bottom->setProperty(WSNshadowThickness,0);
    _new_frame_bottom->setProperty(WSNbackColor,"#606060");
    _new_frame_bottom->setProperty(WSNindicatorOn,False);

    _new_frame_left = WSCbase::getNewInstance("WSCwindow",NULL,"wscbase_sep_window");
    _new_frame_left->initialize();
    _new_frame_left->setProperty(WSNtitleBar,WS_NO_MANAGE);
    _new_frame_left->setProperty(WSNshadowThickness,0);
    _new_frame_left->setProperty(WSNbackColor,"#606060");
    _new_frame_left->setProperty(WSNindicatorOn,False);

    _new_frame_right = WSCbase::getNewInstance("WSCwindow",NULL,"wscbase_sep_window");
    _new_frame_right->initialize();
    _new_frame_right->setProperty(WSNtitleBar,WS_NO_MANAGE);
    _new_frame_right->setProperty(WSNshadowThickness,0);
    _new_frame_right->setProperty(WSNbackColor,"#606060");
    _new_frame_right->setProperty(WSNindicatorOn,False);

  }
  short px;
  short py;
  WSGIappMouse()->getMousePosition(&px,&py);
  _new_frame_pos_x = px;
  _new_frame_pos_y = py;
  _positioning_timer->startTimer();
}

#if 0
void WSCbase::_stop_new_instance_positioning(){
  if (_positioning_timer == NULL){
    _positioning_timer = WSDprivateTimer::getNewInstance();
  }
  _positioning_timer->stopTimer();
  _new_frame_top->setVisible(False);
  _new_frame_bottom->setVisible(False);
  _new_frame_left->setVisible(False);
  _new_frame_right->setVisible(False);
}
#endif
void WSCbase::_new_instance_pos_work_proc(void* ptr){
  if (_new_frame_top == NULL){
    return;
  }
  WSCbase* _this = (WSCbase*)ptr;
  short px;
  short py;
  WSGIappMouse()->getMousePosition(&px,&py);
  short x = _new_frame_pos_x;
  short w = px - _new_frame_pos_x;

  if (w < 0 ){
    if (-10 < w ){
      x = _new_frame_pos_x -10;
      w = 10;
    }else{
      x = px;
      w = -w;
    }
  }else{
    if (w < 10 ){
      w = 10;
    }
  }

  short y = _new_frame_pos_y;
  short h = py - _new_frame_pos_y;
  if (h < 0){
    if (-10 < h ){
      y = _new_frame_pos_y -10;
      h = 10;
    }else{
      y = py;
      h = -h;
    }
  }else{
    if (h < 10 ){
      h = 10;
    }
  }

  _new_frame_top->setProperty(WSNx,x);
  _new_frame_top->setProperty(WSNy,y);
  _new_frame_top->setProperty(WSNwidth,w);
  _new_frame_top->setProperty(WSNheight,2);

  _new_frame_left->setProperty(WSNx,x);
  _new_frame_left->setProperty(WSNy,y);
  _new_frame_left->setProperty(WSNwidth,2);
  _new_frame_left->setProperty(WSNheight,h);

  _new_frame_right->setProperty(WSNx,x+w-2);
  _new_frame_right->setProperty(WSNy,y);
  _new_frame_right->setProperty(WSNwidth,2);
  _new_frame_right->setProperty(WSNheight,h);

  _new_frame_bottom->setProperty(WSNx,x);
  _new_frame_bottom->setProperty(WSNy,y+h-2);
  _new_frame_bottom->setProperty(WSNwidth,w);
  _new_frame_bottom->setProperty(WSNheight,2);

  _new_frame_top->setVisible(True);
  _new_frame_bottom->setVisible(True);
  _new_frame_left->setVisible(True);
  _new_frame_right->setVisible(True);

  if ((WSGIappMouse()->getStatus() & WS_MOUSE_BTN1) == 0){
    _new_frame_top->setVisible(False);
    _new_frame_left->setVisible(False);
    _new_frame_bottom->setVisible(False);
    _new_frame_right->setVisible(False);
    _positioning_timer->stopTimer();
#ifndef NO_INDEX_VARIANT_DATA
    short ax =0,ay =0;
    WSDdev* dev = _this->getowndev();
    if (dev != NULL){
      dev->getDispAddr(&ax,&ay);
      WSCindexVariantData val;
      val["class"] = (char*)WSGIappObjectList()->getNewInstanceClassName();
      val["name"] = "new_insntace";
      val["x"] = x-ax;
      val["y"] = y-ay;
      if (w < 20){
        w = 20;
      }
      if (h < 20){
        h = 20;
      }
      val["width"] = w;
      val["height"] = h;
//      WSCbase* inst = WSGFexecCreateInstanceHandler(_this,&val);
      WSGFexecCreateInstanceHandler(_this,&val);
    }
#endif
  }
}
#endif

void WSCbase::onMousePress(WSCpoint* point){
#ifndef WS_EMBED
  if (_internal_object != False){
    WSCbase* parent = _parent;
    while(parent != NULL){
      if (parent->_internal_object != False){
        parent = parent->_parent;
        continue;
      }else if (parent->_property_edit_mode != False){
        short px;
        short py;
        getMouseAddr(&px,&py);
        WSClistData children = parent->getChildren();
        long num = children._num;
        if (num != 0){
          long i;
          for(i=0; i<num; i++){
            WSCbase* child = (WSCbase*)children[i];
            if (child->_dev == NULL){
              continue;
            }else if (child->_dev->getParentDev() == NULL){
              continue;
            }
            if (child->getInternalObject() != False){
              continue;
            }
            if (child->existProperty(WSNx)      != False && 
                child->existProperty(WSNy)      != False &&
                child->existProperty(WSNwidth)  != False &&
                child->existProperty(WSNheight) != False ){
              short x,y;
              WSCushort w,h;
              child->getPropertyV(WSNx,&x); 
              child->getPropertyV(WSNy,&y); 
              child->getPropertyV(WSNwidth,&w); 
              child->getPropertyV(WSNheight,&h); 
              if ( px >= x   && py >= y  &&
                   px < x + w && py <= y + h &&
                   child->getVisible() != False ){
                return;
              }
            }
          }
        }
        if (WSGIappObjectList()->getNewInstancePositionMode()){
          parent->_start_new_instance_positioning();
        }else{
          parent->setPropertyEditExecute(True); 
        }
        return;
      }else{
        return;
      }
    }
  }else if (_property_edit_mode != False){
    if (!WSIFstrcmp(getUseDevName(),"nwDev")){
      WSCbase* parent = _parent;
      if (parent == NULL){
        if (WSGIappObjectList()->getNewInstancePositionMode()){
          _start_new_instance_positioning();
        }else{
          setPropertyEditExecute(True);
        }
      }else{
        WSClistData children = parent->getChildren();
        long num = children._num;
        long i,j=0;
        for(i=0; i<num; i++){
          WSCbase* base = (WSCbase*)children[i];
          if (base == this){
            j = i;
            break;
          }
        }
        if (i == num -1){
          if (WSGIappObjectList()->getNewInstancePositionMode()){
            _start_new_instance_positioning();
          }else{
            setPropertyEditExecute(True); 
          }
        }else{
          short mx=0,my=0;
          if (existProperty(WSNx) != False){
            getPropertyV(WSNx,&mx);
          }
          if (existProperty(WSNy) != False){
            getPropertyV(WSNy,&my);
          }
          long px = point->x + mx;
          long py = point->y + my;
          for(i=j+1; i<num; i++){
            WSCbase* child = (WSCbase*)children[i];
            if (child->_dev == NULL){
              continue;
            }else if (child->_dev->getParentDev() == NULL){
              continue;
            }
            if (child->existProperty(WSNx)      != False && 
                child->existProperty(WSNy)      != False &&
                child->existProperty(WSNwidth)  != False &&
                child->existProperty(WSNheight) != False ){
              short x,y;
              WSCushort w,h;
              child->getPropertyV(WSNx,&x); 
              child->getPropertyV(WSNy,&y); 
              child->getPropertyV(WSNwidth,&w); 
              child->getPropertyV(WSNheight,&h); 
              if ( px >= x   && py >= y   &&
                   px < x + w && py <= y + h &&
                   child->getVisible() != False ){
                return;
              }
            }
          }
          if (WSGIappObjectList()->getNewInstancePositionMode()){
            _start_new_instance_positioning();
          }else{
            setPropertyEditExecute(True); 
          }
        }
      }
    }else{
      WSClistData children = getChildren();
      long num = children._num;
      if (num != 0){
        long i;
        for(i=0; i<num; i++){
          WSCbase* child = (WSCbase*)children[i];
          if (child->_dev == NULL){
            continue;
          }else if (child->_dev->getParentDev() == NULL){
            continue;
          }
          if (child->existProperty(WSNx)      != False && 
              child->existProperty(WSNy)      != False &&
              child->existProperty(WSNwidth)  != False &&
              child->existProperty(WSNheight) != False ){
            short x,y;
            WSCushort w,h;
            child->getPropertyV(WSNx,&x); 
            child->getPropertyV(WSNy,&y); 
            child->getPropertyV(WSNwidth,&w); 
            child->getPropertyV(WSNheight,&h); 
            if ( point->x >= x   && point->y >= y  &&
                 point->x < x + w && point->y <= y + h &&
                 child->getVisible() != False ){
              return;
            }
          }
        }
      }
      if (WSGIappObjectList()->getNewInstancePositionMode()){
        _start_new_instance_positioning();
      }else{
        setPropertyEditExecute(True); 
      }
    }
  }
#endif
}
void WSCbase::onMouseDoubleClick(WSCpoint*){ }

void WSCbase::onMouseRelease(WSCpoint*){
#ifndef WS_EMBED
#if 0
  if (WSGIappObjectList()->getNewInstancePositionMode()){
    if (_target_site != NULL){
      _target_site->_stop_new_instance_positioning();
    }
    _target_site = NULL;
  }
#endif
#endif
}
void WSCbase::onExpose(WSCrect*){}
void WSCbase::onDataSave(WSDserialize* ){}
void WSCbase::onDataLoad(WSDserialize* ){}
void WSCbase::onGuiPolicyChange(long policy){
  execProcedure(WSEV_GUI_POLICY_CH);
}
void WSCbase::onDefaultColorChange(){}

void WSCbase::onVisibleChange(WSCbool fl){
  WSDdev* dev = getowndev();
  if (fl != False){
    if (dev == NULL){
      if (getParentVisible() == True){
        WSDdev* new_dev = attachdev();
        if (new_dev != NULL){
          new_dev->setEnableEventBit(_event_mask);
          new_dev->setVisible(True);
          setAbsoluteDraw(True);
          needUpdate();
        }
      }
    }else{
      dev->setVisible(True);
    }
  }else{
    if (dev != NULL){
      dev->setVisible(False);
    }
  }
}
void WSCbase::onSensitiveChange(WSCbool){
  setAbsoluteDraw(True);
  needUpdate();
}
void WSCbase::onParentVisibleChange(WSCbool fl){
  if (fl != False && _vis != False){
    WSDdev* dev = getowndev();
    if (dev == NULL){ 
      dev = attachdev();
    }
    if (dev != NULL){
      dev->setEnableEventBit(_event_mask);
      dev->setVisible(True);
      setAbsoluteDraw(True);
      needUpdate();
#ifndef WS_EMBED
      if ( _show_grip_hand != False){
        clearGriphand();
        drawGriphand();
      }
#endif
    }
  }
}
void WSCbase::onParentSensitiveChange(WSCbool){}
void WSCbase::setUserLongData(char* name,WSCulong data){
  setUserData(name,(void*)data);
}
#define WS_USER_DATA_SEG_SIZE 4
void WSCbase::setUserData(const char* name,void* data){
  if (_num_of_user_data != 0){
    long i;
    for(i= 0; i < _num_of_user_data; i++){
      if (name[0] == _user_data_list[i*2][0] &&
          !WSIFstrcmp(name,_user_data_list[i*2])){
         _user_data_list[i*2+1] = (char*)data;
         return;
      }
    }
  }
  if (_num_of_st_user_data == 0){
    _user_data_st_list = new char*[WS_USER_DATA_SEG_SIZE*2];
    _num_of_st_user_data++;
    _user_data_st_list[0] = (char*)name;
    _user_data_st_list[1] = (char*)data;
    return;
  }
  long i;
  for(i= 0; i < _num_of_st_user_data; i++){
    if (name[0] == _user_data_st_list[i*2][0] &&
        !WSIFstrcmp(name,_user_data_st_list[i*2])){
       _user_data_st_list[i*2+1] = (char*)data;
       return;
    }
  }
  if (_num_of_st_user_data % WS_USER_DATA_SEG_SIZE == 0){
    long size = (_num_of_st_user_data/WS_USER_DATA_SEG_SIZE+1)*WS_USER_DATA_SEG_SIZE;
    char** newlist = new char*[size*2];

    if (_num_of_st_user_data != 0){
      memcpy( newlist,_user_data_st_list,
              (size_t)(sizeof(char*)*_num_of_st_user_data*2));
      delete[] _user_data_st_list;
    }
    _user_data_st_list      = newlist;
  }
  _user_data_st_list[_num_of_st_user_data*2] = (char*)name;
  _user_data_st_list[_num_of_st_user_data*2+1] = (char*)data;
  _num_of_st_user_data++;
  return;
}

void WSCbase::setUserData(char* name,void* data){
  if (_num_of_st_user_data != 0){
    long i;
    for(i= 0; i < _num_of_st_user_data; i++){
      if (name[0] == _user_data_st_list[i*2][0] &&
          !WSIFstrcmp(name,_user_data_st_list[i*2])){
         _user_data_st_list[i*2+1] = (char*)data;
         return;
      }
    }
  }
  if (_num_of_user_data == 0){
    _user_data_list = new char*[WS_USER_DATA_SEG_SIZE*2];
    _num_of_user_data++;
    _user_data_list[0] = WSIFstrdup(name);
    _user_data_list[1] = (char*)data;
    return;
  }
  long i;
  for(i= 0; i < _num_of_user_data; i++){
    if (name[0] == _user_data_list[i*2][0] &&
        !WSIFstrcmp(name,_user_data_list[i*2])){
       _user_data_list[i*2+1] = (char*)data;
       return;
    }
  }
  if (_num_of_user_data % WS_USER_DATA_SEG_SIZE == 0){
    long size = (_num_of_user_data/WS_USER_DATA_SEG_SIZE+1)*WS_USER_DATA_SEG_SIZE;
    char** newlist = new char*[size*2];

    if (_num_of_user_data != 0){
      memcpy( newlist,_user_data_list,
              (size_t)(sizeof(char*)*_num_of_user_data*2));
      delete[] _user_data_list;
    }
    _user_data_list      = newlist;
  }
  _user_data_list[_num_of_user_data*2] = WSIFstrdup(name);
  _user_data_list[_num_of_user_data*2+1] = (char*)data;
  _num_of_user_data++;
  return;
}

WSCulong WSCbase::getUserLongData(char* name){
  return (WSCulong)getUserData(name);
}
void WSCbase::setUserStringData(char* name,char* val){
  char* ret = (char*)getUserData(name);
  if (ret != NULL){
    delete[] ret;
  }
  setUserData(name,WSGFstrdup(val));
}
char* WSCbase::getUserStringData(char* name){
  char* ret = (char*)getUserData(name);
  if (ret != NULL){
    return ret;
  }
  return "";
}

void* WSCbase::getUserData(char* name){
  if (name == NULL){
    return NULL;
  }
  int i;
  for(i= 0; i < _num_of_st_user_data; i++){
    if (name[0] == _user_data_st_list[i*2][0] &&
        !WSIFstrcmp(name,_user_data_st_list[i*2])){
      return (void*)_user_data_st_list[i*2+1];
    }
  }
   if (_num_of_user_data == 0){
    return NULL;
  }
  for(i= 0; i < _num_of_user_data; i++){
    if (name[0] == _user_data_list[i*2][0] &&
        !WSIFstrcmp(name,_user_data_list[i*2])){
      return (void*)_user_data_list[i*2+1];
    }
  }
  return NULL;
}
#ifndef NO_INDEX_VARIANT_DATA
void WSCbase::setVariantData(char* name,WSCvariant data){
  if (_variant_list == NULL){
    _variant_list = new WSCindexVariantData;
  }
  _variant_list->setData(name,data);
}
WSCvariant& WSCbase::getVariantData(char* name){
  if (_variant_list == NULL){
    _variant_list = new WSCindexVariantData;
  }
  return _variant_list->getData(name);
}
#endif
WSCbase* WSCbase::getFocusMoveInstance(long direction){
  WSCbase* target = _get_focus_move_instance(direction);
  if (target == NULL){
    return NULL;
  }
  if (target->getSensitive() == False){
    return NULL;
  }
  if (target->canFocus() == False){
    return NULL;
  }
  WSCbase* target2 = target->getFocusMoveInternalInstance(direction);
  if (target2 != NULL){
    return target2;
  }
  return target;
}
WSCbase* WSCbase::_get_focus_move_instance(long direction,WSCbool retry,WSCbase* orig){
  if (getParent() == NULL){
    return NULL;
  }

  short     x=0,y=0;
  WSCushort w=0,h=0;
  short     dx,dy;
  WSCushort dw,dh;
  long work1,work2,hit_work;
  WSCulong tmp_distance;

  if (existProperty(WSNx) != False){
    getPropertyV(WSNx,&x);
  }
  if (existProperty(WSNy) != False){
    getPropertyV(WSNy,&y);
  }
  if (existProperty(WSNwidth) != False){
    getPropertyV(WSNwidth,&w);
  }
  if (existProperty(WSNheight) != False){
    getPropertyV(WSNheight,&h);
  }

  WSCbase* target = NULL;
  char* prop = WSNupward;
  if (direction == WS_DOWN){
    prop = WSNdownward;
  }else if (direction == WS_RET){
    prop = WSNreturn;
  }else if (direction == WS_LEFT){
    prop = WSNleftward;
  }else if (direction == WS_RIGHT){
    prop = WSNrightward;
  }else if (direction == WS_TAB){
    prop = WSNtab;
  }else if (direction == WS_STAB){
    prop = WSNbacktab;
  }
  if (existProperty(prop) != False){
    char* dest;
    WSCbool fl = getPropertyV(prop,&dest);
    if ( fl != False && dest != 0 && dest[0] != 0){
      WSCstring str(dest);
      WSCbase* cparent = (WSCbase*)getUserData(WS_BASE_CPTR);
      if (getInternalObject() != False){
        WSCbase* _this = this;
        while((_this->getInternalObject() != False) && cparent == NULL){
          _this = _this->getParent();
          if (_this == NULL){
            break;
          }
          cparent = (WSCbase*)_this->getUserData(WS_BASE_CPTR);
        }
      }
      long num = str.getWords(",");
      long i=0;
      for(i=0; i<num; i++){
        WSCstring tname = str.getWord(i,",");
        tname.delHeadSpace();
        tname.delTailSpace();
        target = NULL;
        if (cparent != NULL){
          target = cparent->getChildInstance(tname.getString());
          if (target == NULL && !strcmp(cparent->getClassName(),tname.getString())){
            target = cparent;
          }
        }
        if (target == NULL){
          target =  WSGIappObjectList()->getInstance("WSCbase",tname.getString());
        }
        if (target != NULL && target->getVisible() != False &&
            target->getSensitive() != False && target->canFocus() != False){
          return target;
        }
      }
      for(i=0; i<num; i++){
        WSCstring tname = str.getWord(i,",");
        tname.delHeadSpace();
        tname.delTailSpace();
        target = NULL;
        if (cparent != NULL){
          target = cparent->getChildInstance(tname.getString());
          if (target == NULL && !strcmp(cparent->getClassName(),tname.getString())){
            target = cparent;
          }
        }
        if (target == NULL){
          target =  WSGIappObjectList()->getInstance("WSCbase",tname.getString());
        }
        if (target != NULL && (target->getVisible() == False ||
            target->getSensitive() == False || target->canFocus() == False)){
          WSCbase* ret = NULL;
          if (orig == NULL){
            ret = target->_get_focus_move_instance(direction,retry,this);
            if (ret != NULL && ret != this){
              return ret;
            }
          }else{
            if (orig != this){
              ret = target->_get_focus_move_instance(direction,retry,orig);
            }
            if (ret != NULL){
              return ret;
            }
          }
        }
      }
    }
  }

  long i;
  WSClistData* list = (WSClistData*)getParent()->getUserData("FOCUS_LIST");
  if (list == NULL){
    return NULL;
  }
  long num = list->_num;
  if (num < 2){
    return NULL;
  }
  long distance = -1;
  if (direction == WS_UP){
    if (retry != False){
      x = 32767;
    }
    for(i=0; i < num; i++){
      WSCbase* base = (WSCbase*)(*list)[i];
      if (base == this || base->getVisible() == False ||
          base->getSensitive() == False ||
          base->canFocus() == False){
	    continue;
	  }
      base->getPropertyV(WSNy,&dy);
      base->getPropertyV(WSNheight,&dh);
      if (dy + dh  > y ){
	    continue;
      }
      base->getPropertyV(WSNx,&dx);
      base->getPropertyV(WSNwidth,&dw);

      if (dx > x) {
        work1 = (long)dx;
      }else{
        work1 = (long)x;
      }
      if (dx + dw  > x + w) {
        work2 = (long)x +w;
      }else{
        work2 = (long)dx +dw;
      }

      hit_work = work2 - work1; 
      if (hit_work > 0){
        tmp_distance = (y - dy - dh)*(y - dy -dh);
      }else{
        tmp_distance = (y - dy - dh)*(y - dy -dh) + (dx -x)*(dx -x);
      }
      if (tmp_distance < distance || tmp_distance == 0 || distance == -1){
        target = base;
        distance = tmp_distance;
      }
    }
  }else if (direction == WS_DOWN || direction == WS_RET){
    if (retry != False){
      x = 0;
    }
    for(i=0; i < num; i++){
      WSCbase* base = (WSCbase*)(*list)[i];
      if (base == this || base->getVisible() == False ||
          base->getSensitive() == False ||
          base->canFocus() == False){
	    continue;
      }
      base->getPropertyV(WSNy,&dy);
      if (dy  < y +h){
	    continue;
      }
      base->getPropertyV(WSNx,&dx);
      base->getPropertyV(WSNwidth,&dw);
      if (dx > x) {
        work1 = (long)dx;
      }else{
        work1 = (long)x;
      }
      if (dx + dw  > x + w) {
        work2 = (long)x +w;
      }else{
        work2 = (long)dx +dw;
      }
      hit_work = work2 - work1; 
//      tmp_distance = dy - y - h;
      if (hit_work > 0){
        tmp_distance = (dy - y -h)*(dy - y -h);
      }else{
        tmp_distance = (dy - y -h)*(dy - y -h) + (dx -x)*(dx -x);
      }
 //     if (hit_work > 0){
        if (tmp_distance < distance || tmp_distance == 0 || distance == -1){
          target = base;
          distance = tmp_distance;
        }
//      }
    }
  }else if (direction == WS_LEFT || direction == WS_STAB){
    for(i=0; i < num; i++){
      WSCbase* base = (WSCbase*)(*list)[i];
      if (base == this || base->getVisible() == False ||
          base->getSensitive() == False ||
          base->canFocus() == False){
        continue;
      }
      base->getPropertyV(WSNx,&dx);
      base->getPropertyV(WSNwidth,&dw);
      if (dx + dw > x +1){
        continue;
      }
      base->getPropertyV(WSNy,&dy);
      base->getPropertyV(WSNheight,&dh);
      if (dy > y) {
        work1 = (long)dy;
      }else{
        work1 = (long)y;
      }
      if (dy + dh  > y + h) {
        work2 = (long)y +h;
      }else{
        work2 = (long)dy +dh;
      }
      hit_work = work2 - work1; 
      tmp_distance = x - dx - dw;
      if (hit_work > 0){
        if (tmp_distance < distance || tmp_distance == 0 || distance == -1){
          target = base;
          distance = tmp_distance;
        }
      }
    }
  }else if (direction == WS_RIGHT || direction == WS_TAB){
    for(i=0; i < num; i++){
      WSCbase* base = (WSCbase*)(*list)[i];
      if (base == this || base->getVisible() == False ||
          base->getSensitive() == False ||
          base->canFocus() == False){
        continue;
      }
      base->getPropertyV(WSNx,&dx);
      if ( x +w > dx){
        continue;
      }
      base->getPropertyV(WSNy,&dy);
      base->getPropertyV(WSNheight,&dh);
      if (dy > y) {
        work1 = (long)dy;
      }else{
        work1 = (long)y;
      }
      if (dy + dh  > y + h) {
        work2 = (long)y +h;
      }else{
        work2 = (long)dy +dh;
      }
      hit_work = work2 - work1; 
      tmp_distance = dx - x - w;
      if (hit_work > 0){
        if (tmp_distance < distance || tmp_distance == 0 || distance == -1){
          target = base;
          distance = tmp_distance;
        }
      }
    }
  }
  if (direction == WS_TAB && target == NULL){
    return _get_focus_move_instance(WS_DOWN,True);
  }
  if (direction == WS_STAB && target == NULL){
    return _get_focus_move_instance(WS_UP,True);
  }
  return target;
}

void WSCbase::setCreateHandler(char* cname,WSCbase* (*hd)(WSCbase*,char* )){
  if (_create_proc_list == NULL){
    _create_proc_list = new WSClistData(64);
    _cname_list = new WSClistData(64);
  }
  long num = _cname_list->_num;
  long i;
  char** strs = (char**)_cname_list->_data;
  for(i=0; i<num; i++){
    char* str = strs[i];
    if (!WSIFstrcmp(str,cname)){
       _create_proc_list->setData(i,(void*)hd);
       return;
    }
  }
  _create_proc_list->add((void*)hd);
//  _cname_list->add((void*)WSIFstrdup(cname));
  _cname_list->add((void*)cname);
}

WSClistData* WSCbase::getSupportedClassList(){
  static WSClistData _ret;
  _ret.clear();
  long i;
  long num = _cname_list->_num;
  for(i=0; i<num; i++){
    WSCbase* (*hd)(WSCbase*,char*);
    hd = (WSCbase*(*)(WSCbase*,char*))(*_create_proc_list)[i];
    if (hd != NULL){
      _ret.add( (*_cname_list)[i] );
    }
  }
  return &_ret;
}
WSCbase* WSCbase::getNewInstance(char* cname,WSCbase* parent,char* name){
  if (_create_proc_list == NULL){
    return NULL;
  }
  long i;
  long num = _create_proc_list->_num;
  void** buf = (void**)_create_proc_list->_data;
  char** names = (char**)_cname_list->_data;
  for(i=0; i<num; i++){
    if (!WSIFstrcmp(names[i],cname)){
      WSCbase* (*hd)(WSCbase*,char*);
      hd = (WSCbase*(*)(WSCbase*,char*))buf[i];
      if (hd != NULL){
        return hd(parent,name);
      }else{
        return NULL;
      }
    }
  }
  if (_create_instance_handler != NULL){
    return _create_instance_handler(cname,parent,name);
  }

  return NULL;
}
long WSCbase::setOrder(char direct){
  WSCbase* parent = getParent();
  if (parent == NULL){
    return WS_ERR;
  }
  WSClistData children = getParent()->getChildren();
  long num = children._num;
  long i;
  for(i=0; i<num ; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child == this){
      if (direct != WS_TOP){
        getParent()->getChildren().delPos(i);
        getParent()->getChildren().add((void*)this);
      }else{
        getParent()->getChildren().delPos(i);
        getParent()->getChildren().add((void*)this,0);
      }
      break;
    }
  }
  WSDdev* dev = _dev;
  if (dev != NULL){
    dev->setEventOrder(dev,direct);
  }
  return WS_NO_ERR;
}
WSCbase* WSCbase::getChildInstance(char* oname){
  if (_instance_name != NULL && oname[0] == _instance_name[0] && !strcmp(oname,_instance_name)){
    return this;
  }
  WSClistData children = getChildren();
  long num = children._num;
  long i;
  WSCbase** buf = (WSCbase**)children._data;
  for(i=0; i < num; i++){
    WSCbase* child = buf[i];
    WSCbase* ret = child->getChildInstance(oname);
    if (ret != NULL){
      return ret;
    }
  }
  return NULL;
}
long WSCbase::getAllChildren(WSClistData& list){
  WSClistData* children = getChildrenPtr();
  if (children == NULL){
    return WS_NO_ERR;
  }
  long num = children->_num;
  long i;
  WSCbase** children_list = (WSCbase**)children->_data;
  for(i=0; i<num; i++){
    WSCbase* child = children_list[i];
    list.add((void*)child);
#if 0 //for optimizing..
    WSClistData tmplist;
    child->getAllChildren(tmplist);
    long j;
    long cnum = tmplist.getNum();
    for(j=0; j<cnum; j++){
      list.add(tmplist[j]);
    }
#else
    child->getAllChildren(list);
#endif
  }
  return WS_NO_ERR;
}
WSCbool WSCbase::getMouseAddr(short* x,short* y){
  return WSGIappMouse()->getMousePosition(x,y,this);
}
long WSCbase::getInstanceNameHashValue(){
  return _name_hash_value;
}
char* WSCbase::getUseDevName(){
  return NULL;
}

WSCbase* WSCbase::getFocusInstance(){
  return _focus_instance;
}
WSCbase* WSCbase::getSpecialFocusInstance(){
  return _special_focus_instance;
}

long WSCbase::setFocus(WSCbool fl){
  if (fl != False){
    WSCbase* focus_lost_instance = NULL;
    if (_focus_instance != NULL){
      if (_focus_instance != this){
        focus_lost_instance = _focus_instance;
        _focus_instance = NULL;
        focus_lost_instance->onFocusChange(False);
        focus_lost_instance->execProcedure(WSEV_FOCUS_CH);
      }
    }
    if (_focus_instance != this){
      _focus_instance = this;
      onFocusChange(fl);
      execProcedure(WSEV_FOCUS_CH);
      if (focus_lost_instance != NULL && getObjectType() & WS_TYPE_MANAGER){
        WSClistData children(64);
        getAllChildren(children);
        long num = children._num;
        long i;
        WSCbase** buf = (WSCbase**)children._data;
        for(i=0; i<num; i++){
          WSCbase* child = buf[i];
          if (child == focus_lost_instance){
            focus_lost_instance->setFocus(True);
            break;
          }
        }
      }
      return WS_NO_ERR;
    }
 
  }else{
    if (_focus_instance == this){
      _focus_instance = NULL;
      onFocusChange(fl);
      execProcedure(WSEV_FOCUS_CH);
    }
  }
  return WS_NO_ERR;
}

long WSCbase::setSpecialFocus(WSCbool fl){
  if (fl != False){
    WSCbase* focus_lost_instance = NULL;
    if (_special_focus_instance != NULL){
      if (_special_focus_instance != this){
        focus_lost_instance = _special_focus_instance;
        _special_focus_instance = NULL;
        focus_lost_instance->onSpecialFocusChange(False);
//        focus_lost_instance->execProcedure(WSEV_FOCUS_CH);
      }
    }
    if (_special_focus_instance != this){
      _special_focus_instance = this;
      onSpecialFocusChange(fl);
//      execProcedure(WSEV_FOCUS_CH);
      if (focus_lost_instance != NULL && getObjectType() & WS_TYPE_MANAGER){
        WSClistData children;
        getAllChildren(children);
        long num = children._num;
        long i;
        WSCbase** buf = (WSCbase**)children._data;
        for(i=0; i<num; i++){
          WSCbase* child = buf[i];
          if (child == focus_lost_instance){
            focus_lost_instance->setSpecialFocus(True);
            break;
          }
        }
      }
      return WS_NO_ERR;
    }
 
  }else{
    if (_special_focus_instance == this){
      _special_focus_instance = NULL;
      onSpecialFocusChange(fl);
//      execProcedure(WSEV_FOCUS_CH);
    }
  }
  return WS_NO_ERR;
}



WSCbool WSCbase::getFocus(){
  if (_focus_instance == this){
    return True;
  }else{
    return False;
  }
  return False;
}
WSCbool WSCbase::getSpecialFocus(){
  if (_special_focus_instance == this){
    return True;
  }else{
    return False;
  }
  return False;
}

void WSCbase::setChildren(WSClistData&){
}
WSCbase* WSCbase::getPropertyInheritChild(){
  return NULL;
}
WSClistData& WSCbase::getChildren(){
static WSClistData tmp;
  tmp.clear();
  return tmp;
}
WSClistData* WSCbase::getChildrenPtr(){
  return NULL;
}
WSCbool WSCbase::existTrigger(long trg){
  return _own_class_info->existTrigger(trg);
}
WSCindexData* WSCbase::getExtTriggerList(){
  return _own_class_info->getAllExtTriggerList();
}
void WSCbase::setInstanceName(char* name){
  setInstanceNameNC(WSGFstrdup(name));
}
void WSCbase::setInstanceNameNC(char* name){
  if (_instance_name != NULL){
    delete[] _instance_name;
    _instance_name = NULL;
  }
  if (name == NULL){
    name = "none";
  }
  _instance_name = name;
  _name_hash_value = WSGFgetHashValue(name);
}
char* WSCbase::getInstanceName(){
  if (_instance_name == NULL){
    return "";
  }
  return _instance_name;
}
long WSCbase::draw(){
  return WS_NO_ERR;
}

long WSCbase::cdraw(){
  return WS_NO_ERR;
}

WSCbool WSCbase::getDotMode(){
#ifndef WS_EMBED
  return _property_edit_mode;
#else
  return False;
#endif
}
void WSCbase::setScaleOffsetPtr(double* ptr){
  if (_scale_ptrs == NULL){
    _scale_ptrs = new void*[3];
    _scale_ptrs[0] = NULL;
    _scale_ptrs[1] = NULL;
    _scale_ptrs[2] = NULL;
  }
  _scale_ptrs[2] = ptr;
  if (_dev != NULL){
    _dev->setValue(WSDEV_SCALE_OFFSET,_scale_ptrs[2]);
  }
}
void WSCbase::setXOffsetPtr(short* ptr){
  if (_scale_ptrs == NULL){
    _scale_ptrs = new void*[3];
    _scale_ptrs[0] = NULL;
    _scale_ptrs[1] = NULL;
    _scale_ptrs[2] = NULL;
  }
  _scale_ptrs[0] = ptr;
  if (_dev != NULL){
    if( !(getObjectType() &WS_TYPE_WINDOW )){
      _dev->setValue(WSDEV_X_OFFSET,_scale_ptrs[0]);
    }
  }
}
void WSCbase::setYOffsetPtr(short* ptr){
  if (_scale_ptrs == NULL){
    _scale_ptrs = new void*[3];
    _scale_ptrs[0] = NULL;
    _scale_ptrs[1] = NULL;
    _scale_ptrs[2] = NULL;
  }
  _scale_ptrs[1] = ptr;
  if (_dev != NULL){
    if( !(getObjectType() &WS_TYPE_WINDOW )){
      _dev->setValue(WSDEV_Y_OFFSET,_scale_ptrs[1]);
    }
  }
}
double* WSCbase::getScaleOffsetPtr(){
  if (_scale_ptrs != NULL){
    return (double*)_scale_ptrs[2];
  }
  return NULL;
}
short* WSCbase::getXOffsetPtr(){
  if (_scale_ptrs != NULL){
    return (short*)_scale_ptrs[0];
  }
  return NULL;
}
short* WSCbase::getYOffsetPtr(){
  if (_scale_ptrs != NULL){
    return (short*)_scale_ptrs[1];
  }
  return NULL;
}
#ifndef WS_EMBED
WSCbool WSCbase::getPropertyEditMode(){
  return _property_edit_mode;
}
#endif
WSCbool WSCbase::isNeedUpdate(){
  return _update_registered;
}
void WSCbase::_register_focus_move(){
  if (_parent == NULL){
    return;
  }
  WSClistData* list = (WSClistData*)_parent->getUserData("FOCUS_LIST");
  if (list == NULL){
    list = new WSClistData(16);
    _parent->setUserData("FOCUS_LIST",list);
  }
  list->add(this);
}
void WSCbase::setInternalObject(WSCbool fl){
  _internal_object = fl;
}
WSCbool WSCbase::getInternalObject(){
  return _internal_object;
}
long WSCbase::getObjectType(){
  return 0;
}
long WSCbase::getVer(long ver){
  return ver;
}
long WSCbase::checkVersion(long ver){
  if (ver/10 == getVer()/10){
    return 1;
  }
WSMFtrace("VERSION error. WSCbase object_version=%d, This WSCbase object_version=%d\n",WSCbase_VER,ver);
fprintf(stderr,"VERSION error. WSCbase object_version=%d, This WSCbase object_version=%d\n",WSCbase_VER,ver);
  return 0;
}
WSDdev* WSCbase::attachdev(){
  if(_dev == NULL){
    WSDdev* dev = WSGIappDevice()->getDevObject(getUseDevName());
    if (dev != NULL){
      setdev(dev);
    }
  }
  return _dev;
}

void WSCbase::onSelectionChange(WSCbool fl){
  execProcedure(WSEV_SELECTION_CH);
}
char* WSCbase::getDefaultProperty(){
  return "";
}
void WSCbase::setGeometryChanged(WSCbool fl){
  _geometry_changed = fl;
}
WSCbool WSCbase::isParent(WSCbase* inst){
  WSCbase* parent = getParent();
  while(1){
    if (parent == NULL){
      return False;
    }
    if (parent == inst){
      return True;
    }
    parent = parent->getParent();
  }
}

#ifndef NO_REMOTE_INSTANCE
void WSCbase::setExported(WSCbool fl){
  if (_export_bk == False){
    if (fl != False){
      WSGIappObjectList()->addExportInstanceUpdateList(this);
    }
  }else{
    if (fl == False){
      WSGIappObjectList()->addExportInstanceDeleteList(this);
    }
  }
  _export_ = fl;
  _export_bk = fl;
}
WSCbool WSCbase::getExported(){
  return _export_;
}

void WSCbase::setExportName(char* name){
  char* ename = (char*)getUserData("export-name");
  if (ename != NULL){
    delete[] ename;
  }
  setUserData("export-name",WSIFstrdup(name));
}
char* WSCbase::getExportName(){
  char* ename = (char*)getUserData("export-name");
  if (ename != NULL){
    return ename;
  }
  return "";
}
#endif
WSCbase* (*WSCbase::_create_instance_handler)(char*,WSCbase*,char*) = NULL;
void WSCbase::setCreateInstanceHandler(WSCbase* (*hd)(char*,WSCbase*,char*)){
  _create_instance_handler = hd;
}
WSCbool WSCbase::adjustAnchor(){
  return True;
}

#ifndef WS_EMBED
long WSCbase::addProcedure(char* pname,char* fname,long ev){
  WSCprocedure* op = new WSCprocedure(pname,ev);
  op->setFunction(NULL,fname);
  addProcedure(op); 
  return (long)op;
}
long WSCbase::delProcedure(long id){
  WSCprocedure* op = (WSCprocedure*)id;
  long ret = delProcedure(op);
  delete op;
  return ret;
}
#endif
long WSCbase::addProcedureV(char* pname,char* fname,void (*hd)(WSCbase*),long ev){
  WSCprocedure* op = new WSCprocedure(pname,ev);
  op->setFunction(hd,fname);
  addProcedure(op); 
  return WS_NO_ERR;
}
void WSCbase::internalUpdate(){
}
#ifndef NO_RESTACK_CHILD
long WSCbase::restackChild(WSCbase*,int){
  return WS_ERR;
}
#endif
WSCbase* WSCbase::getNextChild(WSCbase* child){
  WSClistData* children = getChildrenPtr();
  if (children == NULL){
    return NULL;
  }
  long num = children->_num;
  WSCbase** children_buf = (WSCbase**)children->_data;
  WSCbase* ret = NULL; 
  if (child == NULL){
    if (num == 0){
      return NULL;
    }
    ret = children_buf[0];
    return ret;
  }
  long i;
  for(i=0; i<num-1; i++){
    WSCbase* item = children_buf[i];
    if (child == item){
      ret = children_buf[i+1];
      return ret;
    }
  }
  return ret;
}
WSCbool WSCbase::canBurstCast(void* ptr){
#ifndef NO_BURST_CAST
  if (ptr == (void*)this){
//printf("WSCbase::canBurstCast  can burst cast!\n");
    return True;
  }
#endif
  return False;
}
WSCbool WSCbase::canFocus(){
  return True;
}
WSCbase* WSCbase::getFocusMoveInternalInstance(long){
  return NULL;
}
