//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCclassInformation.h>
#include <WSCbaseList.h>
#include <WSCbase.h>
#include <WSClistData.h>
#include <WSCRbaseList.h>
#include <WSDappDev.h>

class WSCbaseArray{
 public:
  WSCbaseArray(char*);
  ~WSCbaseArray();
  long        _hash_value;
  char*       _cname;
  WSClistData _base_list;
  long     getNum();
  void     addItem(WSCbase*);
  void     delItem(WSCbase* );
  WSCbase* getItem(char* );
};
static WSCbaseList* _the_app_base_list = NULL;
WSCbaseList::WSCbaseList(){
  _search_handler = NULL;
  _base_list = new WSClistData(128);
  _need_update = new WSClistData(1024);
  _need_init = new WSClistData(1024);
#ifndef NO_REMOTE_INSTANCE
  _remote_data_list_updated = False;
#endif
#ifndef WS_EMBED
  _event_proc_handler = NULL;
  _instance_position_mode = False;
#endif
}
WSCbaseList::~WSCbaseList(){
  long i;
  long num = _base_list->getNum();
  for(i=0; i < num; i++){
    WSCbaseArray* base_array = (WSCbaseArray*)(*_base_list)[i];
    delete base_array;
  }
  _base_list->clear();
  delete _base_list;
  delete _need_update;
  delete _need_init;
#ifndef WS_EMBED
  delAllEventProc();
#endif
}
#ifndef WS_EMBED
void WSCbaseList::setNewInstancePositionMode(WSCbool fl){
  _instance_position_mode = fl;
}
WSCbool WSCbaseList::getNewInstancePositionMode(){
  return _instance_position_mode;
}
void WSCbaseList::setNewInstanceClassName(char* cname){
  _instance_position_cname = cname;
}
WSCstring WSCbaseList::getNewInstanceClassName(){
  return _instance_position_cname;
}
#endif
WSClistData* WSCbaseList::getInstanceList(char* cname){
  long i;
  long hvalue = WSGFgetHashValue(cname);
  long num = _base_list->getNum();
  for(i=0; i<num; i++){
    WSCbaseArray* base_array = (WSCbaseArray*)(*_base_list)[i];
    if (base_array->_hash_value == hvalue && !strcmp(base_array->_cname,cname)){
      return &base_array->_base_list;
    }
  }
  return NULL;
}
WSCbaseList* WSGIappObjectList(){
  if (_the_app_base_list == NULL){
    _the_app_base_list = new WSCbaseList();
  }
  return _the_app_base_list;
}
static WSCbase* _user_data_ = NULL;
void WSCbaseList::setUserData(char* name,void* data){
  if (_user_data_ == NULL){
    _user_data_ = new WSCbase(NULL,"_user_data_");
	_user_data_->initialize();
  }
  _user_data_->setUserData(name,data);
}
void* WSCbaseList::getUserData(char* name){
  if (_user_data_ != NULL){
    return _user_data_->getUserData(name);
  }
  return NULL;
}
void WSCbaseList::setUserLongData(char* name,WSCulong data){
  setUserData(name,(void*)data);
}
WSCulong WSCbaseList::getUserLongData(char* name){
  return (WSCulong)getUserData(name);
}
void WSCbaseList::setUserStringData(char* name,char* val){
  char* ret = (char*)getUserData(name);
  if (ret != NULL){
    delete[] ret;
  }
  setUserData(name,WSGFstrdup(val));
}
char* WSCbaseList::getUserStringData(char* name){
  char* ret = (char*)getUserData(name);
  if (ret != NULL){
    return ret;
  }
  return "";
}

WSClistData* WSCbaseList::getClassList(){
  return _base_list;
}
void WSCbaseList::addClient(WSCbase* client,void* base_array){
  //ok,it was initialized list in classinfo 
  if (base_array != NULL){
    WSCbaseArray* barray = (WSCbaseArray*)base_array;
    barray->addItem(client);
  }else{
    WSCclassInformation* inf = client->getClassInformation();
    WSCbaseArray* new_base_list = new WSCbaseArray(client->getClassName());
    new_base_list->addItem(client);
    _base_list->add( (void*) new_base_list );
    inf->setClassInstanceList((void*)new_base_list);
  }
}
void WSCbaseList::delClient(WSCbase* client,void* base_array){
  //delete from update list
  long i;
  long num = _need_update->getNum();
  for(i=0; i <num; i++){
    WSCbase* base = (WSCbase*)(*_need_update)[i];
    if (base == client){
      _need_update->delPos(i);
      num = _need_update->getNum();
      i--;
    }
  }
  //delete from initialize list
  num = _need_init->getNum();
  for(i=0; i <num; i++){
    WSCbase* base = (WSCbase*)(*_need_init)[i];
    if (base == client){
      _need_init->delPos(i);
      num = _need_init->getNum();
      i--;
    }
  }
  //delete from instance list
  WSCbaseArray* barray = (WSCbaseArray*)base_array;
  if (barray != NULL){
    barray->delItem(client);
  }else{
    WSCclassInformation* inf = client->getClassInformation();
    WSCbaseArray* barray2 = (WSCbaseArray*)inf->getClassInstanceList();
    if (barray2 != NULL){
      barray2->delItem(client);
    }
  }
}
WSCbase* WSCbaseList::searchInstance(char* cname,char* iname){
  if (_search_handler == NULL){
    return getInstance(cname,iname);
  }
  WSCbase* (*hd)(char*,char*) = (WSCbase* (*)(char*,char*))_search_handler;  
  return hd(cname,iname);
}
void WSCbaseList::setSearchInstanceHandler(void* hd){
  _search_handler = hd;
}

WSCbool WSCbaseList::existInstance(WSCbase* ptr){
  long num = _base_list->getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbaseArray* base_array = (WSCbaseArray*)(*_base_list)[i];
    long num2 = base_array->getNum();
    long j;
    for(j=0; j < num2;j++){
      WSCbase* base = (WSCbase*)base_array->_base_list[j];
      if (base == ptr){
        return True;
      }
    }
  }
  return False;
}

WSCbase* WSCbaseList::getInstance(char* cname,char* iname){
  long hvalue = WSGFgetHashValue(cname);
  int i;
  int num = _base_list->getNum();
  if (!strcmp(cname,"WSCbase")){
    for(i = 0; i < num; i++){
      WSCbaseArray* base_array = (WSCbaseArray*)(*_base_list)[i];
      WSCbase* base =  base_array->getItem(iname);
      if (base != NULL){
        return base;
      }
    }
  }else{
    for(i = 0; i < num; i++){
      WSCbaseArray* base_array = (WSCbaseArray*)(*_base_list)[i];
      if (base_array->_hash_value == hvalue &&
          !strcmp(base_array->_cname,cname)){
        return base_array->getItem(iname);
      }
    }
  }
  return NULL;
}

void WSCbaseList::execUpdate(){
  long i;
  long num = _need_update->_num;
  if (num > 1){
    if (num > WS_BASE_LIST_MAX_ARRAY){
      WSCbase** tmp_list = new WSCbase*[num];
      memcpy(tmp_list,_need_update->getBuf(),sizeof(WSCbase*)*num);
      _need_update->clear();
      for(i=0; i <num; i++){
        if (tmp_list[i]->isNeedUpdate() != False){
          tmp_list[i]->update();
        }
      }
      delete tmp_list;
    }else{
      WSCbase* _tmp_array[WS_BASE_LIST_MAX_ARRAY];
      memcpy(_tmp_array,_need_update->getBuf(),sizeof(WSCbase*)*num);
      _need_update->clear();
      for(i=0; i <num; i++){
        if (_tmp_array[i]->isNeedUpdate() != False){
          _tmp_array[i]->update();
        }
      }
    }
  }else if (num == 1){
    WSCbase* item = (WSCbase*)(*_need_update)[0];
    _need_update->clear();
    item->update();
  }
}
void WSCbaseList::addNeedUpdate(WSCbase* client){
  _need_update->add( (void*)client );
}
void WSCbaseList::execInitialize(){
dbprintf("WSCbaseList::execInitialize %s:%d start.\n",__FILE__,__LINE__);
  WSCbool fl = WSGIappDev()->getUnderExecInitialize();
  if (fl != False){
    return;
  }
  fl = WSGIappDev()->getInitializeExecuted();
  if (fl == False){
    return;
  }
  long i;
  long num = _need_init->_num;
  if (num > 0){
    WSCbase** baselist = new WSCbase*[num];
    memcpy(baselist,_need_init->getBuf(),sizeof(WSCbase*)*num);
    _need_init->clear();
    for(i=0; i <num; i++){
      baselist[i]->execProcedure(WSEV_INITIALIZE);
    }
    delete[] baselist;
  }
dbprintf("WSCbaseList::execInitialize %s:%d done.\n",__FILE__,__LINE__);
}
void WSCbaseList::addNeedInitialize(WSCbase* client){
  _need_init->add( (void*)client );
}
long WSCbaseList::countObject(char* cname){
  int i;
  long hvalue = WSGFgetHashValue(cname);
  int num = _base_list->_num;
  if (!strcmp(cname,"WSCbase")){
    return num;
  }
  WSCbaseArray** base_arrays = (WSCbaseArray**)(*_base_list)._data;
  for(i = 0; i < num; i++){
    WSCbaseArray* base_array = base_arrays[i];
    if (base_array->_hash_value == hvalue &&
        !strcmp(base_array->_cname,cname)){
      long ret = base_array->getNum();
      return ret;
    }
  }
  return 0;
}
WSCbaseArray::WSCbaseArray(char* cname){
  _cname = WSGFstrdup(cname);
  _hash_value = WSGFgetHashValue(cname);
  _base_list._seg_size = 32;
}
WSCbaseArray::~WSCbaseArray(){
  _base_list.clear();
}
long WSCbaseArray::getNum(){
  return _base_list._num;
}
void WSCbaseArray::addItem(WSCbase* item){
  _base_list.add( (void*) item );
}
void WSCbaseArray::delItem(WSCbase* item){
  _base_list.del( (void*) item );
}
WSCbase* WSCbaseArray::getItem(char* item){
  long i;
  long hvalue = WSGFgetHashValue(item); 
  long num = _base_list.getNum();
  for(i=0; i < num; i++){
    WSCbase* base = (WSCbase*)_base_list[i];
    if ( hvalue == base->getInstanceNameHashValue() &&
      !strcmp(item,base->getInstanceName()) ){
      return base;
    }
  }
  return NULL;
}
void WSCbaseList::addEvent(WSCbase* client,long ev){
  _event_list.add((void*)ev);
  _event_client_list.add((void*)client);
}
void WSCbaseList::delEvent(WSCbase* client,long ev){
  long i;
  long num = _event_list.getNum(); 
  for(i=0; i<num; i++){
    WSCbase* cl = (WSCbase*)_event_client_list[i];
    if (cl == client){
      long e = (long)_event_list[i];
      if (e == ev){
        _event_list.delPos(i);
        _event_client_list.delPos(i);
        break;
      }
    }
  }
//  _event_client_list.add((void*)client);
//  _event_list.add((void*)ev);
}
void WSCbaseList::execEvent(long ev,void* data){
  long i;
  long num = _event_list.getNum(); 
  for(i=0; i<num; i++){
    long val = (long)_event_list[i];
    if (val == ev){
      WSCbase* client = (WSCbase*)_event_client_list[i];
      long tev = (long)_event_list[i];
      if (tev == ev){
        client->execEventProc(ev,data);
      }
    }
  }
}
void WSCbaseList::execEvent(long ev){
  long i;
  long num = _event_list.getNum(); 
  for(i=0; i<num; i++){
    long val = (long)_event_list[i];
    if (val == ev){
      WSCbase* client = (WSCbase*)_event_client_list[i];
      long tev = (long)_event_list[i];
      if (tev == ev){
        client->execProcedure(ev);
      }
    }
  }
}

void WSCbaseList::execEvent(char* pname){
  long i;
  long num = _event_list.getNum(); 
  for(i=0; i<num; i++){
//    long val = (long)_event_list[i];
    WSCbase* client = (WSCbase*)_event_client_list[i];
    client->execProcedure(pname);
  }
}

#ifndef NO_REMOTE_INSTANCE
WSClistData* WSCbaseList::getRemoteInstanceList(){
  return &_remote_instance_list;
}


WSCremoteInstanceData::WSCremoteInstanceData(){
  _port = 0;
}
WSCremoteInstanceData::~WSCremoteInstanceData(){
}

void WSCremoteInstanceData::setAddr(char* addr){
  _addr = addr;
}
void WSCremoteInstanceData::setPublicInstanceName(char* iname){
  _public_instance_name = iname;
}
void WSCremoteInstanceData::setInstanceName(char* iname){
  _instance_name = iname;
}
void WSCremoteInstanceData::setClassName(char* cname){
  _class_name = cname;
}
void WSCremoteInstanceData::setPort(WSCushort port){
  _port = port;
}

WSCstring WSCremoteInstanceData::getAddr(){
  return _addr;
}
WSCstring WSCremoteInstanceData::getPublicInstanceName(){
  return _public_instance_name;
}
WSCstring WSCremoteInstanceData::getInstanceName(){
  return _instance_name;
}
WSCstring WSCremoteInstanceData::getClassName(){
  return _class_name;
}

WSCushort WSCremoteInstanceData::getPort(){
  return _port;
}

WSCbool WSCbaseList::getRemoteInstanceListUpdated(){
  return _remote_data_list_updated;
}
void WSCbaseList::setRemoteInstanceListUpdated(WSCbool fl){
  _remote_data_list_updated = fl;
}
#endif

#ifndef NO_REMOTE_INSTANCE
long WSCbaseList::addRemoteInstanceData(WSCremoteInstanceData* idata){
  long i;
  long num = _remote_instance_list.getNum();
  for(i=0; i<num; i++){
    WSCremoteInstanceData* item =
                   (WSCremoteInstanceData*)_remote_instance_list[i];
    char* pname = item->_public_instance_name;
    char* pname2 = idata->_public_instance_name;
    if (pname[0] == pname2[0] && !strcmp(pname,pname2)){
    }else{
      continue;
    }
    char* iname = item->_instance_name;
    char* iname2 = idata->_instance_name;
    if (iname[0] == iname2[0] && !strcmp(iname,iname2)){
    }else{
      continue;
    }
    char* cname = item->_class_name;
    char* cname2 = idata->_class_name;
    if (cname[0] == cname2[0] && !strcmp(cname,cname2)){
    }else{
      continue;
    }
    char* addr = item->_addr;
    char* addr2 = idata->_addr;
    if (addr[0] == addr2[0] && !strcmp(addr,addr2)){
    }else{
      continue;
    }
    if (item->_port != idata->_port){
      continue;
    }else{
//printf("WSCbaseList::addRemoteInstanceData same one exists..\n");
      return WS_NO_ERR;
    }
  }
  WSCremoteInstanceData* inst = new WSCremoteInstanceData();
  inst->_public_instance_name = idata->_public_instance_name;
  inst->_instance_name = idata->_instance_name;
  inst->_class_name = idata->_class_name;
  inst->_addr = idata->_addr;
  inst->_port = idata->_port;
  _remote_instance_list.add(inst);
//printf("WSCbaseList::addRemoteInstanceData added. %s %s %s %d\n", (char*)inst->_instance_name,(char*)inst->_class_name,(char*)inst->_addr,inst->_port);
  _remote_data_list_updated = True;
  return WS_NO_ERR;
}

long WSCbaseList::delRemoteInstanceData(WSCremoteInstanceData* idata){
  long i;
  long num = _remote_instance_list.getNum();
  for(i=0; i<num; i++){
    WSCremoteInstanceData* item =
                   (WSCremoteInstanceData*)_remote_instance_list[i];
    char* pname = item->_public_instance_name;
    char* pname2 = idata->_public_instance_name;
    if (pname[0] == pname2[0] && !strcmp(pname,pname2)){
    }else{
      continue;
    }
    char* iname = item->_instance_name;
    char* iname2 = idata->_instance_name;
    if (iname[0] == iname2[0] && !strcmp(iname,iname2)){
    }else{
      continue;
    }
    char* cname = item->_class_name;
    char* cname2 = idata->_class_name;
    if (cname[0] == cname2[0] && !strcmp(cname,cname2)){
    }else{
      continue;
    }
    char* addr = item->_addr;
    char* addr2 = idata->_addr;
    if (addr[0] == addr2[0] && !strcmp(addr,addr2)){
    }else{
      continue;
    }
    if (item->_port == idata->_port){
      continue;
    }else{
      _remote_instance_list.delPos(i);
      delete item;
      _remote_data_list_updated = True;
      return WS_NO_ERR;
    }
  }
  return WS_ERR;
}
#endif

#ifndef NO_REMOTE_INSTANCE
WSCremoteInstanceData* WSCbaseList::getRemoteInstanceData(char* pn){
  long i;
  long num = _remote_instance_list.getNum();
  for(i=0; i<num; i++){
    WSCremoteInstanceData* item =
                   (WSCremoteInstanceData*)_remote_instance_list[i];
    char* pname = item->_public_instance_name;
//printf("search WSCremoteInstanceData %d %s\n",i,pname);
    if (pname[0] == pn[0] && !strcmp(pname,pn)){
      return item;
    }else{
      continue;
    }
  }
  return NULL;
}

WSCRbase* WSCbaseList::getRemoteInstance(char* iname){
  WSCRbaseList* orb = new WSCRbaseList();
  orb->setAddr(WSGIconductor()->getAddr());
  orb->setPort(WS_DEFAULT_AGENT_PORT);
  WSCremoteInstanceData* rinst = orb->getRemoteInstanceData(iname);
  if (rinst == NULL){
    return NULL;
  }
//printf("WSCbaseList::getRemoteInstance cname=%s\n",(char*)rinst->getClassName());
//printf("WSCbaseList::getRemoteInstance pname=%s\n",(char*)rinst->getPublicInstanceName());
  if (!strcmp(rinst->getInstanceName(),"")){
    return NULL;
  }
  WSCRbase* inst = WSCRbase::getNewInstance(rinst->_class_name);
  if (inst == NULL){
    return NULL;
  }
  inst->setAddr(rinst->getAddr());
  inst->setPort(rinst->getPort());
//  inst->setClassName(rinst->getClassName());
  inst->setInstanceName(rinst->getInstanceName());
  delete rinst;
  return inst;
}
#endif

#ifndef NO_REMOTE_INSTANCE
long WSCbaseList::addExportInstanceList(WSCbase* inst){
  long num = _export_instance_list.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* item = (WSCbase*)_export_instance_list[i];
    if (item == inst){
      return WS_ERR;
    }
  }
  _export_instance_list.add((void*)inst);
  return WS_NO_ERR;
}

long WSCbaseList::delExportInstanceList(WSCbase* inst){
  long num = _export_instance_list.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* item = (WSCbase*)_export_instance_list[i];
    if (item == inst){
      _export_instance_list.delPos(i);
      return WS_NO_ERR;
    }
  }
  return WS_NO_ERR;
}

WSClistData* WSCbaseList::getExportInstanceList(){
  return &_export_instance_list;
}
long WSCbaseList::addExportInstanceUpdateList(WSCbase* inst){
  long num = _export_instance_update_list.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* item = (WSCbase*)_export_instance_update_list[i];
    if (item == inst){
      return WS_ERR;
    }
  }
  _export_instance_update_list.add((void*)inst);
  return WS_NO_ERR;
}

long WSCbaseList::delExportInstanceUpdateList(WSCbase* inst){
  long num = _export_instance_update_list.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* item = (WSCbase*)_export_instance_update_list[i];
    if (item == inst){
      _export_instance_update_list.delPos(i);
      return WS_NO_ERR;
    }
  }
  return WS_NO_ERR;
}

WSClistData* WSCbaseList::getExportInstanceUpdateList(){
  return &_export_instance_update_list;
}
long WSCbaseList::addExportInstanceDeleteList(WSCbase* inst){
  long num = _export_instance_delete_list.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* item = (WSCbase*)_export_instance_delete_list[i];
    if (item == inst){
      return WS_ERR;
    }
  }
  _export_instance_delete_list.add((void*)inst);
  return WS_NO_ERR;
}

long WSCbaseList::delExportInstanceDeleteList(WSCbase* inst){
  long num = _export_instance_delete_list.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* item = (WSCbase*)_export_instance_delete_list[i];
    if (item == inst){
      _export_instance_delete_list.delPos(i);
      return WS_NO_ERR;
    }
  }
  return WS_NO_ERR;
}

WSClistData* WSCbaseList::getExportInstanceDeleteList(){
  return &_export_instance_delete_list;
}
#endif


#ifndef NO_REMOTE_INSTANCE
void _WSCremoteInstanceData_save(WSDserialize* db,void* ptr){
//printf("WSCremoteInstanceData_save...\n");
  WSCremoteInstanceData* obj =(WSCremoteInstanceData*)ptr;
//printf("send #%s# #%s# #%s# #%s# %d\n",
//obj->_public_instance_name.getString(),
//obj->_instance_name.getString(),
//obj->_class_name.getString(),
//obj->_addr.getString(),
//obj->_port);

  db->saveData(WS_DcRString,">pn",obj->_public_instance_name.getString());
  db->saveData(WS_DcRString,">in",obj->_instance_name.getString());
  db->saveData(WS_DcRString,">cl",obj->_class_name.getString());
  db->saveData(WS_DcRString,">ad",obj->_addr.getString());
  db->saveData(WS_DcRUShort,">pt",&obj->_port);
}
void _WSCremoteInstanceData_load(WSDserialize* db,void* ptr){
//printf("WSCremoteInstanceData_load...\n");
  WSCremoteInstanceData* obj =(WSCremoteInstanceData*)ptr;
  char* pn = NULL;
  char* in = NULL;
  char* cl = NULL;
  char* ad = NULL;
  db->loadAllocData(WS_DcRString,">pn",(void**)&pn,NULL);
  db->loadAllocData(WS_DcRString,">in",(void**)&in,NULL);
  db->loadAllocData(WS_DcRString,">cl",(void**)&cl,NULL);
  db->loadAllocData(WS_DcRString,">ad",(void**)&ad,NULL);
  db->loadData(WS_DcRUShort,">pt",(void**)&obj->_port);
  if (pn != NULL){
//printf("pn=%s\n",pn);
    obj->setPublicInstanceName(pn);
  }
  if (in != NULL){
//printf("in=%s\n",in);
    obj->setInstanceName(in);
  }
  if (cl != NULL){
//printf("cl=%s\n",cl);
    obj->setClassName(cl);
  }
  if (ad != NULL){
//printf("ad=%s\n",ad);
    obj->setAddr(ad);
  }
}

void* _WSCremoteInstanceData_create(void* ptr){
  return new WSCremoteInstanceData;
}
void _WSCremoteInstanceData_delete(void* ptr){
  WSCremoteInstanceData* obj =(WSCremoteInstanceData*)ptr;
  delete obj;
}
WSMFdefineDrClient(WSCremoteInstanceData,_WSCremoteInstanceData_save,
  _WSCremoteInstanceData_load, _WSCremoteInstanceData_create,
  _WSCremoteInstanceData_delete);
#endif

#ifndef NO_MWT_FUNCTION
#ifndef WS_EMBED
static char* prop_order[] = {
WSNname,
WSNuserString,
WSNuserValue,
WSNx,
WSNy,
WSNwidth,
WSNheight,
WSNshadowType,
WSNshadowThickness,
WSNforeColor,
WSNbackColor,
WSNtopShadowColor,
WSNbottomShadowColor,
WSNlabelString,
WSNtitleString,
WSNfont,
WSNmaxLength,
WSNcolumns,
WSNlabelPixmap,
WSNalignmentV,
WSNalignmentH,
WSNmargin,
WSNmarginTop,
WSNmarginBottom,
WSNmarginLeft,
WSNmarginRight,
WSNblinkColor,
WSNblinkPixmap,
WSNblinkRate,
WSNtwinBlink,
WSNblinkFlag,
WSNblinkRefreshing,
WSNvis,
WSNdet,
WSNanchorTop,
WSNanchorTopFlag,
WSNanchorBottom,
WSNanchorBottomFlag,
WSNanchorLeft,
WSNanchorLeftFlag,
WSNanchorRight,
WSNanchorRightFlag,
WSNseparator,
NULL
};

static void _sort_property(WSClistData* dest,WSClistData* src){
  WSClistData  tmp;
  long num = src->getNum();
  long i;
  for(i=0; i<num; i++){
    void* data = (*src)[i];
    tmp.add(data);
  }

  long j=0;
  while(1){
    if (tmp.getNum() == 0){
      break;
    }
    if (prop_order[j] == NULL){
      break;
    }
    num = tmp.getNum();
    for(i=0; i< num; i++){
      WSCproperty* prop = (WSCproperty*)tmp[i];
      if (!strcmp(prop->getPropObjName(),prop_order[j])){
        dest->add((void*)prop);
        tmp.delPos(i);
        break;
      }
    }
    j++;
  }

  num = tmp.getNum();
  for(i=0; i<num; i++){
    void* data = tmp[i];
    dest->add(data);
  }
}
void WSCbaseList::setInstanceId(long kind,WSCulong data){
  if (kind == WS_REMOVE_ROOT_INSTANCE){
    long num = _root_instance_list.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCulong val = (WSCulong)_root_instance_list[i];
      if (val == data){
        _root_instance_list.delPos(i);
      }
    }
  }
  if (kind == WS_SET_ROOT_INSTANCE){
    long num = _root_instance_list.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCulong val = (WSCulong)_root_instance_list[i];
      if (val == data){
        return;
      }
    }
    _root_instance_list.add((void*)data);
  }
  if (kind == WS_REMOVE_SELECTED_INSTANCE){
    long num = _selected_instance_list.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCulong val = (WSCulong)_selected_instance_list[i];
      if (val == data){
        _selected_instance_list.delPos(i);
      }
    }
  }
  if (kind == WS_SET_SELECTED_INSTANCE){
    long num = _selected_instance_list.getNum();
    long i;
    for(i=0; i<num; i++){
      WSCulong val = (WSCulong)_selected_instance_list[i];
      if (val == data){
        return;
      }
    }
    _selected_instance_list.add((void*)data);
  }
  if (kind == WS_TARGET_INSTANCE_ID){
    _target_instance_id = (WSCulong)data;
    return;
  }
}

WSCulong WSCbaseList::getInstanceId(WSCulong id,long kind,WSCulong data){
  if (kind == WS_NEXT_CHILD_INSTANCE_ID){
    long start = 0;
    long i;
    WSClistData list;
    if (id == WS_ROOT_INSTANCE_ID){
      list = _root_instance_list;
    }else{
      WSCbase* parent = (WSCbase*)id;
      if (existInstance(parent) == False){
        return 0;
      }
      list = parent->getChildren();
    }  

    long num = list.getNum();
    if (data != WS_ROOT_INSTANCE_ID){
      int exists = False;
      for(i=0; i<num-1; i++){
        WSCulong val = (WSCulong)list[i];
        start = i + 1;
        if (val == data){
          exists = True;
          break;
        }
      }
      if (exists == False){
        return 0;
      }
    }
    for(i=start; i<num; i++){
      WSCbase* target = (WSCbase*)list[i];
      if (target->getInternalObject() == False){
        return (WSCulong)target;
      }
    }
    return 0;
  }
  if (kind == WS_NEXT_PROPERTY_ID){
    if (id == WS_ROOT_INSTANCE_ID){
      return 0;
    }
    WSClistData property_list1;
    WSClistData property_list;
    WSCbase* client = (WSCbase*)id;
    WSGFgetAllPropertyList(client,&property_list1);
    _sort_property(&property_list,&property_list1);
    long num = property_list.getNum();
    long i;
    long start = 0;
    WSCbool exists = False;
    if (data != WS_ROOT_PROPERTY_ID){
      for(i = 0; i < num; i++){
        WSCulong val = (WSCulong)property_list[i];
        start = i+1;
        if (val == data){
          exists = True;
          break;
        }
      }
      if (exists == False){
        return 0;
      }
    }
    for(i=start; i<num; i++){
      WSCproperty* target = (WSCproperty*)property_list[i];
      if (client->existProperty(target->getPropObjName()) == False){
        continue;
      }
      if (target->getNotUse() == False &&
          target->getBuilderVisible() != False &&
          target->getDefaultValueChange() == False){
        return (WSCulong)target;
      }
    }
    return 0;
  }
  if (kind == WS_NEXT_PROCEDURE_ID){
    if (id == WS_ROOT_INSTANCE_ID){
      return 0;
    }
    WSCbase* client = (WSCbase*)id;
    WSClistData* procedure_list = client->getProcedureList();
    long num = procedure_list->getNum();
    long i;
    long start = 0;
    WSCbool exists = False;
    if (data != WS_ROOT_PROCEDURE_ID){
      for(i = 0; i < num; i++){
        WSCulong val = (WSCulong)(*procedure_list)[i];
        start = i+1;
        if (val == data){
          exists = True;
          break;
        }
      }
      if (exists == False){
        return 0;
      }
    }
    for(i=start; i<num; i++){
      WSCprocedure* target = (WSCprocedure*)(*procedure_list)[i];
      if (target->getInternal() == False){
        return (WSCulong)target;
      }
    }
    return 0;
  }
  if (kind == WS_NEXT_PROPERTY_SELECT_ITEM_ID){
    WSCproperty* prop = (WSCproperty*)id;
    char* item = (char*)data;
    if (prop == NULL){
      return 0;
    }
    char** labels;
    char** data_lb;
    prop->getBuilderSelectValues(&labels,&data_lb);
    if (labels == NULL){
      return 0;
    }
    if (item == NULL){
      return (long)labels[0];
    }
    int cnt = 0;
    while(1){
      if (labels[cnt] == NULL){
        return 0;
      }
      if (item == labels[cnt]){
        return (long)(labels[cnt+1]);
      }
      cnt++;
    }
    return 0;
  }
  if (kind == WS_NEXT_SELECTED_INSTANCE_ID){
    long i;
    long num = _selected_instance_list.getNum();
    if (id == WS_ROOT_INSTANCE_ID){
      WSCbase* target = (WSCbase*)_selected_instance_list[0];
      return (WSCulong)target;
    }else{
      for(i=0; i<num-1; i++){
        WSCulong val = (WSCulong)_selected_instance_list[i];
        if (val == id){
          WSCbase* target = (WSCbase*)_selected_instance_list[i+1];
          return (WSCulong)target;
        }
      }
    }
    return 0;
  }
  if (kind == WS_TARGET_INSTANCE_ID){
    return _target_instance_id;
  }
  return 0;
}

WSCstring WSCbaseList::getInstanceData(WSCulong id,long kind,WSCulong data){
  if (id == WS_ROOT_INSTANCE_ID){
    return "";
  }
  if (kind == WS_INSTANCE_NAME){
    WSCbase* target = (WSCbase*)id;
    if (existInstance(target) == False){
      return "";
    }
    return target->getInstanceName();
  }
  if (kind == WS_PROPERTY_NAME){
    WSCproperty* prop = (WSCproperty*)id;
    return prop->getPropObjName();
  }
  if (kind == WS_PROPERTY_VALUE){
    WSCbase* client = (WSCbase*)id;
    WSCproperty* prop = (WSCproperty*)data;
    WSCstring tmp = client->getProperty(prop->getPropObjName());
    return tmp;
  }
  if (kind == WS_PROPERTY_TYPE){
    WSCproperty* prop = (WSCproperty*)id;
    return prop->getPropObjTypeName();
  }
  if (kind == WS_PROPERTY_TITLE){
    WSCproperty* prop = (WSCproperty*)id;
    return prop->getBuilderTitle();
  }
  if (kind == WS_PROPERTY_ATTRIBUTE){
    WSCproperty* prop = (WSCproperty*)id;
    WSCulong val = 0;
    if (prop->isColorPropObj() != False){
      val |= WS_PROPERTY_TYPE_COLOR;
    }
    if (prop->isPixmapPropObj() != False){
      val |= WS_PROPERTY_TYPE_PIXMAP;
    }
    if (prop->getFileSelect() != False){
      val |= WS_PROPERTY_TYPE_FILE_SELECT;
    }
    return WSGFltoa(val);
  }
  if (kind == WS_PROCEDURE_NAME){
    WSCprocedure* proc = (WSCprocedure*)id;
    return proc->getProcName();
  }
  if (kind == WS_PROCEDURE_FUNCTION_NAME){
    WSCprocedure* proc = (WSCprocedure*)id;
    return proc->getFunctionName();
  }
  if (kind == WS_PROPERTY_SELECT_VALUE_NAME){
    char* ret = (char*)data;
    return WSGFgettext(ret);
  }
  if (kind == WS_PROPERTY_SELECT_VALUE){
    WSCproperty* prop = (WSCproperty*)id;
    if (prop == NULL){
      return "";
    }
    char* item = (char*)data;
    char** labels;
    char** data_lb;
    prop->getBuilderSelectValues(&labels,&data_lb);
    if (labels == NULL){
      return "";
    }
    long cnt =0;
    while(1){
      if (labels[cnt] == NULL){
        return 0;
      }
      if (item == labels[cnt]){
        return data_lb[cnt];
      }
      cnt++;
    }
    return "";
  }


  return "";
}
WSCbase* WSCbaseList::getInstanceFromId(WSCulong id){
  WSCbase* inst = (WSCbase*)id;
  if (existInstance(inst) == False){
    return NULL;
  }
  return inst;
}
WSCulong WSCbaseList::getIdFromInstance(WSCbase* inst){
  return (WSCulong)inst;
}
#endif
#endif

#ifndef WS_EMBED
void WSCbaseList::addEventProc(void (*hd)(void*),char* trg,void* data){
  long num = _event_proc_list.getNum();
  long i;
  for(i=0; i<num; i++){
    void (*item)(void*) = (void(*)(void*))_event_proc_list[i];
    if (item == hd){
      char* trgn= (char*)_event_proc_trg_list[i];
      if (!strcmp(trgn,trg)){
        _event_proc_data_list.setData(i,data);
        return;
      }
    }
  }
  _event_proc_list.add((void*)hd);
  _event_proc_fname_list.add((void*)NULL);
  _event_proc_trg_list.add((void*)WSGFstrdup(trg));
  _event_proc_data_list.add((void*)data);
}
void WSCbaseList::addEventProc(char* fname,char* trg,void* data){
  long num = _event_proc_list.getNum();
  long i;
  for(i=0; i<num; i++){
    char* item = (char*)_event_proc_fname_list[i];
    if (item != NULL && !strcmp(fname,item)){
      char* trgn= (char*)_event_proc_trg_list[i];
      if (!strcmp(trgn,trg)){
//        char* fname = (char*)_event_proc_list[i];
//        if (fname != NULL){
//          delete[] fname;
//        }
        _event_proc_list.setData(i,NULL);
        _event_proc_data_list.setData(i,data);
        return;
      }
    }
  }
  _event_proc_list.add((void*)NULL);
  _event_proc_fname_list.add((void*)WSGFstrdup(fname));
  _event_proc_trg_list.add((void*)WSGFstrdup(trg));
  _event_proc_data_list.add((void*)data);
}
void WSCbaseList::addEventProc(char* fname,char* trg,long data){
  addEventProc(fname,trg,(void*)data);
}


void WSCbaseList::delEventProc(void(*hd)(void*),char* trg){
  long num = _event_proc_list.getNum();
  long i;
  for(i=0; i<num; i++){
    void (*item)(void*) = (void(*)(void*))_event_proc_list[i];
    if (item == hd){
      char* trgn= (char*)_event_proc_trg_list[i];
      if (!strcmp(trgn,trg)){
        delete[] trgn;
        _event_proc_list.delPos(i);
        char* fname= (char*)_event_proc_fname_list[i];
        if (fname != NULL){
          delete[] fname;
        }
        _event_proc_fname_list.delPos(i);
        _event_proc_trg_list.delPos(i);
        _event_proc_data_list.delPos(i);
        return;
      }
    }
  }
}
void WSCbaseList::delEventProc(char* fn,char* trg){
  long num = _event_proc_list.getNum();
  long i;
  for(i=0; i<num; i++){
    char* fname= (char*)_event_proc_fname_list[i];
    if (fname == NULL){
      continue;
    }
    if (!strcmp(fname,fn)){
      char* trgn= (char*)_event_proc_trg_list[i];
      if (!strcmp(trgn,trg)){
        delete[] trgn;
        _event_proc_list.delPos(i);
        delete[] fname;
        _event_proc_fname_list.delPos(i);
        _event_proc_trg_list.delPos(i);
        _event_proc_data_list.delPos(i);
        return;
      }
    }
  }
}
void WSCbaseList::delAllEventProc(){
  long num = _event_proc_list.getNum();
  long i;
  for(i=0; i<num; i++){
    char* trgn= (char*)_event_proc_trg_list[i];
    delete[] trgn;
    char* fname= (char*)_event_proc_fname_list[i];
    if (fname != NULL){
      delete[] fname;
    }
  }
  _event_proc_list.clear();
  _event_proc_fname_list.clear();
  _event_proc_trg_list.clear();
  _event_proc_data_list.clear();
}

void WSCbaseList::execEventProc(char* trg){
  long num = _event_proc_list.getNum();
  long i;
  for(i=0; i<num; i++){
    char* trgn= (char*)_event_proc_trg_list[i];
    if (!strcmp(trgn,trg)){
      void (*hd)(void*) = (void(*)(void*))_event_proc_list[i];
      void* data = _event_proc_data_list[i];
      if (hd != NULL){
        hd(data);
      }
      char* fname = (char*)_event_proc_fname_list[i];
      if (fname != NULL){
        if (_event_proc_handler != NULL){
          _event_proc_handler(fname,data);
        }
      }
    }
  }
}
void WSCbaseList::setEventProcHandler(void(*hd)(char*,void*)){
  _event_proc_handler = hd;
}
#endif

#ifndef NO_MWT_FUNCTION
static void (*_create_handler)(WSCbase*) = NULL;
static void (*_vis_handler)(WSCbase*) = NULL;
static void (*_unvis_handler)(WSCbase*) = NULL;
static void (*_destroy_handler)(WSCbase*) = NULL;
void WSCbaseList::setInternalWindowCreateHandler(void(*fn)(WSCbase*)){
  _create_handler = fn;
}
void WSCbaseList::setInternalWindowVisibleHandler(void(*fn)(WSCbase*)){
  _vis_handler = fn;
}
void WSCbaseList::setInternalWindowUnvisibleHandler(void(*fn)(WSCbase*)){
  _unvis_handler = fn;
}
void WSCbaseList::setInternalWindowDestroyHandler(void(*fn)(WSCbase*)){
  _destroy_handler = fn;
}
void* WSCbaseList::getInternalWindowCreateHandler(){
  return (void*)_create_handler;
}
void* WSCbaseList::getInternalWindowVisibleHandler(){
  return (void*)_vis_handler;
}
void* WSCbaseList::getInternalWindowUnvisibleHandler(){
  return (void*)_unvis_handler;
}
void* WSCbaseList::getInternalWindowDestroyHandler(){
  return (void*)_destroy_handler;
}
#endif
