//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCclassInformation.h>

WSCclassInformation::WSCclassInformation(const char* class_name,WSCclassInformation* parent){
//  cname = WSGFstrdup(class_name);
  cname = class_name;
  cname_hash_value = WSGFgetHashValue((char*)class_name);
  _bases = NULL;
  _pclass_info = parent;
  _inf_table = NULL;
//  _all_prop_list = new WSClistData(64);
//  _prop_list_for_init = new WSClistData(64);
  _trigger_mask = 0;
  _del_trigger_mask = 0;
  _ext_trigger_list.setNoAllocIndex(True);
  _all_ext_trigger_list.setNoAllocIndex(True);
  _cache = NULL;
  _prop_list._seg_size = 64;
  _prop_list_for_init._seg_size = 64;
  _all_prop_list._seg_size = 64;
  _all_ext_trigger_list.getList()->_seg_size = 16;
  _ext_trigger_list.getList()->_seg_size = 8;
  _del_ext_trigger_list._seg_size = 8;
};

WSCclassInformation::~WSCclassInformation(){
//  delete cname;
//  delete _prop_list_for_init;
//  delete _all_prop_list;
  long num=_prop_list.getNum();
  WSCproperty** buf = (WSCproperty**)_prop_list._data;
  long i;
  for(i=0; i<num; i++){
    WSCproperty* prop = (WSCproperty*)buf[i];
    delete prop;
  }
  if (_inf_table != NULL){
//    for(i=0; i<WS_MAX_HASH_VALUE; i++){
//      WSClistData* list = &(_inf_table[i]);
//      num = list->getNum();
//      int j;
//      for(j=0; j<num; j++){
//        WSCproperty* prop = (WSCproperty*)(*list)[j];
//        delete prop;
//      }
//    }
    delete[] _inf_table;
    _inf_table = NULL;
  }
}
WSCclassInformation* WSCclassInformation::getParentClassInformation(){
  return _pclass_info;
}
void* WSCclassInformation::getClassInstanceList(){
  return _bases;
}
void WSCclassInformation::setClassInstanceList(void* list){
  _bases = list;
}
WSClistData* WSCclassInformation::getPropertyList(){
  return &_prop_list;
}
WSClistData* WSCclassInformation::getHashTable(){
  if (_inf_table == NULL){
    _create_inf_table();
  }
  return _inf_table;
}
#ifndef WS_EMBED
WSCbool WSCclassInformation::getPropObj(char* prop_name,char** class_name){
//  if (_inf_table == NULL){
//    _create_inf_table();
//  }
  long val = WSGFgetHashValue(prop_name);
  WSClistData* list = &_inf_table[val];
  long num = (*list)._num;
  long i;
  WSCproperty* prop = NULL;
  WSCproperty** buf =(WSCproperty**)list->_data;
  for(i=0; i < num; i++){
    i++;
    prop = buf[i];
    if (prop->property_name == prop_name){
      WSCclassInformation* inf = (WSCclassInformation*)(*list)[i-1];
      *class_name = (char*)inf->cname;
       return True;
    }
    if (prop->property_name[0] == prop_name[0] &&
        !WSIFstrcmp( prop->property_name, prop_name)){
      WSCclassInformation* inf = (WSCclassInformation*)(*list)[i-1];
      *class_name = (char*)inf->cname;
      return True;
    }
  }
  return False;
}
#endif
WSCbool WSCclassInformation::getPropObj(char* prop_name,WSCproperty** prop){
//  if (_inf_table == NULL){
//    _create_inf_table();
//  }
  if (_cache != NULL)
    if (_cache->property_name == prop_name ||
        (_cache->property_name[0] == prop_name[0] &&
          !WSIFstrcmp( _cache->property_name, prop_name))){
    *prop = _cache;
    return True;
  }
  long val = WSGFgetHashValue(prop_name);
  WSClistData* list = &_inf_table[val];
  long num = (*list)._num;
//  WSChashData* data;
  long i;
  WSCproperty* property = NULL;
  WSCproperty** proplist = (WSCproperty**)list->_data;
  for(i=0; i < num; i++){
    i++;
    property = proplist[i];
    if (property->property_name == prop_name){
      *prop = property;
      _cache = property;
      return True;
    }
  }
  for(i=0; i < num; i++){
    i++;
    property = proplist[i];
    if (property->property_name[0] == prop_name[0] &&
        !WSIFstrcmp( property->property_name, prop_name)){
      *prop = property;
      _cache = property;
      return True;
    }
  }
  return False;
}
void WSCclassInformation::setExtTrigger(long trg,const char* tname){
  _ext_trigger_list.setData((char*)tname,(void*)trg);
}
WSCindexData* WSCclassInformation::getExtTriggerList(){
  return &_ext_trigger_list;
}
WSCindexData* WSCclassInformation::getAllExtTriggerList(){
  if (_inf_table == NULL){
    _create_inf_table();
  }
  return &_all_ext_trigger_list;
}

void WSCclassInformation::setTrigger(long trg){
  _trigger_mask |= WSGFeventToMaskBit(trg);
}
void WSCclassInformation::setDelTrigger(long trg){
  _del_trigger_mask |= WSGFeventToMaskBit(trg);
}
WSCbool WSCclassInformation::existTrigger(long trg){
  WSCbool ret = _existTrigger(trg);
  if (ret == False){
    return _existExtTrigger(trg);
  }
  return ret;
}
WSCbool WSCclassInformation::_existExtTrigger(long trg){
  long i;
  long num = _all_ext_trigger_list.getNum();
  for(i=0; i<num; i++){
    long val = (long)_all_ext_trigger_list.getData(i);
    if (val == trg){
      return True;
    }
  }
  return False;
}
WSCbool WSCclassInformation::_existTrigger(long trg){
  if (trg == WSEV_NONE || trg == WSEV_INITIALIZE ||
                          trg == WSEV_DELETE ){
    return True;
  }
  WSCulong mask = WSGFeventToMaskBit(trg);
  if (_del_trigger_mask & mask){
    return False;
  }
  if (_trigger_mask & mask){
    return True;
  }

  WSCclassInformation* parent = _pclass_info;
  if (parent == NULL){
    return False;
  }else{
    return parent->existTrigger(trg);
  }
}
WSClistData* WSCclassInformation::getAllPropertyList(){
  if (_inf_table == NULL){
    _create_inf_table();
  }
  return &_all_prop_list;
}
WSClistData* WSCclassInformation::getPropertyListForInit(){
  if (_inf_table == NULL){
    _create_inf_table();
  }
  return &_prop_list_for_init;
}
void WSCclassInformation::setDelExtTrigger(long trg){
  _del_ext_trigger_list.add((void*)trg);
}
void WSCclassInformation::_create_inf_table(){
  if (_inf_table == NULL){
    _inf_table = new WSClistData[WS_MAX_HASH_VALUE];
    int i;
    for(i=0; i<WS_MAX_HASH_VALUE; i++){
      _inf_table[i]._seg_size = 16;
    }
  }
  WSClistData not_use_list(16);
  WSClistData defaultch_list(16);
#ifndef WS_EMBED
  WSClistData not_vis_list(16);
#endif
  WSCclassInformation* inf = this;
  WSClistData* plist;
  WSCproperty* prop = NULL;
  WSCproperty* nprop = NULL;
  long num,num2,i,j;
  WSCbool reject;
  while(1){
    if (inf != NULL){
      WSClistData* dtlist = &inf->_del_ext_trigger_list;
//      long dtnum = dtlist->getNum();
      long dtnum = dtlist->_num;
      long* dtlist_buf = (long*)dtlist->_data;
      for(i=0; i<dtnum; i++){
        long trg = dtlist_buf[i];
        long j;
        long anum = _all_ext_trigger_list.getNum();
        for(j=0; j < anum;j++){
          long val = (long)_all_ext_trigger_list.getData(j);
          if (val == trg){
            _all_ext_trigger_list.delPos(j);
            anum--;
            j--;
          } 
        }
      }

      WSCindexData* tlist = inf->getExtTriggerList();
      long tnum = tlist->getNum();
      for(i=0; i<tnum; i++){
        _all_ext_trigger_list.setData(tlist->getIndex(i),tlist->getData(i));
      }


      plist = &inf->_prop_list;
      num = plist->_num;
      WSCproperty** props = (WSCproperty**)(*plist)._data;
      for(i=0; i< num; i++){
        prop = props[i];
        if (prop->_default_value_change != False){
          defaultch_list.add(prop);
          continue;
        }
#ifndef WS_EMBED
        if (prop->_ignore != False && prop->_builder_visible == False){
          not_vis_list.add(prop);
          continue;
        }
#endif
        if (prop->_not_use != False){
          not_use_list.add(prop);
          continue;
        }
        num2 = not_use_list._num;
        reject = False;
        WSCproperty** not_use_list2 = (WSCproperty**)not_use_list._data;
        for(j=0; j < num2; j++){
          nprop = not_use_list2[j];
          if (nprop->property_name[0] == prop->property_name[0] &&
              !WSIFstrcmp(nprop->property_name,prop->property_name)){
            reject = True;
            j = num2;
          }
        }
        if (reject != False){
          continue;
        }
        WSCproperty* default_ch = NULL;
        long dnum = defaultch_list._num;
        long j;
        WSCproperty** dprops = (WSCproperty**)defaultch_list._data;
        for(j=0; j<dnum; j++){
          WSCproperty* dprop = dprops[j];
          if (dprop->property_name[0] == prop->property_name[0] &&
              !WSIFstrcmp(dprop->property_name,prop->property_name)){
            default_ch = dprop;
            break;
          }
        }
        if (default_ch != NULL){
#ifndef _WSWIN32
          WSCproperty* new_prop = new WSCproperty(*prop);
#else
          WSCproperty* new_prop = new WSCproperty("","");
          *new_prop = *prop;
#endif
          new_prop->setGetDefaultValueHandler(
		           (void(*)(void*))default_ch->getGetDefaultValueHandler() );
          new_prop->_init_execute = default_ch->_init_execute;
//This causes that the property editor does not display, removed.
//          new_prop->_default_value_change = True;
          prop = new_prop;
        }
#ifndef WS_EMBED
        WSCproperty* builder_vis_ch = NULL;
        dnum = not_vis_list._num;
        WSCproperty** nvprops = (WSCproperty**)not_vis_list._data;
        for(j=0; j<dnum; j++){
          WSCproperty* dprop = nvprops[j];
          if (dprop->property_name[0] == prop->property_name[0] &&
              !WSIFstrcmp(dprop->property_name,prop->property_name)){
            builder_vis_ch = dprop;
            break;
          }
        }
        if (builder_vis_ch != NULL){
//          WSCproperty* new_prop = new WSCproperty(*prop); //for VC++
          WSCproperty* new_prop = new WSCproperty("","");
          *new_prop = *prop;
          new_prop->_builder_visible =  builder_vis_ch->_builder_visible;
          prop = new_prop;
        }
#endif
//        WSChashData* data = new WSChashData;
//        data->_class_info = inf;
//        data->_property = prop;
//        char* name = prop->property_name;
        long hash_val = WSGFgetHashValue(prop->property_name);
        _inf_table[ hash_val ].add(inf);
        _inf_table[ hash_val ].add(prop);
        _all_prop_list.add(prop);
      }
      inf = inf->_pclass_info;
    }else{
      break;
    }
  }

  inf = this;
  WSCproperty* vis = NULL;
  WSClistData pl(32);
  while(1){
    if (inf != NULL){
      pl.add(inf);
    }else{
      break;
    }
    inf = inf->_pclass_info;
  }

  j = pl._num;
  j--;
  if (j < 0){ 
    return;
  }
  WSCclassInformation* pinf;
  WSCproperty* _prop;

  WSCclassInformation** pinfs = (WSCclassInformation**)pl._data;
  while(1){
    pinf = pinfs[j];
    if (pinf != NULL ){
      plist = &pinf->_prop_list;
      num = plist->_num;
      WSCproperty** props = (WSCproperty**)plist->_data;
      for(i=0; i< num; i++){
        _prop = props[i];
        if (_prop->_default_value_change != False){
          continue;
        }
#ifndef WS_EMBED
        if (_prop->_ignore != False && _prop->_builder_visible == False){
          continue;
        }
#endif
        if (_prop->_not_use != False){
          continue;
        }
        WSCproperty* default_ch = NULL;
        long dnum = defaultch_list._num;
        long j;
        WSCproperty** dprops = (WSCproperty**)defaultch_list._data;
        for(j=0; j<dnum; j++){
          WSCproperty* dprop = dprops[j];
          if (dprop->property_name[0] == prop->property_name[0] &&
              !WSIFstrcmp(dprop->property_name,_prop->property_name)){
            default_ch = dprop;
            break;
          }
        }
        if (default_ch != NULL){
#ifndef _WSWIN32
          WSCproperty* new_prop = new WSCproperty(*_prop);
#else
          WSCproperty* new_prop = new WSCproperty("","");
          *new_prop = *_prop;
#endif
          new_prop->setGetDefaultValueHandler(
              (void(*)(void*))default_ch->getGetDefaultValueHandler() );
          new_prop->_init_execute = default_ch->_init_execute;
          new_prop->_set_proc_addr = _prop->_set_proc_addr;
          _prop = new_prop;
        }
#ifndef WS_EMBED
        WSCproperty* builder_vis_ch = NULL;
        dnum = not_vis_list._num;
        WSCproperty** nvprops = (WSCproperty**)not_vis_list._data;
        for(j=0; j<dnum; j++){
          WSCproperty* nvprop = nvprops[j];
          if (nvprop->property_name[0] == prop->property_name[0] &&
              !WSIFstrcmp(nvprop->property_name,_prop->property_name)){
            builder_vis_ch = nvprop;
            break;
          }
        }
        if (builder_vis_ch != NULL){
#ifndef _WSWIN32
          WSCproperty* new_prop = new WSCproperty(*_prop);
#else
          WSCproperty* new_prop = new WSCproperty("","");
          *new_prop = *_prop;
#endif
          new_prop->_builder_visible =  builder_vis_ch->_builder_visible;
          _prop = new_prop;
        }
#endif
        if ( WSIFstrcmp(_prop->property_name,"vis")){
          if ( _prop->_init_execute != False){
            _prop_list_for_init.add((void*)_prop);       
          }
        }else{
          if ( _prop->_init_execute != False){
            vis = _prop;
          }
        }
      }
    }else{
      break;
    }
    j--;
    if (j < 0){ 
      break;
    }
  }
  if (vis != NULL){
    _prop_list_for_init.add((void*)vis);       
  }
}
void WSCclassInformation::addPropObj(WSCproperty* prop){
  _prop_list.add((void*)prop);
}
//WSChashData::WSChashData(){
//   _class_info = NULL;
//   _property = NULL;
//}
