//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCimageSet.h>

static WSCimageSet* _the_app_image_list = NULL;

WSCimageSet* get_new_image_set(){
    return new WSCimageSet();
}
WSCimageSet* WSGIappImageSet(){
  if (_the_app_image_list == NULL){
    _the_app_image_list = get_new_image_set();
  }
  return _the_app_image_list;
};


WSCimageSet::WSCimageSet(){
  _create_handler = NULL;
  _image_num = 1;
  long i;
  for(i=0; i<WS_MAX_HASH_VALUE; i++){
    _cache_table[i] = NULL;
    _cache_table2[i] = NULL;
  }
}

WSCimageSet::~WSCimageSet(){
   long i;
   long num = _image_list._num;
   for(i = 0; i<num; i++){
      WSDimage* img = (WSDimage*)_image_list[i];
      delete img;
   }
}

char* WSCimageSet::getImageName(short no){
  if (no == -1) return "";

  long i;
  long num = _image_list._num;
  for(i = 0; i<num; i++){
    WSDimage* img = (WSDimage*)_image_list[i];
    short id = img->_id;
    if (id == no){
      char* ret = img->getSrc();
      return ret;
    }
  }
  return "";
}


WSDimage* WSCimageSet::getImage(short no){
  long hval = no % WS_MAX_HASH_VALUE;
  if (_cache_table2[hval] != NULL){
    short id = _cache_table2[hval]->_id;
    if (id == no){
      return _cache_table2[hval];
    }
  }

  long i;
  long num = _image_list._num;
  WSDimage** buf = (WSDimage**)_image_list._data;
  for(i = 0; i<num; i++){
    WSDimage* img = (WSDimage*)buf[i];
    short id = img->_id;
    if (id == no){
      _cache_table[hval] = img;
      return img;
    }
  }
  return NULL;
}

WSDimage* WSCimageSet::getImage(char* iname){
  long hval = WSGFgetHashValue(iname);
  if (_cache_table[hval] != NULL){
    char* name = _cache_table[hval]->getSrc();
    if (iname[0] == name[0] && !strcmp(iname,name) ){
      return _cache_table[hval];
    }
  }

  long i;
  long num = _image_list._num;
  WSDimage** buf = (WSDimage**)_image_list._data;
  for(i = 0; i<num; i++){
    WSDimage* img = buf[i];
    if (img->getSrc()[0] == iname[0] && !strcmp(img->getSrc(),iname)){
      _cache_table[hval] = img;
      return img;
    }
  }

  if (_create_handler != NULL){
    WSDimage* img = _create_handler();
    img->setImageName(iname);
    img->setId(_image_num);
    _image_num++;
    _image_list.add( (void*)img );
    _cache_table[hval] = img;
    return img;
  }
  return NULL;
}

short WSCimageSet::getImageNo(char* iname){
  long hval = WSGFgetHashValue(iname);
  if (_cache_table[hval] != NULL){
    char* name = _cache_table[hval]->getSrc();
    if (iname[0] == name[0] && !strcmp(iname,name) ){
      return _cache_table[hval]->_id;
    }
  }

  long i;
  long num = _image_list._num;
  WSDimage** buf = (WSDimage**)_image_list._data;
  for(i = 0; i<num; i++){
    WSDimage* img = buf[i];
    char* nm = img->_src_name;
    if (nm != NULL && nm[0] == iname[0] && !strcmp(nm,iname)){
      _cache_table[hval] = img;
      return img->_id;
    }
  }

  if (_create_handler != NULL){
    WSDimage* img = _create_handler();
    img->setImageName(iname);
    img->setId(_image_num);
    img->getValue1();
    _image_num++;
    _image_list.add( (void*)img );
    _cache_table[hval] = img;
    short ret = img->_id;
    return ret;
  }
  return -1;
}
long WSCimageSet::destroyImage(short no){
  WSDimage* img = getImage(no);
  if (img != NULL){
    img->destroyImage();
  }
  return WS_NO_ERR;
}
long WSCimageSet::destroyImage(char* iname){
  WSDimage* img = getImage(iname);
  if (img != NULL){
    img->destroyImage();
  }
  return WS_NO_ERR;
}
long WSCimageSet::update(char* iname){
  WSDimage* img = getImage(iname);
  if (img != NULL){
    img->destroyImage();
    img->getValue1();
  }
  return WS_NO_ERR;
}

long WSCimageSet::destroyAllImage(){
  long i;
  long num = _image_list._num;
  for(i = 0; i<num; i++){
    WSDimage* img = (WSDimage*)_image_list[i];
    img->destroyImage();
  }
  return WS_NO_ERR;
}
long WSCimageSet::setCreateHandler(WSDimage* (*hd)()){
  _create_handler = hd;
  return WS_NO_ERR;
}
short WSGFimage(char* cname){
  return WSGIappImageSet()->getImageNo(cname);
}
short WSGFimage(char* cname,short pno){
  WSDimage* img = WSGIappImageSet()->getImage(pno);
  if (img == NULL){
    return WSGIappImageSet()->getImageNo(cname);
  }
  img->setImageName(cname);
  img->destroyImage();
  return img->_id;
}
char* WSGFimageName(short pno){
  return WSGIappImageSet()->getImageName(pno);
}
long WSCimageSet::setDefaultImageHandle(char* iname,void* handle){
  _default_image_handles.setData(iname,handle);
  return WS_NO_ERR;
}
void* WSCimageSet::getDefaultImageHandle(char* iname){
  return _default_image_handles.getData(iname);
}
