//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>

#include <WSCindexData.h>

WSCindexData::WSCindexData(){
  _no_alloc_index = False;
}

WSCindexData::~WSCindexData(){
  clear();
}

long WSCindexData::getNum(){
//  return _index.getNum();
  return (_data._num)/2;
}
long WSCindexData::setData(char* index,void* data){
  long num = _data._num;
  long i;
  char** buf = (char**)_data._data;
  for(i=0; i<num; i++){
    char* ptr = (char*)buf[i];
    i++;
    if (ptr[0] == index[0] && !WSIFstrcmp(ptr,index)){
      buf[i] = (char*)data;
      return 0;
    }
  }
  if (_no_alloc_index == False){
    _data.add(WSGFstrdup(index));
  }else{
    _data.add(index);
  }
  _data.add(data);
  return 0;
}

long WSCindexData::del(char* index){
  long num = _data._num;
  long i;
  char** buf = (char**)_data._data;
  for(i=0; i<num; i++){
    char* ptr = (char*)buf[i];
    if (ptr[0] == index[0] && !WSIFstrcmp(ptr,index)){
      if (_no_alloc_index == False){
        delete ptr;
      }
      _data.delPos(i);
      _data.delPos(i);
      return 0;
    }
    i++;
  }
  return -1;
} 

long WSCindexData::delPos(long pos){
  pos = pos*2;
  if (pos < 0){
    pos = _data._num -2;
    if (pos < 0){
      return -1;
    }
  }
  if (pos < _data._num){
    if (_no_alloc_index == False){
      char* str = (char*)_data[pos];
      delete str;
    }
    _data.delPos(pos);
    _data.delPos(pos);
    return 0;
  }
  return -1;
}

void WSCindexData::clear(){
  if (_no_alloc_index == False){
    long num = _data._num;
    long i;
    char** buf = (char**)_data._data;
    for(i=0; i<num; i++){
      char* index =(char*)buf[i];
      delete[] index;
      i++;
    }
  }
  _data.clear();

}
void* WSCindexData::getData(char* index){
  long num = _data._num;
  long i;
  char** buf = (char**)_data._data;
  for(i=0; i<num; i++){
    char* ptr = (char*)buf[i];
    i++;
    if (ptr[0] == index[0] && !WSIFstrcmp(ptr,index)){
      return _data[i];
    }
  }
  return 0;
}

void* WSCindexData::getData(long i){
  long num = _data._num;
  if (num == 0){
    return NULL;
  }
  if (-1 < i && i*2 < num){
    return _data[(i*2+1)];
  }
  return (char*)_data[num-1];
}

char* WSCindexData::getIndex(long i){
  long num = _data._num;
  if (num == 0){
    return "";
  }
  char** buf = (char**)_data.getBuf();
  if (-1 < i && i*2 < num){
    return (char*)buf[i*2];
  }
  return (char*)buf[num-2];
}

WSCindexData::WSCindexData(WSCindexData& src){
  _no_alloc_index = src._no_alloc_index;
  long num = src._data._num;
  long i;
  for(i=0; i<num; i++){
    if (_no_alloc_index == False){
      _data.add(WSGFstrdup( (char*)src._data[i]));
    }else{
      _data.add((char*)src._data[i]);
    }
    i++;
    _data.add(src._data[i]);
  }
}
WSCindexData::WSCindexData(const WSCindexData& csrc){
  WSCindexData src(csrc); 
  _no_alloc_index = src._no_alloc_index;
  long num = src._data._num;
  long i;
  for(i=0; i<num; i++){
    if (_no_alloc_index == False){
      _data.add(WSGFstrdup( (char*)src._data[i]));
    }else{
      _data.add((char*)src._data[i]);
    }
    i++;
    _data.add(src._data[i]);
  }
}

void* &WSCindexData::operator [] (char* index){
  long num = _data._num;
//printf("WSCindexData::operator[] num=%d\n",num);
  long i;
  char** buf = (char**)_data._data;
  for(i=0; i<num; i++){
    char* ptr = (char*)buf[i];
    i++;
    if (ptr[0] == index[0] && !WSIFstrcmp(ptr,index)){
      return (void*&)buf[i];
    }
  }
  setData(index,0);
  return (*this)[index];
}
void WSCindexData::setNoAllocIndex(WSCbool fl){
  if (_no_alloc_index != fl){
    clear();
    _no_alloc_index = fl;
  }
}
WSCindexData& WSCindexData::operator = (WSCindexData& src){
  clear();
  _no_alloc_index = src._no_alloc_index;

  long num = src._data._num;
  long i;
  for(i=0; i<num; i++){
    if (_no_alloc_index == False){
      _data.add(WSGFstrdup( (char*)src._data[i]));
    }else{
      _data.add((char*)src._data[i]);
    }
    i++;
    _data.add(src._data[i]);
  }
  return *this;
}
WSClistData* WSCindexData::getList(){
  return &_data;
}
