//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>

#ifndef NO_INDEX_VARIANT_DATA
#include <WSCindexVariantData.h>

WSCindexVariantData::WSCindexVariantData(){
  _tmp = (long)0;
}

WSCindexVariantData::~WSCindexVariantData(){
  clear();
}

long WSCindexVariantData::getNum(){
  return _index.getNum();
}
long WSCindexVariantData::setData(char* index,WSCvariant data){
  long num = _index.getNum();
  long i;
  for(i=0; i<num; i++){
    char* ptr = (char*)_index[i];
    if (ptr[0] == index[0] && !strcmp(ptr,index)){
      WSCvariant* val = (WSCvariant*)_data[i];
      *val = data;
      return 0;
    }
  }
  _index.add(WSGFstrdup(index));
  WSCvariant* val = new WSCvariant(data);
  _data.add(val);
  return 0;
}

long WSCindexVariantData::del(char* index){
  long num = _index.getNum();
  long i;
  for(i=0; i<num; i++){
    char* ptr = (char*)_index[i];
    if (ptr[0] == index[0] && !strcmp(ptr,index)){
      char* str = (char*)_index[i];
      delete[] str;
      _index.delPos(i);
      WSCvariant* val = (WSCvariant*)_data[i];
      _data.delPos(i);
      delete val;
      return 0;
    }
  }
  return -1;
} 

long WSCindexVariantData::delPos(long pos){
  if (pos < 0){
    pos = _index.getNum() -1;
    if (pos < 0){
      return -1;
    }
  }
  if (pos < _index.getNum()){
    char* str = (char*)_index[pos];
    delete[] str;
    _index.delPos(pos);
    WSCvariant* val = (WSCvariant*)_data[pos];
    _data.delPos(pos);
      delete val;
    return 0;
  }
  return -1;
}

void WSCindexVariantData::clear(){
  long num = _index.getNum();
  long i;
  for(i=0; i<num; i++){
    char* index =(char*)_index[i];
    delete[] index;
    WSCvariant* val = (WSCvariant*)_data[i];
    delete val;
  }
  _index.clear();
  _data.clear();

}
WSCvariant& WSCindexVariantData::getData(char* index){
  long num = _index.getNum();
  long i;
  for(i=0; i<num; i++){
    char* ptr = (char*)_index[i];
    if (ptr[0] == index[0] && !strcmp(ptr,index)){
      WSCvariant* val = (WSCvariant*)_data[i];
      return *val;
    }
  }
  return _tmp;
}

WSCvariant& WSCindexVariantData::getData(long i){
  WSCvariant* val = (WSCvariant*)_data[i];
  return *val;
}

char* WSCindexVariantData::getIndex(long i){
  return (char*)_index[i];
}

WSCindexVariantData::WSCindexVariantData(WSCindexVariantData& src){
  _tmp = (long)0;
  long num = src._index.getNum();
  long i;
  for(i=0; i<num; i++){
    _index.add(WSGFstrdup( (char*)src._index[i]));
    WSCvariant* val = (WSCvariant*)src._data[i];
    WSCvariant* val2 = new WSCvariant(*val);
    _data.add(val2);
  }
}

WSCindexVariantData::WSCindexVariantData(const WSCindexVariantData& csrc){
  WSCindexVariantData src(csrc);
  _tmp = (long)0;
  long num = src._index.getNum();
  long i;
  for(i=0; i<num; i++){
    _index.add(WSGFstrdup( (char*)src._index[i]));
    WSCvariant* val = (WSCvariant*)src._data[i];
    WSCvariant* val2 = new WSCvariant(*val);
    _data.add(val2);
  }
}


WSCvariant& WSCindexVariantData::operator [] (char* index){
  long num = _index.getNum();
  long i;
  for(i=0; i<num; i++){
    char* ptr = (char*)_index[i];
    if (ptr[0] == index[0] && !strcmp(ptr,index)){
      WSCvariant* val = (WSCvariant*)_data[i];
      return *val;
    }
  }
  setData(index,0);
  return (*this)[index];
}

WSCindexVariantData& WSCindexVariantData::operator = (WSCindexVariantData& src){
  clear();

  long num = src._index.getNum();
  long i;
  for(i=0; i<num; i++){
    _index.add(WSGFstrdup( (char*)src._index[i]));
    WSCvariant* val = (WSCvariant*)src._data[i];
    WSCvariant* val2 = new WSCvariant(*val);
    _data.add(val2);
  }
  return *this;
}
WSCbool WSCindexVariantData::isExist(char* index){
  long num = _index.getNum();
  long i;
  for(i=0; i<num; i++){
    char* ptr = (char*)_index[i];
    if (ptr[0] == index[0] && !strcmp(ptr,index)){
      return True;
    }
  }
  return False;
}
#endif
