//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCinitializeManager.h>
#include <WSDenv.h>


static WSCinitializeManager* _the_app_init_man = NULL;
WSCinitializeManager* WSGIappInitializeManager(){
  if ( _the_app_init_man == NULL){
    _the_app_init_man = new WSCinitializeManager();
  }
  return _the_app_init_man;
}

WSCinitializeManager::WSCinitializeManager(){
  _executed = False;
}
void WSCinitializeManager::addInitializeProc(void(*hd)()){
  if (_executed == False){
    _init_procs.add((void*)hd);
//printf("XXXXXZZZ added num = %d\n",_init_procs.getNum());
  }else{
//printf("XXXXXZZZ executed.\n");
    hd();
  }
}
void WSCinitializeManager::execInitializeProcs(){
  long num = _init_procs.getNum();
  long i;
  for(i=0; i<num; i++){
    void(*hd)() = (void(*)())_init_procs[i];
//printf("XXXXXZZZ executed num = %d\n",i);
    hd();
  }
  _executed = True;
}
WSCinitializeManager::~WSCinitializeManager(){
}

