//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCindexVariantData.h>
#include <WSCundoManager.h>
#include <WSCbase.h>
#include <WSCbaseList.h>

#ifndef NO_MWT_FUNCTION
#ifndef NO_INDEX_VARIANT_DATA

WSCundoManager* _the_app_undo_manager = NULL;

WSCundoManager* WSGIappUndoManager(){
  if (_the_app_undo_manager == NULL){
    _the_app_undo_manager = new WSCundoManager();
  }
  return _the_app_undo_manager;
}

WSMFclassInit(WSCundoProc,WSCroot);
WSMFclassInit(WSCpropUndoProc,WSCundoProc);

WSCundoProc::WSCundoProc(){
}
WSCundoProc::~WSCundoProc(){
}
WSCpropUndoProc::WSCpropUndoProc(){
  _target = NULL;
}

WSCpropUndoProc::~WSCpropUndoProc(){
}
void WSCpropUndoProc::execute(){
  long num = _args.getNum();
  long i;
  if (_target == NULL){
    return;
  }
  if (_target->cast("WSCnwbase") != NULL && _target->getVisible() != False){
    _target->clear();
  }
  if (WSGIappObjectList()->existInstance(_target) != False){
    for(i=0; i<num; i++){
      char* index = _args.getIndex(i);
      WSCvariant val = _args.getData(i);
      if (!strcmp(index,"vis")){
        _target->setUserData(WS_VIS,(void*)val.getInt());
      }else{
        _target->setProperty(index,val);
      }
    }
  }
}
void WSCpropUndoProc::setTarget(WSCbase* target){
  _target = target;
  WSClistData prop_list;
  target->getPropertyArray(&prop_list,True); 
  int i;
  int num = prop_list.getNum();
  char** buf = (char**)prop_list.getBuf();
  for(i=0; i<num; i++){
    char* propname = buf[i];
    i++;
    char* propval = buf[i];
    _args.setData(propname,propval);
    delete propname;
    delete propval;
  }
}
WSCbase* WSCpropUndoProc::getTarget(){
  return _target;
}
WSCundoManager::WSCundoManager(){
  _max_undo_num = 16;
}
WSCundoManager::~WSCundoManager(){
  int i;
  int num = _undo_proc.getNum();
  for(i=0; i< num; i++){
    WSCundoProc* proc = (WSCundoProc*)_undo_proc.getData(i);
    delete proc;
  }
  _undo_proc.clear();
}
void WSCundoManager::addUndoProc(WSCundoProc* proc){
  long num = _undo_proc.getNum();
  if (num == 0){
    WSGIappObjectList()->execEventProc("ve-undo-status-changed");
  }
  if (num > 15){
    WSCundoProc* proc = (WSCundoProc*)_undo_proc.getData(0);
    delete proc;
    _undo_proc.delPos(0);
  }
  _undo_proc.add((void*)proc);
}
void WSCundoManager::execUndoProc(){
  long num = _undo_proc.getNum();
  if (num > 0){
    WSCundoProc* proc = (WSCundoProc*)_undo_proc.getData(num-1);
    _undo_proc.delPos(num-1);
    proc->execute();
    delete proc;
    if (num == 1){
      WSGIappObjectList()->execEventProc("ve-undo-status-changed");
    }
  }
}
void WSCundoManager::clear(){
  int num = _undo_proc.getNum();
  int i;
  for(i=0;i <num; i++){
    WSCundoProc* proc = (WSCundoProc*)_undo_proc.getData(i);
    _undo_proc.delPos(i);
    delete proc;
  }
  if (num > 0){
    WSGIappObjectList()->execEventProc("ve-undo-status-changed");
  }
  _undo_proc.clear();
}
long WSCundoManager::getNum(){
  return _undo_proc.getNum();
}
WSCundoProc* WSCundoManager::getUndoProc(long pos){
  long num = _undo_proc.getNum();
  if (num == 0){
    return NULL;
  }
  if (pos == -1){
    pos = num -1;
  }
  WSCundoProc* proc = (WSCundoProc*)_undo_proc.getData(pos);
  return proc;
}
WSCundoProc* WSCundoManager::getLastUndoProc(){
  return getUndoProc(-1);
}

#endif
#endif
