//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSDfont.h>
WSMFclassInit(WSDfont,WSDres);

WSDfont::WSDfont(){
  _virtual_flag = False;
  _style = WS_FONT_NORMAL;
}

WSDfont::~WSDfont(){
}
void WSDfont::setFontStyle(unsigned char fl){
  _style = fl;
}
unsigned char WSDfont::getFontStyle(){
  return _style;
}
long WSDfont::setFontName(char* cname){
  if (_virtual_flag != False){
    _virtual_name.setString(cname);
    if (_value1 != -1){
      destroy();
      setValue1(-1);
      setValue2(-1);
      setValue3(-1);
    }
    return WS_NO_ERR;
  }
  return setSrc(cname);
}
char* WSDfont::getFontName(){
  if (_virtual_flag != False){
    return _virtual_name.getString();
  }
  return getSrc();
}
long WSDfont::setPrm(long /*kind*/,long  /*val*/){
  return WS_NO_ERR;
}
long WSDfont::getStringWidth(WSCstring* /*string*/){
  return 0;
}
long WSDfont::getStringHeight(WSCstring* /*string*/){
  return 0;
}
long WSDfont::getStringWidthUCS2(WSCushort* /*string*/){
  return 0;
}
long WSDfont::getStringHeightUCS2(WSCushort* /*string*/){
  return 0;
}
long WSDfont::getStringWidth(char* s,long en){
  WSCstring str;
  str.setString(s,en);
  return getStringWidth(&str);
}
long WSDfont::getStringHeight(char* s,long en){
  WSCstring str;
  str.setString(s,en);
  return getStringHeight(&str);
}

long WSDfont::getFontHeight(){
  return getStringHeight((WSCstring*)NULL);
}
void WSDfont::setVirtualFlag(WSCbool fl){
  _virtual_flag = fl;
}
long WSDfont::getAscent(){
  return 0;
}
long WSDfont::getDescent(){
  return 0;
}
long WSDfont::getCharsByWidth(WSCstring* str,WSCushort width){
  WSCushort* ucs2 = WSGFgetUCS2(str->getString(),WS_EN_DEFAULT);
  if (ucs2 == NULL){
    return 0;
  }
  long len = WSGFstrlenUCS2(ucs2);
  int i;
  int w = 0;
  WSCushort tmp[2];
  tmp[1] = 0;
  for(i=0; i<len; i++){
    tmp[0] = ucs2[i];
    if (tmp[0] == '\n'){
      delete ucs2;
      if (i+1 < len){
        return i+1;
      }else{
        return i;
      }
    }
    long cw = getStringWidthUCS2(tmp);
    if (w + cw  > width){
      delete ucs2;
//printf("getCharsByWidth str=%s ret=%d\n",str->getString(),i);
      return i;
    }
    w = w + cw;
  }
  delete ucs2;
//printf("getCharsByWidth ret=0\n");
  return 0;
}
WSCbool WSDfont::getReady(WSCbool loading){
  if (loading != False){
     long val = getValue1();
     if (val == -1){
       return False;
     }
     return True;
  }
  if (_value1 == -1){
    return False;
  }
  return True;
}
