//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#ifndef NO_WSDTHREAD
#include <WSDthread.h>

WSMFclassInit(WSDthread,WSCroot);

WSDthread* (*WSDthread::_create_handler)() = NULL;


WSDthread::WSDthread(){
  _ptr = NULL;
  _proc = NULL;
  _callback_proc = NULL;
//  _callback_data = NULL;
}

WSDthread::~WSDthread(){
}

WSDthread* WSDthread::getNewInstance(){
  if (_create_handler == NULL){
    return new WSDthread();
  }
  return _create_handler();
}

void* WSDthread::getCreateInstanceHandler(){
  return (void*)_create_handler;
}

void WSDthread::setCreateInstanceHandler(void* hd){
  _create_handler = (WSDthread* (*)())hd;
}



void WSDthread::setFunction(void* (*hd)(WSDthread*,void*)){
  _proc = hd;
};

void* WSDthread::getFunction(){
  return (void*)_proc;
}

void WSDthread::setCallbackFunction(void (*hd)(WSDthread*,void*)){
  _callback_proc = hd;
};

void* WSDthread::getCallbackFunction(){
  return (void*)_callback_proc;
}
long WSDthread::createThread(void*){
WSMFtrace("WSDthread Warring. This system does not support createThread().\n");
  return WS_ERR;
}

long WSDthread::detachThread(){
WSMFtrace("WSDthread Warring. This system does not support detachThread().\n");
  return WS_ERR;
}

long WSDthread::joinThread(void**){
WSMFtrace("WSDthread Warring. This system does not support joinThread().\n");
  return 0;
}

long WSDthread::execCallback(void*){
WSMFtrace("WSDthread Warring. This system does not support execCallback().\n");
  return 0;
}

long WSDthread::terminateThread(){
WSMFtrace("WSDthread Warring. This system does not support terminateThread().\n");
  return 0;
}

long WSDthread::getStatus(){
  return WS_THREAD_STOPPED;
}

//void* WSDthread::getCallbackData(){
//  return _callback_data;
//}
#endif
