//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCpopupMenu.h>
#include <WSCclassInformation.h>
#include <WSDmouse.h>
#include <WSDfont.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>
#include <WSCnwbase.h>
#include <WSCdevice.h>
#include <string.h>
#include <ctype.h>

WSCpopupMenu* WSCpopupMenu::_popuped_instance = NULL;

WSMFguiClassInitialize(WSCpopupMenu,WSCpulldownMenuPopup);

WSCpopupMenu::WSCpopupMenu(WSCbase* base,char* objname):
                WSCpulldownMenuPopup(base,objname){
  _press_state = 0;
  _client = NULL;
  _grabed = 0;
  _internal_popup = 0;

  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNclient,void*, _client,WSSclient );

  WSMFpropertyCreateEnd
}
WSMFproperty( WSCpopupMenu, WSNclient, void*, _client, NULL);

void WSCpopupMenu::setWorkWSNclient(void* data){}
void WSCpopupMenu::getWorkWSNclient(void** data){}

WSCpopupMenu::~WSCpopupMenu(){
  if (_popuped_instance == this){
    _popuped_instance = NULL;
  }
  long i;
  long num = _client_list.getNum();
  for(i=0; i<num; i++){
    WSCbase* client = (WSCbase*)_client_list[i];

    client->setUserData("PM-RGST",(void*)0);
    client->setUserData("PM-SERVER",(void*)0);
    WSCprocedure* op1 = (WSCprocedure*)client->getUserData("PM-BTNPRESS");
    if (op1 != NULL){
      client->delProcedure(op1);
      delete op1;
    }
    WSCprocedure* op2 = (WSCprocedure*)client->getUserData("PM-BTNRELEASE");
    if (op2 != NULL){
      client->delProcedure(op2);
      delete op2;
    }

    WSCprocedure* op3 = (WSCprocedure*)client->getUserData("PM-BTNMOVE");
    if (op3 != NULL){
      client->delProcedure(op3);
      delete op3;
    }

    WSCprocedure* op4 = (WSCprocedure*)client->getUserData("PM-DELETE");
    if (op4 != NULL){
      client->delProcedure(op4);
      delete op4;
    }
  }
}
void WSCpopupMenu::onActivate(){
  execProcedure(WSEV_ACTIVATE);
}
long WSCpopupMenu::_popup_menu(){
  if (_popuped_instance != NULL){
    return WS_ERR;
  }else{
    _popuped_instance = this;
  }
  onActivate();
  short px, py;
  WSCbool ret = WSGIappMouse()->getMousePosition(&px, &py);
  if (ret == False){
    return WS_ERR;
  }

  WSCushort st = _shadow_thick;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    st = 2;
    _shadow_thick = 2;
  }    
  WSCstring str( getProperty(WSNmenuItems) );  

  long num = str.getWords(_separator2);    

  short len = 0;
  short ww = 0;
  short hh = st*2;

  //--- [20041015]
  // We use this variable to determinate if menu will use
  // any pixmap on any option
  WSCbool use_pixmap = False;
  //---

  WSDfont* fn = WSGIappFontSet()->getFont(getFontNo());
  WSCushort h = getItemHeight();
  WSCbool cascaded = False;
  long i =0;
  long cnt = 0;
  for (i=0; i<num; i++) {
    WSCstring item = str.getWord(i, _separator2);
    WSCstring itemName = item.getWord(0, _separator);
    WSCstring itemPrc = item.getWord(1, _separator);

    if (!strcmp(itemName.getString(),"SP") ||
          !strcmp(itemName.getString(),"SEPARATOR")){
      hh += st*2;
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        hh += 4;
      }
    }else{
      if ( !strncmp(itemPrc.getString(),"{",1) ){
        cascaded = True;
        long wpos = str.getWordCharPos(i, _separator2);
        WSCstring tmp(str.getString());
        tmp.deleteChars(0,wpos);
        wpos = tmp.getWordCharPos(1,"{");
        tmp.deleteChars(0,wpos);
        char* tstr = tmp.getString(WS_EN_UTF8);
        long len = strlen(tstr);
        long num_of_conma = 0;
        long j;
        long layers = 0;
        for(j=0; j< len; j++){
          if (tstr[j] == '}'){
            if (layers == 0){
              tstr[j] = 0;
              break;
            }else{
              layers--;
            }
          }
          if (tstr[j] == '{'){
            layers++;
          }
          if (tstr[j] == _separator2[0]){
            num_of_conma++;
          }
        }
        i += num_of_conma;
      }
      hh += h;
      cnt++;
    }
//--- [20041015]
    // Here, we have to determinate if puldownMenuPopup of first level
    // will have pixmaps. We need to activate use_pixmap only if there
    // is a fifth option in menu item string and if this menu item string
    // doesn't content a sub-menu. This is, if this menu item string
    // hasn't got "{" symbol at second option.
    WSCstring tmp_second_opt = item.getWord(1, _separator);
    if ((strlen(item.getWord(4, _separator).getString()) > 0) &&
        !(strchr(tmp_second_opt.getString(), '{'))){
      use_pixmap = True;
    }
//---

    if (len < (short)strlen(itemName.getString())) {
      len = (short)strlen(itemName.getString());
      WSCstring space(" ");
      WSCushort smargin = WSGIappFontSet()->getStringWidth(getFontNo(),&space);
      ww = (short)fn->getStringWidth(&itemName) + st * 2 + st * 2 + smargin;
    }
  }

  //--- [20041015]
  // Here, if there are pixmaps, we need to make pulldownMenuPopup
  // 24 pixles + smargin widest
  if (use_pixmap != False){
    WSCstring space(" ");
    WSCushort smargin = WSGIappFontSet()->getStringWidth(_font,&space);
    ww = ww + 32;
  }
  //---
  WSCpulldownData* own_pld = (WSCpulldownData*)_pld_data;
  if (own_pld->_is_toggle(get_parent_pld_data()) != False){
      ww += 32;
  }

  //Υڡγ
  if (cascaded != False){
      ww += 30;
  }
  WSCulong dw = WSGIappDev()->getWidth();
  if (px < dw){
    if (px + ww > dw) {
      px -= (px + ww - WSGIappDev()->getWidth());
    }
  }

  WSCulong dh = WSGIappDev()->getHeight();
  if (py < dh){
    if (py + hh > dh) {
      py -= (py + hh - WSGIappDev()->getHeight());
    }
  }

//WSMFtrace("WSCpopupMenu::popup %d %d %d %d   st=%d ih=%d\n",px,py,ww,hh,st,h+st*2);

  setPropertyV(WSNx,(short)px);
  setPropertyV(WSNy,(short)py);
//  setPropertyV(WSNmenuItemHeight,(WSCushort)(h + st*2));
  setPropertyV(WSNwidth,(WSCushort)(ww));
  setPropertyV(WSNheight,(WSCushort)(hh));
  set_id_value(0);
  setVisible(True);

  //--- [20041015]
  set_use_pixmap(use_pixmap);
  //---
  if (getVisible() == False){
    return WS_ERR;
  }
  WSGIappKeyboard()->setFocusInputWorkProc(_key_handler,NULL,this,this);
  return WS_NO_ERR;
}
#if 0
long WSCpopupMenu::popdown(){
  if (_popuped_instance == this){
    _popuped_instance = NULL;
  }
  setVisible(False);
  _selected = False;
  _client = NULL;
  return WS_NO_ERR;
}
#endif
long WSCpopupMenu::_popdown_and_execute(){
  WSGIappKeyboard()->resetFocusInputWorkProc();
  if (_popuped_instance == this){
    _popuped_instance = NULL;
  }
  _press_state = 0;
  WSGIappDev()->setPopupModalClient(NULL);
  setVisible(False);
  if (strcmp(getProcName(),"")){
    execProcedure(getProcName());
  }
  _selected = False;
  _client = NULL;
  _internal_popup = False;
  return WS_NO_ERR;
}
long WSCpopupMenu::popdown(){
  if (_grabed != False){
    WSDdev* dev = getowndev();
    WSCbool fl = False;
    if (dev != NULL){
      WSGIappMouse()->setMouseUngrabClient(NULL);
      dev->setValue(WSDEV_GRAB_POINTER,&fl);
    }
    _grabed = False;
  }

  WSGIappKeyboard()->resetFocusInputWorkProc();
  if (_popuped_instance == this){
    _popuped_instance = NULL;
  }
  _press_state = 0;
  WSGIappDev()->setPopupModalClient(NULL);
  setVisible(False);
  _selected = False;
  _client = NULL;
  _internal_popup = False;
  return WS_NO_ERR;
}
long WSCpopupMenu::registerClient(WSCbase* client,WSCbool recursive){
  long registered = (long)client->getUserData("PM-RGST");
  if (registered == 1){
    return WS_NO_ERR;
  }

  _client_list.add((void*)client);

  client->setUserData("PM-RGST",(void*)1);
  client->setUserData("PM-SERVER",(void*)this);

  long trg1 = WSEV_MOUSE_PRESS;
  long trg2 = WSEV_MOUSE_RELEASE;
  long trg3 = WSEV_MOUSE_MOVE;

  WSCprocedure* btnpress = new WSCprocedure("PM_btn_press",trg1);
  btnpress->setFunction(_on_btn_press,"_on_btn_press");
  btnpress->setInternal(True);
  client->addProcedure(btnpress);
  client->setUserData("PM-BTNPRESS",(void*)btnpress);

  WSCprocedure* btnrelease = new WSCprocedure("PM_btn_release",trg2);
  btnrelease->setFunction(_on_btn_release,"_on_btn_release");
  btnrelease->setInternal(True);
  client->addProcedure(btnrelease);
  client->setUserData("PM-BTNRELEASE",(void*)btnrelease);

  WSCprocedure* btnmove = new WSCprocedure("PM_btn_move",trg3);
  btnmove->setFunction(_on_btn_move,"_on_btn_move");
  btnmove->setInternal(True);
  client->addProcedure(btnmove);
  client->setUserData("PM-BTNMOVE",(void*)btnmove);

  WSCprocedure* idelete = new WSCprocedure("PM_idelete",WSEV_DELETE);
  idelete->setFunction(_on_delete,"_on_delete");
  idelete->setInternal(True);
  client->addProcedure(idelete);
  client->setUserData("PM-DELETE",(void*)idelete);

  if (recursive != False){
    long val =(long)recursive;
    client->setUserData("PM-RECURSIVE",(void*)val);
    WSClistData children = client->getChildren();
    long i,num;
    num = children.getNum();
    for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getObjectType() & WS_TYPE_MANAGER){
        _registerClient(child,True);
      }
    } 
  }
  return WS_NO_ERR;
}
long WSCpopupMenu::_registerClient(WSCbase* client,WSCbool recursive){
  long registered = (long)client->getUserData("PM-RGST");
  if (registered == 1){
    return WS_NO_ERR;
  }

  _client_list.add((void*)client);

  client->setUserData("PM-RGST",(void*)1);
  client->setUserData("PM-SERVER",(void*)this);

  long trg1 = WSEV_MOUSE_PRESS;
  long trg2 = WSEV_MOUSE_RELEASE;
  long trg3 = WSEV_MOUSE_MOVE;

  WSCprocedure* btnpress = new WSCprocedure("PM_btn_press",trg1);
  btnpress->setFunction(_on_btn_press_recursive,"_on_btn_press_recursive");
  btnpress->setInternal(True);
  client->addProcedure(btnpress);
  client->setUserData("PM-BTNPRESS",(void*)btnpress);

  WSCprocedure* btnrelease = new WSCprocedure("PM_btn_release",trg2);
  btnrelease->setFunction(_on_btn_release_recursive,"_on_btn_release_recursive");
  btnrelease->setInternal(True);
  client->addProcedure(btnrelease);
  client->setUserData("PM-BTNRELEASE",(void*)btnrelease);

  WSCprocedure* btnmove = new WSCprocedure("PM_btn_move",trg3);
  btnmove->setFunction(_on_btn_move_recursive,"_on_btn_move_recursive");
  btnmove->setInternal(True);
  client->addProcedure(btnmove);
  client->setUserData("PM-BTNMOVE",(void*)btnmove);

  WSCprocedure* idelete = new WSCprocedure("PM_idelete",WSEV_DELETE);
  idelete->setFunction(_on_delete,"_on_delete");
  idelete->setInternal(True);
  client->addProcedure(idelete);
  client->setUserData("PM-DELETE",(void*)idelete);


  if (recursive != False){
    long val =(long)recursive;
    client->setUserData("PM-RECURSIVE",(void*)val);
    WSClistData children = client->getChildren();
    long i,num;
    num = children.getNum();
    for(i=0; i<num; i++){
      WSCbase* child = (WSCbase*)children[i];
      if (child->getObjectType() & WS_TYPE_MANAGER){
        _registerClient(child,True);
      }
    } 
  }
  return WS_NO_ERR;
}

long WSCpopupMenu::unregisterClient(WSCbase* client){
  _client_list.del((void*)client);
  long registered = (long)client->getUserData("PM-RGST");
  long val =(long)client->getUserData("PM-RECURSIVE");
  WSCpopupMenu* serv = (WSCpopupMenu*)client->getUserData("PM-SERVER");

  if (registered == 1 && serv == this){
    client->setUserData("PM-RGST",(void*)0);
    client->setUserData("PM-SERVER",(void*)0);

    WSCprocedure* op1 = (WSCprocedure*)client->getUserData("PM-BTNPRESS");
    if (op1 != NULL){
      client->delProcedure(op1);
      delete op1;
    }
    WSCprocedure* op2 = (WSCprocedure*)client->getUserData("PM-BTNRELEASE");
    if (op2 != NULL){
      client->delProcedure(op2);
      delete op2;
    }

    WSCprocedure* op3 = (WSCprocedure*)client->getUserData("PM-BTNMOVE");
    if (op3 != NULL){
      client->delProcedure(op3);
      delete op3;
    }

    WSCprocedure* op4 = (WSCprocedure*)client->getUserData("PM-DELETE");
    if (op4 != NULL){
      client->delProcedure(op4);
      delete op4;
    }

    if( val != False){
      client->setUserData("PM-RECURSIVE",(void*)0);
      WSClistData children = client->getChildren();
      long i,num;
      num = children.getNum();
      for(i=0; i<num; i++){
        WSCbase* child = (WSCbase*)children[i];
        if (child->getObjectType() & WS_TYPE_MANAGER){
          unregisterClient(child);
        }
      } 
    }
  }
  return WS_NO_ERR;
}

void WSCpopupMenu::_on_delete(WSCbase* client){
  WSCpopupMenu* obj = (WSCpopupMenu*)client->getUserData("PM-SERVER");
  if (obj == NULL){
    return;
  }
  obj->unregisterClient(client);
}
void WSCpopupMenu::_on_btn_press(WSCbase* client){
//printf("WSCpopupMenu::_on_btn_press press... client=%s\n",client->getInstanceName());
  WSCbase* mt =  (WSCbase*)client->getUserData("PM-MODAL-TARGET");
  client->setUserData("PM-MODAL-TARGET",NULL);
  WSCbase* tclient = client;
  if (mt != NULL){
    tclient = mt;
  }

  if (_popuped_instance != NULL){
    return;
  }
  if (WSGIappMouse()->getTargetBtn() != WS_MOUSE_BTN3){
    return;
  }
  WSCpopupMenu* obj = (WSCpopupMenu*)client->getUserData("PM-SERVER");
  if (obj == NULL){
    return;
  }
  if (obj->_client != NULL && obj->_client != (void*)client){
    return;
  }
  if (client->getSensitive() == False){
    return;
  }
  if (obj->_press_state != False){
    return;
  }
  client->setUserData("PM-POPUP",(void*)1);
  obj->_press_state = True;
  WSCnwbase* vpbase = (WSCnwbase*)tclient->cast("WSCnwbase");
  if (vpbase != NULL){
    if (vpbase->getOutSideMousePress() == False){
      vpbase->setOutSideMousePress(True);
      vpbase->setUserData("OSMP-ch",(void*)1);
    }
    if (vpbase->getOutSideMouseMove() == False){
      vpbase->setOutSideMouseMove(True);
      vpbase->setUserData("OSMM-ch",(void*)1);
    }
    if (vpbase->getOutSideMouseRelease() == False){
      vpbase->setOutSideMouseRelease(True);
      vpbase->setUserData("OSMR-ch",(void*)1);
    }
    if (vpbase->getMouseGrabed() == False){
      vpbase->setMouseGrabed(True);
      vpbase->setUserData("MG-ch",(void*)1);
    }
  }
  obj->_client = (void*)client;
  long ret = obj->_popup_menu();
  if (ret != WS_ERR){
    WSGIappDev()->setPopupModalClient(tclient);
    client->setUserData(WS_PM_POPUPED,(void*)1);
  }
}



void WSCpopupMenu::_on_btn_release(WSCbase* client){
//printf("WSCpopupMenu::_on_btn_release... client=%s\n",client->getInstanceName());
  WSCpopupMenu* obj = (WSCpopupMenu*)client->getUserData("PM-SERVER");
  if (obj == NULL){
    return;
  }
  if (obj->getVisible() == False){
    return;
  }

  WSCbase* mt =  (WSCbase*)client->getUserData("PM-MODAL-TARGET");
  client->setUserData("PM-MODAL-TARGET",NULL);
  WSCbase* tclient = client;
  if (mt != NULL){
    tclient = mt;
  } 

  if (obj->_client != NULL && obj->_client != (void*)client){
    return;
  }
  if (obj->_grabed == 0){
    if (WSGIappMouse()->getTargetBtn() != WS_MOUSE_BTN3){
//printf("WSCpopupMenu::_on_btn_release returned..\n");
      return;
    }
  }

  if (obj->_grabed == 0 && obj->_selected == False){
    WSDdev* dev = tclient->getowndev();
//WSMFtrace("WSCpopupMenu::_on_btn_release here----------- client=%s\n",client->getInstanceName()); 
    if (tclient->cast("WSCnwbase")!=0){
      dev = tclient->getParentDev();
    }
    if (dev != NULL){
//printf("_on_btn_release.. grab.. devdl=%s\n",dev->getAttachedClient()->getInstanceName());
//WSMFtrace("WSCpopupMenu::_on_btn_release grabed  %s!!!!!!!!!!!!\n",dev->getClassName());
      obj->_modal_bk = WSGIappDev()->getModalClient();
      WSGIappDev()->setModalClient(tclient);
      WSCbool fl = True;
      WSGIappMouse()->setMouseUngrabClient(obj);
      dev->setValue(WSDEV_GRAB_POINTER,&fl);
      obj->_grabed = True;
      if (tclient->cast("WSCnwbase") != NULL){
        WSCnwbase* nwbase = (WSCnwbase*)client->cast("WSCnwbase");
        nwbase->setMouseGrabed(True);
      }
    }
//printf("popup:: grabed...\n");
    return;
  }else if (obj->_grabed != 0){
    WSCbool fl = False;
    WSDdev* dev = tclient->getdev();
    if (tclient->cast("WSCnwbase")!=0){
      dev = tclient->getParentDev();
    }
    if (dev != NULL){
//WSMFtrace("WSCpopupMenu::_on_btn_press grab -> false\n");
      WSGIappDev()->setModalClient(obj->_modal_bk);
      WSGIappMouse()->setMouseUngrabClient(NULL);
      dev->setValue(WSDEV_GRAB_POINTER,&fl);
      obj->_grabed = False;
//printf("popup:: grabed canceled...\n");
    }
  } 
 
  if ((long)client->getUserData("PM-POPUP") == 0){
    return;
  }
  WSCnwbase* vpbase = (WSCnwbase*)tclient->cast("WSCnwbase");
  if (vpbase != NULL){
    if ((long)vpbase->getUserData("OSMP-ch") == 1){
      vpbase->setOutSideMousePress(False);
      vpbase->setUserData("OSMP-ch",(void*)0);
    }
    if ((long)vpbase->getUserData("OSMM-ch") == 1){
      vpbase->setOutSideMouseMove(False);
      vpbase->setUserData("OSMM-ch",(void*)0);
    }
    if ((long)vpbase->getUserData("OSMR-ch") == 1){
      vpbase->setOutSideMouseRelease(False);
      vpbase->setUserData("OSMR-ch",(void*)0);
    }
    if ((long)vpbase->getUserData("MG-ch") == 1){
      vpbase->setMouseGrabed(False);
      vpbase->setUserData("MG-ch",(void*)0);
    }
  }
  client->setUserData(WS_PM_POPUPED,(void*)0);
  long val = obj->getValue();
  if (obj->getValueToggleMenu(val) != False &&
      obj->getValueSensitive(val) != False){
    WSCbool fl = obj->getValueToggleState(val);
    if (fl == False){
      obj->setValueToggleState(val,True);
    }else{
      obj->setValueToggleState(val,False);
    }
  }
  obj->execProcedure(WSEV_VALUE_CH);

  obj->_popdown_and_execute();
//printf("popup:: popdown...\n");
}

void WSCpopupMenu::_on_btn_move(WSCbase* client){
  WSCpopupMenu* obj = (WSCpopupMenu*)client->getUserData("PM-SERVER");
  if (obj == NULL){
    return;
  }
//WSMFtrace("WSCpopupMenu::_on_btn_move()  grabed=%d\n",obj->_grabed);
  if (obj->_grabed == False){
//    if (WSGIappMouse()->getTargetBtn() != WS_MOUSE_BTN3){
    if ((WSGIappMouse()->getStatus() & WS_MOUSE_BTN3) == 0){
      return;
    }
  }
  if ((long)client->getUserData("PM-POPUP") == 0){
    return;
  }
  short x, y;
  WSCbool ret = WSGIappMouse()->getMousePosition(&x, &y);
  if (ret != False){
    obj->setAbsoluteDraw(True);
    obj->draw();
  }
}

void WSCpopupMenu::_on_btn_press_recursive(WSCbase* client){
  WSCpopupMenu* obj = (WSCpopupMenu*)client->getUserData("PM-SERVER");
  WSCbase* parent = client->getParent();
  if (parent != NULL){
    WSCpopupMenu* obj2 = (WSCpopupMenu*)parent->getUserData("PM-SERVER");
    if (obj == obj2){
      if (client->getUserData("PM-MODAL-TARGET") == NULL){
        parent->setUserData("PM-MODAL-TARGET",(void*)client);
      }else{
        parent->setUserData("PM-MODAL-TARGET",
                            client->getUserData("PM-MODAL-TARGET"));
        client->setUserData("PM-MODAL-TARGET",NULL);
      }
      parent->execProcedure("PM_btn_press");
    }
  }
}
void WSCpopupMenu::_on_btn_release_recursive(WSCbase* client){
  WSCpopupMenu* obj = (WSCpopupMenu*)client->getUserData("PM-SERVER");
  WSCbase* parent = client->getParent();
  if (parent != NULL){
    WSCpopupMenu* obj2 = (WSCpopupMenu*)parent->getUserData("PM-SERVER");
    if (obj == obj2){
      if (client->getUserData("PM-MODAL-TARGET") == NULL){
        parent->setUserData("PM-MODAL-TARGET",(void*)client);
      }else{
        parent->setUserData("PM-MODAL-TARGET",
                            client->getUserData("PM-MODAL-TARGET"));
        client->setUserData("PM-MODAL-TARGET",NULL);
      }
      parent->execProcedure("PM_btn_release");
    }
  }
}
void WSCpopupMenu::_on_btn_move_recursive(WSCbase* client){
  WSCpopupMenu* obj = (WSCpopupMenu*)client->getUserData("PM-SERVER");
  WSCbase* parent = client->getParent();
  if (parent != NULL){
    WSCpopupMenu* obj2 = (WSCpopupMenu*)parent->getUserData("PM-SERVER");
    if (obj == obj2){
      parent->execProcedure("PM_btn_move");
    }
  }
}

long WSCpopupMenu::beginCascade(char* lb){
  WSCstring str(_menu_string);
  str.delHeadSpace();
  str.delTailSpace();
  if (strcmp(str.getString(),"")){
    str += _separator2;
  }
  str = str + lb + _separator + "{";
  setPropertyV(WSNmenuItems,str.getString());
  return WS_NO_ERR;
}
long WSCpopupMenu::endCascade(){
  WSCstring str(_menu_string);
  str += "}";
  setPropertyV(WSNmenuItems,str.getString());
  return WS_NO_ERR;
}
long WSCpopupMenu::addItem(char* lb,char* op,char* sc,long id,char *px){
//---
  WSCstring str(_menu_string);
  if (_menu_string[0] != 0 && _menu_string[strlen(_menu_string)-1] != '{'){
    str += _separator2;
  }
//--- [20041015]
  if (px == NULL){
    str = str + lb + _separator + op + _separator + sc + _separator + WSGFltoa(id);
  }else{
    str = str + lb + _separator + op + _separator + sc + _separator + WSGFltoa(id) + _separator + px;
  }
//---
  setPropertyV(WSNmenuItems,str.getString());
  return WS_NO_ERR;
}

long WSCpopupMenu::popup(){
  _internal_popup = True;
  int ret = _popup_menu();
  if (ret == WS_ERR){
    return ret;
  }
  WSDdev* dev = getowndev();
  if (dev != NULL){
    WSCbool fl = True;
    WSGIappMouse()->setMouseUngrabClient(this);
    dev->setValue(WSDEV_GRAB_POINTER,&fl);
    _grabed = True;
    dev->setEnableEventBit( WSEV_MOUSE_MOVE_BIT | WSEV_MOUSE_OUT_BIT |
                            WSEV_MOUSE_IN_BIT |
                            WSEV_MOUSE_PRESS_BIT | WSEV_MOUSE_RELEASE_BIT );
  }
  WSGIappDev()->setFocusDialog(this,True);

  while(1){
    if (_internal_popup == 0){
      break;
    }
    WSGIappDev()->setFocusDialog(this,True);
    WSGIappDev()->dispatchEvent();
    WSGIappDevice()->clearDeleteList();
  }
  return WS_NO_ERR;
}

void WSCpopupMenu::onMousePress(WSCpoint* pt){
  if (_internal_popup == False){
    return;
  }
}
void WSCpopupMenu::onMouseMove(WSCpoint* pt){
  if (_internal_popup == False){
    return;
  }
  short x, y;
  WSCbool ret = WSGIappMouse()->getMousePosition(&x, &y);
  if (ret != False){
    setAbsoluteDraw(True);
    draw();
  }
}
void WSCpopupMenu::onMouseRelease(WSCpoint* pt){
  if (_internal_popup == False){
    return;
  }
  if (_grabed != False){
    WSDdev* dev = getowndev();
    WSCbool fl = False;
    if (dev != NULL){
      WSGIappMouse()->setMouseUngrabClient(NULL);
      dev->setValue(WSDEV_GRAB_POINTER,&fl);
    }
    _grabed = False;
  }
  if (_selected != False){
    long val = getValue();
    if (getValueToggleMenu(val) != False &&
        getValueSensitive(val) != False){
      WSCbool fl = getValueToggleState(val);
      if (fl == False){
        setValueToggleState(val,True);
      }else{
        setValueToggleState(val,False);
      }
    }
    execProcedure(WSEV_VALUE_CH);

    _popdown_and_execute();




  }else{
    _internal_popup = False;
    WSGIappKeyboard()->resetFocusInputWorkProc();
    setVisible(False);
    if (_popuped_instance == this){
      _popuped_instance = NULL;
    }
    _client = NULL;
  }
}
void WSCpopupMenu::_key_handler(void* ptr,WSDkeyboard* keyboard,WSCbool fl){
  WSCpopupMenu* obj = (WSCpopupMenu*)ptr;
  if (fl != False){
    long key = keyboard->getKey();
    char* text = keyboard->getText();
    if (obj->getVisible() != False){
      char buf[2];
      buf[0] = (char)toupper(text[0]);
      buf[1] = 0;
//      WSCstring pname = obj->_get_proc_name_by_sc(obj->_menu_str,buf);
      int act_val = -1;
      WSCstring pname = obj->_get_proc_name_by_sc(buf,&act_val);
      if (strcmp(buf,"") && strcmp((char*)pname,"")){
        obj->popdown();
//XXZZXXXZZZ // ݥåץåפ
        if (obj->getValueToggleMenu(act_val) != False &&
            obj->getValueSensitive(act_val) != False){
          WSCbool fl = obj->getValueToggleState(act_val);
          if (fl == False){
            obj->setValueToggleState(act_val,True);
          }else{
            obj->setValueToggleState(act_val,False);
          }
        }
        obj->execProcedure(WSEV_VALUE_CH);
            
        if (obj->getSensitive() != False){
          obj->onActivate();
          obj->execProcedure((char*)pname);
        }

      }else
      if (key == WSK_Up || key == WSK_Down || key == WSK_Left || key == WSK_Right){
        obj->setUserData("KEY_PROCESSED",(void*)0);
        obj->onKeyPress(keyboard,fl);
      }else
      if (key == WSK_Escape || key == WSK_Super_L || key == WSK_Super_R ||
          key == WSK_Control_L || key == WSK_Control_R || key == WSK_Apps ||
          key == WSK_Alt_L || key == WSK_Alt_R ||
          key == WSK_Meta_L || key == WSK_Meta_R ){

        obj->setSelected(False);
        WSCpoint pt;
        pt.x = 0;
        pt.y = 0;
        obj->onMousePress(&pt);
        obj->onMouseRelease(&pt);
        keyboard->setKey(0);
      }
      if (key == WSK_Return || key == WSK_KP_Enter){
        WSCpoint pt;
        pt.x = 0;
        pt.y = 0;
        obj->onMousePress(&pt);
        obj->onMouseRelease(&pt);
      }
    }
  }
}
long WSCpopupMenu::execEventProc(long ev,void* data){
  if (ev == WSEV_GRAB_CANCELED){
    popdown();
  }
  return WSCpulldownMenuPopup::execEventProc(ev,data);
}
