//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCvballoonHelp.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>
#include <WSCbaseList.h>
#include <WSCballoonHelp.h>

WSMFguiClassInitialize(WSCvballoonHelp, WSCngbase);
WSMFversion(WSCvballoonHelp, WSCngbase);

WSCvballoonHelp::WSCvballoonHelp(WSCbase* base, char* objname):
			WSCngbase(base, objname){

  _title_string.setString("b-help\nclient: none");
  _label_string = NULL;
  _client = NULL;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvballoonHelp);

    WSMFpropertyCreate(WSNclient,  char*, _client,WSSclient);
    WSMFpropertyCreate(WSNlabelString,  char*, _label_string,WSSlabelString);

    WSMFaddTrigger(WSEV_ACTIVATE  );


  WSMFpropertyCreateEnd

}
WSMFproperty( WSCvballoonHelp, WSNclient, char*, _client ,NULL);
WSMFproperty( WSCvballoonHelp, WSNclient, char*, _label_string ,NULL);

void WSCvballoonHelp::setWorkWSNclient(char*){
  _register();
};
void WSCvballoonHelp::getWorkWSNclient(char**){};
void WSCvballoonHelp::setWorkWSNlabelString(char*){
  _register();
};
void WSCvballoonHelp::getWorkWSNlabelString(char**){};

WSCvballoonHelp::~WSCvballoonHelp() {
  if (_label_string != NULL){
    delete _label_string;
    _label_string = NULL;
  }
  if (_client == NULL){
    delete _client;
    _client = NULL;
  }
}
void WSCvballoonHelp::_register(){
  if (_client == NULL || _client[0] == 0){
    return;
  }
  WSCbase* client = WSGIappObjectList()->getInstance("WSCbase",_client);
  if (client == NULL){
    return;
  }
  _title_string.setString("b-help\n");
  _title_string << "client:" << _client;
  WSGIappBalloonHelp()->unregisterClient(client);
  char* lstr = _label_string;
  if (lstr == NULL){
    lstr = "";
  }
  WSGIappBalloonHelp()->registerClient(client,lstr);
}
char* WSCvballoonHelp::getDefaultProperty(){
  return WSNlabelString;
}
