//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCvlineGraph.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>
#include <WSCbaseList.h>

WSMFguiClassInitialize(WSCvlineGraph, WSCnwbase);
WSMFversion(WSCvlineGraph, WSCnwbase);

WSCvlineGraph::WSCvlineGraph(WSCbase* base, char* objname):
			WSCnwbase(base, objname){
  _values = WSGFstrdup("0,30,20,40,10,50,10,80,50,70");
  _barw = 10;
  _orientation  = WS_VERTICAL;
  _rev = False;
  _num = 10;
  _lw = 2;
  _lt = 0;
  _stippled = False;
  _hatch_pattern = 0;
  _hatch_color = WS_DF_NWBACKCOLOR;
  _data_source_name = NULL;
  _data_source_type = WS_DATA_SOURCE_NONE;
  _need_ds_update = False;
  _bg_blink_color = WS_DF_NWBACKCOLOR;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvlineGraph);

    WSMFpropertyCreate(WSNvalue,  char*,   _values,WSSvalue);
    WSMFpropertyCreate(WSNcolumns, WSCushort, _num,WSScolumns);
    WSMFpropertyCreate(WSNbarThickness,  WSCuchar, _barw,WSSbarThickness);
    WSMFpropertyCreate(WSNorientation,  WSCuchar, _orientation,WSSorientation);
      WSMFpropertySetSelection(WSRorientation, WSRorientationD);
    WSMFpropertyCreate(WSNreverseFlag,  WSCbool, _rev,WSSreverseFlag);
      WSMFpropertySetSelection(WSRbool, WSRboolD);
    WSMFpropertyCreate(WSNlineWidth, WSCuchar, _lw,WSSlineWidth);
    WSMFpropertyCreate(WSNlineType,  WSCuchar, _lt,WSSlineType);
      WSMFpropertySetSelection(WSRlineType, WSRlineTypeD);
    WSMFpropertyCreate(WSNstippled,WSCbool,_stippled,WSSstippled );
      WSMFpropertySetSelection(WSRbool4, WSRbool4D);
    WSMFpropertyCreate(WSNhatchPattern,WSCuchar,_hatch_pattern,WSShatchPattern);
      WSMFpropertySetSelection(WSRhatchPattern, WSRhatchPatternD);
    WSMFpropertyCreate(WSNhatchColor,short,_hatch_color,WSShatchColor);
    WSMFpropertyCreate(WSNdataSource, WSCuchar, _data_source_type,WSSdataSource );
      WSMFpropertySetSelection(WSRdataSource,WSRdataSourceD);
    WSMFpropertyCreate(WSNdataSourceName, char*, _data_source_name,WSSdataSourceName );
    WSMFpropertyCreate(WSNbackBlinkColor, short,   _bg_blink_color,WSSbackBlinkColor);

  WSMFpropertyCreateEnd

}
WSMFproperty( WSCvlineGraph, WSNvalue, char*, _values ,WSGFstrdup("0,30,20,40,10,50,10,80,50,70"));
WSMFproperty( WSCvlineGraph, WSNcolumns, WSCushort, _num ,10);
WSMFproperty( WSCvlineGraph, WSNbarThickness, WSCuchar, _barw ,10);
WSMFproperty( WSCvlineGraph, WSNorientation, WSCuchar, _orientation ,WS_VERTICAL);
WSMFproperty( WSCvlineGraph, WSNreverseFlag, WSCbool, _rev ,False);
WSMFproperty( WSCvlineGraph, WSNlineWidth, WSCuchar, _lw, 2);
WSMFproperty( WSCvlineGraph, WSNlineType,  WSCuchar,      _lt, 0);
WSMFproperty( WSCvlineGraph, WSNstippled,  WSCbool,_stippled,     False);
WSMFproperty( WSCvlineGraph, WSNhatchPattern, WSCuchar,   _hatch_pattern,0    );
WSMFproperty( WSCvlineGraph, WSNhatchColor,  short,  _hatch_color,WS_DF_NWBACKCOLOR);
WSMFproperty( WSCvlineGraph, WSNdataSource,  WSCuchar, _data_source_type,WS_DATA_SOURCE_NONE);
WSMFproperty( WSCvlineGraph, WSNdataSourceName,  char*, _data_source_name,NULL);
WSMFproperty( WSCvlineGraph, WSNbackBlinkColor,    short,        _bg_blink_color, WS_DF_NWBACKCOLOR);

void WSCvlineGraph::_set_ds_instance(){
  char* val = _data_source_name;
  if (val == NULL){
    _need_ds_update = True;
    return;
  }
  WSCbase* serv = WSGIappObjectList()->searchInstance("WSCbase", _data_source_name);
  if (serv != NULL){
    setDataSourceServer(serv);
    serv->addDataSourceClient(this);
    WSCstring val;
    val = serv->getProperty(serv->getDefaultProperty());
    setProperty(WSNvalue,val);
  }else{
    _need_ds_update = True;
  }
}

void WSCvlineGraph::setWorkWSNdataSource(WSCuchar){
  if (_data_source_name != NULL && _data_source_name[0] != 0){
    if (_data_source_type == WS_DATA_SOURCE_FILE){
      WSCstring* str = WSGFreadTextFile(_data_source_name);
      if (str != NULL){
        setProperty(WSNvalue,str->getString());
        delete str;
      }
    }else
    if (_data_source_type == WS_DATA_SOURCE_INSTANCE){
      _set_ds_instance();
    }
    if (_data_source_type != WS_DATA_SOURCE_INSTANCE){
      WSCbase* ds = getDataSourceServer();
      if (ds != NULL){
        ds->delDataSourceClient(this);
        setDataSourceServer(NULL);
      }
    }
  }
}
void WSCvlineGraph::getWorkWSNdataSource(WSCuchar*){}
void WSCvlineGraph::setWorkWSNdataSourceName(char* sname){
  if (_data_source_type == WS_DATA_SOURCE_INSTANCE){
    _set_ds_instance();
  }else
  if (_data_source_type == WS_DATA_SOURCE_FILE){
    WSCstring* str = WSGFreadTextFile(sname);
    if (str != NULL){
      setProperty(WSNvalue,str->getString());
      delete str;
    }
  }
}
void WSCvlineGraph::getWorkWSNdataSourceName(char** sname){};



void WSCvlineGraph::setWorkWSNvalue(char*){};
void WSCvlineGraph::getWorkWSNvalue(char**){};
void WSCvlineGraph::setWorkWSNcolumns(WSCushort){};
void WSCvlineGraph::getWorkWSNcolumns(WSCushort*){};
void WSCvlineGraph::setWorkWSNbarThickness(WSCuchar){};
void WSCvlineGraph::getWorkWSNbarThickness(WSCuchar*){};
void WSCvlineGraph::setWorkWSNorientation(WSCuchar){};
void WSCvlineGraph::getWorkWSNorientation(WSCuchar*){};
void WSCvlineGraph::setWorkWSNreverseFlag(WSCbool){};
void WSCvlineGraph::getWorkWSNreverseFlag(WSCbool*){};
void WSCvlineGraph::setWorkWSNlineWidth(WSCuchar){ }
void WSCvlineGraph::getWorkWSNlineWidth(WSCuchar*){ }
void WSCvlineGraph::setWorkWSNlineType(WSCuchar){ }
void WSCvlineGraph::getWorkWSNlineType(WSCuchar*){ }
void WSCvlineGraph::setWorkWSNstippled(WSCbool){ }
void WSCvlineGraph::getWorkWSNstippled(WSCbool*){ }
void WSCvlineGraph::setWorkWSNhatchPattern(WSCuchar){ }
void WSCvlineGraph::getWorkWSNhatchPattern(WSCuchar*){ }
void WSCvlineGraph::setWorkWSNhatchColor(short){ }
void WSCvlineGraph::getWorkWSNhatchColor(short*){ }
void WSCvlineGraph::setWorkWSNbackBlinkColor(short){ }
void WSCvlineGraph::getWorkWSNbackBlinkColor(short*){ }

WSCvlineGraph::~WSCvlineGraph() {
  if (_values != NULL){
    delete[] _values;
    _values = NULL;
  }
  if (_data_source_name != NULL){
    delete[] _data_source_name;
    _data_source_name = NULL;
    
  }
}

long WSCvlineGraph::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  if (_num == 0){
    return WS_NO_ERR;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;
  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False && dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }
  WSCbool blinkfore = WSGIappBlink()->getBlinkFore(_blink_rate);

  if (_bl_fl == True &&
      blinkfore == True &&
      _tw_fl == False) {
    return WS_NO_ERR;
  }

  WSCbase::update();
  setAbsoluteDraw(False);
  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
     return WS_NO_ERR;
  }
  if (_orientation == WS_VERTICAL){
    h -= _lw;
  }else{
    w -= _lw;
  }
  long i;
  if (_num < 2){
    _num = 2;
  }
  double interval = (double)w/(_num-1);
  if (_orientation != WS_VERTICAL){
    interval = (double)h/(_num-1);
  }

  WSCstring vlist(_values);
  long lnum = vlist.getWords(",");
  long num = _num;
  if (lnum < _num){
    num = lnum;
  }
  WSCbool not_draw = False;
  dev->setLineWidth(0);
  dev->setHatchPattern(_hatch_pattern);
//  dev->setForeColor(_hatch_color);
  if (_bl_fl != False){
    if (_tw_fl == False){
      if (blinkfore == False){
        dev->setForeColor(_hatch_color);
      }else{
        not_draw = True;
      }
    }else{
      if (blinkfore == False){
        dev->setForeColor(_hatch_color);
      }else{
        dev->setForeColor(_bg_blink_color);
      }
    }
  }else{
    dev->setForeColor(_hatch_color);
  }

  WSCpoint* points = NULL;
  if (_stippled == False){
    points = new WSCpoint[num];
  }else{
    points = new WSCpoint[num+2];
  }
  if (points == NULL){
    dev->endDraw();
    return WS_ERR;
  }
  if (_stippled != False && not_draw == False){
    if (_orientation == WS_VERTICAL){
      long na_pt = -1;
      for(i=0; i<num; i++){
        WSCstring tmp = vlist.getWord(i,",");
        if (!strcmp(tmp,"NA") || !strcmp(tmp,"na")){
          if (na_pt+1 == i){
            na_pt = i;
            continue;
          }
          if (_rev == False){
            points[i].x = (short)(interval*(i-1));
            points[i].y = h -_lw/2;
            points[i+1].x = (short)(interval*(na_pt+1));
            points[i+1].y = h -_lw/2;
          }else{
            points[i].x = (short)(interval*(i-1));
            points[i].y = _lw/2;
            points[i+1].x = (short)(interval*(na_pt+1));
            points[i+1].y = _lw/2;
          }
          dev->drawFillPoly(&points[na_pt+1],(i-(na_pt+1))+2);
          na_pt = i;
        }
        long val = atoi(tmp);
        if (_rev == False){
          points[i].x = (short)(interval*i);
          points[i].y =  h - h*val/100 +_lw/2;
        }else{
          points[i].x = (short)(interval*i);
          points[i].y = h*val/100 +_lw/2;
        }
      }
      if (_rev == False){
        points[i].x = (short)(interval*i);
        points[i].y = h -_lw/2;
        points[i+1].x = (short)(interval*(na_pt+1));
        points[i+1].y = h -_lw/2;
      }else{
        points[i].x = (short)(interval*i);
        points[i].y = _lw/2;
        points[i+1].x = (short)(interval*(na_pt+1));
        points[i+1].y = _lw/2;
      }
      dev->drawFillPoly(&points[na_pt+1],(i-(na_pt+1))+2);
    }else{
      long na_pt = -1;
      for(i=0; i<num; i++){
        WSCstring tmp = vlist.getWord(i,",");
        if (!strcmp(tmp,"NA") || !strcmp(tmp,"na")){
          if (na_pt+1 == i){
            na_pt = i;
            continue;
          }
          if (_rev == False){
            points[i].x = w - _lw/2;
            points[i].y = (short)(interval*(i-1));
            points[i+1].x = w - _lw/2;
            points[i+1].y = (short)(interval*(na_pt+1));
          }else{
            points[i].x = _lw/2;
            points[i].y = (short)(interval*(i-1));
            points[i].x = _lw/2;
            points[i+1].y = (short)(interval*(na_pt+1));
          }
          dev->drawFillPoly(&points[na_pt+1],(i-(na_pt+1))+2);
          na_pt = i;
        }
        long val = atoi(tmp);
        if (_rev == False){
          points[i].x = w - w*val/100 + _lw/2;
          points[i].y = (short)(interval*i);
        }else{
          points[i].x = w*val/100 +_lw/2;
          points[i].y = (short)(interval*i);
        }
      }
      if (_rev == False){
        points[i].x = w - _lw/2;
        points[i].y = (short)(interval*i);
        points[i+1].x = w - _lw/2;
        points[i+1].y = (short)(interval*(na_pt+1));
      }else{
        points[i].x = _lw/2;
        points[i].y = (short)(interval*i);
        points[i].x = _lw/2;
        points[i+1].y = (short)(interval*(na_pt+1));
      }
      dev->drawFillPoly(&points[na_pt+1],(i-(na_pt+1))+2);
    }
  }
  dev->setLineWidth(_lw);
  dev->setLineDashType(_lt);
//  dev->setForeColor(_fore_color);

  not_draw = False;
  if (_bl_fl != False){
    if (_tw_fl == False){
      if (blinkfore == False){
        dev->setForeColor(_fore_color);
      }else{
        not_draw = True;
      }
    }else{
      if (blinkfore == False){
        dev->setForeColor(_fore_color);
      }else{
        dev->setForeColor(_blink_color);
      }
    }
  }else{
    dev->setForeColor(_fore_color);
  }

  dev->setHatchPattern(0);

  if (_orientation == WS_VERTICAL){
    long na_pt = -1;
    for(i=0; i<num; i++){
      WSCstring tmp = vlist.getWord(i,",");
      if (!strcmp(tmp,"NA") || !strcmp(tmp,"na")){
        if (na_pt+1 == i){
          na_pt = i;
          continue;
        }
        if (i-(na_pt+1) == 1){
          dev->drawLine(points[na_pt+1].x,points[na_pt+1].y,
                        points[na_pt+1].x+_lw,points[na_pt+1].y);
        }else{
          dev->drawLines(&points[na_pt+1],i-(na_pt+1));
        }
        na_pt = i;
      }
      long val = atoi(tmp);
      if (_rev == False){
        points[i].x = (short)(interval*i);
        points[i].y =  h - h*val/100 +_lw/2;
      }else{
        points[i].x = (short)(interval*i);
        points[i].y = h*val/100 +_lw/2;
      }
    }
    if (not_draw == False){
      dev->drawLines(&points[na_pt+1],i-(na_pt+1));
    }
  }else{
    long na_pt = -1;
    for(i=0; i<num; i++){
      WSCstring tmp = vlist.getWord(i,",");
      if (!strcmp(tmp,"NA") || !strcmp(tmp,"na")){
        if (na_pt+1 == i){
          na_pt = i;
          continue;
        }
        if (i-(na_pt+1) == 1){
          dev->drawLine(points[na_pt+1].x,points[na_pt+1].y,
                        points[na_pt+1].x,points[na_pt+1].y+_lw);
        }else{
          dev->drawLines(&points[na_pt+1],i-(na_pt+1));
        }
        na_pt = i;
      }
      long val = atoi(tmp);
      if (_rev == False){
        points[i].x = w - w*val/100 + _lw/2;
        points[i].y = (short)(interval*i);
      }else{
        points[i].x = w*val/100 + _lw/2;
        points[i].y = (short)(interval*i);
      }
    }
    if (not_draw == False){
      dev->drawLines(&points[na_pt+1],i-(na_pt+1));
    }
  }
  delete points;
  dev->endDraw();
  return WS_NO_ERR;
}

void WSCvlineGraph::setData(WSCvariant* val,long code){
  if (code == WS_EN_DEFAULT){
    WSCstring str;
    str.setString(val->getCharPtr(),code);
    setProperty(WSNvalue,str.getString());
  }else{
    setProperty(WSNvalue,val->getCharPtr());
  }
}

long WSCvlineGraph::getDataSourceType(){
  return _data_source_type;
}
char* WSCvlineGraph::getDataSourcePropertyName(){
  return WSNvalue;
}
void WSCvlineGraph::update(){
  if (_need_ds_update != False){
    _need_ds_update = False;
    _set_ds_instance();
  }
  WSCnwbase::update();
}
char* WSCvlineGraph::getDefaultProperty(){
  return WSNvalue;
}
