//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCvpoly.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <ctype.h>
#include <WSCblink.h>
#include <WSCvline.h>

WSMFguiClassInitialize(WSCvpoly, WSCvpolyAttr);
WSMFversion(WSCvpoly, WSCvpolyAttr);

WSCvpoly::WSCvpoly(WSCbase* base, char* objname):
           WSCvpolyAttr(base, objname){

  _data_x = WSGFstrdup("0,100,100,0");
  _data_y = WSGFstrdup("0,0,100,100");
  _line_num = 4;
  _line_x = new short[_line_num];
  _line_y = new short[_line_num];

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvpoly);

    WSMFpropertyCreate(WSNlineX,      char*, _data_x ,WSSlineX);
    WSMFpropertyCreate(WSNlineY,      char*, _data_y ,WSSlineY);
    WSMFpropertyCreate(WSNlineNum,    WSCuchar, _line_num ,WSSlineNum );

  WSMFpropertyCreateEnd

  WSCvline::_str_to_addr(_data_x, _line_x,_line_num);
  WSCvline::_str_to_addr(_data_y, _line_y,_line_num);
}

WSMFproperty(WSCvpoly, WSNlineX,   char*, _data_x,    WSGFstrdup("0,100,100,0"));
WSMFproperty(WSCvpoly, WSNlineY,   char*, _data_y,    WSGFstrdup("0,0,100,100"));
WSMFproperty(WSCvpoly, WSNlineNum, WSCuchar, _line_num, 4);

void WSCvpoly::setWorkWSNlineX(char* data){
  if (data[0] != 0 && _line_x != 0) {
    WSCvline::_str_to_addr(data,_line_x,_line_num);
  }
}

void WSCvpoly::getWorkWSNlineX(char**){}

void WSCvpoly::setWorkWSNlineY(char* data){
  if (data[0] != 0 && _line_y != 0) {
    WSCvline::_str_to_addr(data,_line_y,_line_num);
  }
}

void WSCvpoly::getWorkWSNlineY(char**){}

void WSCvpoly::setWorkWSNlineNum(WSCuchar num){
  _set_data_num(num);
}

void WSCvpoly::getWorkWSNlineNum(WSCuchar*){}

WSCvpoly::~WSCvpoly(){
  if (_line_x != 0) {
    delete _line_x;
  }
  if (_line_y != 0) {
    delete _line_y;
  }
  delete _data_x;
  delete _data_y;
}

long WSCvpoly::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }

  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False && dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }
  WSCbool blinkfore = WSGIappBlink()->getBlinkFore(_blink_rate);

  if (_bl_fl == True &&
      blinkfore == True &&
      _tw_fl == False) {
    return WS_NO_ERR;
  }

  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }
  WSCbase::update();
  setAbsoluteDraw(False);

  if (_line_num != 0) {
    WSCushort line_w = _lw;
    if (line_w == 1) {
      dev->setLineWidth((WSCushort)0);
    } else {
      dev->setLineWidth((WSCushort)line_w);
    }

    dev->setLineDashType(_lt);

    WSCpoint*	pt = new WSCpoint[_line_num];
    short	i;
    for (i=0; i<_line_num; i++) {
      pt[i].x = (short)(_line_x[i]);
      pt[i].y = (short)(_line_y[i]);
    }
    if (_stippled == True) {
      if (_hatch_pattern != (char)0) {
        if (_back_color_flag == True) {
          if (_blink_type != WS_FORE &&
              _bl_fl == True &&
              blinkfore == True &&
              _tw_fl == True) {
            dev->setForeColor(_back_blink_color);
          } else {
            dev->setForeColor(_back_color);
          }
          dev->setHatchPattern((char)0);
          dev->drawFillPoly(pt, _line_num);
        }
      }
      dev->setHatchPattern(_hatch_pattern);
      if (_blink_type != WS_FORE &&
          _bl_fl == True &&
          blinkfore == True &&
          _tw_fl == True) {
        dev->setForeColor(_hatch_blink_color);
      } else {
        dev->setForeColor(_hatch_color);
      }
      dev->drawFillPoly(pt, _line_num);
      dev->setHatchPattern((char)0);
    }

    if (_bl_fl == True &&
        blinkfore == True &&
        _blink_type != WS_BACK &&
        _tw_fl == True) {
      dev->setForeColor(_blink_color);
    } else {
      dev->setForeColor(_fore_color);
    }

    if (line_w != 0) {
      dev->drawPoly(pt, _line_num);
    }
    delete pt;
  }
  dev->endDraw();
  return WS_NO_ERR;
}

long WSCvpoly::_set_data_num(short num) {
  if (num < 2) {
    return WS_ERR;
  }

  if (_line_x != 0) {
    delete _line_x;
  }
  if (_line_y != 0) {
    delete _line_y;
  }

  _line_num = num;
  _line_x = new short[num];
  _line_y = new short[num];

  // ɸ...
  if (_data_x != 0) {
    WSCvline::_str_to_addr(_data_x, _line_x,_line_num);
  }
  if (_data_y != 0) {
    WSCvline::_str_to_addr(_data_y, _line_y,_line_num);
  }

  return WS_NO_ERR;
}

