//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <devfb/devfb.h>
#include <devfb/WSDdevfbAppDev.h>
#include <devfb/WSDdevfbMouse.h>
#include <devfb/WSDdevfbColor.h>
#include <devfb/WSDdevfbDraw.h>
#include <WSDfont.h>
#include <WSDdev.h>
#include <WSClocaleSet.h>
#include <WSDfileSystem.h>
#include <devfb/WSDdeviceFont.h>
#include <devfb/devfb_dep.h>

//#ifdef TE
#if 0
extern "C" {
struct timespec {
  long tv_sec;
  long tv_nsec;
};

struct timeval {
  long tv_sec;
  long tv_usec;
};
char* getcwd(char* buf,unsigned int len){
  strncpy(buf,"/SYS",len);
  return buf;
}
int chdir(const char* path){
  return 0;
}
int gettimeofday(struct timeval *__tv,
                  struct timezone *__tz){
  __tv->tv_sec = 0;
  __tv->tv_usec = 0;
  __tz->tz_minuteswest = 0;
  __tz->tz_dsttime = 0;
  return 0;
}
char* getenv(const char*){
  return NULL;
}
};
#endif

#ifndef TE
void WSGFsetRect(RECT* r,short x,short y,WSCushort w,WSCushort h){
  r->c.left = x;
  r->c.top = y;
  r->c.right = x+w;
  r->c.bottom = y+h;
}
#endif

#if 0
TF_CTX tc_to_string_ctx = NULL;
TF_CTX string_to_tc_ctx = NULL;
#endif
#ifdef TE
#define WSGFdevfbTcToString     WSGFbtronTcToString
#define WSGFdevfbStringToTc     WSGFbtronStringToTc
#define WSGFdevfbDrawString     WSGFbtronDrawString
#define WSGFdevfbGetStringWidth WSGFbtronGetStringWidth
#define WSGIdevfbAppDev         WSGIbtronAppDev
//class WSDbtronAppDev;
//extern WSDbtronAppDev* WSGIbtronAppDev();
#endif

char* WSGFdevfbTcToString(TC* src){
  return WSGFgetString(src,WS_EN_UTF8);
}

TC* WSGFdevfbStringToTc(char* src,long* tlen){
  TC* str =  WSGFgetUCS2(src,WS_EN_UTF8);
  *tlen = WSGFstrlenUCS2(str);
  return str;
}
TC* WSGFdevfbStringToTc2(char* src,long* tlen){
  TC* str =  WSGFgetUCS2(src,WS_EN_UTF8);
  *tlen = WSGFstrlenUCS2(str);
  return str;
}

TC begin_ascii[5] = { 0xffa2,0x6,0x300,0,0x102 };
TC begin_2byte[5] = { 0xffa2,0x6,0x300,0,0 };

void _devfb_draw_string(TC* str,WSDfont* fn,GID gid,W fg,W bg,long op,long slen,
       long cur,WSCbool inter_cur,long lw,long scur1,long scur2,long x,long y){
//  WSCbool onebyte = False;
//  long sptr = 0;
//  long ptr = 0;
  long bcur = -1;
  long icur = -1;
  FSSPEC* fnt = (FSSPEC*)fn->getValue1();
//  FSSPEC* fnt_ascii = (FSSPEC*)fn->getValue3();
  WSDdeviceFontList* f = (WSDdeviceFontList*)fnt->_f;

//  long cnt = 0;
  if (inter_cur == 0 && cur > -1){
    bcur = cur;
  }
  if (inter_cur != 0 && cur > -1){
    icur = cur;
  }
  if (slen > 0){
    if (scur1 <= 0 && scur2 >= slen){
      long dw = WSGFdeviceGetStringWidth(gid, f, str, slen);
      WSGFdeviceDrawFillRect(gid,x,y - fnt->size.v,dw,fnt->size.v,fg,0);
      WSGFdeviceDrawString(gid,x,y,f,bg,str,slen);
    }else{
      WSGFdeviceDrawString(gid,x,y,f,fg,str,slen);
      if (scur1 < 0) scur1 = 0;
      if (scur2 < 0) scur2 = 0;
      if (scur1 > slen) scur1 = slen;
      if (scur2 > slen) scur2 = slen;
      if (scur1 != scur2){
        int x2 = x;
        if (scur1 > 0){
          x2 += WSGFdeviceGetStringWidth(gid, f, str, scur1);
        }
        long dw = WSGFdeviceGetStringWidth(gid, f, &str[scur1], scur2 - scur1);
        WSGFdeviceDrawFillRect(gid,x2,y - fnt->size.v,dw,fnt->size.v,fg,0);
        WSGFdeviceDrawString(gid,x2,y,f,bg,&str[scur1],scur2 -scur1);
      }
    }
    if (cur >= 0 && cur < slen + inter_cur ){
      int x2 = x;
      if (cur > 0){
        x2 += WSGFdeviceGetStringWidth(gid, f, str, cur);
      }
      if (inter_cur == False){
        long dw = WSGFdeviceGetStringWidth(gid, f, &str[cur],1);
        WSGFdeviceDrawFillRect(gid,x2,y - fnt->size.v,dw,fnt->size.v,fg,0);
        WSGFdeviceDrawString(gid,x2,y,f,bg,&str[cur],1);
      }else{
        if (str[cur] != '\n'){
          WSGFdeviceDrawFillRect(gid,x2-1,y - fnt->size.v,3,fnt->size.v,fg,0);
        }
      }
    }
  }else if (inter_cur == 1 && cur == 0){
    WSGFdeviceDrawFillRect(gid,x,y - fnt->size.v,3,fnt->size.v,fg,0);
  }

}


void WSGFdevfbDrawString(TC* str,WSDfont* fn,GID gid,W fg,W bg,long len,short x,short y,long cur,WSCbool inter_cur,long lw,long scur1,long scur2){
#if 0
  gset_chp(gid,x,y,(Bool)True);
  _devfb_draw_string(str,fn,gid,fg,bg,G_AND,len,cur,inter_cur,lw,scur1,scur2,x,y);
#endif
  gset_chp(gid,x,y,(Bool)True);
  _devfb_draw_string(str,fn,gid,fg,bg,G_OR,len,cur,inter_cur,lw,scur1,scur2,x,y);
}
short WSGFdevfbGetStringWidth(TC* str,WSDfont* fn,long slen){
  WSCbool onebyte = False;
  long sptr = 0;
  long ptr = 0;
  FSSPEC* fnt = (FSSPEC*)fn->getValue1();
  FSSPEC* fnt_ascii = (FSSPEC*)fn->getValue3();
//  W fdesc = fn->getValue2();
#ifdef _NOTSH
extern W WSGFgetFontGid();
  GID fgid = WSGFgetFontGid();
#else
  GID fgid = WSGIdevfbAppDev()->getFontGid();
#endif
  W ret = 0;
  while(1){
    if (str[ptr] == 0xffa2){
      if (!memcmp(begin_ascii,&str[ptr],sizeof(TC)*5)){
        long tclen = ptr - sptr;
        TC* buf = new TC[tclen+1];
        memcpy(buf,&str[sptr],sizeof(TC)*tclen);
        buf[tclen] = 0;
        if (onebyte == False){
          gset_fon(fgid,fnt);
        }else{
          gset_fon(fgid,fnt_ascii);
        }
        W width = gget_stw(fgid,buf,tclen,NULL,NULL);
        ret += width;

        delete buf;
        ptr +=5;
        sptr = ptr;
        onebyte = True;
      }else
      if (!memcmp(begin_2byte,&str[ptr],sizeof(TC)*5)){
        long tclen = ptr - sptr;
        TC* buf = new TC[tclen+1];
        memcpy(buf,&str[sptr],sizeof(TC)*tclen);
        buf[tclen] = 0;
        if (onebyte == False){
          gset_fon(fgid,fnt);
        }else{
          gset_fon(fgid,fnt_ascii);
        }

        W width = gget_stw(fgid,buf,tclen,NULL,NULL);
        ret += width;

        delete buf;
        ptr +=5;
        sptr = ptr;
        onebyte = False;
      }
    }
    if (ptr == slen){
      long tclen = ptr - sptr;
      if (onebyte == False){
        gset_fon(fgid,fnt);
      }else{
        gset_fon(fgid,fnt_ascii);
      }
      W width = gget_stw(fgid,&str[sptr],tclen,NULL,NULL);
      ret += width;
      break;
    }
    if (ptr > slen){
      break;
    }
    ptr++;
  }
  return ret;
}

#ifndef TE
int main1(int argc,char** argv){
#ifdef TDBG
dbprintf("main start:\n");
WSMFtrace("main start:\n");
WSGFsetTimePoint();
#endif

//    W er = opendbox(&lnk, USER_DATA, 0x2000);
//  chg_emk(EM_ALL);
#if 0
  LINK    lnk;
  prc_inf(0, PI_LINK, (VP)&lnk, sizeof(LINK));
  dopn_dat(&lnk);
#endif

dbprintf("Main.cpp: main1() %s:%d stargetd.\n",__FILE__,__LINE__);
   WSDdev::setDraw(new WSDdevfbDraw());

   WSDappDev* app = WSGIappDev();
   WSDdevfbAppDev* devfbApp = (WSDdevfbAppDev*)app->cast("WSDdevfbAppDev");
   if (argc != 0){
     devfbApp->setInitPrm(argc,argv);
   }
   devfbApp->initialize();
   WSGIdevfbAppMouse()->initialize();

//   WSDdevfbColor::restart_blink_server();

   extern void _devfbFont_init();
   _devfbFont_init();

#ifdef TDBG
dbprintf("main init done.:%d\n",WSGFdiffTimePoint());
WSMFtrace("main init done.:%d\n",WSGFdiffTimePoint());
#endif
dbprintf("Main.cpp: main1() %s:%d done.\n",__FILE__,__LINE__);
  return 0;
}

int WSGFwsInitialize(){
  main1(0,NULL);
  return 0;
}

static long mem_initialized = False;
static char* buf[16];
static long buf_size[16];
static long buf_use[16];

char* WSGFdevfbAllocNewMemory(long size){

  if (mem_initialized == False){
    int i;
    for(i=0; i<16; i++){
      buf[i] = NULL;
      buf_size[i] = 0;
      buf_use[i] = 0;
    }
    mem_initialized = True;
  }
  int i;
  for(i=0; i<16; i++){
    if (buf[i] != NULL && buf_size[i] > size-1 && buf_use[i] == False){
      buf_use[i] = True;
      return buf[i];
    }
  }
  for(i=0; i<16; i++){
    if (buf[i] == NULL){
      buf[i] = new char[size];
      buf_size[i] = size;
      buf_use[i] = True;
      return buf[i];
    }
  }
  buf[0] = new char[size];
  buf_size[0] = size;
  buf_use[0] = True;
  return buf[i];
}
void WSGFdevfbDeleteMemory(char* ptr){

  int i;
  for(i=0; i<16; i++){
    if (buf[i] == ptr){
      buf_use[i] = False;
      return;
    }
  }
  delete ptr;
}
#endif
