//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <stdio.h>
#include <devfb/devfb.h>
#include <devfb/devfb_dep.h>
#include <unistd.h>
#include <devfb/WSDdeviceFont.h>

#ifndef TE
ERR cre_sem(W cnt, UW opt){
  return WSGFdeviceSemCreate(cnt,opt);
}

ERR wai_sem(ID id,TMOUT tmo){
  return WSGFdeviceSemLock(id);
}

ERR sig_sem(ID id){
  return WSGFdeviceSemUnlock(id);
}

ERR del_sem(ID id){
  return WSGFdeviceSemDestroy(id);
}
#endif
W wopn_wnd(UW attr, UW par, RECT* r, RECT* org, W pict, TC* tit, PAT* bgpat, WDDISP* atr){
  unsigned int bg = bgpat->spat.bgcol;
  return WSGFdeviceGetNewWindow(attr,par,
                               r->c.left,r->c.top,
                               r->c.right - r->c.left,
                               r->c.bottom - r->c.top,bg);
}
W wcls_wnd(W wid,W opt){
//printf("wcls_wnd=%d\n",wid);
  return WSGFdeviceDestroyWindow(wid);
}
W wmov_wnd(W wid,RECT* r){
  return WSGFdeviceMoveWindow(wid,r->c.left,r->c.top);
}
W wrsz_wnd(W wid,RECT* r){
  unsigned short w;
  unsigned short h;
  WSGFdeviceGetWindowSize(wid,&w,&h);
  int ret = WSGFdeviceResizeWindow(wid,r->c.right - r->c.left, r->c.bottom - r->c.top);
  if (ret == WS_NO_ERR){
    if ((r->c.right - r->c.left ) < w ||
        h > (r->c.right - r->c.left ) < h ){
      return 1;
    }
    return 0;
  }
  return ret;
}
ERR wget_wrk(W wid,RECT* r){
  if (r == 0){
    return WS_ERR_PAR;
  }
  short x;
  short y;
  unsigned short w;
  unsigned short h;
  WSGFlockDev();
  _WSGFdeviceGetWindowPosition(wid,&x,&y);
  _WSGFdeviceGetWindowSize(wid,&w,&h);
  WSGFunlockDev();
//  r->c.left = x;
//  r->c.top = y;
//  r->c.right = x + w;
//  r->c.bottom = y + h;
  r->c.left = 0;
  r->c.top = 0;
  r->c.right = w;
  r->c.bottom = h;
  return WS_NO_ERR;
}

W wsta_dsp(W wid, RECT* r, RLIST* rl){
//printf("wsta_dsp..\n");
  short x =0;
  short y =0;
  unsigned short w;
  unsigned short h;
//  WSGFdeviceGetWindowPosition(wid,&x,&y);
  WSGFdeviceGetWindowSize(wid,&w,&h);

  if (r != NULL){
    r->c.left = x;
    r->c.top = y;
    r->c.right = x + w;
    r->c.bottom = y + h;
  }
  if (rl != NULL){
    rl->rcomp.c.left = x;
    rl->rcomp.c.top = y;
    rl->rcomp.c.right = x + w;
    rl->rcomp.c.bottom = y + h;
  }
  return 1;
}

W wend_dsp(W wid){
//printf("wend_dsp..\n");
  WSGFlockDev();
  unsigned int status;
  int ret = _WSGFdeviceGetWindowStatus(wid,&status);
  if (ret != WS_NO_ERR){
    WSGFunlockDev();
    return ret;
  }
  status &= ~WS_DEVICE_NEED_EXPOSE;
  _WSGFdeviceSetWindowStatus(wid,status);
  int gid = _WSGFdeviceGetWindowGC(wid);
  WSGFunlockDev();
  WSGFdeviceFlushGC(gid);
  return WS_NO_ERR;
}

ERR wset_tit(W wid, W pict,TC* title, W mode){
  return WSGFdeviceSetWindowTitle(wid,title);
}
ERR wset_bgp(W wid, PAT* pat){
  unsigned int bg = pat->spat.bgcol;
  return WSGFdeviceSetWindowColor(wid,bg);
}

ERR wget_act(W* pid){
  int wid;
  int ret = WSGFdeviceGetActiveWindow(&wid);
  if (ret != WS_NO_ERR){
    return WS_ERR_ADR;
  }
  if (pid == NULL){
    return wid;
  }
#ifndef TE
  int my_pid = getpid();
#else
  int my_pid = prc_sts(0,NULL,NULL);
#endif
  int owner;
  ret = WSGFdeviceGetWindowOwner(wid,&owner);
  if (ret != WS_NO_ERR){
    return WS_ERR_ADR;
  }
  if (owner == my_pid ){
    *pid = 0;
  }else{
    *pid = owner;
  }
  return wid;
}
//unlock version
ERR _wget_act(W* pid){
  int wid;
  int ret = _WSGFdeviceGetActiveWindow(&wid);
  if (ret != WS_NO_ERR){
    return WS_ERR_ADR;
  }
  if (pid == NULL){
    return wid;
  }
#ifndef TE
  int my_pid = getpid();
#else
  int my_pid = prc_sts(0,NULL,NULL);
#endif
  int owner;
  ret = _WSGFdeviceGetWindowOwner(wid,&owner);
  if (ret != WS_NO_ERR){
    return WS_ERR_ADR;
  }
  if (owner == my_pid ){
    *pid = 0;
  }else{
    *pid = owner;
  }
  return wid;
}

ERR wget_dat(W wid,W* dat){
  ERR ret = WSGFdeviceGetWindowData(wid,(void**)dat);
//printf("wget_dat dat=0x%x\n",*dat);
  return ret;
}

ERR wset_dat(W wid,W dat){
  ERR ret = WSGFdeviceSetWindowData(wid,(void*)dat);
//printf("wset_dat dat=0x%x\n",dat);
  return ret;
}
GID wget_gid(W wid){
  return WSGFdeviceGetWindowGC(wid);
}

ERR gcls_env(GID gid){
//printf("gcls_env=%d\n",gid);
  return WSGFdeviceDestroyGC(gid);
}

ERR gget_for(GID gid, RLIST* rl){
//printf("gget_for gid=%d\n",gid);
  int num;
  WSCrect* list = WSGFdeviceGetExclusiveRegion(gid,&num);
  if (rl == NULL){
    return WS_ERR_ADR;
  }
  if (list == NULL){
    return 0;
  }
  long i;
  for(i=0; i<num; i++){
    WSCrect* r = (WSCrect*)&list[i];
    rl->rcomp.c.left = r->x;
    rl->rcomp.c.top = r->y;
    rl->rcomp.c.right = r->x + r->width; 
    rl->rcomp.c.bottom = r->y + r->height; 
//printf("gget_for gid=%d %d,%d,%d,%d\n",gid,r->x,r->y,r->width,r->height);
    rl = rl->next;
    if (rl == NULL){
      break;
    }
  }
  return num;
}
ERR gset_for(GID gid, RLIST* rl){
  WSGFlockDev();
  int ret = _WSGFdeviceDestroyExclusiveRegion(gid);
  if (ret != WS_NO_ERR){
    WSGFunlockDev();
    return ret;
  }
  if (rl == NULL){
    WSGFunlockDev();
    return WS_NO_ERR;
  }
  while(1){
    RECT r = rl->rcomp;
    short bx = 0;
    short by = 0;

    int wid = _WSGFdeviceGetGCWindow(gid);
    if (wid > 0){
      short x=0,y=0;
      int ret = _WSGFdeviceGetWindowPosition(wid,&x,&y);
      if (ret > -1){
        bx = x;
        by = y;
      }
//printf("gset_for ret=%d wid=%d gid=%d bx=%d by=%d\n",ret,wid,gid,bx,by); 
    }
    int ret = _WSGFdeviceAddExclusiveRegion(gid,r.c.left -bx,r.c.top -by,
                                               r.c.right - r.c.left,
                                               r.c.bottom - r.c.top);

    if (ret != WS_NO_ERR){
      WSGFunlockDev();
      return ret;
    }
    rl = rl->next;
    if (rl == NULL){
      WSGFunlockDev();
      return WS_NO_ERR;
    }
  }
  WSGFunlockDev();
  return WS_NO_ERR;
}
//unlock version
ERR _gset_for(GID gid, RLIST* rl){
  int ret = _WSGFdeviceDestroyExclusiveRegion(gid);
  if (ret != WS_NO_ERR){
    return ret;
  }
  if (rl == NULL){
    return WS_NO_ERR;
  }
  while(1){
    RECT r = rl->rcomp;
    short bx = 0;
    short by = 0;

    int wid = _WSGFdeviceGetGCWindow(gid);
    if (wid > 0){
      short x=0,y=0;
      int ret = _WSGFdeviceGetWindowPosition(wid,&x,&y);
      if (ret > -1){
        bx = x;
        by = y;
      }
    }
    int ret = _WSGFdeviceAddExclusiveRegion(gid,r.c.left -bx,r.c.top -by,
                                               r.c.right - r.c.left,
                                               r.c.bottom - r.c.top);

    if (ret != WS_NO_ERR){
      return ret;
    }
    rl = rl->next;
    if (rl == NULL){
      return WS_NO_ERR;
    }
  }
  return WS_NO_ERR;
}

ERR gset_vis(GID gid, RECT r){
//  int ret = WSGFdeviceDestroyVisibleRegion(gid);
//  if (ret != WS_NO_ERR){
//    return ret;
//  }
  return WSGFdeviceSetVisibleRegion(gid,r.c.left,r.c.top,
                                 r.c.right - r.c.left,
                                 r.c.bottom - r.c.top);
}
ERR _gset_vis(GID gid, RECT r){
  return _WSGFdeviceSetVisibleRegion(gid,r.c.left,r.c.top,
                                 r.c.right - r.c.left,
                                 r.c.bottom - r.c.top);
}
ERR gcop_bmp(GID sid, RECT* sr, GID did, RECT* dr, GRGN* mask, W mode){
  if ((sr->c.right - sr->c.left == dr->c.right - dr->c.left) && 
      (sr->c.bottom - sr->c.top == dr->c.bottom - dr->c.top)){
    return WSGFdeviceBitBlt(sid,sr->c.left,
                                sr->c.top,
                                sr->c.right - sr->c.left,
                                sr->c.bottom - sr->c.top,
                            did,dr->c.left,
                                dr->c.top,mode);
  }else{
    return WSGFdeviceStretchedBitBlt(sid,sr->c.left,
                                sr->c.top,
                                sr->c.right - sr->c.left,
                                sr->c.bottom - sr->c.top,
                            did,dr->c.left,
                                dr->c.top,
                                dr->c.right - dr->c.left,
                                dr->c.bottom - dr->c.top,
                                mode);
  }
}

W wget_sts(W wid, WDSTAT* stat, WDDISP* atr){
  int pid;
  WSGFlockDev();
  int ret = _WSGFdeviceGetWindowOwner(wid,&pid);
  stat->pid = pid;
  short x,y;
  unsigned short w,h;
  _WSGFdeviceGetWindowPosition(wid,&x,&y);
  _WSGFdeviceGetWindowSize(wid,&w,&h);
  WSGFunlockDev();
  stat->r.c.left = x;
  stat->r.c.top = y;
  stat->r.c.right = x+w;
  stat->r.c.bottom = y+h;

//printf("wget_sts pid=%d\n",pid);
  return ret;
}
W wget_inf(W item, VP buf, W size){
  if (item == WI_WORKSIZE){
    int w,h;
    WSGFdeviceGetScreenSize(&w,&h);
    if (size == sizeof(RECT)){
      RECT* r = (RECT*)buf;
      if (r == NULL){
        return WS_ERR_ADR;
      }
      r->c.left = 0;
      r->c.top = 0;
      r->c.right = w;
      r->c.bottom = h;
    }
    return WS_ERR_PAR;
  }else if (item == WI_WINLIST){
    WSGFdeviceGetWindowList((int*)buf,size/4);
  }
  return WS_ERR_PAR;
}
#ifndef TE
WERR prc_sts(W pid, P_STATE* buff, TC* path){
//printf("prc_sts pid=%d\n",getpid());
  return getpid();
}
#endif
W wget_evt(WEVENT* evt, W mode){
  return WSGFdeviceGetNextEvent(evt,mode);
}
WERR gget_dsp(W gid, DEV_SPEC* dspec){
  return WSGFdeviceGetDevSpec(gid,dspec);
}
WERR gget_csp(W gid, CSPEC* cspec){
  return WSGFdeviceGetColorSpec(gid,cspec);
}

#ifndef NO_DRAW_ARC
ERR gfra_ovl(GID gid, RECT r, W attr, PAT *pat, DEG ang, W mode){
  unsigned int fg = pat->spat.fgcol;
  return WSGFdeviceDrawArc(gid,r.c.left,r.c.top,
                           r.c.right - r.c.left, r.c.bottom - r.c.top,
                           0,360*64,fg,attr & 0xff,attr >> 8);
}
#endif
#ifndef NO_DRAW_FILL_ARC
ERR gfil_ovl(GID gid, RECT r, PAT *pat, DEG ang, W mode){
  unsigned int fg = pat->spat.fgcol;
  return WSGFdeviceDrawFillArc(gid,r.c.left,r.c.top,
                           r.c.right - r.c.left, r.c.bottom - r.c.top,
                           0,360*64,WS_PI,fg);
}
#endif
//ERR gdra_arc(GID gid, RECT r, PNT sp, PNT ep, W attr, PAT *pat, DEG ang, W mode){
//  return 0;
//}
//ERR  gfra_sec(GID gid, RECT r, PNT sp, PNT ep, W attr, PAT *pat, DEG ang, W mode){
//  return 0;
//}
//ERR  gfil_sec(GID gid, RECT r, PNT sp, PNT ep, PAT *pat, DEG ang, W mode){
//  return 0;
//}
//ERR  gfil_cho(GID gid, RECT r, PNT sp, PNT ep, PAT *pat, DEG ang, W mode){
//  return 0;
//}


ERR  gdra_lin(GID gid, PNT p1, PNT p2, W attr, PAT *pat, W mode){
//printf("gdra_lin..%d,%d -> %d,%d\n",p1.x,p1.y,p2.x,p2.y);
//printf("gdra_lin..%d,%d -> %d,%d attr=0x%x\n",p1.x,p1.y,p2.x,p2.y,attr);
  unsigned int fg = pat->spat.fgcol;
  return WSGFdeviceDrawLine(gid,p1.x,p1.y,p2.x,p2.y,fg,attr &  0xff ,attr >> 8);
}
#ifndef NO_DRAW_RECT
ERR  gfra_rec(GID gid, RECT r, W attr, PAT* pat, DEG ang, W mode){
  unsigned int fg = pat->spat.fgcol;
  return WSGFdeviceDrawRect(gid,r.c.left,r.c.top,
                     r.c.right - r.c.left, r.c.bottom - r.c.top,
                     fg,attr & 0xff,attr >> 8);
}
#endif

ERR gfil_rec(GID gid, RECT r, PAT* pat, DEG ang, W mode){
  unsigned int fg = pat->spat.fgcol;
  return WSGFdeviceDrawFillRect(gid,r.c.left,r.c.top,
                     r.c.right - r.c.left, r.c.bottom - r.c.top,
                     fg,0);
}

#ifndef NO_DRAW_POLY
ERR  gfra_pol(GID gid, POLY* p, W attr, PAT *pat, W mode){
  unsigned int fg = pat->spat.fgcol;
  if (p == NULL){
    return WS_ERR_ADR;
  }
  WSCpoint pt[p->size];
  int i;
  for(i=0; i<p->size; i++){
    pt[i].x = p->pt[i].x;
    pt[i].y = p->pt[i].y;
  }
  return WSGFdeviceDrawPolygon(gid,pt,p->size,fg,attr & 0xff,attr >> 8);
}
#endif
#ifndef NO_DRAW_FILL_POLY
ERR  gfil_pol(GID gid, POLY* p, PAT *pat, W mode){
  unsigned int fg = pat->spat.fgcol;
  if (p == NULL){
    return WS_ERR_ADR;
  }
  WSCpoint pt[p->size];
  int i;
  for(i=0; i<p->size; i++){
    pt[i].x = p->pt[i].x;
    pt[i].y = p->pt[i].y;
  }
  return WSGFdeviceDrawFillPolygon(gid,pt,p->size,fg,True);
}
#endif
ERR  gset_fon(GID gid, FSSPEC* fnt){
  if (fnt == NULL){
    return WS_ERR_ADR;
  }
  WSDdeviceFontList* f = (WSDdeviceFontList*)fnt->_f;
  return WSGFdeviceSetFont(gid,f);
}
ERR  gset_chp(GID gid, W x, W y, Bool absolute){
  return WSGFdeviceSetDrawPoint(gid,x,y);
}

ERR  fset_fon(W fdesc, FSSPEC* spec){
  if (spec == NULL){
    return WS_ERR_ADR;
  }
  spec->_f = fdesc;
  return 0;
}
ERR  fcls_fon(W fdesc){
  return 0;
}
WERR gdra_stp(GID gid,W x,W y, TC* str, W len, W mode){
  WSDdeviceFontList* f=NULL;
  WSGFlockDev();
  WERR ret = _WSGFdeviceGetFont(gid,&f);
  if (ret != WS_NO_ERR){
    WSGFunlockDev();
    return ret;
  }
  if (f == NULL){
    WSGFunlockDev();
    return WS_ERR;
  }
  unsigned int fg;
  ret = _WSGFdeviceGetForeColor(gid,&fg);
  if (ret != WS_NO_ERR){
    WSGFunlockDev();
    return ret;
  }
  ret = _WSGFdeviceDrawString(gid,x,y,f,fg,str,len);
  WSGFunlockDev();
  return ret;
}
WERR gdra_str(GID gid, TC* str, W len, W mode){
  short x,y;
  WSDdeviceFontList* f=NULL;
  WSGFlockDev();
  int ret = _WSGFdeviceGetDrawPoint(gid,&x,&y);
  if (ret != WS_NO_ERR){
    WSGFunlockDev();
    return ret;
  }
  ret = _WSGFdeviceGetFont(gid,&f);
  if (ret != WS_NO_ERR){
    WSGFunlockDev();
    return ret;
  }
  if (f == NULL){
    WSGFunlockDev();
    return WS_ERR;
  }
  unsigned int fg;
  ret = _WSGFdeviceGetForeColor(gid,&fg);
  if (ret != WS_NO_ERR){
    WSGFunlockDev();
    return ret;
  }
  ret = _WSGFdeviceDrawString(gid,x,y,f,fg,str,len);
  WSGFunlockDev();
  return ret;
}
ERR  gset_chc(GID gid, COLOR fgc, COLOR bgc){
  WSGFlockDev();
  int ret = _WSGFdeviceSetForeColor(gid,fgc);
  if (ret != WS_NO_ERR){
    WSGFunlockDev();
    return ret;
  }
  ret = _WSGFdeviceSetBackColor(gid,bgc);
  WSGFunlockDev();
  return ret;
}
WERR gget_stw(GID gid, TC* str, W len, void* gap, W* pos){
  WSDdeviceFontList* f=NULL;
  int ret = WSGFdeviceGetFont(gid,&f);
  if (ret != WS_NO_ERR){
    return ret;
  }
  if (f == NULL){
    return WS_ERR;
  }
  f->getStringWidth(str,len,&ret); 
  return ret;
}
W wfnd_wnd(PNT* gpos, PNT* lpos, W* wid){
  if (gpos == NULL){
    return WS_ERR_ADR;
  }
  int ret = WSGFdeviceSearchWindow(gpos->x,gpos->y);
  *wid = ret;
  return ret;
}
#ifndef TE
ERR wai_prc(W time){
  return WSGFdeviceSleep(time);
}

#ifndef NO_THREAD
WERR cre_tsk(void (*entry)(W), W pri, W arg){
  int thr;
  int ret = WSGFdeviceCreateThread(&thr,entry,arg);
  if (ret == WS_NO_ERR){
//printf("cre_tsk ret=%d\n",thr);
    return thr;
  }
  return WS_ERR;
}
void ext_tsk(void){
  WSGFdeviceExitThread();
}
ERR ter_tsk(W id){
  return WSGFdeviceTerminateThread(id);
}
#endif
WERR get_tid(void){
  return WSGFdeviceGetThreadId();
}
#endif
GID gopn_mem(TC* dev, BMP* bmap, B* par){
  CSPEC* csp =(CSPEC*)par;
 
  long x = bmap->bounds.c.left;
  long y = bmap->bounds.c.top;
  long w = bmap->bounds.c.right -x;
  long h = bmap->bounds.c.bottom -y;
  unsigned int row_bytes = bmap->rowbytes;
  long depth = row_bytes / w * 8;
  unsigned int start_red = csp->info[0] >> 8;
  unsigned int red_bits = csp->info[0] & 0xf;
  unsigned int start_green = csp->info[1] >> 8;
  unsigned int green_bits = csp->info[1] & 0xf;
  unsigned int start_blue = csp->info[2] >> 8;
  unsigned int blue_bits = csp->info[2] & 0xf;
//printf("gopn_mem row_bytes=%d w=%d depth=%d x,y,w,h=%d,%d,%d,%d\n",row_bytes,w,depth,x,y,w,h);
//printf("gopn_mem %x,%x,%x\n",csp->info[0],csp->info[1],csp->info[2]);
  return WSGFdeviceGetNewGC(0,0,w,h,depth,row_bytes,bmap->baseaddr[0],
                     start_red,start_green,start_blue,
                     red_bits,green_bits,blue_bits);

}

ERR gcnv_rel(GID gid, PNT* pp){
  short x;
  short y;
  WSGFlockDev();
  int ret = _WSGFdeviceGetGCWindow(gid);
  if (ret < 0){
    WSGFunlockDev();
    return WS_NO_ERR;
  }
  ret = _WSGFdeviceGetWindowPosition(ret,&x,&y);
  WSGFunlockDev();
//printf("gcnv_rel WSGFdeviceGetWindowPos gid=%d ret=%d %d,%d\n",gid,ret,x,y);
  if (ret < 0){
    return WS_ERR;
  }
  pp->x -= x;
  pp->y -= y;
  return WS_NO_ERR;
}
ERR gcnv_abs(GID gid, PNT* pp){
  short x;
  short y;
  WSGFlockDev();
  int ret = _WSGFdeviceGetGCWindow(gid);
//printf("gcnv_abs WSGFdeviceGetWindowPos gid=%d ret=%d\n",gid,ret);
  if (ret < 0){
    WSGFunlockDev();
    return WS_NO_ERR;
  }
  ret = _WSGFdeviceGetWindowPosition(ret,&x,&y);
  WSGFunlockDev();
//printf("gcnv_abs WSGFdeviceGetWindowPos gid=%d ret=%d %d,%d\n",gid,ret,x,y);
  if (ret < 0){
    return WS_ERR;
  }
  pp->x += x;
  pp->y += y;
  return WS_NO_ERR;
}

W wchk_dck(UW first){
//do nothin..
  return 0;
}
W wrsz_drg(WEVENT* evt, RECT* limit, RECT* r){
//do nothin..
  return 0;
}
W wscr_wnd(W wid, RECT* r, W dx, W dy, W mode){
//do nothin..
  return 0;
}
WERR gget_col(GID gid, UW p, COLOR* cv, UW cnt){
//do nothin..
  return 0;
}
W wchg_wnd(W wid, RECT* r, W mode){
//do nothin..
  return 0;
}
WERR chg_emk(W mask){
//do nothin..
  return 0;
}
W wmov_drg(WEVENT *evt, RECT *r){
//do nothin..
  short x;
  short y;
  unsigned short w;
  unsigned short h;
  WSGFlockDev();
  _WSGFdeviceGetWindowPosition(evt->s.wid,&x,&y);
  _WSGFdeviceGetWindowSize(evt->s.wid,&w,&h);
  WSGFunlockDev();
  r->c.left = x;
  r->c.top = y;
  r->c.right = x + w;
  r->c.bottom = y + h;
  return 0;
}
#ifndef _NOTSH
WERR rcv_msg(W mask, MESSAGE* msg, W size, W opt){
  return WSGFdeviceRecvMessage(mask,msg,size);
}
ERR  snd_msg(W pid, MESSAGE *msg, W opt){
  return WSGFdeviceSendMessage(msg);
}
#endif

WERR gget_ptr(PTRSTS* sts, void* img){
  short x;
  short y;
  WSGFdeviceGetCursorPos(&x,&y);
  sts->pos.x = x;
  sts->pos.y = y;
  sts->style = 0;
  sts->fgcol = DEVFB_BLACK;
  sts->bgcol = DEVFB_WHITE;
  sts->motion = 0;
  sts->hidden = 0;
  sts->size = 1;
  return WS_NO_ERR;
}

ERR gset_ptr(PTRSTL s, void* img, COLOR fgc, COLOR bgc){
// DO NOTHING..
  return 0;
}

W wcnv_rec(UW attr, RECT* r, UW opt){
// DO NOTHING..
  return 0;
}
//-----------------------------------------------------------------
