//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <WScom.h>
#include <basic.h>
//#include <devfb/devfb.h>
//#include <devfb/devfb_dep.h>
#include <string.h>
#include <tstring.h>
#include <btron/device.h>
#include <btron/errcode.h>
#include <btron/device.h>
#include <device/screen.h>
#include <device/kbpd.h>
#include <btron/proctask.h>

extern unsigned char* _buffer;
extern int _device_row_bytes;
extern int _device_width;
extern int _device_height;
extern int _device_depth;
extern unsigned int _device_start_red;
extern unsigned int _device_start_green;
extern unsigned int _device_start_blue;
extern unsigned int _device_red_bits;
extern unsigned int _device_green_bits;
extern unsigned int _device_blue_bits;

int _device_buffer_size = 0;

class _WEVENT;
#define WSDdeviceEvent _WEVENT
class WSDdeviceEventList;
extern int _add_event(WSDdeviceEventList* evt);
extern int _device_check_event_available();
extern int _search_window(short x,short y);

extern int _init_for_event_function();
extern int _wake_up_event();
extern int _wait_event();
extern int _event_sem_id;
extern void _mouse_input_proc(W);
extern int WSGFdeviceSemLock(int id);
extern int WSGFdeviceSemUnlock(int id);

int _touch_pannel_x = 0;
int _touch_pannel_y = 0;
int _mouse_status = 0;

void _get_mouse_pos(short* x,short* y){
  *x = _touch_pannel_x;
  *y = _touch_pannel_y;
}

TC devnm[8];
W  disp_dev = 0;
W  kbpd_dev = 0;
BMP devbmp;
int _init_frame_buffer(){
dbprintf("_init_frame_buffer() start.\n");
  W rsize;
  eucstotcs(devnm,(const UB*)"SCREEN");
  disp_dev = opn_dev(devnm, D_UPDATE, NULL);
  W ret = rea_dev(disp_dev, DN_SCRBMP, (B*)&devbmp, sizeof(BMP), &rsize, NULL);
  if (ret < ER_OK){
    return WS_ERR;
  }
  if (rsize != sizeof(BMP)){
    return WS_ERR;
  }

  DEV_SPEC dspec;
  ret = rea_dev(disp_dev, DN_SCRSPEC, (B*)&dspec, sizeof(DEV_SPEC), &rsize, NULL);
  if (ret < ER_OK){
    return WS_ERR;
  }
  if (rsize != sizeof(DEV_SPEC)){
    return WS_ERR;
  }

//  ScrDevInfo scrdevinf;
//  ret = rea_dev(disp_dev, DN_SCRDEVINFO, (B*)&scrdevinf, sizeof(ScrDevInfo), &rsize, NULL);
//printf("ScrDevInfo addr=0x%x size=%d\n",scrdevinf.framebuf_addr,scrdevinf.framebuf_size);
dbprintf("Screen BitMap = %x, pixbits = %x rsize=%d\n", (UW)devbmp.baseaddr[0], devbmp.pixbits,rsize);
  _device_row_bytes = devbmp.rowbytes;
  _device_width = devbmp.bounds.c.right - devbmp.bounds.c.left;
  _device_height = devbmp.bounds.c.bottom - devbmp.bounds.c.top;
  _device_buffer_size = devbmp.rowbytes * _device_height;
  _device_depth = (devbmp.pixbits >> 8);

dbprintf("color=0x%x %x %x %x\n",dspec.color[0],dspec.color[1],dspec.color[2],dspec.color[3]);
  if (dspec.attr & 0x08){
    dbprintf("Error: color map is not supported..\n");
    fprintf(stderr,"Error: color map is not supported..\n");
    exit(0);
  }
  _device_start_red = dspec.color[0] >> 8;
  _device_start_green = dspec.color[1] >> 8;
  _device_start_blue = dspec.color[2] >> 8;
  _device_red_bits = dspec.color[0] & 0xf;
  _device_green_bits = dspec.color[1] & 0xf;
  _device_blue_bits = dspec.color[2] & 0xf;

dbprintf("w,h=%d,%d rowbytes=%d size=%d depth=%d\n",_device_width,_device_height,_device_row_bytes,_device_buffer_size,_device_depth);
//  _buffer = (unsigned char*)malloc(_device_buffer_size);
//  _buffer = (unsigned char*)scrdevinf.framebuf_addr;
//XXXXZZZZ
//  devbmp.baseaddr[0] = _buffer;
  _buffer = devbmp.baseaddr[0];
  memset(_buffer,0xff,_device_buffer_size);
dbprintf("_init_frame_buffer_done buf=0x%x\n",_buffer);

  eucstotcs(devnm,(const UB*)"kbpd");
  kbpd_dev = opn_dev(devnm, D_UPDATE, NULL);
 
dbprintf("kbpd_dev=0x%x\n",kbpd_dev);

  PdRange pdr;
  pdr.xmax = _device_width;
  pdr.ymax = _device_height;
  wri_dev(kbpd_dev,DN_PDRANGE,(B*)&pdr,sizeof(PdRange),&rsize,NULL);
dbprintf("kbpd_dev=0x%x wsize=%d sizeof(PdRange)=%d\n",kbpd_dev,rsize,sizeof(PdRange));

  cre_tsk(_mouse_input_proc,-1,NULL);

  return WS_NO_ERR;
}
int _update_frame_buffer(int x1,int y1,unsigned int w1,unsigned int h1){
//printf("_update_frame_buffer() x,y,w,h=%d,%d,%d,%d\n",x1,y1,w1,h1);
  W rsize;
  RECT bounds;
  bounds.c.left = x1;
  bounds.c.right = x1+w1;
  bounds.c.top = y1;
  bounds.c.bottom = y1+h1;
  int ret = wri_dev(disp_dev,DN_SCRUPDRECT,(B*)&bounds,sizeof(RECT),&rsize,NULL);
//  int ret = wri_dev(disp_dev,DN_SCRWRITE,(B*)_buffer,_device_buffer_size,&rsize,NULL);
//printf("ret=%d size=%d\n",ret,rsize);
  return WS_NO_ERR;
}

extern void _add_mouse_move_evt(int,int);
extern void _add_mouse_evt(int,int,int pressed);

void _mouse_input_proc(W ptr){
  while(1){
    KPStat kpstat;
    W rsize;
    rea_dev(kbpd_dev,DN_KPSTAT,(B*)&kpstat,sizeof(kpstat),&rsize,NULL);
//printf("sizeof(H)=%d sizeof(KPStat)=%d\n",sizeof(H),sizeof(KPStat));
//printf("rsize=%d  kpstat=%d,%d 0x%x\n",rsize,kpstat.xpos,kpstat.ypos,kpstat.stat);
//  PdRange pdr;
//  rea_dev(kbpd_dev,DN_PDRANGE,(B*)&pdr,sizeof(PdRange),&rsize,NULL);
//printf("pdr.xmax=%d ymax=%d\n",pdr.xmax,pdr.ymax);
    int moved = 0;
    int px = kpstat.xpos;
    int py = kpstat.ypos;

    if (_touch_pannel_x != kpstat.xpos ||
        _touch_pannel_y != kpstat.ypos){
      moved = 1;
    }
    if (kpstat.stat.main != 0){
      if (_mouse_status == 0){
        WSGFdeviceSemLock(_event_sem_id);
        _add_mouse_evt(px,py,1);
        _mouse_status = 1;
        moved = 0;
        WSGFdeviceSemUnlock(_event_sem_id);
        _wake_up_event();
      }
    }

    if (moved != 0){
      WSGFdeviceSemLock(_event_sem_id);
      _add_mouse_move_evt(px,py);
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
    }

    if (kpstat.stat.main == 0){
      if (_mouse_status != 0){
        WSGFdeviceSemLock(_event_sem_id);
        _add_mouse_evt(px,py,0);
        _mouse_status = 0;
        WSGFdeviceSemUnlock(_event_sem_id);
        _wake_up_event();
      }
    }
    wai_prc(100);
  }
}

