//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifdef BTRON
#include <basic.h>
#else
#define BTRON
#endif
#define WIN32
#include "xunicode.h"

#include <WScom.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

//static int xu_locale_encoding = XU_CONV_ISO8859(1);
static int xu_locale_encoding = XU_CONV_EUCJP;
int XUGetLocale(){
  return xu_locale_encoding;
}
BOOL xunicode_enable = FALSE;


/* encodings */
#include "iso8859.h"
#include "koi8r.h"
#include "cp1251.h"
static XUChar table_rev_latin2 [ 1024];
static XUChar table_rev_koi8r_1[ 1024];
static XUChar table_rev_koi8r_2[ 1024];
static XUChar table_rev_cp1251_1[ 1024];
static XUChar table_rev_cp1251_2[ 1024];
static XUChar table_rev_iso8859[65536];

#ifndef NO_JAPANESE
#include "jis0208.h"
static XUChar table_rev_jis0208[65536];
#endif

#ifndef NO_KSC5601
#include "ksc5601.h"
static XUChar table_rev_ksc5601[65536];
#endif

#ifndef NO_GB2312
static XUChar table_rev_gb2312 [65536];
#include "gb2312.h"
#endif

#ifndef NO_BIG5
static XUChar table_rev_big5   [65536];
#include "big5.h"
#endif

static void XUInitTable();

void XUInit()
{
  if(xunicode_enable) return;
  
#ifdef WIN32
#ifndef BTRON
  xunicode_enable = TRUE;
  char buf[3];  
  buf[0] = 0x82;
  buf[1] = 0xa0;
  buf[2] = 0;
  unsigned short buf2[4];
  unsigned short buf3[4];
  MultiByteToWideChar(CP_ACP, 0, buf, 3, (WCHAR*)buf2, 2);
  buf3[0] = 0x3042;
  buf3[1] = 0;
  if (!memcmp(buf2,buf3,sizeof(unsigned short)*2)){
    xu_locale_encoding = XU_CONV_SJIS;
  }else{
    xu_locale_encoding = XU_CONV_LOCALE;
  }
#endif
#else
  xunicode_enable = True;
  XUInitLocale();
  XUInitSetting();
#endif
  XUInitTable();
extern void WSGFsetSystemDefaultEncoding(long);
  WSGFsetSystemDefaultEncoding(xu_locale_encoding);
}


static void XUInitTable()
{
  int i, j;
  XUChar c;
  XUChar c1;
  XUChar c2;
  
//  for(i = 0; i < 1024; i++) {
//    table_rev_latin2 [i] = 0;
//    table_rev_koi8r_1[i] = 0;
//    table_rev_koi8r_2[i] = 0;
//    table_rev_cp1251_1[i] = 0;
//    table_rev_cp1251_2[i] = 0;
//  }
  memset(table_rev_latin2,0,sizeof(table_rev_latin2));
  memset(table_rev_koi8r_1,0,sizeof(table_rev_koi8r_1));
  memset(table_rev_koi8r_2,0,sizeof(table_rev_koi8r_2));
  memset(table_rev_cp1251_1,0,sizeof(table_rev_cp1251_1));
  memset(table_rev_cp1251_2,0,sizeof(table_rev_cp1251_2));
  
  for(i = 0; i < 128; i++) {
    c = table_iso8859[1].data[i];
    if(c) table_rev_latin2[c] = i + 0x0080;
  }
  
  for(i = 0; i < 128; i++) {
    c = table_koi8r[i];
    if(0x0080 <= c && c < 0x0480) {
      table_rev_koi8r_1[c - 0x0080] = i + 0x0080;
    } else if(0x2200 <= c && c < 0x2600) {
      table_rev_koi8r_2[c - 0x2200] = i + 0x0080;
    }
    c = table_cp1251[i];
    if(0x0080 <= c && c < 0x0480) {
      table_rev_cp1251_1[c - 0x0080] = i + 0x0080;
    } else if(0x2200 <= c && c < 0x2600) {
      table_rev_cp1251_2[c - 0x2200] = i + 0x0080;
    }
  }
  
//  for(i = 0; i < 65536; i++) table_rev_iso8859[i] = 0;
  memset(table_rev_iso8859,0,sizeof(table_rev_iso8859));
#ifndef NO_JAPANESE
//  for(i = 0; i < 65536; i++) table_rev_jis0208[i] = 0;
  memset(table_rev_jis0208,0,sizeof(table_rev_jis0208));
#endif
#ifndef NO_KSC5601
//  for(i = 0; i < 65536; i++) table_rev_ksc5601[i] = 0;
  memset(table_rev_ksc5601,0,sizeof(table_rev_ksc5601));
#endif
#ifndef NO_GB2312
//  for(i = 0; i < 65536; i++) table_rev_gb2312 [i] = 0;
  memset(table_rev_gb2312,0,sizeof(table_rev_gb2312));
#endif
#ifndef NO_BIG5
//  for(i = 0; i < 65536; i++) table_rev_big5   [i] = 0;
  memset(table_rev_big5,0,sizeof(table_rev_big5));
#endif

  for(i = 9; i >= 1; i--) {
    c = (i << 8) + 128;
    for(j = 0; j < 128; j++, c++) {
      table_rev_iso8859[table_iso8859[i - 1].data[j]] = c;
    }
  }
  
  c1 = 0x21;
  c2 = 0x21;
#ifndef NO_JAPANESE
  for(i = 0; i < MAX_JIS_CHARS; i++) {
    c = table_jis0208[i];
    if(c && table_rev_jis0208[c] == 0) table_rev_jis0208[c] = (c1 << 8) + c2;
    c2++;
    if(c2 == 0x7f) {
      c2 = 0x21;
      c1++;
    }
  }
#endif

  c1 = 0x21;
  c2 = 0x21;
#ifndef NO_GB2312
  for(i = 0; i < 8178; i++) {
    c = table_gb2312[i];
    if(c) table_rev_gb2312[c] = (c1 << 8) + c2;
    c2++;
    if(c2 == 0x7f) {
      c2 = 0x21;
      c1++;
    }
  }
#endif
  
  c1 = 0xa1;
  c2 = 0x40;
#ifndef NO_BIG5
  for(i = 0; i < 13973; i++) {
    c = table_big5[i];
    if(c) table_rev_big5[c] = (c1 << 8) + c2;
    c2++;
    if(c2 == 0x7f) {
      c2 = 0xa1;
    } else if(c2 == 0xff) {
      c2 = 0x40;
      c1++;
    }
  }
#endif
  
  c1 = 0x81;
  c2 = 0x41;
#ifndef NO_KSC5601
  for(i = 0; i < 12816; i++) {
    c = table_ksc5601[i];
    if(c) table_rev_ksc5601[c] = (c1 << 8) + c2;
    c2++;
    if(c2 == 0x5b) {
      c2 = 0x61;
    } else if(c2 == 0x7b) {
      c2 = 0x81;
    } else if(c2 == 0xff) {
      c2 = 0x41;
      c1++;
    }
  }
#endif

  c1 = 0xca;
  c2 = 0xa1;
#ifndef NO_KSC5601
  for(i = 0; i < 4888; i++) {
    c = table_ksc5601_hanja[i];
    if(c) table_rev_ksc5601[c] = (c1 << 8) + c2;
    c2++;
    if(c2 == 0xff) {
      c2 = 0xa1;
      c1++;
    }
  }
#endif
}

/**
  Other -> Unicode
*/

XUChar XUCharEncode(const char* text, int max, int code,int* rlen)
{
  XUChar ret = 0;
  XUChar c1;
  XUChar c2;
  XUChar num;
   *rlen = 1;
 
  if(max == 0 || !*text) return 0;
  
  if(code == XU_CONV_LOCALE) {
#if defined WIN32 && !defined BTRON
    MultiByteToWideChar(CP_ACP, 0, text, max, &ret, 1);
    return ret;
#else
    code = xu_locale_encoding;
#endif
  }
  if(code <= XU_CONV_NONE) return '?';
  if(code == XU_CONV_UTF8) return XUutf8CharEncode(text, max,rlen);
  
  c1 = (XUChar)(unsigned char)*text;
  if(c1 < 0x80) return c1;
  if(code <= XU_CONV_ISO8859(15)) {
    ret = table_iso8859[code - XU_CONV_ISO8859(1)].data[c1 - 0x80];
    if(ret) return ret;
    return '?';
  } else if(code == XU_CONV_KOI8R) {
    ret = table_koi8r[c1 - 0x80];
    if(ret) return ret;
    return '?';
  } else if(code == XU_CONV_CP1251) {
    ret = table_cp1251[c1 - 0x80];
    if(ret) return ret;
    return '?';
  }
  if(code == XU_CONV_SJIS) {
    if(0xa1 <= c1 && c1 <= 0xdf) return c1 + 0xfec0;
  }
  if(max == 1) return '?';
  text++;
  
  c2 = (XUChar)(unsigned char)*text;
  if(!c2) return '?';
  if(code == XU_CONV_EUCJP) {
#ifndef NO_JAPANESE
    if(c1 == 0x8e){
      *rlen = 2;
      return c2 + 0xfec0;
    }
//    if(c1 < 0xa1 || c1 > 0xf4) return '?';
    if(c1 < 0xa1 || c1 > 0xfc) return '?';
    if(c2 < 0xa1 || c2 > 0xfe) return '?';
//printf("EUCJP=0x%02x%02x num=%d 0x%04x\n",c1,c2, (c1 - 0xa1) * 94 + (c2 - 0xa1),table_jis0208[(c1 - 0xa1) * 94 + (c2 - 0xa1)]);
    *rlen = 2;
    ret = table_jis0208[(c1 - 0xa1) * 94 + (c2 - 0xa1)];
#endif
  } else if(code == XU_CONV_SJIS) {
#ifndef NO_JAPANESE
    if(c1 == 0x80 || c1 == 0xa0 || c1 > 0xfc) return '?';
    if(c2  < 0x40 || c2 == 0x7f || c2 > 0xfc) return '?';
    if(c1 >= 0xe0) c1 -= 0x40;
    if(c2 > 0x7e) c2--;
    *rlen = 2;
    num = (c1 - 0x81) * 188 + (c2 - 0x40);
//printf("SJIS=0x%02x%02x num=%d 0x%04x\n",c1,c2,num,table_jis0208[num]);
    if(num < MAX_JIS_CHARS) ret = table_jis0208[num];
#endif
  } else if(code == XU_CONV_EUCKR) {
#ifndef NO_KSC5601
    if(0x81 <= c1 && c1 <= 0xc8) {
      if(c2 < 0x41 || c2 > 0xfe) return '?';
      if(0x5a < c2 && c2 < 0x61) return '?';
      if(0x7a < c2 && c2 < 0x81) return '?';
      if(c2 > 0x7a) c2 -= 6;
      if(c2 > 0x5a) c2 -= 6;
      *rlen = 2;
      ret = table_ksc5601[(c1 - 0x81) * 178 + (c2 - 0x41)];
    } else if(0xca <= c1 && c1 <= 0xfd) {
      if(c2 < 0xa1 || c2 > 0xfe) return '?';
      *rlen = 2;
      ret = table_ksc5601_hanja[(c1 - 0xca) * 94 + (c2 - 0xa1)];
    }
#endif
  } else if(code == XU_CONV_EUCCN) {
#ifndef NO_GB2312
    if(c1 < 0xa1 || c1 > 0xf7) return '?';
    if(c2 < 0xa1 || c2 > 0xfe) return '?';
    *rlen = 2;
    ret = table_gb2312[(c1 - 0xa1) * 94 + (c2 - 0xa1)];
#endif
  } else if(code == XU_CONV_BIG5) {
#ifndef NO_BIG5
    if(c1 < 0xa1 || c1 > 0xf9) return '?';
    if(c2 < 0x40 || c2 > 0xfe) return '?';
    if(0x7e < c2 && c2 < 0xa1) return '?';
    if(c2 > 0x7e) c2 -= 0x22;
    *rlen = 2;
    ret = table_big5[(c1 - 0xa1) * 157 + (c2 - 0x40)];
#endif
  }
  if(ret) return ret;
  
  *rlen = 1;
  return '?';
}


/**
  Unicode -> Other
*/

int XUCharDecode(char* dest, int max, XUChar ch, int code)
{
  XUChar ret = 0;
  XUChar r1;
  XUChar r2;
  XUChar i;
  XUChar* table;
  
  if(code == XU_CONV_LOCALE) {
#if defined WIN32 && !defined BTRON
    WideCharToMultiByte(CP_ACP, 0, &ch, 1, dest, max, NULL, NULL);
    return WideCharToMultiByte(CP_ACP, 0, &ch, 1, NULL, 0, NULL, NULL);
#else
    code = xu_locale_encoding;
#endif
  } else if(code == XU_CONV_NONE) {
    if(max >= 1) dest[0] = '?';
    return 1;
  } else if(code == XU_CONV_UTF8) {
    return XUutf8CharDecode(dest, max, ch);
  }
  
  if(ch < 0x0080) {
    if(max >= 1) dest[0] = (char)ch;
    return 1;
  }
  if(code <= XU_CONV_ISO8859(15)) {
    if(ch < 0x00a1) {
      ret = ch;
    } else {
      table = table_iso8859[code - XU_CONV_ISO8859(1)].data;
      for(i = 0x21; i < 0x80; i++) {
        if(ch == table[i]) {
          ret = i + 0x80;
          break;
        }
      }
    }
    if(!ret) ret = '?';
    if(max >= 1) dest[0] = (char)ret;
    return 1;
  } else if(code == XU_CONV_KOI8R) {
    if(0x0080 <= ch && ch < 0x0480) {
      ret = table_rev_koi8r_1[ch - 0x0080];
    } else if(0x2200 <= ch && ch < 0x2600) {
      ret = table_rev_koi8r_2[ch - 0x2200];
    }
    if(!ret) ret = '?';
    if(max >= 1) dest[0] = (char)ret;
    return 1;
  } else if(code == XU_CONV_CP1251) {
    if(0x0080 <= ch && ch < 0x0480) {
      ret = table_rev_cp1251_1[ch - 0x0080];
    } else if(0x2200 <= ch && ch < 0x2600) {
      ret = table_rev_cp1251_2[ch - 0x2200];
    }
    if(!ret) ret = '?';
    if(max >= 1) dest[0] = (char)ret;
    return 1;
  }
  
  if(code == XU_CONV_EUCJP) {
#ifndef NO_JAPANESE
    if(0xff61 <= ch && ch <= 0xff9f) {
      ret = (ch - 0xfec0) + 0x8e00;
    } else {
      ret = table_rev_jis0208[ch];
      if(ret) ret += 0x8080;
    }
#endif
  } else if(code == XU_CONV_SJIS) {
#ifndef NO_JAPANESE
    if(0xff61 <= ch && ch <= 0xff9f) {
      if(max >= 1) dest[0] = (char)(ch - 0xfec0);
      return 1;
    } else {
      ret = table_rev_jis0208[ch];
      r1 = (ret >> 8  ) - 0x21;
      r2 = (ret & 0xff) - 0x21;
      if(r1 & 1) r2 += 94;
      r1 = (r1 >> 1) + 0x81;
      if(r1 > 0x9f) r1 += 0x40;
      r2 += 0x40;
      if(r2 > 0x7e) r2++;
      ret = (r1 << 8) + r2;
    }
#endif
  } else if(code == XU_CONV_EUCKR) {
#ifndef NO_KSC5601
    ret = table_rev_ksc5601[ch];
#endif
  } else if(code == XU_CONV_EUCCN) {
#ifndef NO_GB2312
    ret = table_rev_gb2312[ch];
    if(ret) ret += 0x8080;
#endif
  } else if(code == XU_CONV_BIG5) {
#ifndef NO_BIG5
    ret = table_rev_big5[ch];
#endif
  }
  if(!ret) {
    if(max >= 1) dest[0] = '?';
    return 1;
  }
  
  if(max >= 2) {
    dest[0] = (char)(ret >> 8);
    dest[1] = (char)(ret & 0xff);
  }
  return 2;
}


int XUCharLen(const char* text, int max, int code)
{
  XUChar c1;
  XUChar c2;
  
  if(max == 0 || !*text) return 1;
  
  if(code == XU_CONV_LOCALE) {
#if defined WIN32 && !defined BTRON
    return MultiByteToWideChar(CP_ACP, 0, text, max, NULL, 0);
#else
    code = xu_locale_encoding;
#endif
  }
  if(code == XU_CONV_UTF8  ) return XUutf8CharLen(text, max);
  if(code <= XU_CONV_KOI8R ) return 1;
  
  c1 = (XUChar)(unsigned char)*text;
  if(code == XU_CONV_SJIS) {
    if(0xa1 <= c1 && c1 <= 0xdf) return 1;
  }
  if(max == 1) return 1;
#if 1 //added by hirabayashi
  if(c1 < 0x80) return 1;
#endif
  text++;
  
  c2 = (XUChar)(unsigned char)*text;
  if(!c2) return 1;
  if(code == XU_CONV_EUCJP) {
    if(c1 == 0x8e) return 2;
//    if(c1 < 0xa1 || c1 > 0xf4) return 1;
    if(c1 < 0xa1 || c1 > 0xfc) return 1;
    if(c2 < 0xa1 || c2 > 0xfe) return 1;
    return 2;
  } else if(code == XU_CONV_SJIS) {
    if(c1 == 0x80 || c1 == 0xa0 || c1 > 0xfc) return 1;
    if(c2  < 0x40 || c2 == 0x7f || c2 > 0xfc) return 1;
    return 2;
  } else if(code == XU_CONV_EUCKR) {
    if(0x81 <= c1 && c1 <= 0xc8) {
      if(c2 < 0x41 || c2 > 0xfe) return 1;
      if(0x5a < c2 && c2 < 0x61) return 1;
      if(0x7a < c2 && c2 < 0x81) return 1;
      return 2;
    } else if(0xca <= c1 && c1 <= 0xfd) {
      if(c2 < 0xa1 || c2 > 0xfe) return 1;
      return 2;
    }
  } else if(code == XU_CONV_EUCCN) {
    if(c1 < 0xa1 || c1 > 0xf7) return 1;
    if(c2 < 0xa1 || c2 > 0xfe) return 1;
    return 2;
  } else if(code == XU_CONV_BIG5) {
    if(c1 < 0xa1 || c1 > 0xf9) return 1;
    if(c2 < 0x40 || c2 > 0xfe) return 1;
    if(0x7e < c2 && c2 < 0xa1) return 1;
    return 2;
  }
  
  return 1;
}


/**
  UTF-8 -> Unicode
*/

XUChar XUutf8CharEncode(const char* text, int max,int* rlen)
{
  XUChar c[6];
  *rlen = 1;
 
  if(max == 0 || !*text) return 0;
  
  c[0] = (XUChar)(unsigned char)*text;
  if(max == 1 || c[0] < 0xc0 || c[0] > 0xfd) return c[0];
  text++;
  
  c[1] = (XUChar)(unsigned char)*text;
  if((c[1] & 0xc0) != 0x80) return c[0];
  c[1] = c[1] & 0x3f;
  if((c[0] & 0xe0) == 0xc0) {
    if(c[0] < 0xc2) return c[0];
    *rlen = 2;
    return ((c[0] & 0x1f) << 6) + c[1];
  }
  if(max == 2) return c[0];
  text++;
  
  c[2] = (XUChar)(unsigned char)*text;
  if((c[2] & 0xc0) != 0x80) return c[0];
  c[2] = c[2] & 0x3f;
  if((c[0] & 0xf0) == 0xe0) {
    if(c[1] < 0x20 && c[0] < 0xe1) return c[0];
    *rlen = 3;
    return ((c[0] & 0x0f) << 12) + (c[1] << 6) + c[2];
  }
  if(max == 3) return c[0];
  text++;
  
  c[3] = (XUChar)(unsigned char)*text;
  if((c[3] & 0xc0) != 0x80) return c[0];
  c[3] = c[3] & 0x3f;
  if((c[0] & 0xf8) == 0xf0) {
    if(c[1] < 0x10 && c[0] < 0xf1) return c[0];
    *rlen = 4;
    return ((c[1] & 0x0f) << 12) + (c[2] << 6) + c[3];
  }
  if(max == 4) return c[0];
  text++;
  
  c[4] = (XUChar)(unsigned char)*text;
  if((c[4] & 0xc0) != 0x80) return c[0];
  c[4] = c[4] & 0x3f;
  if((c[0] & 0xfc) == 0xf8) {
    if(c[1] < 0x08 && c[0] < 0xf9) return c[0];
    *rlen = 5;
    return ((c[2] & 0x0f) << 12) + (c[3] << 6) + c[4];
  }
  if(max == 5) return c[0];
  text++;
  
  c[5] = (XUChar)(unsigned char)*text;
  if((c[5] & 0xc0) != 0x80) return c[0];
  c[5] = c[5] & 0x3f;
  if(c[1] < 0x04 && c[0] < 0xfd) return c[0];
  *rlen = 6;
  return ((c[3] & 0x0f) << 12) + (c[4] << 6) + c[5];
}


/**
  Unicode -> UTF-8
*/

int XUutf8CharDecode(char* dest, int max, XUChar ch)
{
  if(ch < 0x0080) {
    if(max >= 1) dest[0] = (char)ch;
    if(max >= 2) dest[1] = '\0';
    return 1;
  }
  
  if(ch < 0x0800) {
    if(max >= 1) dest[0] = (char)(0xc0 + ((ch >> 6) & 0x001f));
    if(max >= 2) dest[1] = (char)(0x80 + (ch & 0x003f));
    if(max >= 3) dest[2] = '\0';
    return 2;
  }
  
  if(max >= 1) dest[0] = (char)(0xe0 + ((ch >> 12) & 0x000f));
  if(max >= 2) dest[1] = (char)(0x80 + ((ch >>  6) & 0x003f));
  if(max >= 3) dest[2] = (char)(0x80 + (ch & 0x003f));
  if(max >= 4) dest[3] = '\0';
  return 3;
}


int XUutf8CharLen(const char* text, int max)
{
  XUChar c1;
  XUChar c2;
  XUChar ch;
  
  if(max == 0 || !*text) return 1;
  
  c1 = (XUChar)(unsigned char)*text;
  if(max == 1 || c1 < 0xc0 || c1 > 0xfd) return 1;
  text++;
  
  c2 = (XUChar)(unsigned char)*text;
  if((c2 & 0xc0) != 0x80) return 1;
  c2 = c2 & 0x3f;
  if((c1 & 0xe0) == 0xc0) {
    if(c1 < 0xc2) return 1;
    return 2;
  }
  if(max == 2) return 1;
  text++;
  
  ch = (XUChar)(unsigned char)*text;
  if((ch & 0xc0) != 0x80) return 1;
  if((c1 & 0xf0) == 0xe0) {
    if(c2 < 0x20 && c1 < 0xe1) return 1;
    return 3;
  }
  if(max == 3) return 1;
  text++;
  
  ch = (XUChar)(unsigned char)*text;
  if((ch & 0xc0) != 0x80) return 1;
  if((c1 & 0xf8) == 0xf0) {
    if(c2 < 0x10 && c1 < 0xf1) return 1;
    return 4;
  }
  if(max == 4) return 1;
  text++;
  
  ch = (XUChar)(unsigned char)*text;
  if((ch & 0xc0) != 0x80) return 1;
  if((c1 & 0xfc) == 0xf8) {
    if(c2 < 0x08 && c1 < 0xf9) return 1;
    return 5;
  }
  if(max == 5) return 1;
  text++;
  
  ch = (XUChar)(unsigned char)*text;
  if((ch & 0xc0) != 0x80) return 1;
  if(c2 < 0x04 && c1 < 0xfd) return 1;
  return 6;
}


int XUutf8CharRLen(const char* text, int max)
{
  XUChar c1;
  XUChar c2;
  
  if(max == 0) return 1;
  text--;
  
  c1 = (XUChar)(unsigned char)*text;
  if(max == 1 || (c1 & 0xc0) != 0x80) return 1;
  text--;
  
  c1 = (XUChar)(unsigned char)*text;
  if((c1 & 0xe0) == 0xc0) {
    if(c1 < 0xc2) return 1;
    return 2;
  }
  if(max == 2 || (c1 & 0xc0) != 0x80) return 1;
  text--;
  
  c2 = c1 & 0x3f;
  c1 = (XUChar)(unsigned char)*text;
  if((c1 & 0xf0) == 0xe0) {
    if(c2 < 0x20 && c1 < 0xe1) return 1;
    return 3;
  }
  if(max == 3 || (c1 & 0xc0) != 0x80) return 1;
  text--;
  
  c2 = c1 & 0x3f;
  c1 = (XUChar)(unsigned char)*text;
  if((c1 & 0xf8) == 0xf0) {
    if(c2 < 0x10 && c1 < 0xf1) return 1;
    return 4;
  }
  if(max == 4 || (c1 & 0xc0) != 0x80) return 1;
  text--;
  
  c2 = c1 & 0x3f;
  c1 = (XUChar)(unsigned char)*text;
  if((c1 & 0xfc) == 0xf8) {
    if(c2 < 0x08 && c1 < 0xf9) return 1;
    return 5;
  }
  if(max == 5 || (c1 & 0xc0) != 0x80) return 1;
  text--;
  
  c2 = c1 & 0x3f;
  c1 = (XUChar)(unsigned char)*text;
  if((c1 & 0xfe) == 0xfc) {
    if(c2 < 0x04 && c1 < 0xfd) return 1;
    return 6;
  }
  return 1;
}


int XUStrLen(const XUChar* text)
{
  int ret = 0;
  
  while(*text) {
    text++;
    ret++;
  }
  return ret;
}


/**
  Other -> Unicode(UCS-2)
*/

int XUEncode(XUChar* dest, int max, const char* text, int length, int code)
{
  int ret = 0;
  int chlen;
  
  if(length == 0) {
    if(max > 0) *dest = 0;
    return 0;
  }
  
#if defined WIN32 && !defined BTRON
  if(code == XU_CONV_LOCALE) {
    ret = MultiByteToWideChar(CP_ACP, 0, text, length, NULL, 0);
    MultiByteToWideChar(CP_ACP, 0, text, length, dest, max);
    if(ret < max) dest[ret] = L'\0';
    return ret;
  }
#endif

  for(;;) {
    if(length < 0 && !*text) break;
    if(ret < max) {
      *dest = XUCharEncode(text, length, code,&chlen);
      dest++;
    }else{
      chlen = XUCharLen(text, length, code);
    }
    ret++;
    text += chlen;
    if(length > 0) {
      length -= chlen;
      if(length < 1) break;
    }
  }
  
  if(ret < max) *dest = 0;
  return ret;
}


/**
  Unicode(UCS-2) -> Other
*/

int XUDecode(char* dest, int max, const XUChar* text, int length, int code)
{
  int ret = 0;
  int chlen;
  
  if(length == 0) {
    if(max > 0) *dest = 0;
    return 0;
  }
  
#if defined WIN32 && !defined BTRON
  if(code == XU_CONV_LOCALE) {
    ret = WideCharToMultiByte(CP_ACP, 0, text, length, NULL, 0, NULL, NULL);
    WideCharToMultiByte(CP_ACP, 0, text, length, dest, max, NULL, NULL);
    if(ret < max) dest[ret] = '\0';
    return ret;
  }
#endif
  
  for(;;) {
    if(length < 0 && !*text) break;
    chlen = XUCharDecode(dest, max, *text, code);
    ret += chlen;
    if(max > 0) {
      dest += chlen;
      max -= chlen;
    }
    text++;
    if(length > 0) {
      length--;
      if(length < 1) break;
    }
  }
  
  if(max > 0) *dest = 0;
  return ret;
}


int XULen(const char* text, int max, int code)
{
  int ret = 0;
  int chlen;
  
  if(max == 0) return 0;
  
#if defined WIN32 && !defined BTRON
  if(code == XU_CONV_LOCALE) {
    return MultiByteToWideChar(CP_ACP, 0, text, max, NULL, 0);
  }
#endif
  
  for(;;) {
    if(max < 0 && !*text) break;
    ret++;
    chlen = XUCharLen(text, max, code);
    text += chlen;
    if(max > 0) {
      max -= chlen;
      if(max < 1) break;
    }
  }
  return ret;
}


/**
  UTF-8 -> UCS-2
*/

int XUutf8Encode(XUChar* dest, int max, const char* text, int length)
{
  int ret = 0;
  int chlen;
  
  if(length == 0) {
    if(max > 0) *dest = 0;
    return 0;
  }
  
  for(;;) {
    if(length < 0 && !*text) break;
    if(ret < max) {
      *dest = XUutf8CharEncode(text, length,&chlen);
      dest++;
    }else{
      chlen = XUutf8CharLen(text, length);
    }
    ret++;
    text += chlen;
    if(length > 0) {
      length -= chlen;
      if(length < 1) break;
    }
  }
  
  if(ret < max) *dest = 0;
  return ret;
}


/**
  UCS-2 -> UTF-8
*/

int XUutf8Decode(char* dest, int max, const XUChar* text, int length)
{
  int ret = 0;
  int chlen;
  
  if(length == 0) {
    if(max > 0) *dest = 0;
    return 0;
  }
  
  for(;;) {
    if(length < 0 && !*text) break;
    chlen = XUutf8CharDecode(dest, max, *text);
    ret += chlen;
    if(max > 0) {
      dest += chlen;
      max -= chlen;
    }
    text++;
    if(length > 0) {
      length--;
      if(length < 1) break;
    }
  }
  
  if(max > 0) *dest = 0;
  return ret;
}


int XUutf8Len(const char* text, int max)
{
  int ret = 0;
  int chlen;
  
  if(max == 0) return 0;
  
  for(;;) {
    if(max < 0 && !*text) break;
    ret++;
    chlen = XUutf8CharLen(text, max);
    text += chlen;
    if(max > 0) {
      max -= chlen;
      if(max < 1) break;
    }
  }
  return ret;
}


int XUCodeConv(char* dest, int max, int codeTo, const char* text, int length, int codeFrom)
{
  XUChar* buf;
  int len1;
  int len2;
  
  if(length < 0) length = strlen(text);
  buf = new XUChar[length];
  len1 = XUEncode(buf, length, text, length, codeFrom);
  len2 = XUDecode(dest, max, buf, len1, codeTo);
  delete[] buf;
  return len2;
}

int WSGFdeviceQueryChar(WSCushort* c,int* order){
  int charset = 0;
  int i = 0;
  XUChar check;

  check = 0x2000;

#ifndef NO_KSC5601
  if(0xac00 <= *c && *c <= 0xd7a3 && table_rev_ksc5601[*c]) {
    charset = WS_FONT_KSC5601;
    *c = table_rev_ksc5601[*c];
    if((*c >> 8) >= 0x80 || (*c & 0xff) >= 0x80) {
      *c -= 0x8080;
    } else {
      charset = WS_FONT_ISO8859(1);
      *c = '?';
    }
  } else
#endif
  if(0xff61 <= *c && *c <= 0xff9f) {
#ifndef NO_JAPANESE
    charset = WS_FONT_JIS0201;
    *c -= 0xfec0;
#endif
  } else {
    charset = WS_FONT_UNICODE;
    for(i = 0; i < WS_FONT_COUNT; i++) {
      if (order[i] == 0){
        break;
      }
      if(charset != WS_FONT_UNICODE) break;
      switch(order[i]) {
      case WS_FONT_ISO8859(1):
        if(*c < 0x0100){
          charset = WS_FONT_ISO8859(1);
          return charset;
        }
        break;
      case WS_FONT_ISO8859(2):
        if(*c < 0x0400 && table_rev_latin2[*c]) {
          charset = WS_FONT_ISO8859(2);
          *c = table_rev_latin2[*c];
          return charset;
        }
        break;
      case WS_FONT_KOI8R:
        if(0x0080 <= *c && *c < 0x0480 && table_rev_koi8r_1[*c - 0x0080]) {
          charset = WS_FONT_KOI8R;
          *c = table_rev_koi8r_1[*c - 0x0080];
          return charset;
        } else if(0x2200 <= *c && *c < 0x2600 && table_rev_koi8r_2[*c - 0x2200]) {
          charset = WS_FONT_KOI8R;
          *c = table_rev_koi8r_2[*c - 0x2200];
          return charset;
        }
        break;
      case XU_FONT_CP1251:
        if(0x0080 <= *c && *c < 0x0480 && table_rev_cp1251_1[*c - 0x0080]) {
          charset = XU_FONT_CP1251;
          *c = table_rev_cp1251_1[*c - 0x0080];
          return charset;
        } else if(0x2200 <= *c && *c < 0x2600 && table_rev_cp1251_2[*c - 0x2200]) {
          charset = XU_FONT_CP1251;
          *c = table_rev_cp1251_2[*c - 0x2200];
          return charset;
        }
        break;
#ifndef NO_JAPANESE
      case WS_FONT_JIS0208:
        if(*c >= check && table_rev_jis0208[*c]) {
          charset = WS_FONT_JIS0208;
          *c = table_rev_jis0208[*c];
          return charset;
        }
        break;
#endif
#ifndef NO_KSC5601
      case WS_FONT_KSC5601:
        if(*c >= check && table_rev_ksc5601[*c]) {
          charset = WS_FONT_KSC5601;
          *c = table_rev_ksc5601[*c];
          if((*c >> 8) >= 0x80 || (*c & 0xff) >= 0x80) {
            *c -= 0x8080;
          } else {
            charset = WS_FONT_ISO8859(1);
            *c = '?';
          }
          return charset;
        }
        break;
#endif
#ifndef NO_GB2312
      case WS_FONT_GB2312:
        if(*c >= check && table_rev_gb2312[*c]) {
          charset = WS_FONT_GB2312;
          *c = table_rev_gb2312[*c];
          return charset;
        }
        break;
#endif
#ifndef NO_BIG5
      case WS_FONT_BIG5:
        if(*c >= check && table_rev_big5[*c]) {
          charset = WS_FONT_BIG5;
          *c = table_rev_big5[*c];
          return charset;
        }
        break;
#endif
      }
    }
  }
  return charset;
}


