//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <devfb/devfb.h>
#include <WScom.h>
#ifndef NO_WSDMUTEX
#include <WStcpcom.h>
#include <devfb/WSDdevfbMutex.h>
#include <stdio.h>
#include <WSClocaleSet.h>

WSMFclassInit(WSDdevfbMutex,WSDmutex);

WSDmutex* _devfb_mutex_chandler(){
  return new WSDdevfbMutex;
}

void WSGFinitializeUnixMutex(){
    WSDmutex::setCreateInstanceHandler((void*)_devfb_mutex_chandler);
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _devfb_mutex_init {
  public: _devfb_mutex_init(){
    WSDmutex::setCreateInstanceHandler((void*)_devfb_mutex_chandler);
  };
};
_devfb_mutex_init  _devfb_mutex_init_execute;
#endif

WSDdevfbMutex::WSDdevfbMutex(){
}

WSDdevfbMutex::~WSDdevfbMutex(){
}

long WSDdevfbMutex::initialize(){
  _mutex = cre_sem(1,SEM_EXCL | DELEXIT);
  return WS_NO_ERR;
}
long WSDdevfbMutex::lock(){
  int ret = wai_sem(_mutex,T_FOREVER);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDdevfbMutex::trylock(){
#if 0
  int ret = pthread_mutex_trylock(&_mutex);
  if (ret == 0){
    return WS_NO_ERR;
  }
#endif
  return WS_ERR;
}

long WSDdevfbMutex::unlock(){
  int ret = sig_sem(_mutex);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDdevfbMutex::destroy(){
  int ret = del_sem(_mutex);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}
#endif
