//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <devfb/devfb.h>
#include <WScom.h>
#ifndef NO_WSDSEMAPHORE
#include <WStcpcom.h>
#include <devfb/WSDdevfbSemaphore.h>
#include <stdio.h>
#include <WSClocaleSet.h>

WSMFclassInit(WSDdevfbSemaphore,WSDsemaphore);

WSDsemaphore* _devfb_sem_chandler(){
  return new WSDdevfbSemaphore;
}

void WSGFinitializeUnixSemaphore(){
    WSDsemaphore::setCreateInstanceHandler((void*)_devfb_sem_chandler);
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _devfb_sem_init {
  public: _devfb_sem_init(){
    WSGFinitializeUnixSemaphore();
  };
};
_devfb_sem_init  _devfb_sem_init_execute;
#endif

WSDdevfbSemaphore::WSDdevfbSemaphore(){
}

WSDdevfbSemaphore::~WSDdevfbSemaphore(){
}

long WSDdevfbSemaphore::initialize(){
  WERR sem = cre_sem(0,SEM_SYNC|DELEXIT );
  if (sem < 0){
    return WS_ERR;
  }
  _sem = sem;
  return WS_NO_ERR;
}
long WSDdevfbSemaphore::lock(){
  if (_sem == 0){
    return WS_ERR;
  }
  int ret = wai_sem(_sem,T_FOREVER);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDdevfbSemaphore::unlock(){
  if (_sem == 0){
    return WS_ERR;
  }
  int ret = sig_sem(_sem);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDdevfbSemaphore::destroy(){
  if (_sem == 0){
    return WS_ERR;
  }
  int ret = del_sem(_sem);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}


#endif
