//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <WScom.h>
#include <devfb/devfb.h>
#include <devfb/devfb_dep.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fbconfig.h>
#ifdef TE
#include <btron/taskcomm.h>
//import from btron/message.h
#define CHECK 0x0002
#endif
#ifdef LINUX
#include <sys/time.h>
#endif

void* _context_area = NULL;
int   _sem_id = 0;
int   _event_sem_id = 0;

WSDdeviceWindow* _window_list = NULL;
WSDdeviceGC*     _gc_list = NULL;
WSDdeviceEventList*  _evt_list = NULL;;
unsigned int _default_black_color = 0;
unsigned int _default_white_color = 0;

#ifndef _NOTSH
WSClistData _message_list(MAX_MESSAGES);
WSClistData _message_time_list(MAX_MESSAGES);
WSClistData _message_rate_list(MAX_MESSAGES);
#endif

extern int _add_event(WSDdeviceEventList* evt);
extern int _device_check_event_available();
void (*_create_window_handler)(WSDdeviceWindow*) = NULL;
void (*_update_window_handler)(WSDdeviceWindow*) = NULL;
void (*_destroy_window_handler)(WSDdeviceWindow*) = NULL;
extern int _draw_fill_poly(int gid,WSCpoint* point,int num, unsigned int bg,int rev,WSCbool shortcut);

void* get_shared_memory(){
  //TODO: replace returning shared memory function.
  void* ptr =  malloc(WS_MAX_CONTEXT_AREA);
  memset(ptr,0,WS_MAX_CONTEXT_AREA);
  return ptr;
}
unsigned int get_current_time(){
#ifdef LINUX
//TODO: replace ...
  struct timeval  _tmvl;
  struct timezone _tzp;
//  struct tm*      _tm;
  gettimeofday( &_tmvl, &_tzp ) ;
  unsigned int val = _tmvl.tv_sec *1000 + _tmvl.tv_usec /1000;
//printf("get_current_time=%d\n",val);
  return val;
#else
  return 0;
#endif
}

//TODO: replace semaphore...
#if defined (LINUX) || defined (MacOS)
int pthread_sem_init_np(pthread_sem_t* semp){
#ifdef NO_THREAD
  return WS_ERR;
#else
  semp->value = 1;
  pthread_mutex_init(&(semp->mutex),NULL);
  pthread_cond_init(&(semp->lock_free),NULL);
  return 0;
#endif
}
int pthread_sem_lock_np(pthread_sem_t* semp){
#ifdef NO_THREAD
  return WS_ERR;
#else
  pthread_mutex_lock(&(semp->mutex));
  if (--semp->value < 0){
    pthread_cond_wait(&(semp->lock_free),&(semp->mutex));
  }
  pthread_mutex_unlock(&(semp->mutex));
  return 0;
#endif
}
int pthread_sem_unlock_np(pthread_sem_t* semp){
#ifdef NO_THREAD
  return WS_ERR;
#else
  pthread_mutex_lock(&(semp->mutex));
  if (++semp->value < 1){
    pthread_cond_signal(&(semp->lock_free));
  }
  pthread_mutex_unlock(&(semp->mutex));
  return 0;
#endif
}
int pthread_sem_destroy_np(pthread_sem_t* semp){
#ifdef NO_THREAD
  return WS_ERR;
#else
  pthread_cond_destroy(&(semp->lock_free));
  pthread_mutex_destroy(&(semp->mutex));
  return 0;
#endif
}

int WSGFdeviceSemCreate(int cnt,unsigned int opt){
#ifdef NO_THREAD
  return WS_ERR;
#else
  //TODO: initialize sepaphore..
  if (cnt < 0){
    return WS_ERR_PAR;
  }
  pthread_sem_t* sem = (pthread_sem_t*)malloc(sizeof(pthread_sem_t));
  pthread_sem_init_np(sem);
  int ret = (int)sem;
  if (cnt == 0){
    pthread_sem_lock_np(sem);
    return ret;
  }
  if (cnt > 1){
    return WS_ERR_PAR;
  }
  return ret;
#endif
}

int WSMFdeviceSemLock(int id){
#ifdef NO_THREAD
  return WS_ERR;
#else
  //TODO: lock sepaphore..
  pthread_sem_t* sem = (pthread_sem_t*)id;
  pthread_sem_lock_np(sem);
  return WS_NO_ERR;
#endif
}
int WSGFdeviceSemLock(int id){
  return WSMFdeviceSemLock(id);
}

int WSMFdeviceSemUnlock(int id){
#ifdef NO_THREAD
  return WS_ERR;
#else
  //TODO: unlock sepaphore..
  pthread_sem_t* sem = (pthread_sem_t*)id;
  pthread_sem_unlock_np(sem);
  return WS_NO_ERR;
#endif
}
int WSGFdeviceSemUnlock(int id){
  return WSMFdeviceSemUnlock(id);
}
int WSGFdeviceSemDestroy(int id){
#ifdef NO_THREAD
  return WS_ERR;
#else
  //TODO: destroy sepaphore..
  pthread_sem_t* sem = (pthread_sem_t*)id;
  pthread_sem_destroy_np(sem);
  free(sem);
  return WS_NO_ERR;
#endif
}
#endif
#ifdef TE
int WSGFdeviceSemCreate(int cnt,unsigned int opt){
//  return cre_sem(cnt,opt);
  return cre_sem(cnt,SEM_SYNC|DELEXIT);
//  return cre_sem(cnt,SEM_EXCL|DELEXIT);
}
int WSMFdeviceSemLock(int id){
  return wai_sem(id,T_FOREVER);
}
int WSGFdeviceSemLock(int id){
  return wai_sem(id,T_FOREVER);
}
int WSMFdeviceSemUnlock(int id){
  return sig_sem(id);
}
int WSGFdeviceSemUnlock(int id){
  return sig_sem(id);
}
int WSGFdeviceSemDestroy(int id){
  return del_sem(id);
}
#endif

int check_wid(int wid){
  if (!(wid > 0)){
    return WS_ERR_WID;
  }
  if (wid > WS_MAX_WINDOW){
    return WS_ERR_WID;
  }

  if (!(_window_list[wid -1]._window_id == wid)){
    return WS_ERR_WID;
  }
  return WS_NO_ERR;
}
inline int check_gid(int gid){
  if (!(gid > 0)){
    return WS_ERR_GID;
  }
  if (gid > WS_MAX_GC){
    return WS_ERR_GID;
  }

  if (!(_gc_list[gid -1]._gid == gid)){
    return WS_ERR_GID;
  }
  return WS_NO_ERR;
}

inline WSCbool WSGFinArea(short x,short y,unsigned short w,unsigned short h,short px,short py){
  if (px <x){
    return False;
  }
  if (x + w < px){
    return False;
  }
  if (py <y){
    return False;
  }
  if (y + h < py){
    return False;
  }
  return True;
}
inline long WSMFandArea(long x1,long y1,WSCulong w1,WSCulong h1,
                 long x2,long y2,WSCulong w2,WSCulong h2,
                 long* x,long* y,WSCulong* w,WSCulong* h){

  *x = x1 > x2 ? x1 : x2;
  *y = y1 > y2 ? y1 : y2;

//  short ww = (short)(x1+w1) < (short)(x2+w2) ? x1+w1 - *x : x2+w2 - *x;
//  short wh = (short)(y1+h1) < (short)(y2+h2) ? y1+h1 - *y : y2+h2 - *y;
  long ww = (long)(x1+w1) < (long)(x2+w2) ? x1+w1 - *x : x2+w2 - *x;
  long wh = (long)(y1+h1) < (long)(y2+h2) ? y1+h1 - *y : y2+h2 - *y;
  if (ww > 0){
    *w = ww;
  }else{
    *x = 0;
    *y = 0;
    *w = 0;
    *h = 0;
    return WS_ERR;
  }
  if (wh > 0){
    *h = wh;
  }else{
    *x = 0;
    *y = 0;
    *w = 0;
    *h = 0;
    return WS_ERR;
  }
  return WS_NO_ERR;
}

int _search_window(short x,short y){
  int i;
  int stack_no = WS_MAX_WINDOW;
  int wid = 0;
  for(i=0; i<WS_MAX_WINDOW;i++){
    if (_window_list[i]._window_id == 0){
      continue;
    }
    if (_window_list[i]._stack_no < stack_no){
      if (WSGFinArea(_window_list[i]._x,_window_list[i]._y,
                     _window_list[i]._w,_window_list[i]._h,x,y) != False){
        wid = i+1;
        stack_no = _window_list[i]._stack_no;
      }
    }
  }
  return wid;
}


unsigned char* _buffer = NULL;
int _device_row_bytes = DEFAULT_DEVICE_WIDTH;
int _device_width = DEFAULT_DEVICE_WIDTH;
int _device_height = DEFAULT_DEVICE_HEIGHT;
int _device_depth = DEFAULT_DEVICE_DEPTH;
unsigned int _device_start_red =   DEFAULT_DEVICE_RED_SHIFT;
unsigned int _device_start_green = DEFAULT_DEVICE_GREEN_SHIFT;
unsigned int _device_start_blue =  DEFAULT_DEVICE_BLUE_SHIFT;
unsigned int _device_red_bits =    DEFAULT_DEVICE_RED_BIT;
unsigned int _device_green_bits =  DEFAULT_DEVICE_GREEN_BIT;
unsigned int _device_blue_bits =   DEFAULT_DEVICE_BLUE_BIT;

//#if defined LINUX || defined USE_X11
#ifndef NO_THREAD
int   _event_wait_sem = 0;
int   _event_waiting = 0;
void _init_for_event_function(){
  _event_wait_sem = WSGFdeviceSemCreate(1,0);
  WSMFdeviceSemLock(_event_wait_sem);
}

void _wake_up_event(){
  WSMFdeviceSemLock(_event_sem_id);
  if (_event_waiting != False){
    _event_waiting = False;
    WSMFdeviceSemUnlock(_event_wait_sem);
  }
  WSMFdeviceSemUnlock(_event_sem_id);
}

void _wait_event(){
  WSMFdeviceSemLock(_event_sem_id);
  if (_evt_list == NULL && _device_check_event_available() == False ){
    _event_waiting = True;
    WSMFdeviceSemUnlock(_event_sem_id);
    WSMFdeviceSemLock(_event_wait_sem);
    return;
  }
  WSMFdeviceSemUnlock(_event_sem_id);
}
//extern pthread_sem_t _event_sem;
#endif
//#endif


int WSGFdeviceFrameBufferInitialize(){
TIME_TRACE("WSGFdeviceFrameBufferInitialize() start");
  //TODO: initialize(or attach) global(or kernel) context area..
  if (_context_area == NULL){
    _context_area = get_shared_memory();
  }
  if (_context_area == NULL){
    return WS_ERR;
  }
  //TODO: initialize colors.
  _default_black_color = 0x000000;
  _default_white_color = 0xffffff;

  char* ptr = (char*)_context_area;
  _window_list = (WSDdeviceWindow*)_context_area;
  _gc_list = (WSDdeviceGC*)&(ptr[WS_MAX_WINDOW_AREA]);
  _sem_id = WSGFdeviceSemCreate(1,0);
  _event_sem_id = WSGFdeviceSemCreate(1,0);
#ifndef NO_THREAD
  _init_for_event_function();
#endif
  int ret =  _init_frame_buffer();
TIME_TRACE("WSGFdeviceFrameBufferInitialize() done");
  return ret;
}
int _device_insert_window(int parent_wid,int wid){
  if (parent_wid < 0 || WS_MAX_WINDOW < parent_wid){
    return WS_ERR_WID;
  }

  if (wid < 1){
    return WS_ERR_WID;
  }

  if (_window_list[wid -1]._window_id != wid){
    return WS_ERR_PAR;
  }

  int i;
  if (parent_wid == 0){
    for(i=0; i<WS_MAX_WINDOW; i++){
      if (_window_list[i]._window_id == wid){
        _window_list[i]._stack_no = 1;
      }else
      if (_window_list[i]._window_id > 0){
        _window_list[i]._stack_no++;
      }
    }
    return WS_NO_ERR;
  }
#if 0
  int stack_no = _window_list[parent_wid-1]._stack_no;
  for(i=0; i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._stack_no < stack_no){
      //do nothing.
    }else
    if (_window_list[i]._window_id == wid){
      _window_list[i]._stack_no = stack_no;
    }else{
      _window_list[i]._stack_no++;
    }
  }
#endif
  for(i=0; i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._stack_no < 1){
      //do nothing.
    }else
    if (_window_list[i]._window_id == wid){
      _window_list[i]._stack_no = 1;
    }else{
      _window_list[i]._stack_no++;
    }
  }
  return WS_NO_ERR;
}

int _add_event(WSDdeviceEventList* evt){
//printf("_add_event evtl=%d\n",evt);
  if (_evt_list == NULL){
    _evt_list = evt;
    _evt_list->_next = NULL;
    return WS_NO_ERR;
  }
  WSDdeviceEventList* item = _evt_list;
  while(1){
    if (item->_event.e.type == EV_NULL && evt->_event.e.type == EV_NULL){
      memcpy(&(item->_event),&(evt->_event),sizeof(WSDdeviceEvent));
      free(evt);
//printf("_add_event done.\n");
      return WS_NO_ERR;
    }
    if (item->_next == NULL){
      evt->_next = NULL;
      item->_next = evt;
//printf("_add_event done2.\n");
      return WS_NO_ERR;
    }
    item = item->_next;
  }
//printf("_add_event done err.\n");
  return WS_ERR;
}


int _get_device_screen_size(int* w,int* h){
  *w = _device_width;
  *h = _device_height;
  return WS_NO_ERR;
} 

inline WSCbool _check_raw_point(int gid,short x,short y){
  WSCrect* ex_list = _gc_list[gid-1]._ex_region_list;
  if (ex_list != NULL){
    int i;
    int num = _gc_list[gid-1]._ex_region_list_num;
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)&ex_list[i];
      if (r->x <= x && x < r->x + (int)r->width &&
          r->y <= y && y < r->y + (int)r->height ){
        return False;
      }
    }
  }
  int num = _gc_list[gid-1]._visible_region_list_num;
  if (num >0){
    WSCrect* vis_list = _gc_list[gid-1]._visible_region_list;
    int i;
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)&vis_list[i];
      if (r->x <= x && x < r->x + (int)r->width &&
          r->y <= y && y < r->y + (int)r->height ){
      }else{
        return False;
      }
    }
  }
  return True;
}

inline WSCbool _check_raw_point_ex_only(int gid,short x,short y){
  WSCrect* ex_list = _gc_list[gid-1]._ex_region_list;
  if (ex_list != NULL){
    int i;
    int num = _gc_list[gid-1]._ex_region_list_num;
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)&ex_list[i];
      if (r->x <= x && x < r->x + (int)r->width &&
          r->y <= y && y < r->y + (int)r->height ){
        return False;
      }
    }
  }
  return True;
}
#define LINE_OPTIMIZE
#ifdef LINE_OPTIMIZE
inline int _check_line_clossed(short x1, short y1, short x2, short y2,
                            short x3, short y3, short x4, short y4,
                            short* ptx,short* pty){
  if (x3 == x4){
    if (x1 < x2){
      if (x3 < x1 || x2 < x3){
        return False;
      }
    }else if (x2 < x1){
      if (x3 < x2 || x1 < x3){
        return False;
      }
    }else{
      return False;
    }
    long a = FP_BASE*(y2-y1)/(x2 -x1);
    long b = FP_BASE*y1 - a*x1;
    short py = (a*x3 + b)/FP_BASE;
    if (y3 < y4){
      if (py < y3 || y4 < py){
        return False;
      }
    }else{
      if (py < y4 || y3 < py){
        return False;
      }
    }
    *ptx = x3;
    *pty = py;
    return True;
  }else
  if (y3 == y4){
    if (y1 < y2){
      if (y3 < y1 || y2 < y3){
        return False;
      }
    }else if (y2 < y1){
      if (y3 < y2 || y1 < y3){
        return False;
      }
    }else{
      return False;
    }
    
    long ad = FP_BASE*(x2 -x1)/(y2-y1);
    long bd = FP_BASE*x1 - ad*y1;
    short px = (ad*y3 + bd)/FP_BASE;

    if (x3 < x4){
      if (px < x3 || x4 < px){
        return False;
      }
    }else{
      if (px < x4 || x3 < px){
        return False;
      }
    }
    *ptx = px;
    *pty = y3;
    return True;
  }
  //not supported..
  return False;
}

inline int _get_line_in_rect(short* x1,short* y1,short* x2,short* y2,
                            short x,short y,
                            unsigned short w, unsigned short h){
  WSCpoint pt1[2];
  if (*x1 == *x2){
    if (*y1 < *y2){
      pt1[0].x = *x1;
      pt1[0].y = *y1;
      pt1[1].x = *x2;
      pt1[1].y = *y2;
    }else{
      pt1[0].x = *x2;
      pt1[0].y = *y2;
      pt1[1].x = *x1;
      pt1[1].y = *y1;
    }
  }else
  if (*x1 < *x2){
    pt1[0].x = *x1;
    pt1[0].y = *y1;
    pt1[1].x = *x2;
    pt1[1].y = *y2;
  }else{
    pt1[0].x = *x2;
    pt1[0].y = *y2;
    pt1[1].x = *x1;
    pt1[1].y = *y1;
  }
//TEST
  WSCbool in1 = WSGFinArea(x,y,w-1,h-1,pt1[0].x,pt1[0].y);
  WSCbool in2 = WSGFinArea(x,y,w-1,h-1,pt1[1].x,pt1[1].y);
if (*x1==249)printf("in1=%d,in2=%d\n",in1,in2);
  if ((in1 != False) && (in2 != False)){
    return True;
  }

  WSCpoint closspt[4];
  int      clossed[4];
  int cnt = 0;
  short tx,ty;

  WSCpoint pt2[2];
  clossed[0] = _check_line_clossed(*x1,*y1,*x2,*y2,x,y,x+w-1,y,&tx,&ty);
  closspt[0].x = tx;
  closspt[0].y = ty;
  if (clossed[0] != False){
    cnt++;
  }
  clossed[1] = _check_line_clossed(*x1,*y1,*x2,*y2,x,y,x,y+h-1,&tx,&ty);
  closspt[1].x = tx;
  closspt[1].y = ty;
  if (clossed[1] != False){
    cnt++;
  }
  clossed[2] = _check_line_clossed(*x1,*y1,*x2,*y2,x+w-1,y,x+w-1,y+h-1,&tx,&ty);
  closspt[2].x = tx;
  closspt[2].y = ty;
  if (clossed[2] != False){
    cnt++;
  }
  clossed[3] = _check_line_clossed(*x1,*y1,*x2,*y2,x,y+h-1,x+w-1,y+h-1,&tx,&ty);
  closspt[3].x = tx;
  closspt[3].y = ty;
  if (clossed[3] != False){
    cnt++;
  }
//printf("clossed=%d,%d,%d,%d cnt=%d\n",clossed[0],clossed[1],clossed[2],clossed[3],cnt);

  if (clossed[0] == False &&
      clossed[1] == False &&
      clossed[2] == False &&
      clossed[3] == False){
    return False;
  }
  if (cnt == 0){
    return False;
  }
  if (cnt > 0){
    int i;
    int c=0;
    for(i=0; i<4; i++){
      if (clossed[i] != False){
        int j;
        int not_add = False;
        WSCpoint* clspt = &(closspt[i]);
        for(j=0; j<c; j++){
          if (pt2[j].x == clspt->x &&
              pt2[j].y == clspt->y){
            not_add = True;
            break;
          }
        }
        if (not_add == False){
          pt2[c].x = clspt->x;
          pt2[c].y = clspt->y;
          c++;
        }
      }
    }
    cnt = c;
  }
  if (cnt == 2){
    *x1 = pt2[0].x;
    *y1 = pt2[0].y;
    *x2 = pt2[1].x;
    *y2 = pt2[1].y;
    return True;
  }

  if (cnt == 1){
    if (in1 == True){
      *x1 = pt1[0].x;
      *y1 = pt1[0].y;
    }else if (in2 == True){
      *x1 = pt1[1].x;
      *y1 = pt1[1].y;
    }else{
      *x1 = pt2[0].x;
      *y1 = pt2[0].y;
    }
    *x2 = pt2[0].x;
    *y2 = pt2[0].y;
    return 1;
  }
  return 0;
}
inline int _get_hline_in_rect(short* x1,short* y1,short* x2,
                            short x,short y,
                            unsigned short w, unsigned short h){
  short ret_x1;
  short ret_x2;
  if (*y1 < y){
    return 0;
  }
  if (y+h-1 < *y1){
    return 0;
  }
  if (*x1 < *x2){
    if (x < *x1){
      ret_x1 = *x1;
    }else{
      ret_x1 = x;
    }
    if (x + w -1< *x2){
      ret_x2 = x + w-1;
    }else{
      ret_x2 = *x2;
    }
  }else{
    if (x < *x2){
      ret_x1 = *x2;
    }else{
      ret_x1 = x;
    }
    if (x + w -1< *x1){
      ret_x2 = x + w-1;
    }else{
      ret_x2 = *x1;
    }
  }
  if (ret_x1 > ret_x2){
    return 0;
  }
  *x1 = ret_x1;
  *x2 = ret_x2;
  return 1;
}
inline int _get_vline_in_rect(short* x1,short* y1,short* y2,
                            short x,short y,
                            unsigned short w, unsigned short h){
  short ret_y1;
  short ret_y2;
  if (*x1 < x){
    return 0;
  }
  if (x+w-1 < *x1){
    return 0;
  }
  if (*y1 < *y2){
    if (y < *y1){
      ret_y1 = *y1;
    }else{
      ret_y1 = y;
    }
    if (y + h -1< *y2){
      ret_y2 = y + h-1;
    }else{
      ret_y2 = *y2;
    }
  }else{
    if (y < *y2){
      ret_y1 = *y2;
    }else{
      ret_y1 = y;
    }
    if (y + h -1< *y1){
      ret_y2 = y + h-1;
    }else{
      ret_y2 = *y1;
    }
  }
  if (ret_y1 > ret_y2){
    return 0;
  }
  *y1 = ret_y1;
  *y2 = ret_y2;
  return 1;
}


inline int _get_line_outof_rect(short x1,short y1,short x2,short y2,
                            short x,short y,
                            unsigned short w, unsigned short h,
                            WSCpoint* pt){
//printf("_rect_line_outof_rect %d,%d,%d,%d %d,%d-%d,%d\n",x,y,w,h,x1,y1,x2,y2);
  WSCpoint pt1[2];
  if (x1 == x2){
    if (y1 < y2){
      pt1[0].x = x1;
      pt1[0].y = y1;
      pt1[1].x = x2;
      pt1[1].y = y2;
    }else{
      pt1[0].x = x2;
      pt1[0].y = y2;
      pt1[1].x = x1;
      pt1[1].y = y1;
    }
  }else
  if (x1 < x2){
    pt1[0].x = x1;
    pt1[0].y = y1;
    pt1[1].x = x2;
    pt1[1].y = y2;
  }else{
    pt1[0].x = x2;
    pt1[0].y = y2;
    pt1[1].x = x1;
    pt1[1].y = y1;
  }

  WSCbool in1 = WSGFinArea(x,y,w-1,h-1,pt1[0].x,pt1[0].y);
  WSCbool in2 = WSGFinArea(x,y,w-1,h-1,pt1[1].x,pt1[1].y);

  if ((in1 != False) && (in2 != False)){
    return 0;
  }

  WSCpoint closspt[4];
  int      clossed[4];
  int cnt = 0;
  short tx,ty;
  if (y1 == y2){
    if (y-1 == y1 || y+h == y1){
      //do nothing
      pt[0].x = pt1[0].x;
      pt[0].y = pt1[0].y;
      pt[1].x = pt1[1].x;
      pt[1].y = pt1[1].y;
      return 1;
    }
  }
  if (x1 == x2){
    if (x-1 == x1 && x+w == x1){
      //do nothing
      pt[0].x = pt1[0].x;
      pt[0].y = pt1[0].y;
      pt[1].x = pt1[1].x;
      pt[1].y = pt1[1].y;
      return 1;
    }
  }
  clossed[0] = _check_line_clossed(x1,y1,x2,y2,x-1,y-1,x+w,y-1,&tx,&ty);
  closspt[0].x = tx;
  closspt[0].y = ty;
  if (clossed[0] != False){
    cnt++;
  }
  clossed[1] = _check_line_clossed(x1,y1,x2,y2,x-1,y-1,x-1,y+h,&tx,&ty);
  closspt[1].x = tx;
  closspt[1].y = ty;
  if (clossed[1] != False){
    cnt++;
  }
  clossed[2] = _check_line_clossed(x1,y1,x2,y2,x+w,y-1,x+w,y+h,&tx,&ty);
  closspt[2].x = tx;
  closspt[2].y = ty;
  if (clossed[2] != False){
    cnt++;
  }
  clossed[3] = _check_line_clossed(x1,y1,x2,y2,x-1,y+h,x+w,y+h,&tx,&ty);
  closspt[3].x = tx;
  closspt[3].y = ty;
  if (clossed[3] != False){
    cnt++;
  }
 
  if (cnt == 0){
    pt[0].x = pt1[0].x;
    pt[0].y = pt1[0].y;
    pt[1].x = pt1[1].x;
    pt[1].y = pt1[1].y;
    return 1;
  }
//printf("clossed=%d,%d,%d,%d\n",clossed[0],clossed[1],clossed[2],clossed[3]);
  WSCpoint pt2[4];
  if (cnt > 0){
    int i;
    int c=0;
    for(i=0; i<4; i++){
      if (clossed[i] != False){
        int j;
        int not_add = False;
        WSCpoint* clspt = &(closspt[i]);
        for(j=0; j<c; j++){
          if (pt2[j].x == clspt->x &&
              pt2[j].y == clspt->y){
            not_add = True;
            break;
          }
        }
        if (not_add == False){
          pt2[c].x = clspt->x;
          pt2[c].y = clspt->y;
          c++;
        }
      }
    }
    cnt = c;
  }

//printf("clossed=%d\n",cnt);
#if 0
  if (clossed[0] == False &&
      clossed[1] == False &&
      clossed[2] == False &&
      clossed[3] == False){
    pt[0].x = pt1[0].x;
    pt[0].y = pt1[0].y;
    pt[1].x = pt1[1].x;
    pt[1].y = pt1[1].y;
    return 1;
  }
#endif

  if (cnt == 1){
    if (in1 == 0 && in2 == 0){
      pt[0].x = pt1[0].x;
      pt[0].y = pt1[0].y;
      pt[1].x = pt1[1].x;
      pt[1].y = pt1[1].y;
      return 1;
    }
  }else
  if (cnt == 2){
    if (pt2[0].x == pt2[1].x){
      if (pt2[0].y < pt2[1].y){
        pt[0].x = pt1[0].x;
        pt[0].y = pt1[0].y;
        pt[1].x = pt2[0].x;
        pt[1].y = pt2[0].y;
        pt[2].x = pt2[1].x;
        pt[2].y = pt2[1].y;
        pt[3].x = pt1[1].x;
        pt[3].y = pt1[1].y;
        return 2;
      }else{
        pt[0].x = pt1[0].x;
        pt[0].y = pt1[0].y;
        pt[1].x = pt2[1].x;
        pt[1].y = pt2[1].y;
        pt[2].x = pt2[0].x;
        pt[2].y = pt2[0].y;
        pt[3].x = pt1[1].x;
        pt[3].y = pt1[1].y;
        return 2;
      }
    }else
    if (pt2[0].x < pt2[1].x){
      pt[0].x = pt1[0].x;
      pt[0].y = pt1[0].y;
      pt[1].x = pt2[0].x;
      pt[1].y = pt2[0].y;
      pt[2].x = pt2[1].x;
      pt[2].y = pt2[1].y;
      pt[3].x = pt1[1].x;
      pt[3].y = pt1[1].y;
      return 2;
    }else{
      pt[0].x = pt1[0].x;
      pt[0].y = pt1[0].y;
      pt[1].x = pt2[1].x;
      pt[1].y = pt2[1].y;
      pt[2].x = pt2[0].x;
      pt[2].y = pt2[0].y;
      pt[3].x = pt1[1].x;
      pt[3].y = pt1[1].y;
      return 2;
    }
  }
  if (in1 == True){
    if (cnt == 1){
      pt[0].x = pt1[1].x;
      pt[0].y = pt1[1].y;
      pt[1].x = pt2[0].x;
      pt[1].y = pt2[0].y;
      return 1;
    }
  }else
  if (in2 == True){
    if (cnt == 1){
      pt[0].x = pt1[0].x;
      pt[0].y = pt1[0].y;
      pt[1].x = pt2[0].x;
      pt[1].y = pt2[0].y;
      return 1;
    }
  }


  return 0;
}
inline int _get_hline_outof_rect(short x1,short y1,short x2,
                            short x,short y,
                            unsigned short w, unsigned short h,
                            WSCpoint* pt){
  if (x1 > x2){
    short tmp = x1;
    x1 = x2;
    x2 = tmp;
  }
  if (y1 < y){
    pt[0].x = x1;
    pt[0].y = y1;
    pt[1].x = x2;
    pt[1].y = y1;
    return 1;
  }
  if (y+h-1 < y1){
    pt[0].x = x1;
    pt[0].y = y1;
    pt[1].x = x2;
    pt[1].y = y1;
    return 1;
  }
  if (x2 < x){
    pt[0].x = x1;
    pt[0].y = y1;
    pt[1].x = x2;
    pt[1].y = y1;
    return 1;
  }
  if (x+w-1 < x1){
    pt[0].x = x1;
    pt[0].y = y1;
    pt[1].x = x2;
    pt[1].y = y1;
    return 1;
  }
  if (x1 < x){
    pt[0].x = x1;
    pt[0].y = y1;
    if (x2 > x + w-1){
      pt[1].x = x-1;
      pt[1].y = y1;
      pt[2].x = x+w;
      pt[2].y = y1;
      pt[3].x = x2;
      pt[3].y = y1;
      return 2;
    }else{
      pt[1].x = x-1;
      pt[1].y = y1;
      return 1;
    }
  }
  if (x2 > x + w -1){
    pt[0].x = x+w;
    pt[0].y = y1;
    pt[1].x = x2;
    pt[1].y = y1;
    return 1;
  }
  return 0;
}

inline int _get_vline_outof_rect(short x1,short y1,short y2,
                            short x,short y,
                            unsigned short w, unsigned short h,
                            WSCpoint* pt){
  if (y1 > y2){
    short tmp = y1;
    y1 = y2;
    y2 = tmp;
  }
  if (x1 < x){
    pt[0].x = x1;
    pt[0].y = y1;
    pt[1].x = x1;
    pt[1].y = y2;
    return 1;
  }
  if (x+w-1 < x1){
    pt[0].x = x1;
    pt[0].y = y1;
    pt[1].x = x1;
    pt[1].y = y2;
    return 1;
  }
  if (y2 < y){
    pt[0].x = x1;
    pt[0].y = y1;
    pt[1].x = x1;
    pt[1].y = y2;
    return 1;
  }
  if (y+h-1 < y1){
    pt[0].x = x1;
    pt[0].y = y1;
    pt[1].x = x1;
    pt[1].y = y2;
    return 1;
  }
  if (y1 < y){
    pt[0].x = x1;
    pt[0].y = y1;
    if (y2 > y + h-1){
      pt[1].x = x1;
      pt[1].y = y-1;
      pt[2].x = x1;;
      pt[2].y = y+h;
      pt[3].x = x1;
      pt[3].y = y2;
      return 2;
    }else{
      pt[1].x = x1;
      pt[1].y = y-1;
      return 1;
    }
  }
  if (y2 > y + h -1){
    pt[0].x = x1;
    pt[0].y = y+h;
    pt[1].x = x1;
    pt[1].y = y2;
    return 1;
  }
  return 0;
}
inline int _check_visible_region(int gid,long* x,long* y,unsigned long* w,unsigned long* h){
  int num = _gc_list[gid-1]._visible_region_list_num;
  if (num > 0){
    WSCrect* vis_list = _gc_list[gid-1]._visible_region_list;
    int i;
    long x1 = *x;
    long y1 = *y;
    unsigned long w1 = *w;
    unsigned long h1 = *h;
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)&vis_list[i];
      if (WSMFandArea(x1,y1,w1,h1,r->x,r->y,r->width,r->height,&x1,&y1,&w1,&h1) == WS_ERR){
        return 0;
      }
//printf("region r-x,y,w,h=%d,%d,%d,%d\n",r->x,r->y,r->width,r->height);
//      if (w1 == 0 || h1 == 0){
//        return 0;
//      }
    }
    *x = x1;
    *y = y1;
    *w = w1;
    *h = h1;
    return 1;
  }
  return 1;
}
inline int _check_raw_line(int gid,short x1,short y1,short x2,short y2,
                    WSCpoint* pt1,WSCpoint* pt2,int pt_num){

  int num = _gc_list[gid-1]._visible_region_list_num;
  if (num > 0){
    WSCrect* vis_list = _gc_list[gid-1]._visible_region_list;
    int i;
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)&vis_list[i];
//      if (r == NULL){
//        break;
//      }
      if (!_get_line_in_rect(&x1,&y1,&x2,&y2,r->x,r->y,r->width,r->height)){
        return 0;
      }
    }
  }
  WSCrect* ex_list = _gc_list[gid-1]._ex_region_list;
  long ret_num = 1;
  pt1[0].x = x1; 
  pt1[0].y = y1; 
  pt2[0].x = x2; 
  pt2[0].y = y2; 

  if (ex_list != NULL){
    num = _gc_list[gid-1]._ex_region_list_num;
    int i;
    int j;
    WSCpoint pt1_new[pt_num];
    WSCpoint pt2_new[pt_num];
    WSCpoint pt[4];
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)&ex_list[i];
//      if (r == NULL){
//        break;
//      }
      int c = 0;
      for(j=0; j<ret_num; j++){
        int lnum = _get_line_outof_rect(pt1[j].x,pt1[j].y,pt2[j].x,pt2[j].y,
                                        r->x,r->y,r->width,r->height,pt);
//printf("_get_line_outof_rect lnum=%d\n",lnum);
        if (lnum > 0){
//printf("_get_line_outof_rect pt1=%d,%d-%d,%d\n",pt[0].x,pt[0].y,pt[1].x,pt[1].y);
          pt1_new[c].x = pt[0].x; 
          pt1_new[c].y = pt[0].y; 
          pt2_new[c].x = pt[1].x; 
          pt2_new[c].y = pt[1].y; 
          c++;
        }
        if (lnum > 1){
//printf("_get_line_outof_rect pt2=%d,%d-%d,%d\n",pt[2].x,pt[2].y,pt[3].x,pt[3].y);
          pt1_new[c].x = pt[2].x; 
          pt1_new[c].y = pt[2].y; 
          pt2_new[c].x = pt[3].x; 
          pt2_new[c].y = pt[3].y; 
          c++;
        }
        if (c > pt_num-1){
          break;
        }
      }
      memcpy(pt1,pt1_new,sizeof(WSCpoint)*c);
      memcpy(pt2,pt2_new,sizeof(WSCpoint)*c);
      ret_num = c;
      if (ret_num == 0){
//printf("return 0;\n");
        return 0;
      }
    }
    return ret_num;
  }

  return 1;
}

int _check_raw_hline(int gid,short x1,short y1,short x2,
                    WSCpoint* pt1,WSCpoint* pt2,int pt_num,WSCbool check_vis){
  if (_gc_list[gid-1]._buf == NULL){
#ifdef ROTATE90
    if (!_get_hline_in_rect(&x1,&y1,&x2,0,0,_device_height,_device_width)){
      return 0;
    }
#else
    if (!_get_hline_in_rect(&x1,&y1,&x2,0,0,_device_width,_device_height)){
      return 0;
    }
#endif
  }
  if (check_vis != False){
    int num = _gc_list[gid-1]._visible_region_list_num;
    if (num > 0){
      WSCrect* vis_list = _gc_list[gid-1]._visible_region_list;
      int i;
      for(i=0; i<num; i++){
        WSCrect* r = (WSCrect*)&vis_list[i];
        if (!_get_hline_in_rect(&x1,&y1,&x2,r->x,r->y,r->width,r->height)){
          return 0;
        }
      }
    }
  }

  WSCrect* ex_list = _gc_list[gid-1]._ex_region_list;
  long ret_num = 1;
  pt1[0].x = x1; 
  pt1[0].y = y1; 
  pt2[0].x = x2; 
  pt2[0].y = y1; 

//printf("_get_line_outof_rect ex=0x%x\n",ex_list);
  if (ex_list != NULL){
    int num = _gc_list[gid-1]._ex_region_list_num;
    int i;
    int j;
    WSCpoint pt1_new[pt_num];
    WSCpoint pt2_new[pt_num];
    WSCpoint pt[4];
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)&ex_list[i];
      int c = 0;
      for(j=0; j<ret_num; j++){
        int lnum = _get_hline_outof_rect(pt1[j].x,pt1[j].y,pt2[j].x,
                                        r->x,r->y,r->width,r->height,pt);
//printf("_get_line_outof_rect lnum=%d\n",lnum);
        if (lnum > 0){
//printf("_get_line_outof_rect pt1=%d,%d-%d,%d\n",pt[0].x,pt[0].y,pt[1].x,pt[1].y);
          pt1_new[c].x = pt[0].x; 
          pt1_new[c].y = pt[0].y; 
          pt2_new[c].x = pt[1].x; 
          pt2_new[c].y = pt[1].y; 
          c++;
        }
        if (lnum > 1){
//printf("_get_line_outof_rect pt2=%d,%d-%d,%d\n",pt[2].x,pt[2].y,pt[3].x,pt[3].y);
          pt1_new[c].x = pt[2].x; 
          pt1_new[c].y = pt[2].y; 
          pt2_new[c].x = pt[3].x; 
          pt2_new[c].y = pt[3].y; 
          c++;
        }
        if (c > pt_num-1){
          break;
        }
      }
      memcpy(pt1,pt1_new,sizeof(WSCpoint)*c);
      memcpy(pt2,pt2_new,sizeof(WSCpoint)*c);
      ret_num = c;
      if (ret_num == 0){
//printf("return 0;\n");
        return 0;
      }
    }
    return ret_num;
  }

  return 1;
}

int _check_raw_vline(int gid,short x1,short y1,short y2,
                    WSCpoint* pt1,WSCpoint* pt2,int pt_num,WSCbool check_vis){
  if (_gc_list[gid-1]._buf == NULL){
#ifdef ROTATE90
    if (!_get_vline_in_rect(&x1,&y1,&y2,0,0,_device_height,_device_width)){
      return 0;
    }
#else
    if (!_get_vline_in_rect(&x1,&y1,&y2,0,0,_device_width,_device_height)){
      return 0;
    }
#endif
  }
  int num = _gc_list[gid-1]._visible_region_list_num;
  if (check_vis != False && num > 0){
    WSCrect* vis_list = _gc_list[gid-1]._visible_region_list;
    int i;
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)&vis_list[i];
      if (!_get_vline_in_rect(&x1,&y1,&y2,r->x,r->y,r->width,r->height)){
        return 0;
      }
    }
  }

  WSCrect* ex_list = _gc_list[gid-1]._ex_region_list;
  long ret_num = 1;
  pt1[0].x = x1; 
  pt1[0].y = y1; 
  pt2[0].x = x1; 
  pt2[0].y = y2; 

  if (ex_list != NULL){
    num = _gc_list[gid-1]._ex_region_list_num;
    int i;
    int j;
    WSCpoint pt1_new[pt_num];
    WSCpoint pt2_new[pt_num];
    WSCpoint pt[4];
    for(i=0; i<num; i++){
      WSCrect* r = (WSCrect*)&ex_list[i];
      int c = 0;
      for(j=0; j<ret_num; j++){
        int lnum = _get_vline_outof_rect(pt1[j].x,pt1[j].y,pt2[j].y,
                                        r->x,r->y,r->width,r->height,pt);
        if (lnum > 0){
          pt1_new[c].x = pt[0].x; 
          pt1_new[c].y = pt[0].y; 
          pt2_new[c].x = pt[1].x; 
          pt2_new[c].y = pt[1].y; 
          c++;
        }
        if (lnum > 1){
          pt1_new[c].x = pt[2].x; 
          pt1_new[c].y = pt[2].y; 
          pt2_new[c].x = pt[3].x; 
          pt2_new[c].y = pt[3].y; 
          c++;
        }
        if (c > pt_num-1){
          break;
        }
      }
      memcpy(pt1,pt1_new,sizeof(WSCpoint)*c);
      memcpy(pt2,pt2_new,sizeof(WSCpoint)*c);
      ret_num = c;
      if (ret_num == 0){
        return 0;
      }
    }
    return ret_num;
  }
  return 1;
}


#endif
int _draw_raw_point32(int gid,short x,short y,unsigned int val,unsigned char* buf,int row_bytes){
  int ptr = (int)(row_bytes * y + x*4);
  unsigned int* bf = (unsigned int*)&buf[ptr];
  *bf = (unsigned int)val;
  return WS_NO_ERR;
}


int _draw_raw_point24(int gid,short x,short y,unsigned int val,unsigned char* buf,int row_bytes){
  int ptr = (int)(row_bytes * y + x*3);
  unsigned char* bf = (unsigned char*)&buf[ptr];
  *bf++ = (unsigned char)((val>>16) & 0xff);
  *bf++ = (unsigned char)((val>>8) & 0xff);
  *bf++ = (unsigned char)((val) & 0xff);
  return WS_NO_ERR;
}

int _draw_raw_point16(int gid,short x,short y,unsigned int val,unsigned char* buf,int row_bytes){
  int ptr = (int)(row_bytes * y + x*2);
  unsigned short* bf = (unsigned short*)&buf[ptr];
  *bf = (unsigned short)val;
  return WS_NO_ERR;
}

int _draw_raw_point8(int gid,short x,short y,unsigned int val,unsigned char* buf,int row_bytes){
  int ptr = (int)(row_bytes * y + x);
  unsigned char* bf = (unsigned char*)&buf[ptr];
  *bf = (unsigned char)val;
  return WS_NO_ERR;
}
inline void* _get_draw_raw_point_proc(int gid){
  int depth = _gc_list[gid-1]._depth;
  if (depth == 32){
    return (void*)_draw_raw_point32;
  }else
  if (depth == 24){
    return (void*)_draw_raw_point24;
  }else
  if (depth == 16){
    return (void*)_draw_raw_point16;
  }
  return (void*)_draw_raw_point8;
}
inline int _draw_raw_point(int gid,short x,short y,unsigned int val){
  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf = gcptr->_buf;
  int depth = gcptr->_depth;
  int row_bytes = gcptr->_row_bytes;
  int bytes = depth/8;

  if (buf == NULL){
    buf = _buffer;
  }
  int ptr = (int)(row_bytes * y + x*bytes);
  if (depth == 32){
    unsigned int* bf = (unsigned int*)&buf[ptr];
    *bf = (unsigned int)val;
  }else if (depth == 24){
    unsigned char* bf = (unsigned char*)&buf[ptr];
    *bf++ = (unsigned char)((val>>16) & 0xff);
    *bf++ = (unsigned char)((val>>8) & 0xff);
    *bf++ = (unsigned char)((val) & 0xff);
  }else if (depth == 16){
    unsigned short* bf = (unsigned short*)&buf[ptr];
    *bf = (unsigned short)val;
  }else if (depth == 8){
    unsigned char* bf = (unsigned char*)&buf[ptr];
    *bf = (unsigned char)val;
  }else{
    return WS_ERR;
  }
  return WS_NO_ERR;
}

inline unsigned int _get_col_alpha(int gid,unsigned int fg){
//printf("_get_col_alpha=0x%x\n",(fg & 0xff000000)>>24);
  return (fg >> 24) & 0xff;
}
#if 0
int _get_col_rgb(int gid,unsigned int fg,unsigned char* r,unsigned char* g,unsigned char* b){
  *r = fg >> 16;
  *g = fg >> 8;
  *b = fg;
  return WS_NO_ERR;
}
#endif
inline int _draw_point(int gid,short x,short y,unsigned char r2,
                                               unsigned char g2,
                                               unsigned char b2,
                                               unsigned char alpha){
  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf =       gcptr->_buf;
  unsigned int depth =       gcptr->_depth;
  unsigned int start_red =   gcptr->_start_red;
  unsigned int start_green = gcptr->_start_green;
  unsigned int start_blue =  gcptr->_start_blue;
  unsigned int red_bits =    gcptr->_red_bits;
  unsigned int green_bits =  gcptr->_green_bits;
  unsigned int blue_bits =   gcptr->_blue_bits;
  unsigned int row_bytes =   gcptr->_row_bytes;

  unsigned char r,g,b;

  if (buf == NULL){
    buf = _buffer;
  }

  if (depth == 32){
    unsigned int val = 0;
    unsigned int* ptr = (unsigned int*)&buf[y*row_bytes + x*depth/8];
    val = *ptr;
    r = (val >> start_red) << (8 -red_bits);
    g = (val >> start_green) << (8 -green_bits);
    b = (val >> start_blue) << (8 -blue_bits);
    r = (r*(256 - alpha) + r2*alpha)/256;
    g = (g*(256 - alpha) + g2*alpha)/256;
    b = (b*(256 - alpha) + b2*alpha)/256;
    *ptr = ((r >> (8-red_bits)) << start_red)|
           ((g >> (8-green_bits)) << start_green)|
           ((b >> (8-blue_bits)) << start_blue);
  }else
  if (depth == 24){
    unsigned char val = 0;
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned char)(*ptr << 16);
    ptr++;
    val |= (unsigned char)(*ptr << 8);
    ptr++;
    val |= (unsigned char)(*ptr);
    r = (val >> start_red) << (8 -red_bits);
    g = (val >> start_green) << (8 -green_bits);
    b = (val >> start_blue) << (8 -blue_bits);
    r = (r*(256 - alpha) + r2*alpha)/256;
    g = (g*(256 - alpha) + g2*alpha)/256;
    b = (b*(256 - alpha) + b2*alpha)/256;
    *ptr = ((r >> (8-red_bits)) << start_red)|
           ((g >> (8-green_bits)) << start_green)|
           ((b >> (8-blue_bits)) << start_blue);
//printf("_get_rgb() need implement..\n");
//    long ptr = y*row_bytes + x*depth/8;
//    val = buf[ptr] << 16 | buf[ptr+1] << 8 | buf[ptr+2];
  }else
  if (depth == 16){
    unsigned short val = 0;
    unsigned short* ptr = (unsigned short*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned short)*ptr;
    r = (val >> start_red) << (8 -red_bits);
    g = (val >> start_green) << (8 -green_bits);
    b = (val >> start_blue) << (8 -blue_bits);
//printf("ptr=0x%x val=0x%x r,g,b=%d,%d,%d\n",ptr,val,r,g,b);
    r = (r*(256 - alpha) + r2*alpha)/256;
    g = (g*(256 - alpha) + g2*alpha)/256;
    b = (b*(256 - alpha) + b2*alpha)/256;
    *ptr = ((r >> (8-red_bits)) << start_red)|
           ((g >> (8-green_bits)) << start_green)|
           ((b >> (8-blue_bits)) << start_blue);
  }else{
    unsigned char val = 0;
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned char)*ptr;
    r = (val >> start_red) << (8 -red_bits);
    g = (val >> start_green) << (8 -green_bits);
    b = (val >> start_blue) << (8 -blue_bits);
    r = (r*(256 - alpha) + r2*alpha)/256;
    g = (g*(256 - alpha) + g2*alpha)/256;
    b = (b*(256 - alpha) + b2*alpha)/256;
    *ptr = ((r >> (8-red_bits)) << start_red)|
           ((g >> (8-green_bits)) << start_green)|
           ((b >> (8-blue_bits)) << start_blue);
  }
  return WS_NO_ERR;
}

int _draw_raw_hline32(int gid,short x,short y,unsigned int w,unsigned int val){
  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf = gcptr->_buf;
  int depth = gcptr->_depth;
  int row_bytes = gcptr->_row_bytes;
  int bytes = depth/8;
  if (buf == NULL){
    buf = _buffer;
  }
#ifdef ROTATE90
  if (buf == _buffer){
      int i;
      int dx,dy;
      for(i = x; i < x + w; i++){
        dx = y;
        dy = _device_height - i-1;
        unsigned int* ptr = (unsigned int*)&buf[dy*row_bytes + dx*bytes];
        *ptr = (unsigned int)val;
      }
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
      unsigned int* ptr = (unsigned int*)&buf[y*2*row_bytes + x*2*bytes];
      unsigned int* ptr2 = (unsigned int*)&buf[(y*2+1)*row_bytes + x*2*bytes];
      unsigned int i;
      for(i=0; i<w;i++){
        *ptr++ = (unsigned int)val;
        *ptr++ = (unsigned int)val;
        *ptr2++ = (unsigned int)val;
        *ptr2++ = (unsigned int)val;
      }
    return WS_NO_ERR;
  }
#endif
  int ptr = (int)(row_bytes * y + x*bytes);
  register unsigned int i;
  register unsigned int* bf = (unsigned int*)&buf[ptr];
  register unsigned int val2 = (unsigned int)val;
  register unsigned int* bf2 = (unsigned int*)&buf[ptr+w*4];
  do{
    *bf++ = val2;
  } while(bf < bf2);
  return WS_NO_ERR;
}


int _draw_raw_hline24(int gid,short x,short y,unsigned int w,unsigned int val){
  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf = gcptr->_buf;
  int depth = gcptr->_depth;
  int row_bytes = gcptr->_row_bytes;
  int bytes = depth/8;
  if (buf == NULL){
    buf = _buffer;
  }
#ifdef ROTATE90
  if (buf == _buffer){
printf("ROTATE90 mode not supported.. %s:%d\n",__FILE__,__LINE__);
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
printf("DOUBLE_SCALE mode not supported.. %s:%d\n",__FILE__,__LINE__);
    return WS_NO_ERR;
  }
#endif
  int ptr = (int)(row_bytes * y + x*bytes);
  register unsigned int i;
  register unsigned char* bf = (unsigned char*)&buf[ptr];
  register unsigned char val1 = (unsigned char)(val >> 16);
  register unsigned char val2 = (unsigned char)(val >> 8) & 0xff;
  register unsigned char val3 = (unsigned char)(val ) & 0xff;
  for(i=0; i<w; i++){
    *bf++ = val1;
    *bf++ = val2;
    *bf++ = val3;
  }
  return WS_NO_ERR;
}

int _draw_raw_hline16(int gid,short x,short y,unsigned int w,unsigned int val){
  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf = gcptr->_buf;
  int depth = gcptr->_depth;
  int row_bytes = gcptr->_row_bytes;
  int bytes = depth/8;
  if (buf == NULL){
    buf = _buffer;
  }
//printf("_draw_raw_hline gid=%d x,y,w=%d,%d,%d val=0x%x\n",gid,x,y,w,val);
#ifdef ROTATE90
  if (buf == _buffer){
    int i;
    int dx,dy;
    for(i = x; i < x + w; i++){
      dx = y;
      dy = _device_height - i;
      unsigned short* ptr = (unsigned short*)&buf[dy*row_bytes + dx*bytes];
      *ptr = (unsigned short)val;
    }
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    unsigned short* ptr = (unsigned short*)&buf[y*2*row_bytes + x*2*bytes];
    unsigned short* ptr2 = (unsigned short*)&buf[(y*2+1)*row_bytes + x*2*bytes];
    unsigned int i;
    for(i=0; i<w;i++){
      *ptr++ = (unsigned short)val;
      *ptr++ = (unsigned short)val;
      *ptr2++ = (unsigned short)val;
      *ptr2++ = (unsigned short)val;
    }
    return WS_NO_ERR;
  }
#endif
  int ptr = (int)(row_bytes * y + x*bytes);
  register unsigned int i;
    if (w < 16){
      register unsigned short* bf = (unsigned short*)&buf[ptr];
      register unsigned short val2 = (unsigned short)val;
      register unsigned short* bf2 = (unsigned short*)&buf[ptr+w*2];
      do{
        *bf++ = val2;
      } while(bf < bf2);
      return WS_NO_ERR;
    }else{
      register unsigned int* bf = (unsigned int*)&buf[ptr];
      register unsigned int val2 = (unsigned int)(val & 0xffff);
      register unsigned int* bf2 = (unsigned int*)&buf[(ptr+w*2)& 0xfffffffd];
      val2 |= (val2 << 16);
      unsigned short val3 = (unsigned short)val;
      if (ptr % 4){
        *(unsigned short*)&buf[ptr] = val3;
        bf = (unsigned int*)&buf[(ptr/4+1)*4];
      }
      unsigned int diff = (unsigned int)bf2 - (unsigned int)bf;
      int num = (diff >> 5)-1;
      if (num > 0){
        do{
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          num--;
        } while(num);
      }
      diff = (unsigned int)bf2 - (unsigned int)bf;
      num = (diff >> 4) -1;
      if (num >0){
        do{
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          num--;
        } while(num);
      }

      do{
        *bf++ = val2;
      } while(bf < bf2);
 
      if ((ptr + w*2) % 4){
        *(unsigned short*)bf2 = val3;
      }
    }
#if 0
//  if (w < 16){
  if (w < 8){
    register unsigned short* bf = (unsigned short*)&buf[ptr];
    register unsigned short val2 = (unsigned short)val;
    register unsigned short* bf2 = (unsigned short*)&buf[ptr+w*2];
    do{
      *bf++ = val2;
    } while(bf < bf2);
    return WS_NO_ERR;
  }
  register unsigned int* bf = (unsigned int*)&buf[ptr];
  register unsigned int val2 = (unsigned int)(val & 0xffff);
  register unsigned int* bf2 = (unsigned int*)&buf[(ptr+w*2) & 0xfffffffd];
  val2 |= (val2 << 16);
  unsigned short val3 = (unsigned short)val;
  if (ptr % 4){
    *(unsigned short*)&buf[ptr] = val3;
    bf = (unsigned int*)&buf[(ptr/4+1)*4];
  }
  do{
    *bf++ = val2;
  } while(bf < bf2);

  if ((ptr + w*2) % 4){
    *((unsigned short*)bf2) = val3;
  }
#endif
  return WS_NO_ERR;
}


int _draw_raw_hline8(int gid,short x,short y,unsigned int w,unsigned int val){
  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf = gcptr->_buf;
  int depth = gcptr->_depth;
  int row_bytes = gcptr->_row_bytes;
  int bytes = depth/8;
  if (buf == NULL){
    buf = _buffer;
  }
#ifdef ROTATE90
  if (buf == _buffer){
    int i;
    int dx,dy;
    for(i = x; i < x + w; i++){
      dx = y;
      dy = _device_height - i;
      unsigned char* ptr = (unsigned char*)&buf[dy*row_bytes + dx*bytes];
      *ptr = (unsigned char)val;
    }
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    unsigned char* ptr = (unsigned char*)&buf[y*2*row_bytes + x*2*bytes];
    unsigned char* ptr2 = (unsigned char*)&buf[(y*2+1)*row_bytes + x*2*bytes];
    unsigned int i;
    for(i=0; i<w;i++){
      *ptr++ = (unsigned char)val;
      *ptr++ = (unsigned char)val;
      *ptr2++ = (unsigned char)val;
      *ptr2++ = (unsigned char)val;
    }
    return WS_NO_ERR;
  }
#endif
  int ptr = (int)(row_bytes * y + x*bytes);
  unsigned char* bf = (unsigned char*)&buf[ptr];
  memset(bf,val,w);
  return WS_NO_ERR;
}

inline int _draw_raw_hline(int gid,short x,short y,unsigned int w,unsigned int val,unsigned char* buf,int depth,int row_bytes,int bytes){
#ifdef ROTATE90
  if (buf == _buffer){
    if (depth == 32){
      int i;
      int dx,dy;
      for(i = x; i < x + w; i++){
        dx = y;
        dy = _device_height - i-1;
        unsigned int* ptr = (unsigned int*)&buf[dy*row_bytes + dx*bytes];
        *ptr = (unsigned int)val;
      }
    }else
    if (depth == 16){
      int i;
      int dx,dy;
      for(i = x; i < x + w; i++){
        dx = y;
        dy = _device_height - i;
        unsigned short* ptr = (unsigned short*)&buf[dy*row_bytes + dx*bytes];
        *ptr = (unsigned short)val;
      }
    }else
    if (depth == 8){
      int i;
      int dx,dy;
      for(i = x; i < x + w; i++){
        dx = y;
        dy = _device_height - i;
        unsigned char* ptr = (unsigned char*)&buf[dy*row_bytes + dx*bytes];
        *ptr = (unsigned char)val;
      }
    }else{
      return WS_ERR;
    }
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&buf[y*2*row_bytes + x*2*bytes];
      unsigned int* ptr2 = (unsigned int*)&buf[(y*2+1)*row_bytes + x*2*bytes];
      unsigned int i;
      for(i=0; i<w;i++){
        *ptr++ = (unsigned int)val;
        *ptr++ = (unsigned int)val;
        *ptr2++ = (unsigned int)val;
        *ptr2++ = (unsigned int)val;
      }
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&buf[y*2*row_bytes + x*2*bytes];
      unsigned short* ptr2 = (unsigned short*)&buf[(y*2+1)*row_bytes + x*2*bytes];
      unsigned int i;
      for(i=0; i<w;i++){
        *ptr++ = (unsigned short)val;
        *ptr++ = (unsigned short)val;
        *ptr2++ = (unsigned short)val;
        *ptr2++ = (unsigned short)val;
      }
    }else
    if (depth == 8){
      unsigned char* ptr = (unsigned char*)&buf[y*2*row_bytes + x*2*bytes];
      unsigned char* ptr2 = (unsigned char*)&buf[(y*2+1)*row_bytes + x*2*bytes];
      unsigned int i;
      for(i=0; i<w;i++){
        *ptr++ = (unsigned char)val;
        *ptr++ = (unsigned char)val;
        *ptr2++ = (unsigned char)val;
        *ptr2++ = (unsigned char)val;
      }
    }else{
      return WS_ERR;
    }
    return WS_NO_ERR;
  }
#endif
  int ptr = (int)(row_bytes * y + x*bytes);
  register unsigned int i;
  if (depth == 32){
    register unsigned int* bf = (unsigned int*)&buf[ptr];
    register unsigned int val2 = (unsigned int)val;
    register unsigned int* bf2 = (unsigned int*)&buf[ptr+w*4];
    do{
      *bf++ = val2;
    } while(bf < bf2);
#if 0
    for(i=0; i<w; i++){
      *bf++ = val2;
    }
#endif
  }else if (depth == 24){
    register unsigned char* bf = (unsigned char*)&buf[ptr];
    register unsigned char val1 = (unsigned char)(val >> 16);
    register unsigned char val2 = (unsigned char)(val >> 8) & 0xff;
    register unsigned char val3 = (unsigned char)(val ) & 0xff;
    for(i=0; i<w; i++){
      *bf++ = val1;
      *bf++ = val2;
      *bf++ = val3;
    }
  }else if (depth == 16){
    if (w < 8){
      register unsigned short* bf = (unsigned short*)&buf[ptr];
      register unsigned short val2 = (unsigned short)val;
      register unsigned short* bf2 = (unsigned short*)&buf[ptr+w*2];
      do{
        *bf++ = val2;
      } while(bf < bf2);
      return WS_NO_ERR;
    }else{
      register unsigned int* bf = (unsigned int*)&buf[ptr];
      register unsigned int val2 = (unsigned int)(val & 0xffff);
      register unsigned int* bf2 = (unsigned int*)&buf[(ptr+w*2)& 0xfffffffd];
      val2 |= (val2 << 16);
      unsigned short val3 = (unsigned short)val;
      if (ptr % 4){
        *(unsigned short*)&buf[ptr] = val3;
        bf = (unsigned int*)&buf[(ptr/4+1)*4];
      }
      unsigned int diff = (unsigned int)bf2 - (unsigned int)bf;
      int num = (diff >> 5)-1;
      if (num > 0){
        do{
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          num--;
        } while(num);
      }
      diff = (unsigned int)bf2 - (unsigned int)bf;
      num = (diff >> 4) -1;
      if (num >0){
        do{
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          *bf++ = val2;
          num--;
        } while(num);
      }

      do{
        *bf++ = val2;
      } while(bf < bf2);
 
      if ((ptr + w*2) % 4){
        *(unsigned short*)bf2 = val3;
      }
    }
#if 0
    register unsigned int* bf = (unsigned int*)&buf[ptr];
    register unsigned int val2 = (unsigned int)(val & 0xffff);
    register unsigned int* bf2 = (unsigned int*)&buf[(ptr+w*2)& 0xfffffffd];
    val2 |= (val2 << 16);
    unsigned short val3 = (unsigned short)val;
    if (ptr % 4){
      *(unsigned short*)&buf[ptr] = val3;
      bf = (unsigned int*)&buf[(ptr/4+1)*4];
    }
    do{
      *bf++ = val2;
    } while(bf < bf2);

    if ((ptr + w*2) % 4){
      *(unsigned short*)bf2 = val3;
    }
#endif
#if 0
    register unsigned short* bf = (unsigned short*)&buf[ptr];
    register unsigned short val2 = (unsigned short)val;
    for(i=0; i<w; i++){
      *bf++ = val2;
    }
#endif
  }else if (depth == 8){
    unsigned char* bf = (unsigned char*)&buf[ptr];
    memset(bf,val,w);
  }else{
    return WS_ERR;
  }
  return WS_NO_ERR;
}
inline void* _get_draw_raw_hline_proc(int gid){
  int depth = _gc_list[gid-1]._depth;
  if (depth == 32){
    return (void*)_draw_raw_hline32;
  }else
  if (depth == 24){
    return (void*)_draw_raw_hline24;
  }else
  if (depth == 16){
    return (void*)_draw_raw_hline16;
  }
  return (void*)_draw_raw_hline8;
}


inline int _draw_raw_vline(int gid,short x,short y,unsigned int h,unsigned int val,unsigned char* buf,int depth,int row_bytes,int bytes){
#if 0
  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf = gcptr->_buf;
  int depth = gcptr->_depth;
  int row_bytes = gcptr->_row_bytes;
  int bytes = depth/8;
  if (buf == NULL){
    buf = _buffer;
  }
#endif
#ifdef ROTATE90
  if (buf == _buffer){
    if (depth == 32){
      int i;
      int dx,dy;
      for(i = y; i < y + h; i++){
        dx = i;
        dy = _device_height - x-1;
        unsigned int* ptr = (unsigned int*)&buf[dy*row_bytes + dx*bytes];
        *ptr = (unsigned int)val;
      }
    }else
    if (depth == 16){
      int i;
      int dx,dy;
      for(i = y; i < y + h; i++){
        dx = i;
        dy = _device_height - x;
        unsigned short* ptr = (unsigned short*)&buf[dy*row_bytes + dx*bytes];
        *ptr = (unsigned short)val;
      }
    }else
    if (depth == 8){
      int i;
      int dx,dy;
      for(i = y; i < y + h; i++){
        dx = i;
        dy = _device_height - x;
        unsigned char* ptr = (unsigned char*)&buf[dy*row_bytes + dx*bytes];
        *ptr = (unsigned char)val;
      }
    }else{
      return WS_ERR;
    }
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    if (depth == 32){
      int i;
      int dx = x*2*bytes;
      int max = y+h;
      for(i=y; i<(int)max;i++){
        unsigned int* ptr = (unsigned int*)&buf[i*2*row_bytes + dx];
        unsigned int* ptr2 = (unsigned int*)&buf[(i*2+1)*row_bytes + dx];
        *ptr++ = (unsigned int)val;
        *ptr++ = (unsigned int)val;
        *ptr2++ = (unsigned int)val;
        *ptr2++ = (unsigned int)val;
      }
    }else
    if (depth == 16){
      int i;
      int dx = x*2*bytes;
      int max = y+h;
      for(i=y; i<(int)max;i++){
        unsigned short* ptr = (unsigned short*)&buf[i*2*row_bytes + dx];
        unsigned short* ptr2 = (unsigned short*)&buf[(i*2+1)*row_bytes + dx];
        *ptr++ = (unsigned short)val;
        *ptr++ = (unsigned short)val;
        *ptr2++ = (unsigned short)val;
        *ptr2++ = (unsigned short)val;
      }
    }else
    if (depth == 8){
      int i;
      int dx = x*2*bytes;
      int max = y+h;
      for(i=y; i<(int)max;i++){
        unsigned char* ptr = (unsigned char*)&buf[i*2*row_bytes + dx];
        unsigned char* ptr2 = (unsigned char*)&buf[(i*2+1)*row_bytes + dx];
        *ptr++ = (unsigned char)val;
        *ptr++ = (unsigned char)val;
        *ptr2++ = (unsigned char)val;
        *ptr2++ = (unsigned char)val;
      }
    }else{
      return WS_ERR;
    }
    return WS_NO_ERR;
  }
#endif
  int ptr = (int)(row_bytes * y + x*bytes);
  unsigned int i;
  if (depth == 32){
    unsigned int val2 = (unsigned int)val;
    unsigned int* bf;
    for(i=0; i<h; i++){
      *(unsigned int*)&buf[ptr] = val2;
      ptr += row_bytes;
    }
  }else if (depth == 24){
    unsigned char val1 = (unsigned char)(val >> 16);
    unsigned char val2 = (unsigned char)(val >> 8) & 0xff;
    unsigned char val3 = (unsigned char)(val ) & 0xff;
    unsigned char* bf;
    for(i=0; i<h; i++){
      bf = (unsigned char*)&buf[ptr];
      *bf++ = val1;
      *bf++ = val2;
      *bf   = val3;
      ptr += row_bytes;
    }
  }else if (depth == 16){
    unsigned short val2 = (unsigned short)val;
    unsigned short* bf;
    int diff = h /16;
    if (diff > 0){
      for(i=0; i<diff; i++){
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
        *(unsigned short*)&buf[ptr] = val2;
        ptr += row_bytes;
      }
      h = h - i*16;
    }
    for(i=0; i<h; i++){
      bf = (unsigned short*)&buf[ptr];
      *bf = val2;
      ptr += row_bytes;
    }
#if 0
    for(i=0; i<h; i++){
      unsigned short* bf = (unsigned short*)&buf[ptr];
      *bf = val2;
      ptr += row_bytes;
    }
#endif
  }else if (depth == 8){
    unsigned char val2 = (unsigned char)val;
    for(i=0; i<h; i++){
      unsigned char* bf = (unsigned char*)&buf[ptr];
      *bf = val2;
      ptr += row_bytes;
    }
  }else{
    return WS_ERR;
  }
  return WS_NO_ERR;
}



int _draw_raw_vline32(int gid,short x,short y,unsigned int h,unsigned int val){
  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf = gcptr->_buf;
  int depth = gcptr->_depth;
  int row_bytes = gcptr->_row_bytes;
  int bytes = depth/8;
  if (buf == NULL){
    buf = _buffer;
  }
#ifdef ROTATE90
  if (buf == _buffer){
    int i;
    int dx,dy;
    for(i = y; i < y + h; i++){
      dx = i;
      dy = _device_height - x-1;
      unsigned int* ptr = (unsigned int*)&buf[dy*row_bytes + dx*bytes];
      *ptr = (unsigned int)val;
    }
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    int i;
    int dx = x*2*bytes;
    int max = y+h;
    for(i=y; i<(int)max;i++){
      unsigned int* ptr = (unsigned int*)&buf[i*2*row_bytes + dx];
      unsigned int* ptr2 = (unsigned int*)&buf[(i*2+1)*row_bytes + dx];
      *ptr++ = (unsigned int)val;
      *ptr++ = (unsigned int)val;
      *ptr2++ = (unsigned int)val;
      *ptr2++ = (unsigned int)val;
    }
    return WS_NO_ERR;
  }
#endif
  int ptr = (int)(row_bytes * y + x*bytes);
  unsigned int i;
  unsigned int val2 = (unsigned int)val;
  for(i=0; i<h; i++){
    unsigned int* bf = (unsigned int*)&buf[ptr];
    *bf = val2;
    ptr += row_bytes;
  }
  return WS_NO_ERR;
}
int _draw_raw_vline24(int gid,short x,short y,unsigned int h,unsigned int val){
  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf = gcptr->_buf;
  int depth = gcptr->_depth;
  int row_bytes = gcptr->_row_bytes;
  int bytes = depth/8;
  if (buf == NULL){
    buf = _buffer;
  }
#ifdef ROTATE90
  if (buf == _buffer){
printf("ROTATE90 mode not supported.. %s:%d\n",__FILE__,__LINE__);
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
printf("DOUBLE_SCALE mode not supported.. %s:%d\n",__FILE__,__LINE__);
    return WS_NO_ERR;
  }
#endif

  int ptr = (int)(row_bytes * y + x*bytes);
  unsigned int i;
  unsigned char val1 = (unsigned char)(val >> 16);
  unsigned char val2 = (unsigned char)(val >> 8) & 0xff;
  unsigned char val3 = (unsigned char)(val ) & 0xff;
  for(i=0; i<h; i++){
    unsigned char* bf = (unsigned char*)&buf[ptr];
    *bf++ = val1;
    *bf++ = val2;
    *bf   = val3;
    ptr += row_bytes;
  }
  return WS_NO_ERR;
}

int _draw_raw_vline16(int gid,short x,short y,unsigned int h,unsigned int val){
  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf = gcptr->_buf;
  int depth = gcptr->_depth;
  int row_bytes = gcptr->_row_bytes;
  int bytes = depth/8;
  if (buf == NULL){
    buf = _buffer;
  }
#ifdef ROTATE90
  if (buf == _buffer){
    int i;
    int dx,dy;
    for(i = y; i < y + h; i++){
      dx = i;
      dy = _device_height - x;
      unsigned short* ptr = (unsigned short*)&buf[dy*row_bytes + dx*bytes];
      *ptr = (unsigned short)val;
    }
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    int i;
    int dx = x*2*bytes;
    int max = y+h;
    for(i=y; i<(int)max;i++){
      unsigned short* ptr = (unsigned short*)&buf[i*2*row_bytes + dx];
      unsigned short* ptr2 = (unsigned short*)&buf[(i*2+1)*row_bytes + dx];
      *ptr++ = (unsigned short)val;
      *ptr++ = (unsigned short)val;
      *ptr2++ = (unsigned short)val;
      *ptr2++ = (unsigned short)val;
    }
    return WS_NO_ERR;
  }
#endif
  int ptr = (int)(row_bytes * y + x*bytes);
  unsigned int i;
  unsigned short val2 = (unsigned short)val;
  for(i=0; i<h; i++){
    unsigned short* bf = (unsigned short*)&buf[ptr];
    *bf = val2;
    ptr += row_bytes;
  }
  return WS_NO_ERR;
}
int _draw_raw_vline8(int gid,short x,short y,unsigned int h,unsigned int val){
  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf = gcptr->_buf;
  int depth = gcptr->_depth;
  int row_bytes = gcptr->_row_bytes;
  int bytes = depth/8;
  if (buf == NULL){
    buf = _buffer;
  }
#ifdef ROTATE90
  if (buf == _buffer){
    int i;
    int dx,dy;
    for(i = y; i < y + h; i++){
      dx = i;
      dy = _device_height - x;
      unsigned char* ptr = (unsigned char*)&buf[dy*row_bytes + dx*bytes];
      *ptr = (unsigned char)val;
    }
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    int i;
    int dx = x*2*bytes;
    int max = y+h;
    for(i=y; i<(int)max;i++){
      unsigned char* ptr = (unsigned char*)&buf[i*2*row_bytes + dx];
      unsigned char* ptr2 = (unsigned char*)&buf[(i*2+1)*row_bytes + dx];
      *ptr++ = (unsigned char)val;
      *ptr++ = (unsigned char)val;
      *ptr2++ = (unsigned char)val;
      *ptr2++ = (unsigned char)val;
    }
    return WS_NO_ERR;
  }
#endif
  int ptr = (int)(row_bytes * y + x*bytes);
  unsigned int i;
  unsigned char val2 = (unsigned char)val;
  for(i=0; i<h; i++){
    unsigned char* bf = (unsigned char*)&buf[ptr];
    *bf = val2;
    ptr += row_bytes;
  }
  return WS_NO_ERR;
}
void* _get_draw_raw_vline_proc(int gid){
  int depth = _gc_list[gid-1]._depth;
  if (depth == 32){
    return (void*)_draw_raw_vline32;
  }else
  if (depth == 24){
    return (void*)_draw_raw_vline24;
  }else
  if (depth == 16){
    return (void*)_draw_raw_vline16;
  }
  return (void*)_draw_raw_vline8;
}

inline unsigned int _get_col_value(_graphics_context* gcptr,unsigned int fg){
#if 0
  _graphics_context* gcptr = &_gc_list[gid-1];
  int red_shift = gcptr->_start_red;
  int green_shift = gcptr->_start_green;
  int blue_shift = gcptr->_start_blue;

  int red_bits = gcptr->_red_bits;
  int green_bits = gcptr->_green_bits;
  int blue_bits = gcptr->_blue_bits;
  unsigned char red   = (unsigned char)(fg >> 16);
  unsigned char green = (unsigned char)(fg >> 8);
  unsigned char blue  = (unsigned char)fg;
#endif
  unsigned int val = (((unsigned char)(fg>>16) >> (8-gcptr->_red_bits)) << gcptr->_start_red)|
                     (((unsigned char)(fg>>8) >> (8-gcptr->_green_bits)) << gcptr->_start_green)|
                     (((unsigned char)fg >> (8-gcptr->_blue_bits)) << gcptr->_start_blue);
  return val;
}
int _draw_line2_slash(int gid,short x1,short y1,short x2,short y2,unsigned int val,unsigned int fg){
  if (x1 < 0 && x2 < 0){
    return WS_NO_ERR;
  }
  if (y1 < 0 && y2 < 0){
    return WS_NO_ERR;
  }

  _graphics_context* gcptr = &_gc_list[gid-1];
  long gx = gcptr->_x;
  long gy = gcptr->_y;
  unsigned long gw = gcptr->_w;
  unsigned long gh = gcptr->_h;

  long gx2 = gx + gw; 
  long gy2 = gy + gh; 
  long gx3 = gx2 -1;
  long gy3 = gy2 -1;

  int lw = gcptr->_lw;
  if (x1 < x2 && (x2 < gx || (long)(gx3) < (long)x1)){
    return WS_NO_ERR;
  } 
  if (x2 < x1 && (x1 < gx || (long)(gx3) < (long)x2)){
    return WS_NO_ERR;
  } 
  if (y1 < y2 && (y2 < gy || (long)(gy3) < (long)y1)){
    return WS_NO_ERR;
  }
  if (y2 < y1 && (y1 < gy || (long)(gy3) < (long)y2)){
    return WS_NO_ERR;
  }
  if (_check_visible_region(gid,&gx,&gy,&gw,&gh) == False){
    return WS_NO_ERR;
  }
  WSCbool check = True;
  if (gcptr->_ex_region_list == NULL){
    check = False;
  }
  if (x1 < gx || x2 < gx){
    check = True;
  }else
  if ((gx + gw-1) < x1 || (gx + gw-1) < x2){
    check = True;
  }else
  if (y1 < gy || y2 < gy){
    check = True;
  }else
  if ((gy + gh-1) < y1 || (gy + gh-1) < y2){
    check = True;
  }

  int depth = gcptr->_depth;
  int bytes = depth/8;
  int row_bytes = gcptr->_row_bytes;
  unsigned char* buf = gcptr->_buf;
  if (buf == NULL){
    buf = _buffer;
  }

  int diffx1 = x2 - x1; 
  int diffy1 = y2 - y1; 
  int diffx2 = (diffx1 > 0)?diffx1:-diffx1;
  int diffy2 = (diffy1 > 0)?diffy1:-diffy1;

     if (diffx2 > diffy2){
        if (diffx1 < 0){
          long tmp = x1;
          x1 = x2;
          x2 = tmp;
          tmp = y1;
          y1 = y2;
          y2 = tmp;
          diffx1 = -diffx1;
          diffy1 = -diffy1;
        }
        int x;
        if (lw < 2){
          if (check == False){
            if (x1 < gx){
              x1 = gx;
            }
            if (gx3 < x2){
              x2 = gx3;
            }
            int v = y1 - diffy1 * x1 / diffx2;
            register int x;
            register int y;
            register int ptr;
            int delta = diffy1 * FP_BASE / diffx2;

            int mx1 = x1+ diffx1* (gy-y1)/diffy2;
            int mx2 = x1+ diffx1* (gy3-y1)/diffy2;
            if (mx1 < mx2){
              if (x1 < mx1){
                x1 = mx1;
              }
              if (mx2 < x2){
                x2 = mx2;
              }
            }else{
              if (x1 < mx2){
                x1 = mx2;
              }
              if (mx1 < x2){
                x2 = mx1;
              }
            }

            if (depth == 32){
              register unsigned int val2 = (unsigned int)val;
              for(x = x1; x <= x2; x++){
                y = v + delta * x / FP_BASE;
                ptr = (int)(row_bytes * y + x*4);
                *(unsigned int*)&buf[ptr] = val2;
              }
            }else
            if (depth == 24){
              unsigned char val1 = val>>16;
              unsigned char val2 = val>>8;
              unsigned char val3 = val;
              for(x = x1; x <= x2; x++){
                y = v + delta * x / FP_BASE;
                ptr = (int)(row_bytes * y + x*3);
                unsigned char* bf = (unsigned char*)&buf[ptr];
                *bf++ = val1;
                *bf++ = val2;
                *bf = val3;
              }
            }else
            if (depth == 16){
              register unsigned short val2 = (unsigned short)val;
              for(x = x1; x <= x2; x++){
                y = v + delta * x / FP_BASE;
                ptr = (int)(row_bytes * y + x*2);
                *(unsigned short*)&buf[ptr] = val2;
              }
            }else
            if (depth == 8){
              register unsigned char val2 = (unsigned char)val;
              for(x = x1; x <= x2; x++){
                y = v + delta * x / FP_BASE;
                ptr = (int)(row_bytes * y + x);
                *(unsigned char*)&buf[ptr] = val2;
              }
            }
            return WS_NO_ERR;
          }else{
            WSCpoint pt1[WS_MAX_POINTS];
            WSCpoint pt2[WS_MAX_POINTS];
            int num = _check_raw_line(gid,x1,y1,x2,y2,pt1,pt2,WS_MAX_POINTS);
            if (num == 0){
              return WS_NO_ERR;
            }
            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
            int i;
            for(i=0; i<num; i++){
              x1 = pt1[i].x;
              y1 = pt1[i].y;
              x2 = pt2[i].x;
              y2 = pt2[i].y;
              int v = y1 - diffy1 * x1 /diffx2;
              register int y;
              int delta = diffy1 * FP_BASE / diffx2;
              for(x = x1; x <= x2; x++){
                y = v + delta * x / FP_BASE;
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
            }
          }
          return WS_NO_ERR;
        }else
        if (lw == 2){
          if (check == False){
            if (x1 < gx){
              x1 = gx;
            }
            if (gx3 < x2){
              x2 = gx3;
            }
            int v = y1 - diffy1 * x1 /diffx2;
            register int y;
            int delta = diffy1 * FP_BASE / diffx2;
            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
               = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
               _get_draw_raw_point_proc(gid);
            for(x = x1; x <= x2; x++){
              y = v + delta * x / FP_BASE;
              if (gy <= y && y < gy2){
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
              y++;
              if (gy <= y && y < gy2){
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
            }
            return WS_NO_ERR;
          }else{
            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
            WSCpoint pt1[WS_MAX_POINTS];
            WSCpoint pt2[WS_MAX_POINTS];
            int num = _check_raw_line(gid,x1,y1,x2,y2,pt1,pt2,WS_MAX_POINTS);
            num += _check_raw_line(gid,x1,y1+1,x2,y2+1,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
            if ((x1 - x2)*(y1 - y2)< 0){
              num += _check_raw_line(gid,x1+1,y1+1,x2+1,y2+1,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
              if (_check_raw_point(gid,x2+1,y2)){
                _draw_raw_point(gid,x2+1,y2,val,buf,row_bytes);
              }
            }else{
              num += _check_raw_line(gid,x1+1,y1,x2+1,y2,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
              if (_check_raw_point(gid,x2+1,y2+1)){
                _draw_raw_point(gid,x2+1,y2+1,val,buf,row_bytes);
              }
            }
            if (num == 0){
              return WS_NO_ERR;
            }
            int i;
            for(i=0; i<num; i++){
              x1 = pt1[i].x;
              y1 = pt1[i].y;
              x2 = pt2[i].x;
              y2 = pt2[i].y;
              int v = y1 - diffy1 * x1 / diffx2;
              register int y;
              int delta = diffy1 * FP_BASE / diffx2;
              for(x = x1; x <= x2; x++){
                y = v + delta * x / FP_BASE;
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
            }
            return WS_NO_ERR;
          }
        }else if (lw == 3 && check == False){
          if (x1 < gx){
            x1 = gx;
          }
          if (gx3 < x2){
            x2 = gx3;
          }
          int v = y1 - diffy1 * x1 /diffx2;
          register int y;
          int delta = diffy1 * FP_BASE / diffx2;
          int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
               = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
               _get_draw_raw_point_proc(gid);
          for(x = x1; x <= x2; x++){
            y = v + delta * x / FP_BASE;
            if (gy <= y && y < gy2){
              _draw_raw_point(gid,x,y,val,buf,row_bytes);
            }
            y++;
            if (gy <= y && y < gy2){
              _draw_raw_point(gid,x,y,val,buf,row_bytes);
            }
            y-=2;
            if (gy <= y && y < gy2){
              _draw_raw_point(gid,x,y,val,buf,row_bytes);
            }
          }
          return WS_NO_ERR;
        }else{
          long cos_v = (long)(FP_BASE * diffx1 / sqrt(diffx1*diffx1 + diffy1*diffy1));
          long sin_v = (long)(FP_BASE * diffy1 / sqrt(diffx1*diffx1 + diffy1*diffy1));

          WSCpoint pt[4];
          long dy = (lw+1)*cos_v/FP_BASE;
          long dx = (lw+1)*sin_v/FP_BASE;

          long dx2 = dx/2;
          long dy2 = dy/2;
          pt[0].x = -dx2 + x2;
          pt[0].y = -dy2 + y2 + dy;
          pt[1].x = -dx2 + x2 + dx;
          pt[1].y = -dy2 + y2;
          pt[2].x = -dx2 + x1 + dx;
          pt[2].y = -dy2 + y1;
          pt[3].x = -dx2 + x1;
          pt[3].y = -dy2 + y1 + dy;

          _draw_fill_poly(gid,pt,4, fg,False,True);
          return WS_NO_ERR;
        }
        return WS_NO_ERR;
      }else{
        if (diffy1 < 0){
          long tmp = x1;
          x1 = x2;
          x2 = tmp;
          tmp = y1;
          y1 = y2;
          y2 = tmp;
          diffx1 = -diffx1;
          diffy1 = -diffy1;
        }
        int y;
        if (lw < 2){
          if (check == False){
            if (y1 < gy){
              y1 = gy;
            }
            if (gy3 < y2){
              y2 = gy3;
            }
            int v = x1 - diffx1 * y1 / diffy2;
            register int x;
            register int y;
            register int ptr;
            int delta = diffx1 * FP_BASE / diffy2;

            int my1 = y1 + diffy1 * (gx -x1) / diffx2;
            int my2 = y1 + diffy1 * (gx3 -x1) / diffx2;
            if (my1 < my2){
              if (y1 < my1){
                y1 = my1;
              }
              if (my2 < y2){
                y2 = my2;
              }
            }else{
              if (y1 < my2){
                y1 = my2;
              }
              if (my1 < y2){
                y2 = my1;
              }
            }

            if (depth == 32){
              register unsigned int val2 = (unsigned int)val;
              for(y = y1; y <= y2; y++){
                x = v + delta * y / FP_BASE;
                ptr = (int)(row_bytes * y + x*4);
                *(unsigned int*)&buf[ptr] = val2;
              }
            }else
            if (depth == 24){
              unsigned char val1 = val>>16;
              unsigned char val2 = val>>8;
              unsigned char val3 = val;
              for(y = y1; y <= y2; y++){
                x = v + delta * y / FP_BASE;
                ptr = (int)(row_bytes * y + x*3);
                unsigned char* bf = (unsigned char*)&buf[ptr];
                *bf++ = val1;
                *bf++ = val2;
                *bf = val3;
              }
            }else
            if (depth == 16){
              register unsigned short val2 = (unsigned short)val;
              for(y = y1; y <= y2; y++){
                x = v + delta * y / FP_BASE;
                ptr = (int)(row_bytes * y + x*2);
                *(unsigned short*)&buf[ptr] = val2;
              }
            }else
            if (depth == 8){
              register unsigned char val2 = (unsigned char)val;
              for(y = y1; y <= y2; y++){
                x = v + delta * y / FP_BASE;
                ptr = (int)(row_bytes * y + x);
                *(unsigned char*)&buf[ptr] = val2;
              }
            }
            return WS_NO_ERR;
          }else{
            WSCpoint pt1[WS_MAX_POINTS];
            WSCpoint pt2[WS_MAX_POINTS];
            int num = _check_raw_line(gid,x1,y1,x2,y2,pt1,pt2,WS_MAX_POINTS);
            if (num == 0){
              return WS_NO_ERR;
            }

            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
            int i;
            for(i=0; i<num; i++){
              x1 = pt1[i].x;
              y1 = pt1[i].y;
              x2 = pt2[i].x;
              y2 = pt2[i].y;
              if (y2 < y1){
                x1 = pt2[i].x;
                y1 = pt2[i].y;
                x2 = pt1[i].x;
                y2 = pt1[i].y;
              }
              int v = x1- diffx1* y1 / diffy2;
              register int x;
              int delta = diffx1 * FP_BASE / diffy2;
              for(y = y1; y <= y2; y++){
                x = v + delta * y / FP_BASE;
                 _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
            }
          }
        }else
        if (lw == 2){
          if (check == False){
            if (y1 < gy){
              y1 = gy;
            }
            if (gy3 < y2){
              y2 = gy3;
            }
            int v = x1- diffx1* y1 / diffy2;
            register int x;
            int delta = diffx1 * FP_BASE / diffy2;
            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
            for(y = y1; y <= y2; y++){
              x = v + delta * y / FP_BASE;
              if (gx <= x && x < gx2){
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
              x++;
              if (gx <= x && x < gx2){
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
            }
            return WS_NO_ERR;
          }else{
            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
            WSCpoint pt1[WS_MAX_POINTS];
            WSCpoint pt2[WS_MAX_POINTS];
            int num = _check_raw_line(gid,x1,y1,x2,y2,pt1,pt2,WS_MAX_POINTS);
            num += _check_raw_line(gid,x1,y1+1,x2,y2+1,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
            if ((x1 - x2)*(y1 - y2)< 0){
              num += _check_raw_line(gid,x1+1,y1+1,x2+1,y2+1,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
              if (_check_raw_point(gid,x2+1,y2)){
                _draw_raw_point(gid,x2+1,y2,val,buf,row_bytes);
              }
            }else{
              num += _check_raw_line(gid,x1+1,y1,x2+1,y2,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
              if (_check_raw_point(gid,x2+1,y2+1)){
                _draw_raw_point(gid,x2+1,y2+1,val,buf,row_bytes);
              }
            }
            if (num == 0){
              return WS_NO_ERR;
            }
            int i;
            for(i=0; i<num; i++){
              x1 = pt1[i].x;
              y1 = pt1[i].y;
              x2 = pt2[i].x;
              y2 = pt2[i].y;
              if (y2 < y1){
                x1 = pt2[i].x;
                y1 = pt2[i].y;
                x2 = pt1[i].x;
                y2 = pt1[i].y;
              }
              int v = x1 - diffx1 * y1 / diffy2;
              register int x;
              int delta = diffx1 * FP_BASE / diffy2;
              for(y = y1; y <= y2; y++){
                x = v + delta * y / FP_BASE;
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
            }
            return WS_NO_ERR;
          }
   
        }else if (lw == 3 && check == False){
          if (y1 < gy){
            y1 = gy;
          }
          if (gy3 < y2){
            y2 = gy3;
          }
          int v = x1- diffx1* y1 / diffy2;
          register int x;
          int delta = diffx1 * FP_BASE / diffy2;
          int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
          for(y = y1; y <= y2; y++){
            x = v + delta * y / FP_BASE;
            if (gx <= x && x < gx2){
              _draw_raw_point(gid,x,y,val,buf,row_bytes);
            }
            x++;
            if (gx <= x && x < gx2){
              _draw_raw_point(gid,x,y,val,buf,row_bytes);
            }
            x-=2;
            if (gx <= x && x < gx2){
              _draw_raw_point(gid,x,y,val,buf,row_bytes);
            }
          }
          return WS_NO_ERR;
       }else{
          long cos_v = (long)(FP_BASE * diffx1 / sqrt(diffx1*diffx1 + diffy1*diffy1));
          long sin_v = (long)(FP_BASE * diffy1 / sqrt(diffx1*diffx1 + diffy1*diffy1));
          WSCpoint pt[4];
          long dy = (lw+1)*cos_v/FP_BASE;
          long dx = (lw+1)*sin_v/FP_BASE;
          long dx2 = dx/2;
          long dy2 = dy/2;
          pt[0].x = -dx2 + x2;
          pt[0].y = -dy2 + y2 + dy;
          pt[1].x = -dx2 + x2 + dx;
          pt[1].y = -dy2 + y2;
          pt[2].x = -dx2 + x1 + dx;
          pt[2].y = -dy2 + y1;
          pt[3].x = -dx2 + x1;
          pt[3].y = -dy2 + y1 + dy;
          _draw_fill_poly(gid,pt,4, fg,False,True);
          return WS_NO_ERR;
        }
      }
  return WS_NO_ERR;
}
int _draw_line2(int gid,short x1,short y1,short x2,short y2,unsigned int val,unsigned int alpha,unsigned int fg){
  if (x1 < 0 && x2 < 0){
    return WS_NO_ERR;
  }
  if (y1 < 0 && y2 < 0){
    return WS_NO_ERR;
  }
//removed..
//  if (check_gid(gid) != WS_NO_ERR){
//    return WS_ERR_GID;
//  }
  _graphics_context* gcptr = &_gc_list[gid-1];
  long gx = gcptr->_x;
  long gy = gcptr->_y;
  unsigned long gw = gcptr->_w;
  unsigned long gh = gcptr->_h;

  long gx2 = gx + gw; 
  long gy2 = gy + gh; 
  long gx3 = gx + gw-1; 
  long gy3 = gy + gh-1; 

  int lw = gcptr->_lw;
  if (x1 < x2 && (x2 < gx || (long)(gx3) < (long)x1)){
    return WS_NO_ERR;
  } 
  if (x2 < x1 && (x1 < gx || (long)(gx3) < (long)x2)){
    return WS_NO_ERR;
  } 
  if (y1 < y2 && (y2 < gy || (long)(gy3) < (long)y1)){
    return WS_NO_ERR;
  }
  if (y2 < y1 && (y1 < gy || (long)(gy3) < (long)y2)){
    return WS_NO_ERR;
  }

  if (_check_visible_region(gid,&gx,&gy,&gw,&gh) == False){
    return WS_NO_ERR;
  }
  WSCbool check = True;
  if (gcptr->_ex_region_list == NULL){
    check = False;
  }

  if (x1 < gx || x2 < gx){
    check = True;
  }else
  if ((gx + gw-1) < x1 || (gx + gw-1) < x2){
    check = True;
  }else
  if (y1 < gy || y2 < gy){
    check = True;
  }else
  if ((gy + gh-1) < y1 || (gy + gh-1) < y2){
    check = True;
  }

  int depth = gcptr->_depth;
  int bytes = depth/8;
  int row_bytes = gcptr->_row_bytes;
  unsigned char* buf = gcptr->_buf;
  if (buf == NULL){
    buf = _buffer;
  }

  int diffx1 = x2 - x1; 
  int diffy1 = y2 - y1; 
  int diffx2 = (diffx1 > 0)?diffx1:-diffx1;
  int diffy2 = (diffy1 > 0)?diffy1:-diffy1;

  unsigned char r2;
  unsigned char g2;
  unsigned char b2;

  if (alpha != 0xff){
    r2 =  fg >> 16;
    g2 =  fg >> 8;
    b2 =  fg;
  }

  if (y1 != y2 && x1 != x2){
//    int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
//       = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
//         _get_draw_raw_point_proc(gid);

     if (diffx2 > diffy2){
        if (diffx1 < 0){
          long tmp = x1;
          x1 = x2;
          x2 = tmp;
          tmp = y1;
          y1 = y2;
          y2 = tmp;
          diffx1 = -diffx1;
          diffy1 = -diffy1;
        }
        int x;
        if (lw < 2){
          if (check == False){
            if (x1 < gx){
              x1 = gx;
            }
            if (gx3 < x2){
              x2 = gx3;
            }
            int v = y1 - diffy1 * x1 / diffx2;
            register int x;
            register int y;
            register int ptr;
            int delta = diffy1 * FP_BASE / diffx2;

            int mx1 = x1+ diffx1* (gy-y1)/diffy2;
            int mx2 = x1+ diffx1* (gy3-y1)/diffy2;
            if (mx1 < mx2){
              if (x1 < mx1){
                x1 = mx1;
              }
              if (mx2 < x2){
                x2 = mx2;
              }
            }else{
              if (x1 < mx2){
                x1 = mx2;
              }
              if (mx1 < x2){
                x2 = mx1;
              }
            }

            if (alpha == 0xff){
//optimized..
              if (depth == 32){
                register unsigned int val2 = (unsigned int)val;
                for(x = x1; x <= x2; x++){
                  y = v + delta * x / FP_BASE;
//                  if (gy <= y && y < gy2){
                    ptr = (int)(row_bytes * y + x*4);
                    *(unsigned int*)&buf[ptr] = val2;
//                  }
                }
              }else
              if (depth == 24){
                unsigned char val1 = val>>16;
                unsigned char val2 = val>>8;
                unsigned char val3 = val;
                for(x = x1; x <= x2; x++){
                  y = v + delta * x / FP_BASE;
//                  if (gy <= y && y < gy2){
                    ptr = (int)(row_bytes * y + x*3);
                    unsigned char* bf = (unsigned char*)&buf[ptr];
                    *bf++ = val1;
                    *bf++ = val2;
                    *bf = val3;
//                  }
                }
              }else
              if (depth == 16){
                register unsigned short val2 = (unsigned short)val;
                for(x = x1; x <= x2; x++){
                  y = v + delta * x / FP_BASE;
//                  if (gy <= y && y < gy2){
                    ptr = (int)(row_bytes * y + x*2);
                    *(unsigned short*)&buf[ptr] = val2;
//                  }
                }
              }else
              if (depth == 8){
                register unsigned char val2 = (unsigned char)val;
                for(x = x1; x <= x2; x++){
                  y = v + delta * x / FP_BASE;
//                  if (gy <= y && y < gy2){
                    ptr = (int)(row_bytes * y + x);
                    *(unsigned char*)&buf[ptr] = val2;
//                  }
                }
              }
#if 0
              for(x = x1; x <= x2; x++){
//                y = v + diffy1 * x / diffx2;
                y = v + delta * x / FP_BASE;
                if (gy <= y && y < gy2){
                  _draw_raw_point(gid,x,y,val,buf,row_bytes);
                }
              }
#endif
            }else{
//XXZZ
              for(x = x1; x <= x2; x++){
                y = v + delta * x / FP_BASE;
//                int y = (int)(y1+ diffy1* (x-x1)/diffx2);
                if (gy <= y && y < gy2){
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
              }
            }
            return WS_NO_ERR;
          }else{
            WSCpoint pt1[WS_MAX_POINTS];
            WSCpoint pt2[WS_MAX_POINTS];
            int num = _check_raw_line(gid,x1,y1,x2,y2,pt1,pt2,WS_MAX_POINTS);
            if (num == 0){
              return WS_NO_ERR;
            }
            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
            int i;
            for(i=0; i<num; i++){
              x1 = pt1[i].x;
              y1 = pt1[i].y;
              x2 = pt2[i].x;
              y2 = pt2[i].y;
              int v = y1 - diffy1 * x1 /diffx2;
              register int y;
              int delta = diffy1 * FP_BASE / diffx2;
              if (alpha == 0xff){
                for(x = x1; x <= x2; x++){
//                  int y = (int)(y1+ diffy1* (x-x1)/diffx2);
                  y = v + delta * x / FP_BASE;
                  _draw_raw_point(gid,x,y,val,buf,row_bytes);
                }
              }else{
                for(x = x1; x <= x2; x++){
//                  int y = (int)(y1+ diffy1* (x-x1)/diffx2);
                  y = v + delta * x / FP_BASE;
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
              }
            }
          }
          return WS_NO_ERR;
        }else
        if (lw == 2){
          if (check == False){
            if (x1 < gx){
              x1 = gx;
            }
            if (gx3 < x2){
              x2 = gx3;
            }
            int v = y1 - diffy1 * x1 /diffx2;
            register int y;
            int delta = diffy1 * FP_BASE / diffx2;
            if (alpha == 0xff){
              int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
              for(x = x1; x <= x2; x++){
                y = v + delta * x / FP_BASE;
//                int y = (int)(y1+ diffy1* (x-x1)/diffx2);
                if (gy <= y && y < gy2){
                  _draw_raw_point(gid,x,y,val,buf,row_bytes);
                }
                y++;
                if (gy <= y && y < gy2){
                  _draw_raw_point(gid,x,y,val,buf,row_bytes);
                }
              }
            }else{
              for(x = x1; x <= x2; x++){
                y = v + delta * x / FP_BASE;
//                int y = (int)(y1+ diffy1* (x-x1)/diffx2);
                if (gy <= y && y < gy2){
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
                y++;
                if (gy <= y && y < gy2){
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
              }
            }
            return WS_NO_ERR;
          }else{
            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
            WSCpoint pt1[WS_MAX_POINTS];
            WSCpoint pt2[WS_MAX_POINTS];
            int num = _check_raw_line(gid,x1,y1,x2,y2,pt1,pt2,WS_MAX_POINTS);
            num += _check_raw_line(gid,x1,y1+1,x2,y2+1,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
            if ((x1 - x2)*(y1 - y2)< 0){
              num += _check_raw_line(gid,x1+1,y1+1,x2+1,y2+1,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
              if (_check_raw_point(gid,x2+1,y2)){
                _draw_raw_point(gid,x2+1,y2,val,buf,row_bytes);
              }
            }else{
              num += _check_raw_line(gid,x1+1,y1,x2+1,y2,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
              if (_check_raw_point(gid,x2+1,y2+1)){
                _draw_raw_point(gid,x2+1,y2+1,val,buf,row_bytes);
              }
            }
            if (num == 0){
              return WS_NO_ERR;
            }
            int i;
            for(i=0; i<num; i++){
              x1 = pt1[i].x;
              y1 = pt1[i].y;
              x2 = pt2[i].x;
              y2 = pt2[i].y;
              int v = y1 - diffy1 * x1 / diffx2;
              register int y;
              int delta = diffy1 * FP_BASE / diffx2;
              if (alpha == 0xff){
                for(x = x1; x <= x2; x++){
//                  int y = (int)(y1+ diffy1* (x-x1)/diffx2);
                  y = v + delta * x / FP_BASE;
                  _draw_raw_point(gid,x,y,val,buf,row_bytes);
                }
              }else{
                for(x = x1; x <= x2; x++){
//                  int y = (int)(y1+ diffy1* (x-x1)/diffx2);
                  y = v + delta * x / FP_BASE;
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
              }
            }
            return WS_NO_ERR;
          }
 
#if 0
          WSCpoint pt1[WS_MAX_POINTS];
          WSCpoint pt2[WS_MAX_POINTS];
          int num = _check_raw_line(gid,x1,y1,x2,y2,pt1,pt2,WS_MAX_POINTS);
          if (num == 0){
            return WS_NO_ERR;
          }
          int i,j,k;
          long xbk,ybk;
          long px,py;
          for(i=0; i<num; i++){
            x1 = pt1[i].x;
            y1 = pt1[i].y;
            x2 = pt2[i].x;
            y2 = pt2[i].y;
            xbk = -lw;
            ybk = -lw;
            for(x = x1; x <= x2; x++){
              int y = (int)(y1+ diffy1* (x-x1)/diffx2);
              for(j=0; j<lw; j++){
                for(k=0; k<lw; k++){
                  px = x + j;
                  py = y + k;
                  if (xbk <= px && px < lw + xbk &&
                      ybk <= py && py < lw + ybk ){
                    continue;
                  }
                  if (_check_raw_point(gid,px,py)){
                    _draw_raw_point(gid,px,py,val,buf,row_bytes);
                  }
                }
              }
              xbk = x;
              ybk = y;
            }
          }
#endif
        }else if (lw == 3 && check == False){
          if (x1 < gx){
            x1 = gx;
          }
          if (gx3 < x2){
            x2 = gx3;
          }
          int v = y1 - diffy1 * x1 /diffx2;
          register int y;
          int delta = diffy1 * FP_BASE / diffx2;
          if (alpha == 0xff){
            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
            for(x = x1; x <= x2; x++){
//              int y = (int)(y1+ diffy1* (x-x1)/diffx2);
              y = v + delta * x / FP_BASE;
              if (gy <= y && y < gy2){
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
              y++;
              if (gy <= y && y < gy2){
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
              y-=2;
              if (gy <= y && y < gy2){
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
            }
          }else{
            for(x = x1; x <= x2; x++){
//              int y = (int)(y1+ diffy1* (x-x1)/diffx2);
              y = v + delta * x / FP_BASE;
              if (gy <= y && y < gy2){
                _draw_point(gid,x,y,r2,g2,b2,alpha);
              }
              y++;
              if (gy <= y && y < gy2){
                _draw_point(gid,x,y,r2,g2,b2,alpha);
              }
              y-=2;
              if (gy <= y && y < gy2){
                _draw_point(gid,x,y,r2,g2,b2,alpha);
              }
            }
          }
          return WS_NO_ERR;
        }else{
          long cos_v = (long)(FP_BASE * diffx1 / sqrt(diffx1*diffx1 + diffy1*diffy1));
          long sin_v = (long)(FP_BASE * diffy1 / sqrt(diffx1*diffx1 + diffy1*diffy1));

          WSCpoint pt[4];
          long dy = (lw+1)*cos_v/FP_BASE;
          long dx = (lw+1)*sin_v/FP_BASE;

          long dx2 = dx/2;
          long dy2 = dy/2;
          pt[0].x = -dx2 + x2;
          pt[0].y = -dy2 + y2 + dy;
          pt[1].x = -dx2 + x2 + dx;
          pt[1].y = -dy2 + y2;
          pt[2].x = -dx2 + x1 + dx;
          pt[2].y = -dy2 + y1;
          pt[3].x = -dx2 + x1;
          pt[3].y = -dy2 + y1 + dy;

          _draw_fill_poly(gid,pt,4, fg,False,True);
          return WS_NO_ERR;
        }
        return WS_NO_ERR;
      }else{
        if (diffy1 < 0){
          long tmp = x1;
          x1 = x2;
          x2 = tmp;
          tmp = y1;
          y1 = y2;
          y2 = tmp;
          diffx1 = -diffx1;
          diffy1 = -diffy1;
        }
        int y;
        if (lw < 2){
          if (check == False){
            if (y1 < gy){
              y1 = gy;
            }
            if (gy3 < y2){
              y2 = gy3;
            }
            int v = x1 - diffx1 * y1 / diffy2;
            register int x;
            register int y;
            register int ptr;
            int delta = diffx1 * FP_BASE / diffy2;

            int my1 = y1 + diffy1 * (gx -x1) / diffx2;
            int my2 = y1 + diffy1 * (gx3 -x1) / diffx2;
            if (my1 < my2){
              if (y1 < my1){
                y1 = my1;
              }
              if (my2 < y2){
                y2 = my2;
              }
            }else{
              if (y1 < my2){
                y1 = my2;
              }
              if (my1 < y2){
                y2 = my1;
              }
            }


            if (alpha == 0xff){
//optimized..
              if (depth == 32){
                register unsigned int val2 = (unsigned int)val;
                for(y = y1; y <= y2; y++){
                  x = v + delta * y / FP_BASE;
//                  if (gx <= x && x < gx2){
                    ptr = (int)(row_bytes * y + x*4);
                    *(unsigned int*)&buf[ptr] = val2;
//                  }
                }
              }else
              if (depth == 24){
                unsigned char val1 = val>>16;
                unsigned char val2 = val>>8;
                unsigned char val3 = val;
                for(y = y1; y <= y2; y++){
                  x = v + delta * y / FP_BASE;
//                  if (gx <= x && x < gx2){
                    ptr = (int)(row_bytes * y + x*3);
                    unsigned char* bf = (unsigned char*)&buf[ptr];
                    *bf++ = val1;
                    *bf++ = val2;
                    *bf = val3;
//                  }
                }
              }else
              if (depth == 16){
//slow
                register unsigned short val2 = (unsigned short)val;
                for(y = y1; y <= y2; y++){
                  x = v + delta * y / FP_BASE;
//                  if (gx <= x && x < gx2){
                    ptr = (int)(row_bytes * y + x*2);
                    *(unsigned short*)&buf[ptr] = val2;
//                  }
                }
              }else
              if (depth == 8){
                register unsigned char val2 = (unsigned char)val;
                for(y = y1; y <= y2; y++){
                  x = v + delta * y / FP_BASE;
//                  if (gx <= x && x < gx2){
                    ptr = (int)(row_bytes * y + x);
                    *(unsigned char*)&buf[ptr] = val2;
//                  }
                }
              }
              return WS_NO_ERR;

#if 0
              for(y = y1; y <= y2; y++){
//                x = v + diffx1* y / diffy2;
                x = v + delta * y / FP_BASE;
                if (gx <= x && x < gx2){
                  _draw_raw_point(gid,x,y,val,buf,row_bytes);
                }
              }
#endif
            }else{
              for(y = y1; y <= y2; y++){
//                int x = (int)(x1+ diffx1* (y-y1)/diffy2);
                x = v + delta * y / FP_BASE;
                if (gx <= x && x < gx2){
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
              }
              return WS_NO_ERR;
            }
          }else{
            WSCpoint pt1[WS_MAX_POINTS];
            WSCpoint pt2[WS_MAX_POINTS];
            int num = _check_raw_line(gid,x1,y1,x2,y2,pt1,pt2,WS_MAX_POINTS);
            if (num == 0){
              return WS_NO_ERR;
            }
            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
            int i;
            for(i=0; i<num; i++){
              x1 = pt1[i].x;
              y1 = pt1[i].y;
              x2 = pt2[i].x;
              y2 = pt2[i].y;
              if (y2 < y1){
                x1 = pt2[i].x;
                y1 = pt2[i].y;
                x2 = pt1[i].x;
                y2 = pt1[i].y;
              }
              int v = x1- diffx1* y1 / diffy2;
              register int x;
              int delta = diffx1 * FP_BASE / diffy2;
              if (alpha == 0xff){
                for(y = y1; y <= y2; y++){
//                  int x = (int)(x1+ diffx1* (y-y1)/diffy2);
                  x = v + delta * y / FP_BASE;
                   _draw_raw_point(gid,x,y,val,buf,row_bytes);
                }
              }else{
                for(y = y1; y <= y2; y++){
//                  int x = (int)(x1+ diffx1* (y-y1)/diffy2);
                  x = v + delta * y / FP_BASE;
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
              }
            }
          }
        }else
        if (lw == 2){
          if (check == False){
            if (y1 < gy){
              y1 = gy;
            }
            if (gy3 < y2){
              y2 = gy3;
            }
            int v = x1- diffx1* y1 / diffy2;
            register int x;
            int delta = diffx1 * FP_BASE / diffy2;
            if (alpha == 0xff){
              int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
              for(y = y1; y <= y2; y++){
//                int x = (int)(x1+ diffx1* (y-y1)/diffy2);
                x = v + delta * y / FP_BASE;
                if (gx <= x && x < gx2){
                  _draw_raw_point(gid,x,y,val,buf,row_bytes);
                }
                x++;
                if (gx <= x && x < gx2){
                  _draw_raw_point(gid,x,y,val,buf,row_bytes);
                }
              }
            }else{
              for(y = y1; y <= y2; y++){
//                int x = (int)(x1+ diffx1* (y-y1)/diffy2);
                x = v + delta * y / FP_BASE;
                if (gx <= x && x < gx2){
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
                x++;
                if (gx <= x && x < gx2){
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
              }
            }
            return WS_NO_ERR;
          }else{
            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
            WSCpoint pt1[WS_MAX_POINTS];
            WSCpoint pt2[WS_MAX_POINTS];
            int num = _check_raw_line(gid,x1,y1,x2,y2,pt1,pt2,WS_MAX_POINTS);
            num += _check_raw_line(gid,x1,y1+1,x2,y2+1,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
            if ((x1 - x2)*(y1 - y2)< 0){
              num += _check_raw_line(gid,x1+1,y1+1,x2+1,y2+1,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
              if (_check_raw_point(gid,x2+1,y2)){
                _draw_raw_point(gid,x2+1,y2,val,buf,row_bytes);
              }
            }else{
              num += _check_raw_line(gid,x1+1,y1,x2+1,y2,&pt1[num],&pt2[num],WS_MAX_POINTS-num);
              if (_check_raw_point(gid,x2+1,y2+1)){
                _draw_raw_point(gid,x2+1,y2+1,val,buf,row_bytes);
              }
            }
            if (num == 0){
              return WS_NO_ERR;
            }
            int i;
            for(i=0; i<num; i++){
              x1 = pt1[i].x;
              y1 = pt1[i].y;
              x2 = pt2[i].x;
              y2 = pt2[i].y;
              if (y2 < y1){
                x1 = pt2[i].x;
                y1 = pt2[i].y;
                x2 = pt1[i].x;
                y2 = pt1[i].y;
              }
              int v = x1 - diffx1 * y1 / diffy2;
              register int x;
              int delta = diffx1 * FP_BASE / diffy2;
              if (alpha == 0xff){
                for(y = y1; y <= y2; y++){
//                  int x = (int)(x1+ diffx1* (y-y1)/diffy2);
                  x = v + delta * y / FP_BASE;
                  _draw_raw_point(gid,x,y,val,buf,row_bytes);
                }
              }else{
                for(y = y1; y <= y2; y++){
//                  int x = (int)(x1+ diffx1* (y-y1)/diffy2);
                  x = v + delta * y / FP_BASE;
                  _draw_point(gid,x,y,r2,g2,b2,alpha);
                }
              }
            }
            return WS_NO_ERR;
          }
   

#if 0
          WSCpoint pt1[WS_MAX_POINTS];
          WSCpoint pt2[WS_MAX_POINTS];
          int num = _check_raw_line(gid,x1,y1,x2,y2,pt1,pt2,WS_MAX_POINTS);
          if (num == 0){
            return WS_NO_ERR;
          }
          int i,j,k;
          long xbk,ybk;
          long px,py;

          for(i=0; i<num; i++){
            x1 = pt1[i].x;
            y1 = pt1[i].y;
            x2 = pt2[i].x;
            y2 = pt2[i].y;
            xbk = -lw;
            ybk = -lw;
            for(y = y1; y <= y2; y++){
              int x = (int)(x1+ diffx1* (y-y1)/diffy2);
              for(j=0; j<lw; j++){
                for(k=0; k<lw; k++){
                  px = x + j;
                  py = y + k;
                  if (xbk <= px && px < lw + xbk &&
                      ybk <= py && py < lw + ybk){
                    continue;
                  }
                  if (_check_raw_point(gid,x,y)){
                    _draw_raw_point(gid,px,py,val);
                  }
                }
              }
              xbk = x;
              ybk = y;
            }
          }
#endif
        }else if (lw == 3 && check == False){
          if (y1 < gy){
            y1 = gy;
          }
          if (gy3 < y2){
            y2 = gy3;
          }
          int v = x1- diffx1* y1 / diffy2;
          register int x;
          int delta = diffx1 * FP_BASE / diffy2;
          if (alpha == 0xff){
            int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
                 = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
                 _get_draw_raw_point_proc(gid);
            for(y = y1; y <= y2; y++){
//              int x = (int)(x1+ diffx1* (y-y1)/diffy2);
              x = v + delta * y / FP_BASE;
              if (gx <= x && x < gx2){
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
              x++;
              if (gx <= x && x < gx2){
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
              x-=2;
              if (gx <= x && x < gx2){
                _draw_raw_point(gid,x,y,val,buf,row_bytes);
              }
            }
          }else{
            for(y = y1; y <= y2; y++){
//              int x = (int)(x1+ diffx1* (y-y1)/diffy2);
              x = v + delta * y / FP_BASE;
              if (gx <= x && x < gx2){
                _draw_point(gid,x,y,r2,g2,b2,alpha);
              }
              x++;
              if (gx <= x && x < gx2){
                _draw_point(gid,x,y,r2,g2,b2,alpha);
              }
              x-=2;
              if (gx <= x && x < gx2){
                _draw_point(gid,x,y,r2,g2,b2,alpha);
              }
            }
          }
          return WS_NO_ERR;
       }else{
          long cos_v = (long)(FP_BASE * diffx1 / sqrt(diffx1*diffx1 + diffy1*diffy1));
          long sin_v = (long)(FP_BASE * diffy1 / sqrt(diffx1*diffx1 + diffy1*diffy1));
          WSCpoint pt[4];
          long dy = (lw+1)*cos_v/FP_BASE;
          long dx = (lw+1)*sin_v/FP_BASE;
          long dx2 = dx/2;
          long dy2 = dy/2;
          pt[0].x = -dx2 + x2;
          pt[0].y = -dy2 + y2 + dy;
          pt[1].x = -dx2 + x2 + dx;
          pt[1].y = -dy2 + y2;
          pt[2].x = -dx2 + x1 + dx;
          pt[2].y = -dy2 + y1;
          pt[3].x = -dx2 + x1;
          pt[3].y = -dy2 + y1 + dy;
          _draw_fill_poly(gid,pt,4, fg,False,True);
          return WS_NO_ERR;
        }
      }
  }else
  if (y1 == y2){
    if (diffx1 > 0){
    }else{
      long tmp = x1;
      x1 = x2;
      x2 = tmp;
    }
    if (x1 < gx){
      x1 = gx;
    }
    if (gx + gw-1 < x2){
      x2 = gx + gw-1;
    }
    if (alpha == 0xff){
//      int (*_draw_raw_hline)(int gid,short x,short y,unsigned int w,unsigned int val)
//         = (int (*)(int gid,short x,short y,unsigned int w,unsigned int val))
//           _get_draw_raw_hline_proc(gid);
      WSCpoint pt1[WS_MAX_POINTS];
      WSCpoint pt2[WS_MAX_POINTS];
      int num = 1;
      long i,j;
      long v = lw/2;
      for(j=0; j<lw; j++){
        long y = y1 -v +j;
        num = _check_raw_hline(gid,x1,y,x2,pt1,pt2,WS_MAX_POINTS,check);
        if (num == 0){
          continue;
        }
        for(i=0; i<num; i++){
          _draw_raw_hline(gid,pt1[i].x,pt1[i].y,pt2[i].x -pt1[i].x+1,val,buf,depth,row_bytes,bytes);
//          _draw_raw_hline(gid,pt1[i].x,pt1[i].y,pt2[i].x -pt1[i].x+1,val);
        }
      }
      return WS_NO_ERR;
    }

    int x;
    if (lw < 2){
      if (_get_hline_in_rect(&x1,&y1,&x2,gx,gy,gw,gh) == False){
        return WS_NO_ERR;
      }
      if (gy < y1 && y1 < gy2){
        for(x = x1; x <= x2; x++){
          if (check == False || _check_raw_point_ex_only(gid,x,y1)){
            _draw_point(gid,x,y1,r2,g2,b2,alpha);
           }
        }
      }
    }else{
      int lw2 = lw/2;
      int y;
      for(y = 0; y < lw; y++){
        short yy = y - lw2 + y1;
        if (gy < yy && yy < gy2){
          if (_get_hline_in_rect(&x1,&yy,&x2,gx,gy,gw,gh) == False){
            continue;
          }
          for(x = x1; x <= x2; x++){
            if (check == False || _check_raw_point(gid,x,yy)){
              _draw_point(gid,x,yy,r2,g2,b2,alpha);
            }
          }
        }
      }
    }
  }else
  if (x1 == x2){
    if (diffy1 > 0){
    }else{
      long tmp = y1;
      y1 = y2;
      y2 = tmp;
    }

    if (y1 < gy){
      y1 = gy;
    }
    if (gy + gh-1 < y2){
      y2 = gy + gh-1;
    }

    if (alpha == 0xff){
//      int (*_draw_raw_vline)(int gid,short x,short y,unsigned int h,unsigned int val)
//         = (int (*)(int gid,short x,short y,unsigned int h,unsigned int val))
//           _get_draw_raw_vline_proc(gid);
      WSCpoint pt1[WS_MAX_POINTS];
      WSCpoint pt2[WS_MAX_POINTS];
      int num = 1;
      long i,j;
      long v = lw/2;
      for(j=0; j<lw; j++){
        long x = x1 -v +j;
        num = _check_raw_vline(gid,x,y1,y2,pt1,pt2,WS_MAX_POINTS,check);
        if (num == 0){
          continue;
        }
        for(i=0; i<num; i++){
          _draw_raw_vline(gid,pt1[i].x,pt1[i].y,pt2[i].y -pt1[i].y+1,val,buf,depth,row_bytes,bytes);
//          _draw_raw_vline(gid,pt1[i].x,pt1[i].y,pt2[i].y -pt1[i].y+1,val);
        }
      }
      return WS_NO_ERR;
    }

    int y;
    if (lw < 2){
      if (_get_vline_in_rect(&x1,&y1,&y2,gx,gy,gw,gh) == False){
        return WS_NO_ERR;
      }

      if (gx < x1 && x1 < gx2){
        for(y = y1; y <= y2; y++){
          if (gy < y && y < gy2){
            if (check == False || _check_raw_point(gid,x1,y)){
              _draw_point(gid,x1,y,r2,g2,b2,alpha);
            }
          }
        }
      }
    }else{
      long lw2 = lw/2;
      int x;
      for(x = 0; x < lw; x++){
        short xx = x - lw2 + x1;
        if (gx < xx && xx < gx2){
          if (_get_vline_in_rect(&xx,&y1,&y2,gx,gy,gw,gh) == False){
            continue;
          }
          for(y = y1; y <= y2; y++){
            if (check == False || _check_raw_point(gid,xx,y)){
              _draw_point(gid,xx,y,r2,g2,b2,alpha);
            }
          }
        }
      }
    }
  }
  return WS_NO_ERR;
}
inline int _draw_line2_h(int gid,short x1,short y1,short x2,unsigned int val){
  if (x1 < 0 && x2 < 0){
    return WS_NO_ERR;
  }
  if (y1 < 0){
    return WS_NO_ERR;
  }
//removed..
//  if (check_gid(gid) != WS_NO_ERR){
//    return WS_ERR_GID;
//  }
  _graphics_context* gcptr = &_gc_list[gid-1];
  long gx = gcptr->_x;
  long gy = gcptr->_y;
  unsigned long gw = gcptr->_w;
  unsigned long gh = gcptr->_h;

  long gx2 = gx + gw; 
  long gy2 = gy + gh; 
  long gx3 = gx2-1; 
  long gy3 = gy2-1; 

  int lw = gcptr->_lw;
  if (x1 < x2 && (x2 < gx || (long)(gx3) < (long)x1)){
    return WS_NO_ERR;
  } 
  if (x2 < x1 && (x1 < gx || (long)(gx3) < (long)x2)){
    return WS_NO_ERR;
  } 
  if ((y1 < gy || (long)(gy3) < (long)y1)){
    return WS_NO_ERR;
  }

  int depth = gcptr->_depth;
  int bytes = depth/8;
  int row_bytes = gcptr->_row_bytes;
  unsigned char* buf = gcptr->_buf;
  if (buf == NULL){
    buf = _buffer;
  }

  WSCpoint pt1[WS_MAX_POINTS];
  WSCpoint pt2[WS_MAX_POINTS];
  int num = 1;
  long i,j;
  long v = lw/2;
  long y;
  for(j=0; j<lw; j++){
    y = y1 -v +j;
    num = _check_raw_hline(gid,x1,y,x2,pt1,pt2,WS_MAX_POINTS,True);
    if (num == 0){
      continue;
    }
    for(i=0; i<num; i++){
      _draw_raw_hline(gid,pt1[i].x,pt1[i].y,pt2[i].x -pt1[i].x+1,val,buf,depth,row_bytes,bytes);
    }
  }
  return WS_NO_ERR;
}
inline int _draw_line2_h1(int gid,short x1,short y1,short x2,unsigned int val){
  if (x1 < 0 && x2 < 0){
    return WS_NO_ERR;
  }
  if (y1 < 0){
    return WS_NO_ERR;
  }
  _graphics_context* gcptr = &_gc_list[gid-1];
  long gx = gcptr->_x;
  long gy = gcptr->_y;
  unsigned long gw = gcptr->_w;
  unsigned long gh = gcptr->_h;

  long gx2 = gx + gw; 
  long gy2 = gy + gh; 
  long gx3 = gx2-1; 
  long gy3 = gy2-1; 

  int lw = gcptr->_lw;
  if (x1 < x2 && (x2 < gx || (long)(gx3) < (long)x1)){
    return WS_NO_ERR;
  } 
  if (x2 < x1 && (x1 < gx || (long)(gx3) < (long)x2)){
    return WS_NO_ERR;
  } 
  if ((y1 < gy || (long)(gy3) < (long)y1)){
    return WS_NO_ERR;
  }

  int depth = gcptr->_depth;
  int bytes = depth/8;
  int row_bytes = gcptr->_row_bytes;
  unsigned char* buf = gcptr->_buf;
  if (buf == NULL){
    buf = _buffer;
  }

  WSCpoint pt1[WS_MAX_POINTS];
  WSCpoint pt2[WS_MAX_POINTS];
  long i;
  int num = _check_raw_hline(gid,x1,y1,x2,pt1,pt2,WS_MAX_POINTS,True);
  if (num == 0){
    return WS_NO_ERR;
  }
  for(i=0; i<num; i++){
    _draw_raw_hline(gid,pt1[i].x,pt1[i].y,pt2[i].x -pt1[i].x+1,val,buf,depth,row_bytes,bytes);
  }
  return WS_NO_ERR;
}

inline int _draw_line2_v(int gid,short x1,short y1,short y2,unsigned int val){
  if (x1 < 0){
    return WS_NO_ERR;
  }
  if (y1 < 0 && y2 < 0){
    return WS_NO_ERR;
  }
//removed..
//  if (check_gid(gid) != WS_NO_ERR){
//    return WS_ERR_GID;
//  }
  _graphics_context* gcptr = &_gc_list[gid-1];
  long gx = gcptr->_x;
  long gy = gcptr->_y;
  unsigned long gw = gcptr->_w;
  unsigned long gh = gcptr->_h;

  long gx2 = gx + gw; 
  long gy2 = gy + gh; 
  long gx3 = gx2-1; 
  long gy3 = gy2-1; 

  int lw = gcptr->_lw;
  if (y1 < y2 && (y2 < gy || (long)(gy3) < (long)y1)){
    return WS_NO_ERR;
  } 
  if (y2 < y1 && (y1 < gy || (long)(gy3) < (long)y2)){
    return WS_NO_ERR;
  } 
  if ((x1 < gx || (long)(gx3) < (long)x1)){
    return WS_NO_ERR;
  }

  int depth = gcptr->_depth;
  int bytes = depth/8;
  int row_bytes = gcptr->_row_bytes;
  unsigned char* buf = gcptr->_buf;
  if (buf == NULL){
    buf = _buffer;
  }

  WSCpoint pt1[WS_MAX_POINTS];
  WSCpoint pt2[WS_MAX_POINTS];
  int num = 1;
  long i,j;
  long v = lw/2;
  long x;
  for(j=0; j<lw; j++){
    x = x1 -v +j;
    num = _check_raw_vline(gid,x,y1,y2,pt1,pt2,WS_MAX_POINTS,True);
    if (num == 0){
      continue;
    }
    for(i=0; i<num; i++){
      _draw_raw_vline(gid,pt1[i].x,pt1[i].y,pt2[i].y -pt1[i].y+1,val,buf,depth,row_bytes,bytes);
    }
  }
  return WS_NO_ERR;
}
#if 0
int _draw_line(int gid,short x1,short y1,short x2,short y2,unsigned int fg){
  unsigned int val = _get_col_value(&_gc_list[gid-1],fg);
  unsigned int alpha = _get_col_alpha(gid,fg);
  return _draw_line2(gid,x1,y1,x2,y2,val,alpha,fg);
}
#endif
int _draw_rect(int gid,short dx,short dy,
               unsigned short dw,unsigned short dh,
               unsigned int fg){
//  if (check_gid(gid) != WS_NO_ERR){
//    return WS_ERR_GID;
//  }
  unsigned int val = _get_col_value(&_gc_list[gid-1],fg);
  unsigned int alpha = _get_col_alpha(gid,fg);
  _draw_line2(gid,dx,dy,dx + dw-1,dy,val,alpha,fg);
  _draw_line2(gid,dx,dy,dx,dy + dh-1,val,alpha,fg);
  _draw_line2(gid,dx + dw-1 ,dy,dx + dw-1,dy + dh-1,val,alpha,fg);
  _draw_line2(gid,dx ,dy + dh-1,dx + dw-1,dy + dh-1,val,alpha,fg);
  return WS_NO_ERR;
}



inline int _draw_fill_rect(int gid,short dx,short dy,
               unsigned short dw,unsigned short dh,
               unsigned int bg){
//  if (check_gid(gid) != WS_NO_ERR){
//    return WS_ERR_GID;
//  }
  //TODO: draw rectangle..
//  int row_bytes = _gc_list[gid-1]._row_bytes;

  _graphics_context* gcptr = &_gc_list[gid-1];
  long dev_x = gcptr->_x;
  long dev_y = gcptr->_x;
  unsigned int dev_w = gcptr->_w;
  unsigned int dev_h = gcptr->_h;

  long x,y;
  unsigned long w,h;
  if (WSMFandArea(dx,dy,dw,dh,dev_x,dev_y,dev_w,dev_h,
              &x,&y,&w,&h) == WS_ERR){
    return WS_NO_ERR;
  }
  if (_check_visible_region(gid,&x,&y,&w,&h) == False){
    return WS_NO_ERR;
  }

//printf("draw_fill_rect gid=%d x,y,w,h=%d,%d,%d,%d\n",gid,dx,dy,dw,dh);
//printf("draw_fill_rect x,y,w,h=%d,%d,%d,%d buf=0x%x\n",dx,dy,dw,dh,buf);
//printf("draw_fill_rect 0x%x 0x%x 0x%x depth=%d\n",red,green,blue,depth);
  unsigned int val = _get_col_value(gcptr,bg);
  unsigned int alpha = _get_col_alpha(gid,bg);

//printf("draw_fill_rect rowbytes=%d val=0x%x\n",row_bytes,val);
  unsigned int lwbk = gcptr->_lw;
  gcptr->_lw = 1;

  int i,j;
  int right = x+w;
  int bottom = y+h;
  if (alpha == 0xff){
 //   int (*_draw_raw_hline)(int gid,short x,short y,unsigned int w,unsigned int val)
//       = (int (*)(int gid,short x,short y,unsigned int w,unsigned int val))
//         _get_draw_raw_hline_proc(gid);
    unsigned char* buf = gcptr->_buf;
    int depth = gcptr->_depth;
    int row_bytes = gcptr->_row_bytes;
    int bytes = depth/8;
    if (buf == NULL){
      if (WSMFandArea(x,y,w,h,0,0,_device_width,_device_height,
              &x,&y,&w,&h) == WS_ERR){
        return WS_NO_ERR;
      }
      right = x+w;
      bottom = y+h;
      buf = _buffer;
    }

    if (gcptr->_ex_region_list == NULL){
      for(i=y; i<bottom; i++){
        _draw_raw_hline(gid,x,i,w,val,buf,depth,row_bytes,bytes);
//        _draw_raw_hline(gid,x,i,w,val);
      }
    }else{
      WSCpoint pt1[WS_MAX_POINTS];
      WSCpoint pt2[WS_MAX_POINTS];
      for(i=y; i<bottom; i++){
#ifdef LINE_OPTIMIZE
        int num = _check_raw_hline(gid,x,i,right-1,pt1,pt2,WS_MAX_POINTS,False);
        for(j=0; j<num; j++){
          int x1 = pt1[j].x;
          int y1 = pt1[j].y;
          int x2 = pt2[j].x;
          _draw_raw_hline(gid,x1,y1,x2-x1+1,val,buf,depth,row_bytes,bytes);
//          _draw_raw_hline(gid,x1,y1,x2-x1+1,val);
        }
#else
        for(j=x; j<right; j++){
          if (_check_raw_point_ex_only(gid,j,i)){
            _draw_raw_point(gid,j,i,val);
          }
        }
#endif
      }
    }
  }else{
    unsigned char r2 =  bg >> 16;
    unsigned char g2 =  bg >> 8;
    unsigned char b2 =  bg;
    for(i=y; i<bottom; i++){
      for(j=x; j<right; j++){
        if (_check_raw_point(gid,j,i)){
          _draw_point(gid,j,i,r2,g2,b2,alpha);
        }
      }
    }
  }
  _gc_list[gid-1]._lw = lwbk;
  return WS_NO_ERR;
}

struct _poly_data_{
  long no;
#if 1
  long a1;
  long a2;
  long b1;
  long b2;
#endif 
  long v;
  long y_min;
  long y_max;
  WSCbool static_x;
  WSCbool static_y;
  WSCbool not_static;
  long x1;
  long x2;
  long y1;
  long y2;
  long temp_x;
//  long temp_y;
//  WSCbool active;
};
int _draw_fill_poly(int gid,WSCpoint* point,int num, unsigned int bg,int rev,WSCbool shortcut){
  if (num == 0){
    return WS_NO_ERR;
  }
  if (num < 4){
    shortcut = True;
  }
  _poly_data_ poly_data[num];

  _graphics_context* gcptr = &_gc_list[gid-1];
  long lw =  gcptr->_lw;
  gcptr->_lw = 1;

  long i;
#define MAX_CO 1000000
  long min_x = MAX_CO;
  long max_x = -MAX_CO;
  long min_y = MAX_CO;
  long max_y = -MAX_CO;
//printf("WSGFdfbDrawPolygon num=%d\n",num);
  long x1 = 0;
  long y1 = 0;
  long x2 = 0;
  long y2 = 0;
  for(i=0; i<num; i++){
    x1 = point[i].x;
    y1 = point[i].y;
//    x2 = 0;
//    y2 = 0;
    if (i== num -1){
      x2 = point[0].x;
      y2 = point[0].y;
    }else{
      x2 = point[i+1].x;
      y2 = point[i+1].y;
    }
    _poly_data_* pd = &poly_data[i];
    if (x1 != x2){
      pd->a1 = y1 - y2;
      pd->a2 = x1 - x2;
      pd->b1 = x1*y2 - x2*y1; // b = b1/b2
      pd->b2 = x1 - x2;
      pd->static_x = False;
      if (y1 == y2){
        pd->static_y = True;
      }else{
        pd->static_y = False;
        pd->v = pd->a1 * pd->b2;
      }
    }else{
//      pd->a1 = 0;
//      pd->a2 = 0;
//      pd->b1 = 0;
//      pd->b2 = 0;
      pd->static_x = True;
      pd->static_y = False;
    }
    pd->not_static = (pd->static_x == False && pd->static_y == False);
    pd->x1 = x1;
    pd->x2 = x2;
    pd->y1 = y1;
    pd->y2 = y2;
    if (y1 < y2){
      pd->y_min = y1;
      pd->y_max = y2;
    }else{
      pd->y_min = y2;
      pd->y_max = y1;
    }
    pd->no = i;
    if (x1 < min_x){
      min_x = x1;
    }
    if (x2 < min_x){
      min_x = x2;
    }
    if (y1 < min_y){
      min_y = y1;
    }
    if (y2 < min_y){
      min_y = y2;
    }
    if (max_x < x1){
      max_x = x1;
    }
    if (max_x < x2){
      max_x = x2;
    }
    if (max_y < y1){
      max_y = y1;
    }
    if (max_y < y2){
      max_y = y2;
    }
  }
  long y;
  if (min_y < 0){
    min_y = 0;
  }
  _poly_data_* active_list[num];
  int j=0;
  long actives = 0;
//  WSCbool active = False;

  long dev_x = gcptr->_x;
  long dev_y = gcptr->_x;
  unsigned int dev_w = gcptr->_w;
  unsigned int dev_h = gcptr->_h;

  long tx,ty;
  unsigned long tw,th;
  if (WSMFandArea(min_x,min_y,max_x - min_x+1,max_y - min_y+1,dev_x,dev_y,dev_w,dev_h,
              &tx,&ty,&tw,&th) == WS_ERR){
    return WS_NO_ERR;
  }
  if (_check_visible_region(gid,&tx,&ty,&tw,&th) == False){
    return WS_NO_ERR;
  }

  min_x = tx;
  min_y = ty;
  max_x = tx + tw -1;
  max_y = ty + th -1;
  if (min_x >= max_x || min_y >= max_y){
    return WS_NO_ERR;
  }
  unsigned int val = _get_col_value(gcptr,bg);
  unsigned int alpha = _get_col_alpha(gid,bg);
  WSCbool check = True;
  if (gcptr->_ex_region_list == NULL){
    check = False;
  }

  int (*_draw_raw_hline)(int gid,short x,short y,unsigned int w,unsigned int val)
       = (int (*)(int gid,short x,short y,unsigned int w,unsigned int val))
         _get_draw_raw_hline_proc(gid);

  WSCpoint pt1[WS_MAX_POINTS];
  WSCpoint pt2[WS_MAX_POINTS];
  int n;
  _poly_data_* pd;
  
  for(y = min_y; y <= max_y; y++){
    actives = 0;

    for(i=0; i<num; i++){
      pd = &poly_data[i];
      if (!( pd->y_min <= y && y <= pd->y_max)){
        continue;
      }
#if 0
      if ( pd->y1 < pd->y2){
        if (!( pd->y1 <= y && y <= pd->y2)){
          continue;
        }
      }else{
        if (!( pd->y2 <= y && y <= pd->y1)){
          continue;
        }
      }
#endif
//      if (pd->static_x == False && pd->static_y == False){
      if (pd->not_static){
        pd->temp_x = (long)(y * pd->b2 - (long)pd->b1) * pd->a2 / pd->v;
      }else{
        pd->temp_x = pd->x1;
      }

      if (actives == 0){
        active_list[0] = pd;
      }else{
        for(j=0; j<actives; j++){
          _poly_data_* item =(_poly_data_*)active_list[j];
          if (pd->temp_x < item->temp_x){
            memmove(&active_list[j+1],&active_list[j],(num - j -1)*sizeof(_poly_data_*));
            active_list[j] = pd;
            break;
          }
          if (j == actives -1){
            active_list[actives] = pd;
            break;
          }
        }
      }
      actives++;
    }

    if (shortcut == False){
      long direction =0;
      long counts = 1;
      _poly_data_* item = active_list[0];
      if (item->y1 > item->y2){
        direction = 1;
      }
      int j;
      _poly_data_* item1 = NULL;
      _poly_data_* item2 = NULL;
      long direction1 =0;
      long direction2 =0;
      for(j=0; j<actives; j++){
        item1 = active_list[j];
        item2 = NULL;
        direction1 =0;
        direction2 =0;
        if (j < actives-1){
          item2 = active_list[j+1];
        }else{
          item2 = active_list[0];
        }
        if (item1->y1 > item1->y2){
          direction1 = 1;
        }
        if (item2->y1 > item2->y2){
          direction2 = 1;
        }

        if (item1->static_y == True && item1->static_x == False){
          if (alpha == 0xff){
            long x1 = item1->temp_x;
            if (x1 < tx){
              x1 = tx;
            }
            long x2 = item2->temp_x;
            if (max_x < x2){
              x2 = max_x;
            }
            if (x2 < x1){
              continue;
            }
            if (check == False){
              _draw_raw_hline(gid,x1,y,x2-x1+1,val);
            }else{
//              int lnum = _check_raw_hline(gid,item1->temp_x,y,item2->temp_x,pt1,pt2,WS_MAX_POINTS,True);
              int lnum = _check_raw_hline(gid,x1,y,x2,pt1,pt2,WS_MAX_POINTS,False);
              if (lnum == 0){
                continue;
              }
              for(n=0; n<lnum; n++){
                _draw_raw_hline(gid,pt1[n].x,pt1[n].y,pt2[n].x-pt1[n].x+1,val);
              }
            }
          }else{
            _draw_line2(gid,item1->temp_x,y,item2->temp_x,y,val,alpha,bg);
          }
          continue;
        }
        if (direction == direction2){
          if (item1->no == item2->no + 1 ||
              item2->no == item1->no + 1 ||
              (item1->no == 0 && item2->no == num -1) ||
              (item2->no == 0 && item1->no == num -1) ){
            if (direction1 != direction2){
              counts++;
            }else
            if(item1->temp_x != item2->temp_x){
              counts++;
            }
            // these lines has same point. // ignore countup.
          }else{
            counts++;
          }
        }else{
          if (item1->no == item2->no + 1 ||
              item2->no == item1->no + 1 ||
              (item1->no == 0 && item2->no == num -1) ||
              (item2->no == 0 && item1->no == num -1) ){
            if (direction1 != direction2){
              counts--;
            }else
            if(item1->temp_x != item2->temp_x){
              counts--;
            }
            // these lines has same point. // ignore countup.
          }else{
            counts--;
          }
        }
        if ((counts > 1 && rev == True)||(counts%2 == 0)){
          if (alpha == 0xff){
            long x1 = item1->temp_x;
            if (x1 < tx){
              x1 = tx;
            }
            long x2 = item2->temp_x;
            if (max_x < x2){
              x2 = max_x;
            }
            if (x2 < x1){
              continue;
            }
            if (check == False){
              _draw_raw_hline(gid,x1,y,x2 -x1 +1,val);
            }else{
//              int lnum = _check_raw_hline(gid,item1->temp_x,y,item2->temp_x,pt1,pt2,WS_MAX_POINTS,True);
              int lnum = _check_raw_hline(gid,x1,y,x2,pt1,pt2,WS_MAX_POINTS,False);
              if (lnum == 0){
                continue;
              }
              for(n=0; n<lnum; n++){
                _draw_raw_hline(gid,pt1[n].x,pt1[n].y,pt2[n].x-pt1[n].x+1,val);
              }
            }
          }else{
            _draw_line2(gid,item1->temp_x,y,item2->temp_x,y,val,alpha,bg);
          }
        }
      }
    }else{
      if (alpha == 0xff){
        long x1 = active_list[0]->temp_x;
        if (x1 < tx){
          x1 = tx;
        }
        long x2 = active_list[actives-1]->temp_x;
        if (max_x < x2){
          x2 = max_x;
        }
        if (x2 < x1){
          continue;
        }
        if (check == False){
          _draw_raw_hline(gid,x1,y,x2 - x1 +1,val);
        }else{
//          int lnum = _check_raw_hline(gid,active_list[0]->temp_x,y,
//                   active_list[actives-1]->temp_x,pt1,pt2,WS_MAX_POINTS,True);
          int lnum = _check_raw_hline(gid,x1,y,x2,pt1,pt2,WS_MAX_POINTS,False);
          if (lnum == 0){
            continue;
          }
          for(n=0; n<lnum; n++){
            _draw_raw_hline(gid,pt1[n].x,pt1[n].y,pt2[n].x-pt1[n].x+1,val);
          }
        }
      }else{
        _draw_line2(gid,active_list[0]->temp_x,y,
                       active_list[actives -1]->temp_x,y,val,alpha,bg);
      }
    }
  }
//  delete poly_data;
  _gc_list[gid-1]._lw = lw;
  return WS_NO_ERR;
}

#if (defined NO_DRAW_ARC) && (defined NO_DRAW_FILL_ARC)
#else
long _arc_point_index(long vx,long vy){
  if (vx == 0){
    if (vy < 0){
      return 1;
    }
    return 3;
  }
  long pos = 0;
  if (vy < 0){
    if (vx > 0){
      pos = 0;
    }else{
      pos = 1;
    }
  }else{
    if (vx < 0){
      pos = 2;
    }else{
      pos = 3;
    }
  }
  return pos;
}
WSCbool _over_arc_point1(long vx,long vy,long ax,long ay){
  long p1 = _arc_point_index(vx,vy);
  long p2 = _arc_point_index(ax,ay);
  if (p2 < p1){
    return True;
  }
  if (p1 < p2){
    return False;
  }
  if (ay * vx >= vy * ax){
    return True;
  }
  return False;
}
WSCbool _over_arc_point2(long vx,long vy,long ax,long ay){
  long p1 = _arc_point_index(vx,vy);
  long p2 = _arc_point_index(ax,ay);
  if (p2 < p1){
    return True;
  }
  if (p1 < p2){
    return False;
  }
  if (ay * vx > vy * ax){
    return True;
  }
  return False;
}


WSCbool _check_arc_point(long x,long y,long ax1,long ay1,long ax2,long ay2){
  WSCbool over_360 = _over_arc_point1(ax1,ay1,ax2,ay2);
  if (over_360 == False){
    WSCbool fl1 = _over_arc_point1(x,y,ax1,ay1);
    WSCbool fl2 = _over_arc_point2(x,y,ax2,ay2);
    return (fl1 && !fl2);
  }
  WSCbool fl1 = _over_arc_point1(x,y,ax1,ay1);
  if (fl1 != False){
    return True;
  }
  WSCbool fl2 = _over_arc_point2(x,y,ax2,ay2);
  return !fl2;
}
#define VAL_360_x_64 23040

//extern unsigned char arc_ptr[256][2];
void _draw_arc( int gid,int x,int y, int w,int h,
                     long a1,long a2,WSCbool fill,long type,int bg){
  WSCbool circle = False;

  if (a2 >= VAL_360_x_64){
    circle = True;
  }else if (w < 2 || h < 2){
    circle = True;
  }
//#define WS_PT_NUM 36
//#define WS_PT_NUM 360
  unsigned int val = _get_col_value(&_gc_list[gid-1],bg);
  unsigned int alpha = _get_col_alpha(gid,bg);
#if 0
  unsigned char r2 =  bg >> 16;
  unsigned char g2 =  bg >> 8;
  unsigned char b2 =  bg;
#endif

  _graphics_context* gcptr = &_gc_list[gid-1];

  int row_bytes = gcptr->_row_bytes;
  unsigned char* buf = gcptr->_buf;
  if (buf == NULL){
    buf = _buffer;
  }

  long dev_x = gcptr->_x;
  long dev_y = gcptr->_x;
  unsigned int dev_w = gcptr->_w;
  unsigned int dev_h = gcptr->_h;

  long tx,ty;
  unsigned long tw,th;
  if (WSMFandArea(x,y,w,h,dev_x,dev_y,dev_w,dev_h,
              &tx,&ty,&tw,&th) == WS_ERR){
    return;
  }
  if (_check_visible_region(gid,&tx,&ty,&tw,&th) == False){
    return;
  }
  WSCbool check = True;
  if (_gc_list[gid-1]._ex_region_list == NULL){
    check = False;
  }

#if 1
  if (circle != False){
    int w1 = w/2;
    int h1 = h/2;
    int x0 = x + w1;
    int y0 = y + h1;
    int ptx = w1;
    int pty = 0;
    int d1 = w*w;
    int d2 = h*h;
    int diff1 = -2*w*h + d2 + 2*d1;
    int diff2 = -4*w*h + 2*d2 + d1;
    if (fill == False){
      int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
         = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
         _get_draw_raw_point_proc(gid);

      int lw = _gc_list[gid-1]._lw;
      int xbk = ptx;
      int ybk = pty;
      int px;
      int py;
      while(ptx >= 0){
        py = y + h1 + pty;
        if (ty <= py && py <= ty+th){
          px = x + w1 + ptx;
          if (tx <= px && px <= tx+tw){
            if (check == False || _check_raw_point_ex_only(gid,px,py)){
              _draw_raw_point(gid,px,py,val,buf,row_bytes);
            }
          }
          px = x + w1 - ptx;
          if (tx <= px && px <= tx+tw){
            if (check == False || _check_raw_point_ex_only(gid,px,py)){
              _draw_raw_point(gid,px,py,val,buf,row_bytes);
            }
          }
        }
        py = y + h1 - pty;
        if (ty <= py && py <= ty+th){
          px = x + w1 - ptx;
          if (tx <= px && px <= tx+tw){
            if (check == False || _check_raw_point_ex_only(gid,px,py)){
              _draw_raw_point(gid,px,py,val,buf,row_bytes);
            }
          }
          px = x + w1 + ptx;
          if (tx <= px && px <= tx+tw){
            if (check == False || _check_raw_point_ex_only(gid,px,py)){
              _draw_raw_point(gid,px,py,val,buf,row_bytes);
            }
          }
        }
        if (lw > 1 && ptx != xbk && pty != ybk){
          py = y + h1 + pty;
          if (ty <= py && py <= ty+th){
            px = x + w1 + ptx+1;
            if (tx <= px && px <= tx+tw){
              if (check == False || _check_raw_point_ex_only(gid,px,py)){
                _draw_raw_point(gid,px,py,val,buf,row_bytes);
              }
            }
            px = x + w1 - ptx-1;
            if (tx <= px && px <= tx+tw){
              if (check == False || _check_raw_point_ex_only(gid,px,py)){
                _draw_raw_point(gid,px,py,val,buf,row_bytes);
              }
            }
          }
          py = y + h1 - pty;
          if (ty <= py && py <= ty+th){
            px = x + w1 - ptx-1;
            if (tx <= px && px <= tx+tw){
              if (check == False || _check_raw_point_ex_only(gid,px,py)){
                _draw_raw_point(gid,px,py,val,buf,row_bytes);
              }
            }
            px = x + w1 + ptx+1;
            if (tx <= px && px <= tx+tw){
              if (check == False || _check_raw_point_ex_only(gid,px,py)){
                _draw_raw_point(gid,px,py,val,buf,row_bytes);
              }
            }
          }
        }
        if (diff1 < 0){
          pty++;
          diff1 += (4*pty+2) *d1;
          diff2 += 4*pty *d1;
        }else if (diff2 >=0){
          ptx--;
          diff1 -= 4*ptx *d2;
          diff2 -= (4*ptx-2) *d2;
        }else{
          pty++;
          ptx--;
          diff1 += (4*pty + 2)*d1 - 4*d2*ptx;
          diff2 += 4*pty*d1 + (2 -4*d2) *ptx;
        }
//printf("diff=%d %d d1=%d\n",diff1,diff2,d1);
      }
      return;
    }else{
      int pty_bk = -1;
      int tx2 = tx + tw;
      int ty2 = ty + th;
      int depth = gcptr->_depth;
      int bytes = depth/8;
      while(ptx >= 0){
        int px1 = x + w1 - ptx;
        int px2 = x + w1 + ptx;
        int py = y + h1 + pty;
        int py2 = y + h1 - pty;
        if (pty_bk != pty){
          if (check == False){
            if (px1 < tx){
              px1 = tx;
            }
            if (tx2 <= px2){
              px2 = tx2-1;
            }
            if (!(px2 < px1)){
              if (ty <= py && py < ty+th){
                _draw_raw_hline(gid,px1,py,px2 -px1 +1,val,buf,depth,row_bytes,bytes);
              }
              if (ty <= py2 && py2 <= ty+th){
                _draw_raw_hline(gid,px1,py2,px2 -px1 +1,val,buf,depth,row_bytes,bytes);
              }
            }

          }else{
            _draw_line2_h1(gid,px1,py,px2,val);
            _draw_line2_h1(gid,px1,py2,px2,val);
          }
          pty_bk = pty;
        }
        if (diff1 < 0){
          pty++;
          diff1 += (4*pty+2) *d1;
          diff2 += 4*pty *d1;
        }else if (diff2 >=0){
          ptx--;
          diff1 -= 4*ptx *d2;
          diff2 -= (4*ptx-2) *d2;
        }else{
          pty++;
          ptx--;
          diff1 += (4*pty + 2)*d1 - 4*d2*ptx;
          diff2 += 4*pty*d1 + (2 -4*d2) *ptx;
        }
//printf("diff=%d %d d1=%d\n",diff1,diff2,d1);
      }
#if 0
      while(ptx >= 0){
        int px1 = x + w1 - ptx;
        int px2 = x + w1 + ptx;
        int py = y + h1 + pty;
        _draw_line2(gid,px1,py,px2,py,val,alpha,bg);
        py = y + h1 - pty;
        _draw_line2(gid,px1,py,px2,py,val,alpha,bg);

        if (diff1 < 0){
          pty++;
          diff1 += (4*pty+2) *d1;
          diff2 += 4*pty *d1;
        }else if (diff2 >=0){
          ptx--;
          diff1 -= 4*ptx *d2;
          diff2 -= (4*ptx-2) *d2;
        }else{
          pty++;
          ptx--;
          diff1 += (4*pty + 2)*d1 - 4*d2*ptx;
          diff2 += 4*pty*d1 + (2 -4*d2) *ptx;
        }
//printf("diff=%d %d d1=%d\n",diff1,diff2,d1);
      }
#endif
    }
    return;
  }
#endif
#if 1
  if (fill == False){
    int w1 = w/2;
    int h1 = h/2;
    int h2 = h/3;
    int x0 = x + w1;
    int y0 = y + h1;
    int ptx = w1;
    int pty = 0;
    int d1 = w*w;
    int d2 = h*h;
    int diff1 = -2*w*h + d2 + 2*d1;
    int diff2 = -4*w*h + 2*d2 + d1;

#define WS_PI_VALUE1 (3.14159265358979323846/360)
#define WS_PI_VALUE2 (3.14159265358979323846/180)
    float aa1 = WS_PI_VALUE2 * (double)(a1%(360*64))/64;
    float aa2 = WS_PI_VALUE2 * (double)((a1+a2)%(360*64))/64;
    long an1 = a1%(360*64);
    long an2 = (a1+a2)%(360*64);

    int ay1 = 0;
    int ay2 = 0;
    int ax1 = w;
    int ax2 = w;


    if (an1 == 90*64){
      ax1 = 0; 
      ay1 = -h;
    }else
    if ( an1 == 270*64){
      ax1 = 0;
      ay1 = h;
    }else{
      double v = tan(aa1);
      if (v < 0){
        v = -v;
      }
      if (v < 1){
        if (an1 < 180*64){
          ay1 = -h * v;
        }else{
          ay1 = h * v;
        }
        if (90*64 < an1 && an1 < 270*64){
          ax1 = -w;
        }else{
          ax1 = w;
        }
      }else{
        if (90*64 < an1 && an1 < 270*64){
          ax1 = -w / v;
        }else{
          ax1 = w / v;
        }
        if (0 < an1 && an1 < 180*64){
          ay1 = -h;
        }else{
          ay1 = h;
        }
      }
    }

    if (an2 == 90*64){
      ax2 =0;
      ay2 =-h;
    }else
    if (an2 == 270*64){
      ax2 =0;
      ay2 =h;
    }else{
      double v = tan(aa2);
      if (v < 0){
        v = -v;
      }
      if (-1 < v && v < 1){
        if (an2 < 180*64){
          ay2 = -h * v;
        }else{
          ay2 = h * v;
        }
        if (90*64 < an2 && an2 < 270*64){
          ax2 = -w;
        }else{
          ax2 = w;
        }
      }else{
        if (90*64 < an2 && an2 < 270*64){
          ax2 = -w / v;
        }else{
          ax2 = w / v;
        }
        if (0 < an2 && an2 < 180*64){
          ay2 = -h;
        }else{
          ay2 = h;
        }
      }
    }
    int (*_draw_raw_point)(int gid,short x,short y,unsigned int val,unsigned char*,int)
       = (int (*)(int gid,short x,short y,unsigned int val,unsigned char*,int))
       _get_draw_raw_point_proc(gid);


      int lw = _gc_list[gid-1]._lw;
      int xbk = ptx;
      int ybk = pty;
      int px;
      int py;
      while(ptx >= 0){
        py = y + h1 + pty;
        if (ty <= py && py <= ty+th){
          px = x + w1 + ptx;
          if (tx <= px && px <= tx+tw){
            if (_check_arc_point(ptx,pty,ax1,ay1,ax2,ay2))
            if (check == False || _check_raw_point_ex_only(gid,px,py)){
              _draw_raw_point(gid,px,py,val,buf,row_bytes);
            }
          }
          px = x + w1 - ptx;
          if (tx <= px && px <= tx+tw){
            if (_check_arc_point(-ptx,pty,ax1,ay1,ax2,ay2))
            if (check == False || _check_raw_point_ex_only(gid,px,py)){
              _draw_raw_point(gid,px,py,val,buf,row_bytes);
            }
          }
        }
        py = y + h1 - pty;
        if (ty <= py && py <= ty+th){
          px = x + w1 - ptx;
          if (tx <= px && px <= tx+tw){
            if (_check_arc_point(-ptx,-pty,ax1,ay1,ax2,ay2))
            if (check == False || _check_raw_point_ex_only(gid,px,py)){
              _draw_raw_point(gid,px,py,val,buf,row_bytes);
            }
          }
          px = x + w1 + ptx;
          if (tx <= px && px <= tx+tw){
            if (_check_arc_point(ptx,-pty,ax1,ay1,ax2,ay2))
            if (check == False || _check_raw_point_ex_only(gid,px,py)){
              _draw_raw_point(gid,px,py,val,buf,row_bytes);
            }
          }
        }

        if (lw > 1 && ptx != xbk && pty != ybk){
          py = y + h1 + pty;
          if (ty <= py && py <= ty+th){
            px = x + w1 + ptx+1;
            if (tx <= px && px <= tx+tw){
              if (_check_arc_point(ptx+1,pty,ax1,ay1,ax2,ay2))
              if (check == False || _check_raw_point_ex_only(gid,px,py)){
                _draw_raw_point(gid,px,py,val,buf,row_bytes);
              }
            }
            px = x + w1 - ptx-1;
            if (tx <= px && px <= tx+tw){
              if (_check_arc_point(-ptx-1,pty,ax1,ay1,ax2,ay2))
              if (check == False || _check_raw_point_ex_only(gid,px,py)){
                _draw_raw_point(gid,px,py,val,buf,row_bytes);
              }
            }
          }
          py = y + h1 - pty;
          if (ty <= py && py <= ty+th){
            px = x + w1 - ptx-1;
            if (tx <= px && px <= tx+tw){
              if (_check_arc_point(-ptx-1,-pty,ax1,ay1,ax2,ay2))
              if (check == False || _check_raw_point_ex_only(gid,px,py)){
                _draw_raw_point(gid,px,py,val,buf,row_bytes);
              }
            }
            px = x + w1 + ptx+1;
            if (tx <= px && px <= tx+tw){
              if (_check_arc_point(ptx+1,-pty,ax1,ay1,ax2,ay2))
              if (check == False || _check_raw_point_ex_only(gid,px,py)){
                _draw_raw_point(gid,px,py,val,buf,row_bytes);
              }
            }
          }
        }
 #if 0
        if (lw > 1){
          if (pty > h2){
            int j;
            for(j=1; j<lw; j++){
              if (pty - j <= h2){
                continue;
              }
              py = y + h1 + pty-j;
              if (ty <= py && py <= ty+th){
                px = x + w1 + ptx;
                if (tx <= px && px <= tx+tw){
                  if (_check_arc_point(ptx,pty+j,ax1,ay1,ax2,ay2))
                  if (check == False || _check_raw_point_ex_only(gid,px,py)){
                    _draw_raw_point(gid,px,py,val,buf,row_bytes);
                  }
                }
                px = x + w1 - ptx;
                if (tx <= px && px <= tx+tw){
                  if (_check_arc_point(-ptx,pty+j,ax1,ay1,ax2,ay2))
                  if (check == False || _check_raw_point_ex_only(gid,px,py)){
                    _draw_raw_point(gid,px,py,val,buf,row_bytes);
                  }
                }
              }
              py = y + h1 - pty+j;
              if (ty <= py && py <= ty+th){
                px = x + w1 - ptx;
                if (tx <= px && px <= tx+tw){
                  if (_check_arc_point(-ptx,-pty+j,ax1,ay1,ax2,ay2))
                  if (check == False || _check_raw_point_ex_only(gid,px,py)){
                    _draw_raw_point(gid,px,py,val,buf,row_bytes);
                  }
                }
                px = x + w1 + ptx;
                if (tx <= px && px <= tx+tw){
                  if (_check_arc_point(ptx,-pty+j,ax1,ay1,ax2,ay2))
                  if (check == False || _check_raw_point_ex_only(gid,px,py)){
                    _draw_raw_point(gid,px,py,val,buf,row_bytes);
                  }
                }
              }
            }
          }else{
            int j;
            for(j=1; j<lw; j++){
              py = y + h1 + pty;
              if (pty - j > h2){
                continue;
              }
              if (ty <= py && py <= ty+th){
                px = x + w1 + ptx-j;
                if (tx <= px && px <= tx+tw){
                  if (_check_arc_point(ptx-j,pty,ax1,ay1,ax2,ay2))
                  if (check == False || _check_raw_point_ex_only(gid,px,py)){
                    _draw_raw_point(gid,px,py,val,buf,row_bytes);
                  }
                }
                px = x + w1 - ptx+j;
                if (tx <= px && px <= tx+tw){
                  if (_check_arc_point(-ptx+j,pty,ax1,ay1,ax2,ay2))
                  if (check == False || _check_raw_point_ex_only(gid,px,py)){
                    _draw_raw_point(gid,px,py,val,buf,row_bytes);
                  }
                }
              }
              py = y + h1 - pty;
              if (ty <= py && py <= ty+th){
                px = x + w1 - ptx+j;
                if (tx <= px && px <= tx+tw){
                  if (_check_arc_point(-ptx+j,-pty,ax1,ay1,ax2,ay2))
                  if (check == False || _check_raw_point_ex_only(gid,px,py)){
                    _draw_raw_point(gid,px,py,val,buf,row_bytes);
                  }
                }
                px = x + w1 + ptx-j;
                if (tx <= px && px <= tx+tw){
                  if (_check_arc_point(ptx-j,-pty,ax1,ay1,ax2,ay2))
                  if (check == False || _check_raw_point_ex_only(gid,px,py)){
                    _draw_raw_point(gid,px,py,val,buf,row_bytes);
                  }
                }
              }
            }
          }
        }
#endif
        if (diff1 < 0){
          pty++;
          diff1 += (4*pty+2) *d1;
          diff2 += 4*pty *d1;
        }else if (diff2 >=0){
          ptx--;
          diff1 -= 4*ptx *d2;
          diff2 -= (4*ptx-2) *d2;
        }else{
          pty++;
          ptx--;
          diff1 += (4*pty + 2)*d1 - 4*d2*ptx;
          diff2 += 4*pty*d1 + (2 -4*d2) *ptx;
        }
//printf("diff=%d %d d1=%d\n",diff1,diff2,d1);
      }
      return;
  }
#endif
  double an1 = (double)a1/64;
  double an2 = (double)a2/64;

#define WS_PI_VALUE1 (3.14159265358979323846/360)
#define WS_PI_VALUE2 (3.14159265358979323846/180)
  //Do not increase points because noisy line will be appeard.
  long points = (long)((w+h)/4 * WS_PI_VALUE1 * an2);

  WSCpoint point[points+1];
  long cnt = 0;
  int i;

  float aa1 = WS_PI_VALUE2 * an1;
  float aa2 = WS_PI_VALUE2 * an2 / (points -1);
  float w2 = w/2;
  float h2 = h/2;
  float aa = aa1;
  for(i=0; i<points; i++){
//    float aa = aa1 + aa2*i;
    aa += aa2;
    point[cnt].x = x + (long)(w2 * (1 + cos(aa)) + 0.5);
    point[cnt].y = y + (long)(h2 * (1 - sin(aa)) + 0.5);
    if (cnt > 0){
      if (point[cnt].x == point[cnt-1].x &&
          point[cnt].y == point[cnt-1].y){
        continue;
      }
    }
    cnt++;
  }
#if 0
  if (fill == False){
    if (alpha == 0xff){
      for(i=0; i<cnt; i++){
        int x = point[i].x;
        int y = point[i].y;
        if (tx <= x && x <= tx+tw &&
            ty <= y && y <= ty+th){
          if (check == False || _check_raw_point_ex_only(gid,x,y)){
            _draw_raw_point(gid,x,y,val,buf,row_bytes);
          }
        }
      }
    }else{
      for(i=0; i<cnt; i++){
        int x = point[i].x;
        int y = point[i].y;
        if (tx <= x && x <= tx+tw &&
            ty <= y && y <= ty+th){
          if (check == False || _check_raw_point_ex_only(gid,x,y)){
            _draw_point(gid,x,y,r2,g2,b2,alpha);
          }
        }
      }
    }
  }else{
#endif
    if (circle == False && type == WS_PI){
      point[cnt].x = x + w/2;
      point[cnt].y = y + h/2;
      if (an2 > 180){
        long tmpa1 = an1;
        while(tmpa1 > 360){
          tmpa1 -= 360;
        }
        while(tmpa1 < 0){
          tmpa1 += 360;
        }
        long tmpa2 = tmpa1 + an2;
        while(tmpa2 > 360){
          tmpa2 -= 360;
        }
        while(tmpa2 < 0){
          tmpa2 += 360;
        }
        if (0 < tmpa1 && tmpa1 < 180 && 0 < tmpa2 && tmpa2 < 180){
          _draw_fill_poly(gid,point,cnt+1,bg,False,False);
        }else
        if (180 < tmpa1 && tmpa1 < 360 && 180 < tmpa2 && tmpa2 < 360){
          _draw_fill_poly(gid,point,cnt+1,bg,False,False);
        }else{
          _draw_fill_poly(gid,point,cnt+1,bg,False,True);
        }
      }else{
        _draw_fill_poly(gid,point,cnt+1,bg,False,True);
      }
    }else{
      _draw_fill_poly(gid,point,cnt,bg,False,True);
    }
#if 0
  }
#endif

}
#endif

inline int _draw_raw_bitmap(int gid,short dx,short dy,
               unsigned short dw,unsigned short dh,
               unsigned int val,unsigned char* bmp){
//  if (check_gid(gid) != WS_NO_ERR){
//    return WS_ERR_GID;
//  }
  int i,j;
  long val1 = (dw+7)/8;

  _graphics_context* gcptr = &_gc_list[gid-1];
  unsigned char* buf = gcptr->_buf;
  int depth = gcptr->_depth;
  int row_bytes = gcptr->_row_bytes;
  int bytes = depth/8;
  if (buf == NULL){
    buf = _buffer;
  }
  long offset = row_bytes* dy + bytes * dx;
  long gx;
  long gy;
  unsigned long gw;
  unsigned long gh;
  dx += gcptr->_x;
  dy += gcptr->_y;
  if (WSMFandArea(dx,dy,dw,dh,
                      gcptr->_x,
                      gcptr->_y,
                      gcptr->_w,
                      gcptr->_h,
                      &gx,&gy,&gw,&gh) == WS_ERR){
    return WS_NO_ERR;
  }
  if (_check_visible_region(gid,&gx,&gy,&gw,&gh) == False){
    return WS_NO_ERR;
  }

  WSCbool check = True;
  if (gcptr->_ex_region_list == NULL){
    check = False;
  }
  long gx2 = gx + gw;
  long gy2 = gy + gh;
  unsigned char* ptr;
  unsigned char b;
  long px,py;
  if (depth == 32){
    if (check == False){
      for(i=0; i<dh; i++){
        py = i+dy;
        if (gy <= py && py < gy2){
          ptr = &bmp[i*val1];
          b = *ptr;
          int ptr2 = (int)(offset + row_bytes * i);
          for(j=0; j<dw; j++){
            if (b & 0x80){
              px = j+dx;
              if (gx <= px && px < gx2){
                unsigned int* bf = (unsigned int*)&buf[ptr2];
                *bf = (unsigned int)val;
              }
            }
            b <<= 1;
            if (!((j+1) % 8)){
              ptr++;
              b = *ptr;
            }
            ptr2 += bytes;
          }
        }
      }
    }else{
      for(i=0; i<dh; i++){
        py = i+dy;
        if (gy <= py && py < gy2){
          ptr = &bmp[i*val1];
          b = *ptr;
          int ptr2 = (int)(offset + row_bytes * i);
          for(j=0; j<dw; j++){
            if (b & 0x80){
              px = j+dx;
              if (gx <= px && px < gx2){
                if (_check_raw_point_ex_only(gid,px,py)){
                  unsigned int* bf = (unsigned int*)&buf[ptr2];
                  *bf = (unsigned int)val;
                }
              }
            }
            b <<= 1;
            if (!((j+1) % 8)){
              ptr++;
              b = *ptr;
            }
            ptr2 += bytes;
          }
        }
      }
    }
  }else
  if (depth == 24){
    if (check == False){
      for(i=0; i<dh; i++){
        py = i+dy;
        if (gy <= py && py < gy2){
          ptr = &bmp[i*val1];
          b = *ptr;
          int ptr2 = (int)(offset + row_bytes * i);
          for(j=0; j<dw; j++){
            if (b & 0x80){
              px = j+dx;
              if (gx <= px && px < gx2){
                unsigned char* bf = (unsigned char*)&buf[ptr2];
                *bf++ = (unsigned char)((val>>16) & 0xff);
                *bf++ = (unsigned char)((val>>8) & 0xff);
                *bf++ = (unsigned char)((val) & 0xff);
              }
            }
            b <<= 1;
            if (!((j+1) % 8)){
              ptr++;
              b = *ptr;
            }
            ptr2 += bytes;
          }
        }
      }
    }else{
      for(i=0; i<dh; i++){
        py = i+dy;
        if (gy <= py && py < gy2){
          ptr = &bmp[i*val1];
          b = *ptr;
          int ptr2 = (int)(offset + row_bytes * i);
          for(j=0; j<dw; j++){
            if (b & 0x80){
              px = j+dx;
              if (gx <= px && px < gx2){
                if (_check_raw_point_ex_only(gid,px,py)){
                  unsigned char* bf = (unsigned char*)&buf[ptr2];
                  *bf++ = (unsigned char)((val>>16) & 0xff);
                  *bf++ = (unsigned char)((val>>8) & 0xff);
                  *bf++ = (unsigned char)((val) & 0xff);
                }
              }
            }
            b <<= 1;
            if (!((j+1) % 8)){
              ptr++;
              b = *ptr;
            }
            ptr2 += bytes;
          }
        }
      }
    }
  }else
  if (depth == 16){
    if (check == False){
      for(i=0; i<dh; i++){
        py = i+dy;
        if (gy <= py && py < gy2){
          ptr = &bmp[i*val1];
          b = *ptr;
          int ptr2 = (int)(offset + row_bytes * i);
          for(j=0; j<dw; j++){
            if (b & 0x80){
              px = j+dx;
              if (gx <= px && px < gx2){
                unsigned short* bf = (unsigned short*)&buf[ptr2];
                *bf = (unsigned short)val;
              }
            }
            b <<= 1;
            if (!((j+1) % 8)){
              ptr++;
              b = *ptr;
            }
            ptr2 += bytes;
          }
        }
      }
    }else{
      for(i=0; i<dh; i++){
        py = i+dy;
        if (gy <= py && py < gy2){
          ptr = &bmp[i*val1];
          b = *ptr;
          int ptr2 = (int)(offset + row_bytes * i);
          for(j=0; j<dw; j++){
            if (b & 0x80){
              px = j+dx;
              if (gx <= px && px < gx2){
                if (_check_raw_point_ex_only(gid,px,py)){
                  unsigned short* bf = (unsigned short*)&buf[ptr2];
                  *bf = (unsigned short)val;
                }
              }
            }
            b <<= 1;
            if (!((j+1) % 8)){
              ptr++;
              b = *ptr;
            }
            ptr2 += bytes;
          }
        }
      }
    }
  }else
  if (depth == 8){
    for(i=0; i<dh; i++){
      py = i+dy;
      if (gy <= py && py < gy2){
        ptr = &bmp[i*val1];
        b = *ptr;
        int ptr2 = (int)(offset + row_bytes * i);
        for(j=0; j<dw; j++){
          if (b & 0x80){
            px = j+dx;
            if (gx <= px && px < gx2){
              if (check == False || _check_raw_point_ex_only(gid,px,py)){
                unsigned char* bf = (unsigned char*)&buf[ptr2];
                *bf = (unsigned char)val;
              }
            }
          }
          b <<= 1;
          if (!((j+1) % 8)){
            ptr++;
            b = *ptr;
          }
          ptr2 += bytes;
        }
      }
    }
  }
  return WS_NO_ERR;
}
inline int _draw_bitmap(int gid,short dx,short dy,
               unsigned short dw,unsigned short dh,
               unsigned int fg,unsigned char* bmp){
//  if (check_gid(gid) != WS_NO_ERR){
//    return WS_ERR_GID;
//  }
  int i,j;
  unsigned char a2 =  fg >> 24;
  unsigned char r2 =  fg >> 16;
  unsigned char g2 =  fg >> 8;
  unsigned char b2 =  fg;
  for(i=0; i<dh; i++){
    unsigned char* ptr = &bmp[i*((dw+7)/8)];
    unsigned char b = *ptr;
    for(j=0; j<dw; j++){
      if (_check_raw_point(gid,j+dx,i+dy)){
        if (b & 0x80){
          _draw_point(gid,j+dx,i+dy,r2,g2,b2,a2);
        }
      }
      b <<= 1;
      if (!((j+1) % 8)){
        ptr++;
        b = *ptr;
      }
    }
  }
  return WS_NO_ERR;
}


inline int _draw_string(int gid,WSDdeviceFontList* fl, short dx,short dy,
               unsigned int fg,WSCushort* str,int nchars){
  if (fl == NULL){
    return WS_ERR;
  }
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  //TODO: draw rectangle..
//  int row_bytes = _gc_list[gid-1]._row_bytes;

//  long dev_x = _gc_list[gid-1]._x;
//  long dev_y = _gc_list[gid-1]._x;
//  unsigned long dev_w = _gc_list[gid-1]._w;
//  unsigned long dev_h = _gc_list[gid-1]._h;

  long x,y;
//  unsigned long w,h;
//  WSMFandArea(dx,dy,32767,32767,dev_x,dev_y,dev_w,dev_h,
//              &x,&y,&w,&h);
  x = dx;
  y = dy;

//printf("draw_string x,y,w,h=%d,%d nchars=%d\n",dx,dy,nchars);
  unsigned int val = _get_col_value(&_gc_list[gid-1],fg);
  unsigned int alpha = _get_col_alpha(gid,fg);
  WSCushort* sptr = 0;
  int width = 0;
  int height = 0;
//  int len = 0;
  WSCushort c;
  int code = 0;
  WSDdeviceFont* f = 0;

  if(nchars < 0){
    nchars = WSGFstrlenUCS2(str);
  }
  sptr = str;
  int i;
  int* font_order = fl->getFontOrder();
//printf("_draw_string! nchars=%d\n",nchars);
  for(i = 0; i < nchars; i++) {
    if(i == nchars) {
      code = WS_FONT_NONE;
    } else {
      c = *sptr;
extern int WSGFdeviceQueryChar(unsigned short*,int*);
      code = WSGFdeviceQueryChar(&c,font_order);
    }
//printf("font_order %d,%d,%d\n",font_order[0],font_order[1],font_order[2]);
//printf("code=%d c=0x%x c=#%c# fl=0x%x\n",code,c,c,fl);
//fflush(stdout);
    if (f != NULL && f->_font_encode == code){
      //use same font..
    }else{
      f = fl->getFont(code);
      if(!f){
        f = fl->getFont(WS_FONT_ISO8859(1));
      }
    }
    if (f != NULL){
      height = f->_height;
      WSDdeviceFontGlyph* fgr = f->getFontGlyph(c);
//printf("c=%d 0x%x charcode=%d\n",c,c,fgr->_char_code);
      if (fgr != NULL){
        width = fgr->_width;
//printf("width=%d\n",width);
        if (alpha == 0xff){
          _draw_raw_bitmap(gid,x,dy - f->_height,width,height,val,fgr->_data);
        }else{
          _draw_bitmap(gid,x,dy - f->_height,width,height,fg,fgr->_data);
        }
      }else{
        width = f->_width;
//printf("_draw_string ->2 _draw_rect! w,h=%d,%d\n",width,height);
        _draw_rect(gid,x,dy - f->_height,width,height,fg);
      }
      x += width+1;
    }
    sptr++;
  }
  long diff = x - dx;
  _gc_list[gid-1]._draw_pt_x += diff;

  return WS_NO_ERR;
}
int _get_string_width(int gid,WSDdeviceFontList* fl,WSCushort* str,int nchars){
  if (fl == NULL){
    return WS_ERR;
  }
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  //TODO: draw rectangle..

  long dx = 0;

  WSCushort* sptr = 0;
  int width = 0;
//  int height = 0;
//  int len = 0;
  WSCushort c;
  int code = 0;
  WSDdeviceFont* f;

  if(nchars < 0){
    nchars = WSGFstrlenUCS2(str);
  }
  sptr = str;
  int i;
  int* font_order = fl->getFontOrder();
//printf("_draw_string! nchars=%d\n",nchars);
  for(i = 0; i < nchars; i++) {
    if(i == nchars) {
      code = WS_FONT_NONE;
    } else {
      c = *sptr;
extern int WSGFdeviceQueryChar(unsigned short*,int*);
      code = WSGFdeviceQueryChar(&c,font_order);
    }
    f = fl->getFont(code);
    if(!f){
      f = fl->getFont(WS_FONT_ISO8859(1));
    }
//    height = f->_height;
    if (f != NULL){
      WSDdeviceFontGlyph* fgr = f->getFontGlyph(c);
      if (fgr != NULL){
        width = fgr->_width;
      }else{
        width = f->_width;
      }
      dx += width+1;
    }
    sptr++;
  }
  return dx;
}
int _draw_window(int wid,short x,short y,unsigned short w,unsigned short h){
  if (check_wid(wid) != WS_NO_ERR){
//printf("draw_window err return..\n");
    return WS_ERR_WID;
  }
  int gid = _window_list[wid-1]._gc;
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
//  int dx = x + _window_list[wid-1]._x;
//  int dy = y + _window_list[wid-1]._y;
  int bg = _window_list[wid-1]._bg_color;
//  return _draw_fill_rect(gid,dx,dy,w,h,bg);
  return _draw_fill_rect(gid,x,y,w,h,bg);
}

int _add_expose_event(int wid,short x,short y,unsigned short w,unsigned short h){
  WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
//  WSDdeviceEventList* evtl = new WSDdeviceEventList();
  WSDdeviceEvent* evt = &(evtl->_event);
  evt->r.type = EV_REQUEST;
  evt->r.r.c.left = x;
  evt->r.r.c.top = y;
  evt->r.r.c.right = x+w;
  evt->r.r.c.bottom = y+h;
  evt->r.cmd = W_REDISP;
  evt->r.wid = wid;
//printf("add_expose_event.. draw_window=%d %d,%d,%d,%d\n",wid,x,y,w,h);
  _draw_window(wid,x,y,w,h);
//printf("add_expose_event..\n");
  WSMFdeviceSemLock(_event_sem_id);
  _add_event(evtl);
  WSMFdeviceSemUnlock(_event_sem_id);
//printf("add_expose_event.. draw_window=%d %d,%d,%d,%d\n",wid,_window_list[wid-1]._x, _window_list[wid-1]._y, _window_list[wid-1]._w, _window_list[wid-1]._h);

  _update_frame_buffer(_window_list[wid-1]._x, _window_list[wid-1]._y,
                        _window_list[wid-1]._w, _window_list[wid-1]._h);
  return WS_NO_ERR;
}
int _create_expose_event(int wid){
  //TODO: optimize!!..
  _add_expose_event(wid,_window_list[wid-1]._x, _window_list[wid-1]._y,
                        _window_list[wid-1]._w, _window_list[wid-1]._h);
  return WS_NO_ERR;
}
int WSGFdeviceGetNewWindow(unsigned int attr,unsigned int parent,
                          short x, short y, unsigned short w,unsigned short h,
                          unsigned int bg){
TIME_TRACE("WSGFdeviceGetNewWindow() start");
  if ( parent < 0 || WS_MAX_WINDOW < parent){
//printf("WSGFdeviceGetNewWindow(): bad param: parent\n");
    return WS_ERR_WID;
  }
  WSMFdeviceSemLock(_sem_id);
  int i;
  for(i=0; i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._window_id == 0){
      _window_list[i]._window_id = i+1;
      _window_list[i]._attr = attr;
      _window_list[i]._bg_color = bg;
      _window_list[i]._x = x;
      _window_list[i]._y = y;
      _window_list[i]._w = w;
      _window_list[i]._h = h;
      _window_list[i]._user_data = NULL;
      _window_list[i]._title_string = NULL;
      _window_list[i]._stack_no = 1;
      _window_list[i]._parent_window_id = parent; 
      _window_list[i]._status = WS_DEVICE_NEED_EXPOSE;
#ifndef TE
      _window_list[i]._pid = getpid();
#else
      _window_list[i]._pid = prc_sts(0,NULL,NULL);
#endif
      _device_insert_window(parent,i+1);
      WSMFdeviceSemUnlock(_sem_id);
      int gc = WSGFdeviceGetNewGC(x,y,w,h,_device_depth,
                         _device_row_bytes,NULL,
                         _device_start_red,
                         _device_start_green,
                         _device_start_blue,
                         _device_red_bits,
                         _device_green_bits,
                         _device_blue_bits);

      WSMFdeviceSemLock(_sem_id);
      if (check_wid(i+1) != WS_NO_ERR){
        WSMFdeviceSemUnlock(_sem_id);
        return WS_ERR_NOSPC;
      }
      if (check_gid(gc) != WS_NO_ERR){
        WSMFdeviceSemUnlock(_sem_id);
        return WS_ERR_NOSPC;
      }
      _window_list[i]._gc = gc;
      _gc_list[gc-1]._window_id = i+1;
      if (_create_window_handler != NULL){
        _create_window_handler(&_window_list[i]);
      }
//printf("GetNewWindow wid=%d %d,%d,%d,%d\n",i+1,x,y,w,h);
      _add_expose_event(i+1,x,y,w,h);

      WSMFdeviceSemUnlock(_sem_id);

//#if defined LINUX || defined USE_X11
#ifndef NO_THREAD
      _wake_up_event();
//      pthread_sem_unlock_np(&_event_sem);
#endif
//#endif
//printf("GetNewWindow wid=%d gid=%d\n",i+1,gc);
TIME_TRACE("WSGFdeviceGetNewWindow()1 done");
      return i+1;

    }
  }

  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceGetNewWindow()2 done");
  return WS_ERR_NOSPC;
}

int _destroy_gc(int gid){
//printf("_destroy_gc gid=%d\n",gid);
  if (_gc_list[gid-1]._ex_region_list != NULL){
    delete _gc_list[gid-1]._ex_region_list;
    _gc_list[gid-1]._ex_region_list = NULL;
    _gc_list[gid-1]._ex_region_list_num = 0;
  }
  if (_gc_list[gid-1]._visible_region_list != NULL){
    delete _gc_list[gid-1]._visible_region_list;
    _gc_list[gid-1]._visible_region_list = NULL;
    _gc_list[gid-1]._visible_region_list_num = 0;
  }
  _gc_list[gid-1]._gid = 0;
//printf("_destroy_gc gid=%d done.\n",gid);
  return WS_NO_ERR;
}

int WSGFdeviceDestroyWindow(int wid){
TIME_TRACE("WSGFdeviceDestroyWindow() start");
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  if (_destroy_window_handler != NULL){
    _destroy_window_handler(&_window_list[wid -1]);
  }
  short x,y;
  unsigned short w,h;
  x = _window_list[wid -1]._x;
  y = _window_list[wid -1]._y;
  w = _window_list[wid -1]._w;
  h = _window_list[wid -1]._h;

  _window_list[wid -1]._window_id = 0;
  if ( _window_list[wid -1]._title_string != NULL){
    free(_window_list[wid -1]._title_string);
    _window_list[wid -1]._title_string = NULL;
  }
  int stack_no = _window_list[wid-1]._stack_no;

  int gid = _window_list[wid-1]._gc;
  _destroy_gc(gid);
  _window_list[wid-1]._gc = 0;

  int i;
  for(i=0; i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._window_id != 0 &&
        _window_list[i]._stack_no > stack_no){
      _window_list[i]._stack_no--;
      long dx,dy;
      unsigned long dw,dh;
      long tx,ty;
      unsigned long tw,th;
      dx = _window_list[i]._x;
      dy = _window_list[i]._y;
      dw = _window_list[i]._w;
      dh = _window_list[i]._h;
      if ( WSMFandArea(x,y,w,h,dx,dy,dw,dh,&tx,&ty,&tw,&th) == WS_NO_ERR){
        _add_expose_event(i+1,tx,ty,tw,th);
      }
//      _create_expose_event(i+1);
    }
  }
  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDestroyWindow() done");
  return WS_NO_ERR;
}

int WSGFdeviceMoveWindow(int wid,short x,short y){
TIME_TRACE("WSGFdeviceMoveWindow() start");
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceMoveWindow() done");
    return WS_ERR_WID;
  }
  _window_list[wid-1]._x = x;
  _window_list[wid-1]._y = y;
  if (_update_window_handler != NULL){
    _update_window_handler(&_window_list[wid-1]);
  }

  long stack_no =  _window_list[wid -1]._stack_no;
  int i;
  for(i=0; i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._window_id != 0 &&
        _window_list[i]._stack_no < stack_no){
      _window_list[i]._status = WS_DEVICE_NEED_EXPOSE;
      _create_expose_event(i+1);
    }
  } 
  WSMFdeviceSemUnlock(_sem_id);
#ifndef NO_THREAD
  _wake_up_event();
#endif
TIME_TRACE("WSGFdeviceMoveWindow() done");
  return WS_NO_ERR;
}

int WSGFdeviceResizeWindow(int wid,unsigned short w,unsigned short h){
TIME_TRACE("WSGFdeviceResizeWindow() start");
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceResizeWindow() done");
    return WS_ERR_WID;
  }
  long stack_no =  _window_list[wid -1]._stack_no;
//  int cnt = 0;
  if (_window_list[wid -1]._w < w  ||
      _window_list[wid -1]._h < h){
    int i;
    for(i=0; i<WS_MAX_WINDOW; i++){
      if (_window_list[i]._window_id != 0 &&
          _window_list[i]._stack_no < stack_no){
        _window_list[i]._status = WS_DEVICE_NEED_EXPOSE;
        _create_expose_event(i+1);
//        cnt++;
      }
    } 
  }else{
    _window_list[wid -1]._status = WS_DEVICE_NEED_EXPOSE;
    _create_expose_event(wid);
//    cnt++;
  }
  _window_list[wid -1]._w = w;
  _window_list[wid -1]._h = h;
  if (_update_window_handler != NULL){
    _update_window_handler(&_window_list[wid-1]);
  }

  WSMFdeviceSemUnlock(_sem_id);
//#if defined LINUX || defined USE_X11
#ifndef NO_THREAD
  _wake_up_event();
//  int i;
//  for(i=0; i<cnt;i++){
//    pthread_sem_unlock_np(&_event_sem);
//  }
#endif
//#endif
TIME_TRACE("WSGFdeviceResizeWindow() done");
  return WS_NO_ERR;
}


int WSGFdeviceGetWindowPosition(int wid,short* x,short* y){
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  *x = _window_list[wid -1]._x;
  *y = _window_list[wid -1]._y;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int _WSGFdeviceGetWindowPosition(int wid,short* x,short* y){
  if (check_wid(wid) != WS_NO_ERR){
    return WS_ERR_WID;
  }
  *x = _window_list[wid -1]._x;
  *y = _window_list[wid -1]._y;
  return WS_NO_ERR;
}

int WSGFdeviceGetWindowSize(int wid,unsigned short* w,unsigned short* h){
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  *w = _window_list[wid -1]._w;
  *h = _window_list[wid -1]._h;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int _WSGFdeviceGetWindowSize(int wid,unsigned short* w,unsigned short* h){
  if (check_wid(wid) != WS_NO_ERR){
    return WS_ERR_WID;
  }
  *w = _window_list[wid -1]._w;
  *h = _window_list[wid -1]._h;
  return WS_NO_ERR;
}



int WSGFdeviceGetWindowStatus(int wid,unsigned int* status){
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  *status = _window_list[wid -1]._status;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int _WSGFdeviceGetWindowStatus(int wid,unsigned int* status){
  if (check_wid(wid) != WS_NO_ERR){
    return WS_ERR_WID;
  }
  *status = _window_list[wid -1]._status;
  return WS_NO_ERR;
}

int WSGFdeviceSetWindowStatus(int wid,unsigned int status){
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  _window_list[wid -1]._status = status;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int _WSGFdeviceSetWindowStatus(int wid,unsigned int status){
  if (check_wid(wid) != WS_NO_ERR){
    return WS_ERR_WID;
  }
  _window_list[wid -1]._status = status;
  return WS_NO_ERR;
}

int WSGFdeviceSetWindowTitle(int wid,unsigned short* title){
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  if ( _window_list[wid -1]._title_string != NULL){
    free(_window_list[wid -1]._title_string);
  }

  _window_list[wid -1]._title_string = WSGFstrdupUCS2(title);
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int WSGFdeviceSetWindowColor(int wid,unsigned int color){
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  _window_list[wid -1]._bg_color = color;
  _window_list[wid -1]._status = WS_DEVICE_NEED_EXPOSE;
  _create_expose_event(wid);
  WSMFdeviceSemUnlock(_sem_id);
//#if defined LINUX || defined USE_X11
#ifndef NO_THREAD
  _wake_up_event();
//  pthread_sem_unlock_np(&_event_sem);
#endif
//#endif
  return WS_NO_ERR;
}

void _adjust_stack_no(){
  int i;
  int stack_no = 0;
  int stack_wid = 0;
  for(i=0;i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._window_id > 0 &&
        _window_list[i]._stack_no > 0){
      if (stack_no > _window_list[i]._stack_no){
        stack_no = _window_list[i]._stack_no;
        stack_wid = _window_list[i]._window_id;
      }
    }
  }
  int diff = 0;
  if (stack_no > 1){
    diff = stack_no -1;
    for(i=0;i<WS_MAX_WINDOW; i++){
      if (_window_list[i]._window_id > 0 &&
          _window_list[i]._stack_no > 0){
        _window_list[i]._stack_no -= diff;
      }
    }
  }
}

int WSGFdeviceGetActiveWindow(int* wid){
  WSMFdeviceSemLock(_sem_id);
  if (wid == NULL){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_ADR;
  }
  _adjust_stack_no();
  int i;
//  int stack_no = 0;
//  int stack_wid = 0;
  int target = 0;
  for(i=0;i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._window_id > 0 &&
        _window_list[i]._stack_no == 1){
      target = _window_list[i]._window_id;
    }
  }
  WSMFdeviceSemUnlock(_sem_id);
  if (target == 0){
    return WS_ERR_ADR;
  }
  *wid = target;
  return WS_NO_ERR;
}

int _WSGFdeviceGetActiveWindow(int* wid){
  if (wid == NULL){
    return WS_ERR_ADR;
  }
  _adjust_stack_no();
  int i;
//  int stack_no = 0;
//  int stack_wid = 0;
  int target = 0;
  for(i=0;i<WS_MAX_WINDOW; i++){
    if (_window_list[i]._window_id > 0 &&
        _window_list[i]._stack_no == 1){
      target = _window_list[i]._window_id;
    }
  }
  if (target == 0){
    return WS_ERR_ADR;
  }
  *wid = target;
  return WS_NO_ERR;
}
int WSGFdeviceGetWindowOwner(int wid,int* pid){
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  *pid = _window_list[wid -1]._pid;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int _WSGFdeviceGetWindowOwner(int wid,int* pid){
  if (check_wid(wid) != WS_NO_ERR){
    return WS_ERR_WID;
  }
  *pid = _window_list[wid -1]._pid;
  return WS_NO_ERR;
}

int WSGFdeviceSetWindowData(int wid,void* val){
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  _window_list[wid -1]._user_data = val;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int WSGFdeviceGetWindowData(int wid,void** val){
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  *val = _window_list[wid -1]._user_data;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

int WSGFdeviceGetNextEvent(WSDdeviceEvent* evt,unsigned int mode){
TIME_TRACE("WSGFdeviceGetNextEvent() start");
//#if defined LINUX || defined USE_X11 
#ifndef NO_THREAD
//printf("WSGFdeviceGetNextEvent() mode=0x%x\n",mode);
  if ((mode & NOWAIT) == 0){
    _wait_event();
//    pthread_sem_lock_np(&_event_sem);
  }
#endif
//#endif

  WSMFdeviceSemLock(_event_sem_id);
  WSDdeviceEvent wsevt;
  int ret = _get_event(&wsevt,mode);
  if (ret != WS_NO_ERR){
    WSMFdeviceSemUnlock(_event_sem_id);
TIME_TRACE("WSGFdeviceGetNextEvent()1 done");
    return EV_NOMSG;
  }
  memcpy(evt,&wsevt,sizeof(WSDdeviceEvent));
  WSMFdeviceSemUnlock(_event_sem_id);
//printf("WSGFdeviceGetNextEvent ret a msg evt=%d wnd=%d cmd=%d\n",evt->r.type,evt->r.wid,evt->r.cmd);
TIME_TRACE("WSGFdeviceGetNextEvent()2 done");
  return evt->r.type;
}

int WSGFdeviceGetNewGC(short x,short y,
                       unsigned short w, unsigned short h,
                       unsigned int depth, unsigned short row_bytes,
                       unsigned char* buf,
                       unsigned int start_red,
                       unsigned int start_green,
                       unsigned int start_blue,
                       unsigned int red_bits,
                       unsigned int green_bits,
                       unsigned int blue_bits){
//printf("WSGFdeviceGetNewGC %d,%d,%d,%d,%d,%d\n",start_red,start_green,start_blue,red_bits,green_bits,blue_bits);
TIME_TRACE("WSGFdeviceGetNewGC() start");
  WSMFdeviceSemLock(_sem_id);
  int i;
  for(i=0; i<WS_MAX_GC; i++){
    if (_gc_list[i]._gid == 0){
      _gc_list[i]._gid = i+1;
      _gc_list[i]._x = x;
      _gc_list[i]._y = y;
      _gc_list[i]._w = w;
      _gc_list[i]._h = h;
      _gc_list[i]._fg_color = _default_black_color;
      _gc_list[i]._bg_color = _default_white_color;
      _gc_list[i]._lw = 1;
      _gc_list[i]._ld_type = LN_SOLID;
      _gc_list[i]._start_red = start_red;
      _gc_list[i]._start_green = start_green;
      _gc_list[i]._start_blue = start_blue;
      _gc_list[i]._red_bits = red_bits;
      _gc_list[i]._green_bits = green_bits;
      _gc_list[i]._blue_bits = blue_bits;
      _gc_list[i]._buf = buf;
      _gc_list[i]._depth = depth;
      _gc_list[i]._ex_region_list = NULL;
      _gc_list[i]._visible_region_list = NULL;
      _gc_list[i]._ex_region_list_num = 0;
      _gc_list[i]._visible_region_list_num = 0;
      _gc_list[i]._window_id = 0;
      _gc_list[i]._updated = 0;
//printf(">>CreateNewGC gid=%d depth=%d buf=0x%x\n",i+1,depth,buf);
//fflush(stdout);
      _gc_list[i]._row_bytes = row_bytes;
      WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceGetNewGC()1 done");
      return i+1;
    }
  }
  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceGetNewGC()2 done");
  return -1;
}



int WSGFdeviceGetWindowGC(int wid){
  WSMFdeviceSemLock(_sem_id);
  if (check_wid(wid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  int gid = _window_list[wid-1]._gc;
  WSMFdeviceSemUnlock(_sem_id);
  return gid;
}

int _WSGFdeviceGetWindowGC(int wid){
  if (check_wid(wid) != WS_NO_ERR){
    return WS_ERR_WID;
  }
  int gid = _window_list[wid-1]._gc;
  return gid;
}



int WSGFdeviceGetGCWindow(int gid){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_WID;
  }
  int wid = _gc_list[gid-1]._window_id;
  WSMFdeviceSemUnlock(_sem_id);
  return wid;
}

int _WSGFdeviceGetGCWindow(int gid){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_WID;
  }
  return _gc_list[gid-1]._window_id;
}

//TODO: need optimize for gid...
int WSGFdeviceFlushGC(int gid){
TIME_TRACE("WSGFdeviceFlushGC() start");
  int x = _gc_list[gid-1]._x;
  int y = _gc_list[gid-1]._y;
  unsigned int w = _gc_list[gid-1]._w;
  unsigned int h = _gc_list[gid-1]._h;
  int ret =  _update_frame_buffer(x,y,w,h);
TIME_TRACE("WSGFdeviceFlushGC() done");
  return  ret;
}
int WSGFdeviceDrawLine(int gid,short x1,short y1,short x2,short y2,
                       unsigned int fg,int lw,int type){
TIME_TRACE("WSGFdeviceDrawLine() start");
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawLine()1 done");
    return WS_ERR_GID;
  }
  _graphics_context* gcptr = &_gc_list[gid-1];
  gcptr->_lw = lw;
  gcptr->_ld_type = type;
  int dx1 = x1 + gcptr->_x;
  int dx2 = x2 + gcptr->_x;
  int dy1 = y1 + gcptr->_y;
  int dy2 = y2 + gcptr->_y;
  unsigned int val = _get_col_value(gcptr,fg);
  unsigned int alpha = _get_col_alpha(gid,fg);
  if (alpha == 0xff){
    if (dy1 == dy2){
      _draw_line2_h(gid, dx1,dy1,dx2,val);
    }else
    if (dx1 == dx2){
      _draw_line2_v(gid, dx1,dy1,dy2,val);
    }else{
      _draw_line2_slash(gid, dx1,dy1,dx2,dy2,val,fg);
    }
  }else{
    _draw_line2(gid, dx1,dy1,dx2,dy2,val,alpha,fg);
  }
  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawLine()2 done");
  return WS_NO_ERR;
}
#ifndef NO_DRAW_RECT
int WSGFdeviceDrawRect(int gid,short x,short y,
                       unsigned short w, unsigned short h,
                       unsigned int bg,int lw,int type){
TIME_TRACE("WSGFdeviceDrawRect() start");
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawRect()1 done");
    return WS_ERR_GID;
  }
  _graphics_context* gcptr = &_gc_list[gid-1];
  int dx = x + gcptr->_x;
  int dy = y + gcptr->_y;
  gcptr->_lw = lw;
  gcptr->_ld_type = type;
//printf("WSGFdeviceDrawRect gid=%d x,y,w,h=%d,%d,%d,%d dx,dy=%d,%d\n",gid,x,y,w,h,dx,dy);
  unsigned int val = _get_col_value(gcptr,bg);
  unsigned int alpha = _get_col_alpha(gid,bg);
  if (alpha == 0xff){
    _draw_line2_h(gid,dx,dy,dx + w-1,val);
    _draw_line2_v(gid,dx,dy,dy + h-1,val);
    _draw_line2_v(gid,dx + w-1 ,dy,dy + h-1,val);
    _draw_line2_h(gid,dx ,dy + h-1,dx + w-1,val);
  }else{
    _draw_line2(gid,dx,dy,dx + w-1,dy,val,alpha,bg);
    _draw_line2(gid,dx,dy,dx,dy + h-1,val,alpha,bg);
    _draw_line2(gid,dx + w-1 ,dy,dx + w-1,dy + h-1,val,alpha,bg);
    _draw_line2(gid,dx ,dy + h-1,dx + w-1,dy + h-1,val,alpha,bg);
  }
//  _draw_rect(gid,dx,dy,w,h,bg);
  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawRect()2 done");
  return WS_NO_ERR;
}
#endif
#ifndef NO_DRAW_POLY
int WSGFdeviceDrawPolygon(int gid,WSCpoint* point,int num, unsigned int fg,int lw,int type){
TIME_TRACE("WSGFdeviceDrawPolygon() start");
  if (num < 2){
TIME_TRACE("WSGFdeviceDrawPolygon()1 done");
    return WS_ERR_PAR;
  }
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawPolygon()2 done");
    return WS_ERR_GID;
  }
  _graphics_context* gcptr = &_gc_list[gid-1];
  gcptr->_lw = lw;
  gcptr->_ld_type = type;
  unsigned int val = _get_col_value(gcptr,fg);
  unsigned int alpha = _get_col_alpha(gid,fg);
  int i;
  for(i=0; i<num-1; i++){
    short x1 = point[i].x + gcptr->_x;
    short y1 = point[i].y + gcptr->_y;
    short x2 = point[i+1].x + gcptr->_x;
    short y2 = point[i+1].y + gcptr->_y;
    _draw_line2(gid,x1,y1,x2,y2,val,alpha,fg);
  }
  if (num > 2){
    short x1 = point[0].x + gcptr->_x;
    short y1 = point[0].y + gcptr->_y;
    short x2 = point[num-1].x + gcptr->_x;
    short y2 = point[num-1].y + gcptr->_y;
    _draw_line2(gid,x1,y1,x2,y2,val,alpha,fg);
  }
  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawPolygon()3 done");
  return WS_NO_ERR;
}
#endif
#ifndef NO_DRAW_ARC
int WSGFdeviceDrawArc( int gid,short x,short y,unsigned short w,unsigned short h,
                int a1,int a2,unsigned int fg,int lw,int type){
TIME_TRACE("WSGFdeviceDrawArc() start");
  if (a1 == a2){
TIME_TRACE("WSGFdeviceDrawArc()1 done");
    return WS_NO_ERR;
  }
  if (w == 0 || h== 0){
TIME_TRACE("WSGFdeviceDrawArc()2 done");
    return WS_NO_ERR;
  }
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawArc()3 done");
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._lw = lw;
  _gc_list[gid-1]._ld_type = type;
  short x1 = x + _gc_list[gid-1]._x;
  short y1 = y + _gc_list[gid-1]._y;
  int i;
  for(i=0; i < lw; i++){
    if (w -i*2< 1){
      break;
    }
    if (h -i*2< 1){
      break;
    }
    if (i==0){
      _gc_list[gid-1]._lw = 1;
    }else{
//      _gc_list[gid-1]._lw = lw;
      _gc_list[gid-1]._lw = 2;
    }
    _draw_arc(gid,x1+i,y1+i,w-i*2,h-i*2,a1,a2,False,WS_PI,fg);
  }

  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawArc()4 done");
  return WS_NO_ERR;
}
#endif
#ifndef  NO_DRAW_FILL_ARC
int WSGFdeviceDrawFillArc( int gid,short x,short y,unsigned short w,unsigned short h,
                int a1,int a2,int arctype,unsigned int bg){
TIME_TRACE("WSGFdeviceDrawFillArc() start");
  if (a1 == a2){
TIME_TRACE("WSGFdeviceDrawFillArc()1 done");
    return WS_NO_ERR;
  }
  if (w == 0 || h== 0){
TIME_TRACE("WSGFdeviceDrawFillArc()2 done");
    return WS_NO_ERR;
  }
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawFillArc()3 done");
    return WS_ERR_GID;
  }
  short x1 = x + _gc_list[gid-1]._x;
  short y1 = y + _gc_list[gid-1]._y;
  _draw_arc(gid,x1,y1,w,h,a1,a2,True,arctype,bg);

  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawFillArc()4 done");
  return WS_NO_ERR;
}
#endif
#ifndef NO_DRAW_FILL_POLY
int WSGFdeviceDrawFillPolygon(int gid,WSCpoint* point,int num, unsigned int bg,int rev){
TIME_TRACE("WSGFdeviceDrawFillPolygon() start");
  if (num < 2){
TIME_TRACE("WSGFdeviceDrawFillPolygon()1 done");
    return WS_ERR_PAR;
  }
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawFillPolygon()2 done");
    return WS_ERR_GID;
  }
  WSCpoint point2[num];
  int i;
  for(i=0; i<num; i++){
    point2[i].x = point[i].x + _gc_list[gid-1]._x;
    point2[i].y = point[i].y + _gc_list[gid-1]._y;
  }
  _draw_fill_poly(gid,point2,num,bg,rev,False);
  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawFillPolygon()3 done");
  return WS_NO_ERR;
}
#endif

int WSGFdeviceDrawString(int gid,short x,short y,
                       WSDdeviceFontList* fl,
                       unsigned int fg,WSCushort* str,int len){
TIME_TRACE("WSGFdeviceDrawString() start");
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawString()1 done");
    return WS_ERR_GID;
  }
  int dx = x + _gc_list[gid-1]._x;
  int dy = y + _gc_list[gid-1]._y;
//printf("WSGFdeviceDrawString gid=%d x,y=%d,%d dx,dy=%d,%d\n",gid,x,y,dx,dy);
  _draw_string(gid,fl,dx,dy,fg,str,len);
  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawString()2 done");
  return WS_NO_ERR;
}

int _WSGFdeviceDrawString(int gid,short x,short y,
                       WSDdeviceFontList* fl,
                       unsigned int fg,WSCushort* str,int len){
TIME_TRACE("WSGFdeviceDrawString() start");
  if (check_gid(gid) != WS_NO_ERR){
TIME_TRACE("WSGFdeviceDrawString()1 done");
    return WS_ERR_GID;
  }
  int dx = x + _gc_list[gid-1]._x;
  int dy = y + _gc_list[gid-1]._y;
//printf("WSGFdeviceDrawString gid=%d x,y=%d,%d dx,dy=%d,%d\n",gid,x,y,dx,dy);
  _draw_string(gid,fl,dx,dy,fg,str,len);
TIME_TRACE("WSGFdeviceDrawString()2 done");
  return WS_NO_ERR;
}


int WSGFdeviceGetStringWidth(int gid, WSDdeviceFontList* fl,
                       WSCushort* str,int len){
TIME_TRACE("WSGFdeviceGetStringWidth() start");
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceGetStringWidth()1 done");
    return WS_ERR_GID;
  }
  int ret = _get_string_width(gid,fl,str,len);
  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceGetStringWidth()2 done");
  return ret;
}

int WSGFdeviceDrawFillRect(int gid,short x,short y,
                       unsigned short w, unsigned short h,
                       unsigned int bg,int htype){
TIME_TRACE("WSGFdeviceDrawFillRect() start");
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawFillRect()1 done");
    return WS_ERR_GID;
  }
  _graphics_context* gcptr = &_gc_list[gid-1];
  gcptr->_hatch_type = htype;
//  int dx = x + gcptr->_x;
//  int dy = y + gcptr->_y;
  _draw_fill_rect(gid,x + gcptr->_x,y + gcptr->_y,w,h,bg);
  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceDrawFillRect()2 done");
  return WS_NO_ERR;
}
int WSGFdeviceGetDevSpec(int gid,DEV_SPEC* dsp){
  if (dsp == NULL){
    return WS_ERR_PAR;
  }
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  dsp->pixbits = (_gc_list[gid-1]._depth << 8)
                  + _gc_list[gid-1]._red_bits
                  + _gc_list[gid-1]._green_bits
                  + _gc_list[gid-1]._blue_bits;
//printf("gid=%d dsp->pixbits=0x%x\n",gid,dsp->pixbits);
  dsp->planes = 1;
  dsp->hpixels = _gc_list[gid-1]._w;
  dsp->vpixels = _gc_list[gid-1]._h;
  dsp->hres = 0;
  dsp->vres = 0;
  dsp->attr = 0x2001;
  dsp->color[0] = _gc_list[gid-1]._start_red << 8 |
                  _gc_list[gid-1]._red_bits;
  dsp->color[1] = _gc_list[gid-1]._start_green << 8 |
                  _gc_list[gid-1]._green_bits;
  dsp->color[2] = _gc_list[gid-1]._start_blue << 8 |
                  _gc_list[gid-1]._blue_bits;
  dsp->color[3] = 0;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int WSGFdeviceGetColorSpec(int gid,CSPEC* csp){
  if (csp == NULL){
    return WS_ERR_PAR;
  }
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  csp->attr = 0x01;
  csp->info[0] = _gc_list[gid-1]._start_red << 8 |
                  _gc_list[gid-1]._red_bits;
  csp->info[1] = _gc_list[gid-1]._start_green << 8 |
                  _gc_list[gid-1]._green_bits;
  csp->info[2] = _gc_list[gid-1]._start_blue << 8 |
                  _gc_list[gid-1]._blue_bits;
  csp->info[3] = 0;
  csp->colmap = NULL;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
int _get_rgb(int gid,unsigned char* buf,short x,short y,unsigned char* r,unsigned char* g,unsigned char* b){
  unsigned int depth =   _gc_list[gid-1]._depth;
  unsigned int start_red =   _gc_list[gid-1]._start_red;
  unsigned int start_green = _gc_list[gid-1]._start_green;
  unsigned int start_blue =  _gc_list[gid-1]._start_blue;
  unsigned int red_bits =    _gc_list[gid-1]._red_bits;
  unsigned int green_bits =  _gc_list[gid-1]._green_bits;
  unsigned int blue_bits =   _gc_list[gid-1]._blue_bits;
  unsigned int row_bytes =   _gc_list[gid-1]._row_bytes;

  if (depth == 32){
    unsigned int val = 0;
    unsigned int* ptr = (unsigned int*)&buf[y*row_bytes + x*depth/8];
    val = *ptr;
    *r = (val >> start_red) << (8 -red_bits);
    *g = (val >> start_green) << (8 -green_bits);
    *b = (val >> start_blue) << (8 -blue_bits);
  }else
  if (depth == 24){
    unsigned int val = 0;
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    val = (*ptr << 16);
    ptr++;
    val |= (*ptr << 8);
    ptr++;
    val |= *ptr;

    *r = (val >> start_red) << (8 -red_bits);
    *g = (val >> start_green) << (8 -green_bits);
    *b = (val >> start_blue) << (8 -blue_bits);

//printf("_get_rgb() need implement..\n");
//    long ptr = y*row_bytes + x*depth/8;
//    val = buf[ptr] << 16 | buf[ptr+1] << 8 | buf[ptr+2];
  }else
  if (depth == 16){
    unsigned short val = 0;
    unsigned short* ptr = (unsigned short*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned short)*ptr;
    *r = (val >> start_red) << (8 -red_bits);
    *g = (val >> start_green) << (8 -green_bits);
    *b = (val >> start_blue) << (8 -blue_bits);
  }else{
    unsigned char val = 0;
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned char)*ptr;
    *r = (val >> start_red) << (8 -red_bits);
    *g = (val >> start_green) << (8 -green_bits);
    *b = (val >> start_blue) << (8 -blue_bits);
  }
  return WS_NO_ERR;
}
int _get_raw_rgb(int gid,unsigned char* buf,short x,short y,unsigned int* v){
  unsigned int depth =   _gc_list[gid-1]._depth;
  unsigned int row_bytes =   _gc_list[gid-1]._row_bytes;
  unsigned int val = 0;
  if (depth == 32){
    unsigned int* ptr = (unsigned int*)&buf[y*row_bytes + x*depth/8];
    val = *ptr;
  }else
  if (depth == 24){
    unsigned int* ptr = (unsigned int*)&buf[y*row_bytes + x*depth/8];
    val = *ptr;
  }else
  if (depth == 16){
    unsigned short* ptr = (unsigned short*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned short)*ptr;
  }else{
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    val = (unsigned char)*ptr;
  }
  *v = val;
  return WS_NO_ERR;
}
int _set_rgb(int gid,unsigned char* buf,short x,short y,unsigned char r,unsigned char g,unsigned char b){

  unsigned int depth =   _gc_list[gid-1]._depth;
  unsigned int start_red =   _gc_list[gid-1]._start_red;
  unsigned int start_green = _gc_list[gid-1]._start_green;
  unsigned int start_blue =  _gc_list[gid-1]._start_blue;
  unsigned int red_bits =    _gc_list[gid-1]._red_bits;
  unsigned int green_bits =  _gc_list[gid-1]._green_bits;
  unsigned int blue_bits =   _gc_list[gid-1]._blue_bits;
  unsigned int row_bytes =   _gc_list[gid-1]._row_bytes;

  unsigned int val = 0;
  val |= (r >> (8-red_bits)) << start_red;
  val |= (g >> (8-green_bits)) << start_green;
  val |= (b >> (8-blue_bits)) << start_blue;

#ifdef ROTATE90
  if (buf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&buf[(_device_height-x-1)*row_bytes + y*depth/8];
      *ptr = val;
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&buf[(_device_height-x-1)*row_bytes + y*depth/8];
      *ptr = val;
    }else{
      unsigned char* ptr = (unsigned char*)&buf[(_device_height-x-1)*row_bytes + y*depth/8];
      *ptr = val;
    }
    _gc_list[gid-1]._updated = True;
    return WS_NO_ERR;
  }
#endif

#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned int*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned short*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }else{
      unsigned char* ptr = (unsigned char*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned char*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }
    _gc_list[gid-1]._updated = True;
    return WS_NO_ERR;
  }
#endif
  if (depth == 32){
    unsigned int* ptr = (unsigned int*)&buf[y*row_bytes + x*depth/8];
    *ptr = val;
  }else
  if (depth == 24){
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    *ptr++ = (val>> 16) & 0xff;
    *ptr++ = (val>> 8) & 0xff;
    *ptr++ = (val) & 0xff;
  }else
  if (depth == 16){
    unsigned short* ptr = (unsigned short*)&buf[y*row_bytes + x*depth/8];
    *ptr = (unsigned short)val;
  }else{
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    *ptr = (unsigned char)val;
  }
  _gc_list[gid-1]._updated = True;
  return WS_NO_ERR;
}

int _set_raw_rgb(int gid,unsigned char* buf,short x,short y,unsigned int val){

  unsigned int depth =   _gc_list[gid-1]._depth;
  unsigned int row_bytes =   _gc_list[gid-1]._row_bytes;
//printf("_set_raw_rgb start.\n");fflush(stdout);
#ifdef ROTATE90
  if (buf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&buf[(_device_height - x-1)*2*row_bytes + y*depth/8];
      *ptr = val;
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&buf[(_device_height - x-1)*2*row_bytes + y*depth/8];
      *ptr = val;
    }else{
      unsigned char* ptr = (unsigned char*)&buf[(_device_height - x-1)*2*row_bytes + y*depth/8];
      *ptr = val;
    }
    _gc_list[gid-1]._updated = True;
    return WS_NO_ERR;
  }
#endif
#ifdef DOUBLE_SCALE
  if (buf == _buffer){
    if (depth == 32){
      unsigned int* ptr = (unsigned int*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned int*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      unsigned short* ptr = (unsigned short*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned short*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }else{
      unsigned char* ptr = (unsigned char*)&buf[y*2*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
      ptr = (unsigned char*)&buf[(y*2+1)*row_bytes + x*2*depth/8];
      *ptr++ = val;
      *ptr++ = val;
    }
    _gc_list[gid-1]._updated = True;
    return WS_NO_ERR;
  }
#endif
  if (depth == 32){
    unsigned int* ptr = (unsigned int*)&buf[y*row_bytes + x*depth/8];
    *ptr = val;
  }else
  if (depth == 24){
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    *ptr++ = (unsigned char)((val >> 16) & 0xff);
    *ptr++ = (unsigned char)((val >> 8) & 0xff);
    *ptr++ = (unsigned char)((val ) & 0xff);
  }else
  if (depth == 16){
    unsigned short* ptr = (unsigned short*)&buf[y*row_bytes + x*depth/8];
    *ptr = (unsigned short)val;
  }else{
    unsigned char* ptr = (unsigned char*)&buf[y*row_bytes + x*depth/8];
    *ptr = (unsigned char)val;
  }
//printf("_set_raw_rgb done.\n");fflush(stdout);
  _gc_list[gid-1]._updated = True;
  return WS_NO_ERR;
}
int _copy_raw_rgb(int dgid,int sgid,short dx,short dy1,short sx,short sy1,unsigned int size,int reverse,int ph){
  unsigned int depth =   _gc_list[sgid-1]._depth;
  unsigned int row_bytes =   _gc_list[sgid-1]._row_bytes;
  unsigned char* sbuf = _gc_list[sgid-1]._buf;
  if (sbuf == NULL){
    sbuf = _buffer; 
  }

  unsigned int ddepth =   _gc_list[dgid-1]._depth;
  unsigned int drow_bytes =   _gc_list[dgid-1]._row_bytes;
  unsigned char* dbuf = _gc_list[dgid-1]._buf;
  if (dbuf == NULL){
    dbuf = _buffer;
  }
  int i;
  int inc = 1;
  int start = 0;
  int end = ph;
  if (reverse != False){
    inc = -1;
    start = ph -1;
    end = -1;
  }
#ifdef ROTATE90
  if (dbuf == _buffer){
    if (depth == 32){
      for(i=start; i != end; i+=inc){
        int dy = dy1 + i;
        int sy = sy1 + i;
        unsigned int* ptr = (unsigned int*)&sbuf[sy*row_bytes + sx*depth/8];
        int i;
        unsigned int* dptr;
        if (reverse == False){
          for(i=0; i<size; i++){
            dptr = (unsigned int*)&dbuf[(_device_height - dx - i-1)*drow_bytes + dy*ddepth/8];
            *dptr = *ptr++;
          }
        }else{
          for(i=size-1; i>-1; i--){
            dptr = (unsigned int*)&dbuf[(_device_height - dx - i-1)*drow_bytes + dy*ddepth/8];
            *dptr = *ptr++;
          }
        }
      }
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      for(i=start; i != end; i+=inc){
        int dy = dy1 + i;
        int sy = sy1 + i;
        unsigned short* ptr = (unsigned short*)&sbuf[sy*row_bytes + sx*depth/8];
        unsigned short* dptr;
        int i;
        if (reverse == False){
          for(i=0; i<size; i++){
            dptr = (unsigned short*)&dbuf[(_device_height - dx -i-1)*drow_bytes + dy*ddepth/8];
            *dptr = *ptr++;
          }
        }else{
          for(i=size-1; i>-1; i--){
            dptr = (unsigned short*)&dbuf[(_device_height - dx -i-1)*drow_bytes + dy*ddepth/8];
            *dptr = *ptr++;
          }
        }
      }
    }else{
      for(i=start; i != end; i+=inc){
        int dy = dy1 + i;
        int sy = sy1 + i;
        unsigned char* ptr = (unsigned char*)&sbuf[sy*row_bytes + sx*depth/8];
        unsigned char* dptr;
        int i;
        if (reverse == False){
          for(i=0; i<size; i++){
            dptr = (unsigned char*)&dbuf[(_device_height - dx -i-1)*drow_bytes + dy*ddepth/8];
            *dptr = *ptr++;
          }
        }else{
          for(i=size-1; i>-1; i--){
            dptr = (unsigned char*)&dbuf[(_device_height - dx -i-1)*drow_bytes + dy*ddepth/8];
            *dptr = *ptr++;
          }
        }
      }
    }
    _gc_list[dgid-1]._updated = True;
    return WS_NO_ERR;
  }
#endif

#ifdef DOUBLE_SCALE
  if (dbuf == _buffer){
    if (depth == 32){
      
      if (reverse == False){
        for(i=start; i != end; i+=inc){
          int dy = dy1 + i;
          int sy = sy1 + i;
          unsigned int* ptr = (unsigned int*)&sbuf[sy*row_bytes + sx*depth/8];
          unsigned int* dptr = (unsigned int*)&dbuf[dy*2*drow_bytes + dx*2*ddepth/8];
          unsigned int* dptr2 = (unsigned int*)&dbuf[(dy*2+1)*drow_bytes + dx*2*ddepth/8];
          int i;
          for(i=0; i<(int)size; i++){
            *dptr++ = *ptr;
            *dptr++ = *ptr;
            *dptr2++ = *ptr;
            *dptr2++ = *ptr++;
          }
        }
      }else{
        for(i=start; i != end; i+=inc){
          int dy = dy1 + i;
          int sy = sy1 + i;
          unsigned int* ptr = (unsigned int*)&sbuf[sy*row_bytes + sx*depth/8+size*4];
          unsigned int* dptr = (unsigned int*)&dbuf[dy*2*drow_bytes + dx*2*ddepth/8+size*4];
          unsigned int* dptr2 = (unsigned int*)&dbuf[(dy*2+1)*drow_bytes + dx*2*ddepth/8+size*4];
          int i;
          for(i=0; i<(int)size; i++){
            *dptr++ = *(--ptr);
            *dptr++ = *ptr;
            *dptr2++ = *ptr;
            *dptr2++ = *ptr;
          }
        }
      }
    }else
    if (depth == 24){
    }else
    if (depth == 16){
      if (reverse == False){
        for(i=start; i != end; i+=inc){
          int dy = dy1 + i;
          int sy = sy1 + i;
          unsigned short* ptr = (unsigned short*)&sbuf[sy*row_bytes + sx*depth/8];
          unsigned short* dptr = (unsigned short*)&dbuf[dy*2*drow_bytes + dx*2*ddepth/8];
          unsigned short* dptr2 = (unsigned short*)&dbuf[(dy*2+1)*drow_bytes + dx*2*ddepth/8];
          int i;
          for(i=0; i<(int)size; i++){
            *dptr++ = *ptr;
            *dptr++ = *ptr;
            *dptr2++ = *ptr;
            *dptr2++ = *ptr++;
          }
        }
      }else{
        for(i=start; i != end; i+=inc){
          int dy = dy1 + i;
          int sy = sy1 + i;
          unsigned short* ptr = (unsigned short*)&sbuf[sy*row_bytes + sx*depth/8+size*2];
          unsigned short* dptr = (unsigned short*)&dbuf[dy*2*drow_bytes + dx*2*ddepth/8+size*2];
          unsigned short* dptr2 = (unsigned short*)&dbuf[(dy*2+1)*drow_bytes + dx*2*ddepth/8+size*2];
          int i;
          for(i=0; i<(int)size; i++){
            *dptr++ = *(--ptr);
            *dptr++ = *ptr;
            *dptr2++ = *ptr;
            *dptr2++ = *ptr;
          }
        }
      }
    }else{
      if (reverse == False){
        for(i=start; i != end; i+=inc){
          int dy = dy1 + i;
          int sy = sy1 + i;
          unsigned char* ptr = (unsigned char*)&sbuf[sy*row_bytes + sx*depth/8];
          unsigned char* dptr = (unsigned char*)&dbuf[dy*2*drow_bytes + dx*2*ddepth/8];
          unsigned char* dptr2 = (unsigned char*)&dbuf[(dy*2+1)*drow_bytes + dx*2*ddepth/8];
          int i;
          for(i=0; i<(int)size; i++){
            *dptr++ = *ptr;
            *dptr++ = *ptr;
            *dptr2++ = *ptr;
            *dptr2++ = *ptr++;
          }
        }
      }else{
        for(i=start; i != end; i+=inc){
          int dy = dy1 + i;
          int sy = sy1 + i;
          unsigned char* ptr = (unsigned char*)&sbuf[sy*row_bytes + sx*depth/8+size];
          unsigned char* dptr = (unsigned char*)&dbuf[dy*2*drow_bytes + dx*2*ddepth/8+size];
          unsigned char* dptr2 = (unsigned char*)&dbuf[(dy*2+1)*drow_bytes + dx*2*ddepth/8+size];
          int i;
          for(i=0; i<(int)size; i++){
            *dptr++ = *(--ptr);
            *dptr++ = *ptr;
            *dptr2++ = *ptr;
            *dptr2++ = *ptr;
          }
        }
      }
    }
    _gc_list[dgid-1]._updated = True;
    return WS_NO_ERR;
  }
#endif
  long sx_offset = sx*depth/8;
  long dx_offset = dx*depth/8;
  if (depth == 32){
    long tsize = sizeof(unsigned int)*size;
    if (sgid == dgid){
      for(i=start; i != end; i+=inc){
        int dy = dy1 + i;
        int sy = sy1 + i;
        unsigned int* ptr = (unsigned int*)&sbuf[sy*row_bytes + sx_offset];
        unsigned int* dptr = (unsigned int*)&dbuf[dy*drow_bytes + dx_offset];
        memmove(dptr,ptr,tsize);
      }
    }else{
      for(i=start; i != end; i+=inc){
        int dy = dy1 + i;
        int sy = sy1 + i;
        unsigned int* ptr = (unsigned int*)&sbuf[sy*row_bytes + sx_offset];
        unsigned int* dptr = (unsigned int*)&dbuf[dy*drow_bytes + dx_offset];
        memcpy(dptr,ptr,tsize);
      } 
    }
  }else
  if (depth == 24){
    long tsize = sizeof(unsigned char)*size*3;
    if (sgid == dgid){
      for(i=start; i != end; i+=inc){
        int dy = dy1 + i;
        int sy = sy1 + i;
        unsigned char* ptr = (unsigned char*)&sbuf[sy*row_bytes + sx_offset];
        unsigned char* dptr = (unsigned char*)&dbuf[dy*drow_bytes + dx_offset];
        memmove(dptr,ptr,tsize);
      }
    }else{
      for(i=start; i != end; i+=inc){
        int dy = dy1 + i;
        int sy = sy1 + i;
        unsigned char* ptr = (unsigned char*)&sbuf[sy*row_bytes + sx_offset];
        unsigned char* dptr = (unsigned char*)&dbuf[dy*drow_bytes + dx_offset];
        memcpy(dptr,ptr,tsize);
      }
    }
  }else
  if (depth == 16){
    long tsize = sizeof(unsigned short)*size;
    unsigned char* ptr = (unsigned char*)&sbuf[(sy1+start)*row_bytes + sx_offset];
    unsigned char* dptr = (unsigned char*)&dbuf[(dy1+start)*drow_bytes + dx_offset];
    long diff = row_bytes*inc;
    long ddiff = drow_bytes*inc;
    if (sgid == dgid){
      for(i=start; i != end; i+=inc){
        memmove(dptr,ptr,tsize);
        ptr += diff;
        dptr += ddiff;
      }
#if 0
      for(i=start; i != end; i+=inc){
        int dy = dy1 + i;
        int sy = sy1 + i;
        unsigned short* ptr = (unsigned short*)&sbuf[sy*row_bytes + sx_offset];
        unsigned short* dptr = (unsigned short*)&dbuf[dy*drow_bytes + dx_offset];
        memmove(dptr,ptr,tsize);
      }
#endif
    }else{
      for(i=start; i != end; i+=inc){
        memcpy(dptr,ptr,tsize);
        ptr += diff;
        dptr += ddiff;
      }
#if 0
      for(i=start; i != end; i+=inc){
        int dy = dy1 + i;
        int sy = sy1 + i;
        unsigned short* ptr = (unsigned short*)&sbuf[sy*row_bytes + sx_offset];
        unsigned short* dptr = (unsigned short*)&dbuf[dy*drow_bytes + dx_offset];
        memcpy(dptr,ptr,tsize);
      }
#endif
    }
  }else{
    long tsize = sizeof(unsigned char)*size;
    if (sgid == dgid){
      for(i=start; i != end; i+=inc){
        int dy = dy1 + i;
        int sy = sy1 + i;
        unsigned char* ptr = (unsigned char*)&sbuf[sy*row_bytes + sx_offset];
        unsigned char* dptr = (unsigned char*)&dbuf[dy*drow_bytes + dx_offset];
        memmove(dptr,ptr,tsize);
      }
    }else{
      for(i=start; i != end; i+=inc){
        int dy = dy1 + i;
        int sy = sy1 + i;
        unsigned char* ptr = (unsigned char*)&sbuf[sy*row_bytes + sx_offset];
        unsigned char* dptr = (unsigned char*)&dbuf[dy*drow_bytes + dx_offset];
        memcpy(dptr,ptr,tsize);
      }
    }
  }
  _gc_list[dgid-1]._updated = True;
  return WS_NO_ERR;
}



int WSGFdeviceBitBlt(int sgid,short x,short y,
                       unsigned short w,unsigned short h,
                       int dgid,short dx,short dy,
                       unsigned int mode){
TIME_TRACE("WSGFdeviceBitBlt() start");
  mode &= 0xf;
dbprintf("WSGFdeviceBitBlt sgid=%d dgid=%d %d,%d,%d,%d->%d,%d\n",sgid,dgid,x,y,w,h,dx,dy);
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(sgid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceBitBlt()1 done");
dbprintf("WSGFdeviceBitBlt sgid=%d dgid=%d sgid is invarid\n",sgid,dgid);
    return WS_ERR_GID;
  }
  if (check_gid(dgid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceBitBlt()2 done");
dbprintf("WSGFdeviceBitBlt sgid=%d dgid=%d dgid is invarid\n",sgid,dgid);
    return WS_ERR_GID;
  }
  int reverse = False;
  if (sgid == dgid && ((x + w*y) < (dx + w*dy))){
    reverse = True;
  }
  _graphics_context* sgc = &_gc_list[sgid-1];
  _graphics_context* dgc = &_gc_list[dgid-1];

  x += sgc->_x;
  y += sgc->_y;
  dx += dgc->_x;
  dy += dgc->_y;
  unsigned int s_start_red =   sgc->_start_red;
  unsigned int s_start_green = sgc->_start_green;
  unsigned int s_start_blue =  sgc->_start_blue;
  unsigned int s_red_bits =    sgc->_red_bits;
  unsigned int s_green_bits =  sgc->_green_bits;
  unsigned int s_blue_bits =   sgc->_blue_bits;
  
  unsigned int d_start_red =   dgc->_start_red;
  unsigned int d_start_green = dgc->_start_green;
  unsigned int d_start_blue =  dgc->_start_blue;
  unsigned int d_red_bits =    dgc->_red_bits;
  unsigned int d_green_bits =  dgc->_green_bits;
  unsigned int d_blue_bits =   dgc->_blue_bits;
 
//  unsigned int s_row_bytes =   _gc_list[sgid-1]._row_bytes;
//  unsigned int d_row_bytes =   _gc_list[dgid-1]._row_bytes;
  unsigned int s_depth =   sgc->_depth;
  unsigned int d_depth =   dgc->_depth;
//  unsigned int s_pix_bytes = s_depth/8;
//  unsigned int d_pix_bytes = d_depth/8;

  long sx,sy;
  unsigned long sw,sh;
  if (WSMFandArea(x,y,w,h,sgc->_x, sgc->_y, sgc->_w, sgc->_h,
                      &sx,&sy,&sw,&sh) == WS_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_NO_ERR;
  }
  unsigned char* sbuf = sgc->_buf;
  if (sbuf == NULL){
    sbuf = _buffer;
    if (WSMFandArea(sx,sy,sw,sh,0, 0, _device_width, _device_height,
                      &sx,&sy,&sw,&sh) == WS_ERR){
      return WS_NO_ERR;
    }
  }


  if (sgid != dgid && _check_visible_region(sgid,&sx,&sy,&sw,&sh) == False){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_NO_ERR;
  }
  long px,py;
  unsigned long pw,ph;
  if (WSMFandArea(sx - x + dx,sy - y + dy,sw,sh,
                      dgc->_x, dgc->_y, dgc->_w, dgc->_h,
                      &px,&py,&pw,&ph) == WS_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_NO_ERR;
  }

  unsigned char* dbuf = dgc->_buf;
  if (dbuf == NULL){
    dbuf = _buffer;
    if (WSMFandArea(px,py,pw,ph,0, 0, _device_width, _device_height,
                      &px,&py,&pw,&ph) == WS_ERR){
      return WS_NO_ERR;
    }
  }


  if (_check_visible_region(dgid,&px,&py,&pw,&ph) == False){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_NO_ERR;
  }
  sx = px - dx + x; 
  sy = py - dy + y; 
//printf("     %d,%d,%d,%d -> %d,%d\n",x,y,w,h,dx,dy);
//printf("real %d,%d,%d,%d -> %d,%d\n",px,py,pw,ph,sx,sy);
//printf("sdepth=%d ddepth=%d\n",s_depth,d_depth);
//printf("s=%d,%d,%d,%d,%d,%d\n",s_start_red,s_start_green,s_start_blue,
//                               s_red_bits,s_green_bits,s_blue_bits);
//printf("d=%d,%d,%d,%d,%d,%d\n",d_start_red,d_start_green,d_start_blue,
//                               d_red_bits,d_green_bits,d_blue_bits);
//fflush(stdout);
  WSCbool check_s = True;
  if (sgc->_ex_region_list == NULL){
    check_s = False;
  }
  WSCbool check_d = True;
  if (dgc->_ex_region_list == NULL){
    check_d = False;
  }


  //TODO: mask with region..
  if ((sgid == dgid ) ||
      (s_start_red == d_start_red && 
       s_start_green == d_start_green && 
       s_start_blue == d_start_blue && 
       s_red_bits == d_red_bits && 
       s_green_bits == d_green_bits && 
       s_blue_bits == d_blue_bits &&
       s_depth == d_depth)){
    int i,j;
    unsigned int val;
    unsigned int val2;
    if (mode == G_STORE){

//      unsigned char* sbuf = _gc_list[sgid-1]._buf;
//      if (sbuf == NULL){
//        sbuf = _buffer;
//      }

//      unsigned char* dbuf = _gc_list[dgid-1]._buf;
//      if (dbuf == NULL){
//        dbuf = _buffer;
//      }
#if 0
      int depth =  sgc->_depth;
      int ddepth =  dgc->_depth;
      int row_bytes = sgc->_row_bytes;
      int drow_bytes = dgc->_row_bytes;
#endif

      if (reverse == False){
        if (check_d == False){
#ifdef LINE_OPTIMIZE
          _copy_raw_rgb(dgid,sgid,px,py,sx,sy,pw,reverse,ph);
#else
          for(i=0; i< (int)ph; i++){
            for(j=0; j< (int)pw; j++){
              if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
                _get_raw_rgb(sgid,sbuf,sx+j,sy+i,&val);
                _set_raw_rgb(dgid,dbuf,px+j,py+i,val);
              }
            }
          }
#endif
        }else{

          for(i=0; i< (int)ph; i++){
#ifdef LINE_OPTIMIZE
            WSCpoint pt1[WS_MAX_POINTS];
            WSCpoint pt2[WS_MAX_POINTS];
            int num = _check_raw_hline(dgid,px,py+i,px+pw-1,pt1,pt2,WS_MAX_POINTS,False);
            for(j=0; j<(int)num; j++){
              int x1 = pt1[j].x;
              int x2 = pt2[j].x;
              if (x1 < x2){
                long sx2 = sx + (x1 - px);
                _copy_raw_rgb(dgid,sgid,x1,py+i,sx2,sy+i,x2 -x1+1,reverse,1);
              }else{
                long sx2 = sx + (x2 - px);
                _copy_raw_rgb(dgid,sgid,x2,py+i,sx2,sy+i,x1 -x2+1,reverse,1);
              }
            }
#else
            for(j=0; j< (int)pw; j++){
              if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
                _get_raw_rgb(sgid,sbuf,sx+j,sy+i,&val);
                if (_check_raw_point_ex_only(dgid,px+j,py+i) != False){
                  _set_raw_rgb(dgid,dbuf,px+j,py+i,val);
                }
              }
            }
#endif
          }
        }
      }else{
        if (check_d == False){
#ifdef LINE_OPTIMIZE
          _copy_raw_rgb(dgid,sgid,px,py,sx,sy,pw,reverse,ph);
#else
          for(i= (int)ph-1; i> -1; i--){
            for(j= (int)pw-1; j> -1; j--){
              if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
                _get_raw_rgb(sgid,sbuf,sx+j,sy+i,&val);
                if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
                  _set_raw_rgb(dgid,dbuf,px+j,py+i,val);
                }
              }
            }
          }
#endif
        }else{
          for(i= (int)ph-1; i> -1; i--){
#ifdef LINE_OPTIMIZE
            WSCpoint pt1[WS_MAX_POINTS];
            WSCpoint pt2[WS_MAX_POINTS];
            int num = 0;
            if (check_d == False){
              num = 1;
              pt1[0].x = px;
              pt2[0].x = px+pw-1;
            }else{
              num = _check_raw_hline(dgid,px,py+i,px+pw-1,pt1,pt2,WS_MAX_POINTS,False);
            }
            for(j=0; j<(int)num; j++){
              int x1 = pt1[j].x;
              int x2 = pt2[j].x;
              if (x1 < x2){
                long sx2 = sx + (x1 - px);
                _copy_raw_rgb(dgid,sgid,x1,py+i,sx2,sy+i,x2 -x1+1,reverse,1);
              }else{
                long sx2 = sx + (x2 - px);
                _copy_raw_rgb(dgid,sgid,x2,py+i,sx2,sy+i,x1 -x2+1,reverse,1);
              }
            }
#else
            for(j= (int)pw-1; j> -1; j--){
              if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
                _get_raw_rgb(sgid,sbuf,sx+j,sy+i,&val);
                if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
                  _set_raw_rgb(dgid,dbuf,px+j,py+i,val);
                }
              }
            }
#endif
          }
        }
      }
    }else
    if (mode == G_AND){
      if (reverse == False){
        for(i=0; i< (int)ph; i++){
          for(j=0; j< (int)pw; j++){
            if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
              _get_raw_rgb(sgid,sbuf,sx+j,sy+i,&val);
              if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
                _get_raw_rgb(dgid,dbuf,px+j,py+i,&val2);
                _set_raw_rgb(dgid,dbuf,px+j,py+i,val2 & val);
              }
            }
          }
        }
      }else{
        for(i= (int)ph-1; i> -1; i--){
          for(j= (int)pw -1; j> -1; j--){
            if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
              _get_raw_rgb(sgid,sbuf,sx+j,sy+i,&val);
              if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
                _get_raw_rgb(dgid,dbuf,px+j,py+i,&val2);
                _set_raw_rgb(dgid,dbuf,px+j,py+i,val2 & val);
              }
            }
          }
        }
      }
    }else if (mode == G_ANDN){
      if (reverse == False){
        for(i=0; i< (int)ph; i++){
          for(j=0; j< (int)pw; j++){
            if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
              _get_raw_rgb(sgid,sbuf,sx+j,sy+i,&val);
              if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
                _get_raw_rgb(dgid,dbuf,px+j,py+i,&val2);
                _set_raw_rgb(dgid,dbuf,px+j,py+i,(val2 & ~val));
              }
            }
          }
        }
      }else{
        for(i= (int)ph-1; i> -1; i--){
          for(j= (int)pw-1; j> -1; j--){
            if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
              _get_raw_rgb(sgid,sbuf,sx+j,sy+i,&val);
              if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
                _get_raw_rgb(dgid,dbuf,px+j,py+i,&val2);
                _set_raw_rgb(dgid,dbuf,px+j,py+i,(val2 & ~val));
              }
            }
          }
        }
      }
    }else if (mode == G_OR){
      if (reverse == False){
        for(i=0; i< (int)ph; i++){
          for(j=0; j< (int)pw; j++){
            if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
              _get_raw_rgb(sgid,sbuf,sx+j,sy+i,&val);
              _get_raw_rgb(dgid,dbuf,px+j,py+i,&val2);
              if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
                _set_raw_rgb(dgid,dbuf,px+j,py+i,(val2 | val));
              }
            }
          }
        }
      }else{
        for(i= (int)ph-1; i> -1; i--){
          for(j= (int)pw-1; j> -1; j--){
            if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
              _get_raw_rgb(sgid,sbuf,sx+j,sy+i,&val);
              _get_raw_rgb(dgid,dbuf,px+j,py+i,&val2);
              if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
                _set_raw_rgb(dgid,dbuf,px+j,py+i,(val2 | val));
              }
            }
          }
        }
      }
    }
 }else{
    unsigned int i,j;
    unsigned char r;
    unsigned char g;
    unsigned char b;
    if (mode == G_AND){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
            _get_rgb(sgid,sbuf,sx+j,sy+i,&r,&g,&b);
            if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,(r2 & r),(g2 & g),(b2 & b));
            }
          }
        }
      }
    }else if (mode == G_ANDN){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
            _get_rgb(sgid,sbuf,sx+j,sy+i,&r,&g,&b);
            if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,(r2 & ~r),(g2 & ~g),(b2 & ~b));
            }
          }
        }
      }
    }else if (mode == G_OR){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
            _get_rgb(sgid,sbuf,sx+j,sy+i,&r,&g,&b);
            if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,r2 | r,g2 | g,b2 | b);
            }
          }
        }
      }
    }else{
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          if (check_s == False || _check_raw_point_ex_only(sgid,sx+j,sy+i) != False){
            _get_rgb(sgid,sbuf,sx+j,sy+i,&r,&g,&b);
            if (check_d == False || _check_raw_point_ex_only(dgid,px+j,py+i) != False){
              _set_rgb(dgid,dbuf,px+j,py+i,r,g,b);
            }
          }
        }
      }
    }
  }
  if (_gc_list[dgid-1]._buf == NULL){
    _update_frame_buffer(px,py,pw,ph);
  }
  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceBitBlt()3 done");
dbprintf("WSGFdeviceBitBlt sgid=%d dgid=%d %d,%d,%d,%d->%d,%d done.\n",sgid,dgid,x,y,w,h,dx,dy);
  return WS_NO_ERR;
}

int WSGFdeviceStretchedBitBlt(int sgid,short x,short y,
                       unsigned short w,unsigned short h,
                       int dgid,short dx,short dy,
                       unsigned short dw,unsigned short dh,
                       unsigned int mode){
TIME_TRACE("WSGFdeviceStretchedBitBlt() start");
  mode &= 0xf;

  long scale_x = FP_BASE*dw/w;
  long scale_y = FP_BASE*dh/h;
  long x_scale = FP_BASE*w/dw;
  long y_scale = FP_BASE*h/dh;

//printf("WSGFdeviceBitBlt sgid=%d dgid=%d\n",sgid,dgid);
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(sgid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceStretchedBitBlt()1 done");
    return WS_ERR_GID;
  }
  if (check_gid(dgid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceStretchedBitBlt()2 done");
    return WS_ERR_GID;
  }
  x += _gc_list[sgid-1]._x;
  y += _gc_list[sgid-1]._y;
  dx += _gc_list[dgid-1]._x;
  dy += _gc_list[dgid-1]._y;
  unsigned int s_start_red =   _gc_list[sgid-1]._start_red;
  unsigned int s_start_green = _gc_list[sgid-1]._start_green;
  unsigned int s_start_blue =  _gc_list[sgid-1]._start_blue;
  unsigned int s_red_bits =    _gc_list[sgid-1]._red_bits;
  unsigned int s_green_bits =  _gc_list[sgid-1]._green_bits;
  unsigned int s_blue_bits =   _gc_list[sgid-1]._blue_bits;
  
  unsigned int d_start_red =   _gc_list[dgid-1]._start_red;
  unsigned int d_start_green = _gc_list[dgid-1]._start_green;
  unsigned int d_start_blue =  _gc_list[dgid-1]._start_blue;
  unsigned int d_red_bits =    _gc_list[dgid-1]._red_bits;
  unsigned int d_green_bits =  _gc_list[dgid-1]._green_bits;
  unsigned int d_blue_bits =   _gc_list[dgid-1]._blue_bits;
 
//  unsigned int s_row_bytes =   _gc_list[sgid-1]._row_bytes;
//  unsigned int d_row_bytes =   _gc_list[dgid-1]._row_bytes;
  unsigned int s_depth =   _gc_list[sgid-1]._depth;
  unsigned int d_depth =   _gc_list[dgid-1]._depth;
//  unsigned int s_pix_bytes = s_depth/8;
//  unsigned int d_pix_bytes = d_depth/8;

  unsigned char* sbuf = _gc_list[sgid-1]._buf;
  if (sbuf == NULL){
    sbuf = _buffer;
  }

  unsigned char* dbuf = _gc_list[dgid-1]._buf;
  if (dbuf == NULL){
    dbuf = _buffer;
  }

  long sx,sy;
  unsigned long sw,sh;
  if ( WSMFandArea(x,y,w,h,_gc_list[sgid-1]._x,
                      _gc_list[sgid-1]._y,
                      _gc_list[sgid-1]._w,
                      _gc_list[sgid-1]._h,
                      &sx,&sy,&sw,&sh)){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  long bx,by;
  unsigned long bw,bh;
  if (WSMFandArea((long)((_gc_list[sgid-1]._x-x) * scale_x/FP_BASE +dx),
              (long)((_gc_list[sgid-1]._y-y) * scale_y/FP_BASE +dy),
              (unsigned long)(_gc_list[sgid-1]._w * scale_x/FP_BASE),
              (unsigned long)(_gc_list[sgid-1]._h * scale_y/FP_BASE),
                      _gc_list[dgid-1]._x,
                      _gc_list[dgid-1]._y,
                      _gc_list[dgid-1]._w,
                      _gc_list[dgid-1]._h,
                      &bx,&by,&bw,&bh) == WS_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  long px,py;
  unsigned long pw,ph;
  if (WSMFandArea(dx,dy,dw,dh,bx,by,bw,bh, &px,&py,&pw,&ph) == WS_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }

  sx = (long)((px-dx)*x_scale/FP_BASE + x);
  sy = (long)((py-dy)*y_scale/FP_BASE + y);


  //TODO: mask with region..
  if (s_start_red == d_start_red && 
      s_start_green == d_start_green && 
      s_start_blue == d_start_blue && 
      s_red_bits == d_red_bits && 
      s_green_bits == d_green_bits && 
      s_blue_bits == d_blue_bits &&
      s_depth == d_depth){
    unsigned int i,j;
    unsigned int val;
    unsigned int val2;
    if (mode == G_AND){
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale/FP_BASE);
          short syy = (short)(sy+i*y_scale/FP_BASE);
          if (_check_raw_point(sgid,sxx,syy) != False){
            _get_raw_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&val);
            if (_check_raw_point(dgid,px+j,py+i) != False){
              _get_raw_rgb(dgid,dbuf,px+j,py+i,&val2);
              _set_raw_rgb(dgid,dbuf,px+j,py+i,val2 & val);
            }
          }
        }
      }
    }else if (mode == G_ANDN){
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale/FP_BASE);
          short syy = (short)(sy+i*y_scale/FP_BASE);
          if (_check_raw_point(sgid,sxx,syy) != False){
            _get_raw_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&val);
            if (_check_raw_point(dgid,px+j,py+i) != False){
              _get_raw_rgb(dgid,dbuf,px+j,py+i,&val2);
              _set_raw_rgb(dgid,dbuf,px+j,py+i,(val2 & ~val));
            }
          }
        }
      }
    }else if (mode == G_OR){
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale/FP_BASE);
          short syy = (short)(sy+i*y_scale/FP_BASE);
          if (_check_raw_point(sgid,sxx,syy) != False){
            _get_raw_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&val);
            if (_check_raw_point(dgid,px+j,py+i) != False){
              _get_raw_rgb(dgid,dbuf,px+j,py+i,&val2);
              _set_raw_rgb(dgid,dbuf,px+j,py+i,(val2 | val));
            }
          }
        }
      }
    }else if (mode == G_STORE){
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale/FP_BASE);
          short syy = (short)(sy+i*y_scale/FP_BASE);
          if (_check_raw_point(sgid,sxx,syy) != False){
            _get_raw_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&val);
            if (_check_raw_point(dgid,px+j,py+i) != False){
              _set_raw_rgb(dgid,dbuf,px+j,py+i,val);
            }
          }
        }
      }
    }
  }else{
    unsigned int i,j;
    unsigned char r;
    unsigned char g;
    unsigned char b;
    if (mode == G_AND){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale/FP_BASE);
          short syy = (short)(sy+i*y_scale/FP_BASE);
          if (_check_raw_point(sgid,sxx,syy) != False){
            _get_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&r,&g,&b);
            if (_check_raw_point(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,(r2 & r),(g2 & g),(b2 & b));
            }
          }
        }
      }
    }else if (mode == G_ANDN){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale/FP_BASE);
          short syy = (short)(sy+i*y_scale/FP_BASE);
          if (_check_raw_point(sgid,sxx,syy) != False){
            _get_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&r,&g,&b);
            if (_check_raw_point(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,(r2 & ~r),(g2 & ~g),(b2 & ~b));
            }
          }
        }
      }
    }else if (mode == G_OR){
      unsigned char r2;
      unsigned char g2;
      unsigned char b2;
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale/FP_BASE);
          short syy = (short)(sy+i*y_scale/FP_BASE);
          if (_check_raw_point(sgid,sxx,syy) != False){
            _get_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&r,&g,&b);
            if (_check_raw_point(dgid,px+j,py+i) != False){
              _get_rgb(dgid,dbuf,px+j,py+i,&r2,&g2,&b2);
              _set_rgb(dgid,dbuf,px+j,py+i,r2 | r,g2 | g,b2 | b);
            }
          }
        }
      }
    }else{
      for(i=0; i< ph; i++){
        for(j=0; j< pw; j++){
          short sxx = (short)(sx+j*x_scale/FP_BASE);
          short syy = (short)(sy+i*y_scale/FP_BASE);
          if (_check_raw_point(sgid,sxx,syy) != False){
            _get_rgb(sgid,sbuf,(short)(sxx),(short)(syy),&r,&g,&b);
            if (_check_raw_point(dgid,px+j,py+i) != False){
              _set_rgb(dgid,dbuf,px+j,py+i,r,g,b);
            }
          }
        }
      }
    }
  }
  if (_gc_list[dgid-1]._buf == NULL){
    int x = _gc_list[dgid-1]._x;
    int y = _gc_list[dgid-1]._y;
    unsigned int w = _gc_list[dgid-1]._w;
    unsigned int h = _gc_list[dgid-1]._h;
    _update_frame_buffer(x,y,w,h);
  }
  WSMFdeviceSemUnlock(_sem_id);
TIME_TRACE("WSGFdeviceStretchedBitBlt()3 done");
  return WS_NO_ERR;
}



int WSGFdeviceSetDrawPoint(int gid,short x,short y){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._draw_pt_x = x;
  _gc_list[gid-1]._draw_pt_y = y;
  WSMFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}

int WSGFdeviceGetDrawPoint(int gid,short* x,short* y){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  *x = _gc_list[gid-1]._draw_pt_x;
  *y = _gc_list[gid-1]._draw_pt_y;
  WSMFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}

int _WSGFdeviceGetDrawPoint(int gid,short* x,short* y){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  *x = _gc_list[gid-1]._draw_pt_x;
  *y = _gc_list[gid-1]._draw_pt_y;
  return WS_NO_ERR;
}

int WSGFdeviceSetFont(int gid,WSDdeviceFontList* fl){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._font = fl;
  WSMFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}

int WSGFdeviceGetFont(int gid,WSDdeviceFontList** fl){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  *fl = _gc_list[gid-1]._font;
  WSMFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}

int _WSGFdeviceGetFont(int gid,WSDdeviceFontList** fl){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  *fl = _gc_list[gid-1]._font;
  return WS_NO_ERR;
}

int WSGFdeviceSetForeColor(int gid,unsigned int fg){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._fg_color = fg;
  WSMFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}

int _WSGFdeviceSetForeColor(int gid,unsigned int fg){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._fg_color = fg;
  return WS_NO_ERR;
}


int WSGFdeviceGetForeColor(int gid,unsigned int* fg){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  *fg = _gc_list[gid-1]._fg_color;
  WSMFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}

int _WSGFdeviceGetForeColor(int gid,unsigned int* fg){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  *fg = _gc_list[gid-1]._fg_color;
  return WS_NO_ERR;
}

int WSGFdeviceSetBackColor(int gid,unsigned int bg){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._bg_color = bg;
  WSMFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}

int _WSGFdeviceSetBackColor(int gid,unsigned int bg){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._bg_color = bg;
  return WS_NO_ERR;
}

int WSGFdeviceGetBackColor(int gid,unsigned int* bg){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  *bg = _gc_list[gid-1]._bg_color;
  WSMFdeviceSemUnlock(_sem_id);

  return WS_NO_ERR;
}
#if 0
int WSGFdeviceDestroyVisibleRegion(int gid){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._visible_region_list_num = 0;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
#endif

int WSGFdeviceDestroyExclusiveRegion(int gid){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._ex_region_list_num = 0;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}

void WSGFlockDev(){
  WSMFdeviceSemLock(_sem_id);
}
void WSGFunlockDev(){
  WSMFdeviceSemUnlock(_sem_id);
}

int _WSGFdeviceDestroyExclusiveRegion(int gid){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._ex_region_list_num = 0;
  return WS_NO_ERR;
}

int _WSGFdeviceAddVisibleRegion(int gid,short x,short y,WSCushort w,WSCushort h){
//printf("WSGFdeviceAddVisibleRegion gid=%d %d,%d,%d,%d\n",gid,x,y,w,h);
  short bx = _gc_list[gid-1]._x;
  short by = _gc_list[gid-1]._y;
  long  bw = _gc_list[gid-1]._w;
  long  bh = _gc_list[gid-1]._h;

  long dx,dy;
  unsigned long dw,dh;
  WSMFandArea(bx, by, bw, bh, bx +x, by + y,w,h,
              &dx,&dy,&dw,&dh);
//printf("WSGFdeviceAddVisibleRegion gid=%d %d,%d,%d,%d %d,%d,%d,%d\n",gid,bx,by,bw,bh,bx+x,by+y,w,h);

  if (_gc_list[gid-1]._visible_region_list == NULL){
    _gc_list[gid-1]._visible_region_list = new WSCrect[WS_VISLIST_MAX];
    _gc_list[gid-1]._visible_region_list_num = 0;
  }
  long i = _gc_list[gid-1]._visible_region_list_num;
  _gc_list[gid-1]._visible_region_list[i].setRect(dx,dy,dw,dh);
  _gc_list[gid-1]._visible_region_list_num++;
//printf("WSGFdeviceAddVisibleRegion added gid=%d %d,%d,%d,%d\n",gid,dx,dy,dw,dh);
  return WS_NO_ERR;
}
#if 0
int WSGFdeviceAddVisibleRegion(int gid,short x,short y,WSCushort w,WSCushort h){
//printf("WSGFdeviceAddVisibleRegion gid=%d %d,%d,%d,%d\n",gid,x,y,w,h);
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  int ret = _WSGFdeviceAddVisibleRegion(gid,x,y,w,h);
  WSMFdeviceSemUnlock(_sem_id);
  return ret;
}
#endif

int WSGFdeviceSetVisibleRegion(int gid,short x,short y,WSCushort w,WSCushort h){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._visible_region_list_num = 0;
  int ret = _WSGFdeviceAddVisibleRegion(gid,x,y,w,h);
  WSMFdeviceSemUnlock(_sem_id);
  return ret;
}

int _WSGFdeviceSetVisibleRegion(int gid,short x,short y,WSCushort w,WSCushort h){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  _gc_list[gid-1]._visible_region_list_num = 0;
  int ret = _WSGFdeviceAddVisibleRegion(gid,x,y,w,h);
  return ret;
}

WSCrect* WSGFdeviceGetVisibleRegion(int gid,int* num){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return NULL;
  }
  WSCrect* ret = _gc_list[gid-1]._visible_region_list;
  *num = _gc_list[gid-1]._visible_region_list_num;
  WSMFdeviceSemUnlock(_sem_id);
  return ret;
}
#if 0
int WSGFdeviceAddExclusiveRegion(int gid,short x,short y,WSCushort w,WSCushort h){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  short bx = _gc_list[gid-1]._x;
  short by = _gc_list[gid-1]._y;
  if (_gc_list[gid-1]._ex_region_list == NULL){
    _gc_list[gid-1]._ex_region_list = new WSCrect[WS_EXLIST_MAX];
    _gc_list[gid-1]._ex_region_list_num = 0;
  }
  long i =  _gc_list[gid-1]._ex_region_list_num;
  _gc_list[gid-1]._ex_region_list[i].setRect(bx+x,by+y,w,h);
  _gc_list[gid-1]._ex_region_list_num++;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}
#endif

int _WSGFdeviceAddExclusiveRegion(int gid,short x,short y,WSCushort w,WSCushort h){
  if (check_gid(gid) != WS_NO_ERR){
    return WS_ERR_GID;
  }
  short bx = _gc_list[gid-1]._x;
  short by = _gc_list[gid-1]._y;
  if (_gc_list[gid-1]._ex_region_list == NULL){
    _gc_list[gid-1]._ex_region_list = new WSCrect[WS_EXLIST_MAX];
    _gc_list[gid-1]._ex_region_list_num = 0;
  }
  long i =  _gc_list[gid-1]._ex_region_list_num;
  _gc_list[gid-1]._ex_region_list[i].setRect(bx+x,by+y,w,h);
  _gc_list[gid-1]._ex_region_list_num++;
  return WS_NO_ERR;
}

WSCrect* WSGFdeviceGetExclusiveRegion(int gid,int* num){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return NULL;
  }
  WSCrect* ret = NULL;
  ret = _gc_list[gid-1]._ex_region_list;
  *num = _gc_list[gid-1]._ex_region_list_num;
  WSMFdeviceSemUnlock(_sem_id);
  return ret;
}
int WSGFdeviceGetGCPos(int gid,short* x,short* y){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  *x = _gc_list[gid-1]._x;
  *y = _gc_list[gid-1]._y;
  WSMFdeviceSemUnlock(_sem_id);
  return WS_NO_ERR;
}




int WSGFdeviceDestroyGC(int gid){
  WSMFdeviceSemLock(_sem_id);
  if (check_gid(gid) != WS_NO_ERR){
    WSMFdeviceSemUnlock(_sem_id);
    return WS_ERR_GID;
  }
  int ret = _destroy_gc(gid);
  WSMFdeviceSemUnlock(_sem_id);
  return ret;
}

int WSGFdeviceGetScreenSize(int* w,int* h){
  return _get_device_screen_size(w,h); 
}

int WSGFdeviceSearchWindow(short x,short y){
  WSMFdeviceSemLock(_sem_id);
  int wid = _search_window(x,y);
  WSMFdeviceSemUnlock(_sem_id);
  return wid;
}
#ifndef TE
int WSGFdeviceSleep(int time){
  //TODO: call sleep.
#ifdef NO_THREAD
  if (time/1000){
    sleep(time/1000);
  }else{
    usleep((time%1000)*1000);
  }
#else
  pthread_mutex_t mutex;
  pthread_cond_t cond;
  timespec tm;
  struct timeval  _tmvl;
  struct timezone _tzp;
//  struct tm*      _tm;
  gettimeofday( &_tmvl, &_tzp ) ;
  tm.tv_sec = _tmvl.tv_sec + time/1000;
  tm.tv_nsec = _tmvl.tv_usec*1000 + (time%1000)*1000000;
  if (tm.tv_nsec / 1000000000){
    tm.tv_sec += tm.tv_nsec / 1000000000;
    tm.tv_nsec = tm.tv_nsec % 1000000000;
  }
  pthread_mutex_init(&mutex,NULL);
  pthread_cond_init(&cond,NULL);
  pthread_mutex_lock(&mutex);
  pthread_cond_timedwait(&cond,&mutex,&tm);
  pthread_mutex_unlock(&mutex);
  pthread_mutex_destroy(&mutex);
  pthread_cond_destroy(&cond);
#endif
  return WS_NO_ERR;
}
int WSGFdeviceCreateThread(int* thr,void(*entry)(int),int arg){
#ifdef NO_THREAD
  return WS_ERR;
#else
  pthread_t thr2;
  int ret = pthread_create(&thr2,NULL,(void*(*)(void*))entry,(void*)arg);
  if (ret != 0){
    return WS_ERR;
  }
  pthread_detach(thr2);
  *thr = thr2;
  return WS_NO_ERR;
#endif
}
int WSGFdeviceExitThread(){
#ifdef NO_THREAD
  return WS_ERR;
#else
  //TODO: exit thread..
  pthread_exit(NULL);
  return WS_NO_ERR;
#endif
}
int WSGFdeviceTerminateThread(int id){
#ifdef NO_THREAD
  return WS_ERR;
#else
  //TODO: exit thread..
  pthread_cancel((pthread_t)id);
  return WS_NO_ERR;
#endif
}
int WSGFdeviceGetThreadId(){
#ifdef NO_THREAD
  return WS_ERR;
#else
  //TODO: return thread id..
  return (int)pthread_self();
#endif
}
#endif
int _device_check_event_available(){
#ifndef _NOTSH
  int num = _message_list.getNum();
  int i;
  unsigned int ctime = get_current_time();
  for(i=0; i<num; i++){
    unsigned int time = (unsigned int)_message_time_list[i];
    unsigned int rate = (unsigned int)_message_rate_list[i];
    if (time == 0){
      return 1;
    }
    if (ctime > time + rate){
      return 1;
    }
  }
#else
  MESSAGE msg;
  WERR ret = rcv_msg(MM_TYPE1 | MM_TYPE2 | MM_TYPE3 | MM_TYPE4,
                     &msg,8,NOWAIT | NOCLR | CHECK);
//printf("messages=%d\n",ret);
  if (ret > -1){
    return 1;
  }
#endif
  return 0;
}

int WSGFdeviceCheckEventAvailable(){
  WSMFdeviceSemLock(_event_sem_id);
  int ret = _device_check_event_available();
  WSMFdeviceSemUnlock(_event_sem_id);
  return ret;  
}

#ifndef _NOTSH
int WSGFdeviceSendMessage(MESSAGE* msg){
  WSMFdeviceSemLock(_event_sem_id);
//printf("WSGFdeviceSendMessage.. data=0x%x\n",msg->msg_body.SYSEVT.code);
  if (_message_list.getNum() <MAX_MESSAGES-1){
    int size = msg->msg_size;
    MESSAGE* buf = (MESSAGE*)new char[size+sizeof(int)*2];
    memcpy(buf,msg,size+sizeof(int)*2);
//printf("WSGFdeviceSendMessage.. buf=0x%x\n",buf);
//printf("WSGFdeviceSendMessage.. type=%x size=%d\n",msg->msg_type,size);
//printf("WSGFdeviceSendMessage.. data2=0x%x\n",buf->msg_body.SYSEVT.code);
    _message_list.add((void*)buf);
    _message_time_list.add((void*)0);
    _message_rate_list.add((void*)0);
//printf("WSGFdeviceSendMessage.. done.\n");
    WSMFdeviceSemUnlock(_event_sem_id);
#ifndef NO_THREAD
  _wake_up_event();
//  pthread_sem_unlock_np(&_event_sem);
#endif
    return WS_NO_ERR;
  }
//printf("WSGFdeviceSendMessage.. done. err\n");
  WSMFdeviceSemUnlock(_event_sem_id);
//#if defined LINUX || defined USE_X11
//#endif
#ifndef NO_THREAD
  _wake_up_event();
//  pthread_sem_unlock_np(&_event_sem);
#endif
  return WS_ERR_NOSPC;
}

int WSGFdeviceSendDelayMessage(MESSAGE* msg,int rate,int* id){
  WSMFdeviceSemLock(_event_sem_id);
//printf("WSGFdeviceSendDelayMessage..\n");
  unsigned int ctime = get_current_time();
  int ret = 0;
  if (_message_list.getNum() < MAX_MESSAGES-1){
    int size = msg->msg_size;
    MESSAGE* buf = (MESSAGE*)new char[size+sizeof(int)*2];
//printf("WSGFdeviceSendDelayMessage.. buf=0x%x\n",buf);
    memcpy(buf,msg,size+sizeof(int)*2);
//printf("WSGFdeviceSendMessage.. type=%x size=%d\n",msg->msg_type,size);
    _message_list.add((void*)buf);
    _message_time_list.add((void*)ctime);
    _message_rate_list.add((void*)rate);
    ret = _message_list.getNum();
//printf("WSGFdeviceSendDelayMessage.. done.\n");
    WSMFdeviceSemUnlock(_event_sem_id);
    return ret;
  }
//printf("WSGFdeviceSendDelayMessage.. done. err\n");
  WSMFdeviceSemUnlock(_event_sem_id);
  return WS_ERR_NOSPC;
}


int WSGFdeviceRecvMessage(int type,MESSAGE* msg,int size){
  WSMFdeviceSemLock(_event_sem_id);
  int num = _message_list.getNum();
//printf("WSGFdeviceRecvMessage..num=%d\n",num);
  int i;
  unsigned int ctime = get_current_time();
  for(i=0; i<num; i++){
    MESSAGE* buf = (MESSAGE*)_message_list[i];
//printf("WSGFdeviceRecvMessage.. i=%d buf=0x%x\n",i,buf);
    unsigned int time = (unsigned int)_message_time_list[i];
    unsigned int rate = (unsigned int)_message_rate_list[i];
//printf("WSGFdeviceRecvMessage.. i=%d type=%x type=%x\n",i,buf->msg_type,type);
//printf("WSGFdeviceRecvMessage.. ctime=%d time=%d rate=%d\n",ctime,time,rate);
    if (time > 0 && ctime < time + rate){
//printf("WSGFdeviceRecvMessage.. continue.\n");
      continue;
    }
    if ( ((MM_TYPE1 & type) && buf->msg_type == MS_TYPE1)||
         ((MM_TYPE2 & type) && buf->msg_type == MS_TYPE2)||
         ((MM_TYPE3 & type) && buf->msg_type == MS_TYPE3)||
         ((MM_TYPE4 & type) && buf->msg_type == MS_TYPE4)){
//printf("WSGFdeviceRecvMessage.. find i=%d type=%x type=%x\n",i,buf->msg_type,type);
      if (size < (int)(buf->msg_size+sizeof(int)*2)){
        memcpy(msg,buf,size);
      }else{
        memcpy(msg,buf,buf->msg_size + sizeof(int)*2);
      }
      delete buf;
      _message_list.delPos(i);
      _message_time_list.delPos(i);
      _message_rate_list.delPos(i);
//printf("WSGFdeviceRecvMessage.. recv done!\n");
      WSMFdeviceSemUnlock(_event_sem_id);
      return WS_NO_ERR;
    }else{
//printf("WSGFdeviceRecvMessage.. not hit.!\n");
    }
  }
//printf("WSGFdeviceRecvMessage.. recv..ERR!\n");
  WSMFdeviceSemUnlock(_event_sem_id);
  return WS_ERR;
}
#endif
int WSGFdeviceGetCursorPos(short* x,short* y){
  _get_mouse_pos(x,y);
  return WS_NO_ERR;
}
int WSGFdeviceGetWindowList(int* list,int num){
  if (list == NULL){
    return WS_ERR_ADR;
  }
  if (num < 1){
    return WS_ERR_PAR;
  }
  memset(list,0,num * sizeof(int));
  WSMFdeviceSemLock(_sem_id);
//  int stack_no = 0;
  int i,j;
  int cnt = 0;
  for(i=1;i< WS_MAX_WINDOW+1; i++){
    if (cnt >= num){
      break;
    }
    char found = 0;
    for(j=0;j< WS_MAX_WINDOW; j++){
      if (_window_list[j]._window_id != 0 ){
//printf("WSGFdeviceGetWindowList return wid=%d stack=%d\n",_window_list[j]._window_id,_window_list[j]._stack_no);
      }
      if (_window_list[j]._window_id != 0 &&
          _window_list[j]._stack_no == i){
//printf("WSGFdeviceGetWindowList no=%d wid=%d stack=%d\n",cnt,_window_list[j]._window_id,_window_list[j]._stack_no);
        list[cnt] = _window_list[j]._window_id;
        cnt++;
        found = 1;
        break;
      }
    }
    if (found == 0){
      break;
    }
  }
  WSMFdeviceSemUnlock(_sem_id);
//printf("WSGFdeviceGetWindowList return num=%d\n",cnt);
  return WS_NO_ERR;
}
#if 0
unsigned char arc_ptr[256][2] ={
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{255,255},
{254,255},
{254,254},
{254,254},
{254,254},
{254,254},
{254,254},
{254,254},
{254,254},
{254,254},
{254,254},
{253,253},
{253,253},
{253,253},
{253,253},
{253,253},
{253,253},
{253,253},
{252,252},
{252,252},
{252,252},
{252,252},
{252,252},
{252,252},
{251,251},
{251,251},
{251,251},
{251,251},
{251,251},
{250,251},
{250,250},
{250,250},
{250,250},
{250,250},
{249,249},
{249,249},
{249,249},
{249,249},
{248,249},
{248,248},
{248,248},
{248,248},
{247,248},
{247,247},
{247,247},
{247,247},
{246,247},
{246,246},
{246,246},
{245,246},
{245,245},
{245,245},
{245,245},
{244,244},
{244,244},
{244,244},
{243,244},
{243,243},
{243,243},
{242,243},
{242,242},
{242,242},
{241,242},
{241,241},
{241,241},
{240,241},
{240,240},
{240,240},
{239,239},
{239,239},
{238,239},
{238,238},
{238,238},
{237,238},
{237,237},
{237,237},
{236,236},
{236,236},
{235,235},
{235,235},
{234,235},
{234,234},
{234,234},
{233,233},
{233,233},
{232,232},
{232,232},
{231,232},
{231,231},
{230,231},
{230,230},
{229,230},
{229,229},
{228,229},
{228,228},
{227,228},
{227,227},
{226,227},
{226,226},
{225,226},
{225,225},
{224,224},
{224,224},
{223,223},
{223,223},
{222,222},
{221,222},
{221,221},
{220,221},
{220,220},
{219,219},
{218,219},
{218,218},
{217,218},
{217,217},
{216,216},
{215,216},
{215,215},
{214,214},
{213,214},
{213,213},
{212,212},
{211,212},
{210,211},
{210,210},
{209,210},
{208,209},
{208,208},
{207,208},
{206,207},
{206,206},
{205,205},
{204,204},
{203,204},
{203,203},
{202,202},
{201,202},
{200,201},
{200,200},
{199,199},
{198,198},
{197,198},
{196,197},
{195,196},
{194,195},
{194,194},
{193,193},
{192,192},
{191,192},
{190,191},
{189,190},
{188,189},
{187,188},
{186,187},
{186,186},
{185,185},
{184,184},
{183,183},
{182,182},
{181,181},
{180,181},
{179,179},
{178,178},
{177,177},
{176,176},
{174,175},
{173,174},
{172,173},
{171,172},
{170,171},
{169,170},
{168,169},
{167,167},
{165,166},
{164,165},
{163,164},
{162,163},
{161,162},
{160,160},
{158,159},
{157,158},
{156,157},
{154,155},
{153,154},
{152,152},
{150,151},
{149,150},
{147,149},
{146,147},
{145,146},
{143,144},
{142,143},
{140,141},
{139,140},
{137,138},
{136,137},
{134,135},
{132,134},
{131,132},
{129,130},
{127,129},
{126,127},
{124,125},
{122,123},
{120,121},
{118,120},
{116,118},
{114,116},
{112,114},
{110,112},
{108,110},
{106,108},
{104,105},
{101,103},
{99,101},
{97,98},
{94,96},
{91,94},
{89,91},
{86,88},
{83,86},
{80,83},
{77,80},
{74,77},
{70,73},
{67,70},
{63,67},
{59,63},
{55,59},
{50,54},
{45,50},
{39,44},
{32,38},
{22,31},
{0,22}
};
#endif
