//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <WScom.h>
#include <devfb/devfb.h>
#include <devfb/devfb_dep.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fbconfig.h>
#include <WSkeysym.h>
#ifdef LINUX
#include <sys/time.h>
#endif

extern int _add_event(WSDdeviceEventList* evt);
extern int _device_check_event_available();
extern int _search_window(short x,short y);

#include <linux/fb.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <pthread.h>

#define USE_SAME_BUF

int _fb_fd = 0;
struct fb_var_screeninfo var_info;
struct fb_fix_screeninfo fix_info;
int _device_buffer_size = 0;
char* _fb_addr = 0;

#ifndef NO_THREAD
extern int _init_for_event_function();
extern int _wake_up_event();
extern int _wait_event();
//pthread_sem_t _event_sem;
#endif
unsigned int _mouse_status = 0;
unsigned int _keyb_status = 0;

int _touch_pannel_x = 0;
int _touch_pannel_y = 0;
void _get_mouse_pos(short* x,short* y){
  *x = _touch_pannel_x;
  *y = _touch_pannel_y;
}

#ifndef ZAURUS
#include <linux/input.h>
#include <errno.h>
pthread_t     _input_mouse_thr=0;
pthread_t     _input_key_thr=0;
int _mouse_dev =0;
int _keyb_dev =0;

void _draw_mouse_cursor(){
static  int _cursor_x = -1;
static  int _cursor_y = -1;
static  unsigned int val_back = 0;
static  unsigned int val_back2 = 0;
  int dx = _cursor_x;
  int dy = _cursor_y;
  int x = _touch_pannel_x;
  int y = _touch_pannel_y;
  _cursor_x = x;
  _cursor_y = y;
#ifdef ROTATE90
  {
     int tmp = dx;
     dx = dy;
     dy = _device_height - tmp -1;
     tmp = x;
     x = y;
     y = _device_height - tmp -1;
  }
#endif
#ifdef DOUBLE_SCALE
   dx *=2;
   dy *=2;
   x *=2;
   y *=2;
#endif
  if (x < 0 || y < 0){
    return;
  }
  unsigned int depth =   _device_depth;
  unsigned int row_bytes = _device_row_bytes;
  if (depth == 32){
    if (dx > -1 && dy > -1){
      unsigned int* ptr = (unsigned int*)&_buffer[dy*row_bytes + dx*depth/8];
      *ptr++ = val_back;
      *ptr = val_back2;
    }
    unsigned int* ptr2 = (unsigned int*)&_buffer[y*row_bytes + x*depth/8];
    val_back = *ptr2;
    *ptr2 = 0xffffffff;
    ptr2++;
    val_back2 = *ptr2;
    *ptr2 = 0x00000000;
  }else
  if (depth == 16){
    if (dx > -1 && dy > -1){
      unsigned short* ptr = (unsigned short*)&_buffer[dy*row_bytes + dx*depth/8];
      *ptr++ = val_back;
      *ptr = val_back2;
    }
    unsigned short* ptr2 = (unsigned short*)&_buffer[y*row_bytes + x*depth/8];
    val_back = *ptr2;
    *ptr2 = 0xffff;
    ptr2++;
    val_back2 = *ptr2;
    *ptr2 = 0x0000;
  }else
  if (depth == 8){
    if (dx > -1 && dy > -1){
      unsigned char* ptr = (unsigned char*)&_buffer[dy*row_bytes + dx*depth/8];
      *ptr++ = val_back;
      *ptr = val_back2;
    }
    unsigned char* ptr2 = (unsigned char*)&_buffer[y*row_bytes + x*depth/8];
    val_back = *ptr2;
    *ptr2 = 0xff;
    ptr2++;
    val_back2 = *ptr2;
    *ptr2 = 0x00;
  }
}
void _post_mouse_evt(long px,long py,long ev){
  WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
  WSDdeviceEvent* evt = &(evtl->_event);
  int wid = _search_window(px,py);
  if (wid != 0){
    evt->s.type = ev;
    evt->s.cmd = W_WORK;
    evt->s.wid = wid;
    short wx = _window_list[wid -1]._x;
    short wy = _window_list[wid -1]._y;
    evt->s.wid = wid;
    evt->e.pos.x = px -wx;
    evt->e.pos.y = py -wy;
    evt->s.stat = _mouse_status;
    _touch_pannel_x = px;
    _touch_pannel_y = py;
    _draw_mouse_cursor();
    WSGFdeviceSemLock(_event_sem_id);
    _add_event(evtl);
    WSGFdeviceSemUnlock(_event_sem_id);
#ifndef NO_THREAD
    _wake_up_event();
//          pthread_sem_unlock_np(&_event_sem);
#endif
  }else{
    free(evtl);
  }
}
void post_mouse_move(long px,long py){
  _post_mouse_evt(px,py,EV_NULL);
}
#ifdef FR461
void post_mouse_press(long px,long py){
  _mouse_status = ES_BUT;
  _post_mouse_evt(px,py,EV_BUTDWN);
}
void post_mouse_release(long px,long py){
  _mouse_status = 0;
  _post_mouse_evt(px,py,EV_BUTUP);
}
#endif
#ifndef NO_THREAD
void* _mouse_input_thread(void*){
  int readlen;
  struct input_event event;
//printf("_input_thread started.. _mouse_dev=0x%x\n",_mouse_dev);
  while((readlen = read(_mouse_dev,&event,sizeof(struct input_event))) > 0 || errno == EINTR){
//printf("mouse event readlen=0x%x %x ev=%d code=%x val=%x\n",readlen,sizeof(struct input_event),event.type,event.code,event.value);
//printf("mouse event readlen=0x%x %x\n",readlen,sizeof(struct input_event));
    if (readlen != sizeof(struct input_event)){
      continue;
    }
    int px = _touch_pannel_x;
    int py = _touch_pannel_y;
    if (event.type == EV_REL){
      if (event.code == REL_X){
        px += event.value;
        if (px < 0){
          px =0;
        }else if (!(px < _device_width)){
          px = _device_width -1;
        }
      }else
      if (event.code == REL_Y){
        py += event.value;
        if (py < 0){
          py =0;
        }else if (!(py < _device_height)){
          py = _device_height -1;
        }
      }
      if (px != _touch_pannel_x || py != _touch_pannel_y){
        post_mouse_move(px,py);
        continue;
      }
    }else
    if (event.type == EV_ABS){
      if (event.code == ABS_X){
#ifdef FR461
        event.value = (event.value -TOUCH_PANEL_X_OFFSET)*_device_width/TOUCH_PANEL_WIDTH;
#endif
        px = event.value;
        if (px < 0){
          px =0;
        }else if (!(px < _device_width)){
          px = _device_width -1;
        }
      }else
      if (event.code == ABS_Y){
#ifdef FR461
        event.value = (event.value -TOUCH_PANEL_Y_OFFSET)*_device_height/TOUCH_PANEL_HEIGHT;
#endif
        py = event.value;
        if (py < 0){
          py =0;
        }else if (!(py < _device_height)){
          py = _device_height -1;
        }
#ifdef FR461
        if (px != _touch_pannel_x || py != _touch_pannel_y){
          post_mouse_press(px,py);
          post_mouse_release(px,py);
          continue;
        }
#endif
      }
      if (px != _touch_pannel_x || py != _touch_pannel_y){
        post_mouse_move(px,py);
        continue;
      }
    }

    if (event.type == EV_KEY){
      if (event.code == BTN_LEFT ||
          event.code == BTN_MIDDLE ||
          event.code == BTN_RIGHT){
        int mouse_status = _mouse_status;
        if (event.value == 1){
          switch(event.code){
            case BTN_LEFT:
              mouse_status |= ES_BUT;
              break;
            case BTN_RIGHT:
              mouse_status |= ES_BUT2;
              break;
          }
        }else{
          switch(event.code){
            case BTN_LEFT:
              mouse_status &= ~ES_BUT;
              break;
            case BTN_RIGHT:
              mouse_status &= ~ES_BUT2;
              break;
          }
        }
        if (mouse_status != _mouse_status){
          _mouse_status = mouse_status;
          WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
          WSDdeviceEvent* evt = &(evtl->_event);
          int wid = _search_window(px,py);
          if (wid != 0){
            if (event.value == 1){
              evt->s.type = EV_BUTDWN;
            }else{
              evt->s.type = EV_BUTUP;
            }
            evt->s.cmd = W_WORK;
            evt->s.wid = wid;
            short wx = _window_list[wid -1]._x;
            short wy = _window_list[wid -1]._y;
            evt->s.wid = wid;
            evt->e.pos.x = px -wx;
            evt->e.pos.y = py -wy;
            evt->s.stat = _mouse_status;
            _touch_pannel_x = px;
            _touch_pannel_y = py;
            _draw_mouse_cursor();
            WSGFdeviceSemLock(_event_sem_id);
            _add_event(evtl);
            WSGFdeviceSemUnlock(_event_sem_id);
#ifndef NO_THREAD
            _wake_up_event();
//            pthread_sem_unlock_np(&_event_sem);
#endif
          }else{
            free(evtl);
          }
          continue;
        }
      }
    }
  }
}
void* _keyboard_input_thread(void*){
  int readlen;
  struct input_event event;
//printf("_input_thread started.. _mouse_dev=0x%x\n",_mouse_dev);
  while((readlen = read(_keyb_dev,&event,sizeof(struct input_event))) > 0 || errno == EINTR){
//printf("keyboard event readlen=0x%x %x ev=%d code=%x val=%x\n",readlen,sizeof(struct input_event),event.type,event.code,event.value);
//printf("mouse event readlen=0x%x %x\n",readlen,sizeof(struct input_event));
    if (readlen != sizeof(struct input_event)){
      continue;
    }
    if (event.type == EV_KEY){
        int keyb_status = _keyb_status;
        if (event.value == 1){
          switch(event.code){
            case KEY_LEFTSHIFT:
            case KEY_RIGHTSHIFT:
              keyb_status |= 0x10;
              break;
            case KEY_CAPSLOCK:
              keyb_status |= 0x08;
              break;
            case KEY_LEFTCTRL:
            case KEY_RIGHTCTRL:
              keyb_status |= 0x80;
              break;
            case KEY_LEFTALT:
            case KEY_RIGHTALT:
              keyb_status |= 0x40;
              break;
          }
        }else{
          switch(event.code){
            case KEY_LEFTSHIFT:
            case KEY_RIGHTSHIFT:
              keyb_status &= ~0x10;
              break;
            case KEY_CAPSLOCK:
              keyb_status &= ~0x08;
              break;
            case KEY_LEFTCTRL:
            case KEY_RIGHTCTRL:
              keyb_status &= ~0x80;
              break;
            case KEY_LEFTALT:
            case KEY_RIGHTALT:
              keyb_status &= ~0x40;
              break;
          }
        }
//        if (keyb_status != _keyb_status){
          _keyb_status = keyb_status;
          WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
          WSDdeviceEvent* evt = &(evtl->_event);
//          int wid = _search_window(px,py);
//          if (wid != 0){
            if (event.value == 1){
              evt->s.type = EV_KEYDWN;
            }else{
              evt->s.type = EV_KEYUP;
            }
            evt->s.cmd = 0;
            evt->s.stat = _keyb_status;
            switch(event.code){
              case KEY_LEFTSHIFT:
                evt->s.wid = WSK_Shift_L;
                break;
              case KEY_RIGHTSHIFT:
                evt->s.wid = WSK_Shift_R;
                break;
              case KEY_CAPSLOCK:
                evt->s.wid = WSK_Caps_Lock;
                break;
              case KEY_LEFTCTRL:
                evt->s.wid = WSK_Control_L;
                break;
              case KEY_RIGHTCTRL:
                evt->s.wid = WSK_Control_R;
                break;
              case KEY_LEFTALT:
                evt->s.wid = WSK_Alt_L;
                break;
              case KEY_RIGHTALT:
                evt->s.wid = WSK_Alt_R;
                break;
              case KEY_ESC:
                evt->s.wid = WSK_Escape;
                break;
              case KEY_1:
                evt->s.wid = WSK_1;
                break;
              case KEY_2:
                evt->s.wid = WSK_2;
                break;
              case KEY_3:
                evt->s.wid = WSK_3;
                break;
              case KEY_4:
                evt->s.wid = WSK_4;
                break;
              case KEY_5:
                evt->s.wid = WSK_5;
                break;
              case KEY_6:
                evt->s.wid = WSK_6;
                break;
              case KEY_7:
                evt->s.wid = WSK_7;
                break;
              case KEY_8:
                evt->s.wid = WSK_8;
                break;
              case KEY_9:
                evt->s.wid = WSK_9;
                break;
              case KEY_0:
                evt->s.wid = WSK_0;
                break;
              case KEY_MINUS:
                evt->s.wid = WSK_minus;
                break;
              case KEY_EQUAL:
                evt->s.wid = WSK_equal;
                break;
              case KEY_BACKSPACE:
                evt->s.wid = WSK_BackSpace;
                break;
              case KEY_TAB:
                evt->s.wid = WSK_Tab;
                break;
              case KEY_Q:
                evt->s.wid = WSK_Q;
                break;
              case KEY_W:
                evt->s.wid = WSK_W;
                break;
              case KEY_E:
                evt->s.wid = WSK_E;
                break;
              case KEY_R:
                evt->s.wid = WSK_R;
                break;
              case KEY_T:
                evt->s.wid = WSK_T;
                break;
              case KEY_Y:
                evt->s.wid = WSK_Y;
                break;
              case KEY_U:
                evt->s.wid = WSK_U;
                break;
              case KEY_I:
                evt->s.wid = WSK_I;
                break;
              case KEY_O:
                evt->s.wid = WSK_O;
                break;
              case KEY_P:
                evt->s.wid = WSK_P;
                break;
              case KEY_LEFTBRACE:
                evt->s.wid = WSK_braceleft;
                break;
              case KEY_RIGHTBRACE:
                evt->s.wid = WSK_braceright;
                break;
              case KEY_ENTER:
                evt->s.wid = WSK_Return;
                break;
              case KEY_A:
                evt->s.wid = WSK_A;
                break;
              case KEY_S:
                evt->s.wid = WSK_S;
                break;
              case KEY_D:
                evt->s.wid = WSK_D;
                break;
              case KEY_F:
                evt->s.wid = WSK_F;
                break;
              case KEY_G:
                evt->s.wid = WSK_G;
                break;
              case KEY_H:
                evt->s.wid = WSK_H;
                break;
              case KEY_J:
                evt->s.wid = WSK_J;
                break;
              case KEY_K:
                evt->s.wid = WSK_K;
                break;
              case KEY_L:
                evt->s.wid = WSK_L;
                break;
              case KEY_SEMICOLON:
                evt->s.wid = WSK_semicolon;
                break;
              case KEY_APOSTROPHE:
                evt->s.wid = WSK_apostrophe;
                break;
              case KEY_GRAVE:
                evt->s.wid = WSK_grave;
                break;
              case KEY_BACKSLASH:
                evt->s.wid = WSK_backslash;
                break;
              case KEY_Z:
                evt->s.wid = WSK_Z;
                break;
              case KEY_X:
                evt->s.wid = WSK_X;
                break;
              case KEY_C:
                evt->s.wid = WSK_C;
                break;
              case KEY_V:
                evt->s.wid = WSK_V;
                break;
              case KEY_B:
                evt->s.wid = WSK_B;
                break;
              case KEY_N:
                evt->s.wid = WSK_N;
                break;
              case KEY_M:
                evt->s.wid = WSK_M;
                break;
              case KEY_COMMA:
                evt->s.wid = WSK_comma;
                break;
              case KEY_DOT:
                evt->s.wid = WSK_period;
                break;
              case KEY_SLASH:
                evt->s.wid = WSK_slash;
                break;
              case KEY_KPASTERISK:
                evt->s.wid = WSK_asterisk;
                break;
              case KEY_SPACE:
                evt->s.wid = WSK_space;
                break;
              case KEY_F1:
                evt->s.wid = WSK_F1;
                break;
              case KEY_F2:
                evt->s.wid = WSK_F2;
                break;
              case KEY_F3:
                evt->s.wid = WSK_F3;
                break;
              case KEY_F4:
                evt->s.wid = WSK_F4;
                break;
              case KEY_F5:
                evt->s.wid = WSK_F5;
                break;
              case KEY_F6:
                evt->s.wid = WSK_F6;
                break;
              case KEY_F7:
                evt->s.wid = WSK_F7;
                break;
              case KEY_F8:
                evt->s.wid = WSK_F8;
                break;
              case KEY_F9:
                evt->s.wid = WSK_F9;
                break;
              case KEY_F10:
                evt->s.wid = WSK_F10;
                break;
              case KEY_NUMLOCK:
                evt->s.wid = WSK_Num_Lock;
                break;
              case KEY_SCROLLLOCK:
                evt->s.wid = WSK_Scroll_Lock;
                break;
              case KEY_KP7:
                evt->s.wid = WSK_KP_7;
                break;
              case KEY_KP8:
                evt->s.wid = WSK_KP_8;
                break;
              case KEY_KP9:
                evt->s.wid = WSK_KP_9;
                break;
              case KEY_KPMINUS:
                evt->s.wid = WSK_KP_Subtract;
                break;
              case KEY_KP4:
                evt->s.wid = WSK_KP_4;
                break;
              case KEY_KP5:
                evt->s.wid = WSK_KP_5;
                break;
              case KEY_KP6:
                evt->s.wid = WSK_KP_6;
                break;
              case KEY_KPPLUS:
                evt->s.wid = WSK_KP_Add;
                break;
              case KEY_KP1:
                evt->s.wid = WSK_KP_1;
                break;
              case KEY_KP2:
                evt->s.wid = WSK_KP_2;
                break;
              case KEY_KP3:
                evt->s.wid = WSK_KP_3;
                break;
              case KEY_KP0:
                evt->s.wid = WSK_KP_0;
                break;
              case KEY_KPDOT:
                evt->s.wid = WSK_KP_Decimal;
                break;
              case KEY_F11:
                evt->s.wid = WSK_F11;
                break;
              case KEY_F12:
                evt->s.wid = WSK_F12;
                break;
              case KEY_F13:
                evt->s.wid = WSK_F13;
                break;
              case KEY_F14:
                evt->s.wid = WSK_F14;
                break;
              case KEY_F15:
                evt->s.wid = WSK_F15;
                break;
              case KEY_F16:
                evt->s.wid = WSK_F16;
                break;
              case KEY_F17:
                evt->s.wid = WSK_F17;
                break;
              case KEY_F18:
                evt->s.wid = WSK_F18;
                break;
              case KEY_F19:
                evt->s.wid = WSK_F19;
                break;
              case KEY_F20:
                evt->s.wid = WSK_F20;
                break;
              case KEY_KPENTER:
                evt->s.wid = WSK_KP_Enter;
                break;
              case KEY_KPSLASH:
                evt->s.wid = WSK_KP_Divide;
                break;
              case KEY_SYSRQ:
                evt->s.wid = WSK_Sys_Req;
                break;
              case KEY_LINEFEED:
                evt->s.wid = WSK_Linefeed;
                break;
              case KEY_HOME:
                evt->s.wid = WSK_Home;
                break;
              case KEY_UP:
                evt->s.wid = WSK_Up;
                break;
              case KEY_PAGEUP:
                evt->s.wid = WSK_Page_Up;
                break;
              case KEY_LEFT:
                evt->s.wid = WSK_Left;
                break;
              case KEY_RIGHT:
                evt->s.wid = WSK_Right;
                break;
              case KEY_END:
                evt->s.wid = WSK_End;
                break;
              case KEY_DOWN:
                evt->s.wid = WSK_Down;
                break;
              case KEY_PAGEDOWN:
                evt->s.wid = WSK_Page_Down;
                break;
              case KEY_INSERT:
                evt->s.wid = WSK_Insert;
                break;
              case KEY_DELETE:
                evt->s.wid = WSK_Delete;
                break;
              case KEY_KPEQUAL:
                evt->s.wid = WSK_KP_Equal;
                break;
              case KEY_KPPLUSMINUS:
                evt->s.wid = WSK_plusminus;
                break;
              case KEY_PAUSE:
                evt->s.wid = WSK_Pause;
                break;
              default:
                evt->s.wid = -1;
                break;
            }
//printf("evt->.s.wid=%d\n",evt->s.wid);
            WSGFdeviceSemLock(_event_sem_id);
            _add_event(evtl);
            WSGFdeviceSemUnlock(_event_sem_id);
#ifndef NO_THREAD
            _wake_up_event();
//            pthread_sem_unlock_np(&_event_sem);
#endif
//          }else{
//            free(evtl);
//          }
          continue;
//        }
    }
  }
}




#endif
#if (defined NO_THREAD) && !(defined MB93093)
void _mouse_input_proc(){
  int readlen;
  struct input_event event;
//printf("_zaurus_input_thread started..\n");
  while(1){
    int readlen;
    char buffer[16];
//printf("_mouse_input_proc started..\n");fflush(stdout);
    fd_set read_fds;
    FD_ZERO(&read_fds);
    int width=_mouse_dev+1;
    FD_SET(_mouse_dev,&read_fds);
    struct timeval tm;
    tm.tv_sec = 0;
    tm.tv_usec = 0;
    int ret = select(width,&read_fds,NULL,NULL,&tm);
    if (ret > 0){

      while((readlen = read(_mouse_dev,&event,sizeof(struct input_event))) > 0 || errno == EINTR){
        if (readlen != sizeof(struct input_event)){
          continue;
        }
        int px = _touch_pannel_x;
        int py = _touch_pannel_y;

        if (event.type == EV_REL){
          if (event.code == REL_X){
            px += event.value;
            if (px < 0){
              px =0;
            }else if (!(px < _device_width)){
              px = _device_width -1;
            }
          }else
          if (event.code == REL_Y){
            py += event.value;
            if (py < 0){
              py =0;
            }else if (!(py < _device_height)){
              py = _device_height -1;
            }
          }
          if (px != _touch_pannel_x || py != _touch_pannel_y){
            WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
            WSDdeviceEvent* evt = &(evtl->_event);
            int wid = _search_window(px,py);
            if (wid != 0){
              evt->s.type = EV_NULL;
              evt->s.cmd = W_WORK;
              evt->s.wid = wid;
              short wx = _window_list[wid -1]._x;
              short wy = _window_list[wid -1]._y;
              evt->s.wid = wid;
              evt->e.pos.x = px -wx;
              evt->e.pos.y = py -wy;
              evt->s.stat = _mouse_status;
              _touch_pannel_x = px;
              _touch_pannel_y = py;
              _draw_mouse_cursor();
              _add_event(evtl);
            }else{
              free(evtl);
            }
            continue;
          }
        }

        if (event.type == EV_KEY){
          if (event.code == BTN_LEFT ||
              event.code == BTN_MIDDLE ||
              event.code == BTN_RIGHT){
            int mouse_status = _mouse_status;
            if (event.value == 1){
              switch(event.code){
                case BTN_LEFT:
                  mouse_status |= ES_BUT;
                  break;
                case BTN_RIGHT:
                  mouse_status |= ES_BUT2;
                  break;
              }
            }else{
              switch(event.code){
                case BTN_LEFT:
                  mouse_status &= ~ES_BUT;
                  break;
                case BTN_RIGHT:
                  mouse_status &= ~ES_BUT2;
                  break;
              }
            }
            if (mouse_status != _mouse_status){
              _mouse_status = mouse_status;
              WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
              WSDdeviceEvent* evt = &(evtl->_event);
              int wid = _search_window(px,py);
              if (wid != 0){
                if (event.value == 1){
                  evt->s.type = EV_BUTDWN;
                }else{
                  evt->s.type = EV_BUTUP;
                }
                evt->s.cmd = W_WORK;
                evt->s.wid = wid;
                short wx = _window_list[wid -1]._x;
                short wy = _window_list[wid -1]._y;
                evt->s.wid = wid;
                evt->e.pos.x = px -wx;
                evt->e.pos.y = py -wy;
                evt->s.stat = _mouse_status;
                _touch_pannel_x = px;
                _touch_pannel_y = py;
                _draw_mouse_cursor();
                _add_event(evtl);
              }else{
                free(evtl);
              }
              continue;
            }
          }
        }
      }
    }else{
      return;
    }
  }
}
#endif

#ifdef MB93093
int _touch_pannel_pressed = 0;
int _mouse_input_proc(){
  while(1){
  int readlen;
  char buffer[16];
//printf("_mouse_input_proc started..\n");fflush(stdout);
  fd_set read_fds;
  FD_ZERO(&read_fds);
  int width=_mouse_dev+1;
  FD_SET(_mouse_dev,&read_fds);
  struct timeval tm;
  tm.tv_sec = 0;
  tm.tv_usec = 0;
  int ret = select(width,&read_fds,NULL,NULL,&tm);
  if (ret > 0){
    int i;
    for(i=0; i<11; i++){
      char tmp;
      int r = read(_mouse_dev,&tmp,1);
      if (tmp == 0x0d){
        buffer[i] = 0;
        break;
      }
      buffer[i] = tmp;
//printf("0x%x ",tmp);
    }
//printf("\n");
    buffer[11] = 0;
    if (strlen(buffer) != 10){
      return 0;
    }
    int pressed = False;
//printf("buffer[0]=0x%x\n",buffer[0]);
    if (buffer[0] == 0x54){
      pressed = True;
    }else if (buffer[0]== 0x52){
      pressed = False;
    }else{
      return 0;
    }
    int dx=0,dy=0;
    sscanf(&buffer[1],"%d,%d",&dx,&dy);
//printf("press=%d %d,%d\n",pressed,dx,dy);
#define OFFSET_X  40
#define OFFSET_Y  80
#define X_WIDTH  940
#define Y_WIDTH  890
    int px = (X_WIDTH - (dx - OFFSET_X))*_device_width/X_WIDTH;
    int py = (dy - OFFSET_Y)*_device_height/Y_WIDTH;
#ifdef DOUBLE_SCALE
    px /=2;
    py /=2;
#endif
    if (px < 0){
      px = 0;
    }
    if (px > _device_width -1){
      px = _device_width -1;
    }
    if (py < 0){
      py = 0;
    }
    if (py > _device_height -1){
      py = _device_height -1;
    }
#ifdef ROTATE90
    {
       int tmp = px;
       px = _device_height - py -1;
       py = tmp;
    }
#endif


//printf("pressed=%d _t_pressed=%d\n",pressed,_touch_pannel_pressed);
    if (pressed != 0 && _touch_pannel_pressed == 0){
//printf("px,py=%d,%d pressed\n",px,py);
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int wid = _search_window(px,py);
      if (wid != 0){
        evt->s.type = EV_BUTDWN;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
        evt->s.wid = wid;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
        evt->s.stat = ES_BUT;

        _touch_pannel_x = px;
        _touch_pannel_y = py;
        _touch_pannel_pressed = 1;
        _draw_mouse_cursor();
//        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
//        WSGFdeviceSemUnlock(_event_sem_id);
      }
//      return 0;
      continue;
    }
    if (pressed != 0 ){
      if ( _touch_pannel_x -2 < px && px < _touch_pannel_x +2){
        continue;
//        return 0;
      }
      if ( _touch_pannel_y -2 < py && py < _touch_pannel_y +2){
        continue;
//        return 0;
      }
    }


      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int wid = _search_window(px,py);
      if (wid != 0){
        if (pressed == 0 && _touch_pannel_pressed != 0){
//printf("px,py=%d,%d released\n",px,py);
          evt->s.type = EV_BUTUP;
          _touch_pannel_pressed = 0;
        }else{
//printf("px,py=%d,%d moved\n",px,py);
          evt->s.type = EV_NULL;
        }
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
        evt->s.wid = wid;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
        evt->s.stat = ES_BUT;
        if (_touch_pannel_pressed == 0){
          evt->s.stat = 0;
        }
        _touch_pannel_x = px;
        _touch_pannel_y = py;
        _draw_mouse_cursor();
//        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
//        WSGFdeviceSemUnlock(_event_sem_id);
      }
//      return 0;


  }else{
    return 0;
  }
  }
  return 0;
}
#endif

#ifdef MB93093
#include        <termios.h>
#endif

int init_mouse_input_dev(){
#ifndef MB93093
  _mouse_dev = open(DEFAULT_LINUX_MOUSE_DEVICE,O_RDONLY | O_NOCTTY);
  if (_mouse_dev == -1){
fprintf(stderr,"Can not open mouse device.. dev=%s\n",DEFAULT_LINUX_MOUSE_DEVICE);
  }
#else
  _mouse_dev = open("/dev/ttyS1",O_RDWR | O_NOCTTY,0777);
  if (_mouse_dev > -1){
    struct  termios rs_arg;
    int baud = B19200;
    if (tcgetattr(_mouse_dev, &rs_arg) == -1){
      return WS_ERR;
    }
    cfsetospeed(&rs_arg, baud);
    cfsetispeed(&rs_arg, 0);
    rs_arg.c_cflag |= CRTSCTS | CS8 | CREAD;
    rs_arg.c_lflag = 0;
    rs_arg.c_cc[VTIME]    = 0;
    rs_arg.c_cc[VMIN]     = 1;
    rs_arg.c_iflag = IGNPAR;
    rs_arg.c_oflag = 0;
    tcflush(_mouse_dev, TCIFLUSH);
    if (tcsetattr(_mouse_dev, TCSANOW, &rs_arg) == -1){
      return WS_ERR;
    }
  }
#endif
  if (_mouse_dev == -1){
    return WS_ERR;
  }
#ifndef NO_THREAD
  pthread_create(&_input_mouse_thr,NULL,_mouse_input_thread,NULL);
#endif
  return WS_NO_ERR;
}
int init_keyboard_input_dev(){
#ifndef MB93093
  _keyb_dev = open(DEFAULT_LINUX_KEYB_DEVICE,O_RDONLY | O_NOCTTY);
  if (_keyb_dev == -1){
fprintf(stderr,"Can not open keyboard device.. dev=%s\n",DEFAULT_LINUX_MOUSE_DEVICE);
  }
#ifndef NO_THREAD
  pthread_create(&_input_key_thr,NULL,_keyboard_input_thread,NULL);
#endif
#endif
  return WS_NO_ERR;
}
#else //ZAURUS

//#define DOUBLE_SCALE
#include <linux/h3600_ts.h>
#include <errno.h>
pthread_t     _input_thr=0;
int _touch_pannel_dev =0;
int _touched = 0;
void* _zaurus_input_thread(void*){
  int readlen;
  TS_EVENT ts_event;
//printf("_zaurus_input_thread started..\n");
  while((readlen = read(_touch_pannel_dev,&ts_event,sizeof(TS_EVENT))) > 0 || errno == EINTR){
//printf("ts_event.x=%d y=%d p=%d\n",ts_event.x,ts_event.y,ts_event.pressure);
    int px = ts_event.x;
    int py = ts_event.y;
#ifdef ROTATE90
    {
      int tmp = px;
      px = _device_height - py-1;
      py = tmp;
    }
#endif
#ifdef DOUBLE_SCALE
    px /= 2;
    py /= 2;
#endif
    int diffx = _touch_pannel_x - px;
    if (diffx < 0){
      diffx = -diffx;
    }
    int diffy = _touch_pannel_y - py;
    if (diffy < 0){
      diffy = -diffy;
    }
    if (_touched == 0 && ts_event.pressure != 0){
      _touched = 1;
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int wid = _search_window(px,py);
      if (wid != 0){
        evt->s.type = EV_BUTDWN;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
        evt->s.wid = wid;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
        evt->s.stat = ES_BUT;
        _touch_pannel_x = px;
        _touch_pannel_y = py;
//printf("_input_dev add press event\n");
        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
        WSGFdeviceSemUnlock(_event_sem_id);
//printf("_input_dev add press event done..\n");
#ifndef NO_THREAD
        _wake_up_event();
//        pthread_sem_unlock_np(&_event_sem);
#endif
      }
      continue;
    }else
    if (_touched == 1 && ts_event.pressure == 0){
      _touched = 0;
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int wid = _search_window(px,py);
      if (wid != 0){
        evt->s.type = EV_BUTUP;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
        evt->s.wid = wid;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
        evt->s.stat = 0;

        _touch_pannel_x = px;
        _touch_pannel_y = py;
//printf("_input_dev add release event\n");
        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
        WSGFdeviceSemUnlock(_event_sem_id);
//printf("_input_dev add release event done..\n");
#ifndef NO_THREAD
        _wake_up_event();
//        pthread_sem_unlock_np(&_event_sem);
#endif
      }
      continue;
    }else if (diffx > 0 || diffy >0){
      if (_evt_list != NULL){
        continue;
      }
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int wid = _search_window(px,py);
      evt->s.type = EV_NULL;
      evt->s.wid = 0;
      evt->e.pos.x = px;
      evt->e.pos.y = py;
      evt->s.stat = ES_BUT;
      if (wid != 0){
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
        evt->s.wid = wid;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
      }
      _touch_pannel_x = px;
      _touch_pannel_y = py;
      WSGFdeviceSemLock(_event_sem_id);
      _add_event(evtl);
      WSGFdeviceSemUnlock(_event_sem_id);
#ifndef NO_THREAD
      _wake_up_event();
//      pthread_sem_unlock_np(&_event_sem);
#endif
      continue;
    }
  }
  return NULL;
}

int init_zaurus_input_dev(){
  _touch_pannel_dev = open("/dev/sharp_ts",O_RDONLY | O_NOCTTY);
  if (_touch_pannel_dev == -1){
    return WS_ERR;
  }
  pthread_create(&_input_thr,NULL,_zaurus_input_thread,NULL);
  return WS_NO_ERR;
}
#endif
int _init_frame_buffer(){
  _fb_fd = open(DEFAULT_LINUX_FRAME_BUFFER_DEVICE, O_RDWR);
  if (!_fb_fd) {
    fprintf(stderr,"Error: cannot open %s device.\n",DEFAULT_LINUX_FRAME_BUFFER_DEVICE);
    WSGFexit(1);
  }
  if (ioctl(_fb_fd, FBIOGET_FSCREENINFO, &fix_info)) {
    fprintf(stderr,"Error reading the fixed information of the frame buffer.\n");
    WSGFexit(1);
  }
  if (ioctl(_fb_fd, FBIOGET_VSCREENINFO, &var_info)) {
    fprintf(stderr,"Error reading the variable information of the frame buffer.\n");
    WSGFexit(1);
  }
//printf("res=%dx%d, %dbpp\n", var_info.xres, var_info.yres, var_info.bits_per_pixel );
  _device_width = var_info.xres;
  _device_height = var_info.yres;

  _device_buffer_size =
             var_info.xres * var_info.yres * var_info.bits_per_pixel / 8;
  _fb_addr = (char *)mmap(0, _device_buffer_size,
                          PROT_READ | PROT_WRITE, MAP_SHARED,
                          _fb_fd, 0);
  if ((int)_fb_addr == -1){
#ifdef MB93093
    _fb_addr = (char*)fix_info.smem_start;
    memset(_fb_addr,0x00,_device_buffer_size);
    _fb_addr = (char*)fix_info.smem_start+32;
#else
    _fb_addr = (char*)fix_info.smem_start;
#endif
dbprintf("type=%d type_aux=%d visual=%d panstep=%d,%d wrap=%d\n",fix_info.type,fix_info.type_aux,fix_info.visual,fix_info.xpanstep,fix_info.ypanstep,fix_info.ywrapstep);
dbprintf("line_len=%d mmio=0x%x buf=0x%x accel=%d\n",fix_info.line_length,fix_info.mmio_start,fix_info.smem_start,fix_info.accel);
  }
  _device_depth = var_info.bits_per_pixel;
  _device_row_bytes = _device_width * _device_depth / 8;
dbprintf("_device_row_bytes=%d depth=%d\n",_device_row_bytes,_device_depth);
dbprintf("red=%d,%d green=%d,%d blue=%d,%d transp=%d,%d\n", var_info.red.offset, var_info.red.length, var_info.green.offset, var_info.green.length, var_info.blue.offset, var_info.blue.length, var_info.transp.offset, var_info.transp.length);
#ifdef USE_SAME_BUF
  if (fix_info.visual == FB_VISUAL_TRUECOLOR){
    _device_start_red = var_info.red.offset;
    _device_start_green = var_info.green.offset;
    _device_start_blue = var_info.blue.offset;
    _device_red_bits = var_info.red.length;
    _device_green_bits = var_info.green.length;
    _device_blue_bits = var_info.blue.length;
  }else{
    if (_device_depth == 32){
      _device_start_red = 16;
      _device_start_green = 8;
      _device_start_blue = 0;
      _device_red_bits = 8;
      _device_green_bits = 8;
      _device_blue_bits = 8;
    }else if (_device_depth == 24){
      _device_start_red = 16;
      _device_start_green = 8;
      _device_start_blue = 0;
      _device_red_bits = 8;
      _device_green_bits = 8;
      _device_blue_bits = 8;
    }else if (_device_depth == 16){
      _device_start_red = 11;
      _device_start_green = 5;
      _device_start_blue = 0;
      _device_red_bits = 5;
      _device_green_bits = 6;
      _device_blue_bits = 5;
    }
  }
//printf("device: w,h,d=%d,%d,%d\n",_device_width,_device_height,_device_depth);
  _buffer = (unsigned char*)_fb_addr;
  memset(_buffer,0xff,_device_buffer_size);
#else
  long buf_size = _device_height * _device_row_bytes;
  _buffer = (unsigned char*)malloc(buf_size);
#endif

#ifndef NO_THREAD
//  pthread_sem_init_np(&_event_sem);
//  pthread_sem_lock_np(&_event_sem);
#endif

#ifndef ZAURUS
  init_mouse_input_dev();
  init_keyboard_input_dev();
#else
  init_zaurus_input_dev();
#endif

  if ((int)_fb_addr == -1) {
    fprintf(stderr,"Error: failed to map framebuffer device to memory.\n");
    WSGFexit(1);
  }
  return 0;
}
int _update_frame_buffer(int x1,int y1,unsigned int w1,unsigned int h1){
//printf("_update_frame_buffer.. started\n");
#ifdef USE_SAME_BUF
#else
  unsigned int depth =   _device_depth;
  unsigned int row_bytes = _device_row_bytes;
#ifdef ROTATE90
  long tmp = x1;
  x1 = y1;
  y1 = _device_height - tmp - w1;
  tmp = w1;
  w1 = h1;
  h1 = tmp;
#endif

  int x;
  int y;
  for ( y = y1; y < y1 + h1; y++ ){
    int pos = (var_info.xoffset + x1) * (var_info.bits_per_pixel/8) +
                       (y+var_info.yoffset) * fix_info.line_length;
    for ( x = x1; x < x1 + w1; x++ ){
      unsigned int val = 0;

      if (depth == 32){
        unsigned int* ptr = (unsigned int*)&_buffer[y*row_bytes + x*depth/8];
        val = *ptr;
      }else
      if (depth == 16){
        unsigned short* ptr = (unsigned short*)&_buffer[y*row_bytes + x*depth/8];
        val = *ptr;
      }

      unsigned char rr = (val >> _device_start_red) << (8 -_device_red_bits);
      unsigned char gg = (val >> _device_start_green) << (8 -_device_green_bits);
      unsigned char bb = (val >> _device_start_blue) << (8 -_device_blue_bits);
      if ( var_info.bits_per_pixel == 32 ) {
        _fb_addr[pos++] = bb;
        _fb_addr[pos++] = gg;
        _fb_addr[pos++] = rr;
        _fb_addr[pos++] = 0;
      }else if (var_info.bits_per_pixel == 16){
        unsigned short* ptr = (unsigned short*)&_fb_addr[pos++];
        unsigned short int v = (rr>>3)<<11 | (gg>>2) << 5 | (bb>>3);
        *((unsigned short int*)(ptr)) = v;
        pos++;
      }
    }
  }
#endif
//printf("_update_frame_buffer.. done\n");
  return 0;
}
int _get_event(WSDdeviceEvent* evt,unsigned int mode){
#ifdef NO_THREAD
  _mouse_input_proc();
#endif
  if (_evt_list == NULL){
    if ( _device_check_event_available() != False ){
      evt->s.type = EV_MSG;
      return WS_NO_ERR;
    }
    return WS_ERR;
  }

  WSDdeviceEventList* item = _evt_list;
  WSDdeviceEventList* item_bak = NULL;
  while(1){
    if (item == NULL){
      break;
    }
    if ((mode & 0xfff0 ) == DSPEVT){
      if (item->_event.r.type != EV_REQUEST){
        item_bak = item;
        item = item->_next;
        continue;
      }
      if (item->_event.r.cmd != W_REDISP){
        item_bak = item;
        item = item->_next;
        continue;
      }
    }
    if (item_bak == NULL){
      _evt_list = item->_next;
    }else{
      item_bak->_next = item->_next;
    }
    memcpy(evt,&(item->_event),sizeof(WSDdeviceEvent));
    free(item);
    return WS_NO_ERR;
  }
  if ((mode & 0xfff0 ) == DSPEVT){
    return WS_ERR;
  }
  //TODO: get mouse event..
  //TODO: get key event..
  if ( _device_check_event_available() != False ){
    evt->s.type = EV_MSG;
    return WS_NO_ERR;
  }
  return 0;
}

