//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <WScom.h>
#include <Carbon/Carbon.h>
#include <devfb/devfb.h>
#include <devfb/devfb_dep.h>
#include <WSDappDev.h>
#include <WSCbaseList.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <devfb/WSDdevfbFormDev.h>
#include <devfb/WSDdevfbAppDev.h>

#include <sys/time.h>
#include <pthread.h>
//#include <X11/Xlib.h>
//#include <X11/Xutil.h>
#include <WSDkeyboard.h>
#include "fbconfig.h"

extern int _add_event(WSDdeviceEventList* evt);
extern int _device_check_event_available();
extern int _search_window(short x,short y);

extern int _init_for_event_function();
extern int _wake_up_event();
extern int _wait_event();

extern int get_window(WindowRef window);
extern int get_window_by_control(ControlRef window);

int red_mask, green_mask, blue_mask;
int red_shift, green_shift, blue_shift;

short _mouse_pos_x = 0;
short _mouse_pos_y = 0;

extern void (*_create_window_handler)(WSDdeviceWindow*);
extern void (*_update_window_handler)(WSDdeviceWindow*);
extern void (*_destroy_window_handler)(WSDdeviceWindow*);

extern void mac_create_window(WSDdeviceWindow*);
extern void mac_update_window(WSDdeviceWindow*);
extern void mac_update_geom_window(WSDdeviceWindow*);
extern void mac_destroy_window(WSDdeviceWindow*);

pthread_t _input_thr = 0;
unsigned int _mouse_status = 0;
extern void* _mac_input_thread(void*);

//regular internal functions -------------------------
void _get_mouse_pos(short* x,short* y){
  *x = _mouse_pos_x;
  *y = _mouse_pos_y;
}

int _init_frame_buffer(){
  _device_width = 1440;
  _device_height = 900;
  _create_window_handler = mac_create_window;
  _update_window_handler = mac_update_geom_window;
  _destroy_window_handler = mac_destroy_window;

  red_mask = 0xff0000;
  red_shift = 16;

  green_mask = 0xff00;
  green_shift = 8;

  blue_mask = 0xff;
  blue_shift = 0;

  pthread_create(&_input_thr,NULL,_mac_input_thread,NULL);
  return WS_NO_ERR;
}

int _update_frame_buffer(int x,int y,unsigned int w,unsigned int h){
#if 0
  int i;
  for(i=0; i<WS_MAX_GC;i++){
    if (_gc_list[i]._gid == 0){
      continue;
    }
    if (_gc_list[i]._updated == 0){
      continue;
    }
    if (_gc_list[i]._window_id == 0){
      continue;
    }
    mac_update_window(&_window_list[_gc_list[i]._window_id-1]);
    _gc_list[i]._updated = 0;
  }
#endif
  return WS_NO_ERR;
}

int _get_event(WSDdeviceEvent* evt,unsigned int mode){
//printf("get_event thr=0x%x\n",pthread_self());fflush(stdout);
#if 0 //This logic causes not enough drawing.., removed.
  int i;
  for(i=0; i<WS_MAX_GC;i++){
    if (_gc_list[i]._gid == 0){
      continue;
    }
    if (_gc_list[i]._updated == 0){
      continue;
    }
    if (_gc_list[i]._window_id == 0){
      continue;
    }
    mac_update_window(&_window_list[_gc_list[i]._window_id-1]);
    _gc_list[i]._updated = 0;
  }
#endif
  if (_evt_list == NULL){
    if ( _device_check_event_available() != False ){
      evt->s.type = EV_MSG;
      return WS_NO_ERR;
    }
    return WS_ERR;
  }
  WSDdeviceEventList* item = _evt_list;
  WSDdeviceEventList* item_bak = NULL;
  while(1){
    if (item == NULL){
      break;
    }
    if ((mode & 0xfff0 ) == DSPEVT){
      if (item->_event.r.type != EV_REQUEST){
        item_bak = item;
        item = item->_next;
        continue;
      }
      if (item->_event.r.cmd != W_REDISP){
        item_bak = item;
        item = item->_next;
        continue;
      }
    }
    if (item_bak == NULL){
      _evt_list = item->_next;
    }else{
      item_bak->_next = item->_next;
    }
    memcpy(evt,&(item->_event),sizeof(WSDdeviceEvent));
    free(item);
//printf("get_event get evt!!! type=0x%x\n",evt->r.type);
    return WS_NO_ERR;
  }
//printf("get_event get evt!!! return2\n");
  if ((mode & 0xfff0 ) == DSPEVT){
    return WS_ERR;
  }
  //TODO: get mouse event..
  //TODO: get key event..
  if ( _device_check_event_available() != False ){
    evt->s.type = EV_MSG;
    return WS_NO_ERR;
  }
  return WS_ERR;
}

#define kALRT_About             200     // About... alert
#define kMBAR_Main              128     // Menu Bar
#define kMENU_Apple             128     // Apple menu
#define kMENU_File              129     // File menu
#define kMENU_Edit              130     // Edit menu
#define kAboutMenuItem          1
#define kNewMenuItem            1
#define kCloseMenuItem          2
#define kQuitSeparatorMenuItem  3
#define kQuitMenuItem           4

void handleMenuEvents(EventRecord event){
  short menuID;           // resource ID of selected menu
  short menuItem;         // item number of selected menu
  long menuResult = MenuSelect( event.where );
  menuID = HiWord( menuResult );
  menuItem = LoWord( menuResult );
//printf("WSDmacAppDev::handleMenuEvents..\n");
  switch( menuID ) {
    case kMENU_Apple:
      switch( menuItem ) {
        case kAboutMenuItem:
          Alert( kALRT_About, nil );  // simple alert dialog box
          break;
        default:
          break;
      }
      break;
    case kMENU_File:
      switch( menuItem ) {
        case kNewMenuItem:
          break;
        case kCloseMenuItem:
          break;
        case kQuitMenuItem:
          break;
      }
      break;
    case kMENU_Edit:
      break;
  }
  HiliteMenu( 0 );
}

//---------------------------------------------- 
void* _mac_input_thread(void*){
  CGrafPtr disp = GetQDGlobalsThePort();
  Rect r;
  GetPortBounds(disp,&r);
  _device_width = r.right;
  _device_height = r.bottom;
  EventRecord event;
  WindowRef window;
  short part;
  Rect tempRect;
  while(1){
    int i;
    WSGFdeviceSemLock(_sem_id);
    for(i=0; i<WS_MAX_GC;i++){
      if (_gc_list[i]._gid == 0){
        continue;
      }
      if (_gc_list[i]._window_id == 0){
        continue;
      }
      if (_gc_list[i]._updated == 0){
        continue;
      }
      WSDdeviceWindow* win = &_window_list[_gc_list[i]._window_id-1];
      if (win->_top_float == 1){
        win->_top_float = 0;
        BringToFront(win->_native_window);
      }
      mac_update_window(win);
      _gc_list[i]._updated = 0;
    }
    WSGFdeviceSemUnlock(_sem_id);

#ifdef ECLIPSE_PLUGIN
    sleep(1);
    continue;
#else
    if (WaitNextEvent(everyEvent,&event,1,nil)){
//printf("after event=0x%x msg=0x%x\n",event.what,event.message);
      switch(event.what){
        case osEvt:{
          break;
        }
        case mouseDown:
          part = FindWindow( event.where, &window );
          switch( part ) {
            case inMenuBar:
              handleMenuEvents(event);
              break;
            case inSysWindow:
              break;
            case inContent:
              break;
            case inDrag:{
              break;
            }
            case inGrow:{
              break;
            }
           case inGoAway:
             break;
           case inZoomIn:
           case inZoomOut:{
             break;
           }
         }
         break;
       case keyUp:
       case keyDown:
       case autoKey:{
         break;
       }
       case activateEvt:{
#if 0
         long wid = get_window(window);
         if (wid > -1){
           WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
           WSDdeviceEvent* evt = &(evtl->_event);
           evt->r.wid = wid;
           evt->r.cmd = W_REDISP;
           evt->r.type = EV_REQUEST;
           evt->r.r.c.left = _window_list[wid-1]._x;
           evt->r.r.c.top = _window_list[wid-1]._y;
           evt->r.r.c.right = _window_list[wid-1]._x + _window_list[wid-1]._w;
           evt->r.r.c.bottom = _window_list[wid-1]._y + _window_list[wid-1]._h;

           WSGFdeviceSemLock(_event_sem_id);
           _add_event(evtl);
           WSGFdeviceSemUnlock(_event_sem_id);
           _wake_up_event();
         }
#endif
         break;
       }
       case updateEvt:
         break;
       case kHighLevelEvent:
//printf("kHighLevelEvent..\n");
         AEProcessAppleEvent( &event );
         break;
       case diskEvt:
         break;
       }
     }
#endif
   }


#if 0
  switch(e.type){
    case Expose:{
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      evt->s.wid = target_win;
      evt->s.type = EV_SWITCH;
        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
        WSGFdeviceSemUnlock(_event_sem_id);
        _wake_up_event();
       break;
    }
    case ButtonPress:{
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int px = e.xbutton.x;
      int py = e.xbutton.y;
      int bt = e.xbutton.button;
      int wid = target_win;
      if (wid > 0){
        short wx = 0;
        short wy = 0;
        evt->s.stat = 0;
        if (bt == 1){
          _mouse_status |= 1;
        }
        if (bt == 2){
          _mouse_status |= 2;
        }
        if (bt == 3){
          _mouse_status |= 4;
        }
        if (_mouse_status & 1){
          evt->s.stat |= ES_BUT;
        }
        if (_mouse_status & 2){
          evt->s.stat |= ES_BUT2;
        }
        _mouse_pos_x = px + _window_list[wid -1]._x;
        _mouse_pos_y = py + _window_list[wid -1]._y;
        evt->e.pos.x = px;
        evt->e.pos.y = py;
        evt->s.type = EV_BUTDWN;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
        WSGFdeviceSemUnlock(_event_sem_id);
        _wake_up_event();
      }else{
        delete evtl;
      }
      break;
    }
    case ButtonRelease:{
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int px = e.xbutton.x;
      int py = e.xbutton.y;
      int bt = e.xbutton.button;
      int wid = target_win;
      if (wid > 0){
        short wx = 0;
        short wy = 0;
        evt->s.stat = 0;
        if (bt == 1){
          _mouse_status &= ~Button1Mask;
        }
        if (bt == 2){
          _mouse_status &= ~Button2Mask;
        }
        if (bt == 3){
          _mouse_status &= ~Button3Mask;
        }
        if (_mouse_status & Button1Mask){
          evt->s.stat |= ES_BUT;
        }
        if (_mouse_status & Button3Mask){
          evt->s.stat |= ES_BUT2;
        }

        if (control != NULL){
          _mouse_pos_x = px;
          _mouse_pos_y = py;
        }else{
          _mouse_pos_x = px + _window_list[wid -1]._x;
          _mouse_pos_y = py + _window_list[wid -1]._y;
        }
        evt->e.pos.x = px;
        evt->e.pos.y = py;
        evt->s.type = EV_BUTUP;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
        WSGFdeviceSemUnlock(_event_sem_id);
        _wake_up_event();
      }else{
        delete evtl;
      }
      break;
    }
    case EnterNotify:{
      break;
    }
    case LeaveNotify:{
      break;
    }
    case MotionNotify:{
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int px = e.xmotion.x;
      int py = e.xmotion.y;
      int bt = e.xmotion.state;
      int wid = target_win;
      if (wid > 0){
        short wx = 0;
        short wy = 0;
        evt->s.wid = wid;
        _mouse_pos_x = px + _window_list[wid -1]._x;
        _mouse_pos_y = py + _window_list[wid -1]._y;
        evt->e.pos.x = px;
        evt->e.pos.y = py;
      }else{
        evt->s.wid = 0;
        _mouse_pos_x = px;
        _mouse_pos_y = py;
        evt->e.pos.x = px;
        evt->e.pos.y = py;
      }
      evt->s.stat = 0;
      if (bt & Button1Mask){
        evt->s.stat |= ES_BUT;
      }
      if (bt & Button3Mask){
        evt->s.stat |= ES_BUT2;
      }
      evt->e.type = EV_NULL;
      WSGFdeviceSemLock(_event_sem_id);
      _add_event(evtl);
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
      break;
    }
    case FocusIn:{
//printf("FocusIn\n");
      break;
    }
    case FocusOut:{
//printf("FocusIn\n");
      break;
    }
    case KeyPress:{
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      KeySym key;
      char buffer[1024];
      int len = XLookupString((XKeyEvent *)&e,buffer,1022,&key,(XComposeStatus*)NULL);
      WSGIappKeyboard()->setText(buffer);
      evt->s.wid = (short)key;
      evt->e.type = EV_KEYDWN;
      evt->s.stat = 0;
      if (e.xkey.state & ShiftMask){
        evt->s.stat |= 0x10;
      }
      if (e.xkey.state & LockMask){
        evt->s.stat |= 0x08;
      }
      if (e.xkey.state & ControlMask){
        evt->s.stat |= 0x80;
      }
      if (e.xkey.state & Mod1Mask){
        evt->s.stat |= 0x40;
      }
      buffer[len]=0;

      WSGFdeviceSemLock(_event_sem_id);
      _add_event(evtl);
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
 
      break;
    }
    case KeyRelease:{
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      KeySym key;
      char buffer[1024];
      int len = XLookupString((XKeyEvent *)&e,buffer,1022,&key,(XComposeStatus*)NULL);
      evt->s.wid = key;
      evt->e.type = EV_KEYUP;
      buffer[len]=0;

      WSGFdeviceSemLock(_event_sem_id);
      _add_event(evtl);
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
 
      break;
    }
    case ConfigureNotify:{
//printf("configure norify..\n");
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      evt->s.wid = target_win;
      evt->s.cmd = W_FRAM;
      evt->e.type = EV_BUTDWN;
      int x = e.xconfigure.x;
      int y = e.xconfigure.y;
      int w = e.xconfigure.width;
      int h = e.xconfigure.height;
      WSGFdeviceSemLock(_sem_id);
extern int check_wid(int wid);
      if (check_wid(target_win) == WS_NO_ERR){
        _window_list[target_win-1]._x = x;
        _window_list[target_win-1]._y = y;
        _window_list[target_win-1]._w = w;
        _window_list[target_win-1]._h = h;
//printf("configure notify x,y,w,h=%d,%d,%d,%d\n",x,y,w,h);
      }
      WSGFdeviceSemUnlock(_sem_id);

      WSGFdeviceSemLock(_event_sem_id);
      _add_event(evtl);
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
      break;
    }
    default:{
//printf("other..\n");
      break;
    }
  }
#endif
  return NULL;
}
int get_window(WindowRef window){
  int i;
  for(i=0; i<WS_MAX_WINDOW;i++){
    if (_window_list[i]._window_id != i+1){
      continue;
    }
    if (_window_list[i]._native_window == 0){
      continue;
    }
    WindowRef win = (WindowRef)_window_list[i]._native_window;
    if (win == window){
//printf("hit!\n");
      return i+1;
    }
  }
  return -1;
}
int get_window_by_control(ControlRef window){
  int i;
  for(i=0; i<WS_MAX_WINDOW;i++){
    if (_window_list[i]._window_id != i+1){
      continue;
    }
    if (_window_list[i]._native_window == 0){
      continue;
    }
    ControlRef control = (ControlRef)_window_list[i]._native_context;
//printf("i=%d _native_context=0x%x search=0x%x\n",i,control,window);
    if (control == window){
//printf("hit!\n");
      return i+1;
    }
  }
//printf("return=-1\n");
  return -1;
}
pascal OSStatus _evh_key_pressed(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_key_pressed..\n");

  EventRecord event;
  ConvertEventRefToEventRecord(ev,&event);

  WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
  WSDdeviceEvent* evt = &(evtl->_event);
  evt->s.cmd = (event.message & charCodeMask);
  evt->s.wid = (event.message & keyCodeMask >> 8);
  evt->s.stat = 0;
  if (evt->s.cmd < 0x20){
    evt->s.cmd = 0;
  }
//printf("event.message = 0x%x %d key=0x%x,%d\n",evt->s.cmd,evt->s.cmd,evt->s.wid,evt->s.wid);
  if( event.modifiers & shiftKey ) {
    evt->s.stat = 0x10;
  }
  if( event.modifiers & rightShiftKey ) {
    evt->s.stat = 0x10;
  }
  if( event.modifiers & alphaLock ) {
    evt->s.stat = 0x08;
  }
  if( event.modifiers & controlKey ) {
    evt->s.stat = 0x80;
  }
  if( event.modifiers & rightControlKey ) {
    evt->s.stat = 0x80;
  }
  if( event.modifiers & optionKey ) {
    evt->s.stat = 0x40;
  }
  if( event.modifiers & rightOptionKey ) {
    evt->s.stat = 0x40;
  }
  if (event.what == keyDown){
    evt->s.type = EV_KEYDWN;
  }else
  if (event.what == keyUp){
    evt->s.type = EV_KEYUP;
  }else{
    evt->s.type = EV_AUTKEY;
  }

  WSGFdeviceSemLock(_event_sem_id);
  _add_event(evtl);
  WSGFdeviceSemUnlock(_event_sem_id);
  _wake_up_event();
//  WSGIdevfbAppDev()->_dispatchEvent(False);
//printf("_evh_key_pressed..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_apple_event(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_apple_event..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_activated(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_activated..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_deactivated(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_deactivated..\n");
  WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
  WSDdeviceEvent* evt = &(evtl->_event);
  evt->e.type = EV_CANCEL;
  WSGFdeviceSemLock(_event_sem_id);
  _add_event(evtl);
  WSGFdeviceSemUnlock(_event_sem_id);
  _wake_up_event();
//  WSGIdevfbAppDev()->_dispatchEvent(False);
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_quit(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_quit..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_launch_notification(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_launch_notification..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_launched(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_launched..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_terminated(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_terminated..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_front_switched(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_front_switched..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_hidden(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_hidden..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_shown(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_shown..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_system_uimode_changed(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_system_uimode_changed..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_available_window_bounds_changed(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_available_window_bounds_changed..\n");
  return eventNotHandledErr;
}
pascal OSStatus _evh_app_active_window_changed(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_app_active_window_changed..\n");
  return eventNotHandledErr;
}

pascal OSStatus _evh_control_updated(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_control_updated.. started.. \n");fflush(stdout);
  ControlRef control = (ControlRef)ptr;
  int i;
  for(i=0; i<WS_MAX_WINDOW;i++){
    if (_window_list[i]._native_context == (long)control){
      mac_update_window(&_window_list[i]);
    }
  }
//printf("_evh_control_updated.. done.. \n");fflush(stdout);
  return eventNotHandledErr;
}
pascal OSStatus _evh_window_updated(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_window_updated..\n");fflush(stdout);
#if 0
  WindowRef window = (WindowRef)ptr; int i;
  for(i=0; i<WS_MAX_WINDOW;i++){
    if (_window_list[i]._native_window == (long)window){
//      BringToFront(window);
      mac_update_window(&_window_list[i]);
    }
  }
#endif
//printf("_evh_window_updated\n");
  return eventNotHandledErr;
}

pascal OSStatus _evh_window_resized(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_window_resized..\n");fflush(stdout);
  WindowRef window = (WindowRef)ptr;
  Rect r;
//  GetWindowBounds(window,kWindowStructureRgn,&r);
  GetWindowBounds(window,kWindowContentRgn,&r);

  WSDdeviceEventList* evtl =
          (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
  WSDdeviceEvent* evt = &(evtl->_event);

  int wid = get_window(window);
  if (wid > -1){

//TODO:
//    _window_list[wid -1]._x = r.left;
//    _window_list[wid -1]._y = r.top;
//    _window_list[wid -1]._w = r.right - r.left;
//    _window_list[wid -1]._h = r.bottom - r.top;

    ControlRef control = (ControlRef)_window_list[wid-1]._native_context;
    if (control != 0){
      return eventNotHandledErr;
    }
    evt->s.type = EV_RESIZE;
    evt->s.wid = wid;
    WSGFdeviceSemLock(_event_sem_id);
    _add_event(evtl);
    WSGFdeviceSemUnlock(_event_sem_id);
    _wake_up_event();
//    WSGIdevfbAppDev()->_dispatchEvent(False);
  }else{
    delete evtl;
  }
  return eventNotHandledErr;
}

pascal OSStatus _evh_mouse_pressed(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_mouse_pressed.. started..\n");fflush(stdout);
//fprintf(stderr,"_evh_mouse_pressed.. started..\n");fflush(stderr);
  EventRecord event;
  ConvertEventRefToEventRecord(ev,&event);
  WindowRef window = 0;
  short part = FindWindow( event.where, &window );

  window = (WindowRef)ptr;
  HIPoint where;
  GetEventParameter(ev,kEventParamWindowMouseLocation,typeHIPoint,NULL,
                    sizeof(HIPoint),NULL,&where);

  int px = where.x;
  int py = where.y;

  Rect r2;
  GetWindowBounds(window,kWindowStructureRgn,&r2);
  Rect r3;
  GetWindowBounds(window,kWindowContentRgn,&r3);
  long diffy = r3.top - r2.top;

  Point pos;
//  pos.h = px - r2.left;
//  pos.v = py - r2.top;
  pos.h = px;
  pos.v = py;

  ControlRef control = 0;
  short part2 = FindControl( pos, window, &control );

//printf("_evh_mouse_pressed control=0x%x\n",control);

  if (part == inDrag){
//printf("in drag....\n");
    Rect tempRect;
    GetRegionBounds( GetGrayRgn(), &tempRect );
    DragWindow( window, event.where, &tempRect );
    Rect r;
//    GetWindowBounds(window,kWindowStructureRgn,&r);
    GetWindowBounds(window,kWindowContentRgn,&r);
    long wid = get_window(window);
    if (wid > -1){
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      evt->s.wid = wid;
      evt->s.cmd = W_FRAM;
      evt->e.type = EV_BUTDWN;
      WSGFdeviceSemLock(_sem_id);
extern int check_wid(int wid);
      if (check_wid(wid) == WS_NO_ERR){
        _window_list[wid-1]._x = r.left;
        _window_list[wid-1]._y = r.top;
        _window_list[wid-1]._w = r.right - r.left;
        _window_list[wid-1]._h = r.bottom - r.top;
//printf("x,y,w,h=%d,%d,%d,%d\n",r.left,r.top,r.right,r.bottom);
      }
      WSGFdeviceSemUnlock(_sem_id);

      WSGFdeviceSemLock(_event_sem_id);
      _add_event(evtl);
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
//printf("in drag.. resized..\n");
      return eventNotHandledErr;
    }
  }else
  if (part == inGrow){
    long size = GrowWindow( window, event.where, NULL );
    if( size ) {
      Rect tempRect;
      SizeWindow(window,LoWord(size),HiWord(size),true);
      GetPortBounds( GetWindowPort( window ), &tempRect );
      InvalWindowRect( window, &tempRect );
    }
    return eventNotHandledErr;
  }else
  if (part == inGoAway){
    if( TrackGoAway( window, event.where ) ){
      long wid = get_window(window);
      if (wid > -1){
        WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
        WSDdeviceEvent* evt = &(evtl->_event);
        evt->r.wid = wid;
        evt->r.cmd = W_CLOSED;
        evt->r.type = EV_BUTDWN;
        WSGFdeviceSemLock(_event_sem_id);
        _add_event(evtl);
        WSGFdeviceSemUnlock(_event_sem_id);
        _wake_up_event();
      }
    }
  }else
  if (part == inZoomIn || part == inZoomOut){
    Boolean hit = TrackBox( window, event.where, part );
    if( hit ) {
      Rect tempRect;
      SetPort( GetWindowPort( window ) );
      EraseRect(GetWindowPortBounds(window, &tempRect));
      ZoomWindow( window, part, true );
      InvalWindowRect( window,
      GetWindowPortBounds( window, &tempRect ) );
//printf("inZoomOut.. not supported..\n");
    }
  }



  int bt;
  GetEventParameter(ev,kEventParamMouseButton,typeMouseButton,NULL,
                    sizeof(int),NULL,&bt);
  bt >>=16;

  unsigned int mod;
  GetEventParameter(ev,kEventParamKeyModifiers,typeUInt32,NULL,
                    sizeof(unsigned int),NULL,&mod);

  WSDdeviceEventList* evtl =
          (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
  WSDdeviceEvent* evt = &(evtl->_event);

  _mouse_pos_x = 0;
  _mouse_pos_y = 0;

  int wid = get_window(window);
  if (control != NULL){
    wid = get_window_by_control(control);
    if (wid < 0){
      return eventNotHandledErr;
    }
    Rect r;
    GetControlBounds(control,&r);
    px -= r.left;
    py -= (r.top + diffy);
//printf("pressed. mouse diffx,y=%d,%d res=%d,%d+++++++++++++ diffy=%d\n",r.left,r.top,px,py,diffy);fflush(stdout);
    _mouse_pos_x = r.left + r2.left;
    _mouse_pos_y = r.top + r2.top + diffy;
  }
  if (wid > -1){
    short wx = 0;
    short wy = 0;
    evt->s.stat = 0;
    if (bt == 1){
      if (mod & 0x1000){
        _mouse_status |= 4;
      }else{
        _mouse_status |= 1;
      }
    }
    if (bt == 3){
      _mouse_status |= 2;
    }
    if (bt == 2){
      _mouse_status |= 4;
    }
    if (_mouse_status & 1){
      evt->s.stat |= ES_BUT;
    }
    if (_mouse_status & 4){
      evt->s.stat |= ES_BUT2;
    }
//printf("evt->s.stat=0x%x\n",evt->s.stat);
    if (control != NULL){
      _mouse_pos_x += px;
      _mouse_pos_y += py;
      evt->e.pos.y = py;
    }else{
      _mouse_pos_x += (px + _window_list[wid -1]._x);
      _mouse_pos_y += (py + _window_list[wid -1]._y - _window_list[wid-1]._diff_y);
      evt->e.pos.y = py - _window_list[wid-1]._diff_y;
    }
//printf("mouse_pos=%d,%d\n",_mouse_pos_x,_mouse_pos_y);

    evt->e.pos.x = px;
//printf("press x,y=%d,%d p=0x%x bt=%d\n",evt->e.pos.x,evt->e.pos.y,evt->s.stat,bt);
    evt->s.type = EV_BUTDWN;
    evt->s.cmd = W_WORK;
    evt->s.wid = wid;
    WSGFdeviceSemLock(_event_sem_id);
    _add_event(evtl);
    WSGFdeviceSemUnlock(_event_sem_id);
    _wake_up_event();
//    WSGIdevfbAppDev()->_dispatchEvent(False);
  }else{
    delete evtl;
  }
//fprintf(stderr,"_evh_mouse_pressed.. done.. thr=0x%x\n",pthread_self());fflush(stderr);
//printf("_evh_mouse_pressed.. done.. thr=0x%x\n",pthread_self());fflush(stdout);
  return eventNotHandledErr;
}
pascal OSStatus _evh_mouse_moved(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_mouse_moved..\n");
  WindowRef window = (WindowRef)ptr;
  HIPoint where;
  GetEventParameter(ev,kEventParamWindowMouseLocation,typeHIPoint,NULL,
                    sizeof(HIPoint),NULL,&where);

  unsigned int mod;
  GetEventParameter(ev,kEventParamKeyModifiers,typeUInt32,NULL,
                    sizeof(unsigned int),NULL,&mod);

  WSDdeviceEventList* evtl =
          (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
  WSDdeviceEvent* evt = &(evtl->_event);

  EventRecord event;
  int px = where.x;
  int py = where.y;

  ConvertEventRefToEventRecord(ev,&event);
  Rect r2;
  GetWindowBounds(window,kWindowStructureRgn,&r2);
  Rect r3;
  GetWindowBounds(window,kWindowContentRgn,&r3);
  long diffy = r3.top - r2.top;

  Point pos;
//  pos.h = px - r2.left;
//  pos.v = py - r2.top;
  pos.h = px;
  pos.v = py;

  ControlRef control = 0;
  short part2 = FindControl( pos, window, &control );

  _mouse_pos_x = 0;
  _mouse_pos_y = 0;

  int wid = get_window(window);
  if (control != NULL){
    wid = get_window_by_control(control);
//printf("moved.. control=0x%x wid=0x%x\n",control,wid);fflush(stdout);
    if (wid < 0){
      return eventNotHandledErr;
    }
    Rect r;
    GetControlBounds(control,&r);
    px -= r.left;
    py -= (r.top + diffy);
//printf("moved. mouse diffx,y=%d,%d res=%d,%d+++++++++++++ diffy=%d\n",r.left,r.top,px,py,diffy);fflush(stdout);
    _mouse_pos_x = r.left + r2.left;
    _mouse_pos_y = r.top + r2.top + diffy;
  }
  if (wid > -1){
    short wx = 0;
    short wy = 0;
    evt->s.stat = 0;
    evt->s.stat = 0;
    if (_mouse_status & 1){
      evt->s.stat |= ES_BUT;
    }
    if (_mouse_status & 4){
      evt->s.stat |= ES_BUT2;
    }
//printf("evt->s.stat=0x%x\n",evt->s.stat);

    if (control != NULL){
      _mouse_pos_x += px;
      _mouse_pos_y += py;
      evt->e.pos.y = py;
    }else{
      _mouse_pos_x += (px + _window_list[wid -1]._x);
      _mouse_pos_y += (py + _window_list[wid -1]._y - _window_list[wid-1]._diff_y);
      evt->e.pos.y = py - _window_list[wid-1]._diff_y;
    }
    evt->e.pos.x = px;
    evt->e.type = EV_NULL;
//    evt->s.cmd = W_WORK;
    evt->s.wid = wid;
    WSGFdeviceSemLock(_event_sem_id);
    _add_event(evtl);
    WSGFdeviceSemUnlock(_event_sem_id);
    _wake_up_event();
//    WSGIdevfbAppDev()->_dispatchEvent(False);
  }else{
    delete evtl;
  }
  return eventNotHandledErr;
}
pascal OSStatus _evh_mouse_dragged(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_mouse_dragged..\n");
  return _evh_mouse_moved(nh,ev,ptr);
}
pascal OSStatus _evh_mouse_released(EventHandlerCallRef nh,EventRef ev,void* ptr){
//printf("_evh_mouse_released.. started\n");fflush(stdout);
  WindowRef window = (WindowRef)ptr;
  HIPoint where;
  GetEventParameter(ev,kEventParamWindowMouseLocation,typeHIPoint,NULL,
                    sizeof(HIPoint),NULL,&where);
  int bt;
  GetEventParameter(ev,kEventParamMouseButton,typeMouseButton,NULL,
                    sizeof(int),NULL,&bt);
  bt >>=16;

  unsigned int mod;
  GetEventParameter(ev,kEventParamKeyModifiers,typeUInt32,NULL,
                    sizeof(unsigned int),NULL,&mod);

  WSDdeviceEventList* evtl =
          (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
  WSDdeviceEvent* evt = &(evtl->_event);
  EventRecord event;
  int px = where.x;
  int py = where.y;

  ConvertEventRefToEventRecord(ev,&event);

  Rect r2;
  GetWindowBounds(window,kWindowStructureRgn,&r2);
  Rect r3;
  GetWindowBounds(window,kWindowContentRgn,&r3);
  long diffy = r3.top - r2.top;

  Point pos;
//  pos.h = px - r2.left;
//  pos.v = py - r2.top;
  pos.h = px;
  pos.v = py;
  ControlRef control = 0;
  short part2 = FindControl( pos, window, &control );

  _mouse_pos_x = 0;
  _mouse_pos_y = 0;

  int wid = get_window(window);
  if (control != NULL){
    wid = get_window_by_control(control);
    if (wid < 0){
      return eventNotHandledErr;
    }
    Rect r;
    GetControlBounds(control,&r);
    px -= r.left;
    py -= r.top;
    py -= (r.top - diffy);
//printf("released. mouse diffx,y=%d,%d res=%d,%d+++++++++++++ diffy=%d\n",r.left,r.top,px,py,diffy);fflush(stdout);
    _mouse_pos_x = r.left + r2.left;
    _mouse_pos_y = r.top + r2.top;
  }
  if (wid > -1){
//printf("here...\n");
    short wx = 0;
    short wy = 0;
    evt->s.stat = 0;
    if (bt == 1){
      if (mod & 0x1000){
        _mouse_status &= ~4;
      }else{
        _mouse_status &= ~1;
      }
    }
    if (bt == 3){
      _mouse_status &= ~2;
    }
    if (bt == 2){
      _mouse_status &= ~4;
    }
    if (_mouse_status & 1){
      evt->s.stat |= ES_BUT;
    }
    if (_mouse_status & 4){
      evt->s.stat |= ES_BUT2;
    }
//printf("evt->s.stat=0x%x\n",evt->s.stat);
    if (control != NULL){
      _mouse_pos_x += px;
      _mouse_pos_y += py;
      evt->e.pos.y = py;
    }else{
      _mouse_pos_x += (px + _window_list[wid -1]._x);
      _mouse_pos_y += (py + _window_list[wid -1]._y - _window_list[wid-1]._diff_y);
      evt->e.pos.y = py - _window_list[wid-1]._diff_y;
    }
    evt->e.pos.x = px;
    evt->s.type = EV_BUTUP;
    evt->s.cmd = W_WORK;
    evt->s.wid = wid;
    WSGFdeviceSemLock(_event_sem_id);
    _add_event(evtl);
    WSGFdeviceSemUnlock(_event_sem_id);
    _wake_up_event();
//    WSGIdevfbAppDev()->_dispatchEvent(False);
  }else{
    delete evtl;
  }
//printf("_evh_mouse_released.. done\n");fflush(stdout);
  return eventNotHandledErr;
}
void mac_create_window(WSDdeviceWindow* win){
  Rect windowRect;
  if (win->_y < 22){
    win->_y = 22;
  }
  long x = win->_x;
  long y = win->_y;
  WSCulong w = win->_w;
  WSCulong h = win->_h;
  win->_diff_y = 0;

  SetRect(&windowRect,x,y,x+w,y+h);
  WindowRef _window = 0;
  ControlRef _control = 0;
  if (WSGIappDev()->getRebaseHandle() != 0){
    _control = (ControlRef)WSGIappDev()->getRebaseHandle();
    WSGIappDev()->setRebaseHandle(0);
  }

  long _win_type =6;
//printf("size=%d,%d,%d,%d attr=0x%x\n",win->_x,win->_y,win->_w,win->_h,win->_attr);fflush(stdout);
  win->_native_window = 0;
  win->_native_context = 0;
  win->_native_image = 0;
  win->_top_float = 0;
  OSErr error;
  EventTypeSpec eventTypes[20];

  RGBColor col;
  long color = win->_bg_color;
  col.red = ((color & 0xff0000) >> 8);
  col.green = (color & 0xff00);
  col.blue = ((color & 0xff) << 8);
//printf("control=0x%x ------------   !!!!!!!!!!!!!!!!!!\n",_control);fflush(stdout);
  if (_control != NULL){
//printf("------------   !!!!!!!!!!!!!!!!!!\n");fflush(stdout);
    _window = GetControlOwner(_control);
//    Rect r;
//    GetControlBounds(_control,&r);
//
//    ControlRef control2 = NewControl(_window,&r,"\p",false,0,0,0,kControlUserPaneProc,NULL);
//    EmbedControl(control2,_control);
//    HIViewAddSubview(_control,control2);
//    ShowControl(control2);
//    _control = control2;

    eventTypes[0].eventClass = kEventClassControl;
    eventTypes[0].eventKind = kEventControlDraw;
    error = InstallEventHandler(GetControlEventTarget(_control),
                              NewEventHandlerUPP(_evh_control_updated),
                              1,eventTypes, (void*)_control,NULL);

  }else{
    if (win->_attr & WA_NOFRAME){
      error = CreateNewWindow(kPlainWindowClass,
             kWindowNoActivatesAttribute | kWindowDoesNotCycleAttribute | kWindowNoShadowAttribute,
             &windowRect,&_window);
      SetWindowContentColor(_window,&col);
      SetWindowKind(_window,dialogKind);
//printf("create window=0x%x\n",_window);
//    win->_native_image = NewDialog(NULL,&windowRect,"",false,kWindowPlainDialogProc,-1,false,
//                            NULL,0);
//    _window = GetDialogWindow(win->_native_image);
      WindowRef acf = ActiveNonFloatingWindow();

      ShowWindow(_window); 
      ActivateWindow(_window,false);
      ActivateWindow(acf,true);
      BringToFront(_window);
      win->_top_float = 1;
    }else{
      error = CreateNewWindow(_win_type,kWindowStandardDocumentAttributes,
                                &windowRect,&_window);
      SetWindowContentColor(_window,&col);
      ShowWindow(_window); 
      BringToFront(_window);
      ActivateWindow(_window,true);
    }
    GetWindowBounds(_window,kWindowStructureRgn,&windowRect);
    win->_diff_y = y - windowRect.top;
    if (win->_diff_y > 0 && win->_y < win->_diff_y*2){
      MoveWindow(_window,win->_x,win->_diff_y*2,true);
    }
  }

  eventTypes[0].eventClass = kEventClassMouse;
  eventTypes[0].eventKind = kEventMouseDown;
  error = InstallEventHandler(GetWindowEventTarget(_window),
                              NewEventHandlerUPP(_evh_mouse_pressed),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassMouse;
  eventTypes[0].eventKind = kEventMouseUp;
  error = InstallEventHandler(GetWindowEventTarget(_window),
                              NewEventHandlerUPP(_evh_mouse_released),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassMouse;
  eventTypes[0].eventKind = kEventMouseMoved;
  error = InstallEventHandler(GetWindowEventTarget(_window),
                              NewEventHandlerUPP(_evh_mouse_moved),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassMouse;
  eventTypes[0].eventKind = kEventMouseDragged;
  error = InstallEventHandler(GetWindowEventTarget(_window),
                              NewEventHandlerUPP(_evh_mouse_dragged),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassWindow;
  eventTypes[0].eventKind = kEventWindowUpdate;
  eventTypes[1].eventClass = kEventClassWindow;
  eventTypes[1].eventKind = kEventWindowDrawContent;
  error = InstallEventHandler(GetWindowEventTarget(_window),
                              NewEventHandlerUPP(_evh_window_updated),
                              2,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassWindow;
  eventTypes[0].eventKind = kEventWindowResizeCompleted;
  error = InstallEventHandler(GetWindowEventTarget(_window),
                              NewEventHandlerUPP(_evh_window_resized),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppActivated;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_activated),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppDeactivated;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_deactivated),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppQuit;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_quit),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppLaunchNotification;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_launch_notification),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppLaunched;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_launched),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppTerminated;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_terminated),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppFrontSwitched;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_front_switched),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppHidden;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_hidden),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppShown;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_shown),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppSystemUIModeChanged;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_system_uimode_changed),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppAvailableWindowBoundsChanged;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_available_window_bounds_changed),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassApplication;
  eventTypes[0].eventKind = kEventAppActiveWindowChanged;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_app_active_window_changed),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassAppleEvent;
  eventTypes[0].eventKind = kEventAppleEvent;
  error = InstallEventHandler(GetApplicationEventTarget(),
                              NewEventHandlerUPP(_evh_apple_event),
                              1,eventTypes, (void*)_window,NULL);

  eventTypes[0].eventClass = kEventClassKeyboard;
  eventTypes[0].eventKind = kEventRawKeyDown;
  eventTypes[1].eventClass = kEventClassKeyboard;
  eventTypes[1].eventKind = kEventRawKeyRepeat;
  eventTypes[2].eventClass = kEventClassKeyboard;
  eventTypes[2].eventKind = kEventRawKeyUp;
  error = InstallEventHandler(GetWindowEventTarget(_window),
                              NewEventHandlerUPP(_evh_key_pressed),
                              3,eventTypes, (void*)_window,NULL);

  win->_native_window = (long)_window;
  win->_native_context = (long)_control;
  WSDdeviceGC* gid = &_gc_list[win->_gc-1];

  long buf_size = w * h * 4;
  unsigned char* buffer = (unsigned char*)malloc(buf_size);

  memset(buffer,0xff,buf_size);
  gid->_x = 0;
  gid->_y = 0;
  gid->_buf = buffer;
  gid->_row_bytes = w * 4;
}

void mac_update_window(WSDdeviceWindow* win){
//printf("mac_update_window.. \n");fflush(stdout);
  WindowRef window = (WindowRef)win->_native_window;
  ControlRef control =(ControlRef)win->_native_context;
  long gid = win->_gc -1;
  unsigned char* buf = _gc_list[gid]._buf;
  int x = _gc_list[gid]._x;
  int y = _gc_list[gid]._y;
  unsigned int w = _gc_list[gid]._w;
  unsigned int h = _gc_list[gid]._h;
  unsigned int d = _gc_list[gid]._depth;


#if 0
  RGBColor col;
  int i,j;
  int p =0;
  for(j=0; j<h; j++){
    for(i=0; i<w; i++){
      p++;
      col.red = (buf[p++] << 8);
      col.green = (buf[p++] << 8);
      col.blue = (buf[p++] << 8);
      SetCPixel(i,j,&col);
    }
  }
#endif
//printf("update x,y,w,h=%d,%d,%d,%d\n",x,y,w,h);
  Rect rect;
  SetRect(&rect,x,y,x+w,y+h);
  GWorldPtr graf;
  NewGWorldFromPtr(&graf,k32ARGBPixelFormat,&rect,0,0,0,buf,w*4);
  SetPort(GetWindowPort(window));
  if (control == NULL){
    CopyBits(GetPortBitMapForCopyBits(graf),GetPortBitMapForCopyBits(GetWindowPort(window)),&rect,&rect,srcCopy,0);
  }else{
    RgnHandle saveRgn = NewRgn();
    GetClip(saveRgn);
    Rect controlRect;
    GetControlBounds(control,&controlRect);
//    SInt32 vsize = GetControlViewSize(control);
//printf("vsize=0x%x\n",vsize);fflush(stdout);
    long cw = controlRect.right - controlRect.left;
    long ch = controlRect.bottom - controlRect.top;
    controlRect.right = controlRect.left + w;
    controlRect.bottom = controlRect.top + h;
    RgnHandle rgn = NewRgn();
    GetControlRegion(control,kControlStructureMetaPart,rgn); 
    ControlRef parent;
    GetSuperControl(control,&parent);
    if (parent != 0){
      RgnHandle rgn2 = NewRgn();
      GetControlRegion(parent,kControlStructureMetaPart,rgn2); 
      SectRgn(rgn,rgn2,rgn);
      DisposeRgn(rgn2);
    }
//    GetControlRegion(control,kControlIndicatorPart,rgn); 
//    GetControlRegion(control,kControlStructureMetaPart,rgn); 
//    GetControlRegion(control,kControlPicturePart,rgn); 
//    HIViewConvertRegion(rgn,NULL,control);
//    HIViewConvertRegion(rgn,control,NULL);

    SetClip(rgn);
    if (cw != w || ch != h){
//printf("size control w,h=%d,%d ++++++++++++++++++++++++++++++++++\n",w,h);fflush(stdout);
      SizeControl(control,w,h);
    }
//    SetClip(0);
//printf("CopyBits!!!! w,h=%d,%d\n",w,h);fflush(stdout);
    RGBColor col;
    col.red = 0xffff;
    col.green = 0xffff;
    col.blue = 0xffff;
    RGBBackColor(&col);
//    RGBForeColor(&col);
//    Rect r;
//    SetRect(&r,0,0,0x7fff,0x7fff);
//    PaintRect(&r);
    CopyBits(GetPortBitMapForCopyBits(graf),GetPortBitMapForCopyBits(GetWindowPort(window)),&rect,&controlRect,srcCopy,rgn);
//    CopyBits(GetPortBitMapForCopyBits(graf),GetPortBitMapForCopyBits(GetWindowPort(window)),&rect,&controlRect,srcCopy,0);
    DisposeRgn(rgn);
    SetClip(saveRgn);
    DisposeRgn(saveRgn);
    HIWindowFlush(window);
  }
  DisposeGWorld(graf);
//  BeginUpdate(window);
//  EndUpdate(window);
}
void mac_update_geom_window(WSDdeviceWindow* win){
  WindowRef window = (WindowRef)win->_native_window;
  ControlRef control = (ControlRef)win->_native_context;
  if (control != 0){
    return;
  }
  unsigned char* buf = _gc_list[win->_gc -1]._buf;
  int x = win->_x;
  int y = win->_y;
  unsigned int w = win->_w;
  unsigned int h = win->_h;
  Rect tr;
//  SetRect(&tr,x,y,x+w,y+h);
  GetWindowBounds(window,kWindowContentRgn,&tr);
//printf("mac_update_geom_window.. win=0x%x %d,%d,%d,%d\n",window,x,y,w,h);
  if (x != tr.left || y != tr.top){
    MoveWindow(win->_native_window,x,y,true);
  }
  if (w != tr.right - tr.left || h != tr.bottom - tr.top){
    SizeWindow(win->_native_window,w,h,true);
  }
}

void mac_destroy_window(WSDdeviceWindow* win){
  WindowRef window = (WindowRef)win->_native_window;
  ControlRef control = (ControlRef)win->_native_context;
  if (control == NULL){
    DisposeWindow(window);
    ReleaseWindow(window);
  }

  win->_native_window = 0;
  win->_native_context = 0;
}

char* cvt_table[]={
"\xe3\x81\x8b\xe3\x82\x99","\xe3\x81\x8c", //GA
"\xe3\x81\x8d\xe3\x82\x99","\xe3\x81\x8e", //GI
"\xe3\x81\x8f\xe3\x82\x99","\xe3\x81\x90", //GU
"\xe3\x81\x91\xe3\x82\x99","\xe3\x81\x92", //GE
"\xe3\x81\x93\xe3\x82\x99","\xe3\x81\x94", //GO
"\xe3\x81\x95\xe3\x82\x99","\xe3\x81\x96", //ZA
"\xe3\x81\x97\xe3\x82\x99","\xe3\x81\x98", //ZI
"\xe3\x81\x99\xe3\x82\x99","\xe3\x81\x9a", //ZU
"\xe3\x81\x9b\xe3\x82\x99","\xe3\x81\x9c", //ZE
"\xe3\x81\x9d\xe3\x82\x99","\xe3\x81\x9e", //ZO
"\xe3\x81\x9f\xe3\x82\x99","\xe3\x81\xa0", //DA
"\xe3\x81\xa1\xe3\x82\x99","\xe3\x81\xa2", //DI
"\xe3\x81\xa4\xe3\x82\x99","\xe3\x81\xa5", //DU
"\xe3\x81\xa6\xe3\x82\x99","\xe3\x81\xa7", //DE
"\xe3\x81\xa8\xe3\x82\x99","\xe3\x81\xa9", //DO
"\xe3\x81\xaf\xe3\x82\x99","\xe3\x81\xb0", //BA
"\xe3\x81\xaf\xe3\x82\x9a","\xe3\x81\xb1", //PA
"\xe3\x81\xb2\xe3\x82\x99","\xe3\x81\xb3", //BI
"\xe3\x81\xb2\xe3\x82\x9a","\xe3\x81\xb4", //PI
"\xe3\x81\xb5\xe3\x82\x99","\xe3\x81\xb6", //BU
"\xe3\x81\xb5\xe3\x82\x9a","\xe3\x81\xb7", //PU
"\xe3\x81\xb8\xe3\x82\x99","\xe3\x81\xb9", //BE
"\xe3\x81\xb8\xe3\x82\x9a","\xe3\x81\xba", //PE
"\xe3\x81\xbb\xe3\x82\x99","\xe3\x81\xbc", //BO
"\xe3\x81\xbb\xe3\x82\x9a","\xe3\x81\xbd", //PO

"\xe3\x82\xab\xe3\x82\x99","\xe3\x82\xac", //GA
"\xe3\x82\xad\xe3\x82\x99","\xe3\x82\xae", //GI
"\xe3\x82\xaf\xe3\x82\x99","\xe3\x82\xb0", //GU
"\xe3\x82\xb1\xe3\x82\x99","\xe3\x82\xb2", //GE
"\xe3\x82\xb3\xe3\x82\x99","\xe3\x82\xb4", //GO
"\xe3\x82\xb5\xe3\x82\x99","\xe3\x82\xb6", //ZA
"\xe3\x82\xb7\xe3\x82\x99","\xe3\x82\xb8", //ZI
"\xe3\x82\xb9\xe3\x82\x99","\xe3\x82\xba", //ZU
"\xe3\x82\xbb\xe3\x82\x99","\xe3\x82\xbc", //ZE
"\xe3\x82\xbd\xe3\x82\x99","\xe3\x82\xbe", //ZO
"\xe3\x82\xbf\xe3\x82\x99","\xe3\x83\x80", //DA
"\xe3\x83\x81\xe3\x82\x99","\xe3\x83\x82", //DI
"\xe3\x83\x84\xe3\x82\x99","\xe3\x83\xa5", //DU
"\xe3\x83\x86\xe3\x82\x99","\xe3\x83\x87", //DE
"\xe3\x83\x88\xe3\x82\x99","\xe3\x83\x89", //DO
"\xe3\x83\x8f\xe3\x82\x99","\xe3\x83\x90", //BA
"\xe3\x83\x8f\xe3\x82\x9a","\xe3\x83\x91", //PA
"\xe3\x83\x92\xe3\x82\x99","\xe3\x83\x93", //BI
"\xe3\x83\x92\xe3\x82\x9a","\xe3\x83\x94", //PI
"\xe3\x83\x95\xe3\x82\x99","\xe3\x83\x96", //BU
"\xe3\x83\x95\xe3\x82\x9a","\xe3\x83\x97", //PU
"\xe3\x83\x98\xe3\x82\x99","\xe3\x83\x99", //BE
"\xe3\x83\x98\xe3\x82\x9a","\xe3\x83\x9a", //PE
"\xe3\x83\x9b\xe3\x82\x99","\xe3\x83\x9c", //BO
"\xe3\x83\x9b\xe3\x82\x9a","\xe3\x83\x9d", //PO
NULL,NULL,
};

#define UTF8_PREFIX 0xe3
#define UTF8_M_S_T1_FROM 0x80
#define UTF8_M_S_T1_TO   0x84
#define UTF8_M_S_T2_FROM 0x7f
#define UTF8_M_S_T2_TO   0xc0

#define UTF8_S_M_T1_FROM 0x80
#define UTF8_S_M_T1_TO   0x84
#define UTF8_S_M_T2_FROM 0x7f
#define UTF8_S_M_T2_TO   0xc0

char* macutf8_to_utf8(char* src){
  if (src == NULL){
    return 0;
  }
//printf("macutf8_to_utf8 #%s#\n",src);
  long slen = strlen(src)+1;
  char* dest = new char[slen];

  long sptr = 0;
  long dptr = 0;
  while(1){
    if (src[sptr] == 0){
      dest[dptr] = 0;
      return dest;
    }
    if ((unsigned char)src[sptr] == UTF8_PREFIX){
      if ((unsigned char)src[sptr+1] > UTF8_M_S_T1_FROM &&
          (unsigned char)src[sptr+1] < UTF8_M_S_T1_TO){
        if ((unsigned char)src[sptr+2] > UTF8_M_S_T2_FROM &&
            (unsigned char)src[sptr+2] < UTF8_M_S_T2_TO){
          long tblptr = 0;
          long converted = 0;
          while(1){
            if (cvt_table[tblptr*2] == NULL){
              break;
            }
            if (!strncmp(&src[sptr],
                         cvt_table[tblptr*2],
                         strlen(cvt_table[tblptr*2]))){
              converted = 1;
              strcpy(&dest[dptr],cvt_table[tblptr*2+1]);
//printf("macutf8_to_utf8 converted!! #%s#\n",dest);
              sptr += strlen(cvt_table[tblptr*2]);
              dptr += strlen(cvt_table[tblptr*2+1]);
              break;
            }
            tblptr++;
          }
          if(converted == 1){
            continue;
          }
        }
      }
    }
    dest[dptr] = src[sptr];
    sptr++;
    dptr++;
  }
  return dest;
}

char* utf8_to_macutf8(char* src){
  if (src == NULL){
    return 0;
  }
  long slen = strlen(src)+1;
  char* dest = new char[slen*2];

  long sptr = 0;
  long dptr = 0;
  while(1){
    if (src[sptr] == 0){
      dest[dptr] = 0;
      return dest;
    }
    if ((unsigned char)src[sptr] == UTF8_PREFIX){
      if ((unsigned char)src[sptr+1] > UTF8_S_M_T1_FROM &&
          (unsigned char)src[sptr+1] < UTF8_S_M_T1_TO){
        if ((unsigned char)src[sptr+2] > UTF8_S_M_T2_FROM &&
            (unsigned char)src[sptr+2] < UTF8_S_M_T2_TO){
          long tblptr = 0;
          long converted = 0;
          while(1){
            if (cvt_table[tblptr*2+1] == NULL){
              break;
            }
            if (!strncmp(&src[sptr],
                         cvt_table[tblptr*2+1],
                         strlen(cvt_table[tblptr*2+1]))){
              converted = 1;
              strcpy(&dest[dptr],cvt_table[tblptr*2]);
              sptr += strlen(cvt_table[tblptr*2+1]);
              dptr += strlen(cvt_table[tblptr*2]);
              break;
            }
            tblptr++;
          }
          if(converted == 1){
            continue;
          }
        }
      }
    }
    dest[dptr] = src[sptr];
    sptr++;
    dptr++;
  }
  return dest;
}

