//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <devfb/devfb.h>
#include <WScom.h>
#include <fbconfig.h>

#ifndef NO_WSDTHREAD
#include <WStcpcom.h>
#include <devfb/WSDdevfbThread.h>
#include <devfb/WSDdevfbAppDev.h>
#include <stdio.h>
#include <WSClocaleSet.h>

WSMFclassInit(WSDdevfbThread,WSDthread);

WSDthread* _devfb_th_chandler(){
  return new WSDdevfbThread;
}

void WSGFinitializeUnixThread(){
    WSDthread::setCreateInstanceHandler((void*)_devfb_th_chandler);
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _devfb_th_init {
  public: _devfb_th_init(){
    WSGFinitializeUnixThread();
  };
};
_devfb_th_init  _devfb_th_init_execute;
#endif

WSDdevfbThread::WSDdevfbThread(){
  _mutex = cre_sem(1,SEM_EXCL | DELEXIT);
  _id = 0;
}

WSDdevfbThread::~WSDdevfbThread(){
  if (_id != 0){
    terminateThread();
  }
  if (_mutex != 0){
    del_sem(_mutex);
  }
}

long WSDdevfbThread::createThread(void* data){
#ifndef NO_THREAD
  wai_sem(_mutex,T_FOREVER);
  if (_proc == 0){
    sig_sem(_mutex);
    return WS_ERR;
  }
  if (_id != 0){
    sig_sem(_mutex);
    return WS_ERR;
  }
  _ptr = data;
  int ret = cre_tsk(_thread_start_handler,-1,(int)this);
  if (ret < 0){
dbprintf("Error. WSDdevfbPrivateTimer can not create thread...\n");
WSMFtrace("Error. WSDdevfbPrivateTimer can not create thread...\n");
    sig_sem(_mutex);
    return WS_ERR;
  }
  _id = ret;
  sig_sem(_mutex);
  return WS_NO_ERR;
#else
  return WS_ERR;
#endif
}

void WSDdevfbThread::_thread_start_handler(W ptr){
#ifndef NO_THREAD
  WSDdevfbThread* _this = (WSDdevfbThread*)ptr;
  void* ret = NULL;
  if (_this->_proc != NULL){
    ret = _this->_proc(_this,_this->_ptr);
  }
  wai_sem(_this->_mutex,T_FOREVER);
  _this->_id = 0;
  sig_sem(_this->_mutex);
  ext_tsk();
#endif
  return;
}

long WSDdevfbThread::detachThread(){
#if 0
  if (_id != 0){
    int ret = pthread_detach(_id);
    if (ret == 0){
      return WS_NO_ERR;
    }
  }
  return WS_ERR;
#endif
  return WS_NO_ERR;
}
long WSDdevfbThread::terminateThread(){
#ifndef NO_THREAD
  if (_id == 0){
    return WS_ERR;  
  }
  wai_sem(_mutex,T_FOREVER);
  ter_tsk(_id);
  _id = 0;
  sig_sem(_mutex);
  return WS_NO_ERR;  
#else
  return WS_ERR;
#endif
}
long WSDdevfbThread::joinThread(void** retval){
  *retval = (void*)0;
  return WS_ERR;
}
long WSDdevfbThread::getStatus(){
  if (_id == 0){
    return WS_THREAD_STOPPED;
  }
  return WS_THREAD_RUNNING;
}
long WSDdevfbThread::execCallback(void* data){
//  _callback_data = data;

  W tid = get_tid();
  MESSAGE* msg;
  char buffer[128];
  msg = (MESSAGE*)buffer;
  msg->msg_type = MS_TYPE4;
  msg->msg_size = sizeof(W)*3;
  WSDdevfbThread* ptr = this;

  memcpy(msg->msg_body.ANYMSG.msg_str,&ptr,sizeof(W));
  memcpy(&(msg->msg_body.ANYMSG.msg_str[sizeof(W)]),&tid,sizeof(W));
  memcpy(&(msg->msg_body.ANYMSG.msg_str[sizeof(W)*2]),&data,sizeof(void*));
  return snd_msg(0,msg,WAIT);
}
#endif
